# fatcat-openapi-client
Fatcat is a scalable, versioned, API-oriented catalog of bibliographic entities and file metadata. 

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.5.0
- Package version: 0.5.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://fatcat.wiki](https://fatcat.wiki)

## Requirements.

Python 3.5+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install fatcat-openapi-client
```
(you may need to run `pip` with root permission: `sudo pip install fatcat-openapi-client`)

Then import the package:
```python
import fatcat_openapi_client 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import fatcat_openapi_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import fatcat_openapi_client
from fatcat_openapi_client.rest import ApiException
from pprint import pprint

configuration = fatcat_openapi_client.Configuration()
# Configure API key authorization: Bearer
configuration.api_key['Authorization'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Authorization'] = 'Bearer'

# Defining host is optional and default to https://api.fatcat.wiki/v0
configuration.host = "https://api.fatcat.wiki/v0"
# Create an instance of the API class
api_instance = fatcat_openapi_client.DefaultApi(fatcat_openapi_client.ApiClient(configuration))
editgroup_id = 'editgroup_id_example' # str | base32-encoded unique identifier

try:
    api_response = api_instance.accept_editgroup(editgroup_id)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling DefaultApi->accept_editgroup: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://api.fatcat.wiki/v0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**accept_editgroup**](docs/DefaultApi.md#accept_editgroup) | **POST** /editgroup/{editgroup_id}/accept | 
*DefaultApi* | [**auth_check**](docs/DefaultApi.md#auth_check) | **GET** /auth/check | 
*DefaultApi* | [**auth_oidc**](docs/DefaultApi.md#auth_oidc) | **POST** /auth/oidc | 
*DefaultApi* | [**create_auth_token**](docs/DefaultApi.md#create_auth_token) | **POST** /auth/token/{editor_id} | 
*DefaultApi* | [**create_container**](docs/DefaultApi.md#create_container) | **POST** /editgroup/{editgroup_id}/container | 
*DefaultApi* | [**create_container_auto_batch**](docs/DefaultApi.md#create_container_auto_batch) | **POST** /editgroup/auto/container/batch | 
*DefaultApi* | [**create_creator**](docs/DefaultApi.md#create_creator) | **POST** /editgroup/{editgroup_id}/creator | 
*DefaultApi* | [**create_creator_auto_batch**](docs/DefaultApi.md#create_creator_auto_batch) | **POST** /editgroup/auto/creator/batch | 
*DefaultApi* | [**create_editgroup**](docs/DefaultApi.md#create_editgroup) | **POST** /editgroup | 
*DefaultApi* | [**create_editgroup_annotation**](docs/DefaultApi.md#create_editgroup_annotation) | **POST** /editgroup/{editgroup_id}/annotation | 
*DefaultApi* | [**create_file**](docs/DefaultApi.md#create_file) | **POST** /editgroup/{editgroup_id}/file | 
*DefaultApi* | [**create_file_auto_batch**](docs/DefaultApi.md#create_file_auto_batch) | **POST** /editgroup/auto/file/batch | 
*DefaultApi* | [**create_fileset**](docs/DefaultApi.md#create_fileset) | **POST** /editgroup/{editgroup_id}/fileset | 
*DefaultApi* | [**create_fileset_auto_batch**](docs/DefaultApi.md#create_fileset_auto_batch) | **POST** /editgroup/auto/fileset/batch | 
*DefaultApi* | [**create_release**](docs/DefaultApi.md#create_release) | **POST** /editgroup/{editgroup_id}/release | 
*DefaultApi* | [**create_release_auto_batch**](docs/DefaultApi.md#create_release_auto_batch) | **POST** /editgroup/auto/release/batch | 
*DefaultApi* | [**create_webcapture**](docs/DefaultApi.md#create_webcapture) | **POST** /editgroup/{editgroup_id}/webcapture | 
*DefaultApi* | [**create_webcapture_auto_batch**](docs/DefaultApi.md#create_webcapture_auto_batch) | **POST** /editgroup/auto/webcapture/batch | 
*DefaultApi* | [**create_work**](docs/DefaultApi.md#create_work) | **POST** /editgroup/{editgroup_id}/work | 
*DefaultApi* | [**create_work_auto_batch**](docs/DefaultApi.md#create_work_auto_batch) | **POST** /editgroup/auto/work/batch | 
*DefaultApi* | [**delete_container**](docs/DefaultApi.md#delete_container) | **DELETE** /editgroup/{editgroup_id}/container/{ident} | 
*DefaultApi* | [**delete_container_edit**](docs/DefaultApi.md#delete_container_edit) | **DELETE** /editgroup/{editgroup_id}/container/edit/{edit_id} | 
*DefaultApi* | [**delete_creator**](docs/DefaultApi.md#delete_creator) | **DELETE** /editgroup/{editgroup_id}/creator/{ident} | 
*DefaultApi* | [**delete_creator_edit**](docs/DefaultApi.md#delete_creator_edit) | **DELETE** /editgroup/{editgroup_id}/creator/edit/{edit_id} | 
*DefaultApi* | [**delete_file**](docs/DefaultApi.md#delete_file) | **DELETE** /editgroup/{editgroup_id}/file/{ident} | 
*DefaultApi* | [**delete_file_edit**](docs/DefaultApi.md#delete_file_edit) | **DELETE** /editgroup/{editgroup_id}/file/edit/{edit_id} | 
*DefaultApi* | [**delete_fileset**](docs/DefaultApi.md#delete_fileset) | **DELETE** /editgroup/{editgroup_id}/fileset/{ident} | 
*DefaultApi* | [**delete_fileset_edit**](docs/DefaultApi.md#delete_fileset_edit) | **DELETE** /editgroup/{editgroup_id}/fileset/edit/{edit_id} | 
*DefaultApi* | [**delete_release**](docs/DefaultApi.md#delete_release) | **DELETE** /editgroup/{editgroup_id}/release/{ident} | 
*DefaultApi* | [**delete_release_edit**](docs/DefaultApi.md#delete_release_edit) | **DELETE** /editgroup/{editgroup_id}/release/edit/{edit_id} | 
*DefaultApi* | [**delete_webcapture**](docs/DefaultApi.md#delete_webcapture) | **DELETE** /editgroup/{editgroup_id}/webcapture/{ident} | 
*DefaultApi* | [**delete_webcapture_edit**](docs/DefaultApi.md#delete_webcapture_edit) | **DELETE** /editgroup/{editgroup_id}/webcapture/edit/{edit_id} | 
*DefaultApi* | [**delete_work**](docs/DefaultApi.md#delete_work) | **DELETE** /editgroup/{editgroup_id}/work/{ident} | 
*DefaultApi* | [**delete_work_edit**](docs/DefaultApi.md#delete_work_edit) | **DELETE** /editgroup/{editgroup_id}/work/edit/{edit_id} | 
*DefaultApi* | [**get_changelog**](docs/DefaultApi.md#get_changelog) | **GET** /changelog | 
*DefaultApi* | [**get_changelog_entry**](docs/DefaultApi.md#get_changelog_entry) | **GET** /changelog/{index} | 
*DefaultApi* | [**get_container**](docs/DefaultApi.md#get_container) | **GET** /container/{ident} | 
*DefaultApi* | [**get_container_edit**](docs/DefaultApi.md#get_container_edit) | **GET** /container/edit/{edit_id} | 
*DefaultApi* | [**get_container_history**](docs/DefaultApi.md#get_container_history) | **GET** /container/{ident}/history | 
*DefaultApi* | [**get_container_redirects**](docs/DefaultApi.md#get_container_redirects) | **GET** /container/{ident}/redirects | 
*DefaultApi* | [**get_container_revision**](docs/DefaultApi.md#get_container_revision) | **GET** /container/rev/{rev_id} | 
*DefaultApi* | [**get_creator**](docs/DefaultApi.md#get_creator) | **GET** /creator/{ident} | 
*DefaultApi* | [**get_creator_edit**](docs/DefaultApi.md#get_creator_edit) | **GET** /creator/edit/{edit_id} | 
*DefaultApi* | [**get_creator_history**](docs/DefaultApi.md#get_creator_history) | **GET** /creator/{ident}/history | 
*DefaultApi* | [**get_creator_redirects**](docs/DefaultApi.md#get_creator_redirects) | **GET** /creator/{ident}/redirects | 
*DefaultApi* | [**get_creator_releases**](docs/DefaultApi.md#get_creator_releases) | **GET** /creator/{ident}/releases | 
*DefaultApi* | [**get_creator_revision**](docs/DefaultApi.md#get_creator_revision) | **GET** /creator/rev/{rev_id} | 
*DefaultApi* | [**get_editgroup**](docs/DefaultApi.md#get_editgroup) | **GET** /editgroup/{editgroup_id} | 
*DefaultApi* | [**get_editgroup_annotations**](docs/DefaultApi.md#get_editgroup_annotations) | **GET** /editgroup/{editgroup_id}/annotations | 
*DefaultApi* | [**get_editgroups_reviewable**](docs/DefaultApi.md#get_editgroups_reviewable) | **GET** /editgroup/reviewable | 
*DefaultApi* | [**get_editor**](docs/DefaultApi.md#get_editor) | **GET** /editor/{editor_id} | 
*DefaultApi* | [**get_editor_annotations**](docs/DefaultApi.md#get_editor_annotations) | **GET** /editor/{editor_id}/annotations | 
*DefaultApi* | [**get_editor_editgroups**](docs/DefaultApi.md#get_editor_editgroups) | **GET** /editor/{editor_id}/editgroups | 
*DefaultApi* | [**get_file**](docs/DefaultApi.md#get_file) | **GET** /file/{ident} | 
*DefaultApi* | [**get_file_edit**](docs/DefaultApi.md#get_file_edit) | **GET** /file/edit/{edit_id} | 
*DefaultApi* | [**get_file_history**](docs/DefaultApi.md#get_file_history) | **GET** /file/{ident}/history | 
*DefaultApi* | [**get_file_redirects**](docs/DefaultApi.md#get_file_redirects) | **GET** /file/{ident}/redirects | 
*DefaultApi* | [**get_file_revision**](docs/DefaultApi.md#get_file_revision) | **GET** /file/rev/{rev_id} | 
*DefaultApi* | [**get_fileset**](docs/DefaultApi.md#get_fileset) | **GET** /fileset/{ident} | 
*DefaultApi* | [**get_fileset_edit**](docs/DefaultApi.md#get_fileset_edit) | **GET** /fileset/edit/{edit_id} | 
*DefaultApi* | [**get_fileset_history**](docs/DefaultApi.md#get_fileset_history) | **GET** /fileset/{ident}/history | 
*DefaultApi* | [**get_fileset_redirects**](docs/DefaultApi.md#get_fileset_redirects) | **GET** /fileset/{ident}/redirects | 
*DefaultApi* | [**get_fileset_revision**](docs/DefaultApi.md#get_fileset_revision) | **GET** /fileset/rev/{rev_id} | 
*DefaultApi* | [**get_release**](docs/DefaultApi.md#get_release) | **GET** /release/{ident} | 
*DefaultApi* | [**get_release_edit**](docs/DefaultApi.md#get_release_edit) | **GET** /release/edit/{edit_id} | 
*DefaultApi* | [**get_release_files**](docs/DefaultApi.md#get_release_files) | **GET** /release/{ident}/files | 
*DefaultApi* | [**get_release_filesets**](docs/DefaultApi.md#get_release_filesets) | **GET** /release/{ident}/filesets | 
*DefaultApi* | [**get_release_history**](docs/DefaultApi.md#get_release_history) | **GET** /release/{ident}/history | 
*DefaultApi* | [**get_release_redirects**](docs/DefaultApi.md#get_release_redirects) | **GET** /release/{ident}/redirects | 
*DefaultApi* | [**get_release_revision**](docs/DefaultApi.md#get_release_revision) | **GET** /release/rev/{rev_id} | 
*DefaultApi* | [**get_release_webcaptures**](docs/DefaultApi.md#get_release_webcaptures) | **GET** /release/{ident}/webcaptures | 
*DefaultApi* | [**get_webcapture**](docs/DefaultApi.md#get_webcapture) | **GET** /webcapture/{ident} | 
*DefaultApi* | [**get_webcapture_edit**](docs/DefaultApi.md#get_webcapture_edit) | **GET** /webcapture/edit/{edit_id} | 
*DefaultApi* | [**get_webcapture_history**](docs/DefaultApi.md#get_webcapture_history) | **GET** /webcapture/{ident}/history | 
*DefaultApi* | [**get_webcapture_redirects**](docs/DefaultApi.md#get_webcapture_redirects) | **GET** /webcapture/{ident}/redirects | 
*DefaultApi* | [**get_webcapture_revision**](docs/DefaultApi.md#get_webcapture_revision) | **GET** /webcapture/rev/{rev_id} | 
*DefaultApi* | [**get_work**](docs/DefaultApi.md#get_work) | **GET** /work/{ident} | 
*DefaultApi* | [**get_work_edit**](docs/DefaultApi.md#get_work_edit) | **GET** /work/edit/{edit_id} | 
*DefaultApi* | [**get_work_history**](docs/DefaultApi.md#get_work_history) | **GET** /work/{ident}/history | 
*DefaultApi* | [**get_work_redirects**](docs/DefaultApi.md#get_work_redirects) | **GET** /work/{ident}/redirects | 
*DefaultApi* | [**get_work_releases**](docs/DefaultApi.md#get_work_releases) | **GET** /work/{ident}/releases | 
*DefaultApi* | [**get_work_revision**](docs/DefaultApi.md#get_work_revision) | **GET** /work/rev/{rev_id} | 
*DefaultApi* | [**lookup_container**](docs/DefaultApi.md#lookup_container) | **GET** /container/lookup | 
*DefaultApi* | [**lookup_creator**](docs/DefaultApi.md#lookup_creator) | **GET** /creator/lookup | 
*DefaultApi* | [**lookup_editor**](docs/DefaultApi.md#lookup_editor) | **GET** /editor/lookup | 
*DefaultApi* | [**lookup_file**](docs/DefaultApi.md#lookup_file) | **GET** /file/lookup | 
*DefaultApi* | [**lookup_release**](docs/DefaultApi.md#lookup_release) | **GET** /release/lookup | 
*DefaultApi* | [**update_container**](docs/DefaultApi.md#update_container) | **PUT** /editgroup/{editgroup_id}/container/{ident} | 
*DefaultApi* | [**update_creator**](docs/DefaultApi.md#update_creator) | **PUT** /editgroup/{editgroup_id}/creator/{ident} | 
*DefaultApi* | [**update_editgroup**](docs/DefaultApi.md#update_editgroup) | **PUT** /editgroup/{editgroup_id} | 
*DefaultApi* | [**update_editor**](docs/DefaultApi.md#update_editor) | **PUT** /editor/{editor_id} | 
*DefaultApi* | [**update_file**](docs/DefaultApi.md#update_file) | **PUT** /editgroup/{editgroup_id}/file/{ident} | 
*DefaultApi* | [**update_fileset**](docs/DefaultApi.md#update_fileset) | **PUT** /editgroup/{editgroup_id}/fileset/{ident} | 
*DefaultApi* | [**update_release**](docs/DefaultApi.md#update_release) | **PUT** /editgroup/{editgroup_id}/release/{ident} | 
*DefaultApi* | [**update_webcapture**](docs/DefaultApi.md#update_webcapture) | **PUT** /editgroup/{editgroup_id}/webcapture/{ident} | 
*DefaultApi* | [**update_work**](docs/DefaultApi.md#update_work) | **PUT** /editgroup/{editgroup_id}/work/{ident} | 


## Documentation For Models

 - [AuthOidc](docs/AuthOidc.md)
 - [AuthOidcResult](docs/AuthOidcResult.md)
 - [AuthTokenResult](docs/AuthTokenResult.md)
 - [ChangelogEntry](docs/ChangelogEntry.md)
 - [ContainerAutoBatch](docs/ContainerAutoBatch.md)
 - [ContainerEntity](docs/ContainerEntity.md)
 - [CreatorAutoBatch](docs/CreatorAutoBatch.md)
 - [CreatorEntity](docs/CreatorEntity.md)
 - [Editgroup](docs/Editgroup.md)
 - [EditgroupAnnotation](docs/EditgroupAnnotation.md)
 - [EditgroupEdits](docs/EditgroupEdits.md)
 - [Editor](docs/Editor.md)
 - [EntityEdit](docs/EntityEdit.md)
 - [EntityHistoryEntry](docs/EntityHistoryEntry.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [FileAutoBatch](docs/FileAutoBatch.md)
 - [FileEntity](docs/FileEntity.md)
 - [FileUrl](docs/FileUrl.md)
 - [FilesetAutoBatch](docs/FilesetAutoBatch.md)
 - [FilesetEntity](docs/FilesetEntity.md)
 - [FilesetFile](docs/FilesetFile.md)
 - [FilesetUrl](docs/FilesetUrl.md)
 - [ReleaseAbstract](docs/ReleaseAbstract.md)
 - [ReleaseAutoBatch](docs/ReleaseAutoBatch.md)
 - [ReleaseContrib](docs/ReleaseContrib.md)
 - [ReleaseEntity](docs/ReleaseEntity.md)
 - [ReleaseExtIds](docs/ReleaseExtIds.md)
 - [ReleaseRef](docs/ReleaseRef.md)
 - [Success](docs/Success.md)
 - [WebcaptureAutoBatch](docs/WebcaptureAutoBatch.md)
 - [WebcaptureCdxLine](docs/WebcaptureCdxLine.md)
 - [WebcaptureEntity](docs/WebcaptureEntity.md)
 - [WebcaptureUrl](docs/WebcaptureUrl.md)
 - [WorkAutoBatch](docs/WorkAutoBatch.md)
 - [WorkEntity](docs/WorkEntity.md)


## Documentation For Authorization


## Bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Author

Bryan Newbold <bnewbold@archive.org>

