# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### KubeApiService <a name="KubeApiService" id="cdk8s-metaflow.k8s.KubeApiService"></a>

APIService represents a server for a particular GroupVersion.

Name must be "version.group".

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeApiService.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeApiService(scope: Construct, id: string, props?: KubeApiServiceProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeApiServiceProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeApiService.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeApiService.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeApiService.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeApiServiceProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeApiService.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeApiService.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeApiService.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeApiService.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeApiService.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeApiService.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeApiService.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeApiService.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeApiService.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeApiService.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeApiService.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeApiService.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeApiService.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeApiService.manifest(props?: KubeApiServiceProps)
```

Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeApiService.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeApiServiceProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeApiService.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeApiService.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeApiService.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeApiService.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeApiService.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeApiService.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeApiService.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiService.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeApiService.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIService".

---

### KubeApiServiceList <a name="KubeApiServiceList" id="cdk8s-metaflow.k8s.KubeApiServiceList"></a>

APIServiceList is a list of APIService objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeApiServiceList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeApiServiceList(scope: Construct, id: string, props: KubeApiServiceListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeApiServiceListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeApiServiceList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeApiServiceList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeApiServiceList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeApiServiceListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeApiServiceList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeApiServiceList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeApiServiceList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeApiServiceList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeApiServiceList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeApiServiceList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeApiServiceList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeApiServiceList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeApiServiceList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeApiServiceList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeApiServiceList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeApiServiceList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeApiServiceList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeApiServiceList.manifest(props: KubeApiServiceListProps)
```

Renders a Kubernetes manifest for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeApiServiceList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeApiServiceListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeApiServiceList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeApiServiceList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeApiServiceList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeApiServiceList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeApiServiceList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeApiServiceList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeApiServiceList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeApiServiceList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeApiServiceList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.kube-aggregator.pkg.apis.apiregistration.v1.APIServiceList".

---

### KubeBinding <a name="KubeBinding" id="cdk8s-metaflow.k8s.KubeBinding"></a>

Binding ties one object to another;

for example, a pod is bound to a node by a scheduler. Deprecated in 1.7, please use the bindings subresource of pods instead.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeBinding.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeBinding(scope: Construct, id: string, props: KubeBindingProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeBindingProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeBinding.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeBinding.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeBinding.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeBindingProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeBinding.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeBinding.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeBinding.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeBinding.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeBinding.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeBinding.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.Binding". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeBinding.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeBinding.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeBinding.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeBinding.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeBinding.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeBinding.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeBinding.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeBinding.manifest(props: KubeBindingProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Binding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeBinding.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeBindingProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeBinding.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeBinding.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeBinding.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeBinding.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeBinding.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeBinding.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeBinding.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeBinding.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Binding". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeBinding.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.Binding".

---

### KubeCertificateSigningRequest <a name="KubeCertificateSigningRequest" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest"></a>

CertificateSigningRequest objects provide a mechanism to obtain x509 certificates by submitting a certificate signing request, and having it asynchronously approved and issued.

Kubelets use this API to obtain:
1. client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client-kubelet" signerName).
2. serving certificates for TLS endpoints kube-apiserver can connect to securely (with the "kubernetes.io/kubelet-serving" signerName).

This API can be used to request client certificates to authenticate to kube-apiserver (with the "kubernetes.io/kube-apiserver-client" signerName), or to obtain certificates from custom non-Kubernetes signers.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCertificateSigningRequest(scope: Construct, id: string, props: KubeCertificateSigningRequestProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCertificateSigningRequestProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCertificateSigningRequestProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequest". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCertificateSigningRequest.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCertificateSigningRequest.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCertificateSigningRequest.manifest(props: KubeCertificateSigningRequestProps)
```

Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequest".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCertificateSigningRequestProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequest". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequest.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequest".

---

### KubeCertificateSigningRequestList <a name="KubeCertificateSigningRequestList" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList"></a>

CertificateSigningRequestList is a collection of CertificateSigningRequest objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCertificateSigningRequestList(scope: Construct, id: string, props: KubeCertificateSigningRequestListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCertificateSigningRequestListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCertificateSigningRequestListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequestList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCertificateSigningRequestList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCertificateSigningRequestList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCertificateSigningRequestList.manifest(props: KubeCertificateSigningRequestListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.certificates.v1.CertificateSigningRequestList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCertificateSigningRequestListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequestList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCertificateSigningRequestList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.certificates.v1.CertificateSigningRequestList".

---

### KubeClusterRole <a name="KubeClusterRole" id="cdk8s-metaflow.k8s.KubeClusterRole"></a>

ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeClusterRole.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeClusterRole(scope: Construct, id: string, props?: KubeClusterRoleProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeClusterRoleProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeClusterRole.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeClusterRole.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRole.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeClusterRole.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeClusterRole.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeClusterRole.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeClusterRole.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeClusterRole.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeClusterRole.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRole". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeClusterRole.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRole.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeClusterRole.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeClusterRole.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRole.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeClusterRole.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeClusterRole.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRole.manifest(props?: KubeClusterRoleProps)
```

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRole".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRole.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeClusterRole.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeClusterRole.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeClusterRole.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeClusterRole.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeClusterRole.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeClusterRole.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeClusterRole.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRole.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRole". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeClusterRole.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRole".

---

### KubeClusterRoleBinding <a name="KubeClusterRoleBinding" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding"></a>

ClusterRoleBinding references a ClusterRole, but not contain it.

It can reference a ClusterRole in the global namespace, and adds who information via Subject.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeClusterRoleBinding(scope: Construct, id: string, props: KubeClusterRoleBindingProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeClusterRoleBindingProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleBindingProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBinding". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBinding.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBinding.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBinding.manifest(props: KubeClusterRoleBindingProps)
```

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBinding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleBindingProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBinding". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeClusterRoleBinding.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBinding".

---

### KubeClusterRoleBindingList <a name="KubeClusterRoleBindingList" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList"></a>

ClusterRoleBindingList is a collection of ClusterRoleBindings.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeClusterRoleBindingList(scope: Construct, id: string, props: KubeClusterRoleBindingListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeClusterRoleBindingListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleBindingListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBindingList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingList.manifest(props: KubeClusterRoleBindingListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleBindingList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleBindingListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBindingList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleBindingList".

---

### KubeClusterRoleBindingListV1Alpha1 <a name="KubeClusterRoleBindingListV1Alpha1" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1"></a>

ClusterRoleBindingList is a collection of ClusterRoleBindings.

Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBindings, and will no longer be served in v1.22.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeClusterRoleBindingListV1Alpha1(scope: Construct, id: string, props: KubeClusterRoleBindingListV1Alpha1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingListV1Alpha1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingListV1Alpha1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingListV1Alpha1.manifest(props: KubeClusterRoleBindingListV1Alpha1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingListV1Alpha1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBindingList".

---

### KubeClusterRoleBindingV1Alpha1 <a name="KubeClusterRoleBindingV1Alpha1" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1"></a>

ClusterRoleBinding references a ClusterRole, but not contain it.

It can reference a ClusterRole in the global namespace, and adds who information via Subject. Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoleBinding, and will no longer be served in v1.22.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeClusterRoleBindingV1Alpha1(scope: Construct, id: string, props: KubeClusterRoleBindingV1Alpha1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingV1Alpha1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingV1Alpha1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleBindingV1Alpha1.manifest(props: KubeClusterRoleBindingV1Alpha1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeClusterRoleBindingV1Alpha1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleBinding".

---

### KubeClusterRoleList <a name="KubeClusterRoleList" id="cdk8s-metaflow.k8s.KubeClusterRoleList"></a>

ClusterRoleList is a collection of ClusterRoles.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeClusterRoleList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeClusterRoleList(scope: Construct, id: string, props: KubeClusterRoleListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeClusterRoleListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeClusterRoleList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeClusterRoleList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeClusterRoleList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeClusterRoleList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeClusterRoleList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeClusterRoleList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeClusterRoleList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeClusterRoleList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeClusterRoleList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeClusterRoleList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeClusterRoleList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeClusterRoleList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeClusterRoleList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleList.manifest(props: KubeClusterRoleListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1.ClusterRoleList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeClusterRoleList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeClusterRoleList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeClusterRoleList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeClusterRoleList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeClusterRoleList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeClusterRoleList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeClusterRoleList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeClusterRoleList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.rbac.v1.ClusterRoleList".

---

### KubeClusterRoleListV1Alpha1 <a name="KubeClusterRoleListV1Alpha1" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1"></a>

ClusterRoleList is a collection of ClusterRoles.

Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRoles, and will no longer be served in v1.22.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeClusterRoleListV1Alpha1(scope: Construct, id: string, props: KubeClusterRoleListV1Alpha1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleListV1Alpha1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleListV1Alpha1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleListV1Alpha1.manifest(props: KubeClusterRoleListV1Alpha1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRoleList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeClusterRoleListV1Alpha1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRoleList".

---

### KubeClusterRoleV1Alpha1 <a name="KubeClusterRoleV1Alpha1" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1"></a>

ClusterRole is a cluster level, logical grouping of PolicyRules that can be referenced as a unit by a RoleBinding or ClusterRoleBinding.

Deprecated in v1.17 in favor of rbac.authorization.k8s.io/v1 ClusterRole, and will no longer be served in v1.22.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeClusterRoleV1Alpha1(scope: Construct, id: string, props?: KubeClusterRoleV1Alpha1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRole". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleV1Alpha1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleV1Alpha1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeClusterRoleV1Alpha1.manifest(props?: KubeClusterRoleV1Alpha1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.rbac.v1alpha1.ClusterRole".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRole". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeClusterRoleV1Alpha1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.rbac.v1alpha1.ClusterRole".

---

### KubeComponentStatus <a name="KubeComponentStatus" id="cdk8s-metaflow.k8s.KubeComponentStatus"></a>

ComponentStatus (and ComponentStatusList) holds the cluster validation info.

Deprecated: This API is deprecated in v1.19+

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeComponentStatus.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeComponentStatus(scope: Construct, id: string, props?: KubeComponentStatusProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeComponentStatusProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeComponentStatus.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeComponentStatus.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeComponentStatus.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeComponentStatusProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeComponentStatus.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeComponentStatus.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeComponentStatus.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeComponentStatus.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeComponentStatus.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeComponentStatus.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatus". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeComponentStatus.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeComponentStatus.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeComponentStatus.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeComponentStatus.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeComponentStatus.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeComponentStatus.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeComponentStatus.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeComponentStatus.manifest(props?: KubeComponentStatusProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatus".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeComponentStatus.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeComponentStatusProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeComponentStatus.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeComponentStatus.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeComponentStatus.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeComponentStatus.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeComponentStatus.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeComponentStatus.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeComponentStatus.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatus.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatus". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeComponentStatus.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatus".

---

### KubeComponentStatusList <a name="KubeComponentStatusList" id="cdk8s-metaflow.k8s.KubeComponentStatusList"></a>

Status of all the conditions for the component as a list of ComponentStatus objects.

Deprecated: This API is deprecated in v1.19+

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeComponentStatusList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeComponentStatusList(scope: Construct, id: string, props: KubeComponentStatusListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeComponentStatusListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeComponentStatusList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeComponentStatusList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeComponentStatusList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeComponentStatusListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeComponentStatusList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeComponentStatusList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeComponentStatusList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeComponentStatusList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeComponentStatusList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeComponentStatusList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatusList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeComponentStatusList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeComponentStatusList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeComponentStatusList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeComponentStatusList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeComponentStatusList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeComponentStatusList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeComponentStatusList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeComponentStatusList.manifest(props: KubeComponentStatusListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ComponentStatusList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeComponentStatusList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeComponentStatusListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeComponentStatusList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeComponentStatusList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeComponentStatusList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeComponentStatusList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeComponentStatusList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeComponentStatusList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeComponentStatusList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeComponentStatusList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatusList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeComponentStatusList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.ComponentStatusList".

---

### KubeConfigMap <a name="KubeConfigMap" id="cdk8s-metaflow.k8s.KubeConfigMap"></a>

ConfigMap holds configuration data for pods to consume.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeConfigMap.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeConfigMap(scope: Construct, id: string, props?: KubeConfigMapProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeConfigMapProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeConfigMap.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeConfigMap.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeConfigMap.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeConfigMapProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeConfigMap.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeConfigMap.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeConfigMap.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeConfigMap.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeConfigMap.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeConfigMap.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMap". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeConfigMap.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeConfigMap.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeConfigMap.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeConfigMap.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeConfigMap.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeConfigMap.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeConfigMap.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeConfigMap.manifest(props?: KubeConfigMapProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMap".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeConfigMap.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeConfigMapProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeConfigMap.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeConfigMap.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeConfigMap.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeConfigMap.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeConfigMap.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeConfigMap.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeConfigMap.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMap.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMap". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeConfigMap.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMap".

---

### KubeConfigMapList <a name="KubeConfigMapList" id="cdk8s-metaflow.k8s.KubeConfigMapList"></a>

ConfigMapList is a resource containing a list of ConfigMap objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeConfigMapList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeConfigMapList(scope: Construct, id: string, props: KubeConfigMapListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeConfigMapListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeConfigMapList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeConfigMapList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeConfigMapList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeConfigMapListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeConfigMapList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeConfigMapList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeConfigMapList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeConfigMapList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeConfigMapList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeConfigMapList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMapList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeConfigMapList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeConfigMapList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeConfigMapList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeConfigMapList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeConfigMapList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeConfigMapList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeConfigMapList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeConfigMapList.manifest(props: KubeConfigMapListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.ConfigMapList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeConfigMapList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeConfigMapListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeConfigMapList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeConfigMapList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeConfigMapList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeConfigMapList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeConfigMapList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeConfigMapList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeConfigMapList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeConfigMapList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMapList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeConfigMapList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.ConfigMapList".

---

### KubeControllerRevision <a name="KubeControllerRevision" id="cdk8s-metaflow.k8s.KubeControllerRevision"></a>

ControllerRevision implements an immutable snapshot of state data.

Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeControllerRevision.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeControllerRevision(scope: Construct, id: string, props: KubeControllerRevisionProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeControllerRevisionProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeControllerRevision.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeControllerRevision.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeControllerRevision.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeControllerRevisionProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeControllerRevision.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeControllerRevision.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeControllerRevision.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeControllerRevision.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeControllerRevision.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeControllerRevision.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevision". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeControllerRevision.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeControllerRevision.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeControllerRevision.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeControllerRevision.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeControllerRevision.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeControllerRevision.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeControllerRevision.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeControllerRevision.manifest(props: KubeControllerRevisionProps)
```

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevision".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeControllerRevision.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeControllerRevisionProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeControllerRevision.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeControllerRevision.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeControllerRevision.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeControllerRevision.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeControllerRevision.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeControllerRevision.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeControllerRevision.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevision.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevision". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeControllerRevision.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevision".

---

### KubeControllerRevisionList <a name="KubeControllerRevisionList" id="cdk8s-metaflow.k8s.KubeControllerRevisionList"></a>

ControllerRevisionList is a resource containing a list of ControllerRevision objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeControllerRevisionList(scope: Construct, id: string, props: KubeControllerRevisionListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeControllerRevisionListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeControllerRevisionListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevisionList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeControllerRevisionList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeControllerRevisionList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeControllerRevisionList.manifest(props: KubeControllerRevisionListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.ControllerRevisionList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeControllerRevisionListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeControllerRevisionList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevisionList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeControllerRevisionList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.apps.v1.ControllerRevisionList".

---

### KubeCronJob <a name="KubeCronJob" id="cdk8s-metaflow.k8s.KubeCronJob"></a>

CronJob represents the configuration of a single cron job.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCronJob.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCronJob(scope: Construct, id: string, props?: KubeCronJobProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCronJobProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCronJob.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCronJob.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCronJob.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCronJobProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCronJob.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCronJob.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCronJob.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCronJob.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCronJob.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCronJob.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJob". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCronJob.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJob.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCronJob.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCronJob.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJob.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCronJob.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCronJob.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJob.manifest(props?: KubeCronJobProps)
```

Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJob".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCronJob.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCronJobProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCronJob.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCronJob.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCronJob.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCronJob.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCronJob.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCronJob.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCronJob.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJob.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJob". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCronJob.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJob".

---

### KubeCronJobList <a name="KubeCronJobList" id="cdk8s-metaflow.k8s.KubeCronJobList"></a>

CronJobList is a collection of cron jobs.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCronJobList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCronJobList(scope: Construct, id: string, props: KubeCronJobListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCronJobListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCronJobList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCronJobList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCronJobList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCronJobListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCronJobList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCronJobList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCronJobList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCronJobList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCronJobList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCronJobList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJobList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCronJobList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCronJobList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCronJobList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCronJobList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCronJobList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobList.manifest(props: KubeCronJobListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.batch.v1.CronJobList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCronJobList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCronJobListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCronJobList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCronJobList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCronJobList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCronJobList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCronJobList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCronJobList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCronJobList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJobList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCronJobList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.batch.v1.CronJobList".

---

### KubeCronJobListV1Beta1 <a name="KubeCronJobListV1Beta1" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1"></a>

CronJobList is a collection of cron jobs.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCronJobListV1Beta1(scope: Construct, id: string, props: KubeCronJobListV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCronJobListV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCronJobListV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJobList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobListV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobListV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobListV1Beta1.manifest(props: KubeCronJobListV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJobList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCronJobListV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJobList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCronJobListV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJobList".

---

### KubeCronJobV1Beta1 <a name="KubeCronJobV1Beta1" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1"></a>

CronJob represents the configuration of a single cron job.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCronJobV1Beta1(scope: Construct, id: string, props?: KubeCronJobV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCronJobV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCronJobV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJob". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCronJobV1Beta1.manifest(props?: KubeCronJobV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.batch.v1beta1.CronJob".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCronJobV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJob". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCronJobV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.batch.v1beta1.CronJob".

---

### KubeCsiDriver <a name="KubeCsiDriver" id="cdk8s-metaflow.k8s.KubeCsiDriver"></a>

CSIDriver captures information about a Container Storage Interface (CSI) volume driver deployed on the cluster.

Kubernetes attach detach controller uses this object to determine whether attach is required. Kubelet uses this object to determine whether pod information needs to be passed on mount. CSIDriver objects are non-namespaced.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCsiDriver.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCsiDriver(scope: Construct, id: string, props: KubeCsiDriverProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCsiDriverProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCsiDriver.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCsiDriver.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiDriver.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiDriverProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCsiDriver.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCsiDriver.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCsiDriver.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCsiDriver.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCsiDriver.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCsiDriver.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriver". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCsiDriver.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiDriver.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCsiDriver.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCsiDriver.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiDriver.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCsiDriver.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCsiDriver.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiDriver.manifest(props: KubeCsiDriverProps)
```

Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriver".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiDriver.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiDriverProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCsiDriver.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCsiDriver.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCsiDriver.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCsiDriver.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCsiDriver.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCsiDriver.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCsiDriver.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriver.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriver". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCsiDriver.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriver".

---

### KubeCsiDriverList <a name="KubeCsiDriverList" id="cdk8s-metaflow.k8s.KubeCsiDriverList"></a>

CSIDriverList is a collection of CSIDriver objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCsiDriverList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCsiDriverList(scope: Construct, id: string, props: KubeCsiDriverListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCsiDriverListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCsiDriverList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCsiDriverList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiDriverList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiDriverListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCsiDriverList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCsiDriverList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCsiDriverList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCsiDriverList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCsiDriverList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCsiDriverList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriverList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCsiDriverList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiDriverList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCsiDriverList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCsiDriverList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiDriverList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCsiDriverList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCsiDriverList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiDriverList.manifest(props: KubeCsiDriverListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSIDriverList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiDriverList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiDriverListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCsiDriverList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCsiDriverList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCsiDriverList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCsiDriverList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCsiDriverList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCsiDriverList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCsiDriverList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiDriverList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriverList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCsiDriverList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSIDriverList".

---

### KubeCsiNode <a name="KubeCsiNode" id="cdk8s-metaflow.k8s.KubeCsiNode"></a>

CSINode holds information about all CSI drivers installed on a node.

CSI drivers do not need to create the CSINode object directly. As long as they use the node-driver-registrar sidecar container, the kubelet will automatically populate the CSINode object for the CSI driver as part of kubelet plugin registration. CSINode has the same name as a node. If the object is missing, it means either there are no CSI Drivers available on the node, or the Kubelet version is low enough that it doesn't create this object. CSINode has an OwnerReference that points to the corresponding node object.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCsiNode.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCsiNode(scope: Construct, id: string, props: KubeCsiNodeProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCsiNodeProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCsiNode.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCsiNode.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiNode.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiNodeProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCsiNode.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCsiNode.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCsiNode.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCsiNode.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCsiNode.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCsiNode.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINode". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCsiNode.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiNode.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCsiNode.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCsiNode.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiNode.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCsiNode.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCsiNode.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiNode.manifest(props: KubeCsiNodeProps)
```

Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINode".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiNode.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiNodeProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCsiNode.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCsiNode.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCsiNode.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCsiNode.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCsiNode.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCsiNode.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCsiNode.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNode.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINode". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCsiNode.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINode".

---

### KubeCsiNodeList <a name="KubeCsiNodeList" id="cdk8s-metaflow.k8s.KubeCsiNodeList"></a>

CSINodeList is a collection of CSINode objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCsiNodeList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCsiNodeList(scope: Construct, id: string, props: KubeCsiNodeListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCsiNodeListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCsiNodeList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCsiNodeList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiNodeList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiNodeListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCsiNodeList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCsiNodeList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCsiNodeList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCsiNodeList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCsiNodeList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCsiNodeList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINodeList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCsiNodeList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiNodeList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCsiNodeList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCsiNodeList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiNodeList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCsiNodeList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCsiNodeList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiNodeList.manifest(props: KubeCsiNodeListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.storage.v1.CSINodeList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiNodeList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiNodeListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCsiNodeList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCsiNodeList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCsiNodeList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCsiNodeList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCsiNodeList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCsiNodeList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCsiNodeList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiNodeList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINodeList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCsiNodeList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.storage.v1.CSINodeList".

---

### KubeCsiStorageCapacityListV1Alpha1 <a name="KubeCsiStorageCapacityListV1Alpha1" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1"></a>

CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCsiStorageCapacityListV1Alpha1(scope: Construct, id: string, props: KubeCsiStorageCapacityListV1Alpha1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.CSIStorageCapacityList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityListV1Alpha1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityListV1Alpha1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityListV1Alpha1.manifest(props: KubeCsiStorageCapacityListV1Alpha1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.CSIStorageCapacityList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.CSIStorageCapacityList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Alpha1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.CSIStorageCapacityList".

---

### KubeCsiStorageCapacityListV1Beta1 <a name="KubeCsiStorageCapacityListV1Beta1" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1"></a>

CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCsiStorageCapacityListV1Beta1(scope: Construct, id: string, props: KubeCsiStorageCapacityListV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIStorageCapacityList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityListV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityListV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityListV1Beta1.manifest(props: KubeCsiStorageCapacityListV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIStorageCapacityList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIStorageCapacityList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityListV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIStorageCapacityList".

---

### KubeCsiStorageCapacityV1Alpha1 <a name="KubeCsiStorageCapacityV1Alpha1" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1"></a>

CSIStorageCapacity stores the result of one CSI GetCapacity call.

For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

The producer of these objects can decide which approach is more suitable.

They are consumed by the kube-scheduler if the CSIStorageCapacity beta feature gate is enabled there and a CSI driver opts into capacity-aware scheduling with CSIDriver.StorageCapacity.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCsiStorageCapacityV1Alpha1(scope: Construct, id: string, props: KubeCsiStorageCapacityV1Alpha1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.CSIStorageCapacity". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityV1Alpha1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityV1Alpha1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityV1Alpha1.manifest(props: KubeCsiStorageCapacityV1Alpha1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.storage.v1alpha1.CSIStorageCapacity".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.CSIStorageCapacity". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Alpha1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.storage.v1alpha1.CSIStorageCapacity".

---

### KubeCsiStorageCapacityV1Beta1 <a name="KubeCsiStorageCapacityV1Beta1" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1"></a>

CSIStorageCapacity stores the result of one CSI GetCapacity call.

For a given StorageClass, this describes the available capacity in a particular topology segment.  This can be used when considering where to instantiate new PersistentVolumes.

For example this can express things like: - StorageClass "standard" has "1234 GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"

The following three cases all imply that no capacity is available for a certain combination: - no object exists with suitable topology and storage class name - such an object exists, but the capacity is unset - such an object exists, but the capacity is zero

The producer of these objects can decide which approach is more suitable.

They are consumed by the kube-scheduler if the CSIStorageCapacity beta feature gate is enabled there and a CSI driver opts into capacity-aware scheduling with CSIDriver.StorageCapacity.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCsiStorageCapacityV1Beta1(scope: Construct, id: string, props: KubeCsiStorageCapacityV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIStorageCapacity". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCsiStorageCapacityV1Beta1.manifest(props: KubeCsiStorageCapacityV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.storage.v1beta1.CSIStorageCapacity".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIStorageCapacity". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCsiStorageCapacityV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.storage.v1beta1.CSIStorageCapacity".

---

### KubeCustomResourceDefinition <a name="KubeCustomResourceDefinition" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition"></a>

CustomResourceDefinition represents a resource that should be exposed on the API server.

Its name MUST be in the format <.spec.name>.<.spec.group>.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCustomResourceDefinition(scope: Construct, id: string, props: KubeCustomResourceDefinitionProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCustomResourceDefinitionProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCustomResourceDefinitionProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCustomResourceDefinition.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCustomResourceDefinition.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCustomResourceDefinition.manifest(props: KubeCustomResourceDefinitionProps)
```

Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCustomResourceDefinitionProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinition.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition".

---

### KubeCustomResourceDefinitionList <a name="KubeCustomResourceDefinitionList" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList"></a>

CustomResourceDefinitionList is a list of CustomResourceDefinition objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeCustomResourceDefinitionList(scope: Construct, id: string, props: KubeCustomResourceDefinitionListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeCustomResourceDefinitionListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCustomResourceDefinitionListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCustomResourceDefinitionList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCustomResourceDefinitionList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeCustomResourceDefinitionList.manifest(props: KubeCustomResourceDefinitionListProps)
```

Renders a Kubernetes manifest for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeCustomResourceDefinitionListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeCustomResourceDefinitionList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.apiextensions-apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList".

---

### KubeDaemonSet <a name="KubeDaemonSet" id="cdk8s-metaflow.k8s.KubeDaemonSet"></a>

DaemonSet represents the configuration of a daemon set.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeDaemonSet.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeDaemonSet(scope: Construct, id: string, props?: KubeDaemonSetProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeDaemonSetProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeDaemonSet.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeDaemonSet.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeDaemonSet.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeDaemonSetProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeDaemonSet.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeDaemonSet.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeDaemonSet.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeDaemonSet.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeDaemonSet.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeDaemonSet.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSet". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeDaemonSet.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDaemonSet.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeDaemonSet.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeDaemonSet.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDaemonSet.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeDaemonSet.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeDaemonSet.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDaemonSet.manifest(props?: KubeDaemonSetProps)
```

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSet".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeDaemonSet.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeDaemonSetProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeDaemonSet.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeDaemonSet.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeDaemonSet.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeDaemonSet.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeDaemonSet.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeDaemonSet.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeDaemonSet.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSet.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSet". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeDaemonSet.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSet".

---

### KubeDaemonSetList <a name="KubeDaemonSetList" id="cdk8s-metaflow.k8s.KubeDaemonSetList"></a>

DaemonSetList is a collection of daemon sets.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeDaemonSetList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeDaemonSetList(scope: Construct, id: string, props: KubeDaemonSetListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeDaemonSetListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeDaemonSetList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeDaemonSetList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeDaemonSetList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeDaemonSetListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeDaemonSetList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeDaemonSetList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeDaemonSetList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeDaemonSetList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeDaemonSetList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeDaemonSetList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSetList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeDaemonSetList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDaemonSetList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeDaemonSetList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeDaemonSetList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDaemonSetList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeDaemonSetList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeDaemonSetList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDaemonSetList.manifest(props: KubeDaemonSetListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DaemonSetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeDaemonSetList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeDaemonSetListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeDaemonSetList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeDaemonSetList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeDaemonSetList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeDaemonSetList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeDaemonSetList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeDaemonSetList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeDaemonSetList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDaemonSetList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSetList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeDaemonSetList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.apps.v1.DaemonSetList".

---

### KubeDeployment <a name="KubeDeployment" id="cdk8s-metaflow.k8s.KubeDeployment"></a>

Deployment enables declarative updates for Pods and ReplicaSets.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeDeployment.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeDeployment(scope: Construct, id: string, props?: KubeDeploymentProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeDeploymentProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeDeployment.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeDeployment.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeDeployment.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeDeploymentProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeDeployment.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeDeployment.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeDeployment.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeDeployment.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeDeployment.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeDeployment.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.apps.v1.Deployment". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeDeployment.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDeployment.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeDeployment.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeDeployment.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDeployment.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeDeployment.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeDeployment.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDeployment.manifest(props?: KubeDeploymentProps)
```

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.Deployment".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeDeployment.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeDeploymentProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeDeployment.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeDeployment.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeDeployment.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeDeployment.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeDeployment.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeDeployment.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeDeployment.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeployment.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.Deployment". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeDeployment.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.apps.v1.Deployment".

---

### KubeDeploymentList <a name="KubeDeploymentList" id="cdk8s-metaflow.k8s.KubeDeploymentList"></a>

DeploymentList is a list of Deployments.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeDeploymentList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeDeploymentList(scope: Construct, id: string, props: KubeDeploymentListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeDeploymentListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeDeploymentList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeDeploymentList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeDeploymentList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeDeploymentListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeDeploymentList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeDeploymentList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeDeploymentList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeDeploymentList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeDeploymentList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeDeploymentList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DeploymentList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeDeploymentList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDeploymentList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeDeploymentList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeDeploymentList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDeploymentList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeDeploymentList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeDeploymentList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeDeploymentList.manifest(props: KubeDeploymentListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.apps.v1.DeploymentList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeDeploymentList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeDeploymentListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeDeploymentList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeDeploymentList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeDeploymentList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeDeploymentList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeDeploymentList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeDeploymentList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeDeploymentList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeDeploymentList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.apps.v1.DeploymentList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeDeploymentList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.apps.v1.DeploymentList".

---

### KubeEndpoints <a name="KubeEndpoints" id="cdk8s-metaflow.k8s.KubeEndpoints"></a>

Endpoints is a collection of endpoints that implement the actual service.

Example:
Name: "mysvc",
Subsets: [
  {
    Addresses: [{"ip": "10.10.1.1"}, {"ip": "10.10.2.2"}],
    Ports: [{"name": "a", "port": 8675}, {"name": "b", "port": 309}]
  },
  {
    Addresses: [{"ip": "10.10.3.3"}],
    Ports: [{"name": "a", "port": 93}, {"name": "b", "port": 76}]
  },
]

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEndpoints.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEndpoints(scope: Construct, id: string, props?: KubeEndpointsProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEndpointsProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEndpoints.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEndpoints.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpoints.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointsProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEndpoints.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEndpoints.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEndpoints.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEndpoints.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEndpoints.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEndpoints.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.Endpoints". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEndpoints.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpoints.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEndpoints.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEndpoints.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpoints.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEndpoints.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEndpoints.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpoints.manifest(props?: KubeEndpointsProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Endpoints".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpoints.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointsProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEndpoints.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEndpoints.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEndpoints.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEndpoints.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEndpoints.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEndpoints.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEndpoints.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpoints.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Endpoints". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEndpoints.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.Endpoints".

---

### KubeEndpointSlice <a name="KubeEndpointSlice" id="cdk8s-metaflow.k8s.KubeEndpointSlice"></a>

EndpointSlice represents a subset of the endpoints that implement a service.

For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEndpointSlice.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEndpointSlice(scope: Construct, id: string, props: KubeEndpointSliceProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEndpointSliceProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEndpointSlice.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEndpointSlice.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointSlice.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointSliceProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEndpointSlice.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEndpointSlice.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEndpointSlice.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEndpointSlice.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEndpointSlice.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEndpointSlice.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSlice". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEndpointSlice.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSlice.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEndpointSlice.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEndpointSlice.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSlice.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEndpointSlice.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEndpointSlice.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSlice.manifest(props: KubeEndpointSliceProps)
```

Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSlice".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointSlice.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointSliceProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEndpointSlice.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEndpointSlice.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEndpointSlice.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEndpointSlice.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEndpointSlice.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEndpointSlice.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEndpointSlice.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSlice.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSlice". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEndpointSlice.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSlice".

---

### KubeEndpointSliceList <a name="KubeEndpointSliceList" id="cdk8s-metaflow.k8s.KubeEndpointSliceList"></a>

EndpointSliceList represents a list of endpoint slices.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEndpointSliceList(scope: Construct, id: string, props: KubeEndpointSliceListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEndpointSliceListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointSliceListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSliceList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceList.manifest(props: KubeEndpointSliceListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.discovery.v1.EndpointSliceList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointSliceListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSliceList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEndpointSliceList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.discovery.v1.EndpointSliceList".

---

### KubeEndpointSliceListV1Beta1 <a name="KubeEndpointSliceListV1Beta1" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1"></a>

EndpointSliceList represents a list of endpoint slices.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEndpointSliceListV1Beta1(scope: Construct, id: string, props: KubeEndpointSliceListV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.discovery.v1beta1.EndpointSliceList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceListV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceListV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceListV1Beta1.manifest(props: KubeEndpointSliceListV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.discovery.v1beta1.EndpointSliceList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.discovery.v1beta1.EndpointSliceList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEndpointSliceListV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.discovery.v1beta1.EndpointSliceList".

---

### KubeEndpointSliceV1Beta1 <a name="KubeEndpointSliceV1Beta1" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1"></a>

EndpointSlice represents a subset of the endpoints that implement a service.

For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEndpointSliceV1Beta1(scope: Construct, id: string, props: KubeEndpointSliceV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.discovery.v1beta1.EndpointSlice". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointSliceV1Beta1.manifest(props: KubeEndpointSliceV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.discovery.v1beta1.EndpointSlice".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.discovery.v1beta1.EndpointSlice". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEndpointSliceV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.discovery.v1beta1.EndpointSlice".

---

### KubeEndpointsList <a name="KubeEndpointsList" id="cdk8s-metaflow.k8s.KubeEndpointsList"></a>

EndpointsList is a list of endpoints.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEndpointsList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEndpointsList(scope: Construct, id: string, props: KubeEndpointsListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEndpointsListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEndpointsList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEndpointsList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointsList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointsListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEndpointsList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEndpointsList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEndpointsList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEndpointsList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEndpointsList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEndpointsList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.EndpointsList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEndpointsList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointsList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEndpointsList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEndpointsList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointsList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEndpointsList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEndpointsList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEndpointsList.manifest(props: KubeEndpointsListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.EndpointsList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEndpointsList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEndpointsListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEndpointsList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEndpointsList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEndpointsList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEndpointsList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEndpointsList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEndpointsList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEndpointsList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEndpointsList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.EndpointsList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEndpointsList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.EndpointsList".

---

### KubeEvent <a name="KubeEvent" id="cdk8s-metaflow.k8s.KubeEvent"></a>

Event is a report of an event somewhere in the cluster.

It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEvent.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEvent(scope: Construct, id: string, props: KubeEventProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEventProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEvent.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEvent.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEvent.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEventProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEvent.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEvent.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEvent.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEvent.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEvent.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEvent.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.events.v1.Event". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEvent.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEvent.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEvent.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEvent.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEvent.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEvent.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEvent.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEvent.manifest(props: KubeEventProps)
```

Renders a Kubernetes manifest for "io.k8s.api.events.v1.Event".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEvent.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEventProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEvent.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEvent.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEvent.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEvent.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEvent.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEvent.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEvent.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEvent.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.events.v1.Event". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEvent.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.events.v1.Event".

---

### KubeEventList <a name="KubeEventList" id="cdk8s-metaflow.k8s.KubeEventList"></a>

EventList is a list of Event objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEventList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEventList(scope: Construct, id: string, props: KubeEventListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEventListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEventList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEventList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEventList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEventListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEventList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEventList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEventList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEventList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEventList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEventList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.events.v1.EventList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEventList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEventList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEventList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEventList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEventList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventList.manifest(props: KubeEventListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.events.v1.EventList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEventList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEventListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEventList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEventList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEventList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEventList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEventList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEventList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEventList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.events.v1.EventList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEventList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.events.v1.EventList".

---

### KubeEventListV1Beta1 <a name="KubeEventListV1Beta1" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1"></a>

EventList is a list of Event objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEventListV1Beta1(scope: Construct, id: string, props: KubeEventListV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEventListV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEventListV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.EventList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventListV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventListV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventListV1Beta1.manifest(props: KubeEventListV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.EventList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEventListV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.EventList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEventListV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.EventList".

---

### KubeEventV1Beta1 <a name="KubeEventV1Beta1" id="cdk8s-metaflow.k8s.KubeEventV1Beta1"></a>

Event is a report of an event somewhere in the cluster.

It generally denotes some state change in the system. Events have a limited retention time and triggers and messages may evolve with time.  Event consumers should not rely on the timing of an event with a given Reason reflecting a consistent underlying trigger, or the continued existence of events with that Reason.  Events should be treated as informative, best-effort, supplemental data.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEventV1Beta1(scope: Construct, id: string, props: KubeEventV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEventV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEventV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.Event". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEventV1Beta1.manifest(props: KubeEventV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.events.v1beta1.Event".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEventV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEventV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.Event". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEventV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.events.v1beta1.Event".

---

### KubeEviction <a name="KubeEviction" id="cdk8s-metaflow.k8s.KubeEviction"></a>

Eviction evicts a pod from its node subject to certain policies and safety constraints.

This is a subresource of Pod.  A request to cause such an eviction is created by POSTing to .../pods/<pod name>/evictions.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeEviction.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeEviction(scope: Construct, id: string, props?: KubeEvictionProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeEvictionProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeEviction.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeEviction.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEviction.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEvictionProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeEviction.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeEviction.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeEviction.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeEviction.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeEviction.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeEviction.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.policy.v1.Eviction". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeEviction.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEviction.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeEviction.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeEviction.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEviction.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeEviction.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeEviction.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeEviction.manifest(props?: KubeEvictionProps)
```

Renders a Kubernetes manifest for "io.k8s.api.policy.v1.Eviction".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeEviction.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeEvictionProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeEviction.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeEviction.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeEviction.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeEviction.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeEviction.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeEviction.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeEviction.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeEviction.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1.Eviction". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeEviction.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.policy.v1.Eviction".

---

### KubeFlowSchemaListV1Beta1 <a name="KubeFlowSchemaListV1Beta1" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1"></a>

FlowSchemaList is a list of FlowSchema objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeFlowSchemaListV1Beta1(scope: Construct, id: string, props: KubeFlowSchemaListV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta1.FlowSchemaList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeFlowSchemaListV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeFlowSchemaListV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeFlowSchemaListV1Beta1.manifest(props: KubeFlowSchemaListV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta1.FlowSchemaList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta1.FlowSchemaList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeFlowSchemaListV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta1.FlowSchemaList".

---

### KubeFlowSchemaV1Beta1 <a name="KubeFlowSchemaV1Beta1" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1"></a>

FlowSchema defines the schema of a group of flows.

Note that a flow is made up of a set of inbound API requests with similar attributes and is identified by a pair of strings: the name of the FlowSchema and a "flow distinguisher".

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeFlowSchemaV1Beta1(scope: Construct, id: string, props?: KubeFlowSchemaV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta1.FlowSchema". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeFlowSchemaV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeFlowSchemaV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeFlowSchemaV1Beta1.manifest(props?: KubeFlowSchemaV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.flowcontrol.v1beta1.FlowSchema".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta1.FlowSchema". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeFlowSchemaV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.flowcontrol.v1beta1.FlowSchema".

---

### KubeHorizontalPodAutoscaler <a name="KubeHorizontalPodAutoscaler" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler"></a>

configuration of a horizontal pod autoscaler.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeHorizontalPodAutoscaler(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscaler.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscaler.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscaler.manifest(props?: KubeHorizontalPodAutoscalerProps)
```

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscaler.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscaler".

---

### KubeHorizontalPodAutoscalerList <a name="KubeHorizontalPodAutoscalerList" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList"></a>

list of horizontal pod autoscaler objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeHorizontalPodAutoscalerList(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerList.manifest(props: KubeHorizontalPodAutoscalerListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.autoscaling.v1.HorizontalPodAutoscalerList".

---

### KubeHorizontalPodAutoscalerListV2Beta1 <a name="KubeHorizontalPodAutoscalerListV2Beta1" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1"></a>

HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeHorizontalPodAutoscalerListV2Beta1(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListV2Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerListV2Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerListV2Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerListV2Beta1.manifest(props: KubeHorizontalPodAutoscalerListV2Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscalerList".

---

### KubeHorizontalPodAutoscalerListV2Beta2 <a name="KubeHorizontalPodAutoscalerListV2Beta2" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2"></a>

HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeHorizontalPodAutoscalerListV2Beta2(scope: Construct, id: string, props: KubeHorizontalPodAutoscalerListV2Beta2Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerListV2Beta2.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerListV2Beta2.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerListV2Beta2.manifest(props: KubeHorizontalPodAutoscalerListV2Beta2Props)
```

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerListV2Beta2.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscalerList".

---

### KubeHorizontalPodAutoscalerV2Beta1 <a name="KubeHorizontalPodAutoscalerV2Beta1" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1"></a>

HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeHorizontalPodAutoscalerV2Beta1(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerV2Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerV2Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerV2Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerV2Beta1.manifest(props?: KubeHorizontalPodAutoscalerV2Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta1.HorizontalPodAutoscaler".

---

### KubeHorizontalPodAutoscalerV2Beta2 <a name="KubeHorizontalPodAutoscalerV2Beta2" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2"></a>

HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeHorizontalPodAutoscalerV2Beta2(scope: Construct, id: string, props?: KubeHorizontalPodAutoscalerV2Beta2Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerV2Beta2.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerV2Beta2.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeHorizontalPodAutoscalerV2Beta2.manifest(props?: KubeHorizontalPodAutoscalerV2Beta2Props)
```

Renders a Kubernetes manifest for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeHorizontalPodAutoscalerV2Beta2.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.autoscaling.v2beta2.HorizontalPodAutoscaler".

---

### KubeIngress <a name="KubeIngress" id="cdk8s-metaflow.k8s.KubeIngress"></a>

Ingress is a collection of rules that allow inbound connections to reach the endpoints defined by a backend.

An Ingress can be configured to give services externally-reachable urls, load balance traffic, terminate SSL, offer name based virtual hosting etc.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeIngress.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeIngress(scope: Construct, id: string, props?: KubeIngressProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeIngressProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeIngress.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeIngress.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeIngress.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeIngressProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeIngress.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeIngress.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeIngress.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeIngress.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeIngress.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeIngress.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.networking.v1.Ingress". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeIngress.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngress.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeIngress.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeIngress.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngress.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeIngress.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeIngress.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngress.manifest(props?: KubeIngressProps)
```

Renders a Kubernetes manifest for "io.k8s.api.networking.v1.Ingress".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeIngress.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeIngressProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeIngress.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeIngress.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeIngress.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeIngress.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeIngress.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeIngress.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeIngress.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngress.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1.Ingress". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeIngress.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.networking.v1.Ingress".

---

### KubeIngressClass <a name="KubeIngressClass" id="cdk8s-metaflow.k8s.KubeIngressClass"></a>

IngressClass represents the class of the Ingress, referenced by the Ingress Spec.

The `ingressclass.kubernetes.io/is-default-class` annotation can be used to indicate that an IngressClass should be considered default. When a single IngressClass resource has this annotation set to true, new Ingress resources without a class specified will be assigned this default class.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeIngressClass.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeIngressClass(scope: Construct, id: string, props?: KubeIngressClassProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeIngressClassProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeIngressClass.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeIngressClass.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeIngressClass.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeIngressClassProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeIngressClass.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeIngressClass.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeIngressClass.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeIngressClass.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeIngressClass.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeIngressClass.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressClass". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeIngressClass.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressClass.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeIngressClass.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeIngressClass.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressClass.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeIngressClass.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeIngressClass.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressClass.manifest(props?: KubeIngressClassProps)
```

Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeIngressClass.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeIngressClassProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeIngressClass.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeIngressClass.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeIngressClass.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeIngressClass.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeIngressClass.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeIngressClass.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeIngressClass.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClass.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressClass". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeIngressClass.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressClass".

---

### KubeIngressClassList <a name="KubeIngressClassList" id="cdk8s-metaflow.k8s.KubeIngressClassList"></a>

IngressClassList is a collection of IngressClasses.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeIngressClassList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeIngressClassList(scope: Construct, id: string, props: KubeIngressClassListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeIngressClassListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeIngressClassList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeIngressClassList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeIngressClassList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeIngressClassListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeIngressClassList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeIngressClassList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeIngressClassList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeIngressClassList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeIngressClassList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeIngressClassList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressClassList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeIngressClassList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressClassList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeIngressClassList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeIngressClassList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressClassList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeIngressClassList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeIngressClassList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressClassList.manifest(props: KubeIngressClassListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeIngressClassList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeIngressClassListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeIngressClassList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeIngressClassList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeIngressClassList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeIngressClassList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeIngressClassList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeIngressClassList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeIngressClassList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressClassList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressClassList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeIngressClassList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressClassList".

---

### KubeIngressList <a name="KubeIngressList" id="cdk8s-metaflow.k8s.KubeIngressList"></a>

IngressList is a collection of Ingress.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeIngressList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeIngressList(scope: Construct, id: string, props: KubeIngressListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeIngressListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeIngressList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeIngressList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeIngressList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeIngressListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeIngressList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeIngressList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeIngressList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeIngressList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeIngressList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeIngressList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeIngressList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeIngressList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeIngressList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeIngressList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeIngressList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeIngressList.manifest(props: KubeIngressListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.networking.v1.IngressList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeIngressList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeIngressListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeIngressList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeIngressList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeIngressList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeIngressList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeIngressList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeIngressList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeIngressList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeIngressList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeIngressList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.networking.v1.IngressList".

---

### KubeJob <a name="KubeJob" id="cdk8s-metaflow.k8s.KubeJob"></a>

Job represents the configuration of a single job.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeJob.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeJob(scope: Construct, id: string, props?: KubeJobProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeJobProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeJob.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeJob.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeJob.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeJobProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeJob.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeJob.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeJob.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeJob.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeJob.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeJob.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.batch.v1.Job". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeJob.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeJob.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeJob.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeJob.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeJob.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeJob.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeJob.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeJob.manifest(props?: KubeJobProps)
```

Renders a Kubernetes manifest for "io.k8s.api.batch.v1.Job".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeJob.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeJobProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeJob.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeJob.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeJob.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeJob.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeJob.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeJob.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeJob.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJob.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1.Job". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeJob.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.batch.v1.Job".

---

### KubeJobList <a name="KubeJobList" id="cdk8s-metaflow.k8s.KubeJobList"></a>

JobList is a collection of jobs.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeJobList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeJobList(scope: Construct, id: string, props: KubeJobListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeJobListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeJobList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeJobList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeJobList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeJobListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeJobList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeJobList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeJobList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeJobList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeJobList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeJobList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.batch.v1.JobList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeJobList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeJobList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeJobList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeJobList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeJobList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeJobList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeJobList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeJobList.manifest(props: KubeJobListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.batch.v1.JobList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeJobList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeJobListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeJobList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeJobList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeJobList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeJobList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeJobList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeJobList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeJobList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeJobList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.batch.v1.JobList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeJobList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.batch.v1.JobList".

---

### KubeLease <a name="KubeLease" id="cdk8s-metaflow.k8s.KubeLease"></a>

Lease defines a lease concept.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeLease.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeLease(scope: Construct, id: string, props?: KubeLeaseProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeLeaseProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeLease.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeLease.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLease.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLeaseProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeLease.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeLease.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeLease.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeLease.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeLease.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeLease.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.Lease". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeLease.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLease.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeLease.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeLease.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLease.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeLease.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeLease.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLease.manifest(props?: KubeLeaseProps)
```

Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.Lease".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLease.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLeaseProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeLease.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeLease.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeLease.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeLease.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeLease.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeLease.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeLease.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLease.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.coordination.v1.Lease". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeLease.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.coordination.v1.Lease".

---

### KubeLeaseList <a name="KubeLeaseList" id="cdk8s-metaflow.k8s.KubeLeaseList"></a>

LeaseList is a list of Lease objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeLeaseList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeLeaseList(scope: Construct, id: string, props: KubeLeaseListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeLeaseListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeLeaseList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeLeaseList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLeaseList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLeaseListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeLeaseList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeLeaseList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeLeaseList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeLeaseList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeLeaseList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeLeaseList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.LeaseList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeLeaseList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLeaseList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeLeaseList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeLeaseList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLeaseList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeLeaseList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeLeaseList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLeaseList.manifest(props: KubeLeaseListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.coordination.v1.LeaseList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLeaseList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLeaseListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeLeaseList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeLeaseList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeLeaseList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeLeaseList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeLeaseList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeLeaseList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeLeaseList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLeaseList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.coordination.v1.LeaseList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeLeaseList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.coordination.v1.LeaseList".

---

### KubeLimitRange <a name="KubeLimitRange" id="cdk8s-metaflow.k8s.KubeLimitRange"></a>

LimitRange sets resource usage limits for each kind of resource in a Namespace.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeLimitRange.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeLimitRange(scope: Construct, id: string, props?: KubeLimitRangeProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeLimitRangeProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeLimitRange.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeLimitRange.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLimitRange.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLimitRangeProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeLimitRange.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeLimitRange.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeLimitRange.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeLimitRange.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeLimitRange.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeLimitRange.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRange". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeLimitRange.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLimitRange.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeLimitRange.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeLimitRange.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLimitRange.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeLimitRange.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeLimitRange.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLimitRange.manifest(props?: KubeLimitRangeProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRange".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLimitRange.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLimitRangeProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeLimitRange.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeLimitRange.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeLimitRange.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeLimitRange.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeLimitRange.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeLimitRange.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeLimitRange.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRange.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRange". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeLimitRange.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRange".

---

### KubeLimitRangeList <a name="KubeLimitRangeList" id="cdk8s-metaflow.k8s.KubeLimitRangeList"></a>

LimitRangeList is a list of LimitRange items.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeLimitRangeList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeLimitRangeList(scope: Construct, id: string, props: KubeLimitRangeListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeLimitRangeListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeLimitRangeList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeLimitRangeList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLimitRangeList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLimitRangeListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeLimitRangeList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeLimitRangeList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeLimitRangeList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeLimitRangeList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeLimitRangeList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeLimitRangeList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRangeList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeLimitRangeList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLimitRangeList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeLimitRangeList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeLimitRangeList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLimitRangeList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeLimitRangeList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeLimitRangeList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLimitRangeList.manifest(props: KubeLimitRangeListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.LimitRangeList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLimitRangeList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLimitRangeListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeLimitRangeList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeLimitRangeList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeLimitRangeList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeLimitRangeList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeLimitRangeList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeLimitRangeList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeLimitRangeList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLimitRangeList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRangeList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeLimitRangeList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.LimitRangeList".

---

### KubeLocalSubjectAccessReview <a name="KubeLocalSubjectAccessReview" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview"></a>

LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace.

Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeLocalSubjectAccessReview(scope: Construct, id: string, props: KubeLocalSubjectAccessReviewProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeLocalSubjectAccessReviewProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLocalSubjectAccessReviewProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.LocalSubjectAccessReview". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLocalSubjectAccessReview.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLocalSubjectAccessReview.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeLocalSubjectAccessReview.manifest(props: KubeLocalSubjectAccessReviewProps)
```

Renders a Kubernetes manifest for "io.k8s.api.authorization.v1.LocalSubjectAccessReview".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeLocalSubjectAccessReviewProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.authorization.v1.LocalSubjectAccessReview". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeLocalSubjectAccessReview.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.authorization.v1.LocalSubjectAccessReview".

---

### KubeMutatingWebhookConfiguration <a name="KubeMutatingWebhookConfiguration" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration"></a>

MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeMutatingWebhookConfiguration(scope: Construct, id: string, props?: KubeMutatingWebhookConfigurationProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeMutatingWebhookConfiguration.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeMutatingWebhookConfiguration.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeMutatingWebhookConfiguration.manifest(props?: KubeMutatingWebhookConfigurationProps)
```

Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfiguration.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration".

---

### KubeMutatingWebhookConfigurationList <a name="KubeMutatingWebhookConfigurationList" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList"></a>

MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeMutatingWebhookConfigurationList(scope: Construct, id: string, props: KubeMutatingWebhookConfigurationListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeMutatingWebhookConfigurationList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeMutatingWebhookConfigurationList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeMutatingWebhookConfigurationList.manifest(props: KubeMutatingWebhookConfigurationListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeMutatingWebhookConfigurationList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.admissionregistration.v1.MutatingWebhookConfigurationList".

---

### KubeNamespace <a name="KubeNamespace" id="cdk8s-metaflow.k8s.KubeNamespace"></a>

Namespace provides a scope for Names.

Use of multiple namespaces is optional.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeNamespace.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeNamespace(scope: Construct, id: string, props?: KubeNamespaceProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeNamespaceProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeNamespace.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeNamespace.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNamespace.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNamespaceProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeNamespace.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeNamespace.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeNamespace.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeNamespace.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeNamespace.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeNamespace.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.Namespace". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeNamespace.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNamespace.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeNamespace.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeNamespace.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNamespace.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeNamespace.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeNamespace.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNamespace.manifest(props?: KubeNamespaceProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Namespace".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNamespace.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNamespaceProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeNamespace.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeNamespace.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeNamespace.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeNamespace.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeNamespace.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeNamespace.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeNamespace.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespace.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Namespace". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeNamespace.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.Namespace".

---

### KubeNamespaceList <a name="KubeNamespaceList" id="cdk8s-metaflow.k8s.KubeNamespaceList"></a>

NamespaceList is a list of Namespaces.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeNamespaceList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeNamespaceList(scope: Construct, id: string, props: KubeNamespaceListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeNamespaceListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeNamespaceList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeNamespaceList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNamespaceList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNamespaceListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeNamespaceList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeNamespaceList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeNamespaceList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeNamespaceList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeNamespaceList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeNamespaceList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.NamespaceList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeNamespaceList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNamespaceList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeNamespaceList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeNamespaceList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNamespaceList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeNamespaceList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeNamespaceList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNamespaceList.manifest(props: KubeNamespaceListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.NamespaceList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNamespaceList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNamespaceListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeNamespaceList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeNamespaceList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeNamespaceList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeNamespaceList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeNamespaceList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeNamespaceList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeNamespaceList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNamespaceList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.NamespaceList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeNamespaceList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.NamespaceList".

---

### KubeNetworkPolicy <a name="KubeNetworkPolicy" id="cdk8s-metaflow.k8s.KubeNetworkPolicy"></a>

NetworkPolicy describes what network traffic is allowed for a set of Pods.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeNetworkPolicy(scope: Construct, id: string, props?: KubeNetworkPolicyProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeNetworkPolicyProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNetworkPolicyProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicy". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNetworkPolicy.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNetworkPolicy.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNetworkPolicy.manifest(props?: KubeNetworkPolicyProps)
```

Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicy".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNetworkPolicyProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicy.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicy". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeNetworkPolicy.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicy".

---

### KubeNetworkPolicyList <a name="KubeNetworkPolicyList" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList"></a>

NetworkPolicyList is a list of NetworkPolicy objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeNetworkPolicyList(scope: Construct, id: string, props: KubeNetworkPolicyListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeNetworkPolicyListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNetworkPolicyListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicyList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNetworkPolicyList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNetworkPolicyList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNetworkPolicyList.manifest(props: KubeNetworkPolicyListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.networking.v1.NetworkPolicyList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNetworkPolicyListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicyList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeNetworkPolicyList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.networking.v1.NetworkPolicyList".

---

### KubeNode <a name="KubeNode" id="cdk8s-metaflow.k8s.KubeNode"></a>

Node is a worker node in Kubernetes.

Each node will have a unique identifier in the cache (i.e. in etcd).

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeNode.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeNode(scope: Construct, id: string, props?: KubeNodeProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeNodeProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeNode.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeNode.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNode.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNodeProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeNode.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeNode.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeNode.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeNode.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeNode.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeNode.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.Node". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeNode.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNode.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeNode.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeNode.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNode.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeNode.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeNode.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNode.manifest(props?: KubeNodeProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Node".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNode.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNodeProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeNode.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeNode.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeNode.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeNode.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeNode.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeNode.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeNode.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNode.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Node". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeNode.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.Node".

---

### KubeNodeList <a name="KubeNodeList" id="cdk8s-metaflow.k8s.KubeNodeList"></a>

NodeList is the whole list of all Nodes which have been registered with master.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubeNodeList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubeNodeList(scope: Construct, id: string, props: KubeNodeListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubeNodeListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubeNodeList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubeNodeList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNodeList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNodeListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubeNodeList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubeNodeList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubeNodeList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubeNodeList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubeNodeList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubeNodeList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.NodeList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubeNodeList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNodeList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubeNodeList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubeNodeList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNodeList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubeNodeList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubeNodeList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubeNodeList.manifest(props: KubeNodeListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.NodeList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubeNodeList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubeNodeListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubeNodeList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubeNodeList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubeNodeList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubeNodeList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubeNodeList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubeNodeList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubeNodeList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubeNodeList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.NodeList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubeNodeList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.NodeList".

---

### KubePersistentVolume <a name="KubePersistentVolume" id="cdk8s-metaflow.k8s.KubePersistentVolume"></a>

PersistentVolume (PV) is a storage resource provisioned by an administrator.

It is analogous to a node. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePersistentVolume.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePersistentVolume(scope: Construct, id: string, props?: KubePersistentVolumeProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePersistentVolumeProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePersistentVolume.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePersistentVolume.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePersistentVolume.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePersistentVolumeProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePersistentVolume.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePersistentVolume.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePersistentVolume.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePersistentVolume.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePersistentVolume.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePersistentVolume.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolume". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePersistentVolume.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolume.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePersistentVolume.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePersistentVolume.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolume.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePersistentVolume.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePersistentVolume.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolume.manifest(props?: KubePersistentVolumeProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolume".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePersistentVolume.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePersistentVolumeProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePersistentVolume.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePersistentVolume.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePersistentVolume.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePersistentVolume.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePersistentVolume.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePersistentVolume.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePersistentVolume.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolume.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolume". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePersistentVolume.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolume".

---

### KubePersistentVolumeClaim <a name="KubePersistentVolumeClaim" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim"></a>

PersistentVolumeClaim is a user's request for and claim to a persistent volume.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePersistentVolumeClaim(scope: Construct, id: string, props?: KubePersistentVolumeClaimProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePersistentVolumeClaimProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePersistentVolumeClaimProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaim". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeClaim.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeClaim.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeClaim.manifest(props?: KubePersistentVolumeClaimProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaim".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePersistentVolumeClaimProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaim". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaim.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaim".

---

### KubePersistentVolumeClaimList <a name="KubePersistentVolumeClaimList" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList"></a>

PersistentVolumeClaimList is a list of PersistentVolumeClaim items.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePersistentVolumeClaimList(scope: Construct, id: string, props: KubePersistentVolumeClaimListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePersistentVolumeClaimListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePersistentVolumeClaimListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaimList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeClaimList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeClaimList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeClaimList.manifest(props: KubePersistentVolumeClaimListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeClaimList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePersistentVolumeClaimListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaimList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePersistentVolumeClaimList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeClaimList".

---

### KubePersistentVolumeList <a name="KubePersistentVolumeList" id="cdk8s-metaflow.k8s.KubePersistentVolumeList"></a>

PersistentVolumeList is a list of PersistentVolume items.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePersistentVolumeList(scope: Construct, id: string, props: KubePersistentVolumeListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePersistentVolumeListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePersistentVolumeListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePersistentVolumeList.manifest(props: KubePersistentVolumeListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PersistentVolumeList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePersistentVolumeListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePersistentVolumeList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePersistentVolumeList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.PersistentVolumeList".

---

### KubePod <a name="KubePod" id="cdk8s-metaflow.k8s.KubePod"></a>

Pod is a collection of containers that can run on a host.

This resource is created by clients and scheduled onto hosts.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePod.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePod(scope: Construct, id: string, props?: KubePodProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePod.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePod.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePod.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePod.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePod.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePod.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePod.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePod.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePod.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.Pod". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePod.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePod.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePod.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePod.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePod.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePod.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePod.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePod.manifest(props?: KubePodProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.Pod".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePod.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePod.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePod.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePod.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePod.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePod.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePod.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePod.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePod.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.Pod". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePod.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.Pod".

---

### KubePodDisruptionBudget <a name="KubePodDisruptionBudget" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget"></a>

PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodDisruptionBudget(scope: Construct, id: string, props?: KubePodDisruptionBudgetProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodDisruptionBudgetProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodDisruptionBudgetProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.policy.v1.PodDisruptionBudget". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudget.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudget.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudget.manifest(props?: KubePodDisruptionBudgetProps)
```

Renders a Kubernetes manifest for "io.k8s.api.policy.v1.PodDisruptionBudget".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodDisruptionBudgetProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1.PodDisruptionBudget". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodDisruptionBudget.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.policy.v1.PodDisruptionBudget".

---

### KubePodDisruptionBudgetList <a name="KubePodDisruptionBudgetList" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList"></a>

PodDisruptionBudgetList is a collection of PodDisruptionBudgets.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodDisruptionBudgetList(scope: Construct, id: string, props: KubePodDisruptionBudgetListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodDisruptionBudgetListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodDisruptionBudgetListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.policy.v1.PodDisruptionBudgetList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetList.manifest(props: KubePodDisruptionBudgetListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.policy.v1.PodDisruptionBudgetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodDisruptionBudgetListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1.PodDisruptionBudgetList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.policy.v1.PodDisruptionBudgetList".

---

### KubePodDisruptionBudgetListV1Beta1 <a name="KubePodDisruptionBudgetListV1Beta1" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1"></a>

PodDisruptionBudgetList is a collection of PodDisruptionBudgets.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodDisruptionBudgetListV1Beta1(scope: Construct, id: string, props: KubePodDisruptionBudgetListV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetListV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetListV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetListV1Beta1.manifest(props: KubePodDisruptionBudgetListV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetListV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudgetList".

---

### KubePodDisruptionBudgetV1Beta1 <a name="KubePodDisruptionBudgetV1Beta1" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1"></a>

PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodDisruptionBudgetV1Beta1(scope: Construct, id: string, props?: KubePodDisruptionBudgetV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudget". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodDisruptionBudgetV1Beta1.manifest(props?: KubePodDisruptionBudgetV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodDisruptionBudget".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudget". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodDisruptionBudgetV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodDisruptionBudget".

---

### KubePodList <a name="KubePodList" id="cdk8s-metaflow.k8s.KubePodList"></a>

PodList is a list of Pods.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodList(scope: Construct, id: string, props: KubePodListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodList.manifest(props: KubePodListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PodList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.PodList".

---

### KubePodSecurityPolicyListV1Beta1 <a name="KubePodSecurityPolicyListV1Beta1" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1"></a>

PodSecurityPolicyList is a list of PodSecurityPolicy objects.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodSecurityPolicyListV1Beta1(scope: Construct, id: string, props: KubePodSecurityPolicyListV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodSecurityPolicyListV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodSecurityPolicyListV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodSecurityPolicyListV1Beta1.manifest(props: KubePodSecurityPolicyListV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyListV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicyList".

---

### KubePodSecurityPolicyV1Beta1 <a name="KubePodSecurityPolicyV1Beta1" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1"></a>

PodSecurityPolicy governs the ability to make requests that affect the Security Context that will be applied to a pod and container.

Deprecated in 1.21.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodSecurityPolicyV1Beta1(scope: Construct, id: string, props?: KubePodSecurityPolicyV1Beta1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicy". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodSecurityPolicyV1Beta1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodSecurityPolicyV1Beta1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodSecurityPolicyV1Beta1.manifest(props?: KubePodSecurityPolicyV1Beta1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.policy.v1beta1.PodSecurityPolicy".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicy". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodSecurityPolicyV1Beta1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.policy.v1beta1.PodSecurityPolicy".

---

### KubePodTemplate <a name="KubePodTemplate" id="cdk8s-metaflow.k8s.KubePodTemplate"></a>

PodTemplate describes a template for creating copies of a predefined pod.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodTemplate.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodTemplate(scope: Construct, id: string, props?: KubePodTemplateProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodTemplateProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodTemplate.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodTemplate.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodTemplate.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodTemplateProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodTemplate.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodTemplate.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodTemplate.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodTemplate.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodTemplate.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodTemplate.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplate". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodTemplate.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodTemplate.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodTemplate.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodTemplate.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodTemplate.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodTemplate.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodTemplate.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodTemplate.manifest(props?: KubePodTemplateProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplate".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Optional</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodTemplate.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodTemplateProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodTemplate.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodTemplate.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodTemplate.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodTemplate.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodTemplate.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodTemplate.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodTemplate.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplate.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplate". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodTemplate.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplate".

---

### KubePodTemplateList <a name="KubePodTemplateList" id="cdk8s-metaflow.k8s.KubePodTemplateList"></a>

PodTemplateList is a list of PodTemplates.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePodTemplateList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePodTemplateList(scope: Construct, id: string, props: KubePodTemplateListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePodTemplateListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePodTemplateList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePodTemplateList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodTemplateList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodTemplateListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePodTemplateList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePodTemplateList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePodTemplateList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePodTemplateList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePodTemplateList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePodTemplateList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplateList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePodTemplateList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodTemplateList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePodTemplateList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePodTemplateList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodTemplateList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePodTemplateList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePodTemplateList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePodTemplateList.manifest(props: KubePodTemplateListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.core.v1.PodTemplateList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePodTemplateList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePodTemplateListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePodTemplateList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePodTemplateList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePodTemplateList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePodTemplateList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePodTemplateList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePodTemplateList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePodTemplateList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePodTemplateList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplateList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePodTemplateList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.core.v1.PodTemplateList".

---

### KubePriorityClass <a name="KubePriorityClass" id="cdk8s-metaflow.k8s.KubePriorityClass"></a>

PriorityClass defines mapping from a priority class name to the priority integer value.

The value can be any valid integer.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePriorityClass.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePriorityClass(scope: Construct, id: string, props: KubePriorityClassProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePriorityClassProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePriorityClass.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePriorityClass.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePriorityClass.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePriorityClassProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePriorityClass.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePriorityClass.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePriorityClass.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePriorityClass.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePriorityClass.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePriorityClass.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClass". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePriorityClass.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClass.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePriorityClass.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePriorityClass.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClass.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePriorityClass.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePriorityClass.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClass.manifest(props: KubePriorityClassProps)
```

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePriorityClass.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePriorityClassProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePriorityClass.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePriorityClass.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePriorityClass.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePriorityClass.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePriorityClass.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePriorityClass.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePriorityClass.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClass.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClass". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePriorityClass.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClass".

---

### KubePriorityClassList <a name="KubePriorityClassList" id="cdk8s-metaflow.k8s.KubePriorityClassList"></a>

PriorityClassList is a collection of priority classes.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePriorityClassList.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePriorityClassList(scope: Construct, id: string, props: KubePriorityClassListProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePriorityClassListProps</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePriorityClassList.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePriorityClassList.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePriorityClassList.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePriorityClassListProps

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePriorityClassList.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePriorityClassList.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePriorityClassList.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePriorityClassList.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePriorityClassList.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePriorityClassList.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClassList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePriorityClassList.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassList.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePriorityClassList.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePriorityClassList.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassList.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePriorityClassList.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePriorityClassList.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassList.manifest(props: KubePriorityClassListProps)
```

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1.PriorityClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePriorityClassList.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePriorityClassListProps

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePriorityClassList.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePriorityClassList.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePriorityClassList.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePriorityClassList.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePriorityClassList.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePriorityClassList.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePriorityClassList.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassList.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClassList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePriorityClassList.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.scheduling.v1.PriorityClassList".

---

### KubePriorityClassListV1Alpha1 <a name="KubePriorityClassListV1Alpha1" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1"></a>

PriorityClassList is a collection of priority classes.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePriorityClassListV1Alpha1(scope: Construct, id: string, props: KubePriorityClassListV1Alpha1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1alpha1.PriorityClassList". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassListV1Alpha1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassListV1Alpha1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassListV1Alpha1.manifest(props: KubePriorityClassListV1Alpha1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1alpha1.PriorityClassList".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.apiVersion">apiVersion</a></code> | <code>string</code> | The object's API version (e.g. `authorization.k8s.io/v1`). |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.chart">chart</a></code> | <code>cdk8s.Chart</code> | The chart in which this object is defined. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.kind">kind</a></code> | <code>string</code> | The object kind. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.metadata">metadata</a></code> | <code>cdk8s.ApiObjectMetadataDefinition</code> | Metadata associated with this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.name">name</a></code> | <code>string</code> | The name of the API object. |

---

##### `node`<sup>Required</sup> <a name="node" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGroup`<sup>Required</sup> <a name="apiGroup" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.apiGroup"></a>

```typescript
public readonly apiGroup: string;
```

- *Type:* string

The group portion of the API version (e.g. `authorization.k8s.io`).

---

##### `apiVersion`<sup>Required</sup> <a name="apiVersion" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.apiVersion"></a>

```typescript
public readonly apiVersion: string;
```

- *Type:* string

The object's API version (e.g. `authorization.k8s.io/v1`).

---

##### `chart`<sup>Required</sup> <a name="chart" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.chart"></a>

```typescript
public readonly chart: Chart;
```

- *Type:* cdk8s.Chart

The chart in which this object is defined.

---

##### `kind`<sup>Required</sup> <a name="kind" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.kind"></a>

```typescript
public readonly kind: string;
```

- *Type:* string

The object kind.

---

##### `metadata`<sup>Required</sup> <a name="metadata" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.metadata"></a>

```typescript
public readonly metadata: ApiObjectMetadataDefinition;
```

- *Type:* cdk8s.ApiObjectMetadataDefinition

Metadata associated with this API object.

---

##### `name`<sup>Required</sup> <a name="name" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.name"></a>

```typescript
public readonly name: string;
```

- *Type:* string

The name of the API object.

If a name is specified in `metadata.name` this will be the name returned.
Otherwise, a name will be generated by calling
`Chart.of(this).generatedObjectName(this)`, which by default uses the
construct path to generate a DNS-compatible name for the resource.

---

#### Constants <a name="Constants" id="Constants"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.GVK">GVK</a></code> | <code>cdk8s.GroupVersionKind</code> | Returns the apiVersion and kind for "io.k8s.api.scheduling.v1alpha1.PriorityClassList". |

---

##### `GVK`<sup>Required</sup> <a name="GVK" id="cdk8s-metaflow.k8s.KubePriorityClassListV1Alpha1.property.GVK"></a>

```typescript
public readonly GVK: GroupVersionKind;
```

- *Type:* cdk8s.GroupVersionKind

Returns the apiVersion and kind for "io.k8s.api.scheduling.v1alpha1.PriorityClassList".

---

### KubePriorityClassV1Alpha1 <a name="KubePriorityClassV1Alpha1" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1"></a>

DEPRECATED - This group version of PriorityClass is deprecated by scheduling.k8s.io/v1/PriorityClass. PriorityClass defines mapping from a priority class name to the priority integer value. The value can be any valid integer.

#### Initializers <a name="Initializers" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.Initializer"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

new k8s.KubePriorityClassV1Alpha1(scope: Construct, id: string, props: KubePriorityClassV1Alpha1Props)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | the scope in which to define this object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.Initializer.parameter.id">id</a></code> | <code>string</code> | a scope-local name for the object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.Initializer.parameter.props">props</a></code> | <code>cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1Props</code> | initialization props. |

---

##### `scope`<sup>Required</sup> <a name="scope" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

the scope in which to define this object.

---

##### `id`<sup>Required</sup> <a name="id" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.Initializer.parameter.id"></a>

- *Type:* string

a scope-local name for the object.

---

##### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.Initializer.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1Props

initialization props.

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.addDependency">addDependency</a></code> | Create a dependency between this ApiObject and other constructs. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.addJsonPatch">addJsonPatch</a></code> | Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.toJson">toJson</a></code> | Renders the object to Kubernetes JSON. |

---

##### `toString` <a name="toString" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addDependency` <a name="addDependency" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.addDependency"></a>

```typescript
public addDependency(dependencies: IConstruct): void
```

Create a dependency between this ApiObject and other constructs.

These can be other ApiObjects, Charts, or custom.

###### `dependencies`<sup>Required</sup> <a name="dependencies" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.addDependency.parameter.dependencies"></a>

- *Type:* constructs.IConstruct

the dependencies to add.

---

##### `addJsonPatch` <a name="addJsonPatch" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.addJsonPatch"></a>

```typescript
public addJsonPatch(ops: JsonPatch): void
```

Applies a set of RFC-6902 JSON-Patch operations to the manifest synthesized for this API object.

*Example*

```typescript
  kubePod.addJsonPatch(JsonPatch.replace('/spec/enableServiceLinks', true));
```


###### `ops`<sup>Required</sup> <a name="ops" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.addJsonPatch.parameter.ops"></a>

- *Type:* cdk8s.JsonPatch

The JSON-Patch operations to apply.

---

##### `toJson` <a name="toJson" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.toJson"></a>

```typescript
public toJson(): any
```

Renders the object to Kubernetes JSON.

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.of">of</a></code> | Returns the `ApiObject` named `Resource` which is a child of the given construct. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.manifest">manifest</a></code> | Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1alpha1.PriorityClass". |

---

##### `isConstruct` <a name="isConstruct" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.isConstruct"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassV1Alpha1.isConstruct(x: any)
```

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

###### `x`<sup>Required</sup> <a name="x" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

##### `of` <a name="of" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.of"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassV1Alpha1.of(c: IConstruct)
```

Returns the `ApiObject` named `Resource` which is a child of the given construct.

If `c` is an `ApiObject`, it is returned directly. Throws an
exception if the construct does not have a child named `Default` _or_ if
this child is not an `ApiObject`.

###### `c`<sup>Required</sup> <a name="c" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.of.parameter.c"></a>

- *Type:* constructs.IConstruct

The higher-level construct.

---

##### `manifest` <a name="manifest" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.manifest"></a>

```typescript
import { k8s } from 'cdk8s-metaflow'

k8s.KubePriorityClassV1Alpha1.manifest(props: KubePriorityClassV1Alpha1Props)
```

Renders a Kubernetes manifest for "io.k8s.api.scheduling.v1alpha1.PriorityClass".

This can be used to inline resource manifests inside other objects (e.g. as templates).

###### `props`<sup>Required</sup> <a name="props" id="cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.manifest.parameter.props"></a>

- *Type:* cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1Props

initialization props.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#cdk8s-metaflow.k8s.KubePriorityClassV1Alpha1.property.apiGroup">apiGroup</a></code> | <code>string</code> | The group portion of the API version (e.g. `authorization.k8s.io`). |
|