# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetOrderCartResult',
    'AwaitableGetOrderCartResult',
    'get_order_cart',
    'get_order_cart_output',
]

@pulumi.output_type
class GetOrderCartResult:
    """
    A collection of values returned by getOrderCart.
    """
    def __init__(__self__, cart_id=None, description=None, expire=None, id=None, items=None, ovh_subsidiary=None, read_only=None):
        if cart_id and not isinstance(cart_id, str):
            raise TypeError("Expected argument 'cart_id' to be a str")
        pulumi.set(__self__, "cart_id", cart_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if expire and not isinstance(expire, str):
            raise TypeError("Expected argument 'expire' to be a str")
        pulumi.set(__self__, "expire", expire)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if ovh_subsidiary and not isinstance(ovh_subsidiary, str):
            raise TypeError("Expected argument 'ovh_subsidiary' to be a str")
        pulumi.set(__self__, "ovh_subsidiary", ovh_subsidiary)
        if read_only and not isinstance(read_only, bool):
            raise TypeError("Expected argument 'read_only' to be a bool")
        pulumi.set(__self__, "read_only", read_only)

    @property
    @pulumi.getter(name="cartId")
    def cart_id(self) -> str:
        """
        Cart identifier
        """
        return pulumi.get(self, "cart_id")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expire(self) -> str:
        return pulumi.get(self, "expire")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence[int]:
        """
        Items of your cart
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="ovhSubsidiary")
    def ovh_subsidiary(self) -> str:
        return pulumi.get(self, "ovh_subsidiary")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        Indicates if the cart has already been validated
        """
        return pulumi.get(self, "read_only")


class AwaitableGetOrderCartResult(GetOrderCartResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOrderCartResult(
            cart_id=self.cart_id,
            description=self.description,
            expire=self.expire,
            id=self.id,
            items=self.items,
            ovh_subsidiary=self.ovh_subsidiary,
            read_only=self.read_only)


def get_order_cart(description: Optional[str] = None,
                   expire: Optional[str] = None,
                   ovh_subsidiary: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOrderCartResult:
    """
    Use this data source to create a temporary order cart to retrieve information order cart products.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    mycart = ovh.get_order_cart(description="...",
        ovh_subsidiary="fr")
    ```


    :param str description: Description of your cart
    :param str expire: Expiration time (format: 2006-01-02T15:04:05+00:00)
    :param str ovh_subsidiary: Ovh Subsidiary
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['expire'] = expire
    __args__['ovhSubsidiary'] = ovh_subsidiary
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:index/getOrderCart:getOrderCart', __args__, opts=opts, typ=GetOrderCartResult).value

    return AwaitableGetOrderCartResult(
        cart_id=__ret__.cart_id,
        description=__ret__.description,
        expire=__ret__.expire,
        id=__ret__.id,
        items=__ret__.items,
        ovh_subsidiary=__ret__.ovh_subsidiary,
        read_only=__ret__.read_only)


@_utilities.lift_output_func(get_order_cart)
def get_order_cart_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                          expire: Optional[pulumi.Input[Optional[str]]] = None,
                          ovh_subsidiary: Optional[pulumi.Input[str]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOrderCartResult]:
    """
    Use this data source to create a temporary order cart to retrieve information order cart products.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    mycart = ovh.get_order_cart(description="...",
        ovh_subsidiary="fr")
    ```


    :param str description: Description of your cart
    :param str expire: Expiration time (format: 2006-01-02T15:04:05+00:00)
    :param str ovh_subsidiary: Ovh Subsidiary
    """
    ...
