# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServerInstallTaskArgs', 'ServerInstallTask']

@pulumi.input_type
class ServerInstallTaskArgs:
    def __init__(__self__, *,
                 service_name: pulumi.Input[str],
                 template_name: pulumi.Input[str],
                 bootid_on_destroy: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input['ServerInstallTaskDetailsArgs']] = None,
                 partition_scheme_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ServerInstallTask resource.
        :param pulumi.Input[str] service_name: The service_name of your dedicated server.
        :param pulumi.Input[str] template_name: Template name.
        :param pulumi.Input[int] bootid_on_destroy: If set, reboot the server on the specified boot id during destroy phase.
        :param pulumi.Input['ServerInstallTaskDetailsArgs'] details: see `details` block below.
        :param pulumi.Input[str] partition_scheme_name: Partition scheme name.
        """
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "template_name", template_name)
        if bootid_on_destroy is not None:
            pulumi.set(__self__, "bootid_on_destroy", bootid_on_destroy)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if partition_scheme_name is not None:
            pulumi.set(__self__, "partition_scheme_name", partition_scheme_name)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The service_name of your dedicated server.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[str]:
        """
        Template name.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="bootidOnDestroy")
    def bootid_on_destroy(self) -> Optional[pulumi.Input[int]]:
        """
        If set, reboot the server on the specified boot id during destroy phase.
        """
        return pulumi.get(self, "bootid_on_destroy")

    @bootid_on_destroy.setter
    def bootid_on_destroy(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bootid_on_destroy", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input['ServerInstallTaskDetailsArgs']]:
        """
        see `details` block below.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input['ServerInstallTaskDetailsArgs']]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="partitionSchemeName")
    def partition_scheme_name(self) -> Optional[pulumi.Input[str]]:
        """
        Partition scheme name.
        """
        return pulumi.get(self, "partition_scheme_name")

    @partition_scheme_name.setter
    def partition_scheme_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_scheme_name", value)


@pulumi.input_type
class _ServerInstallTaskState:
    def __init__(__self__, *,
                 bootid_on_destroy: Optional[pulumi.Input[int]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 details: Optional[pulumi.Input['ServerInstallTaskDetailsArgs']] = None,
                 done_date: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 last_update: Optional[pulumi.Input[str]] = None,
                 partition_scheme_name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ServerInstallTask resources.
        :param pulumi.Input[int] bootid_on_destroy: If set, reboot the server on the specified boot id during destroy phase.
        :param pulumi.Input[str] comment: Details of this task. (should be `Install asked`)
        :param pulumi.Input['ServerInstallTaskDetailsArgs'] details: see `details` block below.
        :param pulumi.Input[str] done_date: Completion date in RFC3339 format.
        :param pulumi.Input[str] function: Function name (should be `hardInstall`).
        :param pulumi.Input[str] last_update: Last update in RFC3339 format.
        :param pulumi.Input[str] partition_scheme_name: Partition scheme name.
        :param pulumi.Input[str] service_name: The service_name of your dedicated server.
        :param pulumi.Input[str] start_date: Task creation date in RFC3339 format.
        :param pulumi.Input[str] status: Task status (should be `done`)
        :param pulumi.Input[str] template_name: Template name.
        """
        if bootid_on_destroy is not None:
            pulumi.set(__self__, "bootid_on_destroy", bootid_on_destroy)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if done_date is not None:
            pulumi.set(__self__, "done_date", done_date)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if last_update is not None:
            pulumi.set(__self__, "last_update", last_update)
        if partition_scheme_name is not None:
            pulumi.set(__self__, "partition_scheme_name", partition_scheme_name)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)

    @property
    @pulumi.getter(name="bootidOnDestroy")
    def bootid_on_destroy(self) -> Optional[pulumi.Input[int]]:
        """
        If set, reboot the server on the specified boot id during destroy phase.
        """
        return pulumi.get(self, "bootid_on_destroy")

    @bootid_on_destroy.setter
    def bootid_on_destroy(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bootid_on_destroy", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        Details of this task. (should be `Install asked`)
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input['ServerInstallTaskDetailsArgs']]:
        """
        see `details` block below.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input['ServerInstallTaskDetailsArgs']]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter(name="doneDate")
    def done_date(self) -> Optional[pulumi.Input[str]]:
        """
        Completion date in RFC3339 format.
        """
        return pulumi.get(self, "done_date")

    @done_date.setter
    def done_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "done_date", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        Function name (should be `hardInstall`).
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> Optional[pulumi.Input[str]]:
        """
        Last update in RFC3339 format.
        """
        return pulumi.get(self, "last_update")

    @last_update.setter
    def last_update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update", value)

    @property
    @pulumi.getter(name="partitionSchemeName")
    def partition_scheme_name(self) -> Optional[pulumi.Input[str]]:
        """
        Partition scheme name.
        """
        return pulumi.get(self, "partition_scheme_name")

    @partition_scheme_name.setter
    def partition_scheme_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition_scheme_name", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The service_name of your dedicated server.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[str]]:
        """
        Task creation date in RFC3339 format.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Task status (should be `done`)
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        Template name.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)


class ServerInstallTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootid_on_destroy: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[pulumi.InputType['ServerInstallTaskDetailsArgs']]] = None,
                 partition_scheme_name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh
        import pulumi_ovh as ovh

        rescue = ovh.Dedicated.get_server_boots(service_name="nsxxxxxxx.ip-xx-xx-xx.eu",
            boot_type="rescue")
        key = ovh.me.SshKey("key",
            key_name="mykey",
            key="ssh-ed25519 AAAAC3...")
        debian = ovh.me.InstallationTemplate("debian",
            base_template_name="debian11_64",
            template_name="mydebian11",
            default_language="en",
            customization=ovh.me.InstallationTemplateCustomizationArgs(
                ssh_key_name=key.key_name,
            ))
        server_install = ovh.dedicated.ServerInstallTask("serverInstall",
            service_name="nsxxxxxxx.ip-xx-xx-xx.eu",
            template_name=debian.template_name,
            bootid_on_destroy=rescue.results[0],
            details=ovh.dedicated.ServerInstallTaskDetailsArgs(
                custom_hostname="mytest",
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bootid_on_destroy: If set, reboot the server on the specified boot id during destroy phase.
        :param pulumi.Input[pulumi.InputType['ServerInstallTaskDetailsArgs']] details: see `details` block below.
        :param pulumi.Input[str] partition_scheme_name: Partition scheme name.
        :param pulumi.Input[str] service_name: The service_name of your dedicated server.
        :param pulumi.Input[str] template_name: Template name.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServerInstallTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_pulumi_ovh as ovh
        import pulumi_ovh as ovh

        rescue = ovh.Dedicated.get_server_boots(service_name="nsxxxxxxx.ip-xx-xx-xx.eu",
            boot_type="rescue")
        key = ovh.me.SshKey("key",
            key_name="mykey",
            key="ssh-ed25519 AAAAC3...")
        debian = ovh.me.InstallationTemplate("debian",
            base_template_name="debian11_64",
            template_name="mydebian11",
            default_language="en",
            customization=ovh.me.InstallationTemplateCustomizationArgs(
                ssh_key_name=key.key_name,
            ))
        server_install = ovh.dedicated.ServerInstallTask("serverInstall",
            service_name="nsxxxxxxx.ip-xx-xx-xx.eu",
            template_name=debian.template_name,
            bootid_on_destroy=rescue.results[0],
            details=ovh.dedicated.ServerInstallTaskDetailsArgs(
                custom_hostname="mytest",
            ))
        ```

        :param str resource_name: The name of the resource.
        :param ServerInstallTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServerInstallTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bootid_on_destroy: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[pulumi.InputType['ServerInstallTaskDetailsArgs']]] = None,
                 partition_scheme_name: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServerInstallTaskArgs.__new__(ServerInstallTaskArgs)

            __props__.__dict__["bootid_on_destroy"] = bootid_on_destroy
            __props__.__dict__["details"] = details
            __props__.__dict__["partition_scheme_name"] = partition_scheme_name
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if template_name is None and not opts.urn:
                raise TypeError("Missing required property 'template_name'")
            __props__.__dict__["template_name"] = template_name
            __props__.__dict__["comment"] = None
            __props__.__dict__["done_date"] = None
            __props__.__dict__["function"] = None
            __props__.__dict__["last_update"] = None
            __props__.__dict__["start_date"] = None
            __props__.__dict__["status"] = None
        super(ServerInstallTask, __self__).__init__(
            'ovh:Dedicated/serverInstallTask:ServerInstallTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bootid_on_destroy: Optional[pulumi.Input[int]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            details: Optional[pulumi.Input[pulumi.InputType['ServerInstallTaskDetailsArgs']]] = None,
            done_date: Optional[pulumi.Input[str]] = None,
            function: Optional[pulumi.Input[str]] = None,
            last_update: Optional[pulumi.Input[str]] = None,
            partition_scheme_name: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            start_date: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            template_name: Optional[pulumi.Input[str]] = None) -> 'ServerInstallTask':
        """
        Get an existing ServerInstallTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bootid_on_destroy: If set, reboot the server on the specified boot id during destroy phase.
        :param pulumi.Input[str] comment: Details of this task. (should be `Install asked`)
        :param pulumi.Input[pulumi.InputType['ServerInstallTaskDetailsArgs']] details: see `details` block below.
        :param pulumi.Input[str] done_date: Completion date in RFC3339 format.
        :param pulumi.Input[str] function: Function name (should be `hardInstall`).
        :param pulumi.Input[str] last_update: Last update in RFC3339 format.
        :param pulumi.Input[str] partition_scheme_name: Partition scheme name.
        :param pulumi.Input[str] service_name: The service_name of your dedicated server.
        :param pulumi.Input[str] start_date: Task creation date in RFC3339 format.
        :param pulumi.Input[str] status: Task status (should be `done`)
        :param pulumi.Input[str] template_name: Template name.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServerInstallTaskState.__new__(_ServerInstallTaskState)

        __props__.__dict__["bootid_on_destroy"] = bootid_on_destroy
        __props__.__dict__["comment"] = comment
        __props__.__dict__["details"] = details
        __props__.__dict__["done_date"] = done_date
        __props__.__dict__["function"] = function
        __props__.__dict__["last_update"] = last_update
        __props__.__dict__["partition_scheme_name"] = partition_scheme_name
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["start_date"] = start_date
        __props__.__dict__["status"] = status
        __props__.__dict__["template_name"] = template_name
        return ServerInstallTask(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bootidOnDestroy")
    def bootid_on_destroy(self) -> pulumi.Output[Optional[int]]:
        """
        If set, reboot the server on the specified boot id during destroy phase.
        """
        return pulumi.get(self, "bootid_on_destroy")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[str]:
        """
        Details of this task. (should be `Install asked`)
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter
    def details(self) -> pulumi.Output[Optional['outputs.ServerInstallTaskDetails']]:
        """
        see `details` block below.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter(name="doneDate")
    def done_date(self) -> pulumi.Output[str]:
        """
        Completion date in RFC3339 format.
        """
        return pulumi.get(self, "done_date")

    @property
    @pulumi.getter
    def function(self) -> pulumi.Output[str]:
        """
        Function name (should be `hardInstall`).
        """
        return pulumi.get(self, "function")

    @property
    @pulumi.getter(name="lastUpdate")
    def last_update(self) -> pulumi.Output[str]:
        """
        Last update in RFC3339 format.
        """
        return pulumi.get(self, "last_update")

    @property
    @pulumi.getter(name="partitionSchemeName")
    def partition_scheme_name(self) -> pulumi.Output[Optional[str]]:
        """
        Partition scheme name.
        """
        return pulumi.get(self, "partition_scheme_name")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The service_name of your dedicated server.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output[str]:
        """
        Task creation date in RFC3339 format.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Task status (should be `done`)
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[str]:
        """
        Template name.
        """
        return pulumi.get(self, "template_name")

