# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['LogsOutputGraylogStreamArgs', 'LogsOutputGraylogStream']

@pulumi.input_type
class LogsOutputGraylogStreamArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 title: pulumi.Input[str],
                 cold_storage_compression: Optional[pulumi.Input[str]] = None,
                 cold_storage_content: Optional[pulumi.Input[str]] = None,
                 cold_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 cold_storage_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 cold_storage_retention: Optional[pulumi.Input[int]] = None,
                 cold_storage_target: Optional[pulumi.Input[str]] = None,
                 indexing_enabled: Optional[pulumi.Input[bool]] = None,
                 indexing_max_size: Optional[pulumi.Input[int]] = None,
                 indexing_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 parent_stream_id: Optional[pulumi.Input[str]] = None,
                 pause_indexing_on_max_size: Optional[pulumi.Input[bool]] = None,
                 retention_id: Optional[pulumi.Input[str]] = None,
                 web_socket_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a LogsOutputGraylogStream resource.
        :param pulumi.Input[str] description: Stream description
        :param pulumi.Input[str] service_name: The service name
        :param pulumi.Input[str] title: Stream description
        :param pulumi.Input[str] cold_storage_compression: Cold storage compression method
        :param pulumi.Input[str] cold_storage_content: ColdStorage content
        :param pulumi.Input[bool] cold_storage_enabled: Is Cold storage enabled?
        :param pulumi.Input[bool] cold_storage_notify_enabled: Notify on new Cold storage archive
        :param pulumi.Input[int] cold_storage_retention: Cold storage retention in year
        :param pulumi.Input[str] cold_storage_target: ColdStorage destination
        :param pulumi.Input[bool] indexing_enabled: Enable ES indexing
        :param pulumi.Input[int] indexing_max_size: Maximum indexing size (in GB)
        :param pulumi.Input[bool] indexing_notify_enabled: If set, notify when size is near 80, 90 or 100 % of the maximum configured setting
        :param pulumi.Input[str] parent_stream_id: Parent stream ID
        :param pulumi.Input[bool] pause_indexing_on_max_size: If set, pause indexing when maximum size is reach
        :param pulumi.Input[str] retention_id: Retention ID
        :param pulumi.Input[bool] web_socket_enabled: Enable Websocket
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "title", title)
        if cold_storage_compression is not None:
            pulumi.set(__self__, "cold_storage_compression", cold_storage_compression)
        if cold_storage_content is not None:
            pulumi.set(__self__, "cold_storage_content", cold_storage_content)
        if cold_storage_enabled is not None:
            pulumi.set(__self__, "cold_storage_enabled", cold_storage_enabled)
        if cold_storage_notify_enabled is not None:
            pulumi.set(__self__, "cold_storage_notify_enabled", cold_storage_notify_enabled)
        if cold_storage_retention is not None:
            pulumi.set(__self__, "cold_storage_retention", cold_storage_retention)
        if cold_storage_target is not None:
            pulumi.set(__self__, "cold_storage_target", cold_storage_target)
        if indexing_enabled is not None:
            pulumi.set(__self__, "indexing_enabled", indexing_enabled)
        if indexing_max_size is not None:
            pulumi.set(__self__, "indexing_max_size", indexing_max_size)
        if indexing_notify_enabled is not None:
            pulumi.set(__self__, "indexing_notify_enabled", indexing_notify_enabled)
        if parent_stream_id is not None:
            pulumi.set(__self__, "parent_stream_id", parent_stream_id)
        if pause_indexing_on_max_size is not None:
            pulumi.set(__self__, "pause_indexing_on_max_size", pause_indexing_on_max_size)
        if retention_id is not None:
            pulumi.set(__self__, "retention_id", retention_id)
        if web_socket_enabled is not None:
            pulumi.set(__self__, "web_socket_enabled", web_socket_enabled)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        Stream description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def title(self) -> pulumi.Input[str]:
        """
        Stream description
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: pulumi.Input[str]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="coldStorageCompression")
    def cold_storage_compression(self) -> Optional[pulumi.Input[str]]:
        """
        Cold storage compression method
        """
        return pulumi.get(self, "cold_storage_compression")

    @cold_storage_compression.setter
    def cold_storage_compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cold_storage_compression", value)

    @property
    @pulumi.getter(name="coldStorageContent")
    def cold_storage_content(self) -> Optional[pulumi.Input[str]]:
        """
        ColdStorage content
        """
        return pulumi.get(self, "cold_storage_content")

    @cold_storage_content.setter
    def cold_storage_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cold_storage_content", value)

    @property
    @pulumi.getter(name="coldStorageEnabled")
    def cold_storage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is Cold storage enabled?
        """
        return pulumi.get(self, "cold_storage_enabled")

    @cold_storage_enabled.setter
    def cold_storage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cold_storage_enabled", value)

    @property
    @pulumi.getter(name="coldStorageNotifyEnabled")
    def cold_storage_notify_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Notify on new Cold storage archive
        """
        return pulumi.get(self, "cold_storage_notify_enabled")

    @cold_storage_notify_enabled.setter
    def cold_storage_notify_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cold_storage_notify_enabled", value)

    @property
    @pulumi.getter(name="coldStorageRetention")
    def cold_storage_retention(self) -> Optional[pulumi.Input[int]]:
        """
        Cold storage retention in year
        """
        return pulumi.get(self, "cold_storage_retention")

    @cold_storage_retention.setter
    def cold_storage_retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cold_storage_retention", value)

    @property
    @pulumi.getter(name="coldStorageTarget")
    def cold_storage_target(self) -> Optional[pulumi.Input[str]]:
        """
        ColdStorage destination
        """
        return pulumi.get(self, "cold_storage_target")

    @cold_storage_target.setter
    def cold_storage_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cold_storage_target", value)

    @property
    @pulumi.getter(name="indexingEnabled")
    def indexing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable ES indexing
        """
        return pulumi.get(self, "indexing_enabled")

    @indexing_enabled.setter
    def indexing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "indexing_enabled", value)

    @property
    @pulumi.getter(name="indexingMaxSize")
    def indexing_max_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum indexing size (in GB)
        """
        return pulumi.get(self, "indexing_max_size")

    @indexing_max_size.setter
    def indexing_max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "indexing_max_size", value)

    @property
    @pulumi.getter(name="indexingNotifyEnabled")
    def indexing_notify_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, notify when size is near 80, 90 or 100 % of the maximum configured setting
        """
        return pulumi.get(self, "indexing_notify_enabled")

    @indexing_notify_enabled.setter
    def indexing_notify_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "indexing_notify_enabled", value)

    @property
    @pulumi.getter(name="parentStreamId")
    def parent_stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        Parent stream ID
        """
        return pulumi.get(self, "parent_stream_id")

    @parent_stream_id.setter
    def parent_stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_stream_id", value)

    @property
    @pulumi.getter(name="pauseIndexingOnMaxSize")
    def pause_indexing_on_max_size(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, pause indexing when maximum size is reach
        """
        return pulumi.get(self, "pause_indexing_on_max_size")

    @pause_indexing_on_max_size.setter
    def pause_indexing_on_max_size(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pause_indexing_on_max_size", value)

    @property
    @pulumi.getter(name="retentionId")
    def retention_id(self) -> Optional[pulumi.Input[str]]:
        """
        Retention ID
        """
        return pulumi.get(self, "retention_id")

    @retention_id.setter
    def retention_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_id", value)

    @property
    @pulumi.getter(name="webSocketEnabled")
    def web_socket_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Websocket
        """
        return pulumi.get(self, "web_socket_enabled")

    @web_socket_enabled.setter
    def web_socket_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "web_socket_enabled", value)


@pulumi.input_type
class _LogsOutputGraylogStreamState:
    def __init__(__self__, *,
                 can_alert: Optional[pulumi.Input[bool]] = None,
                 cold_storage_compression: Optional[pulumi.Input[str]] = None,
                 cold_storage_content: Optional[pulumi.Input[str]] = None,
                 cold_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 cold_storage_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 cold_storage_retention: Optional[pulumi.Input[int]] = None,
                 cold_storage_target: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 indexing_enabled: Optional[pulumi.Input[bool]] = None,
                 indexing_max_size: Optional[pulumi.Input[int]] = None,
                 indexing_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 is_editable: Optional[pulumi.Input[bool]] = None,
                 is_shareable: Optional[pulumi.Input[bool]] = None,
                 nb_alert_condition: Optional[pulumi.Input[int]] = None,
                 nb_archive: Optional[pulumi.Input[int]] = None,
                 parent_stream_id: Optional[pulumi.Input[str]] = None,
                 pause_indexing_on_max_size: Optional[pulumi.Input[bool]] = None,
                 retention_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 stream_id: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 web_socket_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering LogsOutputGraylogStream resources.
        :param pulumi.Input[bool] can_alert: Indicates if the current user can create alert on the stream
        :param pulumi.Input[str] cold_storage_compression: Cold storage compression method
        :param pulumi.Input[str] cold_storage_content: ColdStorage content
        :param pulumi.Input[bool] cold_storage_enabled: Is Cold storage enabled?
        :param pulumi.Input[bool] cold_storage_notify_enabled: Notify on new Cold storage archive
        :param pulumi.Input[int] cold_storage_retention: Cold storage retention in year
        :param pulumi.Input[str] cold_storage_target: ColdStorage destination
        :param pulumi.Input[str] created_at: Stream creation
        :param pulumi.Input[str] description: Stream description
        :param pulumi.Input[bool] indexing_enabled: Enable ES indexing
        :param pulumi.Input[int] indexing_max_size: Maximum indexing size (in GB)
        :param pulumi.Input[bool] indexing_notify_enabled: If set, notify when size is near 80, 90 or 100 % of the maximum configured setting
        :param pulumi.Input[bool] is_editable: Indicates if you are allowed to edit entry
        :param pulumi.Input[bool] is_shareable: Indicates if you are allowed to share entry
        :param pulumi.Input[int] nb_alert_condition: Number of alert condition
        :param pulumi.Input[int] nb_archive: Number of coldstored archives
        :param pulumi.Input[str] parent_stream_id: Parent stream ID
        :param pulumi.Input[bool] pause_indexing_on_max_size: If set, pause indexing when maximum size is reach
        :param pulumi.Input[str] retention_id: Retention ID
        :param pulumi.Input[str] service_name: The service name
        :param pulumi.Input[str] stream_id: Stream ID
        :param pulumi.Input[str] title: Stream description
        :param pulumi.Input[str] updated_at: Stream last update
        :param pulumi.Input[bool] web_socket_enabled: Enable Websocket
        """
        if can_alert is not None:
            pulumi.set(__self__, "can_alert", can_alert)
        if cold_storage_compression is not None:
            pulumi.set(__self__, "cold_storage_compression", cold_storage_compression)
        if cold_storage_content is not None:
            pulumi.set(__self__, "cold_storage_content", cold_storage_content)
        if cold_storage_enabled is not None:
            pulumi.set(__self__, "cold_storage_enabled", cold_storage_enabled)
        if cold_storage_notify_enabled is not None:
            pulumi.set(__self__, "cold_storage_notify_enabled", cold_storage_notify_enabled)
        if cold_storage_retention is not None:
            pulumi.set(__self__, "cold_storage_retention", cold_storage_retention)
        if cold_storage_target is not None:
            pulumi.set(__self__, "cold_storage_target", cold_storage_target)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if indexing_enabled is not None:
            pulumi.set(__self__, "indexing_enabled", indexing_enabled)
        if indexing_max_size is not None:
            pulumi.set(__self__, "indexing_max_size", indexing_max_size)
        if indexing_notify_enabled is not None:
            pulumi.set(__self__, "indexing_notify_enabled", indexing_notify_enabled)
        if is_editable is not None:
            pulumi.set(__self__, "is_editable", is_editable)
        if is_shareable is not None:
            pulumi.set(__self__, "is_shareable", is_shareable)
        if nb_alert_condition is not None:
            pulumi.set(__self__, "nb_alert_condition", nb_alert_condition)
        if nb_archive is not None:
            pulumi.set(__self__, "nb_archive", nb_archive)
        if parent_stream_id is not None:
            pulumi.set(__self__, "parent_stream_id", parent_stream_id)
        if pause_indexing_on_max_size is not None:
            pulumi.set(__self__, "pause_indexing_on_max_size", pause_indexing_on_max_size)
        if retention_id is not None:
            pulumi.set(__self__, "retention_id", retention_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if web_socket_enabled is not None:
            pulumi.set(__self__, "web_socket_enabled", web_socket_enabled)

    @property
    @pulumi.getter(name="canAlert")
    def can_alert(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the current user can create alert on the stream
        """
        return pulumi.get(self, "can_alert")

    @can_alert.setter
    def can_alert(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_alert", value)

    @property
    @pulumi.getter(name="coldStorageCompression")
    def cold_storage_compression(self) -> Optional[pulumi.Input[str]]:
        """
        Cold storage compression method
        """
        return pulumi.get(self, "cold_storage_compression")

    @cold_storage_compression.setter
    def cold_storage_compression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cold_storage_compression", value)

    @property
    @pulumi.getter(name="coldStorageContent")
    def cold_storage_content(self) -> Optional[pulumi.Input[str]]:
        """
        ColdStorage content
        """
        return pulumi.get(self, "cold_storage_content")

    @cold_storage_content.setter
    def cold_storage_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cold_storage_content", value)

    @property
    @pulumi.getter(name="coldStorageEnabled")
    def cold_storage_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Is Cold storage enabled?
        """
        return pulumi.get(self, "cold_storage_enabled")

    @cold_storage_enabled.setter
    def cold_storage_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cold_storage_enabled", value)

    @property
    @pulumi.getter(name="coldStorageNotifyEnabled")
    def cold_storage_notify_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Notify on new Cold storage archive
        """
        return pulumi.get(self, "cold_storage_notify_enabled")

    @cold_storage_notify_enabled.setter
    def cold_storage_notify_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cold_storage_notify_enabled", value)

    @property
    @pulumi.getter(name="coldStorageRetention")
    def cold_storage_retention(self) -> Optional[pulumi.Input[int]]:
        """
        Cold storage retention in year
        """
        return pulumi.get(self, "cold_storage_retention")

    @cold_storage_retention.setter
    def cold_storage_retention(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cold_storage_retention", value)

    @property
    @pulumi.getter(name="coldStorageTarget")
    def cold_storage_target(self) -> Optional[pulumi.Input[str]]:
        """
        ColdStorage destination
        """
        return pulumi.get(self, "cold_storage_target")

    @cold_storage_target.setter
    def cold_storage_target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cold_storage_target", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Stream creation
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Stream description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="indexingEnabled")
    def indexing_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable ES indexing
        """
        return pulumi.get(self, "indexing_enabled")

    @indexing_enabled.setter
    def indexing_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "indexing_enabled", value)

    @property
    @pulumi.getter(name="indexingMaxSize")
    def indexing_max_size(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum indexing size (in GB)
        """
        return pulumi.get(self, "indexing_max_size")

    @indexing_max_size.setter
    def indexing_max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "indexing_max_size", value)

    @property
    @pulumi.getter(name="indexingNotifyEnabled")
    def indexing_notify_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, notify when size is near 80, 90 or 100 % of the maximum configured setting
        """
        return pulumi.get(self, "indexing_notify_enabled")

    @indexing_notify_enabled.setter
    def indexing_notify_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "indexing_notify_enabled", value)

    @property
    @pulumi.getter(name="isEditable")
    def is_editable(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if you are allowed to edit entry
        """
        return pulumi.get(self, "is_editable")

    @is_editable.setter
    def is_editable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_editable", value)

    @property
    @pulumi.getter(name="isShareable")
    def is_shareable(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if you are allowed to share entry
        """
        return pulumi.get(self, "is_shareable")

    @is_shareable.setter
    def is_shareable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_shareable", value)

    @property
    @pulumi.getter(name="nbAlertCondition")
    def nb_alert_condition(self) -> Optional[pulumi.Input[int]]:
        """
        Number of alert condition
        """
        return pulumi.get(self, "nb_alert_condition")

    @nb_alert_condition.setter
    def nb_alert_condition(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nb_alert_condition", value)

    @property
    @pulumi.getter(name="nbArchive")
    def nb_archive(self) -> Optional[pulumi.Input[int]]:
        """
        Number of coldstored archives
        """
        return pulumi.get(self, "nb_archive")

    @nb_archive.setter
    def nb_archive(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nb_archive", value)

    @property
    @pulumi.getter(name="parentStreamId")
    def parent_stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        Parent stream ID
        """
        return pulumi.get(self, "parent_stream_id")

    @parent_stream_id.setter
    def parent_stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_stream_id", value)

    @property
    @pulumi.getter(name="pauseIndexingOnMaxSize")
    def pause_indexing_on_max_size(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, pause indexing when maximum size is reach
        """
        return pulumi.get(self, "pause_indexing_on_max_size")

    @pause_indexing_on_max_size.setter
    def pause_indexing_on_max_size(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "pause_indexing_on_max_size", value)

    @property
    @pulumi.getter(name="retentionId")
    def retention_id(self) -> Optional[pulumi.Input[str]]:
        """
        Retention ID
        """
        return pulumi.get(self, "retention_id")

    @retention_id.setter
    def retention_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[str]]:
        """
        Stream ID
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stream_id", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Stream description
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        Stream last update
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="webSocketEnabled")
    def web_socket_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable Websocket
        """
        return pulumi.get(self, "web_socket_enabled")

    @web_socket_enabled.setter
    def web_socket_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "web_socket_enabled", value)


class LogsOutputGraylogStream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cold_storage_compression: Optional[pulumi.Input[str]] = None,
                 cold_storage_content: Optional[pulumi.Input[str]] = None,
                 cold_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 cold_storage_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 cold_storage_retention: Optional[pulumi.Input[int]] = None,
                 cold_storage_target: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 indexing_enabled: Optional[pulumi.Input[bool]] = None,
                 indexing_max_size: Optional[pulumi.Input[int]] = None,
                 indexing_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 parent_stream_id: Optional[pulumi.Input[str]] = None,
                 pause_indexing_on_max_size: Optional[pulumi.Input[bool]] = None,
                 retention_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 web_socket_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Create a LogsOutputGraylogStream resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cold_storage_compression: Cold storage compression method
        :param pulumi.Input[str] cold_storage_content: ColdStorage content
        :param pulumi.Input[bool] cold_storage_enabled: Is Cold storage enabled?
        :param pulumi.Input[bool] cold_storage_notify_enabled: Notify on new Cold storage archive
        :param pulumi.Input[int] cold_storage_retention: Cold storage retention in year
        :param pulumi.Input[str] cold_storage_target: ColdStorage destination
        :param pulumi.Input[str] description: Stream description
        :param pulumi.Input[bool] indexing_enabled: Enable ES indexing
        :param pulumi.Input[int] indexing_max_size: Maximum indexing size (in GB)
        :param pulumi.Input[bool] indexing_notify_enabled: If set, notify when size is near 80, 90 or 100 % of the maximum configured setting
        :param pulumi.Input[str] parent_stream_id: Parent stream ID
        :param pulumi.Input[bool] pause_indexing_on_max_size: If set, pause indexing when maximum size is reach
        :param pulumi.Input[str] retention_id: Retention ID
        :param pulumi.Input[str] service_name: The service name
        :param pulumi.Input[str] title: Stream description
        :param pulumi.Input[bool] web_socket_enabled: Enable Websocket
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LogsOutputGraylogStreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a LogsOutputGraylogStream resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param LogsOutputGraylogStreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LogsOutputGraylogStreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cold_storage_compression: Optional[pulumi.Input[str]] = None,
                 cold_storage_content: Optional[pulumi.Input[str]] = None,
                 cold_storage_enabled: Optional[pulumi.Input[bool]] = None,
                 cold_storage_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 cold_storage_retention: Optional[pulumi.Input[int]] = None,
                 cold_storage_target: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 indexing_enabled: Optional[pulumi.Input[bool]] = None,
                 indexing_max_size: Optional[pulumi.Input[int]] = None,
                 indexing_notify_enabled: Optional[pulumi.Input[bool]] = None,
                 parent_stream_id: Optional[pulumi.Input[str]] = None,
                 pause_indexing_on_max_size: Optional[pulumi.Input[bool]] = None,
                 retention_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 web_socket_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LogsOutputGraylogStreamArgs.__new__(LogsOutputGraylogStreamArgs)

            __props__.__dict__["cold_storage_compression"] = cold_storage_compression
            __props__.__dict__["cold_storage_content"] = cold_storage_content
            __props__.__dict__["cold_storage_enabled"] = cold_storage_enabled
            __props__.__dict__["cold_storage_notify_enabled"] = cold_storage_notify_enabled
            __props__.__dict__["cold_storage_retention"] = cold_storage_retention
            __props__.__dict__["cold_storage_target"] = cold_storage_target
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["indexing_enabled"] = indexing_enabled
            __props__.__dict__["indexing_max_size"] = indexing_max_size
            __props__.__dict__["indexing_notify_enabled"] = indexing_notify_enabled
            __props__.__dict__["parent_stream_id"] = parent_stream_id
            __props__.__dict__["pause_indexing_on_max_size"] = pause_indexing_on_max_size
            __props__.__dict__["retention_id"] = retention_id
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if title is None and not opts.urn:
                raise TypeError("Missing required property 'title'")
            __props__.__dict__["title"] = title
            __props__.__dict__["web_socket_enabled"] = web_socket_enabled
            __props__.__dict__["can_alert"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["is_editable"] = None
            __props__.__dict__["is_shareable"] = None
            __props__.__dict__["nb_alert_condition"] = None
            __props__.__dict__["nb_archive"] = None
            __props__.__dict__["stream_id"] = None
            __props__.__dict__["updated_at"] = None
        super(LogsOutputGraylogStream, __self__).__init__(
            'ovh:Dbaas/logsOutputGraylogStream:LogsOutputGraylogStream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            can_alert: Optional[pulumi.Input[bool]] = None,
            cold_storage_compression: Optional[pulumi.Input[str]] = None,
            cold_storage_content: Optional[pulumi.Input[str]] = None,
            cold_storage_enabled: Optional[pulumi.Input[bool]] = None,
            cold_storage_notify_enabled: Optional[pulumi.Input[bool]] = None,
            cold_storage_retention: Optional[pulumi.Input[int]] = None,
            cold_storage_target: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            indexing_enabled: Optional[pulumi.Input[bool]] = None,
            indexing_max_size: Optional[pulumi.Input[int]] = None,
            indexing_notify_enabled: Optional[pulumi.Input[bool]] = None,
            is_editable: Optional[pulumi.Input[bool]] = None,
            is_shareable: Optional[pulumi.Input[bool]] = None,
            nb_alert_condition: Optional[pulumi.Input[int]] = None,
            nb_archive: Optional[pulumi.Input[int]] = None,
            parent_stream_id: Optional[pulumi.Input[str]] = None,
            pause_indexing_on_max_size: Optional[pulumi.Input[bool]] = None,
            retention_id: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            stream_id: Optional[pulumi.Input[str]] = None,
            title: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            web_socket_enabled: Optional[pulumi.Input[bool]] = None) -> 'LogsOutputGraylogStream':
        """
        Get an existing LogsOutputGraylogStream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] can_alert: Indicates if the current user can create alert on the stream
        :param pulumi.Input[str] cold_storage_compression: Cold storage compression method
        :param pulumi.Input[str] cold_storage_content: ColdStorage content
        :param pulumi.Input[bool] cold_storage_enabled: Is Cold storage enabled?
        :param pulumi.Input[bool] cold_storage_notify_enabled: Notify on new Cold storage archive
        :param pulumi.Input[int] cold_storage_retention: Cold storage retention in year
        :param pulumi.Input[str] cold_storage_target: ColdStorage destination
        :param pulumi.Input[str] created_at: Stream creation
        :param pulumi.Input[str] description: Stream description
        :param pulumi.Input[bool] indexing_enabled: Enable ES indexing
        :param pulumi.Input[int] indexing_max_size: Maximum indexing size (in GB)
        :param pulumi.Input[bool] indexing_notify_enabled: If set, notify when size is near 80, 90 or 100 % of the maximum configured setting
        :param pulumi.Input[bool] is_editable: Indicates if you are allowed to edit entry
        :param pulumi.Input[bool] is_shareable: Indicates if you are allowed to share entry
        :param pulumi.Input[int] nb_alert_condition: Number of alert condition
        :param pulumi.Input[int] nb_archive: Number of coldstored archives
        :param pulumi.Input[str] parent_stream_id: Parent stream ID
        :param pulumi.Input[bool] pause_indexing_on_max_size: If set, pause indexing when maximum size is reach
        :param pulumi.Input[str] retention_id: Retention ID
        :param pulumi.Input[str] service_name: The service name
        :param pulumi.Input[str] stream_id: Stream ID
        :param pulumi.Input[str] title: Stream description
        :param pulumi.Input[str] updated_at: Stream last update
        :param pulumi.Input[bool] web_socket_enabled: Enable Websocket
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LogsOutputGraylogStreamState.__new__(_LogsOutputGraylogStreamState)

        __props__.__dict__["can_alert"] = can_alert
        __props__.__dict__["cold_storage_compression"] = cold_storage_compression
        __props__.__dict__["cold_storage_content"] = cold_storage_content
        __props__.__dict__["cold_storage_enabled"] = cold_storage_enabled
        __props__.__dict__["cold_storage_notify_enabled"] = cold_storage_notify_enabled
        __props__.__dict__["cold_storage_retention"] = cold_storage_retention
        __props__.__dict__["cold_storage_target"] = cold_storage_target
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["indexing_enabled"] = indexing_enabled
        __props__.__dict__["indexing_max_size"] = indexing_max_size
        __props__.__dict__["indexing_notify_enabled"] = indexing_notify_enabled
        __props__.__dict__["is_editable"] = is_editable
        __props__.__dict__["is_shareable"] = is_shareable
        __props__.__dict__["nb_alert_condition"] = nb_alert_condition
        __props__.__dict__["nb_archive"] = nb_archive
        __props__.__dict__["parent_stream_id"] = parent_stream_id
        __props__.__dict__["pause_indexing_on_max_size"] = pause_indexing_on_max_size
        __props__.__dict__["retention_id"] = retention_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["stream_id"] = stream_id
        __props__.__dict__["title"] = title
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["web_socket_enabled"] = web_socket_enabled
        return LogsOutputGraylogStream(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="canAlert")
    def can_alert(self) -> pulumi.Output[bool]:
        """
        Indicates if the current user can create alert on the stream
        """
        return pulumi.get(self, "can_alert")

    @property
    @pulumi.getter(name="coldStorageCompression")
    def cold_storage_compression(self) -> pulumi.Output[str]:
        """
        Cold storage compression method
        """
        return pulumi.get(self, "cold_storage_compression")

    @property
    @pulumi.getter(name="coldStorageContent")
    def cold_storage_content(self) -> pulumi.Output[str]:
        """
        ColdStorage content
        """
        return pulumi.get(self, "cold_storage_content")

    @property
    @pulumi.getter(name="coldStorageEnabled")
    def cold_storage_enabled(self) -> pulumi.Output[bool]:
        """
        Is Cold storage enabled?
        """
        return pulumi.get(self, "cold_storage_enabled")

    @property
    @pulumi.getter(name="coldStorageNotifyEnabled")
    def cold_storage_notify_enabled(self) -> pulumi.Output[bool]:
        """
        Notify on new Cold storage archive
        """
        return pulumi.get(self, "cold_storage_notify_enabled")

    @property
    @pulumi.getter(name="coldStorageRetention")
    def cold_storage_retention(self) -> pulumi.Output[int]:
        """
        Cold storage retention in year
        """
        return pulumi.get(self, "cold_storage_retention")

    @property
    @pulumi.getter(name="coldStorageTarget")
    def cold_storage_target(self) -> pulumi.Output[str]:
        """
        ColdStorage destination
        """
        return pulumi.get(self, "cold_storage_target")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Stream creation
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Stream description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="indexingEnabled")
    def indexing_enabled(self) -> pulumi.Output[bool]:
        """
        Enable ES indexing
        """
        return pulumi.get(self, "indexing_enabled")

    @property
    @pulumi.getter(name="indexingMaxSize")
    def indexing_max_size(self) -> pulumi.Output[int]:
        """
        Maximum indexing size (in GB)
        """
        return pulumi.get(self, "indexing_max_size")

    @property
    @pulumi.getter(name="indexingNotifyEnabled")
    def indexing_notify_enabled(self) -> pulumi.Output[bool]:
        """
        If set, notify when size is near 80, 90 or 100 % of the maximum configured setting
        """
        return pulumi.get(self, "indexing_notify_enabled")

    @property
    @pulumi.getter(name="isEditable")
    def is_editable(self) -> pulumi.Output[bool]:
        """
        Indicates if you are allowed to edit entry
        """
        return pulumi.get(self, "is_editable")

    @property
    @pulumi.getter(name="isShareable")
    def is_shareable(self) -> pulumi.Output[bool]:
        """
        Indicates if you are allowed to share entry
        """
        return pulumi.get(self, "is_shareable")

    @property
    @pulumi.getter(name="nbAlertCondition")
    def nb_alert_condition(self) -> pulumi.Output[int]:
        """
        Number of alert condition
        """
        return pulumi.get(self, "nb_alert_condition")

    @property
    @pulumi.getter(name="nbArchive")
    def nb_archive(self) -> pulumi.Output[int]:
        """
        Number of coldstored archives
        """
        return pulumi.get(self, "nb_archive")

    @property
    @pulumi.getter(name="parentStreamId")
    def parent_stream_id(self) -> pulumi.Output[Optional[str]]:
        """
        Parent stream ID
        """
        return pulumi.get(self, "parent_stream_id")

    @property
    @pulumi.getter(name="pauseIndexingOnMaxSize")
    def pause_indexing_on_max_size(self) -> pulumi.Output[bool]:
        """
        If set, pause indexing when maximum size is reach
        """
        return pulumi.get(self, "pause_indexing_on_max_size")

    @property
    @pulumi.getter(name="retentionId")
    def retention_id(self) -> pulumi.Output[str]:
        """
        Retention ID
        """
        return pulumi.get(self, "retention_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Output[str]:
        """
        Stream ID
        """
        return pulumi.get(self, "stream_id")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        Stream description
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        Stream last update
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="webSocketEnabled")
    def web_socket_enabled(self) -> pulumi.Output[bool]:
        """
        Enable Websocket
        """
        return pulumi.get(self, "web_socket_enabled")

