# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRegionsResult',
    'AwaitableGetRegionsResult',
    'get_regions',
    'get_regions_output',
]

@pulumi.output_type
class GetRegionsResult:
    """
    A collection of values returned by getRegions.
    """
    def __init__(__self__, has_services_ups=None, id=None, names=None, service_name=None):
        if has_services_ups and not isinstance(has_services_ups, list):
            raise TypeError("Expected argument 'has_services_ups' to be a list")
        pulumi.set(__self__, "has_services_ups", has_services_ups)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter(name="hasServicesUps")
    def has_services_ups(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "has_services_ups")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        The list of regions associated with the project, filtered by services UP.
        """
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        return pulumi.get(self, "service_name")


class AwaitableGetRegionsResult(GetRegionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRegionsResult(
            has_services_ups=self.has_services_ups,
            id=self.id,
            names=self.names,
            service_name=self.service_name)


def get_regions(has_services_ups: Optional[Sequence[str]] = None,
                service_name: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRegionsResult:
    """
    Use this data source to get the regions of a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    regions = ovh.CloudProject.get_regions(has_services_ups=["network"],
        service_name="XXXXXX")
    ```


    :param Sequence[str] has_services_ups: List of services which has to be UP in regions.
           Example: "image", "instance", "network", "storage", "volume", "workflow", ...
           If left blank, returns all regions associated with the service_name.
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    __args__ = dict()
    __args__['hasServicesUps'] = has_services_ups
    __args__['serviceName'] = service_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ovh:CloudProject/getRegions:getRegions', __args__, opts=opts, typ=GetRegionsResult).value

    return AwaitableGetRegionsResult(
        has_services_ups=__ret__.has_services_ups,
        id=__ret__.id,
        names=__ret__.names,
        service_name=__ret__.service_name)


@_utilities.lift_output_func(get_regions)
def get_regions_output(has_services_ups: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       service_name: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRegionsResult]:
    """
    Use this data source to get the regions of a public cloud project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ovh as ovh

    regions = ovh.CloudProject.get_regions(has_services_ups=["network"],
        service_name="XXXXXX")
    ```


    :param Sequence[str] has_services_ups: List of services which has to be UP in regions.
           Example: "image", "instance", "network", "storage", "volume", "workflow", ...
           If left blank, returns all regions associated with the service_name.
    :param str service_name: The id of the public cloud project. If omitted,
           the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
    """
    ...
