# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CloudProjectContainerRegistryUserArgs', 'CloudProjectContainerRegistryUser']

@pulumi.input_type
class CloudProjectContainerRegistryUserArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[str],
                 login: pulumi.Input[str],
                 registry_id: pulumi.Input[str],
                 service_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a CloudProjectContainerRegistryUser resource.
        :param pulumi.Input[str] email: User email
        :param pulumi.Input[str] login: Registry name
        :param pulumi.Input[str] registry_id: Registry ID
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted,
               the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "registry_id", registry_id)
        pulumi.set(__self__, "service_name", service_name)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[str]:
        """
        User email
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[str]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def login(self) -> pulumi.Input[str]:
        """
        Registry name
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: pulumi.Input[str]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Input[str]:
        """
        Registry ID
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        The id of the public cloud project. If omitted,
        the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)


@pulumi.input_type
class _CloudProjectContainerRegistryUserState:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CloudProjectContainerRegistryUser resources.
        :param pulumi.Input[str] email: User email
        :param pulumi.Input[str] login: Registry name
        :param pulumi.Input[str] password: (Sensitive) User password
        :param pulumi.Input[str] registry_id: Registry ID
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted,
               the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[str] user: User name
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        User email
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[str]]:
        """
        Registry name
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Sensitive) User password
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[str]]:
        """
        Registry ID
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the public cloud project. If omitted,
        the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        """
        User name
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


class CloudProjectContainerRegistryUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a user for a container registry associated with a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_ovh as ovh
        import pulumi_ovh as ovh

        registry = ovh.get_cloud_project_container_registry(service_name="XXXXXX",
            registry_id="yyyy")
        user = ovh.CloudProjectContainerRegistryUser("user",
            service_name=ovh_cloud_project_containerregistry["registry"]["service_name"],
            registry_id=ovh_cloud_project_containerregistry["registry"]["id"],
            email="foo@bar.com",
            login="foobar")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: User email
        :param pulumi.Input[str] login: Registry name
        :param pulumi.Input[str] registry_id: Registry ID
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted,
               the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudProjectContainerRegistryUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a user for a container registry associated with a public cloud project.

        ## Example Usage

        ```python
        import pulumi
        import lbrlabs_ovh as ovh
        import pulumi_ovh as ovh

        registry = ovh.get_cloud_project_container_registry(service_name="XXXXXX",
            registry_id="yyyy")
        user = ovh.CloudProjectContainerRegistryUser("user",
            service_name=ovh_cloud_project_containerregistry["registry"]["service_name"],
            registry_id=ovh_cloud_project_containerregistry["registry"]["id"],
            email="foo@bar.com",
            login="foobar")
        ```

        :param str resource_name: The name of the resource.
        :param CloudProjectContainerRegistryUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudProjectContainerRegistryUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 email: Optional[pulumi.Input[str]] = None,
                 login: Optional[pulumi.Input[str]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudProjectContainerRegistryUserArgs.__new__(CloudProjectContainerRegistryUserArgs)

            if email is None and not opts.urn:
                raise TypeError("Missing required property 'email'")
            __props__.__dict__["email"] = email
            if login is None and not opts.urn:
                raise TypeError("Missing required property 'login'")
            __props__.__dict__["login"] = login
            if registry_id is None and not opts.urn:
                raise TypeError("Missing required property 'registry_id'")
            __props__.__dict__["registry_id"] = registry_id
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["password"] = None
            __props__.__dict__["user"] = None
        super(CloudProjectContainerRegistryUser, __self__).__init__(
            'ovh:index/cloudProjectContainerRegistryUser:CloudProjectContainerRegistryUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            email: Optional[pulumi.Input[str]] = None,
            login: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            registry_id: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            user: Optional[pulumi.Input[str]] = None) -> 'CloudProjectContainerRegistryUser':
        """
        Get an existing CloudProjectContainerRegistryUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] email: User email
        :param pulumi.Input[str] login: Registry name
        :param pulumi.Input[str] password: (Sensitive) User password
        :param pulumi.Input[str] registry_id: Registry ID
        :param pulumi.Input[str] service_name: The id of the public cloud project. If omitted,
               the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        :param pulumi.Input[str] user: User name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudProjectContainerRegistryUserState.__new__(_CloudProjectContainerRegistryUserState)

        __props__.__dict__["email"] = email
        __props__.__dict__["login"] = login
        __props__.__dict__["password"] = password
        __props__.__dict__["registry_id"] = registry_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["user"] = user
        return CloudProjectContainerRegistryUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Output[str]:
        """
        User email
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def login(self) -> pulumi.Output[str]:
        """
        Registry name
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        (Sensitive) User password
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Output[str]:
        """
        Registry ID
        """
        return pulumi.get(self, "registry_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        The id of the public cloud project. If omitted,
        the `OVH_CLOUD_PROJECT_SERVICE` environment variable is used.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def user(self) -> pulumi.Output[str]:
        """
        User name
        """
        return pulumi.get(self, "user")

