"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOctokit = exports.baseUrlFromDomain = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const auth_app_1 = require("@octokit/auth-app");
const rest_1 = require("@octokit/rest");
const helpers_1 = require("./helpers");
function baseUrlFromDomain(domain) {
    if (domain == 'github.com') {
        return 'https://api.github.com';
    }
    return `https://${domain}/api/v3`;
}
exports.baseUrlFromDomain = baseUrlFromDomain;
async function getOctokit(installationId) {
    if (!process.env.GITHUB_SECRET_ARN || !process.env.GITHUB_PRIVATE_KEY_SECRET_ARN) {
        throw new Error('Missing environment variables');
    }
    const githubSecrets = await helpers_1.getSecretJsonValue(process.env.GITHUB_SECRET_ARN);
    let baseUrl = baseUrlFromDomain(githubSecrets.domain);
    let token;
    if (githubSecrets.personalAuthToken) {
        token = githubSecrets.personalAuthToken;
    }
    else {
        const privateKey = await helpers_1.getSecretValue(process.env.GITHUB_PRIVATE_KEY_SECRET_ARN);
        const appOctokit = new rest_1.Octokit({
            baseUrl,
            authStrategy: auth_app_1.createAppAuth,
            auth: {
                appId: githubSecrets.appId,
                privateKey: privateKey,
            },
        });
        token = (await appOctokit.auth({
            type: 'installation',
            installationId: installationId,
        })).token;
    }
    const octokit = new rest_1.Octokit({
        baseUrl,
        auth: token,
    });
    return {
        githubSecrets,
        octokit,
    };
}
exports.getOctokit = getOctokit;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0aHViLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2xhbWJkYXMvZ2l0aHViLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHNEQUFzRDtBQUN0RCxnREFBa0Q7QUFDbEQsd0NBQXdDO0FBQ3hDLHVDQUErRDtBQUUvRCxTQUFnQixpQkFBaUIsQ0FBQyxNQUFjO0lBQzlDLElBQUksTUFBTSxJQUFJLFlBQVksRUFBRTtRQUMxQixPQUFPLHdCQUF3QixDQUFDO0tBQ2pDO0lBQ0QsT0FBTyxXQUFXLE1BQU0sU0FBUyxDQUFDO0FBQ3BDLENBQUM7QUFMRCw4Q0FLQztBQUVNLEtBQUssVUFBVSxVQUFVLENBQUMsY0FBdUI7SUFDdEQsSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLDZCQUE2QixFQUFFO1FBQ2hGLE1BQU0sSUFBSSxLQUFLLENBQUMsK0JBQStCLENBQUMsQ0FBQztLQUNsRDtJQUVELE1BQU0sYUFBYSxHQUFHLE1BQU0sNEJBQWtCLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDO0lBRTlFLElBQUksT0FBTyxHQUFHLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUV0RCxJQUFJLEtBQUssQ0FBQztJQUNWLElBQUksYUFBYSxDQUFDLGlCQUFpQixFQUFFO1FBQ25DLEtBQUssR0FBRyxhQUFhLENBQUMsaUJBQWlCLENBQUM7S0FDekM7U0FBTTtRQUNMLE1BQU0sVUFBVSxHQUFHLE1BQU0sd0JBQWMsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLDZCQUE2QixDQUFDLENBQUM7UUFFbkYsTUFBTSxVQUFVLEdBQUcsSUFBSSxjQUFPLENBQUM7WUFDN0IsT0FBTztZQUNQLFlBQVksRUFBRSx3QkFBYTtZQUMzQixJQUFJLEVBQUU7Z0JBQ0osS0FBSyxFQUFFLGFBQWEsQ0FBQyxLQUFLO2dCQUMxQixVQUFVLEVBQUUsVUFBVTthQUN2QjtTQUNGLENBQUMsQ0FBQztRQUVILEtBQUssR0FBRyxDQUFDLE1BQU0sVUFBVSxDQUFDLElBQUksQ0FBQztZQUM3QixJQUFJLEVBQUUsY0FBYztZQUNwQixjQUFjLEVBQUUsY0FBYztTQUMvQixDQUFTLENBQUEsQ0FBQyxLQUFLLENBQUM7S0FDbEI7SUFFRCxNQUFNLE9BQU8sR0FBRyxJQUFJLGNBQU8sQ0FBQztRQUMxQixPQUFPO1FBQ1AsSUFBSSxFQUFFLEtBQUs7S0FDWixDQUFDLENBQUM7SUFFSCxPQUFPO1FBQ0wsYUFBYTtRQUNiLE9BQU87S0FDUixDQUFDO0FBQ0osQ0FBQztBQXZDRCxnQ0F1Q0MiLCJzb3VyY2VzQ29udGVudCI6WyIvKiBlc2xpbnQtZGlzYWJsZSBpbXBvcnQvbm8tZXh0cmFuZW91cy1kZXBlbmRlbmNpZXMgKi9cbmltcG9ydCB7IGNyZWF0ZUFwcEF1dGggfSBmcm9tICdAb2N0b2tpdC9hdXRoLWFwcCc7XG5pbXBvcnQgeyBPY3Rva2l0IH0gZnJvbSAnQG9jdG9raXQvcmVzdCc7XG5pbXBvcnQgeyBnZXRTZWNyZXRWYWx1ZSwgZ2V0U2VjcmV0SnNvblZhbHVlIH0gZnJvbSAnLi9oZWxwZXJzJztcblxuZXhwb3J0IGZ1bmN0aW9uIGJhc2VVcmxGcm9tRG9tYWluKGRvbWFpbjogc3RyaW5nKTogc3RyaW5nIHtcbiAgaWYgKGRvbWFpbiA9PSAnZ2l0aHViLmNvbScpIHtcbiAgICByZXR1cm4gJ2h0dHBzOi8vYXBpLmdpdGh1Yi5jb20nO1xuICB9XG4gIHJldHVybiBgaHR0cHM6Ly8ke2RvbWFpbn0vYXBpL3YzYDtcbn1cblxuZXhwb3J0IGFzeW5jIGZ1bmN0aW9uIGdldE9jdG9raXQoaW5zdGFsbGF0aW9uSWQ/OiBzdHJpbmcpIHtcbiAgaWYgKCFwcm9jZXNzLmVudi5HSVRIVUJfU0VDUkVUX0FSTiB8fCAhcHJvY2Vzcy5lbnYuR0lUSFVCX1BSSVZBVEVfS0VZX1NFQ1JFVF9BUk4pIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoJ01pc3NpbmcgZW52aXJvbm1lbnQgdmFyaWFibGVzJyk7XG4gIH1cblxuICBjb25zdCBnaXRodWJTZWNyZXRzID0gYXdhaXQgZ2V0U2VjcmV0SnNvblZhbHVlKHByb2Nlc3MuZW52LkdJVEhVQl9TRUNSRVRfQVJOKTtcblxuICBsZXQgYmFzZVVybCA9IGJhc2VVcmxGcm9tRG9tYWluKGdpdGh1YlNlY3JldHMuZG9tYWluKTtcblxuICBsZXQgdG9rZW47XG4gIGlmIChnaXRodWJTZWNyZXRzLnBlcnNvbmFsQXV0aFRva2VuKSB7XG4gICAgdG9rZW4gPSBnaXRodWJTZWNyZXRzLnBlcnNvbmFsQXV0aFRva2VuO1xuICB9IGVsc2Uge1xuICAgIGNvbnN0IHByaXZhdGVLZXkgPSBhd2FpdCBnZXRTZWNyZXRWYWx1ZShwcm9jZXNzLmVudi5HSVRIVUJfUFJJVkFURV9LRVlfU0VDUkVUX0FSTik7XG5cbiAgICBjb25zdCBhcHBPY3Rva2l0ID0gbmV3IE9jdG9raXQoe1xuICAgICAgYmFzZVVybCxcbiAgICAgIGF1dGhTdHJhdGVneTogY3JlYXRlQXBwQXV0aCxcbiAgICAgIGF1dGg6IHtcbiAgICAgICAgYXBwSWQ6IGdpdGh1YlNlY3JldHMuYXBwSWQsXG4gICAgICAgIHByaXZhdGVLZXk6IHByaXZhdGVLZXksXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdG9rZW4gPSAoYXdhaXQgYXBwT2N0b2tpdC5hdXRoKHtcbiAgICAgIHR5cGU6ICdpbnN0YWxsYXRpb24nLFxuICAgICAgaW5zdGFsbGF0aW9uSWQ6IGluc3RhbGxhdGlvbklkLFxuICAgIH0pIGFzIGFueSkudG9rZW47XG4gIH1cblxuICBjb25zdCBvY3Rva2l0ID0gbmV3IE9jdG9raXQoe1xuICAgIGJhc2VVcmwsXG4gICAgYXV0aDogdG9rZW4sXG4gIH0pO1xuXG4gIHJldHVybiB7XG4gICAgZ2l0aHViU2VjcmV0cyxcbiAgICBvY3Rva2l0LFxuICB9O1xufVxuIl19