"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/* eslint-disable import/no-extraneous-dependencies */
const AWS = require("aws-sdk");
const semver_1 = require("semver");
const helpers_1 = require("./helpers");
const ib = new AWS.Imagebuilder();
/* eslint-disable @typescript-eslint/no-require-imports, import/no-extraneous-dependencies */
async function handler(event, context) {
    console.log(JSON.stringify({ ...event, ResponseURL: '...' }));
    try {
        const objectType = event.ResourceProperties.ObjectType;
        const objectName = event.ResourceProperties.ObjectName;
        switch (event.RequestType) {
            case 'Create':
            case 'Update':
                let version = '1.0.0';
                let allVersions = [];
                try {
                    switch (objectType) {
                        case 'Component': {
                            let result = {};
                            do {
                                result = await ib.listComponents({
                                    filters: [{
                                            name: 'name',
                                            values: [objectName],
                                        }],
                                    nextToken: result.nextToken,
                                }).promise();
                                allVersions = allVersions.concat(result.componentVersionList.map(i => i.version || '1.0.0'));
                            } while (result.nextToken);
                            break;
                        }
                        case 'ImageRecipe': {
                            let result = {};
                            do {
                                result = await ib.listImageRecipes({
                                    filters: [{
                                            name: 'name',
                                            values: [objectName],
                                        }],
                                    nextToken: result.nextToken,
                                }).promise();
                                allVersions = allVersions.concat(result.imageRecipeSummaryList.map(i => i.arn?.split('/').pop() || '1.0.0'));
                            } while (result.nextToken);
                            break;
                        }
                        case 'ContainerRecipe': {
                            let result = {};
                            do {
                                result = await ib.listContainerRecipes({
                                    filters: [{
                                            name: 'name',
                                            values: [objectName],
                                        }],
                                    nextToken: result.nextToken,
                                }).promise();
                                allVersions = allVersions.concat(result.containerRecipeSummaryList.map(i => i.arn?.split('/').pop() || '1.0.0'));
                            } while (result.nextToken);
                            break;
                        }
                    }
                }
                catch (e) {
                    if (e.code !== 'ResourceNotFoundException') {
                        throw e;
                    }
                    else {
                        console.log('Resource not found, assuming first version');
                    }
                }
                version = semver_1.maxSatisfying(allVersions, '>=0.0.0');
                if (version === null) {
                    version = '1.0.0';
                }
                console.log(`Found versions ${allVersions} -- latest is ${version}`);
                version = semver_1.inc(version, 'patch');
                if (version === null) {
                    throw new Error('Unable to bump version');
                }
                await helpers_1.customResourceRespond(event, 'SUCCESS', 'OK', version, {});
                break;
            case 'Delete':
                await helpers_1.customResourceRespond(event, 'SUCCESS', 'OK', event.PhysicalResourceId, {});
                break;
        }
    }
    catch (e) {
        console.log(e);
        await helpers_1.customResourceRespond(event, 'FAILED', e.message || 'Internal Error', context.logStreamName, {});
    }
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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