"""
Container module for Enum classes used within NISTparser
"""

from enum import Enum


class NISTMaterials(Enum):
    """
    Simple enum class listing NISTmaterials and respective URL index
    """

    A_150_TISSUE_EQUIVALENT_PLASTIC = 99
    ACETYLENE = 101
    ADIPOSE_TISSUE_ICRP = 103
    AIR_DRY_NEAR_SEA_LEVEL = 104
    ALUMINUM_OXIDE = 106
    B_100_BONE_EQUIVALENT_PLASTIC = 111
    BONE_COMPACT_ICRU = 119
    BONE_CORTICAL_ICRP = 120
    C_552_AIR_EQUIVALENT_PLASTIC = 126
    CALCIUM_FLUORIDE = 130
    CARBON_DIOXIDE = 134
    CELLULOSE_NITRATE = 138
    CERIC_SULFATE_DOSIMETER_SOLUTION = 139
    CESIUM_IODIDE = 141
    ETHYLENE = 155
    FERROUS_SULFATE_DOSIMETER_SOLUTION = 160
    GLASS_PYREX = 169
    KAPTON_POLYIMIDE_FILM = 179
    LITHIUM_FLUORIDE = 185
    LITHIUM_TETRABORATE = 189
    M3_WAX = 191
    METHANE = 197
    MS20_TISSUE_SUBSTITUTE = 200
    MUSCLE_SKELETAL = 201
    MUSCLE_STRIATED = 202
    MUSCLE_EQUIVALENT_LIQUID_WITH_SUCROSE = 203
    MUSCLE_EQUIVALENT_LIQUID_WITHOUT_SUCROSE = 204
    NYLON_TYPE_6_AND_TYPE_6_BY_6 = 209
    PARAFFIN_WAX = 213
    PHOTOGRAPHIC_EMULSION = 215
    PLASTIC_SCINTILLATOR_VINYLTOLUENE_BASED = 216
    POLYCARBONATE_MAKROLON_LEXAN = 219
    POLYETHYLENE = 221
    POLYETHYLENE_TEREPHTHALATE_MYLAR = 222
    POLYMETHYL_METHACRALATE_LUCITE_PERSPEX = 223
    POLYPROPYLENE = 225
    POLYSTYRENE = 226
    POLYTETRAFLUOROETHYLENE_TEFLON = 227
    POLYVINYL_CHLORIDE = 232
    PROPANE = 238
    SILICON_DIOXIDE = 245
    SODIUM_IODIDE = 252
    STILBENE = 255
    TISSUE_EQUIVALENT_GAS_METHANE_BASED = 263
    TISSUE_EQUIVALENT_GAS_PROPANE_BASED = 264
    TOLUENE = 266
    WATER_LIQUID = 276
    WATER_VAPOR = 277
