"""Common types used in pystv."""
from dataclasses import dataclass

from icontract import invariant


class PyStvError(Exception):
    """Error in PyStv."""


@dataclass
class RaceMetadata:
    race_name: str
    num_seats: int
    names: list[str]


@invariant(lambda self: len(self.metadata.names) >= max(map(max, self.ballots)))
@invariant(lambda self: len(self.ballots) == len(self.votes))
@dataclass
class RaceInfo:
    metadata: RaceMetadata
    ballots: list[list[int]]
    votes: list


@dataclass
class RoundResult:
    count: list[float]
    elected: list[int]
    eliminated: list[int]
    transfers: dict[int, dict[int, float]]


@invariant(lambda self: len(set(len(r.count) for r in self.rounds)) < 2)
@invariant(
    lambda self: not self.rounds
    or (len(self.rounds[0].count) == len(self.metadata.names) + 1)
)
@dataclass
class RaceResult:
    metadata: RaceMetadata
    rounds: list[RoundResult]
