# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import typing
from enum import Enum

class AvailabilityInfo:
    r"""
    Availability information for an node
    """
    @property
    def available_until(self) -> typing.Optional[builtins.str]: ...
    @property
    def verification_score(self) -> builtins.float: ...
    @property
    def uptime_percentage(self) -> builtins.float: ...

class AvailableNode:
    r"""
    Available node with details and availability info
    """
    @property
    def node(self) -> NodeDetails: ...
    @property
    def availability(self) -> AvailabilityInfo: ...

class BasilicaClient:
    r"""
    Python wrapper for BasilicaClient
    """
    ...

class CpuSpec:
    r"""
    CPU specification details
    """
    @property
    def cores(self) -> builtins.int: ...
    @property
    def model(self) -> builtins.str: ...
    @property
    def memory_gb(self) -> builtins.int: ...

class NodeDetails:
    r"""
    Node details including GPU and CPU specifications
    """
    @property
    def id(self) -> builtins.str: ...
    @property
    def gpu_specs(self) -> builtins.list[GpuSpec]: ...
    @property
    def cpu_specs(self) -> CpuSpec: ...
    @property
    def location(self) -> typing.Optional[builtins.str]: ...

class GpuRequirements:
    r"""
    GPU requirements for node selection
    """
    @property
    def gpu_count(self) -> builtins.int: ...
    @property
    def gpu_type(self) -> typing.Optional[builtins.str]: ...
    @property
    def min_memory_gb(self) -> builtins.int: ...
    @gpu_count.setter
    def gpu_count(self, value: builtins.int) -> None: ...
    @gpu_type.setter
    def gpu_type(self, value: typing.Optional[builtins.str]) -> None: ...
    @min_memory_gb.setter
    def min_memory_gb(self, value: builtins.int) -> None: ...
    def __new__(cls, gpu_count:builtins.int, min_memory_gb:builtins.int, gpu_type:typing.Optional[builtins.str]=None) -> GpuRequirements: ...

class GpuSpec:
    r"""
    GPU specification details
    """
    @property
    def name(self) -> builtins.str: ...
    @property
    def memory_gb(self) -> builtins.int: ...
    @property
    def compute_capability(self) -> builtins.str: ...

class HealthCheckResponse:
    r"""
    Health check response
    """
    @property
    def status(self) -> builtins.str: ...
    @property
    def version(self) -> builtins.str: ...
    @property
    def timestamp(self) -> builtins.str: ...
    @property
    def healthy_validators(self) -> builtins.int: ...
    @property
    def total_validators(self) -> builtins.int: ...

class ListAvailableNodesQuery:
    r"""
    Query parameters for listing available nodes
    """
    @property
    def available(self) -> typing.Optional[builtins.bool]: ...
    @property
    def min_gpu_memory(self) -> typing.Optional[builtins.int]: ...
    @property
    def gpu_type(self) -> typing.Optional[builtins.str]: ...
    @property
    def min_gpu_count(self) -> typing.Optional[builtins.int]: ...
    @available.setter
    def available(self, value: typing.Optional[builtins.bool]) -> None: ...
    @min_gpu_memory.setter
    def min_gpu_memory(self, value: typing.Optional[builtins.int]) -> None: ...
    @gpu_type.setter
    def gpu_type(self, value: typing.Optional[builtins.str]) -> None: ...
    @min_gpu_count.setter
    def min_gpu_count(self, value: typing.Optional[builtins.int]) -> None: ...
    def __new__(cls, available:typing.Optional[builtins.bool]=None, min_gpu_memory:typing.Optional[builtins.int]=None, gpu_type:typing.Optional[builtins.str]=None, min_gpu_count:typing.Optional[builtins.int]=None) -> ListAvailableNodesQuery: ...

class ListRentalsQuery:
    r"""
    Query parameters for listing rentals
    """
    @property
    def status(self) -> typing.Optional[builtins.str]: ...
    @property
    def gpu_type(self) -> typing.Optional[builtins.str]: ...
    @property
    def min_gpu_count(self) -> typing.Optional[builtins.int]: ...
    @status.setter
    def status(self, value: typing.Optional[builtins.str]) -> None: ...
    @gpu_type.setter
    def gpu_type(self, value: typing.Optional[builtins.str]) -> None: ...
    @min_gpu_count.setter
    def min_gpu_count(self, value: typing.Optional[builtins.int]) -> None: ...
    def __new__(cls, status:typing.Optional[builtins.str]=None, gpu_type:typing.Optional[builtins.str]=None, min_gpu_count:typing.Optional[builtins.int]=None) -> ListRentalsQuery: ...

class PortMappingRequest:
    r"""
    Port mapping request
    """
    @property
    def container_port(self) -> builtins.int: ...
    @property
    def host_port(self) -> builtins.int: ...
    @property
    def protocol(self) -> builtins.str: ...
    @container_port.setter
    def container_port(self, value: builtins.int) -> None: ...
    @host_port.setter
    def host_port(self, value: builtins.int) -> None: ...
    @protocol.setter
    def protocol(self, value: builtins.str) -> None: ...
    def __new__(cls, container_port:builtins.int, host_port:builtins.int, protocol:typing.Optional[builtins.str]=None) -> PortMappingRequest: ...

class RentalResponse:
    r"""
    Response from starting a rental
    """
    @property
    def rental_id(self) -> builtins.str: ...
    @property
    def ssh_credentials(self) -> typing.Optional[builtins.str]: ...
    @property
    def container_id(self) -> builtins.str: ...
    @property
    def container_name(self) -> builtins.str: ...
    @property
    def status(self) -> builtins.str: ...

class RentalStatus:
    r"""
    Rental status enumeration
    """
    @property
    def state(self) -> builtins.str: ...
    @property
    def message(self) -> typing.Optional[builtins.str]: ...

class RentalStatusWithSshResponse:
    r"""
    Full rental status response with SSH credentials (matches API response)
    """
    @property
    def rental_id(self) -> builtins.str: ...
    @property
    def status(self) -> RentalStatus: ...
    @property
    def node(self) -> NodeDetails: ...
    @property
    def ssh_credentials(self) -> typing.Optional[builtins.str]: ...
    @property
    def created_at(self) -> builtins.str: ...
    @property
    def updated_at(self) -> builtins.str: ...

class ResourceRequirementsRequest:
    r"""
    Resource requirements request
    """
    @property
    def cpu_cores(self) -> builtins.float: ...
    @property
    def memory_mb(self) -> builtins.int: ...
    @property
    def storage_mb(self) -> builtins.int: ...
    @property
    def gpu_count(self) -> builtins.int: ...
    @property
    def gpu_types(self) -> builtins.list[builtins.str]: ...
    @cpu_cores.setter
    def cpu_cores(self, value: builtins.float) -> None: ...
    @memory_mb.setter
    def memory_mb(self, value: builtins.int) -> None: ...
    @storage_mb.setter
    def storage_mb(self, value: builtins.int) -> None: ...
    @gpu_count.setter
    def gpu_count(self, value: builtins.int) -> None: ...
    @gpu_types.setter
    def gpu_types(self, value: builtins.list[builtins.str]) -> None: ...
    def __new__(cls, cpu_cores:builtins.float=1.0, memory_mb:builtins.int=1024, storage_mb:builtins.int=10240, gpu_count:builtins.int=0, gpu_types:typing.Optional[typing.Sequence[builtins.str]]=None) -> ResourceRequirementsRequest: ...

class SshAccess:
    r"""
    SSH access information for a rental
    """
    @property
    def host(self) -> builtins.str: ...
    @property
    def port(self) -> builtins.int: ...
    @property
    def user(self) -> builtins.str: ...

class StartRentalApiRequest:
    r"""
    Start rental API request
    """
    @property
    def node_selection(self) -> NodeSelection: ...
    @property
    def container_image(self) -> builtins.str: ...
    @property
    def ssh_public_key(self) -> builtins.str: ...
    @property
    def environment(self) -> builtins.dict[builtins.str, builtins.str]: ...
    @property
    def ports(self) -> builtins.list[PortMappingRequest]: ...
    @property
    def resources(self) -> ResourceRequirementsRequest: ...
    @property
    def command(self) -> builtins.list[builtins.str]: ...
    @property
    def volumes(self) -> builtins.list[VolumeMountRequest]: ...
    @property
    def no_ssh(self) -> builtins.bool: ...
    @node_selection.setter
    def node_selection(self, value: NodeSelection) -> None: ...
    @container_image.setter
    def container_image(self, value: builtins.str) -> None: ...
    @ssh_public_key.setter
    def ssh_public_key(self, value: builtins.str) -> None: ...
    @environment.setter
    def environment(self, value: builtins.dict[builtins.str, builtins.str]) -> None: ...
    @ports.setter
    def ports(self, value: builtins.list[PortMappingRequest]) -> None: ...
    @resources.setter
    def resources(self, value: ResourceRequirementsRequest) -> None: ...
    @command.setter
    def command(self, value: builtins.list[builtins.str]) -> None: ...
    @volumes.setter
    def volumes(self, value: builtins.list[VolumeMountRequest]) -> None: ...
    @no_ssh.setter
    def no_ssh(self, value: builtins.bool) -> None: ...
    def __new__(cls, node_selection:NodeSelection, container_image:builtins.str, ssh_public_key:builtins.str, environment:typing.Optional[typing.Mapping[builtins.str, builtins.str]]=None, ports:typing.Optional[typing.Sequence[PortMappingRequest]]=None, resources:typing.Optional[ResourceRequirementsRequest]=None, command:typing.Optional[typing.Sequence[builtins.str]]=None, volumes:typing.Optional[typing.Sequence[VolumeMountRequest]]=None, no_ssh:builtins.bool=False) -> StartRentalApiRequest: ...

class VolumeMountRequest:
    r"""
    Volume mount request
    """
    @property
    def host_path(self) -> builtins.str: ...
    @property
    def container_path(self) -> builtins.str: ...
    @property
    def read_only(self) -> builtins.bool: ...
    @host_path.setter
    def host_path(self, value: builtins.str) -> None: ...
    @container_path.setter
    def container_path(self, value: builtins.str) -> None: ...
    @read_only.setter
    def read_only(self, value: builtins.bool) -> None: ...
    def __new__(cls, host_path:builtins.str, container_path:builtins.str, read_only:builtins.bool=False) -> VolumeMountRequest: ...

class NodeSelection(Enum):
    r"""
    Node selection strategy
    """
    NodeId = ...
    GpuRequirements = ...

def node_by_gpu(gpu_requirements:GpuRequirements) -> NodeSelection:
    r"""
    Helper function to create node selection by GPU requirements
    """

def node_by_id(node_id:builtins.str) -> NodeSelection:
    r"""
    Helper function to create node selection by ID
    """

