#[allow(dead_code, unused_imports, non_camel_case_types, unreachable_patterns)]
#[allow(clippy::all)]
#[allow(rustdoc::broken_intra_doc_links)]
pub mod api {
    #[allow(unused_imports)]
    mod root_mod {
        pub use super::*;
    }
    pub static PALLETS: [&str; 28usize] = [
        "System",
        "RandomnessCollectiveFlip",
        "Timestamp",
        "Aura",
        "Grandpa",
        "Balances",
        "TransactionPayment",
        "SubtensorModule",
        "Triumvirate",
        "TriumvirateMembers",
        "SenateMembers",
        "Utility",
        "Sudo",
        "Multisig",
        "Preimage",
        "Scheduler",
        "Proxy",
        "Registry",
        "Commitments",
        "AdminUtils",
        "SafeMode",
        "Ethereum",
        "EVM",
        "EVMChainId",
        "BaseFee",
        "Drand",
        "Crowdloan",
        "Swap",
    ];
    pub static RUNTIME_APIS: [&str; 20usize] = [
        "Core",
        "Metadata",
        "BlockBuilder",
        "GenesisBuilder",
        "TaggedTransactionQueue",
        "OffchainWorkerApi",
        "AuraApi",
        "SessionKeys",
        "GrandpaApi",
        "AccountNonceApi",
        "TransactionPaymentApi",
        "TransactionPaymentCallApi",
        "EthereumRuntimeRPCApi",
        "ConvertTransactionRuntimeApi",
        "DelegateInfoRuntimeApi",
        "NeuronInfoRuntimeApi",
        "SubnetInfoRuntimeApi",
        "StakeInfoRuntimeApi",
        "SubnetRegistrationRuntimeApi",
        "SwapRuntimeApi",
    ];
    #[doc = r" The error type that is returned when there is a runtime issue."]
    pub type DispatchError = runtime_types::sp_runtime::DispatchError;
    #[doc = r" The outer event enum."]
    pub type Event = runtime_types::node_subtensor_runtime::RuntimeEvent;
    #[doc = r" The outer extrinsic enum."]
    pub type Call = runtime_types::node_subtensor_runtime::RuntimeCall;
    #[doc = r" The outer error enum represents the DispatchError's Module variant."]
    pub type Error = runtime_types::node_subtensor_runtime::RuntimeError;
    pub fn constants() -> ConstantsApi {
        ConstantsApi
    }
    pub fn storage() -> StorageApi {
        StorageApi
    }
    pub fn tx() -> TransactionApi {
        TransactionApi
    }
    pub fn apis() -> runtime_apis::RuntimeApi {
        runtime_apis::RuntimeApi
    }
    pub mod runtime_apis {
        use super::root_mod;
        use super::runtime_types;
        use ::subxt::ext::subxt_core::ext::codec::Encode;
        pub struct RuntimeApi;
        impl RuntimeApi {
            pub fn core(&self) -> core::Core {
                core::Core
            }
            pub fn metadata(&self) -> metadata::Metadata {
                metadata::Metadata
            }
            pub fn block_builder(&self) -> block_builder::BlockBuilder {
                block_builder::BlockBuilder
            }
            pub fn genesis_builder(&self) -> genesis_builder::GenesisBuilder {
                genesis_builder::GenesisBuilder
            }
            pub fn tagged_transaction_queue(
                &self,
            ) -> tagged_transaction_queue::TaggedTransactionQueue {
                tagged_transaction_queue::TaggedTransactionQueue
            }
            pub fn offchain_worker_api(&self) -> offchain_worker_api::OffchainWorkerApi {
                offchain_worker_api::OffchainWorkerApi
            }
            pub fn aura_api(&self) -> aura_api::AuraApi {
                aura_api::AuraApi
            }
            pub fn session_keys(&self) -> session_keys::SessionKeys {
                session_keys::SessionKeys
            }
            pub fn grandpa_api(&self) -> grandpa_api::GrandpaApi {
                grandpa_api::GrandpaApi
            }
            pub fn account_nonce_api(&self) -> account_nonce_api::AccountNonceApi {
                account_nonce_api::AccountNonceApi
            }
            pub fn transaction_payment_api(
                &self,
            ) -> transaction_payment_api::TransactionPaymentApi {
                transaction_payment_api::TransactionPaymentApi
            }
            pub fn transaction_payment_call_api(
                &self,
            ) -> transaction_payment_call_api::TransactionPaymentCallApi {
                transaction_payment_call_api::TransactionPaymentCallApi
            }
            pub fn ethereum_runtime_rpc_api(
                &self,
            ) -> ethereum_runtime_rpc_api::EthereumRuntimeRPCApi {
                ethereum_runtime_rpc_api::EthereumRuntimeRPCApi
            }
            pub fn convert_transaction_runtime_api(
                &self,
            ) -> convert_transaction_runtime_api::ConvertTransactionRuntimeApi {
                convert_transaction_runtime_api::ConvertTransactionRuntimeApi
            }
            pub fn delegate_info_runtime_api(
                &self,
            ) -> delegate_info_runtime_api::DelegateInfoRuntimeApi {
                delegate_info_runtime_api::DelegateInfoRuntimeApi
            }
            pub fn neuron_info_runtime_api(&self) -> neuron_info_runtime_api::NeuronInfoRuntimeApi {
                neuron_info_runtime_api::NeuronInfoRuntimeApi
            }
            pub fn subnet_info_runtime_api(&self) -> subnet_info_runtime_api::SubnetInfoRuntimeApi {
                subnet_info_runtime_api::SubnetInfoRuntimeApi
            }
            pub fn stake_info_runtime_api(&self) -> stake_info_runtime_api::StakeInfoRuntimeApi {
                stake_info_runtime_api::StakeInfoRuntimeApi
            }
            pub fn subnet_registration_runtime_api(
                &self,
            ) -> subnet_registration_runtime_api::SubnetRegistrationRuntimeApi {
                subnet_registration_runtime_api::SubnetRegistrationRuntimeApi
            }
            pub fn swap_runtime_api(&self) -> swap_runtime_api::SwapRuntimeApi {
                swap_runtime_api::SwapRuntimeApi
            }
        }
        pub mod core {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " The `Core` runtime api that every Substrate runtime needs to implement."]
            pub struct Core;
            impl Core {
                #[doc = " Returns the version of the runtime."]
                pub fn version(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::Version,
                    types::version::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "Core",
                        "version",
                        types::Version {},
                        [
                            79u8, 22u8, 137u8, 4u8, 40u8, 64u8, 30u8, 180u8, 49u8, 222u8, 114u8,
                            125u8, 44u8, 25u8, 33u8, 152u8, 98u8, 42u8, 72u8, 178u8, 240u8, 103u8,
                            34u8, 187u8, 81u8, 161u8, 183u8, 6u8, 120u8, 2u8, 146u8, 0u8,
                        ],
                    )
                }
                #[doc = " Execute the given block."]
                pub fn execute_block(
                    &self,
                    block: types::execute_block::Block,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::ExecuteBlock,
                    types::execute_block::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "Core",
                        "execute_block",
                        types::ExecuteBlock { block },
                        [
                            71u8, 186u8, 53u8, 183u8, 85u8, 95u8, 61u8, 56u8, 159u8, 137u8, 111u8,
                            34u8, 39u8, 238u8, 212u8, 113u8, 200u8, 93u8, 118u8, 143u8, 186u8,
                            16u8, 79u8, 249u8, 95u8, 210u8, 240u8, 0u8, 220u8, 57u8, 121u8, 186u8,
                        ],
                    )
                }
                #[doc = " Initialize a block with the given header and return the runtime executive mode."]
                pub fn initialize_block(
                    &self,
                    header: types::initialize_block::Header,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::InitializeBlock,
                    types::initialize_block::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "Core",
                        "initialize_block",
                        types::InitializeBlock { header },
                        [
                            132u8, 169u8, 113u8, 112u8, 80u8, 139u8, 113u8, 35u8, 41u8, 81u8, 36u8,
                            35u8, 37u8, 202u8, 29u8, 207u8, 205u8, 229u8, 145u8, 7u8, 133u8, 94u8,
                            25u8, 108u8, 233u8, 86u8, 234u8, 29u8, 236u8, 57u8, 56u8, 186u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod version {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types::sp_version::RuntimeVersion;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct Version {}
                pub mod execute_block {
                    use super::runtime_types;
                    pub type Block = runtime_types :: sp_runtime :: generic :: block :: Block < runtime_types :: sp_runtime :: generic :: header :: Header < :: core :: primitive :: u32 > , runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > > ;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ();
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct ExecuteBlock {
                    pub block: execute_block::Block,
                }
                pub mod initialize_block {
                    use super::runtime_types;
                    pub type Header =
                        runtime_types::sp_runtime::generic::header::Header<::core::primitive::u32>;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types::sp_runtime::ExtrinsicInclusionMode;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct InitializeBlock {
                    pub header: initialize_block::Header,
                }
            }
        }
        pub mod metadata {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " The `Metadata` api trait that returns metadata for the runtime."]
            pub struct Metadata;
            impl Metadata {
                #[doc = " Returns the metadata of a runtime."]
                pub fn metadata(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::Metadata,
                    types::metadata::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "Metadata",
                        "metadata",
                        types::Metadata {},
                        [
                            231u8, 24u8, 67u8, 152u8, 23u8, 26u8, 188u8, 82u8, 229u8, 6u8, 185u8,
                            27u8, 175u8, 68u8, 83u8, 122u8, 69u8, 89u8, 185u8, 74u8, 248u8, 87u8,
                            217u8, 124u8, 193u8, 252u8, 199u8, 186u8, 196u8, 179u8, 179u8, 96u8,
                        ],
                    )
                }
                #[doc = " Returns the metadata at a given version."]
                #[doc = ""]
                #[doc = " If the given `version` isn't supported, this will return `None`."]
                #[doc = " Use [`Self::metadata_versions`] to find out about supported metadata version of the runtime."]
                pub fn metadata_at_version(
                    &self,
                    version: types::metadata_at_version::Version,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::MetadataAtVersion,
                    types::metadata_at_version::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "Metadata",
                        "metadata_at_version",
                        types::MetadataAtVersion { version },
                        [
                            131u8, 53u8, 212u8, 234u8, 16u8, 25u8, 120u8, 252u8, 153u8, 153u8,
                            216u8, 28u8, 54u8, 113u8, 52u8, 236u8, 146u8, 68u8, 142u8, 8u8, 10u8,
                            169u8, 131u8, 142u8, 204u8, 38u8, 48u8, 108u8, 134u8, 86u8, 226u8,
                            61u8,
                        ],
                    )
                }
                #[doc = " Returns the supported metadata versions."]
                #[doc = ""]
                #[doc = " This can be used to call `metadata_at_version`."]
                pub fn metadata_versions(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::MetadataVersions,
                    types::metadata_versions::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "Metadata",
                        "metadata_versions",
                        types::MetadataVersions {},
                        [
                            23u8, 144u8, 137u8, 91u8, 188u8, 39u8, 231u8, 208u8, 252u8, 218u8,
                            224u8, 176u8, 77u8, 32u8, 130u8, 212u8, 223u8, 76u8, 100u8, 190u8,
                            82u8, 94u8, 190u8, 8u8, 82u8, 244u8, 225u8, 179u8, 85u8, 176u8, 56u8,
                            16u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod metadata {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types::sp_core::OpaqueMetadata;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct Metadata {}
                pub mod metadata_at_version {
                    use super::runtime_types;
                    pub type Version = ::core::primitive::u32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            ::core::option::Option<runtime_types::sp_core::OpaqueMetadata>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct MetadataAtVersion {
                    pub version: metadata_at_version::Version,
                }
                pub mod metadata_versions {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u32>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct MetadataVersions {}
            }
        }
        pub mod block_builder {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " The `BlockBuilder` api trait that provides the required functionality for building a block."]
            pub struct BlockBuilder;
            impl BlockBuilder {
                #[doc = " Apply the given extrinsic."]
                #[doc = ""]
                #[doc = " Returns an inclusion outcome which specifies if this extrinsic is included in"]
                #[doc = " this block or not."]
                pub fn apply_extrinsic(
                    &self,
                    extrinsic: types::apply_extrinsic::Extrinsic,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::ApplyExtrinsic,
                    types::apply_extrinsic::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "BlockBuilder",
                        "apply_extrinsic",
                        types::ApplyExtrinsic { extrinsic },
                        [
                            20u8, 216u8, 216u8, 106u8, 88u8, 52u8, 32u8, 26u8, 170u8, 214u8, 30u8,
                            9u8, 196u8, 53u8, 223u8, 193u8, 132u8, 231u8, 31u8, 40u8, 178u8, 197u8,
                            238u8, 115u8, 153u8, 197u8, 220u8, 135u8, 253u8, 61u8, 58u8, 145u8,
                        ],
                    )
                }
                #[doc = " Finish the current block."]
                pub fn finalize_block(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::FinalizeBlock,
                    types::finalize_block::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "BlockBuilder",
                        "finalize_block",
                        types::FinalizeBlock {},
                        [
                            244u8, 207u8, 24u8, 33u8, 13u8, 69u8, 9u8, 249u8, 145u8, 143u8, 122u8,
                            96u8, 197u8, 55u8, 64u8, 111u8, 238u8, 224u8, 34u8, 201u8, 27u8, 146u8,
                            232u8, 99u8, 191u8, 30u8, 114u8, 16u8, 32u8, 220u8, 58u8, 62u8,
                        ],
                    )
                }
                #[doc = " Generate inherent extrinsics. The inherent data will vary from chain to chain."]
                pub fn inherent_extrinsics(
                    &self,
                    inherent: types::inherent_extrinsics::Inherent,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::InherentExtrinsics,
                    types::inherent_extrinsics::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "BlockBuilder",
                        "inherent_extrinsics",
                        types::InherentExtrinsics { inherent },
                        [
                            38u8, 7u8, 22u8, 96u8, 164u8, 159u8, 19u8, 22u8, 13u8, 1u8, 194u8,
                            99u8, 146u8, 217u8, 97u8, 235u8, 104u8, 166u8, 20u8, 158u8, 193u8,
                            203u8, 97u8, 247u8, 30u8, 246u8, 196u8, 113u8, 166u8, 78u8, 194u8,
                            163u8,
                        ],
                    )
                }
                #[doc = " Check that the inherents are valid. The inherent data will vary from chain to chain."]
                pub fn check_inherents(
                    &self,
                    block: types::check_inherents::Block,
                    data: types::check_inherents::Data,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::CheckInherents,
                    types::check_inherents::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "BlockBuilder",
                        "check_inherents",
                        types::CheckInherents { block, data },
                        [
                            188u8, 160u8, 23u8, 43u8, 139u8, 48u8, 47u8, 82u8, 226u8, 24u8, 53u8,
                            86u8, 114u8, 2u8, 206u8, 95u8, 174u8, 219u8, 60u8, 86u8, 142u8, 164u8,
                            171u8, 101u8, 249u8, 40u8, 171u8, 123u8, 137u8, 219u8, 122u8, 9u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod apply_extrinsic {
                    use super::runtime_types;
                    pub type Extrinsic = runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > ;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = :: core :: result :: Result < :: core :: result :: Result < () , runtime_types :: sp_runtime :: DispatchError > , runtime_types :: sp_runtime :: transaction_validity :: TransactionValidityError > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct ApplyExtrinsic {
                    pub extrinsic: apply_extrinsic::Extrinsic,
                }
                pub mod finalize_block {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types::sp_runtime::generic::header::Header<
                            ::core::primitive::u32,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct FinalizeBlock {}
                pub mod inherent_extrinsics {
                    use super::runtime_types;
                    pub type Inherent = runtime_types::sp_inherents::InherentData;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = :: subxt :: ext :: subxt_core :: alloc :: vec :: Vec < runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct InherentExtrinsics {
                    pub inherent: inherent_extrinsics::Inherent,
                }
                pub mod check_inherents {
                    use super::runtime_types;
                    pub type Block = runtime_types :: sp_runtime :: generic :: block :: Block < runtime_types :: sp_runtime :: generic :: header :: Header < :: core :: primitive :: u32 > , runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > > ;
                    pub type Data = runtime_types::sp_inherents::InherentData;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types::sp_inherents::CheckInherentsResult;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct CheckInherents {
                    pub block: check_inherents::Block,
                    pub data: check_inherents::Data,
                }
            }
        }
        pub mod genesis_builder {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " API to interact with `RuntimeGenesisConfig` for the runtime"]
            pub struct GenesisBuilder;
            impl GenesisBuilder {
                #[doc = " Build `RuntimeGenesisConfig` from a JSON blob not using any defaults and store it in the"]
                #[doc = " storage."]
                #[doc = ""]
                #[doc = " In the case of a FRAME-based runtime, this function deserializes the full"]
                #[doc = " `RuntimeGenesisConfig` from the given JSON blob and puts it into the storage. If the"]
                #[doc = " provided JSON blob is incorrect or incomplete or the deserialization fails, an error"]
                #[doc = " is returned."]
                #[doc = ""]
                #[doc = " Please note that provided JSON blob must contain all `RuntimeGenesisConfig` fields, no"]
                #[doc = " defaults will be used."]
                pub fn build_state(
                    &self,
                    json: types::build_state::Json,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::BuildState,
                    types::build_state::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "GenesisBuilder",
                        "build_state",
                        types::BuildState { json },
                        [
                            203u8, 233u8, 104u8, 116u8, 111u8, 131u8, 201u8, 235u8, 117u8, 116u8,
                            140u8, 185u8, 93u8, 25u8, 155u8, 210u8, 56u8, 49u8, 23u8, 32u8, 253u8,
                            92u8, 149u8, 241u8, 85u8, 245u8, 137u8, 45u8, 209u8, 189u8, 81u8, 2u8,
                        ],
                    )
                }
                #[doc = " Returns a JSON blob representation of the built-in `RuntimeGenesisConfig` identified by"]
                #[doc = " `id`."]
                #[doc = ""]
                #[doc = " If `id` is `None` the function should return JSON blob representation of the default"]
                #[doc = " `RuntimeGenesisConfig` struct of the runtime. Implementation must provide default"]
                #[doc = " `RuntimeGenesisConfig`."]
                #[doc = ""]
                #[doc = " Otherwise function returns a JSON representation of the built-in, named"]
                #[doc = " `RuntimeGenesisConfig` preset identified by `id`, or `None` if such preset does not"]
                #[doc = " exist. Returned `Vec<u8>` contains bytes of JSON blob (patch) which comprises a list of"]
                #[doc = " (potentially nested) key-value pairs that are intended for customizing the default"]
                #[doc = " runtime genesis config. The patch shall be merged (rfc7386) with the JSON representation"]
                #[doc = " of the default `RuntimeGenesisConfig` to create a comprehensive genesis config that can"]
                #[doc = " be used in `build_state` method."]
                pub fn get_preset(
                    &self,
                    id: types::get_preset::Id,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetPreset,
                    types::get_preset::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "GenesisBuilder",
                        "get_preset",
                        types::GetPreset { id },
                        [
                            43u8, 153u8, 23u8, 52u8, 113u8, 161u8, 227u8, 122u8, 169u8, 135u8,
                            119u8, 8u8, 128u8, 33u8, 143u8, 235u8, 13u8, 173u8, 58u8, 121u8, 178u8,
                            223u8, 66u8, 217u8, 22u8, 244u8, 168u8, 113u8, 202u8, 186u8, 241u8,
                            124u8,
                        ],
                    )
                }
                #[doc = " Returns a list of identifiers for available builtin `RuntimeGenesisConfig` presets."]
                #[doc = ""]
                #[doc = " The presets from the list can be queried with [`GenesisBuilder::get_preset`] method. If"]
                #[doc = " no named presets are provided by the runtime the list is empty."]
                pub fn preset_names(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::PresetNames,
                    types::preset_names::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "GenesisBuilder",
                        "preset_names",
                        types::PresetNames {},
                        [
                            150u8, 117u8, 54u8, 129u8, 221u8, 130u8, 186u8, 71u8, 13u8, 140u8,
                            77u8, 180u8, 141u8, 37u8, 22u8, 219u8, 149u8, 218u8, 186u8, 206u8,
                            80u8, 42u8, 165u8, 41u8, 99u8, 184u8, 73u8, 37u8, 125u8, 188u8, 167u8,
                            122u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod build_state {
                    use super::runtime_types;
                    pub type Json =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::result::Result<
                            (),
                            ::subxt::ext::subxt_core::alloc::string::String,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct BuildState {
                    pub json: build_state::Json,
                }
                pub mod get_preset {
                    use super::runtime_types;
                    pub type Id =
                        ::core::option::Option<::subxt::ext::subxt_core::alloc::string::String>;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetPreset {
                    pub id: get_preset::Id,
                }
                pub mod preset_names {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            ::subxt::ext::subxt_core::alloc::string::String,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct PresetNames {}
            }
        }
        pub mod tagged_transaction_queue {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " The `TaggedTransactionQueue` api trait for interfering with the transaction queue."]
            pub struct TaggedTransactionQueue;
            impl TaggedTransactionQueue {
                #[doc = " Validate the transaction."]
                #[doc = ""]
                #[doc = " This method is invoked by the transaction pool to learn details about given transaction."]
                #[doc = " The implementation should make sure to verify the correctness of the transaction"]
                #[doc = " against current state. The given `block_hash` corresponds to the hash of the block"]
                #[doc = " that is used as current state."]
                #[doc = ""]
                #[doc = " Note that this call may be performed by the pool multiple times and transactions"]
                #[doc = " might be verified in any possible order."]
                pub fn validate_transaction(
                    &self,
                    source: types::validate_transaction::Source,
                    tx: types::validate_transaction::Tx,
                    block_hash: types::validate_transaction::BlockHash,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::ValidateTransaction,
                    types::validate_transaction::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TaggedTransactionQueue",
                        "validate_transaction",
                        types::ValidateTransaction {
                            source,
                            tx,
                            block_hash,
                        },
                        [
                            213u8, 188u8, 51u8, 29u8, 155u8, 246u8, 70u8, 43u8, 224u8, 47u8, 160u8,
                            105u8, 29u8, 125u8, 243u8, 213u8, 51u8, 162u8, 72u8, 94u8, 125u8,
                            108u8, 239u8, 233u8, 74u8, 163u8, 13u8, 19u8, 170u8, 140u8, 31u8,
                            254u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod validate_transaction {
                    use super::runtime_types;
                    pub type Source =
                        runtime_types::sp_runtime::transaction_validity::TransactionSource;
                    pub type Tx = runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > ;
                    pub type BlockHash = ::subxt::ext::subxt_core::utils::H256;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = :: core :: result :: Result < runtime_types :: sp_runtime :: transaction_validity :: ValidTransaction , runtime_types :: sp_runtime :: transaction_validity :: TransactionValidityError > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct ValidateTransaction {
                    pub source: validate_transaction::Source,
                    pub tx: validate_transaction::Tx,
                    pub block_hash: validate_transaction::BlockHash,
                }
            }
        }
        pub mod offchain_worker_api {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " The offchain worker api."]
            pub struct OffchainWorkerApi;
            impl OffchainWorkerApi {
                #[doc = " Starts the off-chain task for given block header."]
                pub fn offchain_worker(
                    &self,
                    header: types::offchain_worker::Header,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::OffchainWorker,
                    types::offchain_worker::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "OffchainWorkerApi",
                        "offchain_worker",
                        types::OffchainWorker { header },
                        [
                            10u8, 135u8, 19u8, 153u8, 33u8, 216u8, 18u8, 242u8, 33u8, 140u8, 4u8,
                            223u8, 200u8, 130u8, 103u8, 118u8, 137u8, 24u8, 19u8, 127u8, 161u8,
                            29u8, 184u8, 111u8, 222u8, 111u8, 253u8, 73u8, 45u8, 31u8, 79u8, 60u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod offchain_worker {
                    use super::runtime_types;
                    pub type Header =
                        runtime_types::sp_runtime::generic::header::Header<::core::primitive::u32>;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ();
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct OffchainWorker {
                    pub header: offchain_worker::Header,
                }
            }
        }
        pub mod aura_api {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " API necessary for block authorship with aura."]
            pub struct AuraApi;
            impl AuraApi {
                #[doc = " Returns the slot duration for Aura."]
                #[doc = ""]
                #[doc = " Currently, only the value provided by this type at genesis will be used."]
                pub fn slot_duration(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::SlotDuration,
                    types::slot_duration::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "AuraApi",
                        "slot_duration",
                        types::SlotDuration {},
                        [
                            233u8, 210u8, 132u8, 172u8, 100u8, 125u8, 239u8, 92u8, 114u8, 82u8,
                            7u8, 110u8, 179u8, 196u8, 10u8, 19u8, 211u8, 15u8, 174u8, 2u8, 91u8,
                            73u8, 133u8, 100u8, 205u8, 201u8, 191u8, 60u8, 163u8, 122u8, 215u8,
                            10u8,
                        ],
                    )
                }
                #[doc = " Return the current set of authorities."]
                pub fn authorities(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::Authorities,
                    types::authorities::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "AuraApi",
                        "authorities",
                        types::Authorities {},
                        [
                            35u8, 244u8, 24u8, 155u8, 95u8, 1u8, 221u8, 159u8, 33u8, 144u8, 213u8,
                            26u8, 13u8, 21u8, 136u8, 72u8, 45u8, 47u8, 15u8, 51u8, 235u8, 10u8,
                            6u8, 219u8, 9u8, 246u8, 50u8, 252u8, 49u8, 77u8, 64u8, 182u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod slot_duration {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types::sp_consensus_slots::SlotDuration;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct SlotDuration {}
                pub mod authorities {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            runtime_types::sp_consensus_aura::sr25519::app_sr25519::Public,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct Authorities {}
            }
        }
        pub mod session_keys {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " Session keys runtime api."]
            pub struct SessionKeys;
            impl SessionKeys {
                #[doc = " Generate a set of session keys with optionally using the given seed."]
                #[doc = " The keys should be stored within the keystore exposed via runtime"]
                #[doc = " externalities."]
                #[doc = ""]
                #[doc = " The seed needs to be a valid `utf8` string."]
                #[doc = ""]
                #[doc = " Returns the concatenated SCALE encoded public keys."]
                pub fn generate_session_keys(
                    &self,
                    seed: types::generate_session_keys::Seed,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GenerateSessionKeys,
                    types::generate_session_keys::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SessionKeys",
                        "generate_session_keys",
                        types::GenerateSessionKeys { seed },
                        [
                            96u8, 171u8, 164u8, 166u8, 175u8, 102u8, 101u8, 47u8, 133u8, 95u8,
                            102u8, 202u8, 83u8, 26u8, 238u8, 47u8, 126u8, 132u8, 22u8, 11u8, 33u8,
                            190u8, 175u8, 94u8, 58u8, 245u8, 46u8, 80u8, 195u8, 184u8, 107u8, 65u8,
                        ],
                    )
                }
                #[doc = " Decode the given public session keys."]
                #[doc = ""]
                #[doc = " Returns the list of public raw public keys + key type."]
                pub fn decode_session_keys(
                    &self,
                    encoded: types::decode_session_keys::Encoded,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::DecodeSessionKeys,
                    types::decode_session_keys::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SessionKeys",
                        "decode_session_keys",
                        types::DecodeSessionKeys { encoded },
                        [
                            57u8, 242u8, 18u8, 51u8, 132u8, 110u8, 238u8, 255u8, 39u8, 194u8, 8u8,
                            54u8, 198u8, 178u8, 75u8, 151u8, 148u8, 176u8, 144u8, 197u8, 87u8,
                            29u8, 179u8, 235u8, 176u8, 78u8, 252u8, 103u8, 72u8, 203u8, 151u8,
                            248u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod generate_session_keys {
                    use super::runtime_types;
                    pub type Seed = ::core::option::Option<
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>,
                    >;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GenerateSessionKeys {
                    pub seed: generate_session_keys::Seed,
                }
                pub mod decode_session_keys {
                    use super::runtime_types;
                    pub type Encoded =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            ::subxt::ext::subxt_core::alloc::vec::Vec<(
                                ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>,
                                runtime_types::sp_core::crypto::KeyTypeId,
                            )>,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct DecodeSessionKeys {
                    pub encoded: decode_session_keys::Encoded,
                }
            }
        }
        pub mod grandpa_api {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " APIs for integrating the GRANDPA finality gadget into runtimes."]
            #[doc = " This should be implemented on the runtime side."]
            #[doc = ""]
            #[doc = " This is primarily used for negotiating authority-set changes for the"]
            #[doc = " gadget. GRANDPA uses a signaling model of changing authority sets:"]
            #[doc = " changes should be signaled with a delay of N blocks, and then automatically"]
            #[doc = " applied in the runtime after those N blocks have passed."]
            #[doc = ""]
            #[doc = " The consensus protocol will coordinate the handoff externally."]
            pub struct GrandpaApi;
            impl GrandpaApi {
                #[doc = " Get the current GRANDPA authorities and weights. This should not change except"]
                #[doc = " for when changes are scheduled and the corresponding delay has passed."]
                #[doc = ""]
                #[doc = " When called at block B, it will return the set of authorities that should be"]
                #[doc = " used to finalize descendants of this block (B+1, B+2, ...). The block B itself"]
                #[doc = " is finalized by the authorities from block B-1."]
                pub fn grandpa_authorities(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GrandpaAuthorities,
                    types::grandpa_authorities::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "GrandpaApi",
                        "grandpa_authorities",
                        types::GrandpaAuthorities {},
                        [
                            8u8, 1u8, 99u8, 227u8, 52u8, 95u8, 230u8, 139u8, 198u8, 90u8, 159u8,
                            146u8, 193u8, 81u8, 37u8, 27u8, 216u8, 227u8, 108u8, 126u8, 12u8, 94u8,
                            125u8, 183u8, 143u8, 231u8, 87u8, 101u8, 114u8, 190u8, 193u8, 180u8,
                        ],
                    )
                }
                #[doc = " Submits an unsigned extrinsic to report an equivocation. The caller"]
                #[doc = " must provide the equivocation proof and a key ownership proof"]
                #[doc = " (should be obtained using `generate_key_ownership_proof`). The"]
                #[doc = " extrinsic will be unsigned and should only be accepted for local"]
                #[doc = " authorship (not to be broadcast to the network). This method returns"]
                #[doc = " `None` when creation of the extrinsic fails, e.g. if equivocation"]
                #[doc = " reporting is disabled for the given runtime (i.e. this method is"]
                #[doc = " hardcoded to return `None`). Only useful in an offchain context."]
                pub fn submit_report_equivocation_unsigned_extrinsic(
                    &self,
                    equivocation_proof : types :: submit_report_equivocation_unsigned_extrinsic :: EquivocationProof,
                    key_owner_proof : types :: submit_report_equivocation_unsigned_extrinsic :: KeyOwnerProof,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::SubmitReportEquivocationUnsignedExtrinsic,
                    types::submit_report_equivocation_unsigned_extrinsic::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "GrandpaApi",
                        "submit_report_equivocation_unsigned_extrinsic",
                        types::SubmitReportEquivocationUnsignedExtrinsic {
                            equivocation_proof,
                            key_owner_proof,
                        },
                        [
                            27u8, 32u8, 16u8, 79u8, 172u8, 124u8, 44u8, 13u8, 176u8, 89u8, 69u8,
                            60u8, 45u8, 176u8, 72u8, 151u8, 252u8, 5u8, 243u8, 82u8, 170u8, 51u8,
                            179u8, 197u8, 117u8, 177u8, 110u8, 111u8, 97u8, 15u8, 109u8, 169u8,
                        ],
                    )
                }
                #[doc = " Generates a proof of key ownership for the given authority in the"]
                #[doc = " given set. An example usage of this module is coupled with the"]
                #[doc = " session historical module to prove that a given authority key is"]
                #[doc = " tied to a given staking identity during a specific session. Proofs"]
                #[doc = " of key ownership are necessary for submitting equivocation reports."]
                #[doc = " NOTE: even though the API takes a `set_id` as parameter the current"]
                #[doc = " implementations ignore this parameter and instead rely on this"]
                #[doc = " method being called at the correct block height, i.e. any point at"]
                #[doc = " which the given set id is live on-chain. Future implementations will"]
                #[doc = " instead use indexed data through an offchain worker, not requiring"]
                #[doc = " older states to be available."]
                pub fn generate_key_ownership_proof(
                    &self,
                    set_id: types::generate_key_ownership_proof::SetId,
                    authority_id: types::generate_key_ownership_proof::AuthorityId,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GenerateKeyOwnershipProof,
                    types::generate_key_ownership_proof::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "GrandpaApi",
                        "generate_key_ownership_proof",
                        types::GenerateKeyOwnershipProof {
                            set_id,
                            authority_id,
                        },
                        [
                            13u8, 144u8, 66u8, 235u8, 24u8, 190u8, 39u8, 75u8, 29u8, 157u8, 215u8,
                            181u8, 173u8, 145u8, 224u8, 244u8, 189u8, 79u8, 6u8, 116u8, 139u8,
                            196u8, 54u8, 16u8, 89u8, 190u8, 121u8, 43u8, 137u8, 150u8, 117u8, 68u8,
                        ],
                    )
                }
                #[doc = " Get current GRANDPA authority set id."]
                pub fn current_set_id(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::CurrentSetId,
                    types::current_set_id::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "GrandpaApi",
                        "current_set_id",
                        types::CurrentSetId {},
                        [
                            42u8, 230u8, 120u8, 211u8, 156u8, 245u8, 109u8, 86u8, 100u8, 146u8,
                            234u8, 205u8, 41u8, 183u8, 109u8, 42u8, 17u8, 33u8, 156u8, 25u8, 139u8,
                            84u8, 101u8, 75u8, 232u8, 198u8, 87u8, 136u8, 218u8, 233u8, 103u8,
                            156u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod grandpa_authorities {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                            runtime_types::sp_consensus_grandpa::app::Public,
                            ::core::primitive::u64,
                        )>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GrandpaAuthorities {}
                pub mod submit_report_equivocation_unsigned_extrinsic {
                    use super::runtime_types;
                    pub type EquivocationProof =
                        runtime_types::sp_consensus_grandpa::EquivocationProof<
                            ::subxt::ext::subxt_core::utils::H256,
                            ::core::primitive::u32,
                        >;
                    pub type KeyOwnerProof = runtime_types::sp_runtime::OpaqueValue;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<()>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct SubmitReportEquivocationUnsignedExtrinsic {
                    pub equivocation_proof:
                        submit_report_equivocation_unsigned_extrinsic::EquivocationProof,
                    pub key_owner_proof:
                        submit_report_equivocation_unsigned_extrinsic::KeyOwnerProof,
                }
                pub mod generate_key_ownership_proof {
                    use super::runtime_types;
                    pub type SetId = ::core::primitive::u64;
                    pub type AuthorityId = runtime_types::sp_consensus_grandpa::app::Public;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            ::core::option::Option<runtime_types::sp_runtime::OpaqueValue>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GenerateKeyOwnershipProof {
                    pub set_id: generate_key_ownership_proof::SetId,
                    pub authority_id: generate_key_ownership_proof::AuthorityId,
                }
                pub mod current_set_id {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct CurrentSetId {}
            }
        }
        pub mod account_nonce_api {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " The API to query account nonce."]
            pub struct AccountNonceApi;
            impl AccountNonceApi {
                #[doc = " Get current account nonce of given `AccountId`."]
                pub fn account_nonce(
                    &self,
                    account: types::account_nonce::Account,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::AccountNonce,
                    types::account_nonce::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "AccountNonceApi",
                        "account_nonce",
                        types::AccountNonce { account },
                        [
                            231u8, 82u8, 7u8, 227u8, 131u8, 2u8, 215u8, 252u8, 173u8, 82u8, 11u8,
                            103u8, 200u8, 25u8, 114u8, 116u8, 79u8, 229u8, 152u8, 150u8, 236u8,
                            37u8, 101u8, 26u8, 220u8, 146u8, 182u8, 101u8, 73u8, 55u8, 191u8,
                            171u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod account_nonce {
                    use super::runtime_types;
                    pub type Account = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u32;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct AccountNonce {
                    pub account: account_nonce::Account,
                }
            }
        }
        pub mod transaction_payment_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct TransactionPaymentApi;
            impl TransactionPaymentApi {
                pub fn query_info(
                    &self,
                    uxt: types::query_info::Uxt,
                    len: types::query_info::Len,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::QueryInfo,
                    types::query_info::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TransactionPaymentApi",
                        "query_info",
                        types::QueryInfo { uxt, len },
                        [
                            54u8, 3u8, 155u8, 175u8, 234u8, 40u8, 67u8, 208u8, 24u8, 38u8, 236u8,
                            154u8, 89u8, 131u8, 217u8, 136u8, 252u8, 10u8, 141u8, 112u8, 149u8,
                            20u8, 41u8, 128u8, 156u8, 55u8, 153u8, 255u8, 211u8, 133u8, 25u8,
                            205u8,
                        ],
                    )
                }
                pub fn query_fee_details(
                    &self,
                    uxt: types::query_fee_details::Uxt,
                    len: types::query_fee_details::Len,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::QueryFeeDetails,
                    types::query_fee_details::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TransactionPaymentApi",
                        "query_fee_details",
                        types::QueryFeeDetails { uxt, len },
                        [
                            74u8, 176u8, 154u8, 28u8, 200u8, 208u8, 20u8, 237u8, 75u8, 65u8, 27u8,
                            89u8, 157u8, 255u8, 254u8, 124u8, 34u8, 79u8, 226u8, 13u8, 110u8,
                            118u8, 59u8, 76u8, 197u8, 21u8, 251u8, 42u8, 179u8, 203u8, 122u8, 88u8,
                        ],
                    )
                }
                pub fn query_weight_to_fee(
                    &self,
                    weight: types::query_weight_to_fee::Weight,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::QueryWeightToFee,
                    types::query_weight_to_fee::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TransactionPaymentApi",
                        "query_weight_to_fee",
                        types::QueryWeightToFee { weight },
                        [
                            43u8, 38u8, 7u8, 127u8, 93u8, 202u8, 221u8, 100u8, 79u8, 26u8, 61u8,
                            51u8, 106u8, 250u8, 233u8, 161u8, 32u8, 72u8, 198u8, 28u8, 94u8, 150u8,
                            8u8, 143u8, 58u8, 148u8, 69u8, 198u8, 215u8, 27u8, 186u8, 242u8,
                        ],
                    )
                }
                pub fn query_length_to_fee(
                    &self,
                    length: types::query_length_to_fee::Length,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::QueryLengthToFee,
                    types::query_length_to_fee::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TransactionPaymentApi",
                        "query_length_to_fee",
                        types::QueryLengthToFee { length },
                        [
                            129u8, 136u8, 216u8, 144u8, 66u8, 102u8, 146u8, 169u8, 202u8, 11u8,
                            0u8, 146u8, 200u8, 172u8, 84u8, 238u8, 129u8, 32u8, 214u8, 169u8,
                            130u8, 111u8, 112u8, 68u8, 51u8, 8u8, 174u8, 90u8, 81u8, 46u8, 0u8,
                            249u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod query_info {
                    use super::runtime_types;
                    pub type Uxt = runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > ;
                    pub type Len = ::core::primitive::u32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            runtime_types::pallet_transaction_payment::types::RuntimeDispatchInfo<
                                ::core::primitive::u64,
                                runtime_types::sp_weights::weight_v2::Weight,
                            >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct QueryInfo {
                    pub uxt: query_info::Uxt,
                    pub len: query_info::Len,
                }
                pub mod query_fee_details {
                    use super::runtime_types;
                    pub type Uxt = runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > ;
                    pub type Len = ::core::primitive::u32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            runtime_types::pallet_transaction_payment::types::FeeDetails<
                                ::core::primitive::u64,
                            >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct QueryFeeDetails {
                    pub uxt: query_fee_details::Uxt,
                    pub len: query_fee_details::Len,
                }
                pub mod query_weight_to_fee {
                    use super::runtime_types;
                    pub type Weight = runtime_types::sp_weights::weight_v2::Weight;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct QueryWeightToFee {
                    pub weight: query_weight_to_fee::Weight,
                }
                pub mod query_length_to_fee {
                    use super::runtime_types;
                    pub type Length = ::core::primitive::u32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct QueryLengthToFee {
                    pub length: query_length_to_fee::Length,
                }
            }
        }
        pub mod transaction_payment_call_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct TransactionPaymentCallApi;
            impl TransactionPaymentCallApi {
                #[doc = " Query information of a dispatch class, weight, and fee of a given encoded `Call`."]
                pub fn query_call_info(
                    &self,
                    call: types::query_call_info::Call,
                    len: types::query_call_info::Len,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::QueryCallInfo,
                    types::query_call_info::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TransactionPaymentCallApi",
                        "query_call_info",
                        types::QueryCallInfo { call, len },
                        [
                            232u8, 94u8, 156u8, 65u8, 7u8, 162u8, 100u8, 152u8, 103u8, 27u8, 25u8,
                            164u8, 24u8, 64u8, 6u8, 116u8, 104u8, 212u8, 174u8, 151u8, 181u8,
                            212u8, 208u8, 18u8, 121u8, 49u8, 224u8, 152u8, 213u8, 21u8, 209u8,
                            108u8,
                        ],
                    )
                }
                #[doc = " Query fee details of a given encoded `Call`."]
                pub fn query_call_fee_details(
                    &self,
                    call: types::query_call_fee_details::Call,
                    len: types::query_call_fee_details::Len,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::QueryCallFeeDetails,
                    types::query_call_fee_details::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TransactionPaymentCallApi",
                        "query_call_fee_details",
                        types::QueryCallFeeDetails { call, len },
                        [
                            181u8, 90u8, 105u8, 6u8, 149u8, 166u8, 214u8, 159u8, 249u8, 108u8,
                            128u8, 134u8, 136u8, 238u8, 178u8, 17u8, 193u8, 145u8, 48u8, 204u8,
                            156u8, 251u8, 244u8, 67u8, 17u8, 40u8, 75u8, 83u8, 192u8, 213u8, 33u8,
                            99u8,
                        ],
                    )
                }
                #[doc = " Query the output of the current `WeightToFee` given some input."]
                pub fn query_weight_to_fee(
                    &self,
                    weight: types::query_weight_to_fee::Weight,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::QueryWeightToFee,
                    types::query_weight_to_fee::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TransactionPaymentCallApi",
                        "query_weight_to_fee",
                        types::QueryWeightToFee { weight },
                        [
                            154u8, 155u8, 82u8, 35u8, 212u8, 163u8, 97u8, 198u8, 2u8, 206u8, 243u8,
                            23u8, 100u8, 233u8, 202u8, 247u8, 176u8, 177u8, 138u8, 135u8, 164u8,
                            220u8, 9u8, 182u8, 226u8, 22u8, 29u8, 173u8, 234u8, 18u8, 230u8, 184u8,
                        ],
                    )
                }
                #[doc = " Query the output of the current `LengthToFee` given some input."]
                pub fn query_length_to_fee(
                    &self,
                    length: types::query_length_to_fee::Length,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::QueryLengthToFee,
                    types::query_length_to_fee::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "TransactionPaymentCallApi",
                        "query_length_to_fee",
                        types::QueryLengthToFee { length },
                        [
                            81u8, 163u8, 41u8, 53u8, 39u8, 220u8, 142u8, 196u8, 240u8, 62u8, 204u8,
                            3u8, 172u8, 25u8, 99u8, 48u8, 143u8, 115u8, 9u8, 151u8, 167u8, 209u8,
                            207u8, 224u8, 50u8, 232u8, 73u8, 176u8, 130u8, 80u8, 185u8, 105u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod query_call_info {
                    use super::runtime_types;
                    pub type Call = runtime_types::node_subtensor_runtime::RuntimeCall;
                    pub type Len = ::core::primitive::u32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            runtime_types::pallet_transaction_payment::types::RuntimeDispatchInfo<
                                ::core::primitive::u64,
                                runtime_types::sp_weights::weight_v2::Weight,
                            >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct QueryCallInfo {
                    pub call: query_call_info::Call,
                    pub len: query_call_info::Len,
                }
                pub mod query_call_fee_details {
                    use super::runtime_types;
                    pub type Call = runtime_types::node_subtensor_runtime::RuntimeCall;
                    pub type Len = ::core::primitive::u32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            runtime_types::pallet_transaction_payment::types::FeeDetails<
                                ::core::primitive::u64,
                            >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct QueryCallFeeDetails {
                    pub call: query_call_fee_details::Call,
                    pub len: query_call_fee_details::Len,
                }
                pub mod query_weight_to_fee {
                    use super::runtime_types;
                    pub type Weight = runtime_types::sp_weights::weight_v2::Weight;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct QueryWeightToFee {
                    pub weight: query_weight_to_fee::Weight,
                }
                pub mod query_length_to_fee {
                    use super::runtime_types;
                    pub type Length = ::core::primitive::u32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct QueryLengthToFee {
                    pub length: query_length_to_fee::Length,
                }
            }
        }
        pub mod ethereum_runtime_rpc_api {
            use super::root_mod;
            use super::runtime_types;
            #[doc = " API necessary for Ethereum-compatibility layer."]
            pub struct EthereumRuntimeRPCApi;
            impl EthereumRuntimeRPCApi {
                #[doc = " Returns runtime defined pallet_evm::ChainId."]
                pub fn chain_id(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::ChainId,
                    types::chain_id::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "chain_id",
                        types::ChainId {},
                        [
                            119u8, 123u8, 11u8, 231u8, 92u8, 198u8, 90u8, 85u8, 52u8, 55u8, 105u8,
                            101u8, 142u8, 11u8, 27u8, 201u8, 110u8, 228u8, 114u8, 128u8, 217u8,
                            236u8, 146u8, 229u8, 7u8, 81u8, 102u8, 18u8, 115u8, 141u8, 216u8,
                            164u8,
                        ],
                    )
                }
                #[doc = " Returns pallet_evm::Accounts by address."]
                pub fn account_basic(
                    &self,
                    address: types::account_basic::Address,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::AccountBasic,
                    types::account_basic::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "account_basic",
                        types::AccountBasic { address },
                        [
                            253u8, 214u8, 163u8, 33u8, 163u8, 38u8, 64u8, 14u8, 118u8, 135u8, 77u8,
                            215u8, 45u8, 161u8, 43u8, 40u8, 140u8, 131u8, 209u8, 187u8, 171u8,
                            129u8, 42u8, 206u8, 175u8, 50u8, 208u8, 186u8, 216u8, 109u8, 166u8,
                            123u8,
                        ],
                    )
                }
                #[doc = " Returns FixedGasPrice::min_gas_price"]
                pub fn gas_price(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GasPrice,
                    types::gas_price::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "gas_price",
                        types::GasPrice {},
                        [
                            109u8, 203u8, 181u8, 107u8, 184u8, 171u8, 218u8, 171u8, 23u8, 235u8,
                            214u8, 209u8, 233u8, 89u8, 99u8, 63u8, 16u8, 175u8, 44u8, 31u8, 241u8,
                            122u8, 126u8, 146u8, 146u8, 131u8, 11u8, 84u8, 129u8, 203u8, 249u8,
                            235u8,
                        ],
                    )
                }
                #[doc = " For a given account address, returns pallet_evm::AccountCodes."]
                pub fn account_code_at(
                    &self,
                    address: types::account_code_at::Address,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::AccountCodeAt,
                    types::account_code_at::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "account_code_at",
                        types::AccountCodeAt { address },
                        [
                            140u8, 192u8, 250u8, 89u8, 84u8, 152u8, 124u8, 241u8, 255u8, 64u8,
                            238u8, 86u8, 13u8, 46u8, 252u8, 66u8, 62u8, 109u8, 46u8, 229u8, 126u8,
                            188u8, 64u8, 24u8, 75u8, 157u8, 217u8, 154u8, 102u8, 207u8, 181u8,
                            254u8,
                        ],
                    )
                }
                #[doc = " Returns the converted FindAuthor::find_author authority id."]
                pub fn author(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::Author,
                    types::author::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "author",
                        types::Author {},
                        [
                            101u8, 105u8, 12u8, 234u8, 72u8, 53u8, 32u8, 56u8, 226u8, 189u8, 216u8,
                            228u8, 196u8, 14u8, 147u8, 191u8, 144u8, 203u8, 195u8, 85u8, 162u8,
                            67u8, 86u8, 196u8, 116u8, 129u8, 57u8, 102u8, 223u8, 129u8, 222u8,
                            71u8,
                        ],
                    )
                }
                #[doc = " For a given account address and index, returns pallet_evm::AccountStorages."]
                pub fn storage_at(
                    &self,
                    address: types::storage_at::Address,
                    index: types::storage_at::Index,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::StorageAt,
                    types::storage_at::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "storage_at",
                        types::StorageAt { address, index },
                        [
                            19u8, 29u8, 54u8, 70u8, 199u8, 223u8, 39u8, 4u8, 126u8, 126u8, 81u8,
                            102u8, 223u8, 60u8, 2u8, 155u8, 60u8, 167u8, 0u8, 219u8, 98u8, 236u8,
                            145u8, 115u8, 202u8, 87u8, 183u8, 131u8, 230u8, 189u8, 228u8, 91u8,
                        ],
                    )
                }
                pub fn call(
                    &self,
                    from: types::call::From,
                    to: types::call::To,
                    data: types::call::Data,
                    value: types::call::Value,
                    gas_limit: types::call::GasLimit,
                    max_fee_per_gas: types::call::MaxFeePerGas,
                    max_priority_fee_per_gas: types::call::MaxPriorityFeePerGas,
                    nonce: types::call::Nonce,
                    estimate: types::call::Estimate,
                    access_list: types::call::AccessList,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::Call,
                    types::call::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "call",
                        types::Call {
                            from,
                            to,
                            data,
                            value,
                            gas_limit,
                            max_fee_per_gas,
                            max_priority_fee_per_gas,
                            nonce,
                            estimate,
                            access_list,
                        },
                        [
                            83u8, 202u8, 72u8, 13u8, 103u8, 54u8, 152u8, 227u8, 204u8, 185u8, 52u8,
                            154u8, 120u8, 125u8, 73u8, 63u8, 105u8, 167u8, 243u8, 83u8, 110u8,
                            84u8, 144u8, 69u8, 96u8, 150u8, 199u8, 96u8, 76u8, 9u8, 4u8, 154u8,
                        ],
                    )
                }
                pub fn create(
                    &self,
                    from: types::create::From,
                    data: types::create::Data,
                    value: types::create::Value,
                    gas_limit: types::create::GasLimit,
                    max_fee_per_gas: types::create::MaxFeePerGas,
                    max_priority_fee_per_gas: types::create::MaxPriorityFeePerGas,
                    nonce: types::create::Nonce,
                    estimate: types::create::Estimate,
                    access_list: types::create::AccessList,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::Create,
                    types::create::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "create",
                        types::Create {
                            from,
                            data,
                            value,
                            gas_limit,
                            max_fee_per_gas,
                            max_priority_fee_per_gas,
                            nonce,
                            estimate,
                            access_list,
                        },
                        [
                            180u8, 231u8, 236u8, 65u8, 192u8, 214u8, 43u8, 175u8, 34u8, 44u8, 54u8,
                            108u8, 223u8, 247u8, 49u8, 159u8, 251u8, 50u8, 93u8, 244u8, 36u8,
                            232u8, 178u8, 210u8, 98u8, 38u8, 172u8, 123u8, 32u8, 141u8, 219u8,
                            34u8,
                        ],
                    )
                }
                #[doc = " Return the current block."]
                pub fn current_block(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::CurrentBlock,
                    types::current_block::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "current_block",
                        types::CurrentBlock {},
                        [
                            223u8, 174u8, 72u8, 237u8, 254u8, 149u8, 89u8, 18u8, 134u8, 21u8,
                            192u8, 75u8, 29u8, 248u8, 230u8, 130u8, 137u8, 203u8, 81u8, 96u8,
                            179u8, 133u8, 232u8, 183u8, 62u8, 196u8, 175u8, 136u8, 181u8, 66u8,
                            230u8, 115u8,
                        ],
                    )
                }
                #[doc = " Return the current receipt."]
                pub fn current_receipts(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::CurrentReceipts,
                    types::current_receipts::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "current_receipts",
                        types::CurrentReceipts {},
                        [
                            174u8, 101u8, 240u8, 50u8, 204u8, 64u8, 207u8, 220u8, 200u8, 196u8,
                            248u8, 93u8, 30u8, 53u8, 208u8, 184u8, 110u8, 47u8, 19u8, 200u8, 35u8,
                            70u8, 26u8, 66u8, 181u8, 129u8, 237u8, 115u8, 81u8, 169u8, 213u8,
                            137u8,
                        ],
                    )
                }
                #[doc = " Return the current transaction status."]
                pub fn current_transaction_statuses(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::CurrentTransactionStatuses,
                    types::current_transaction_statuses::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "current_transaction_statuses",
                        types::CurrentTransactionStatuses {},
                        [
                            104u8, 186u8, 112u8, 255u8, 185u8, 24u8, 178u8, 204u8, 141u8, 184u8,
                            235u8, 60u8, 152u8, 200u8, 223u8, 154u8, 105u8, 193u8, 211u8, 82u8,
                            77u8, 157u8, 122u8, 36u8, 86u8, 224u8, 150u8, 32u8, 48u8, 176u8, 129u8,
                            33u8,
                        ],
                    )
                }
                pub fn current_all(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::CurrentAll,
                    types::current_all::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "current_all",
                        types::CurrentAll {},
                        [
                            140u8, 52u8, 171u8, 209u8, 255u8, 183u8, 119u8, 234u8, 65u8, 156u8,
                            128u8, 33u8, 217u8, 78u8, 181u8, 48u8, 162u8, 34u8, 92u8, 253u8, 132u8,
                            67u8, 54u8, 1u8, 254u8, 44u8, 219u8, 112u8, 205u8, 2u8, 219u8, 225u8,
                        ],
                    )
                }
                #[doc = " Receives a `Vec<OpaqueExtrinsic>` and filters all the ethereum transactions."]
                pub fn extrinsic_filter(
                    &self,
                    xts: types::extrinsic_filter::Xts,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::ExtrinsicFilter,
                    types::extrinsic_filter::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "extrinsic_filter",
                        types::ExtrinsicFilter { xts },
                        [
                            34u8, 199u8, 221u8, 81u8, 136u8, 126u8, 202u8, 122u8, 232u8, 184u8,
                            41u8, 211u8, 199u8, 24u8, 250u8, 176u8, 199u8, 94u8, 233u8, 221u8,
                            104u8, 94u8, 198u8, 52u8, 218u8, 125u8, 104u8, 91u8, 178u8, 133u8,
                            195u8, 113u8,
                        ],
                    )
                }
                #[doc = " Return the elasticity multiplier."]
                pub fn elasticity(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::Elasticity,
                    types::elasticity::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "elasticity",
                        types::Elasticity {},
                        [
                            231u8, 129u8, 189u8, 25u8, 156u8, 180u8, 55u8, 76u8, 115u8, 115u8,
                            97u8, 87u8, 113u8, 235u8, 49u8, 153u8, 82u8, 254u8, 238u8, 66u8, 99u8,
                            243u8, 179u8, 91u8, 186u8, 122u8, 112u8, 79u8, 0u8, 240u8, 239u8, 97u8,
                        ],
                    )
                }
                #[doc = " Used to determine if gas limit multiplier for non-transactional calls (eth_call/estimateGas)"]
                #[doc = " is supported."]
                pub fn gas_limit_multiplier_support(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GasLimitMultiplierSupport,
                    types::gas_limit_multiplier_support::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "gas_limit_multiplier_support",
                        types::GasLimitMultiplierSupport {},
                        [
                            156u8, 34u8, 145u8, 114u8, 36u8, 174u8, 36u8, 65u8, 158u8, 45u8, 203u8,
                            4u8, 160u8, 170u8, 43u8, 227u8, 204u8, 213u8, 197u8, 230u8, 190u8,
                            119u8, 166u8, 243u8, 225u8, 138u8, 134u8, 169u8, 187u8, 95u8, 245u8,
                            102u8,
                        ],
                    )
                }
                #[doc = " Return the pending block."]
                pub fn pending_block(
                    &self,
                    xts: types::pending_block::Xts,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::PendingBlock,
                    types::pending_block::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "pending_block",
                        types::PendingBlock { xts },
                        [
                            173u8, 229u8, 156u8, 7u8, 102u8, 234u8, 114u8, 87u8, 242u8, 104u8,
                            174u8, 57u8, 202u8, 118u8, 125u8, 215u8, 117u8, 85u8, 137u8, 215u8,
                            13u8, 146u8, 45u8, 197u8, 223u8, 59u8, 146u8, 30u8, 14u8, 209u8, 45u8,
                            198u8,
                        ],
                    )
                }
                #[doc = " Initialize the pending block."]
                #[doc = " The behavior should be the same as the runtime api Core_initialize_block but"]
                #[doc = " for a \"pending\" block."]
                #[doc = " If your project don't need to have a different behavior to initialize \"pending\" blocks,"]
                #[doc = " you can copy your Core_initialize_block implementation."]
                pub fn initialize_pending_block(
                    &self,
                    header: types::initialize_pending_block::Header,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::InitializePendingBlock,
                    types::initialize_pending_block::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "EthereumRuntimeRPCApi",
                        "initialize_pending_block",
                        types::InitializePendingBlock { header },
                        [
                            46u8, 174u8, 182u8, 191u8, 229u8, 174u8, 228u8, 72u8, 119u8, 110u8,
                            223u8, 19u8, 112u8, 12u8, 174u8, 88u8, 159u8, 126u8, 4u8, 166u8, 107u8,
                            244u8, 243u8, 224u8, 84u8, 131u8, 40u8, 164u8, 133u8, 52u8, 76u8,
                            114u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod chain_id {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct ChainId {}
                pub mod account_basic {
                    use super::runtime_types;
                    pub type Address = ::subxt::ext::subxt_core::utils::H160;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types::evm::backend::Basic;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct AccountBasic {
                    pub address: account_basic::Address,
                }
                pub mod gas_price {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types::primitive_types::U256;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GasPrice {}
                pub mod account_code_at {
                    use super::runtime_types;
                    pub type Address = ::subxt::ext::subxt_core::utils::H160;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output =
                            ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct AccountCodeAt {
                    pub address: account_code_at::Address,
                }
                pub mod author {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::utils::H160;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct Author {}
                pub mod storage_at {
                    use super::runtime_types;
                    pub type Address = ::subxt::ext::subxt_core::utils::H160;
                    pub type Index = runtime_types::primitive_types::U256;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::utils::H256;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct StorageAt {
                    pub address: storage_at::Address,
                    pub index: storage_at::Index,
                }
                pub mod call {
                    use super::runtime_types;
                    pub type From = ::subxt::ext::subxt_core::utils::H160;
                    pub type To = ::subxt::ext::subxt_core::utils::H160;
                    pub type Data =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Value = runtime_types::primitive_types::U256;
                    pub type GasLimit = runtime_types::primitive_types::U256;
                    pub type MaxFeePerGas =
                        ::core::option::Option<runtime_types::primitive_types::U256>;
                    pub type MaxPriorityFeePerGas =
                        ::core::option::Option<runtime_types::primitive_types::U256>;
                    pub type Nonce = ::core::option::Option<runtime_types::primitive_types::U256>;
                    pub type Estimate = ::core::primitive::bool;
                    pub type AccessList = ::core::option::Option<
                        ::subxt::ext::subxt_core::alloc::vec::Vec<(
                            ::subxt::ext::subxt_core::utils::H160,
                            ::subxt::ext::subxt_core::alloc::vec::Vec<
                                ::subxt::ext::subxt_core::utils::H256,
                            >,
                        )>,
                    >;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::result::Result<
                            runtime_types::fp_evm::ExecutionInfoV2<
                                ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>,
                            >,
                            runtime_types::sp_runtime::DispatchError,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct Call {
                    pub from: call::From,
                    pub to: call::To,
                    pub data: call::Data,
                    pub value: call::Value,
                    pub gas_limit: call::GasLimit,
                    pub max_fee_per_gas: call::MaxFeePerGas,
                    pub max_priority_fee_per_gas: call::MaxPriorityFeePerGas,
                    pub nonce: call::Nonce,
                    pub estimate: call::Estimate,
                    pub access_list: call::AccessList,
                }
                pub mod create {
                    use super::runtime_types;
                    pub type From = ::subxt::ext::subxt_core::utils::H160;
                    pub type Data =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Value = runtime_types::primitive_types::U256;
                    pub type GasLimit = runtime_types::primitive_types::U256;
                    pub type MaxFeePerGas =
                        ::core::option::Option<runtime_types::primitive_types::U256>;
                    pub type MaxPriorityFeePerGas =
                        ::core::option::Option<runtime_types::primitive_types::U256>;
                    pub type Nonce = ::core::option::Option<runtime_types::primitive_types::U256>;
                    pub type Estimate = ::core::primitive::bool;
                    pub type AccessList = ::core::option::Option<
                        ::subxt::ext::subxt_core::alloc::vec::Vec<(
                            ::subxt::ext::subxt_core::utils::H160,
                            ::subxt::ext::subxt_core::alloc::vec::Vec<
                                ::subxt::ext::subxt_core::utils::H256,
                            >,
                        )>,
                    >;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::result::Result<
                            runtime_types::fp_evm::ExecutionInfoV2<
                                ::subxt::ext::subxt_core::utils::H160,
                            >,
                            runtime_types::sp_runtime::DispatchError,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct Create {
                    pub from: create::From,
                    pub data: create::Data,
                    pub value: create::Value,
                    pub gas_limit: create::GasLimit,
                    pub max_fee_per_gas: create::MaxFeePerGas,
                    pub max_priority_fee_per_gas: create::MaxPriorityFeePerGas,
                    pub nonce: create::Nonce,
                    pub estimate: create::Estimate,
                    pub access_list: create::AccessList,
                }
                pub mod current_block {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::ethereum::block::Block<
                                runtime_types::ethereum::transaction::TransactionV2,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct CurrentBlock {}
                pub mod current_receipts {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            ::subxt::ext::subxt_core::alloc::vec::Vec<
                                runtime_types::ethereum::receipt::ReceiptV3,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct CurrentReceipts {}
                pub mod current_transaction_statuses {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            ::subxt::ext::subxt_core::alloc::vec::Vec<
                                runtime_types::fp_rpc::TransactionStatus,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct CurrentTransactionStatuses {}
                pub mod current_all {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = (
                            ::core::option::Option<
                                runtime_types::ethereum::block::Block<
                                    runtime_types::ethereum::transaction::TransactionV2,
                                >,
                            >,
                            ::core::option::Option<
                                ::subxt::ext::subxt_core::alloc::vec::Vec<
                                    runtime_types::ethereum::receipt::ReceiptV3,
                                >,
                            >,
                            ::core::option::Option<
                                ::subxt::ext::subxt_core::alloc::vec::Vec<
                                    runtime_types::fp_rpc::TransactionStatus,
                                >,
                            >,
                        );
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct CurrentAll {}
                pub mod extrinsic_filter {
                    use super::runtime_types;
                    pub type Xts = :: subxt :: ext :: subxt_core :: alloc :: vec :: Vec < runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > > ;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            runtime_types::ethereum::transaction::TransactionV2,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct ExtrinsicFilter {
                    pub xts: extrinsic_filter::Xts,
                }
                pub mod elasticity {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::sp_arithmetic::per_things::Permill,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct Elasticity {}
                pub mod gas_limit_multiplier_support {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ();
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GasLimitMultiplierSupport {}
                pub mod pending_block {
                    use super::runtime_types;
                    pub type Xts = :: subxt :: ext :: subxt_core :: alloc :: vec :: Vec < runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > > ;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = (
                            ::core::option::Option<
                                runtime_types::ethereum::block::Block<
                                    runtime_types::ethereum::transaction::TransactionV2,
                                >,
                            >,
                            ::core::option::Option<
                                ::subxt::ext::subxt_core::alloc::vec::Vec<
                                    runtime_types::fp_rpc::TransactionStatus,
                                >,
                            >,
                        );
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct PendingBlock {
                    pub xts: pending_block::Xts,
                }
                pub mod initialize_pending_block {
                    use super::runtime_types;
                    pub type Header =
                        runtime_types::sp_runtime::generic::header::Header<::core::primitive::u32>;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ();
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct InitializePendingBlock {
                    pub header: initialize_pending_block::Header,
                }
            }
        }
        pub mod convert_transaction_runtime_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct ConvertTransactionRuntimeApi;
            impl ConvertTransactionRuntimeApi {
                pub fn convert_transaction(
                    &self,
                    transaction: types::convert_transaction::Transaction,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::ConvertTransaction,
                    types::convert_transaction::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "ConvertTransactionRuntimeApi",
                        "convert_transaction",
                        types::ConvertTransaction { transaction },
                        [
                            38u8, 3u8, 65u8, 131u8, 104u8, 95u8, 86u8, 42u8, 177u8, 179u8, 245u8,
                            253u8, 51u8, 174u8, 207u8, 232u8, 181u8, 68u8, 71u8, 91u8, 213u8, 63u8,
                            48u8, 83u8, 142u8, 178u8, 236u8, 64u8, 185u8, 64u8, 188u8, 123u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod convert_transaction {
                    use super::runtime_types;
                    pub type Transaction = runtime_types::ethereum::transaction::TransactionV2;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = runtime_types :: fp_self_contained :: unchecked_extrinsic :: UncheckedExtrinsic < :: subxt :: ext :: subxt_core :: utils :: MultiAddress < :: subxt :: ext :: subxt_core :: utils :: AccountId32 , () > , runtime_types :: node_subtensor_runtime :: RuntimeCall , runtime_types :: sp_runtime :: MultiSignature , (runtime_types :: frame_system :: extensions :: check_non_zero_sender :: CheckNonZeroSender , runtime_types :: frame_system :: extensions :: check_spec_version :: CheckSpecVersion , runtime_types :: frame_system :: extensions :: check_tx_version :: CheckTxVersion , runtime_types :: frame_system :: extensions :: check_genesis :: CheckGenesis , runtime_types :: frame_system :: extensions :: check_mortality :: CheckMortality , runtime_types :: node_subtensor_runtime :: check_nonce :: CheckNonce , runtime_types :: frame_system :: extensions :: check_weight :: CheckWeight , runtime_types :: pallet_transaction_payment :: ChargeTransactionPayment , runtime_types :: pallet_subtensor :: SubtensorTransactionExtension < runtime_types :: node_subtensor_runtime :: Runtime > , runtime_types :: frame_metadata_hash_extension :: CheckMetadataHash ,) > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct ConvertTransaction {
                    pub transaction: convert_transaction::Transaction,
                }
            }
        }
        pub mod delegate_info_runtime_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct DelegateInfoRuntimeApi;
            impl DelegateInfoRuntimeApi {
                pub fn get_delegates(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetDelegates,
                    types::get_delegates::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "DelegateInfoRuntimeApi",
                        "get_delegates",
                        types::GetDelegates {},
                        [
                            84u8, 157u8, 45u8, 177u8, 179u8, 241u8, 44u8, 84u8, 110u8, 16u8, 136u8,
                            163u8, 253u8, 254u8, 50u8, 65u8, 4u8, 133u8, 11u8, 37u8, 147u8, 242u8,
                            164u8, 114u8, 229u8, 60u8, 254u8, 236u8, 50u8, 122u8, 98u8, 218u8,
                        ],
                    )
                }
                pub fn get_delegate(
                    &self,
                    delegate_account: types::get_delegate::DelegateAccount,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetDelegate,
                    types::get_delegate::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "DelegateInfoRuntimeApi",
                        "get_delegate",
                        types::GetDelegate { delegate_account },
                        [
                            5u8, 251u8, 208u8, 34u8, 232u8, 79u8, 228u8, 155u8, 157u8, 152u8, 78u8,
                            249u8, 185u8, 93u8, 233u8, 66u8, 224u8, 170u8, 103u8, 35u8, 150u8, 6u8,
                            213u8, 147u8, 244u8, 123u8, 1u8, 41u8, 243u8, 76u8, 177u8, 254u8,
                        ],
                    )
                }
                pub fn get_delegated(
                    &self,
                    delegatee_account: types::get_delegated::DelegateeAccount,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetDelegated,
                    types::get_delegated::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "DelegateInfoRuntimeApi",
                        "get_delegated",
                        types::GetDelegated { delegatee_account },
                        [
                            38u8, 86u8, 71u8, 247u8, 70u8, 89u8, 117u8, 90u8, 79u8, 100u8, 98u8,
                            123u8, 118u8, 100u8, 195u8, 31u8, 47u8, 243u8, 232u8, 228u8, 164u8,
                            33u8, 186u8, 101u8, 75u8, 47u8, 132u8, 175u8, 170u8, 142u8, 72u8, 40u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod get_delegates {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            runtime_types::pallet_subtensor::rpc_info::delegate_info::DelegateInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetDelegates {}
                pub mod get_delegate {
                    use super::runtime_types;
                    pub type DelegateAccount = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::delegate_info::DelegateInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetDelegate {
                    pub delegate_account: get_delegate::DelegateAccount,
                }
                pub mod get_delegated {
                    use super::runtime_types;
                    pub type DelegateeAccount = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                            runtime_types::pallet_subtensor::rpc_info::delegate_info::DelegateInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                            (
                                ::subxt::ext::subxt_core::ext::codec::Compact<
                                    ::core::primitive::u16,
                                >,
                                ::subxt::ext::subxt_core::ext::codec::Compact<
                                    ::core::primitive::u64,
                                >,
                            ),
                        )>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetDelegated {
                    pub delegatee_account: get_delegated::DelegateeAccount,
                }
            }
        }
        pub mod neuron_info_runtime_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct NeuronInfoRuntimeApi;
            impl NeuronInfoRuntimeApi {
                pub fn get_neurons(
                    &self,
                    netuid: types::get_neurons::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetNeurons,
                    types::get_neurons::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "NeuronInfoRuntimeApi",
                        "get_neurons",
                        types::GetNeurons { netuid },
                        [
                            29u8, 31u8, 252u8, 255u8, 122u8, 62u8, 85u8, 100u8, 129u8, 30u8, 54u8,
                            193u8, 3u8, 193u8, 171u8, 125u8, 163u8, 155u8, 188u8, 197u8, 204u8,
                            251u8, 67u8, 245u8, 117u8, 93u8, 144u8, 78u8, 90u8, 199u8, 3u8, 165u8,
                        ],
                    )
                }
                pub fn get_neuron(
                    &self,
                    netuid: types::get_neuron::Netuid,
                    uid: types::get_neuron::Uid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetNeuron,
                    types::get_neuron::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "NeuronInfoRuntimeApi",
                        "get_neuron",
                        types::GetNeuron { netuid, uid },
                        [
                            139u8, 168u8, 134u8, 98u8, 35u8, 45u8, 15u8, 62u8, 231u8, 241u8, 7u8,
                            48u8, 3u8, 217u8, 103u8, 109u8, 164u8, 154u8, 98u8, 137u8, 243u8, 24u8,
                            2u8, 137u8, 59u8, 162u8, 182u8, 249u8, 218u8, 143u8, 203u8, 47u8,
                        ],
                    )
                }
                pub fn get_neurons_lite(
                    &self,
                    netuid: types::get_neurons_lite::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetNeuronsLite,
                    types::get_neurons_lite::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "NeuronInfoRuntimeApi",
                        "get_neurons_lite",
                        types::GetNeuronsLite { netuid },
                        [
                            20u8, 84u8, 89u8, 226u8, 124u8, 150u8, 169u8, 14u8, 75u8, 218u8, 136u8,
                            236u8, 137u8, 198u8, 127u8, 143u8, 45u8, 46u8, 65u8, 46u8, 242u8, 69u8,
                            180u8, 63u8, 11u8, 56u8, 115u8, 37u8, 5u8, 164u8, 180u8, 190u8,
                        ],
                    )
                }
                pub fn get_neuron_lite(
                    &self,
                    netuid: types::get_neuron_lite::Netuid,
                    uid: types::get_neuron_lite::Uid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetNeuronLite,
                    types::get_neuron_lite::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "NeuronInfoRuntimeApi",
                        "get_neuron_lite",
                        types::GetNeuronLite { netuid, uid },
                        [
                            113u8, 98u8, 78u8, 240u8, 254u8, 189u8, 58u8, 44u8, 49u8, 21u8, 121u8,
                            127u8, 31u8, 102u8, 14u8, 6u8, 76u8, 86u8, 151u8, 89u8, 90u8, 148u8,
                            173u8, 88u8, 83u8, 227u8, 151u8, 246u8, 249u8, 238u8, 255u8, 127u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod get_neurons {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            runtime_types::pallet_subtensor::rpc_info::neuron_info::NeuronInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetNeurons {
                    pub netuid: get_neurons::Netuid,
                }
                pub mod get_neuron {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Uid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::neuron_info::NeuronInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetNeuron {
                    pub netuid: get_neuron::Netuid,
                    pub uid: get_neuron::Uid,
                }
                pub mod get_neurons_lite {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            runtime_types::pallet_subtensor::rpc_info::neuron_info::NeuronInfoLite<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetNeuronsLite {
                    pub netuid: get_neurons_lite::Netuid,
                }
                pub mod get_neuron_lite {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Uid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::neuron_info::NeuronInfoLite<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetNeuronLite {
                    pub netuid: get_neuron_lite::Netuid,
                    pub uid: get_neuron_lite::Uid,
                }
            }
        }
        pub mod subnet_info_runtime_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct SubnetInfoRuntimeApi;
            impl SubnetInfoRuntimeApi {
                pub fn get_subnet_info(
                    &self,
                    netuid: types::get_subnet_info::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetSubnetInfo,
                    types::get_subnet_info::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_subnet_info",
                        types::GetSubnetInfo { netuid },
                        [
                            119u8, 89u8, 29u8, 164u8, 38u8, 24u8, 27u8, 41u8, 75u8, 128u8, 72u8,
                            38u8, 94u8, 237u8, 65u8, 220u8, 67u8, 33u8, 247u8, 221u8, 83u8, 97u8,
                            246u8, 220u8, 236u8, 121u8, 10u8, 103u8, 163u8, 252u8, 174u8, 236u8,
                        ],
                    )
                }
                pub fn get_subnets_info(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetSubnetsInfo,
                    types::get_subnets_info::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_subnets_info",
                        types::GetSubnetsInfo {},
                        [
                            49u8, 55u8, 178u8, 80u8, 22u8, 54u8, 132u8, 142u8, 192u8, 53u8, 221u8,
                            2u8, 205u8, 114u8, 100u8, 168u8, 110u8, 31u8, 204u8, 214u8, 88u8, 36u8,
                            115u8, 133u8, 254u8, 195u8, 90u8, 109u8, 221u8, 236u8, 104u8, 246u8,
                        ],
                    )
                }
                pub fn get_subnet_info_v2(
                    &self,
                    netuid: types::get_subnet_info_v2::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetSubnetInfoV2,
                    types::get_subnet_info_v2::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_subnet_info_v2",
                        types::GetSubnetInfoV2 { netuid },
                        [
                            132u8, 17u8, 149u8, 139u8, 225u8, 117u8, 250u8, 70u8, 115u8, 183u8,
                            50u8, 188u8, 145u8, 109u8, 0u8, 42u8, 4u8, 38u8, 169u8, 161u8, 197u8,
                            182u8, 191u8, 179u8, 224u8, 166u8, 43u8, 232u8, 103u8, 107u8, 72u8,
                            206u8,
                        ],
                    )
                }
                pub fn get_subnets_info_v2(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetSubnetsInfoV2,
                    types::get_subnets_info_v2::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_subnets_info_v2",
                        types::GetSubnetsInfoV2 {},
                        [
                            110u8, 162u8, 122u8, 133u8, 21u8, 248u8, 95u8, 215u8, 146u8, 147u8,
                            20u8, 67u8, 208u8, 171u8, 38u8, 209u8, 171u8, 240u8, 195u8, 21u8, 39u8,
                            147u8, 147u8, 174u8, 100u8, 55u8, 52u8, 225u8, 159u8, 5u8, 88u8, 180u8,
                        ],
                    )
                }
                pub fn get_subnet_hyperparams(
                    &self,
                    netuid: types::get_subnet_hyperparams::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetSubnetHyperparams,
                    types::get_subnet_hyperparams::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_subnet_hyperparams",
                        types::GetSubnetHyperparams { netuid },
                        [
                            105u8, 42u8, 239u8, 199u8, 164u8, 166u8, 25u8, 168u8, 1u8, 9u8, 120u8,
                            205u8, 173u8, 15u8, 69u8, 247u8, 21u8, 74u8, 152u8, 213u8, 201u8,
                            206u8, 151u8, 88u8, 33u8, 140u8, 236u8, 252u8, 8u8, 77u8, 167u8, 143u8,
                        ],
                    )
                }
                pub fn get_subnet_hyperparams_v2(
                    &self,
                    netuid: types::get_subnet_hyperparams_v2::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetSubnetHyperparamsV2,
                    types::get_subnet_hyperparams_v2::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_subnet_hyperparams_v2",
                        types::GetSubnetHyperparamsV2 { netuid },
                        [
                            135u8, 85u8, 182u8, 104u8, 206u8, 139u8, 220u8, 110u8, 23u8, 208u8,
                            232u8, 183u8, 228u8, 81u8, 7u8, 138u8, 199u8, 205u8, 168u8, 252u8,
                            16u8, 112u8, 240u8, 161u8, 244u8, 93u8, 120u8, 131u8, 215u8, 227u8,
                            228u8, 85u8,
                        ],
                    )
                }
                pub fn get_all_dynamic_info(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetAllDynamicInfo,
                    types::get_all_dynamic_info::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_all_dynamic_info",
                        types::GetAllDynamicInfo {},
                        [
                            222u8, 205u8, 49u8, 222u8, 215u8, 78u8, 194u8, 45u8, 164u8, 157u8,
                            243u8, 202u8, 173u8, 27u8, 96u8, 22u8, 78u8, 108u8, 7u8, 36u8, 240u8,
                            52u8, 134u8, 64u8, 180u8, 124u8, 219u8, 207u8, 165u8, 50u8, 106u8,
                            125u8,
                        ],
                    )
                }
                pub fn get_all_metagraphs(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetAllMetagraphs,
                    types::get_all_metagraphs::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_all_metagraphs",
                        types::GetAllMetagraphs {},
                        [
                            147u8, 178u8, 17u8, 111u8, 212u8, 4u8, 51u8, 117u8, 251u8, 44u8, 22u8,
                            181u8, 12u8, 183u8, 72u8, 67u8, 141u8, 13u8, 36u8, 117u8, 161u8, 147u8,
                            104u8, 9u8, 222u8, 47u8, 173u8, 176u8, 216u8, 220u8, 218u8, 80u8,
                        ],
                    )
                }
                pub fn get_metagraph(
                    &self,
                    netuid: types::get_metagraph::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetMetagraph,
                    types::get_metagraph::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_metagraph",
                        types::GetMetagraph { netuid },
                        [
                            53u8, 68u8, 46u8, 132u8, 163u8, 124u8, 29u8, 39u8, 68u8, 80u8, 26u8,
                            254u8, 233u8, 68u8, 1u8, 152u8, 169u8, 134u8, 82u8, 26u8, 139u8, 16u8,
                            151u8, 215u8, 225u8, 93u8, 165u8, 31u8, 82u8, 235u8, 55u8, 160u8,
                        ],
                    )
                }
                pub fn get_dynamic_info(
                    &self,
                    netuid: types::get_dynamic_info::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetDynamicInfo,
                    types::get_dynamic_info::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_dynamic_info",
                        types::GetDynamicInfo { netuid },
                        [
                            182u8, 161u8, 5u8, 148u8, 114u8, 241u8, 151u8, 126u8, 23u8, 238u8,
                            62u8, 49u8, 27u8, 18u8, 162u8, 29u8, 11u8, 62u8, 121u8, 139u8, 148u8,
                            35u8, 199u8, 154u8, 221u8, 75u8, 89u8, 48u8, 165u8, 157u8, 152u8,
                            241u8,
                        ],
                    )
                }
                pub fn get_subnet_state(
                    &self,
                    netuid: types::get_subnet_state::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetSubnetState,
                    types::get_subnet_state::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_subnet_state",
                        types::GetSubnetState { netuid },
                        [
                            142u8, 252u8, 50u8, 8u8, 72u8, 70u8, 156u8, 59u8, 8u8, 178u8, 205u8,
                            150u8, 65u8, 3u8, 213u8, 14u8, 110u8, 60u8, 6u8, 154u8, 1u8, 181u8,
                            158u8, 80u8, 120u8, 220u8, 47u8, 84u8, 120u8, 251u8, 43u8, 132u8,
                        ],
                    )
                }
                pub fn get_selective_metagraph(
                    &self,
                    netuid: types::get_selective_metagraph::Netuid,
                    metagraph_indexes: types::get_selective_metagraph::MetagraphIndexes,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetSelectiveMetagraph,
                    types::get_selective_metagraph::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetInfoRuntimeApi",
                        "get_selective_metagraph",
                        types::GetSelectiveMetagraph {
                            netuid,
                            metagraph_indexes,
                        },
                        [
                            126u8, 221u8, 115u8, 215u8, 91u8, 207u8, 177u8, 57u8, 216u8, 150u8,
                            83u8, 173u8, 146u8, 142u8, 159u8, 102u8, 73u8, 108u8, 142u8, 112u8,
                            125u8, 143u8, 44u8, 43u8, 12u8, 91u8, 128u8, 32u8, 252u8, 21u8, 102u8,
                            141u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod get_subnet_info {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::subnet_info::SubnetInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetSubnetInfo {
                    pub netuid: get_subnet_info::Netuid,
                }
                pub mod get_subnets_info {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            ::core::option::Option<
                                runtime_types::pallet_subtensor::rpc_info::subnet_info::SubnetInfo<
                                    ::subxt::ext::subxt_core::utils::AccountId32,
                                >,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetSubnetsInfo {}
                pub mod get_subnet_info_v2 {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::subnet_info::SubnetInfov2<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetSubnetInfoV2 {
                    pub netuid: get_subnet_info_v2::Netuid,
                }
                pub mod get_subnets_info_v2 {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = :: subxt :: ext :: subxt_core :: alloc :: vec :: Vec < :: core :: option :: Option < runtime_types :: pallet_subtensor :: rpc_info :: subnet_info :: SubnetInfov2 < :: subxt :: ext :: subxt_core :: utils :: AccountId32 > > > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetSubnetsInfoV2 {}
                pub mod get_subnet_hyperparams {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = :: core :: option :: Option < runtime_types :: pallet_subtensor :: rpc_info :: subnet_info :: SubnetHyperparams > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetSubnetHyperparams {
                    pub netuid: get_subnet_hyperparams::Netuid,
                }
                pub mod get_subnet_hyperparams_v2 {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = :: core :: option :: Option < runtime_types :: pallet_subtensor :: rpc_info :: subnet_info :: SubnetHyperparamsV2 > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetSubnetHyperparamsV2 {
                    pub netuid: get_subnet_hyperparams_v2::Netuid,
                }
                pub mod get_all_dynamic_info {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = :: subxt :: ext :: subxt_core :: alloc :: vec :: Vec < :: core :: option :: Option < runtime_types :: pallet_subtensor :: rpc_info :: dynamic_info :: DynamicInfo < :: subxt :: ext :: subxt_core :: utils :: AccountId32 > > > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetAllDynamicInfo {}
                pub mod get_all_metagraphs {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            ::core::option::Option<
                                runtime_types::pallet_subtensor::rpc_info::metagraph::Metagraph<
                                    ::subxt::ext::subxt_core::utils::AccountId32,
                                >,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetAllMetagraphs {}
                pub mod get_metagraph {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::metagraph::Metagraph<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetMetagraph {
                    pub netuid: get_metagraph::Netuid,
                }
                pub mod get_dynamic_info {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::dynamic_info::DynamicInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetDynamicInfo {
                    pub netuid: get_dynamic_info::Netuid,
                }
                pub mod get_subnet_state {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::show_subnet::SubnetState<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetSubnetState {
                    pub netuid: get_subnet_state::Netuid,
                }
                pub mod get_selective_metagraph {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type MetagraphIndexes =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = :: core :: option :: Option < runtime_types :: pallet_subtensor :: rpc_info :: metagraph :: SelectiveMetagraph < :: subxt :: ext :: subxt_core :: utils :: AccountId32 > > ;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetSelectiveMetagraph {
                    pub netuid: get_selective_metagraph::Netuid,
                    pub metagraph_indexes: get_selective_metagraph::MetagraphIndexes,
                }
            }
        }
        pub mod stake_info_runtime_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct StakeInfoRuntimeApi;
            impl StakeInfoRuntimeApi {
                pub fn get_stake_info_for_coldkey(
                    &self,
                    coldkey_account: types::get_stake_info_for_coldkey::ColdkeyAccount,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetStakeInfoForColdkey,
                    types::get_stake_info_for_coldkey::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "StakeInfoRuntimeApi",
                        "get_stake_info_for_coldkey",
                        types::GetStakeInfoForColdkey { coldkey_account },
                        [
                            143u8, 77u8, 215u8, 163u8, 187u8, 63u8, 84u8, 15u8, 21u8, 63u8, 12u8,
                            196u8, 129u8, 195u8, 95u8, 120u8, 196u8, 70u8, 200u8, 84u8, 169u8,
                            188u8, 150u8, 136u8, 119u8, 30u8, 171u8, 87u8, 73u8, 189u8, 186u8,
                            108u8,
                        ],
                    )
                }
                pub fn get_stake_info_for_coldkeys(
                    &self,
                    coldkey_accounts: types::get_stake_info_for_coldkeys::ColdkeyAccounts,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetStakeInfoForColdkeys,
                    types::get_stake_info_for_coldkeys::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "StakeInfoRuntimeApi",
                        "get_stake_info_for_coldkeys",
                        types::GetStakeInfoForColdkeys { coldkey_accounts },
                        [
                            1u8, 78u8, 223u8, 196u8, 230u8, 76u8, 101u8, 184u8, 52u8, 211u8, 205u8,
                            55u8, 53u8, 111u8, 1u8, 120u8, 132u8, 164u8, 143u8, 245u8, 188u8,
                            192u8, 212u8, 42u8, 2u8, 67u8, 107u8, 74u8, 118u8, 82u8, 217u8, 60u8,
                        ],
                    )
                }
                pub fn get_stake_info_for_hotkey_coldkey_netuid(
                    &self,
                    hotkey_account: types::get_stake_info_for_hotkey_coldkey_netuid::HotkeyAccount,
                    coldkey_account : types :: get_stake_info_for_hotkey_coldkey_netuid :: ColdkeyAccount,
                    netuid: types::get_stake_info_for_hotkey_coldkey_netuid::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetStakeInfoForHotkeyColdkeyNetuid,
                    types::get_stake_info_for_hotkey_coldkey_netuid::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "StakeInfoRuntimeApi",
                        "get_stake_info_for_hotkey_coldkey_netuid",
                        types::GetStakeInfoForHotkeyColdkeyNetuid {
                            hotkey_account,
                            coldkey_account,
                            netuid,
                        },
                        [
                            228u8, 228u8, 175u8, 61u8, 136u8, 161u8, 60u8, 52u8, 116u8, 133u8,
                            188u8, 29u8, 43u8, 145u8, 157u8, 49u8, 241u8, 175u8, 142u8, 150u8,
                            241u8, 79u8, 204u8, 222u8, 165u8, 138u8, 5u8, 139u8, 51u8, 89u8, 87u8,
                            136u8,
                        ],
                    )
                }
                pub fn get_stake_fee(
                    &self,
                    origin: types::get_stake_fee::Origin,
                    origin_coldkey_account: types::get_stake_fee::OriginColdkeyAccount,
                    destination: types::get_stake_fee::Destination,
                    destination_coldkey_account: types::get_stake_fee::DestinationColdkeyAccount,
                    amount: types::get_stake_fee::Amount,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetStakeFee,
                    types::get_stake_fee::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "StakeInfoRuntimeApi",
                        "get_stake_fee",
                        types::GetStakeFee {
                            origin,
                            origin_coldkey_account,
                            destination,
                            destination_coldkey_account,
                            amount,
                        },
                        [
                            183u8, 139u8, 137u8, 149u8, 162u8, 63u8, 53u8, 161u8, 255u8, 164u8,
                            217u8, 252u8, 213u8, 205u8, 138u8, 70u8, 200u8, 241u8, 162u8, 190u8,
                            81u8, 248u8, 140u8, 38u8, 83u8, 12u8, 110u8, 70u8, 15u8, 93u8, 70u8,
                            39u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod get_stake_info_for_coldkey {
                    use super::runtime_types;
                    pub type ColdkeyAccount = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<
                            runtime_types::pallet_subtensor::rpc_info::stake_info::StakeInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetStakeInfoForColdkey {
                    pub coldkey_account: get_stake_info_for_coldkey::ColdkeyAccount,
                }
                pub mod get_stake_info_for_coldkeys {
                    use super::runtime_types;
                    pub type ColdkeyAccounts = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                    >;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                            ::subxt::ext::subxt_core::utils::AccountId32,
                            ::subxt::ext::subxt_core::alloc::vec::Vec<
                                runtime_types::pallet_subtensor::rpc_info::stake_info::StakeInfo<
                                    ::subxt::ext::subxt_core::utils::AccountId32,
                                >,
                            >,
                        )>;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetStakeInfoForColdkeys {
                    pub coldkey_accounts: get_stake_info_for_coldkeys::ColdkeyAccounts,
                }
                pub mod get_stake_info_for_hotkey_coldkey_netuid {
                    use super::runtime_types;
                    pub type HotkeyAccount = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type ColdkeyAccount = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::option::Option<
                            runtime_types::pallet_subtensor::rpc_info::stake_info::StakeInfo<
                                ::subxt::ext::subxt_core::utils::AccountId32,
                            >,
                        >;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetStakeInfoForHotkeyColdkeyNetuid {
                    pub hotkey_account: get_stake_info_for_hotkey_coldkey_netuid::HotkeyAccount,
                    pub coldkey_account: get_stake_info_for_hotkey_coldkey_netuid::ColdkeyAccount,
                    pub netuid: get_stake_info_for_hotkey_coldkey_netuid::Netuid,
                }
                pub mod get_stake_fee {
                    use super::runtime_types;
                    pub type Origin = ::core::option::Option<(
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        ::core::primitive::u16,
                    )>;
                    pub type OriginColdkeyAccount = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Destination = ::core::option::Option<(
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        ::core::primitive::u16,
                    )>;
                    pub type DestinationColdkeyAccount =
                        ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Amount = ::core::primitive::u64;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetStakeFee {
                    pub origin: get_stake_fee::Origin,
                    pub origin_coldkey_account: get_stake_fee::OriginColdkeyAccount,
                    pub destination: get_stake_fee::Destination,
                    pub destination_coldkey_account: get_stake_fee::DestinationColdkeyAccount,
                    pub amount: get_stake_fee::Amount,
                }
            }
        }
        pub mod subnet_registration_runtime_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct SubnetRegistrationRuntimeApi;
            impl SubnetRegistrationRuntimeApi {
                pub fn get_network_registration_cost(
                    &self,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::GetNetworkRegistrationCost,
                    types::get_network_registration_cost::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SubnetRegistrationRuntimeApi",
                        "get_network_registration_cost",
                        types::GetNetworkRegistrationCost {},
                        [
                            152u8, 137u8, 58u8, 141u8, 204u8, 239u8, 63u8, 8u8, 76u8, 223u8, 54u8,
                            219u8, 150u8, 155u8, 129u8, 130u8, 64u8, 40u8, 177u8, 153u8, 29u8, 1u8,
                            234u8, 30u8, 20u8, 218u8, 17u8, 254u8, 18u8, 135u8, 133u8, 25u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod get_network_registration_cost {
                    use super::runtime_types;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct GetNetworkRegistrationCost {}
            }
        }
        pub mod swap_runtime_api {
            use super::root_mod;
            use super::runtime_types;
            pub struct SwapRuntimeApi;
            impl SwapRuntimeApi {
                pub fn current_alpha_price(
                    &self,
                    netuid: types::current_alpha_price::Netuid,
                ) -> ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload<
                    types::CurrentAlphaPrice,
                    types::current_alpha_price::output::Output,
                > {
                    ::subxt::ext::subxt_core::runtime_api::payload::StaticPayload::new_static(
                        "SwapRuntimeApi",
                        "current_alpha_price",
                        types::CurrentAlphaPrice { netuid },
                        [
                            11u8, 188u8, 171u8, 199u8, 218u8, 30u8, 244u8, 88u8, 54u8, 217u8,
                            110u8, 45u8, 207u8, 243u8, 137u8, 75u8, 164u8, 95u8, 95u8, 168u8,
                            192u8, 97u8, 155u8, 169u8, 242u8, 215u8, 135u8, 202u8, 236u8, 133u8,
                            147u8, 32u8,
                        ],
                    )
                }
            }
            pub mod types {
                use super::runtime_types;
                pub mod current_alpha_price {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub mod output {
                        use super::runtime_types;
                        pub type Output = ::core::primitive::u64;
                    }
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                pub struct CurrentAlphaPrice {
                    pub netuid: current_alpha_price::Netuid,
                }
            }
        }
    }
    pub fn custom() -> CustomValuesApi {
        CustomValuesApi
    }
    pub struct CustomValuesApi;
    impl CustomValuesApi {}
    pub struct ConstantsApi;
    impl ConstantsApi {
        pub fn system(&self) -> system::constants::ConstantsApi {
            system::constants::ConstantsApi
        }
        pub fn timestamp(&self) -> timestamp::constants::ConstantsApi {
            timestamp::constants::ConstantsApi
        }
        pub fn aura(&self) -> aura::constants::ConstantsApi {
            aura::constants::ConstantsApi
        }
        pub fn grandpa(&self) -> grandpa::constants::ConstantsApi {
            grandpa::constants::ConstantsApi
        }
        pub fn balances(&self) -> balances::constants::ConstantsApi {
            balances::constants::ConstantsApi
        }
        pub fn transaction_payment(&self) -> transaction_payment::constants::ConstantsApi {
            transaction_payment::constants::ConstantsApi
        }
        pub fn subtensor_module(&self) -> subtensor_module::constants::ConstantsApi {
            subtensor_module::constants::ConstantsApi
        }
        pub fn utility(&self) -> utility::constants::ConstantsApi {
            utility::constants::ConstantsApi
        }
        pub fn multisig(&self) -> multisig::constants::ConstantsApi {
            multisig::constants::ConstantsApi
        }
        pub fn scheduler(&self) -> scheduler::constants::ConstantsApi {
            scheduler::constants::ConstantsApi
        }
        pub fn proxy(&self) -> proxy::constants::ConstantsApi {
            proxy::constants::ConstantsApi
        }
        pub fn registry(&self) -> registry::constants::ConstantsApi {
            registry::constants::ConstantsApi
        }
        pub fn commitments(&self) -> commitments::constants::ConstantsApi {
            commitments::constants::ConstantsApi
        }
        pub fn safe_mode(&self) -> safe_mode::constants::ConstantsApi {
            safe_mode::constants::ConstantsApi
        }
        pub fn drand(&self) -> drand::constants::ConstantsApi {
            drand::constants::ConstantsApi
        }
        pub fn crowdloan(&self) -> crowdloan::constants::ConstantsApi {
            crowdloan::constants::ConstantsApi
        }
        pub fn swap(&self) -> swap::constants::ConstantsApi {
            swap::constants::ConstantsApi
        }
    }
    pub struct StorageApi;
    impl StorageApi {
        pub fn system(&self) -> system::storage::StorageApi {
            system::storage::StorageApi
        }
        pub fn randomness_collective_flip(
            &self,
        ) -> randomness_collective_flip::storage::StorageApi {
            randomness_collective_flip::storage::StorageApi
        }
        pub fn timestamp(&self) -> timestamp::storage::StorageApi {
            timestamp::storage::StorageApi
        }
        pub fn aura(&self) -> aura::storage::StorageApi {
            aura::storage::StorageApi
        }
        pub fn grandpa(&self) -> grandpa::storage::StorageApi {
            grandpa::storage::StorageApi
        }
        pub fn balances(&self) -> balances::storage::StorageApi {
            balances::storage::StorageApi
        }
        pub fn transaction_payment(&self) -> transaction_payment::storage::StorageApi {
            transaction_payment::storage::StorageApi
        }
        pub fn subtensor_module(&self) -> subtensor_module::storage::StorageApi {
            subtensor_module::storage::StorageApi
        }
        pub fn triumvirate(&self) -> triumvirate::storage::StorageApi {
            triumvirate::storage::StorageApi
        }
        pub fn triumvirate_members(&self) -> triumvirate_members::storage::StorageApi {
            triumvirate_members::storage::StorageApi
        }
        pub fn senate_members(&self) -> senate_members::storage::StorageApi {
            senate_members::storage::StorageApi
        }
        pub fn sudo(&self) -> sudo::storage::StorageApi {
            sudo::storage::StorageApi
        }
        pub fn multisig(&self) -> multisig::storage::StorageApi {
            multisig::storage::StorageApi
        }
        pub fn preimage(&self) -> preimage::storage::StorageApi {
            preimage::storage::StorageApi
        }
        pub fn scheduler(&self) -> scheduler::storage::StorageApi {
            scheduler::storage::StorageApi
        }
        pub fn proxy(&self) -> proxy::storage::StorageApi {
            proxy::storage::StorageApi
        }
        pub fn registry(&self) -> registry::storage::StorageApi {
            registry::storage::StorageApi
        }
        pub fn commitments(&self) -> commitments::storage::StorageApi {
            commitments::storage::StorageApi
        }
        pub fn admin_utils(&self) -> admin_utils::storage::StorageApi {
            admin_utils::storage::StorageApi
        }
        pub fn safe_mode(&self) -> safe_mode::storage::StorageApi {
            safe_mode::storage::StorageApi
        }
        pub fn ethereum(&self) -> ethereum::storage::StorageApi {
            ethereum::storage::StorageApi
        }
        pub fn evm(&self) -> evm::storage::StorageApi {
            evm::storage::StorageApi
        }
        pub fn evm_chain_id(&self) -> evm_chain_id::storage::StorageApi {
            evm_chain_id::storage::StorageApi
        }
        pub fn base_fee(&self) -> base_fee::storage::StorageApi {
            base_fee::storage::StorageApi
        }
        pub fn drand(&self) -> drand::storage::StorageApi {
            drand::storage::StorageApi
        }
        pub fn crowdloan(&self) -> crowdloan::storage::StorageApi {
            crowdloan::storage::StorageApi
        }
        pub fn swap(&self) -> swap::storage::StorageApi {
            swap::storage::StorageApi
        }
    }
    pub struct TransactionApi;
    impl TransactionApi {
        pub fn system(&self) -> system::calls::TransactionApi {
            system::calls::TransactionApi
        }
        pub fn timestamp(&self) -> timestamp::calls::TransactionApi {
            timestamp::calls::TransactionApi
        }
        pub fn grandpa(&self) -> grandpa::calls::TransactionApi {
            grandpa::calls::TransactionApi
        }
        pub fn balances(&self) -> balances::calls::TransactionApi {
            balances::calls::TransactionApi
        }
        pub fn subtensor_module(&self) -> subtensor_module::calls::TransactionApi {
            subtensor_module::calls::TransactionApi
        }
        pub fn triumvirate(&self) -> triumvirate::calls::TransactionApi {
            triumvirate::calls::TransactionApi
        }
        pub fn triumvirate_members(&self) -> triumvirate_members::calls::TransactionApi {
            triumvirate_members::calls::TransactionApi
        }
        pub fn senate_members(&self) -> senate_members::calls::TransactionApi {
            senate_members::calls::TransactionApi
        }
        pub fn utility(&self) -> utility::calls::TransactionApi {
            utility::calls::TransactionApi
        }
        pub fn sudo(&self) -> sudo::calls::TransactionApi {
            sudo::calls::TransactionApi
        }
        pub fn multisig(&self) -> multisig::calls::TransactionApi {
            multisig::calls::TransactionApi
        }
        pub fn preimage(&self) -> preimage::calls::TransactionApi {
            preimage::calls::TransactionApi
        }
        pub fn scheduler(&self) -> scheduler::calls::TransactionApi {
            scheduler::calls::TransactionApi
        }
        pub fn proxy(&self) -> proxy::calls::TransactionApi {
            proxy::calls::TransactionApi
        }
        pub fn registry(&self) -> registry::calls::TransactionApi {
            registry::calls::TransactionApi
        }
        pub fn commitments(&self) -> commitments::calls::TransactionApi {
            commitments::calls::TransactionApi
        }
        pub fn admin_utils(&self) -> admin_utils::calls::TransactionApi {
            admin_utils::calls::TransactionApi
        }
        pub fn safe_mode(&self) -> safe_mode::calls::TransactionApi {
            safe_mode::calls::TransactionApi
        }
        pub fn ethereum(&self) -> ethereum::calls::TransactionApi {
            ethereum::calls::TransactionApi
        }
        pub fn evm(&self) -> evm::calls::TransactionApi {
            evm::calls::TransactionApi
        }
        pub fn base_fee(&self) -> base_fee::calls::TransactionApi {
            base_fee::calls::TransactionApi
        }
        pub fn drand(&self) -> drand::calls::TransactionApi {
            drand::calls::TransactionApi
        }
        pub fn crowdloan(&self) -> crowdloan::calls::TransactionApi {
            crowdloan::calls::TransactionApi
        }
        pub fn swap(&self) -> swap::calls::TransactionApi {
            swap::calls::TransactionApi
        }
    }
    #[doc = r" check whether the metadata provided is aligned with this statically generated code."]
    pub fn is_codegen_valid_for(metadata: &::subxt::ext::subxt_core::Metadata) -> bool {
        let runtime_metadata_hash = metadata
            .hasher()
            .only_these_pallets(&PALLETS)
            .only_these_runtime_apis(&RUNTIME_APIS)
            .hash();
        runtime_metadata_hash
            == [
                128u8, 173u8, 220u8, 246u8, 31u8, 83u8, 247u8, 123u8, 237u8, 114u8, 8u8, 174u8,
                105u8, 221u8, 164u8, 239u8, 235u8, 240u8, 90u8, 85u8, 163u8, 195u8, 19u8, 216u8,
                67u8, 120u8, 133u8, 52u8, 91u8, 46u8, 182u8, 120u8,
            ]
    }
    pub mod system {
        use super::root_mod;
        use super::runtime_types;
        #[doc = "Error for the System pallet"]
        pub type Error = runtime_types::frame_system::pallet::Error;
        #[doc = "Contains a variant per dispatchable extrinsic that this pallet has."]
        pub type Call = runtime_types::frame_system::pallet::Call;
        pub mod calls {
            use super::root_mod;
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Make some on-chain remark."]
                #[doc = ""]
                #[doc = "Can be executed by every `origin`."]
                pub struct Remark {
                    pub remark: remark::Remark,
                }
                pub mod remark {
                    use super::runtime_types;
                    pub type Remark =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for Remark {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "remark";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Set the number of pages in the WebAssembly environment's heap."]
                pub struct SetHeapPages {
                    pub pages: set_heap_pages::Pages,
                }
                pub mod set_heap_pages {
                    use super::runtime_types;
                    pub type Pages = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetHeapPages {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "set_heap_pages";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Set the new runtime code."]
                pub struct SetCode {
                    pub code: set_code::Code,
                }
                pub mod set_code {
                    use super::runtime_types;
                    pub type Code =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetCode {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "set_code";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Set the new runtime code without doing any checks of the given `code`."]
                #[doc = ""]
                #[doc = "Note that runtime upgrades will not run if this is called with a not-increasing spec"]
                #[doc = "version!"]
                pub struct SetCodeWithoutChecks {
                    pub code: set_code_without_checks::Code,
                }
                pub mod set_code_without_checks {
                    use super::runtime_types;
                    pub type Code =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetCodeWithoutChecks {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "set_code_without_checks";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Set some items of storage."]
                pub struct SetStorage {
                    pub items: set_storage::Items,
                }
                pub mod set_storage {
                    use super::runtime_types;
                    pub type Items = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>,
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>,
                    )>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetStorage {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "set_storage";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Kill some items from storage."]
                pub struct KillStorage {
                    pub keys: kill_storage::Keys,
                }
                pub mod kill_storage {
                    use super::runtime_types;
                    pub type Keys = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>,
                    >;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for KillStorage {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "kill_storage";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Kill all storage items with a key that starts with the given prefix."]
                #[doc = ""]
                #[doc = "**NOTE:** We rely on the Root origin to provide us the number of subkeys under"]
                #[doc = "the prefix we are removing to accurately calculate the weight of this function."]
                pub struct KillPrefix {
                    pub prefix: kill_prefix::Prefix,
                    pub subkeys: kill_prefix::Subkeys,
                }
                pub mod kill_prefix {
                    use super::runtime_types;
                    pub type Prefix =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Subkeys = ::core::primitive::u32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for KillPrefix {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "kill_prefix";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Make some on-chain remark and emit event."]
                pub struct RemarkWithEvent {
                    pub remark: remark_with_event::Remark,
                }
                pub mod remark_with_event {
                    use super::runtime_types;
                    pub type Remark =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RemarkWithEvent {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "remark_with_event";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Authorize an upgrade to a given `code_hash` for the runtime. The runtime can be supplied"]
                #[doc = "later."]
                #[doc = ""]
                #[doc = "This call requires Root origin."]
                pub struct AuthorizeUpgrade {
                    pub code_hash: authorize_upgrade::CodeHash,
                }
                pub mod authorize_upgrade {
                    use super::runtime_types;
                    pub type CodeHash = ::subxt::ext::subxt_core::utils::H256;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for AuthorizeUpgrade {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "authorize_upgrade";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Authorize an upgrade to a given `code_hash` for the runtime. The runtime can be supplied"]
                #[doc = "later."]
                #[doc = ""]
                #[doc = "WARNING: This authorizes an upgrade that will take place without any safety checks, for"]
                #[doc = "example that the spec name remains the same and that the version number increases. Not"]
                #[doc = "recommended for normal use. Use `authorize_upgrade` instead."]
                #[doc = ""]
                #[doc = "This call requires Root origin."]
                pub struct AuthorizeUpgradeWithoutChecks {
                    pub code_hash: authorize_upgrade_without_checks::CodeHash,
                }
                pub mod authorize_upgrade_without_checks {
                    use super::runtime_types;
                    pub type CodeHash = ::subxt::ext::subxt_core::utils::H256;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for AuthorizeUpgradeWithoutChecks {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "authorize_upgrade_without_checks";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Provide the preimage (runtime binary) `code` for an upgrade that has been authorized."]
                #[doc = ""]
                #[doc = "If the authorization required a version check, this call will ensure the spec name"]
                #[doc = "remains unchanged and that the spec version has increased."]
                #[doc = ""]
                #[doc = "Depending on the runtime's `OnSetCode` configuration, this function may directly apply"]
                #[doc = "the new `code` in the same block or attempt to schedule the upgrade."]
                #[doc = ""]
                #[doc = "All origins are allowed."]
                pub struct ApplyAuthorizedUpgrade {
                    pub code: apply_authorized_upgrade::Code,
                }
                pub mod apply_authorized_upgrade {
                    use super::runtime_types;
                    pub type Code =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ApplyAuthorizedUpgrade {
                    const PALLET: &'static str = "System";
                    const CALL: &'static str = "apply_authorized_upgrade";
                }
            }
            pub struct TransactionApi;
            impl TransactionApi {
                #[doc = "Make some on-chain remark."]
                #[doc = ""]
                #[doc = "Can be executed by every `origin`."]
                pub fn remark(
                    &self,
                    remark: types::remark::Remark,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::Remark>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "remark",
                        types::Remark { remark },
                        [
                            43u8, 126u8, 180u8, 174u8, 141u8, 48u8, 52u8, 125u8, 166u8, 212u8,
                            216u8, 98u8, 100u8, 24u8, 132u8, 71u8, 101u8, 64u8, 246u8, 169u8, 33u8,
                            250u8, 147u8, 208u8, 2u8, 40u8, 129u8, 209u8, 232u8, 207u8, 207u8,
                            13u8,
                        ],
                    )
                }
                #[doc = "Set the number of pages in the WebAssembly environment's heap."]
                pub fn set_heap_pages(
                    &self,
                    pages: types::set_heap_pages::Pages,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetHeapPages>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "set_heap_pages",
                        types::SetHeapPages { pages },
                        [
                            188u8, 191u8, 99u8, 216u8, 219u8, 109u8, 141u8, 50u8, 78u8, 235u8,
                            215u8, 242u8, 195u8, 24u8, 111u8, 76u8, 229u8, 64u8, 99u8, 225u8,
                            134u8, 121u8, 81u8, 209u8, 127u8, 223u8, 98u8, 215u8, 150u8, 70u8,
                            57u8, 147u8,
                        ],
                    )
                }
                #[doc = "Set the new runtime code."]
                pub fn set_code(
                    &self,
                    code: types::set_code::Code,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetCode>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "set_code",
                        types::SetCode { code },
                        [
                            233u8, 248u8, 88u8, 245u8, 28u8, 65u8, 25u8, 169u8, 35u8, 237u8, 19u8,
                            203u8, 136u8, 160u8, 18u8, 3u8, 20u8, 197u8, 81u8, 169u8, 244u8, 188u8,
                            27u8, 147u8, 147u8, 236u8, 65u8, 25u8, 3u8, 143u8, 182u8, 22u8,
                        ],
                    )
                }
                #[doc = "Set the new runtime code without doing any checks of the given `code`."]
                #[doc = ""]
                #[doc = "Note that runtime upgrades will not run if this is called with a not-increasing spec"]
                #[doc = "version!"]
                pub fn set_code_without_checks(
                    &self,
                    code: types::set_code_without_checks::Code,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetCodeWithoutChecks>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "set_code_without_checks",
                        types::SetCodeWithoutChecks { code },
                        [
                            82u8, 212u8, 157u8, 44u8, 70u8, 0u8, 143u8, 15u8, 109u8, 109u8, 107u8,
                            157u8, 141u8, 42u8, 169u8, 11u8, 15u8, 186u8, 252u8, 138u8, 10u8,
                            147u8, 15u8, 178u8, 247u8, 229u8, 213u8, 98u8, 207u8, 231u8, 119u8,
                            115u8,
                        ],
                    )
                }
                #[doc = "Set some items of storage."]
                pub fn set_storage(
                    &self,
                    items: types::set_storage::Items,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetStorage>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "set_storage",
                        types::SetStorage { items },
                        [
                            141u8, 216u8, 52u8, 222u8, 223u8, 136u8, 123u8, 181u8, 19u8, 75u8,
                            163u8, 102u8, 229u8, 189u8, 158u8, 142u8, 95u8, 235u8, 240u8, 49u8,
                            150u8, 76u8, 78u8, 137u8, 126u8, 88u8, 183u8, 88u8, 231u8, 146u8,
                            234u8, 43u8,
                        ],
                    )
                }
                #[doc = "Kill some items from storage."]
                pub fn kill_storage(
                    &self,
                    keys: types::kill_storage::Keys,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::KillStorage>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "kill_storage",
                        types::KillStorage { keys },
                        [
                            73u8, 63u8, 196u8, 36u8, 144u8, 114u8, 34u8, 213u8, 108u8, 93u8, 209u8,
                            234u8, 153u8, 185u8, 33u8, 91u8, 187u8, 195u8, 223u8, 130u8, 58u8,
                            156u8, 63u8, 47u8, 228u8, 249u8, 216u8, 139u8, 143u8, 177u8, 41u8,
                            35u8,
                        ],
                    )
                }
                #[doc = "Kill all storage items with a key that starts with the given prefix."]
                #[doc = ""]
                #[doc = "**NOTE:** We rely on the Root origin to provide us the number of subkeys under"]
                #[doc = "the prefix we are removing to accurately calculate the weight of this function."]
                pub fn kill_prefix(
                    &self,
                    prefix: types::kill_prefix::Prefix,
                    subkeys: types::kill_prefix::Subkeys,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::KillPrefix>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "kill_prefix",
                        types::KillPrefix { prefix, subkeys },
                        [
                            184u8, 57u8, 139u8, 24u8, 208u8, 87u8, 108u8, 215u8, 198u8, 189u8,
                            175u8, 242u8, 167u8, 215u8, 97u8, 63u8, 110u8, 166u8, 238u8, 98u8,
                            67u8, 236u8, 111u8, 110u8, 234u8, 81u8, 102u8, 5u8, 182u8, 5u8, 214u8,
                            85u8,
                        ],
                    )
                }
                #[doc = "Make some on-chain remark and emit event."]
                pub fn remark_with_event(
                    &self,
                    remark: types::remark_with_event::Remark,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::RemarkWithEvent>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "remark_with_event",
                        types::RemarkWithEvent { remark },
                        [
                            120u8, 120u8, 153u8, 92u8, 184u8, 85u8, 34u8, 2u8, 174u8, 206u8, 105u8,
                            228u8, 233u8, 130u8, 80u8, 246u8, 228u8, 59u8, 234u8, 240u8, 4u8, 49u8,
                            147u8, 170u8, 115u8, 91u8, 149u8, 200u8, 228u8, 181u8, 8u8, 154u8,
                        ],
                    )
                }
                #[doc = "Authorize an upgrade to a given `code_hash` for the runtime. The runtime can be supplied"]
                #[doc = "later."]
                #[doc = ""]
                #[doc = "This call requires Root origin."]
                pub fn authorize_upgrade(
                    &self,
                    code_hash: types::authorize_upgrade::CodeHash,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::AuthorizeUpgrade>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "authorize_upgrade",
                        types::AuthorizeUpgrade { code_hash },
                        [
                            4u8, 14u8, 76u8, 107u8, 209u8, 129u8, 9u8, 39u8, 193u8, 17u8, 84u8,
                            254u8, 170u8, 214u8, 24u8, 155u8, 29u8, 184u8, 249u8, 241u8, 109u8,
                            58u8, 145u8, 131u8, 109u8, 63u8, 38u8, 165u8, 107u8, 215u8, 217u8,
                            172u8,
                        ],
                    )
                }
                #[doc = "Authorize an upgrade to a given `code_hash` for the runtime. The runtime can be supplied"]
                #[doc = "later."]
                #[doc = ""]
                #[doc = "WARNING: This authorizes an upgrade that will take place without any safety checks, for"]
                #[doc = "example that the spec name remains the same and that the version number increases. Not"]
                #[doc = "recommended for normal use. Use `authorize_upgrade` instead."]
                #[doc = ""]
                #[doc = "This call requires Root origin."]
                pub fn authorize_upgrade_without_checks(
                    &self,
                    code_hash: types::authorize_upgrade_without_checks::CodeHash,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::AuthorizeUpgradeWithoutChecks,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "authorize_upgrade_without_checks",
                        types::AuthorizeUpgradeWithoutChecks { code_hash },
                        [
                            126u8, 126u8, 55u8, 26u8, 47u8, 55u8, 66u8, 8u8, 167u8, 18u8, 29u8,
                            136u8, 146u8, 14u8, 189u8, 117u8, 16u8, 227u8, 162u8, 61u8, 149u8,
                            197u8, 104u8, 184u8, 185u8, 161u8, 99u8, 154u8, 80u8, 125u8, 181u8,
                            233u8,
                        ],
                    )
                }
                #[doc = "Provide the preimage (runtime binary) `code` for an upgrade that has been authorized."]
                #[doc = ""]
                #[doc = "If the authorization required a version check, this call will ensure the spec name"]
                #[doc = "remains unchanged and that the spec version has increased."]
                #[doc = ""]
                #[doc = "Depending on the runtime's `OnSetCode` configuration, this function may directly apply"]
                #[doc = "the new `code` in the same block or attempt to schedule the upgrade."]
                #[doc = ""]
                #[doc = "All origins are allowed."]
                pub fn apply_authorized_upgrade(
                    &self,
                    code: types::apply_authorized_upgrade::Code,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::ApplyAuthorizedUpgrade,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "System",
                        "apply_authorized_upgrade",
                        types::ApplyAuthorizedUpgrade { code },
                        [
                            232u8, 107u8, 127u8, 38u8, 230u8, 29u8, 97u8, 4u8, 160u8, 191u8, 222u8,
                            156u8, 245u8, 102u8, 196u8, 141u8, 44u8, 163u8, 98u8, 68u8, 125u8,
                            32u8, 124u8, 101u8, 108u8, 93u8, 211u8, 52u8, 0u8, 231u8, 33u8, 227u8,
                        ],
                    )
                }
            }
        }
        #[doc = "Event for the System pallet."]
        pub type Event = runtime_types::frame_system::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "An extrinsic completed successfully."]
            pub struct ExtrinsicSuccess {
                pub dispatch_info: extrinsic_success::DispatchInfo,
            }
            pub mod extrinsic_success {
                use super::runtime_types;
                pub type DispatchInfo = runtime_types::frame_system::DispatchEventInfo;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ExtrinsicSuccess {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "ExtrinsicSuccess";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "An extrinsic failed."]
            pub struct ExtrinsicFailed {
                pub dispatch_error: extrinsic_failed::DispatchError,
                pub dispatch_info: extrinsic_failed::DispatchInfo,
            }
            pub mod extrinsic_failed {
                use super::runtime_types;
                pub type DispatchError = runtime_types::sp_runtime::DispatchError;
                pub type DispatchInfo = runtime_types::frame_system::DispatchEventInfo;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ExtrinsicFailed {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "ExtrinsicFailed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "`:code` was updated."]
            pub struct CodeUpdated;
            impl ::subxt::ext::subxt_core::events::StaticEvent for CodeUpdated {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "CodeUpdated";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A new account was created."]
            pub struct NewAccount {
                pub account: new_account::Account,
            }
            pub mod new_account {
                use super::runtime_types;
                pub type Account = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NewAccount {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "NewAccount";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "An account was reaped."]
            pub struct KilledAccount {
                pub account: killed_account::Account,
            }
            pub mod killed_account {
                use super::runtime_types;
                pub type Account = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for KilledAccount {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "KilledAccount";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "On on-chain remark happened."]
            pub struct Remarked {
                pub sender: remarked::Sender,
                pub hash: remarked::Hash,
            }
            pub mod remarked {
                use super::runtime_types;
                pub type Sender = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Hash = ::subxt::ext::subxt_core::utils::H256;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Remarked {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "Remarked";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "An upgrade was authorized."]
            pub struct UpgradeAuthorized {
                pub code_hash: upgrade_authorized::CodeHash,
                pub check_version: upgrade_authorized::CheckVersion,
            }
            pub mod upgrade_authorized {
                use super::runtime_types;
                pub type CodeHash = ::subxt::ext::subxt_core::utils::H256;
                pub type CheckVersion = ::core::primitive::bool;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for UpgradeAuthorized {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "UpgradeAuthorized";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                pub mod account {
                    use super::runtime_types;
                    pub type Account = runtime_types::frame_system::AccountInfo<
                        ::core::primitive::u32,
                        runtime_types::pallet_balances::types::AccountData<::core::primitive::u64>,
                    >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod extrinsic_count {
                    use super::runtime_types;
                    pub type ExtrinsicCount = ::core::primitive::u32;
                }
                pub mod inherents_applied {
                    use super::runtime_types;
                    pub type InherentsApplied = ::core::primitive::bool;
                }
                pub mod block_weight {
                    use super::runtime_types;
                    pub type BlockWeight = runtime_types::frame_support::dispatch::PerDispatchClass<
                        runtime_types::sp_weights::weight_v2::Weight,
                    >;
                }
                pub mod all_extrinsics_len {
                    use super::runtime_types;
                    pub type AllExtrinsicsLen = ::core::primitive::u32;
                }
                pub mod block_hash {
                    use super::runtime_types;
                    pub type BlockHash = ::subxt::ext::subxt_core::utils::H256;
                    pub type Param0 = ::core::primitive::u32;
                }
                pub mod extrinsic_data {
                    use super::runtime_types;
                    pub type ExtrinsicData =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Param0 = ::core::primitive::u32;
                }
                pub mod number {
                    use super::runtime_types;
                    pub type Number = ::core::primitive::u32;
                }
                pub mod parent_hash {
                    use super::runtime_types;
                    pub type ParentHash = ::subxt::ext::subxt_core::utils::H256;
                }
                pub mod digest {
                    use super::runtime_types;
                    pub type Digest = runtime_types::sp_runtime::generic::digest::Digest;
                }
                pub mod events {
                    use super::runtime_types;
                    pub type Events = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        runtime_types::frame_system::EventRecord<
                            runtime_types::node_subtensor_runtime::RuntimeEvent,
                            ::subxt::ext::subxt_core::utils::H256,
                        >,
                    >;
                }
                pub mod event_count {
                    use super::runtime_types;
                    pub type EventCount = ::core::primitive::u32;
                }
                pub mod event_topics {
                    use super::runtime_types;
                    pub type EventTopics = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::H256;
                }
                pub mod last_runtime_upgrade {
                    use super::runtime_types;
                    pub type LastRuntimeUpgrade =
                        runtime_types::frame_system::LastRuntimeUpgradeInfo;
                }
                pub mod upgraded_to_u32_ref_count {
                    use super::runtime_types;
                    pub type UpgradedToU32RefCount = ::core::primitive::bool;
                }
                pub mod upgraded_to_triple_ref_count {
                    use super::runtime_types;
                    pub type UpgradedToTripleRefCount = ::core::primitive::bool;
                }
                pub mod execution_phase {
                    use super::runtime_types;
                    pub type ExecutionPhase = runtime_types::frame_system::Phase;
                }
                pub mod authorized_upgrade {
                    use super::runtime_types;
                    pub type AuthorizedUpgrade =
                        runtime_types::frame_system::CodeUpgradeAuthorization;
                }
            }
            pub struct StorageApi;
            impl StorageApi {
                #[doc = " The full account information for a particular account ID."]
                pub fn account_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::account::Account,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "Account",
                        (),
                        [
                            134u8, 36u8, 200u8, 97u8, 250u8, 93u8, 194u8, 130u8, 234u8, 169u8,
                            160u8, 176u8, 58u8, 142u8, 63u8, 133u8, 29u8, 94u8, 102u8, 192u8, 82u8,
                            6u8, 105u8, 248u8, 238u8, 246u8, 26u8, 107u8, 39u8, 219u8, 103u8,
                            212u8,
                        ],
                    )
                }
                #[doc = " The full account information for a particular account ID."]
                pub fn account(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::account::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::account::Param0,
                    >,
                    types::account::Account,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "Account",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            134u8, 36u8, 200u8, 97u8, 250u8, 93u8, 194u8, 130u8, 234u8, 169u8,
                            160u8, 176u8, 58u8, 142u8, 63u8, 133u8, 29u8, 94u8, 102u8, 192u8, 82u8,
                            6u8, 105u8, 248u8, 238u8, 246u8, 26u8, 107u8, 39u8, 219u8, 103u8,
                            212u8,
                        ],
                    )
                }
                #[doc = " Total extrinsics count for the current block."]
                pub fn extrinsic_count(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::extrinsic_count::ExtrinsicCount,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "ExtrinsicCount",
                        (),
                        [
                            102u8, 76u8, 236u8, 42u8, 40u8, 231u8, 33u8, 222u8, 123u8, 147u8,
                            153u8, 148u8, 234u8, 203u8, 181u8, 119u8, 6u8, 187u8, 177u8, 199u8,
                            120u8, 47u8, 137u8, 254u8, 96u8, 100u8, 165u8, 182u8, 249u8, 230u8,
                            159u8, 79u8,
                        ],
                    )
                }
                #[doc = " Whether all inherents have been applied."]
                pub fn inherents_applied(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::inherents_applied::InherentsApplied,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "InherentsApplied",
                        (),
                        [
                            132u8, 249u8, 142u8, 252u8, 8u8, 103u8, 80u8, 120u8, 50u8, 6u8, 188u8,
                            223u8, 101u8, 55u8, 165u8, 189u8, 172u8, 249u8, 165u8, 230u8, 183u8,
                            109u8, 34u8, 65u8, 185u8, 150u8, 29u8, 8u8, 186u8, 129u8, 135u8, 239u8,
                        ],
                    )
                }
                #[doc = " The current weight for the block."]
                pub fn block_weight(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::block_weight::BlockWeight,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "BlockWeight",
                        (),
                        [
                            158u8, 46u8, 228u8, 89u8, 210u8, 214u8, 84u8, 154u8, 50u8, 68u8, 63u8,
                            62u8, 43u8, 42u8, 99u8, 27u8, 54u8, 42u8, 146u8, 44u8, 241u8, 216u8,
                            229u8, 30u8, 216u8, 255u8, 165u8, 238u8, 181u8, 130u8, 36u8, 102u8,
                        ],
                    )
                }
                #[doc = " Total length (in bytes) for all extrinsics put together, for the current block."]
                pub fn all_extrinsics_len(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::all_extrinsics_len::AllExtrinsicsLen,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "AllExtrinsicsLen",
                        (),
                        [
                            117u8, 86u8, 61u8, 243u8, 41u8, 51u8, 102u8, 214u8, 137u8, 100u8,
                            243u8, 185u8, 122u8, 174u8, 187u8, 117u8, 86u8, 189u8, 63u8, 135u8,
                            101u8, 218u8, 203u8, 201u8, 237u8, 254u8, 128u8, 183u8, 169u8, 221u8,
                            242u8, 65u8,
                        ],
                    )
                }
                #[doc = " Map of block numbers to block hashes."]
                pub fn block_hash_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::block_hash::BlockHash,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "BlockHash",
                        (),
                        [
                            217u8, 32u8, 215u8, 253u8, 24u8, 182u8, 207u8, 178u8, 157u8, 24u8,
                            103u8, 100u8, 195u8, 165u8, 69u8, 152u8, 112u8, 181u8, 56u8, 192u8,
                            164u8, 16u8, 20u8, 222u8, 28u8, 214u8, 144u8, 142u8, 146u8, 69u8,
                            202u8, 118u8,
                        ],
                    )
                }
                #[doc = " Map of block numbers to block hashes."]
                pub fn block_hash(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::block_hash::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::block_hash::Param0,
                    >,
                    types::block_hash::BlockHash,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "BlockHash",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            217u8, 32u8, 215u8, 253u8, 24u8, 182u8, 207u8, 178u8, 157u8, 24u8,
                            103u8, 100u8, 195u8, 165u8, 69u8, 152u8, 112u8, 181u8, 56u8, 192u8,
                            164u8, 16u8, 20u8, 222u8, 28u8, 214u8, 144u8, 142u8, 146u8, 69u8,
                            202u8, 118u8,
                        ],
                    )
                }
                #[doc = " Extrinsics data for the current block (maps an extrinsic's index to its data)."]
                pub fn extrinsic_data_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::extrinsic_data::ExtrinsicData,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "ExtrinsicData",
                        (),
                        [
                            160u8, 180u8, 122u8, 18u8, 196u8, 26u8, 2u8, 37u8, 115u8, 232u8, 133u8,
                            220u8, 106u8, 245u8, 4u8, 129u8, 42u8, 84u8, 241u8, 45u8, 199u8, 179u8,
                            128u8, 61u8, 170u8, 137u8, 231u8, 156u8, 247u8, 57u8, 47u8, 38u8,
                        ],
                    )
                }
                #[doc = " Extrinsics data for the current block (maps an extrinsic's index to its data)."]
                pub fn extrinsic_data(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::extrinsic_data::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::extrinsic_data::Param0,
                    >,
                    types::extrinsic_data::ExtrinsicData,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "ExtrinsicData",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            160u8, 180u8, 122u8, 18u8, 196u8, 26u8, 2u8, 37u8, 115u8, 232u8, 133u8,
                            220u8, 106u8, 245u8, 4u8, 129u8, 42u8, 84u8, 241u8, 45u8, 199u8, 179u8,
                            128u8, 61u8, 170u8, 137u8, 231u8, 156u8, 247u8, 57u8, 47u8, 38u8,
                        ],
                    )
                }
                #[doc = " The current block number being processed. Set by `execute_block`."]
                pub fn number(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::number::Number,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "Number",
                        (),
                        [
                            30u8, 194u8, 177u8, 90u8, 194u8, 232u8, 46u8, 180u8, 85u8, 129u8, 14u8,
                            9u8, 8u8, 8u8, 23u8, 95u8, 230u8, 5u8, 13u8, 105u8, 125u8, 2u8, 22u8,
                            200u8, 78u8, 93u8, 115u8, 28u8, 150u8, 113u8, 48u8, 53u8,
                        ],
                    )
                }
                #[doc = " Hash of the previous block."]
                pub fn parent_hash(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::parent_hash::ParentHash,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "ParentHash",
                        (),
                        [
                            26u8, 130u8, 11u8, 216u8, 155u8, 71u8, 128u8, 170u8, 30u8, 153u8, 21u8,
                            192u8, 62u8, 93u8, 137u8, 80u8, 120u8, 81u8, 202u8, 94u8, 248u8, 125u8,
                            71u8, 82u8, 141u8, 229u8, 32u8, 56u8, 73u8, 50u8, 101u8, 78u8,
                        ],
                    )
                }
                #[doc = " Digest of the current block, also part of the block header."]
                pub fn digest(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::digest::Digest,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "Digest",
                        (),
                        [
                            61u8, 64u8, 237u8, 91u8, 145u8, 232u8, 17u8, 254u8, 181u8, 16u8, 234u8,
                            91u8, 51u8, 140u8, 254u8, 131u8, 98u8, 135u8, 21u8, 37u8, 251u8, 20u8,
                            58u8, 92u8, 123u8, 141u8, 14u8, 227u8, 146u8, 46u8, 222u8, 117u8,
                        ],
                    )
                }
                #[doc = " Events deposited for the current block."]
                #[doc = ""]
                #[doc = " NOTE: The item is unbound and should therefore never be read on chain."]
                #[doc = " It could otherwise inflate the PoV size of a block."]
                #[doc = ""]
                #[doc = " Events have a large in-memory size. Box the events to not go out-of-memory"]
                #[doc = " just in case someone still reads them from within the runtime."]
                pub fn events(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::events::Events,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "Events",
                        (),
                        [
                            134u8, 187u8, 47u8, 40u8, 222u8, 241u8, 167u8, 190u8, 169u8, 23u8,
                            124u8, 179u8, 6u8, 51u8, 60u8, 231u8, 156u8, 126u8, 161u8, 131u8,
                            228u8, 154u8, 26u8, 35u8, 194u8, 142u8, 136u8, 205u8, 168u8, 82u8,
                            110u8, 161u8,
                        ],
                    )
                }
                #[doc = " The number of events in the `Events<T>` list."]
                pub fn event_count(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::event_count::EventCount,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "EventCount",
                        (),
                        [
                            175u8, 24u8, 252u8, 184u8, 210u8, 167u8, 146u8, 143u8, 164u8, 80u8,
                            151u8, 205u8, 189u8, 189u8, 55u8, 220u8, 47u8, 101u8, 181u8, 33u8,
                            254u8, 131u8, 13u8, 143u8, 3u8, 244u8, 245u8, 45u8, 2u8, 210u8, 79u8,
                            133u8,
                        ],
                    )
                }
                #[doc = " Mapping between a topic (represented by T::Hash) and a vector of indexes"]
                #[doc = " of events in the `<Events<T>>` list."]
                #[doc = ""]
                #[doc = " All topic vectors have deterministic storage locations depending on the topic. This"]
                #[doc = " allows light-clients to leverage the changes trie storage tracking mechanism and"]
                #[doc = " in case of changes fetch the list of events of interest."]
                #[doc = ""]
                #[doc = " The value has the type `(BlockNumberFor<T>, EventIndex)` because if we used only just"]
                #[doc = " the `EventIndex` then in case if the topic has the same contents on the next block"]
                #[doc = " no notification will be triggered thus the event might be lost."]
                pub fn event_topics_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::event_topics::EventTopics,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "EventTopics",
                        (),
                        [
                            40u8, 225u8, 14u8, 75u8, 44u8, 176u8, 76u8, 34u8, 143u8, 107u8, 69u8,
                            133u8, 114u8, 13u8, 172u8, 250u8, 141u8, 73u8, 12u8, 65u8, 217u8, 63u8,
                            120u8, 241u8, 48u8, 106u8, 143u8, 161u8, 128u8, 100u8, 166u8, 59u8,
                        ],
                    )
                }
                #[doc = " Mapping between a topic (represented by T::Hash) and a vector of indexes"]
                #[doc = " of events in the `<Events<T>>` list."]
                #[doc = ""]
                #[doc = " All topic vectors have deterministic storage locations depending on the topic. This"]
                #[doc = " allows light-clients to leverage the changes trie storage tracking mechanism and"]
                #[doc = " in case of changes fetch the list of events of interest."]
                #[doc = ""]
                #[doc = " The value has the type `(BlockNumberFor<T>, EventIndex)` because if we used only just"]
                #[doc = " the `EventIndex` then in case if the topic has the same contents on the next block"]
                #[doc = " no notification will be triggered thus the event might be lost."]
                pub fn event_topics(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::event_topics::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::event_topics::Param0,
                    >,
                    types::event_topics::EventTopics,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "EventTopics",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            40u8, 225u8, 14u8, 75u8, 44u8, 176u8, 76u8, 34u8, 143u8, 107u8, 69u8,
                            133u8, 114u8, 13u8, 172u8, 250u8, 141u8, 73u8, 12u8, 65u8, 217u8, 63u8,
                            120u8, 241u8, 48u8, 106u8, 143u8, 161u8, 128u8, 100u8, 166u8, 59u8,
                        ],
                    )
                }
                #[doc = " Stores the `spec_version` and `spec_name` of when the last runtime upgrade happened."]
                pub fn last_runtime_upgrade(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::last_runtime_upgrade::LastRuntimeUpgrade,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "LastRuntimeUpgrade",
                        (),
                        [
                            197u8, 212u8, 249u8, 209u8, 79u8, 34u8, 55u8, 203u8, 31u8, 42u8, 199u8,
                            242u8, 188u8, 74u8, 234u8, 250u8, 245u8, 44u8, 139u8, 162u8, 45u8,
                            150u8, 230u8, 249u8, 135u8, 100u8, 158u8, 167u8, 118u8, 219u8, 28u8,
                            98u8,
                        ],
                    )
                }
                #[doc = " True if we have upgraded so that `type RefCount` is `u32`. False (default) if not."]
                pub fn upgraded_to_u32_ref_count(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::upgraded_to_u32_ref_count::UpgradedToU32RefCount,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "UpgradedToU32RefCount",
                        (),
                        [
                            229u8, 73u8, 9u8, 132u8, 186u8, 116u8, 151u8, 171u8, 145u8, 29u8, 34u8,
                            130u8, 52u8, 146u8, 124u8, 175u8, 79u8, 189u8, 147u8, 230u8, 234u8,
                            107u8, 124u8, 31u8, 2u8, 22u8, 86u8, 190u8, 4u8, 147u8, 50u8, 245u8,
                        ],
                    )
                }
                #[doc = " True if we have upgraded so that AccountInfo contains three types of `RefCount`. False"]
                #[doc = " (default) if not."]
                pub fn upgraded_to_triple_ref_count(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::upgraded_to_triple_ref_count::UpgradedToTripleRefCount,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "UpgradedToTripleRefCount",
                        (),
                        [
                            97u8, 66u8, 124u8, 243u8, 27u8, 167u8, 147u8, 81u8, 254u8, 201u8,
                            101u8, 24u8, 40u8, 231u8, 14u8, 179u8, 154u8, 163u8, 71u8, 81u8, 185u8,
                            167u8, 82u8, 254u8, 189u8, 3u8, 101u8, 207u8, 206u8, 194u8, 155u8,
                            151u8,
                        ],
                    )
                }
                #[doc = " The execution phase of the block."]
                pub fn execution_phase(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::execution_phase::ExecutionPhase,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "ExecutionPhase",
                        (),
                        [
                            191u8, 129u8, 100u8, 134u8, 126u8, 116u8, 154u8, 203u8, 220u8, 200u8,
                            0u8, 26u8, 161u8, 250u8, 133u8, 205u8, 146u8, 24u8, 5u8, 156u8, 158u8,
                            35u8, 36u8, 253u8, 52u8, 235u8, 86u8, 167u8, 35u8, 100u8, 119u8, 27u8,
                        ],
                    )
                }
                #[doc = " `Some` if a code upgrade has been authorized."]
                pub fn authorized_upgrade(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::authorized_upgrade::AuthorizedUpgrade,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "System",
                        "AuthorizedUpgrade",
                        (),
                        [
                            165u8, 97u8, 27u8, 138u8, 2u8, 28u8, 55u8, 92u8, 96u8, 96u8, 168u8,
                            169u8, 55u8, 178u8, 44u8, 127u8, 58u8, 140u8, 206u8, 178u8, 1u8, 37u8,
                            214u8, 213u8, 251u8, 123u8, 5u8, 111u8, 90u8, 148u8, 217u8, 135u8,
                        ],
                    )
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                #[doc = " Block & extrinsics weights: base values and limits."]
                pub fn block_weights(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    runtime_types::frame_system::limits::BlockWeights,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "System",
                        "BlockWeights",
                        [
                            176u8, 124u8, 225u8, 136u8, 25u8, 73u8, 247u8, 33u8, 82u8, 206u8, 85u8,
                            190u8, 127u8, 102u8, 71u8, 11u8, 185u8, 8u8, 58u8, 0u8, 94u8, 55u8,
                            163u8, 177u8, 104u8, 59u8, 60u8, 136u8, 246u8, 116u8, 0u8, 239u8,
                        ],
                    )
                }
                #[doc = " The maximum length of a block (in bytes)."]
                pub fn block_length(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    runtime_types::frame_system::limits::BlockLength,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "System",
                        "BlockLength",
                        [
                            23u8, 242u8, 225u8, 39u8, 225u8, 67u8, 152u8, 41u8, 155u8, 104u8, 68u8,
                            229u8, 185u8, 133u8, 10u8, 143u8, 184u8, 152u8, 234u8, 44u8, 140u8,
                            96u8, 166u8, 235u8, 162u8, 160u8, 72u8, 7u8, 35u8, 194u8, 3u8, 37u8,
                        ],
                    )
                }
                #[doc = " Maximum number of block number to block hash mappings to keep (oldest pruned first)."]
                pub fn block_hash_count(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u32,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "System",
                        "BlockHashCount",
                        [
                            98u8, 252u8, 116u8, 72u8, 26u8, 180u8, 225u8, 83u8, 200u8, 157u8,
                            125u8, 151u8, 53u8, 76u8, 168u8, 26u8, 10u8, 9u8, 98u8, 68u8, 9u8,
                            178u8, 197u8, 113u8, 31u8, 79u8, 200u8, 90u8, 203u8, 100u8, 41u8,
                            145u8,
                        ],
                    )
                }
                #[doc = " The weight of runtime database operations the runtime can invoke."]
                pub fn db_weight(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    runtime_types::sp_weights::RuntimeDbWeight,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "System",
                        "DbWeight",
                        [
                            42u8, 43u8, 178u8, 142u8, 243u8, 203u8, 60u8, 173u8, 118u8, 111u8,
                            200u8, 170u8, 102u8, 70u8, 237u8, 187u8, 198u8, 120u8, 153u8, 232u8,
                            183u8, 76u8, 74u8, 10u8, 70u8, 243u8, 14u8, 218u8, 213u8, 126u8, 29u8,
                            177u8,
                        ],
                    )
                }
                #[doc = " Get the chain's in-code version."]
                pub fn version(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    runtime_types::sp_version::RuntimeVersion,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "System",
                        "Version",
                        [
                            214u8, 43u8, 96u8, 193u8, 96u8, 213u8, 63u8, 124u8, 22u8, 111u8, 41u8,
                            78u8, 146u8, 77u8, 34u8, 163u8, 117u8, 100u8, 6u8, 216u8, 238u8, 54u8,
                            80u8, 185u8, 219u8, 11u8, 192u8, 200u8, 129u8, 88u8, 161u8, 250u8,
                        ],
                    )
                }
                #[doc = " The designated SS58 prefix of this chain."]
                #[doc = ""]
                #[doc = " This replaces the \"ss58Format\" property declared in the chain spec. Reason is"]
                #[doc = " that the runtime should know about the prefix in order to make use of it as"]
                #[doc = " an identifier of the chain."]
                pub fn ss58_prefix(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u16,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "System",
                        "SS58Prefix",
                        [
                            116u8, 33u8, 2u8, 170u8, 181u8, 147u8, 171u8, 169u8, 167u8, 227u8,
                            41u8, 144u8, 11u8, 236u8, 82u8, 100u8, 74u8, 60u8, 184u8, 72u8, 169u8,
                            90u8, 208u8, 135u8, 15u8, 117u8, 10u8, 123u8, 128u8, 193u8, 29u8, 70u8,
                        ],
                    )
                }
            }
        }
    }
    pub mod randomness_collective_flip {
        use super::root_mod;
        use super::runtime_types;
        pub mod storage {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                pub mod random_material {
                    use super::runtime_types;
                    pub type RandomMaterial =
                        runtime_types::bounded_collections::bounded_vec::BoundedVec<
                            ::subxt::ext::subxt_core::utils::H256,
                        >;
                }
            }
            pub struct StorageApi;
            impl StorageApi {
                #[doc = " Series of block headers from the last 81 blocks that acts as random seed material. This"]
                #[doc = " is arranged as a ring buffer with `block_number % 81` being the index into the `Vec` of"]
                #[doc = " the oldest hash."]
                pub fn random_material(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::random_material::RandomMaterial,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "RandomnessCollectiveFlip",
                        "RandomMaterial",
                        (),
                        [
                            195u8, 232u8, 244u8, 162u8, 110u8, 137u8, 66u8, 57u8, 51u8, 221u8,
                            143u8, 38u8, 51u8, 183u8, 105u8, 245u8, 175u8, 13u8, 33u8, 192u8, 53u8,
                            16u8, 161u8, 76u8, 219u8, 177u8, 144u8, 192u8, 96u8, 166u8, 117u8,
                            247u8,
                        ],
                    )
                }
            }
        }
    }
    pub mod timestamp {
        use super::root_mod;
        use super::runtime_types;
        #[doc = "Contains a variant per dispatchable extrinsic that this pallet has."]
        pub type Call = runtime_types::pallet_timestamp::pallet::Call;
        pub mod calls {
            use super::root_mod;
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Set the current time."]
                #[doc = ""]
                #[doc = "This call should be invoked exactly once per block. It will panic at the finalization"]
                #[doc = "phase, if this call hasn't been invoked by that time."]
                #[doc = ""]
                #[doc = "The timestamp should be greater than the previous one by the amount specified by"]
                #[doc = "[`Config::MinimumPeriod`]."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call must be _None_."]
                #[doc = ""]
                #[doc = "This dispatch class is _Mandatory_ to ensure it gets executed in the block. Be aware"]
                #[doc = "that changing the complexity of this call could result exhausting the resources in a"]
                #[doc = "block to execute any other calls."]
                #[doc = ""]
                #[doc = "## Complexity"]
                #[doc = "- `O(1)` (Note that implementations of `OnTimestampSet` must also be `O(1)`)"]
                #[doc = "- 1 storage read and 1 storage mutation (codec `O(1)` because of `DidUpdate::take` in"]
                #[doc = "  `on_finalize`)"]
                #[doc = "- 1 event handler `on_timestamp_set`. Must be `O(1)`."]
                pub struct Set {
                    #[codec(compact)]
                    pub now: set::Now,
                }
                pub mod set {
                    use super::runtime_types;
                    pub type Now = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for Set {
                    const PALLET: &'static str = "Timestamp";
                    const CALL: &'static str = "set";
                }
            }
            pub struct TransactionApi;
            impl TransactionApi {
                #[doc = "Set the current time."]
                #[doc = ""]
                #[doc = "This call should be invoked exactly once per block. It will panic at the finalization"]
                #[doc = "phase, if this call hasn't been invoked by that time."]
                #[doc = ""]
                #[doc = "The timestamp should be greater than the previous one by the amount specified by"]
                #[doc = "[`Config::MinimumPeriod`]."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call must be _None_."]
                #[doc = ""]
                #[doc = "This dispatch class is _Mandatory_ to ensure it gets executed in the block. Be aware"]
                #[doc = "that changing the complexity of this call could result exhausting the resources in a"]
                #[doc = "block to execute any other calls."]
                #[doc = ""]
                #[doc = "## Complexity"]
                #[doc = "- `O(1)` (Note that implementations of `OnTimestampSet` must also be `O(1)`)"]
                #[doc = "- 1 storage read and 1 storage mutation (codec `O(1)` because of `DidUpdate::take` in"]
                #[doc = "  `on_finalize`)"]
                #[doc = "- 1 event handler `on_timestamp_set`. Must be `O(1)`."]
                pub fn set(
                    &self,
                    now: types::set::Now,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::Set>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Timestamp",
                        "set",
                        types::Set { now },
                        [
                            37u8, 95u8, 49u8, 218u8, 24u8, 22u8, 0u8, 95u8, 72u8, 35u8, 155u8,
                            199u8, 213u8, 54u8, 207u8, 22u8, 185u8, 193u8, 221u8, 70u8, 18u8,
                            200u8, 4u8, 231u8, 195u8, 173u8, 6u8, 122u8, 11u8, 203u8, 231u8, 227u8,
                        ],
                    )
                }
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                pub mod now {
                    use super::runtime_types;
                    pub type Now = ::core::primitive::u64;
                }
                pub mod did_update {
                    use super::runtime_types;
                    pub type DidUpdate = ::core::primitive::bool;
                }
            }
            pub struct StorageApi;
            impl StorageApi {
                #[doc = " The current time for the current block."]
                pub fn now(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::now::Now,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Timestamp",
                        "Now",
                        (),
                        [
                            44u8, 50u8, 80u8, 30u8, 195u8, 146u8, 123u8, 238u8, 8u8, 163u8, 187u8,
                            92u8, 61u8, 39u8, 51u8, 29u8, 173u8, 169u8, 217u8, 158u8, 85u8, 187u8,
                            141u8, 26u8, 12u8, 115u8, 51u8, 11u8, 200u8, 244u8, 138u8, 152u8,
                        ],
                    )
                }
                #[doc = " Whether the timestamp has been updated in this block."]
                #[doc = ""]
                #[doc = " This value is updated to `true` upon successful submission of a timestamp by a node."]
                #[doc = " It is then checked at the end of each block execution in the `on_finalize` hook."]
                pub fn did_update(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::did_update::DidUpdate,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Timestamp",
                        "DidUpdate",
                        (),
                        [
                            229u8, 175u8, 246u8, 102u8, 237u8, 158u8, 212u8, 229u8, 238u8, 214u8,
                            205u8, 160u8, 164u8, 252u8, 195u8, 75u8, 139u8, 110u8, 22u8, 34u8,
                            248u8, 204u8, 107u8, 46u8, 20u8, 200u8, 238u8, 167u8, 71u8, 41u8,
                            214u8, 140u8,
                        ],
                    )
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                #[doc = " The minimum period between blocks."]
                #[doc = ""]
                #[doc = " Be aware that this is different to the *expected* period that the block production"]
                #[doc = " apparatus provides. Your chosen consensus system will generally work with this to"]
                #[doc = " determine a sensible block time. For example, in the Aura pallet it will be double this"]
                #[doc = " period on default settings."]
                pub fn minimum_period(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u64,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Timestamp",
                        "MinimumPeriod",
                        [
                            128u8, 214u8, 205u8, 242u8, 181u8, 142u8, 124u8, 231u8, 190u8, 146u8,
                            59u8, 226u8, 157u8, 101u8, 103u8, 117u8, 249u8, 65u8, 18u8, 191u8,
                            103u8, 119u8, 53u8, 85u8, 81u8, 96u8, 220u8, 42u8, 184u8, 239u8, 42u8,
                            246u8,
                        ],
                    )
                }
            }
        }
    }
    pub mod aura {
        use super::root_mod;
        use super::runtime_types;
        pub mod storage {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                pub mod authorities {
                    use super::runtime_types;
                    pub type Authorities =
                        runtime_types::bounded_collections::bounded_vec::BoundedVec<
                            runtime_types::sp_consensus_aura::sr25519::app_sr25519::Public,
                        >;
                }
                pub mod current_slot {
                    use super::runtime_types;
                    pub type CurrentSlot = runtime_types::sp_consensus_slots::Slot;
                }
            }
            pub struct StorageApi;
            impl StorageApi {
                #[doc = " The current authority set."]
                pub fn authorities(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::authorities::Authorities,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Aura",
                        "Authorities",
                        (),
                        [
                            95u8, 52u8, 203u8, 53u8, 254u8, 107u8, 134u8, 122u8, 95u8, 253u8, 51u8,
                            137u8, 142u8, 106u8, 237u8, 248u8, 159u8, 80u8, 41u8, 233u8, 137u8,
                            133u8, 13u8, 217u8, 176u8, 88u8, 132u8, 199u8, 241u8, 47u8, 125u8,
                            27u8,
                        ],
                    )
                }
                #[doc = " The current slot of this block."]
                #[doc = ""]
                #[doc = " This will be set in `on_initialize`."]
                pub fn current_slot(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::current_slot::CurrentSlot,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Aura",
                        "CurrentSlot",
                        (),
                        [
                            112u8, 199u8, 115u8, 248u8, 217u8, 242u8, 45u8, 231u8, 178u8, 53u8,
                            236u8, 167u8, 219u8, 238u8, 81u8, 243u8, 39u8, 140u8, 68u8, 19u8,
                            201u8, 169u8, 211u8, 133u8, 135u8, 213u8, 150u8, 105u8, 60u8, 252u8,
                            43u8, 57u8,
                        ],
                    )
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                #[doc = " The slot duration Aura should run with, expressed in milliseconds."]
                #[doc = " The effective value of this type should not change while the chain is running."]
                #[doc = ""]
                #[doc = " For backwards compatibility either use [`MinimumPeriodTimesTwo`] or a const."]
                pub fn slot_duration(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u64,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Aura",
                        "SlotDuration",
                        [
                            128u8, 214u8, 205u8, 242u8, 181u8, 142u8, 124u8, 231u8, 190u8, 146u8,
                            59u8, 226u8, 157u8, 101u8, 103u8, 117u8, 249u8, 65u8, 18u8, 191u8,
                            103u8, 119u8, 53u8, 85u8, 81u8, 96u8, 220u8, 42u8, 184u8, 239u8, 42u8,
                            246u8,
                        ],
                    )
                }
            }
        }
    }
    pub mod grandpa {
        use super::root_mod;
        use super::runtime_types;
        #[doc = "The `Error` enum of this pallet."]
        pub type Error = runtime_types::pallet_grandpa::pallet::Error;
        #[doc = "Contains a variant per dispatchable extrinsic that this pallet has."]
        pub type Call = runtime_types::pallet_grandpa::pallet::Call;
        pub mod calls {
            use super::root_mod;
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Report voter equivocation/misbehavior. This method will verify the"]
                #[doc = "equivocation proof and validate the given key ownership proof"]
                #[doc = "against the extracted offender. If both are valid, the offence"]
                #[doc = "will be reported."]
                pub struct ReportEquivocation {
                    pub equivocation_proof: ::subxt::ext::subxt_core::alloc::boxed::Box<
                        report_equivocation::EquivocationProof,
                    >,
                    pub key_owner_proof: report_equivocation::KeyOwnerProof,
                }
                pub mod report_equivocation {
                    use super::runtime_types;
                    pub type EquivocationProof =
                        runtime_types::sp_consensus_grandpa::EquivocationProof<
                            ::subxt::ext::subxt_core::utils::H256,
                            ::core::primitive::u32,
                        >;
                    pub type KeyOwnerProof = runtime_types::sp_core::Void;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ReportEquivocation {
                    const PALLET: &'static str = "Grandpa";
                    const CALL: &'static str = "report_equivocation";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Report voter equivocation/misbehavior. This method will verify the"]
                #[doc = "equivocation proof and validate the given key ownership proof"]
                #[doc = "against the extracted offender. If both are valid, the offence"]
                #[doc = "will be reported."]
                #[doc = ""]
                #[doc = "This extrinsic must be called unsigned and it is expected that only"]
                #[doc = "block authors will call it (validated in `ValidateUnsigned`), as such"]
                #[doc = "if the block author is defined it will be defined as the equivocation"]
                #[doc = "reporter."]
                pub struct ReportEquivocationUnsigned {
                    pub equivocation_proof: ::subxt::ext::subxt_core::alloc::boxed::Box<
                        report_equivocation_unsigned::EquivocationProof,
                    >,
                    pub key_owner_proof: report_equivocation_unsigned::KeyOwnerProof,
                }
                pub mod report_equivocation_unsigned {
                    use super::runtime_types;
                    pub type EquivocationProof =
                        runtime_types::sp_consensus_grandpa::EquivocationProof<
                            ::subxt::ext::subxt_core::utils::H256,
                            ::core::primitive::u32,
                        >;
                    pub type KeyOwnerProof = runtime_types::sp_core::Void;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ReportEquivocationUnsigned {
                    const PALLET: &'static str = "Grandpa";
                    const CALL: &'static str = "report_equivocation_unsigned";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Note that the current authority set of the GRANDPA finality gadget has stalled."]
                #[doc = ""]
                #[doc = "This will trigger a forced authority set change at the beginning of the next session, to"]
                #[doc = "be enacted `delay` blocks after that. The `delay` should be high enough to safely assume"]
                #[doc = "that the block signalling the forced change will not be re-orged e.g. 1000 blocks."]
                #[doc = "The block production rate (which may be slowed down because of finality lagging) should"]
                #[doc = "be taken into account when choosing the `delay`. The GRANDPA voters based on the new"]
                #[doc = "authority will start voting on top of `best_finalized_block_number` for new finalized"]
                #[doc = "blocks. `best_finalized_block_number` should be the highest of the latest finalized"]
                #[doc = "block of all validators of the new authority set."]
                #[doc = ""]
                #[doc = "Only callable by root."]
                pub struct NoteStalled {
                    pub delay: note_stalled::Delay,
                    pub best_finalized_block_number: note_stalled::BestFinalizedBlockNumber,
                }
                pub mod note_stalled {
                    use super::runtime_types;
                    pub type Delay = ::core::primitive::u32;
                    pub type BestFinalizedBlockNumber = ::core::primitive::u32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for NoteStalled {
                    const PALLET: &'static str = "Grandpa";
                    const CALL: &'static str = "note_stalled";
                }
            }
            pub struct TransactionApi;
            impl TransactionApi {
                #[doc = "Report voter equivocation/misbehavior. This method will verify the"]
                #[doc = "equivocation proof and validate the given key ownership proof"]
                #[doc = "against the extracted offender. If both are valid, the offence"]
                #[doc = "will be reported."]
                pub fn report_equivocation(
                    &self,
                    equivocation_proof: types::report_equivocation::EquivocationProof,
                    key_owner_proof: types::report_equivocation::KeyOwnerProof,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::ReportEquivocation>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Grandpa",
                        "report_equivocation",
                        types::ReportEquivocation {
                            equivocation_proof: ::subxt::ext::subxt_core::alloc::boxed::Box::new(
                                equivocation_proof,
                            ),
                            key_owner_proof,
                        },
                        [
                            187u8, 224u8, 115u8, 5u8, 236u8, 32u8, 180u8, 155u8, 218u8, 109u8,
                            238u8, 253u8, 30u8, 225u8, 4u8, 225u8, 132u8, 232u8, 243u8, 54u8, 56u8,
                            158u8, 94u8, 192u8, 94u8, 206u8, 189u8, 61u8, 14u8, 49u8, 48u8, 131u8,
                        ],
                    )
                }
                #[doc = "Report voter equivocation/misbehavior. This method will verify the"]
                #[doc = "equivocation proof and validate the given key ownership proof"]
                #[doc = "against the extracted offender. If both are valid, the offence"]
                #[doc = "will be reported."]
                #[doc = ""]
                #[doc = "This extrinsic must be called unsigned and it is expected that only"]
                #[doc = "block authors will call it (validated in `ValidateUnsigned`), as such"]
                #[doc = "if the block author is defined it will be defined as the equivocation"]
                #[doc = "reporter."]
                pub fn report_equivocation_unsigned(
                    &self,
                    equivocation_proof: types::report_equivocation_unsigned::EquivocationProof,
                    key_owner_proof: types::report_equivocation_unsigned::KeyOwnerProof,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::ReportEquivocationUnsigned,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Grandpa",
                        "report_equivocation_unsigned",
                        types::ReportEquivocationUnsigned {
                            equivocation_proof: ::subxt::ext::subxt_core::alloc::boxed::Box::new(
                                equivocation_proof,
                            ),
                            key_owner_proof,
                        },
                        [
                            98u8, 103u8, 6u8, 54u8, 0u8, 200u8, 166u8, 163u8, 202u8, 45u8, 131u8,
                            226u8, 114u8, 166u8, 237u8, 174u8, 207u8, 214u8, 2u8, 227u8, 32u8,
                            166u8, 47u8, 83u8, 166u8, 239u8, 232u8, 72u8, 224u8, 242u8, 156u8,
                            44u8,
                        ],
                    )
                }
                #[doc = "Note that the current authority set of the GRANDPA finality gadget has stalled."]
                #[doc = ""]
                #[doc = "This will trigger a forced authority set change at the beginning of the next session, to"]
                #[doc = "be enacted `delay` blocks after that. The `delay` should be high enough to safely assume"]
                #[doc = "that the block signalling the forced change will not be re-orged e.g. 1000 blocks."]
                #[doc = "The block production rate (which may be slowed down because of finality lagging) should"]
                #[doc = "be taken into account when choosing the `delay`. The GRANDPA voters based on the new"]
                #[doc = "authority will start voting on top of `best_finalized_block_number` for new finalized"]
                #[doc = "blocks. `best_finalized_block_number` should be the highest of the latest finalized"]
                #[doc = "block of all validators of the new authority set."]
                #[doc = ""]
                #[doc = "Only callable by root."]
                pub fn note_stalled(
                    &self,
                    delay: types::note_stalled::Delay,
                    best_finalized_block_number: types::note_stalled::BestFinalizedBlockNumber,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::NoteStalled>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Grandpa",
                        "note_stalled",
                        types::NoteStalled {
                            delay,
                            best_finalized_block_number,
                        },
                        [
                            158u8, 25u8, 64u8, 114u8, 131u8, 139u8, 227u8, 132u8, 42u8, 107u8,
                            40u8, 249u8, 18u8, 93u8, 254u8, 86u8, 37u8, 67u8, 250u8, 35u8, 241u8,
                            194u8, 209u8, 20u8, 39u8, 75u8, 186u8, 21u8, 48u8, 124u8, 151u8, 31u8,
                        ],
                    )
                }
            }
        }
        #[doc = "The `Event` enum of this pallet"]
        pub type Event = runtime_types::pallet_grandpa::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "New authority set has been applied."]
            pub struct NewAuthorities {
                pub authority_set: new_authorities::AuthoritySet,
            }
            pub mod new_authorities {
                use super::runtime_types;
                pub type AuthoritySet = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                    runtime_types::sp_consensus_grandpa::app::Public,
                    ::core::primitive::u64,
                )>;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NewAuthorities {
                const PALLET: &'static str = "Grandpa";
                const EVENT: &'static str = "NewAuthorities";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Current authority set has been paused."]
            pub struct Paused;
            impl ::subxt::ext::subxt_core::events::StaticEvent for Paused {
                const PALLET: &'static str = "Grandpa";
                const EVENT: &'static str = "Paused";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Current authority set has been resumed."]
            pub struct Resumed;
            impl ::subxt::ext::subxt_core::events::StaticEvent for Resumed {
                const PALLET: &'static str = "Grandpa";
                const EVENT: &'static str = "Resumed";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                pub mod state {
                    use super::runtime_types;
                    pub type State =
                        runtime_types::pallet_grandpa::StoredState<::core::primitive::u32>;
                }
                pub mod pending_change {
                    use super::runtime_types;
                    pub type PendingChange =
                        runtime_types::pallet_grandpa::StoredPendingChange<::core::primitive::u32>;
                }
                pub mod next_forced {
                    use super::runtime_types;
                    pub type NextForced = ::core::primitive::u32;
                }
                pub mod stalled {
                    use super::runtime_types;
                    pub type Stalled = (::core::primitive::u32, ::core::primitive::u32);
                }
                pub mod current_set_id {
                    use super::runtime_types;
                    pub type CurrentSetId = ::core::primitive::u64;
                }
                pub mod set_id_session {
                    use super::runtime_types;
                    pub type SetIdSession = ::core::primitive::u32;
                    pub type Param0 = ::core::primitive::u64;
                }
                pub mod authorities {
                    use super::runtime_types;
                    pub type Authorities =
                        runtime_types::bounded_collections::weak_bounded_vec::WeakBoundedVec<(
                            runtime_types::sp_consensus_grandpa::app::Public,
                            ::core::primitive::u64,
                        )>;
                }
            }
            pub struct StorageApi;
            impl StorageApi {
                #[doc = " State of the current authority set."]
                pub fn state(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::state::State,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Grandpa",
                        "State",
                        (),
                        [
                            73u8, 71u8, 112u8, 83u8, 238u8, 75u8, 44u8, 9u8, 180u8, 33u8, 30u8,
                            121u8, 98u8, 96u8, 61u8, 133u8, 16u8, 70u8, 30u8, 249u8, 34u8, 148u8,
                            15u8, 239u8, 164u8, 157u8, 52u8, 27u8, 144u8, 52u8, 223u8, 109u8,
                        ],
                    )
                }
                #[doc = " Pending change: (signaled at, scheduled change)."]
                pub fn pending_change(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::pending_change::PendingChange,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Grandpa",
                        "PendingChange",
                        (),
                        [
                            32u8, 165u8, 141u8, 100u8, 109u8, 66u8, 58u8, 22u8, 118u8, 84u8, 92u8,
                            164u8, 119u8, 130u8, 104u8, 25u8, 244u8, 111u8, 223u8, 54u8, 184u8,
                            95u8, 196u8, 30u8, 244u8, 129u8, 110u8, 127u8, 200u8, 66u8, 226u8,
                            26u8,
                        ],
                    )
                }
                #[doc = " next block number where we can force a change."]
                pub fn next_forced(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::next_forced::NextForced,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Grandpa",
                        "NextForced",
                        (),
                        [
                            3u8, 231u8, 56u8, 18u8, 87u8, 112u8, 227u8, 126u8, 180u8, 131u8, 255u8,
                            141u8, 82u8, 34u8, 61u8, 47u8, 234u8, 37u8, 95u8, 62u8, 33u8, 235u8,
                            231u8, 122u8, 125u8, 8u8, 223u8, 95u8, 255u8, 204u8, 40u8, 97u8,
                        ],
                    )
                }
                #[doc = " `true` if we are currently stalled."]
                pub fn stalled(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::stalled::Stalled,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Grandpa",
                        "Stalled",
                        (),
                        [
                            6u8, 81u8, 205u8, 142u8, 195u8, 48u8, 0u8, 247u8, 108u8, 170u8, 10u8,
                            249u8, 72u8, 206u8, 32u8, 103u8, 109u8, 57u8, 51u8, 21u8, 144u8, 204u8,
                            79u8, 8u8, 191u8, 185u8, 38u8, 34u8, 118u8, 223u8, 75u8, 241u8,
                        ],
                    )
                }
                #[doc = " The number of changes (both in terms of keys and underlying economic responsibilities)"]
                #[doc = " in the \"set\" of Grandpa validators from genesis."]
                pub fn current_set_id(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::current_set_id::CurrentSetId,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Grandpa",
                        "CurrentSetId",
                        (),
                        [
                            234u8, 215u8, 218u8, 42u8, 30u8, 76u8, 129u8, 40u8, 125u8, 137u8,
                            207u8, 47u8, 46u8, 213u8, 159u8, 50u8, 175u8, 81u8, 155u8, 123u8,
                            246u8, 175u8, 156u8, 68u8, 22u8, 113u8, 135u8, 137u8, 163u8, 18u8,
                            115u8, 73u8,
                        ],
                    )
                }
                #[doc = " A mapping from grandpa set ID to the index of the *most recent* session for which its"]
                #[doc = " members were responsible."]
                #[doc = ""]
                #[doc = " This is only used for validating equivocation proofs. An equivocation proof must"]
                #[doc = " contains a key-ownership proof for a given session, therefore we need a way to tie"]
                #[doc = " together sessions and GRANDPA set ids, i.e. we need to validate that a validator"]
                #[doc = " was the owner of a given key on a given session, and what the active set ID was"]
                #[doc = " during that session."]
                #[doc = ""]
                #[doc = " TWOX-NOTE: `SetId` is not under user control."]
                pub fn set_id_session_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::set_id_session::SetIdSession,
                    (),
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Grandpa",
                        "SetIdSession",
                        (),
                        [
                            47u8, 0u8, 239u8, 121u8, 187u8, 213u8, 254u8, 50u8, 238u8, 10u8, 162u8,
                            65u8, 189u8, 166u8, 37u8, 74u8, 82u8, 81u8, 160u8, 20u8, 180u8, 253u8,
                            238u8, 18u8, 209u8, 203u8, 38u8, 148u8, 16u8, 105u8, 72u8, 169u8,
                        ],
                    )
                }
                #[doc = " A mapping from grandpa set ID to the index of the *most recent* session for which its"]
                #[doc = " members were responsible."]
                #[doc = ""]
                #[doc = " This is only used for validating equivocation proofs. An equivocation proof must"]
                #[doc = " contains a key-ownership proof for a given session, therefore we need a way to tie"]
                #[doc = " together sessions and GRANDPA set ids, i.e. we need to validate that a validator"]
                #[doc = " was the owner of a given key on a given session, and what the active set ID was"]
                #[doc = " during that session."]
                #[doc = ""]
                #[doc = " TWOX-NOTE: `SetId` is not under user control."]
                pub fn set_id_session(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::set_id_session::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::set_id_session::Param0,
                    >,
                    types::set_id_session::SetIdSession,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Grandpa",
                        "SetIdSession",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            47u8, 0u8, 239u8, 121u8, 187u8, 213u8, 254u8, 50u8, 238u8, 10u8, 162u8,
                            65u8, 189u8, 166u8, 37u8, 74u8, 82u8, 81u8, 160u8, 20u8, 180u8, 253u8,
                            238u8, 18u8, 209u8, 203u8, 38u8, 148u8, 16u8, 105u8, 72u8, 169u8,
                        ],
                    )
                }
                #[doc = " The current list of authorities."]
                pub fn authorities(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::authorities::Authorities,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Grandpa",
                        "Authorities",
                        (),
                        [
                            192u8, 157u8, 98u8, 244u8, 104u8, 38u8, 195u8, 114u8, 183u8, 62u8,
                            247u8, 18u8, 31u8, 152u8, 246u8, 206u8, 97u8, 13u8, 118u8, 211u8,
                            104u8, 54u8, 150u8, 152u8, 126u8, 170u8, 228u8, 158u8, 108u8, 129u8,
                            134u8, 44u8,
                        ],
                    )
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                #[doc = " Max Authorities in use"]
                pub fn max_authorities(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u32,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Grandpa",
                        "MaxAuthorities",
                        [
                            98u8, 252u8, 116u8, 72u8, 26u8, 180u8, 225u8, 83u8, 200u8, 157u8,
                            125u8, 151u8, 53u8, 76u8, 168u8, 26u8, 10u8, 9u8, 98u8, 68u8, 9u8,
                            178u8, 197u8, 113u8, 31u8, 79u8, 200u8, 90u8, 203u8, 100u8, 41u8,
                            145u8,
                        ],
                    )
                }
                #[doc = " The maximum number of nominators for each validator."]
                pub fn max_nominators(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u32,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Grandpa",
                        "MaxNominators",
                        [
                            98u8, 252u8, 116u8, 72u8, 26u8, 180u8, 225u8, 83u8, 200u8, 157u8,
                            125u8, 151u8, 53u8, 76u8, 168u8, 26u8, 10u8, 9u8, 98u8, 68u8, 9u8,
                            178u8, 197u8, 113u8, 31u8, 79u8, 200u8, 90u8, 203u8, 100u8, 41u8,
                            145u8,
                        ],
                    )
                }
                #[doc = " The maximum number of entries to keep in the set id to session index mapping."]
                #[doc = ""]
                #[doc = " Since the `SetIdSession` map is only used for validating equivocations this"]
                #[doc = " value should relate to the bonding duration of whatever staking system is"]
                #[doc = " being used (if any). If equivocation handling is not enabled then this value"]
                #[doc = " can be zero."]
                pub fn max_set_id_session_entries(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u64,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Grandpa",
                        "MaxSetIdSessionEntries",
                        [
                            128u8, 214u8, 205u8, 242u8, 181u8, 142u8, 124u8, 231u8, 190u8, 146u8,
                            59u8, 226u8, 157u8, 101u8, 103u8, 117u8, 249u8, 65u8, 18u8, 191u8,
                            103u8, 119u8, 53u8, 85u8, 81u8, 96u8, 220u8, 42u8, 184u8, 239u8, 42u8,
                            246u8,
                        ],
                    )
                }
            }
        }
    }
    pub mod balances {
        use super::root_mod;
        use super::runtime_types;
        #[doc = "The `Error` enum of this pallet."]
        pub type Error = runtime_types::pallet_balances::pallet::Error;
        #[doc = "Contains a variant per dispatchable extrinsic that this pallet has."]
        pub type Call = runtime_types::pallet_balances::pallet::Call;
        pub mod calls {
            use super::root_mod;
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Transfer some liquid free balance to another account."]
                #[doc = ""]
                #[doc = "`transfer_allow_death` will set the `FreeBalance` of the sender and receiver."]
                #[doc = "If the sender's account is below the existential deposit as a result"]
                #[doc = "of the transfer, the account will be reaped."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call must be `Signed` by the transactor."]
                pub struct TransferAllowDeath {
                    pub dest: transfer_allow_death::Dest,
                    #[codec(compact)]
                    pub value: transfer_allow_death::Value,
                }
                pub mod transfer_allow_death {
                    use super::runtime_types;
                    pub type Dest = ::subxt::ext::subxt_core::utils::MultiAddress<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        (),
                    >;
                    pub type Value = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for TransferAllowDeath {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "transfer_allow_death";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Exactly as `transfer_allow_death`, except the origin must be root and the source account"]
                #[doc = "may be specified."]
                pub struct ForceTransfer {
                    pub source: force_transfer::Source,
                    pub dest: force_transfer::Dest,
                    #[codec(compact)]
                    pub value: force_transfer::Value,
                }
                pub mod force_transfer {
                    use super::runtime_types;
                    pub type Source = ::subxt::ext::subxt_core::utils::MultiAddress<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        (),
                    >;
                    pub type Dest = ::subxt::ext::subxt_core::utils::MultiAddress<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        (),
                    >;
                    pub type Value = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ForceTransfer {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "force_transfer";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Same as the [`transfer_allow_death`] call, but with a check that the transfer will not"]
                #[doc = "kill the origin account."]
                #[doc = ""]
                #[doc = "99% of the time you want [`transfer_allow_death`] instead."]
                #[doc = ""]
                #[doc = "[`transfer_allow_death`]: struct.Pallet.html#method.transfer"]
                pub struct TransferKeepAlive {
                    pub dest: transfer_keep_alive::Dest,
                    #[codec(compact)]
                    pub value: transfer_keep_alive::Value,
                }
                pub mod transfer_keep_alive {
                    use super::runtime_types;
                    pub type Dest = ::subxt::ext::subxt_core::utils::MultiAddress<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        (),
                    >;
                    pub type Value = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for TransferKeepAlive {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "transfer_keep_alive";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Transfer the entire transferable balance from the caller account."]
                #[doc = ""]
                #[doc = "NOTE: This function only attempts to transfer _transferable_ balances. This means that"]
                #[doc = "any locked, reserved, or existential deposits (when `keep_alive` is `true`), will not be"]
                #[doc = "transferred by this function. To ensure that this function results in a killed account,"]
                #[doc = "you might need to prepare the account by removing any reference counters, storage"]
                #[doc = "deposits, etc..."]
                #[doc = ""]
                #[doc = "The dispatch origin of this call must be Signed."]
                #[doc = ""]
                #[doc = "- `dest`: The recipient of the transfer."]
                #[doc = "- `keep_alive`: A boolean to determine if the `transfer_all` operation should send all"]
                #[doc = "  of the funds the account has, causing the sender account to be killed (false), or"]
                #[doc = "  transfer everything except at least the existential deposit, which will guarantee to"]
                #[doc = "  keep the sender account alive (true)."]
                pub struct TransferAll {
                    pub dest: transfer_all::Dest,
                    pub keep_alive: transfer_all::KeepAlive,
                }
                pub mod transfer_all {
                    use super::runtime_types;
                    pub type Dest = ::subxt::ext::subxt_core::utils::MultiAddress<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        (),
                    >;
                    pub type KeepAlive = ::core::primitive::bool;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for TransferAll {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "transfer_all";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Unreserve some balance from a user by force."]
                #[doc = ""]
                #[doc = "Can only be called by ROOT."]
                pub struct ForceUnreserve {
                    pub who: force_unreserve::Who,
                    pub amount: force_unreserve::Amount,
                }
                pub mod force_unreserve {
                    use super::runtime_types;
                    pub type Who = ::subxt::ext::subxt_core::utils::MultiAddress<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        (),
                    >;
                    pub type Amount = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ForceUnreserve {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "force_unreserve";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Upgrade a specified account."]
                #[doc = ""]
                #[doc = "- `origin`: Must be `Signed`."]
                #[doc = "- `who`: The account to be upgraded."]
                #[doc = ""]
                #[doc = "This will waive the transaction fee if at least all but 10% of the accounts needed to"]
                #[doc = "be upgraded. (We let some not have to be upgraded just in order to allow for the"]
                #[doc = "possibility of churn)."]
                pub struct UpgradeAccounts {
                    pub who: upgrade_accounts::Who,
                }
                pub mod upgrade_accounts {
                    use super::runtime_types;
                    pub type Who = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                    >;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for UpgradeAccounts {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "upgrade_accounts";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Set the regular balance of a given account."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call is `root`."]
                pub struct ForceSetBalance {
                    pub who: force_set_balance::Who,
                    #[codec(compact)]
                    pub new_free: force_set_balance::NewFree,
                }
                pub mod force_set_balance {
                    use super::runtime_types;
                    pub type Who = ::subxt::ext::subxt_core::utils::MultiAddress<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        (),
                    >;
                    pub type NewFree = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ForceSetBalance {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "force_set_balance";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Adjust the total issuance in a saturating way."]
                #[doc = ""]
                #[doc = "Can only be called by root and always needs a positive `delta`."]
                #[doc = ""]
                #[doc = "# Example"]
                pub struct ForceAdjustTotalIssuance {
                    pub direction: force_adjust_total_issuance::Direction,
                    #[codec(compact)]
                    pub delta: force_adjust_total_issuance::Delta,
                }
                pub mod force_adjust_total_issuance {
                    use super::runtime_types;
                    pub type Direction = runtime_types::pallet_balances::types::AdjustmentDirection;
                    pub type Delta = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ForceAdjustTotalIssuance {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "force_adjust_total_issuance";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Burn the specified liquid free balance from the origin account."]
                #[doc = ""]
                #[doc = "If the origin's account ends up below the existential deposit as a result"]
                #[doc = "of the burn and `keep_alive` is false, the account will be reaped."]
                #[doc = ""]
                #[doc = "Unlike sending funds to a _burn_ address, which merely makes the funds inaccessible,"]
                #[doc = "this `burn` operation will reduce total issuance by the amount _burned_."]
                pub struct Burn {
                    #[codec(compact)]
                    pub value: burn::Value,
                    pub keep_alive: burn::KeepAlive,
                }
                pub mod burn {
                    use super::runtime_types;
                    pub type Value = ::core::primitive::u64;
                    pub type KeepAlive = ::core::primitive::bool;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for Burn {
                    const PALLET: &'static str = "Balances";
                    const CALL: &'static str = "burn";
                }
            }
            pub struct TransactionApi;
            impl TransactionApi {
                #[doc = "Transfer some liquid free balance to another account."]
                #[doc = ""]
                #[doc = "`transfer_allow_death` will set the `FreeBalance` of the sender and receiver."]
                #[doc = "If the sender's account is below the existential deposit as a result"]
                #[doc = "of the transfer, the account will be reaped."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call must be `Signed` by the transactor."]
                pub fn transfer_allow_death(
                    &self,
                    dest: types::transfer_allow_death::Dest,
                    value: types::transfer_allow_death::Value,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::TransferAllowDeath>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "transfer_allow_death",
                        types::TransferAllowDeath { dest, value },
                        [
                            55u8, 189u8, 102u8, 71u8, 231u8, 179u8, 169u8, 229u8, 206u8, 42u8,
                            10u8, 117u8, 36u8, 34u8, 30u8, 145u8, 227u8, 105u8, 252u8, 188u8,
                            162u8, 0u8, 84u8, 24u8, 123u8, 241u8, 152u8, 118u8, 181u8, 182u8,
                            137u8, 241u8,
                        ],
                    )
                }
                #[doc = "Exactly as `transfer_allow_death`, except the origin must be root and the source account"]
                #[doc = "may be specified."]
                pub fn force_transfer(
                    &self,
                    source: types::force_transfer::Source,
                    dest: types::force_transfer::Dest,
                    value: types::force_transfer::Value,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::ForceTransfer>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "force_transfer",
                        types::ForceTransfer {
                            source,
                            dest,
                            value,
                        },
                        [
                            15u8, 9u8, 232u8, 170u8, 117u8, 161u8, 184u8, 255u8, 3u8, 155u8, 165u8,
                            226u8, 151u8, 189u8, 226u8, 21u8, 14u8, 70u8, 17u8, 43u8, 181u8, 59u8,
                            158u8, 222u8, 167u8, 59u8, 61u8, 233u8, 78u8, 108u8, 161u8, 192u8,
                        ],
                    )
                }
                #[doc = "Same as the [`transfer_allow_death`] call, but with a check that the transfer will not"]
                #[doc = "kill the origin account."]
                #[doc = ""]
                #[doc = "99% of the time you want [`transfer_allow_death`] instead."]
                #[doc = ""]
                #[doc = "[`transfer_allow_death`]: struct.Pallet.html#method.transfer"]
                pub fn transfer_keep_alive(
                    &self,
                    dest: types::transfer_keep_alive::Dest,
                    value: types::transfer_keep_alive::Value,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::TransferKeepAlive>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "transfer_keep_alive",
                        types::TransferKeepAlive { dest, value },
                        [
                            126u8, 208u8, 16u8, 244u8, 94u8, 74u8, 166u8, 13u8, 149u8, 95u8, 88u8,
                            250u8, 95u8, 0u8, 43u8, 57u8, 18u8, 129u8, 24u8, 210u8, 91u8, 50u8,
                            251u8, 73u8, 126u8, 218u8, 244u8, 52u8, 36u8, 175u8, 28u8, 210u8,
                        ],
                    )
                }
                #[doc = "Transfer the entire transferable balance from the caller account."]
                #[doc = ""]
                #[doc = "NOTE: This function only attempts to transfer _transferable_ balances. This means that"]
                #[doc = "any locked, reserved, or existential deposits (when `keep_alive` is `true`), will not be"]
                #[doc = "transferred by this function. To ensure that this function results in a killed account,"]
                #[doc = "you might need to prepare the account by removing any reference counters, storage"]
                #[doc = "deposits, etc..."]
                #[doc = ""]
                #[doc = "The dispatch origin of this call must be Signed."]
                #[doc = ""]
                #[doc = "- `dest`: The recipient of the transfer."]
                #[doc = "- `keep_alive`: A boolean to determine if the `transfer_all` operation should send all"]
                #[doc = "  of the funds the account has, causing the sender account to be killed (false), or"]
                #[doc = "  transfer everything except at least the existential deposit, which will guarantee to"]
                #[doc = "  keep the sender account alive (true)."]
                pub fn transfer_all(
                    &self,
                    dest: types::transfer_all::Dest,
                    keep_alive: types::transfer_all::KeepAlive,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::TransferAll>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "transfer_all",
                        types::TransferAll { dest, keep_alive },
                        [
                            105u8, 132u8, 49u8, 144u8, 195u8, 250u8, 34u8, 46u8, 213u8, 248u8,
                            112u8, 188u8, 81u8, 228u8, 136u8, 18u8, 67u8, 172u8, 37u8, 38u8, 238u8,
                            9u8, 34u8, 15u8, 67u8, 34u8, 148u8, 195u8, 223u8, 29u8, 154u8, 6u8,
                        ],
                    )
                }
                #[doc = "Unreserve some balance from a user by force."]
                #[doc = ""]
                #[doc = "Can only be called by ROOT."]
                pub fn force_unreserve(
                    &self,
                    who: types::force_unreserve::Who,
                    amount: types::force_unreserve::Amount,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::ForceUnreserve>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "force_unreserve",
                        types::ForceUnreserve { who, amount },
                        [
                            194u8, 160u8, 176u8, 186u8, 10u8, 132u8, 201u8, 232u8, 127u8, 9u8,
                            234u8, 37u8, 167u8, 77u8, 157u8, 228u8, 62u8, 207u8, 172u8, 240u8, 1u8,
                            10u8, 136u8, 97u8, 115u8, 13u8, 2u8, 61u8, 200u8, 235u8, 39u8, 97u8,
                        ],
                    )
                }
                #[doc = "Upgrade a specified account."]
                #[doc = ""]
                #[doc = "- `origin`: Must be `Signed`."]
                #[doc = "- `who`: The account to be upgraded."]
                #[doc = ""]
                #[doc = "This will waive the transaction fee if at least all but 10% of the accounts needed to"]
                #[doc = "be upgraded. (We let some not have to be upgraded just in order to allow for the"]
                #[doc = "possibility of churn)."]
                pub fn upgrade_accounts(
                    &self,
                    who: types::upgrade_accounts::Who,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::UpgradeAccounts>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "upgrade_accounts",
                        types::UpgradeAccounts { who },
                        [
                            66u8, 200u8, 179u8, 104u8, 65u8, 2u8, 101u8, 56u8, 130u8, 161u8, 224u8,
                            233u8, 255u8, 124u8, 70u8, 122u8, 8u8, 49u8, 103u8, 178u8, 68u8, 47u8,
                            214u8, 166u8, 217u8, 116u8, 178u8, 50u8, 212u8, 164u8, 98u8, 226u8,
                        ],
                    )
                }
                #[doc = "Set the regular balance of a given account."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call is `root`."]
                pub fn force_set_balance(
                    &self,
                    who: types::force_set_balance::Who,
                    new_free: types::force_set_balance::NewFree,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::ForceSetBalance>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "force_set_balance",
                        types::ForceSetBalance { who, new_free },
                        [
                            172u8, 128u8, 27u8, 158u8, 43u8, 74u8, 29u8, 195u8, 16u8, 214u8, 1u8,
                            128u8, 138u8, 144u8, 6u8, 236u8, 61u8, 41u8, 155u8, 208u8, 57u8, 42u8,
                            237u8, 229u8, 130u8, 214u8, 8u8, 93u8, 57u8, 219u8, 178u8, 197u8,
                        ],
                    )
                }
                #[doc = "Adjust the total issuance in a saturating way."]
                #[doc = ""]
                #[doc = "Can only be called by root and always needs a positive `delta`."]
                #[doc = ""]
                #[doc = "# Example"]
                pub fn force_adjust_total_issuance(
                    &self,
                    direction: types::force_adjust_total_issuance::Direction,
                    delta: types::force_adjust_total_issuance::Delta,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::ForceAdjustTotalIssuance,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "force_adjust_total_issuance",
                        types::ForceAdjustTotalIssuance { direction, delta },
                        [
                            70u8, 239u8, 219u8, 254u8, 5u8, 227u8, 119u8, 182u8, 85u8, 96u8, 88u8,
                            71u8, 89u8, 73u8, 199u8, 50u8, 89u8, 157u8, 30u8, 121u8, 34u8, 184u8,
                            9u8, 118u8, 51u8, 182u8, 121u8, 109u8, 22u8, 155u8, 83u8, 198u8,
                        ],
                    )
                }
                #[doc = "Burn the specified liquid free balance from the origin account."]
                #[doc = ""]
                #[doc = "If the origin's account ends up below the existential deposit as a result"]
                #[doc = "of the burn and `keep_alive` is false, the account will be reaped."]
                #[doc = ""]
                #[doc = "Unlike sending funds to a _burn_ address, which merely makes the funds inaccessible,"]
                #[doc = "this `burn` operation will reduce total issuance by the amount _burned_."]
                pub fn burn(
                    &self,
                    value: types::burn::Value,
                    keep_alive: types::burn::KeepAlive,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::Burn>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "Balances",
                        "burn",
                        types::Burn { value, keep_alive },
                        [
                            47u8, 248u8, 43u8, 36u8, 119u8, 205u8, 108u8, 21u8, 199u8, 180u8,
                            233u8, 162u8, 61u8, 240u8, 233u8, 246u8, 119u8, 19u8, 172u8, 171u8,
                            38u8, 155u8, 189u8, 243u8, 40u8, 235u8, 23u8, 221u8, 158u8, 47u8,
                            183u8, 10u8,
                        ],
                    )
                }
            }
        }
        #[doc = "The `Event` enum of this pallet"]
        pub type Event = runtime_types::pallet_balances::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "An account was created with some free balance."]
            pub struct Endowed {
                pub account: endowed::Account,
                pub free_balance: endowed::FreeBalance,
            }
            pub mod endowed {
                use super::runtime_types;
                pub type Account = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type FreeBalance = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Endowed {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Endowed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "An account was removed whose balance was non-zero but below ExistentialDeposit,"]
            #[doc = "resulting in an outright loss."]
            pub struct DustLost {
                pub account: dust_lost::Account,
                pub amount: dust_lost::Amount,
            }
            pub mod dust_lost {
                use super::runtime_types;
                pub type Account = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for DustLost {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "DustLost";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Transfer succeeded."]
            pub struct Transfer {
                pub from: transfer::From,
                pub to: transfer::To,
                pub amount: transfer::Amount,
            }
            pub mod transfer {
                use super::runtime_types;
                pub type From = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type To = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Transfer {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Transfer";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A balance was set by root."]
            pub struct BalanceSet {
                pub who: balance_set::Who,
                pub free: balance_set::Free,
            }
            pub mod balance_set {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Free = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BalanceSet {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "BalanceSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some balance was reserved (moved from free to reserved)."]
            pub struct Reserved {
                pub who: reserved::Who,
                pub amount: reserved::Amount,
            }
            pub mod reserved {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Reserved {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Reserved";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some balance was unreserved (moved from reserved to free)."]
            pub struct Unreserved {
                pub who: unreserved::Who,
                pub amount: unreserved::Amount,
            }
            pub mod unreserved {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Unreserved {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Unreserved";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some balance was moved from the reserve of the first account to the second account."]
            #[doc = "Final argument indicates the destination balance type."]
            pub struct ReserveRepatriated {
                pub from: reserve_repatriated::From,
                pub to: reserve_repatriated::To,
                pub amount: reserve_repatriated::Amount,
                pub destination_status: reserve_repatriated::DestinationStatus,
            }
            pub mod reserve_repatriated {
                use super::runtime_types;
                pub type From = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type To = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
                pub type DestinationStatus =
                    runtime_types::frame_support::traits::tokens::misc::BalanceStatus;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ReserveRepatriated {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "ReserveRepatriated";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some amount was deposited (e.g. for transaction fees)."]
            pub struct Deposit {
                pub who: deposit::Who,
                pub amount: deposit::Amount,
            }
            pub mod deposit {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Deposit {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Deposit";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some amount was withdrawn from the account (e.g. for transaction fees)."]
            pub struct Withdraw {
                pub who: withdraw::Who,
                pub amount: withdraw::Amount,
            }
            pub mod withdraw {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Withdraw {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Withdraw";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some amount was removed from the account (e.g. for misbehavior)."]
            pub struct Slashed {
                pub who: slashed::Who,
                pub amount: slashed::Amount,
            }
            pub mod slashed {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Slashed {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Slashed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some amount was minted into an account."]
            pub struct Minted {
                pub who: minted::Who,
                pub amount: minted::Amount,
            }
            pub mod minted {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Minted {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Minted";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some amount was burned from an account."]
            pub struct Burned {
                pub who: burned::Who,
                pub amount: burned::Amount,
            }
            pub mod burned {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Burned {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Burned";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some amount was suspended from an account (it can be restored later)."]
            pub struct Suspended {
                pub who: suspended::Who,
                pub amount: suspended::Amount,
            }
            pub mod suspended {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Suspended {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Suspended";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some amount was restored into an account."]
            pub struct Restored {
                pub who: restored::Who,
                pub amount: restored::Amount,
            }
            pub mod restored {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Restored {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Restored";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "An account was upgraded."]
            pub struct Upgraded {
                pub who: upgraded::Who,
            }
            pub mod upgraded {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Upgraded {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Upgraded";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Total issuance was increased by `amount`, creating a credit to be balanced."]
            pub struct Issued {
                pub amount: issued::Amount,
            }
            pub mod issued {
                use super::runtime_types;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Issued {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Issued";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Total issuance was decreased by `amount`, creating a debt to be balanced."]
            pub struct Rescinded {
                pub amount: rescinded::Amount,
            }
            pub mod rescinded {
                use super::runtime_types;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Rescinded {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Rescinded";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some balance was locked."]
            pub struct Locked {
                pub who: locked::Who,
                pub amount: locked::Amount,
            }
            pub mod locked {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Locked {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Locked";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some balance was unlocked."]
            pub struct Unlocked {
                pub who: unlocked::Who,
                pub amount: unlocked::Amount,
            }
            pub mod unlocked {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Unlocked {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Unlocked";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some balance was frozen."]
            pub struct Frozen {
                pub who: frozen::Who,
                pub amount: frozen::Amount,
            }
            pub mod frozen {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Frozen {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Frozen";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Some balance was thawed."]
            pub struct Thawed {
                pub who: thawed::Who,
                pub amount: thawed::Amount,
            }
            pub mod thawed {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Amount = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Thawed {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Thawed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The `TotalIssuance` was forcefully changed."]
            pub struct TotalIssuanceForced {
                pub old: total_issuance_forced::Old,
                pub new: total_issuance_forced::New,
            }
            pub mod total_issuance_forced {
                use super::runtime_types;
                pub type Old = ::core::primitive::u64;
                pub type New = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TotalIssuanceForced {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "TotalIssuanceForced";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                pub mod total_issuance {
                    use super::runtime_types;
                    pub type TotalIssuance = ::core::primitive::u64;
                }
                pub mod inactive_issuance {
                    use super::runtime_types;
                    pub type InactiveIssuance = ::core::primitive::u64;
                }
                pub mod account {
                    use super::runtime_types;
                    pub type Account =
                        runtime_types::pallet_balances::types::AccountData<::core::primitive::u64>;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod locks {
                    use super::runtime_types;
                    pub type Locks =
                        runtime_types::bounded_collections::weak_bounded_vec::WeakBoundedVec<
                            runtime_types::pallet_balances::types::BalanceLock<
                                ::core::primitive::u64,
                            >,
                        >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod reserves {
                    use super::runtime_types;
                    pub type Reserves = runtime_types::bounded_collections::bounded_vec::BoundedVec<
                        runtime_types::pallet_balances::types::ReserveData<
                            [::core::primitive::u8; 8usize],
                            ::core::primitive::u64,
                        >,
                    >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod holds {
                    use super::runtime_types;
                    pub type Holds = runtime_types::bounded_collections::bounded_vec::BoundedVec<
                        runtime_types::frame_support::traits::tokens::misc::IdAmount<
                            runtime_types::node_subtensor_runtime::RuntimeHoldReason,
                            ::core::primitive::u64,
                        >,
                    >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod freezes {
                    use super::runtime_types;
                    pub type Freezes = runtime_types::bounded_collections::bounded_vec::BoundedVec<
                        runtime_types::frame_support::traits::tokens::misc::IdAmount<
                            runtime_types::node_subtensor_runtime::RuntimeFreezeReason,
                            ::core::primitive::u64,
                        >,
                    >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
            }
            pub struct StorageApi;
            impl StorageApi {
                #[doc = " The total units issued in the system."]
                pub fn total_issuance(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::total_issuance::TotalIssuance,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "TotalIssuance",
                        (),
                        [
                            157u8, 166u8, 49u8, 95u8, 245u8, 38u8, 96u8, 83u8, 23u8, 203u8, 246u8,
                            208u8, 251u8, 175u8, 40u8, 92u8, 163u8, 112u8, 43u8, 190u8, 14u8,
                            128u8, 45u8, 22u8, 157u8, 205u8, 181u8, 84u8, 79u8, 132u8, 160u8,
                            149u8,
                        ],
                    )
                }
                #[doc = " The total units of outstanding deactivated balance in the system."]
                pub fn inactive_issuance(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::inactive_issuance::InactiveIssuance,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "InactiveIssuance",
                        (),
                        [
                            33u8, 251u8, 197u8, 148u8, 61u8, 202u8, 85u8, 164u8, 169u8, 36u8,
                            163u8, 147u8, 243u8, 250u8, 178u8, 40u8, 199u8, 147u8, 196u8, 206u8,
                            163u8, 246u8, 154u8, 51u8, 208u8, 250u8, 127u8, 89u8, 118u8, 21u8,
                            225u8, 248u8,
                        ],
                    )
                }
                #[doc = " The Balances pallet example of storing the balance of an account."]
                #[doc = ""]
                #[doc = " # Example"]
                #[doc = ""]
                #[doc = " ```nocompile"]
                #[doc = "  impl pallet_balances::Config for Runtime {"]
                #[doc = "    type AccountStore = StorageMapShim<Self::Account<Runtime>, frame_system::Provider<Runtime>, AccountId, Self::AccountData<Balance>>"]
                #[doc = "  }"]
                #[doc = " ```"]
                #[doc = ""]
                #[doc = " You can also store the balance of an account in the `System` pallet."]
                #[doc = ""]
                #[doc = " # Example"]
                #[doc = ""]
                #[doc = " ```nocompile"]
                #[doc = "  impl pallet_balances::Config for Runtime {"]
                #[doc = "   type AccountStore = System"]
                #[doc = "  }"]
                #[doc = " ```"]
                #[doc = ""]
                #[doc = " But this comes with tradeoffs, storing account balances in the system pallet stores"]
                #[doc = " `frame_system` data alongside the account data contrary to storing account balances in the"]
                #[doc = " `Balances` pallet, which uses a `StorageMap` to store balances data only."]
                #[doc = " NOTE: This is only used in the case that this pallet is used to store balances."]
                pub fn account_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::account::Account,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Account",
                        (),
                        [
                            0u8, 34u8, 91u8, 238u8, 87u8, 151u8, 107u8, 4u8, 104u8, 111u8, 47u8,
                            9u8, 10u8, 169u8, 173u8, 69u8, 182u8, 183u8, 227u8, 37u8, 148u8, 135u8,
                            184u8, 83u8, 67u8, 66u8, 238u8, 130u8, 90u8, 28u8, 248u8, 68u8,
                        ],
                    )
                }
                #[doc = " The Balances pallet example of storing the balance of an account."]
                #[doc = ""]
                #[doc = " # Example"]
                #[doc = ""]
                #[doc = " ```nocompile"]
                #[doc = "  impl pallet_balances::Config for Runtime {"]
                #[doc = "    type AccountStore = StorageMapShim<Self::Account<Runtime>, frame_system::Provider<Runtime>, AccountId, Self::AccountData<Balance>>"]
                #[doc = "  }"]
                #[doc = " ```"]
                #[doc = ""]
                #[doc = " You can also store the balance of an account in the `System` pallet."]
                #[doc = ""]
                #[doc = " # Example"]
                #[doc = ""]
                #[doc = " ```nocompile"]
                #[doc = "  impl pallet_balances::Config for Runtime {"]
                #[doc = "   type AccountStore = System"]
                #[doc = "  }"]
                #[doc = " ```"]
                #[doc = ""]
                #[doc = " But this comes with tradeoffs, storing account balances in the system pallet stores"]
                #[doc = " `frame_system` data alongside the account data contrary to storing account balances in the"]
                #[doc = " `Balances` pallet, which uses a `StorageMap` to store balances data only."]
                #[doc = " NOTE: This is only used in the case that this pallet is used to store balances."]
                pub fn account(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::account::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::account::Param0,
                    >,
                    types::account::Account,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Account",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            0u8, 34u8, 91u8, 238u8, 87u8, 151u8, 107u8, 4u8, 104u8, 111u8, 47u8,
                            9u8, 10u8, 169u8, 173u8, 69u8, 182u8, 183u8, 227u8, 37u8, 148u8, 135u8,
                            184u8, 83u8, 67u8, 66u8, 238u8, 130u8, 90u8, 28u8, 248u8, 68u8,
                        ],
                    )
                }
                #[doc = " Any liquidity locks on some account balances."]
                #[doc = " NOTE: Should only be accessed when setting, changing and freeing a lock."]
                #[doc = ""]
                #[doc = " Use of locks is deprecated in favour of freezes. See `https://github.com/paritytech/substrate/pull/12951/`"]
                pub fn locks_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::locks::Locks,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Locks",
                        (),
                        [
                            184u8, 159u8, 77u8, 3u8, 45u8, 154u8, 149u8, 191u8, 33u8, 212u8, 190u8,
                            76u8, 222u8, 65u8, 62u8, 163u8, 44u8, 141u8, 151u8, 114u8, 109u8, 98u8,
                            70u8, 103u8, 41u8, 93u8, 14u8, 171u8, 115u8, 127u8, 71u8, 114u8,
                        ],
                    )
                }
                #[doc = " Any liquidity locks on some account balances."]
                #[doc = " NOTE: Should only be accessed when setting, changing and freeing a lock."]
                #[doc = ""]
                #[doc = " Use of locks is deprecated in favour of freezes. See `https://github.com/paritytech/substrate/pull/12951/`"]
                pub fn locks(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::locks::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::locks::Param0,
                    >,
                    types::locks::Locks,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Locks",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            184u8, 159u8, 77u8, 3u8, 45u8, 154u8, 149u8, 191u8, 33u8, 212u8, 190u8,
                            76u8, 222u8, 65u8, 62u8, 163u8, 44u8, 141u8, 151u8, 114u8, 109u8, 98u8,
                            70u8, 103u8, 41u8, 93u8, 14u8, 171u8, 115u8, 127u8, 71u8, 114u8,
                        ],
                    )
                }
                #[doc = " Named reserves on some account balances."]
                #[doc = ""]
                #[doc = " Use of reserves is deprecated in favour of holds. See `https://github.com/paritytech/substrate/pull/12951/`"]
                pub fn reserves_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::reserves::Reserves,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Reserves",
                        (),
                        [
                            229u8, 249u8, 203u8, 167u8, 55u8, 45u8, 194u8, 217u8, 66u8, 155u8,
                            16u8, 204u8, 106u8, 207u8, 49u8, 127u8, 193u8, 192u8, 147u8, 242u8,
                            31u8, 220u8, 137u8, 8u8, 247u8, 96u8, 175u8, 28u8, 246u8, 50u8, 254u8,
                            222u8,
                        ],
                    )
                }
                #[doc = " Named reserves on some account balances."]
                #[doc = ""]
                #[doc = " Use of reserves is deprecated in favour of holds. See `https://github.com/paritytech/substrate/pull/12951/`"]
                pub fn reserves(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::reserves::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::reserves::Param0,
                    >,
                    types::reserves::Reserves,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Reserves",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            229u8, 249u8, 203u8, 167u8, 55u8, 45u8, 194u8, 217u8, 66u8, 155u8,
                            16u8, 204u8, 106u8, 207u8, 49u8, 127u8, 193u8, 192u8, 147u8, 242u8,
                            31u8, 220u8, 137u8, 8u8, 247u8, 96u8, 175u8, 28u8, 246u8, 50u8, 254u8,
                            222u8,
                        ],
                    )
                }
                #[doc = " Holds on account balances."]
                pub fn holds_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::holds::Holds,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Holds",
                        (),
                        [
                            45u8, 20u8, 255u8, 248u8, 91u8, 92u8, 19u8, 120u8, 216u8, 121u8, 46u8,
                            13u8, 188u8, 79u8, 124u8, 254u8, 252u8, 41u8, 107u8, 21u8, 215u8,
                            242u8, 220u8, 136u8, 14u8, 200u8, 102u8, 147u8, 141u8, 50u8, 162u8,
                            201u8,
                        ],
                    )
                }
                #[doc = " Holds on account balances."]
                pub fn holds(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::holds::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::holds::Param0,
                    >,
                    types::holds::Holds,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Holds",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            45u8, 20u8, 255u8, 248u8, 91u8, 92u8, 19u8, 120u8, 216u8, 121u8, 46u8,
                            13u8, 188u8, 79u8, 124u8, 254u8, 252u8, 41u8, 107u8, 21u8, 215u8,
                            242u8, 220u8, 136u8, 14u8, 200u8, 102u8, 147u8, 141u8, 50u8, 162u8,
                            201u8,
                        ],
                    )
                }
                #[doc = " Freeze locks on account balances."]
                pub fn freezes_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::freezes::Freezes,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Freezes",
                        (),
                        [
                            53u8, 28u8, 230u8, 230u8, 26u8, 176u8, 210u8, 21u8, 149u8, 240u8,
                            217u8, 196u8, 134u8, 217u8, 43u8, 98u8, 245u8, 54u8, 222u8, 227u8,
                            140u8, 204u8, 119u8, 99u8, 198u8, 252u8, 76u8, 83u8, 140u8, 122u8,
                            55u8, 236u8,
                        ],
                    )
                }
                #[doc = " Freeze locks on account balances."]
                pub fn freezes(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::freezes::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::freezes::Param0,
                    >,
                    types::freezes::Freezes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "Balances",
                        "Freezes",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            53u8, 28u8, 230u8, 230u8, 26u8, 176u8, 210u8, 21u8, 149u8, 240u8,
                            217u8, 196u8, 134u8, 217u8, 43u8, 98u8, 245u8, 54u8, 222u8, 227u8,
                            140u8, 204u8, 119u8, 99u8, 198u8, 252u8, 76u8, 83u8, 140u8, 122u8,
                            55u8, 236u8,
                        ],
                    )
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                #[doc = " The minimum amount required to keep an account open. MUST BE GREATER THAN ZERO!"]
                #[doc = ""]
                #[doc = " If you *really* need it to be zero, you can enable the feature `insecure_zero_ed` for"]
                #[doc = " this pallet. However, you do so at your own risk: this will open up a major DoS vector."]
                #[doc = " In case you have multiple sources of provider references, you may also get unexpected"]
                #[doc = " behaviour if you set this to zero."]
                #[doc = ""]
                #[doc = " Bottom line: Do yourself a favour and make it at least one!"]
                pub fn existential_deposit(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u64,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Balances",
                        "ExistentialDeposit",
                        [
                            128u8, 214u8, 205u8, 242u8, 181u8, 142u8, 124u8, 231u8, 190u8, 146u8,
                            59u8, 226u8, 157u8, 101u8, 103u8, 117u8, 249u8, 65u8, 18u8, 191u8,
                            103u8, 119u8, 53u8, 85u8, 81u8, 96u8, 220u8, 42u8, 184u8, 239u8, 42u8,
                            246u8,
                        ],
                    )
                }
                #[doc = " The maximum number of locks that should exist on an account."]
                #[doc = " Not strictly enforced, but used for weight estimation."]
                #[doc = ""]
                #[doc = " Use of locks is deprecated in favour of freezes. See `https://github.com/paritytech/substrate/pull/12951/`"]
                pub fn max_locks(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u32,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Balances",
                        "MaxLocks",
                        [
                            98u8, 252u8, 116u8, 72u8, 26u8, 180u8, 225u8, 83u8, 200u8, 157u8,
                            125u8, 151u8, 53u8, 76u8, 168u8, 26u8, 10u8, 9u8, 98u8, 68u8, 9u8,
                            178u8, 197u8, 113u8, 31u8, 79u8, 200u8, 90u8, 203u8, 100u8, 41u8,
                            145u8,
                        ],
                    )
                }
                #[doc = " The maximum number of named reserves that can exist on an account."]
                #[doc = ""]
                #[doc = " Use of reserves is deprecated in favour of holds. See `https://github.com/paritytech/substrate/pull/12951/`"]
                pub fn max_reserves(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u32,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Balances",
                        "MaxReserves",
                        [
                            98u8, 252u8, 116u8, 72u8, 26u8, 180u8, 225u8, 83u8, 200u8, 157u8,
                            125u8, 151u8, 53u8, 76u8, 168u8, 26u8, 10u8, 9u8, 98u8, 68u8, 9u8,
                            178u8, 197u8, 113u8, 31u8, 79u8, 200u8, 90u8, 203u8, 100u8, 41u8,
                            145u8,
                        ],
                    )
                }
                #[doc = " The maximum number of individual freeze locks that can exist on an account at any time."]
                pub fn max_freezes(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u32,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "Balances",
                        "MaxFreezes",
                        [
                            98u8, 252u8, 116u8, 72u8, 26u8, 180u8, 225u8, 83u8, 200u8, 157u8,
                            125u8, 151u8, 53u8, 76u8, 168u8, 26u8, 10u8, 9u8, 98u8, 68u8, 9u8,
                            178u8, 197u8, 113u8, 31u8, 79u8, 200u8, 90u8, 203u8, 100u8, 41u8,
                            145u8,
                        ],
                    )
                }
            }
        }
    }
    pub mod transaction_payment {
        use super::root_mod;
        use super::runtime_types;
        #[doc = "The `Event` enum of this pallet"]
        pub type Event = runtime_types::pallet_transaction_payment::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A transaction fee `actual_fee`, of which `tip` was added to the minimum inclusion fee,"]
            #[doc = "has been paid by `who`."]
            pub struct TransactionFeePaid {
                pub who: transaction_fee_paid::Who,
                pub actual_fee: transaction_fee_paid::ActualFee,
                pub tip: transaction_fee_paid::Tip,
            }
            pub mod transaction_fee_paid {
                use super::runtime_types;
                pub type Who = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type ActualFee = ::core::primitive::u64;
                pub type Tip = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TransactionFeePaid {
                const PALLET: &'static str = "TransactionPayment";
                const EVENT: &'static str = "TransactionFeePaid";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                pub mod next_fee_multiplier {
                    use super::runtime_types;
                    pub type NextFeeMultiplier =
                        runtime_types::sp_arithmetic::fixed_point::FixedU128;
                }
                pub mod storage_version {
                    use super::runtime_types;
                    pub type StorageVersion = runtime_types::pallet_transaction_payment::Releases;
                }
            }
            pub struct StorageApi;
            impl StorageApi {
                pub fn next_fee_multiplier(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::next_fee_multiplier::NextFeeMultiplier,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "TransactionPayment",
                        "NextFeeMultiplier",
                        (),
                        [
                            247u8, 39u8, 81u8, 170u8, 225u8, 226u8, 82u8, 147u8, 34u8, 113u8,
                            147u8, 213u8, 59u8, 80u8, 139u8, 35u8, 36u8, 196u8, 152u8, 19u8, 9u8,
                            159u8, 176u8, 79u8, 249u8, 201u8, 170u8, 1u8, 129u8, 79u8, 146u8,
                            197u8,
                        ],
                    )
                }
                pub fn storage_version(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::storage_version::StorageVersion,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "TransactionPayment",
                        "StorageVersion",
                        (),
                        [
                            105u8, 243u8, 158u8, 241u8, 159u8, 231u8, 253u8, 6u8, 4u8, 32u8, 85u8,
                            178u8, 126u8, 31u8, 203u8, 134u8, 154u8, 38u8, 122u8, 155u8, 150u8,
                            251u8, 174u8, 15u8, 74u8, 134u8, 216u8, 244u8, 168u8, 175u8, 158u8,
                            144u8,
                        ],
                    )
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                #[doc = " A fee multiplier for `Operational` extrinsics to compute \"virtual tip\" to boost their"]
                #[doc = " `priority`"]
                #[doc = ""]
                #[doc = " This value is multiplied by the `final_fee` to obtain a \"virtual tip\" that is later"]
                #[doc = " added to a tip component in regular `priority` calculations."]
                #[doc = " It means that a `Normal` transaction can front-run a similarly-sized `Operational`"]
                #[doc = " extrinsic (with no tip), by including a tip value greater than the virtual tip."]
                #[doc = ""]
                #[doc = " ```rust,ignore"]
                #[doc = " // For `Normal`"]
                #[doc = " let priority = priority_calc(tip);"]
                #[doc = ""]
                #[doc = " // For `Operational`"]
                #[doc = " let virtual_tip = (inclusion_fee + tip) * OperationalFeeMultiplier;"]
                #[doc = " let priority = priority_calc(tip + virtual_tip);"]
                #[doc = " ```"]
                #[doc = ""]
                #[doc = " Note that since we use `final_fee` the multiplier applies also to the regular `tip`"]
                #[doc = " sent with the transaction. So, not only does the transaction get a priority bump based"]
                #[doc = " on the `inclusion_fee`, but we also amplify the impact of tips applied to `Operational`"]
                #[doc = " transactions."]
                pub fn operational_fee_multiplier(
                    &self,
                ) -> ::subxt::ext::subxt_core::constants::address::StaticAddress<
                    ::core::primitive::u8,
                > {
                    ::subxt::ext::subxt_core::constants::address::StaticAddress::new_static(
                        "TransactionPayment",
                        "OperationalFeeMultiplier",
                        [
                            141u8, 130u8, 11u8, 35u8, 226u8, 114u8, 92u8, 179u8, 168u8, 110u8,
                            28u8, 91u8, 221u8, 64u8, 4u8, 148u8, 201u8, 193u8, 185u8, 66u8, 226u8,
                            114u8, 97u8, 79u8, 62u8, 212u8, 202u8, 114u8, 237u8, 228u8, 183u8,
                            165u8,
                        ],
                    )
                }
            }
        }
    }
    pub mod subtensor_module {
        use super::root_mod;
        use super::runtime_types;
        #[doc = "The `Error` enum of this pallet."]
        pub type Error = runtime_types::pallet_subtensor::pallet::Error;
        #[doc = "Dispatchable functions allow users to interact with the pallet and invoke state changes."]
        #[doc = "These functions materialize as \"extrinsics\", which are often compared to transactions."]
        #[doc = "Dispatchable functions must be annotated with a weight and must return a DispatchResult."]
        pub type Call = runtime_types::pallet_subtensor::pallet::Call;
        pub mod calls {
            use super::root_mod;
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Sets the caller weights for the incentive mechanism. The call can be"]
                #[doc = "made from the hotkey account so is potentially insecure, however, the damage"]
                #[doc = "of changing weights is minimal if caught early. This function includes all the"]
                #[doc = "checks that the passed weights meet the requirements. Stored as u16s they represent"]
                #[doc = "rational values in the range [0,1] which sum to 1 and can be interpreted as"]
                #[doc = "probabilities. The specific weights determine how inflation propagates outward"]
                #[doc = "from this peer."]
                #[doc = ""]
                #[doc = "Note: The 16 bit integers weights should represent 1.0 as the max u16."]
                #[doc = "However, the function normalizes all integers to u16_max anyway. This means that if the sum of all"]
                #[doc = "elements is larger or smaller than the amount of elements * u16_max, all elements"]
                #[doc = "will be corrected for this deviation."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (<T as frame_system::Config>Origin):"]
                #[doc = "    - The caller, a hotkey who wishes to set their weights."]
                #[doc = ""]
                #[doc = "* `netuid` (u16):"]
                #[doc = "\t- The network uid we are setting these weights on."]
                #[doc = ""]
                #[doc = "* `dests` (Vec<u16>):"]
                #[doc = "\t- The edge endpoint for the weight, i.e. j for w_ij."]
                #[doc = ""]
                #[doc = "* 'weights' (Vec<u16>):"]
                #[doc = "\t- The u16 integer encoded weights. Interpreted as rational"]
                #[doc = "\t\tvalues in the range [0,1]. They must sum to in32::MAX."]
                #[doc = ""]
                #[doc = "* 'version_key' ( u64 ):"]
                #[doc = "\t- The network version key to check if the validator is up to date."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* WeightsSet;"]
                #[doc = "\t- On successfully setting the weights on chain."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to set weights on a non-existent network."]
                #[doc = ""]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Attempting to set weights from a non registered account."]
                #[doc = ""]
                #[doc = "* 'WeightVecNotEqualSize':"]
                #[doc = "\t- Attempting to set weights with uids not of same length."]
                #[doc = ""]
                #[doc = "* 'DuplicateUids':"]
                #[doc = "\t- Attempting to set weights with duplicate uids."]
                #[doc = ""]
                #[doc = "    * 'UidsLengthExceedUidsInSubNet':"]
                #[doc = "\t- Attempting to set weights above the max allowed uids."]
                #[doc = ""]
                #[doc = "* 'UidVecContainInvalidOne':"]
                #[doc = "\t- Attempting to set weights with invalid uids."]
                #[doc = ""]
                #[doc = "* 'WeightVecLengthIsLow':"]
                #[doc = "\t- Attempting to set weights with fewer weights than min."]
                #[doc = ""]
                #[doc = "* 'MaxWeightExceeded':"]
                #[doc = "\t- Attempting to set weights with max value exceeding limit."]
                pub struct SetWeights {
                    pub netuid: set_weights::Netuid,
                    pub dests: set_weights::Dests,
                    pub weights: set_weights::Weights,
                    pub version_key: set_weights::VersionKey,
                }
                pub mod set_weights {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Dests =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Weights =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type VersionKey = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetWeights {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "set_weights";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Allows a hotkey to set weights for multiple netuids as a batch."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (<T as frame_system::Config>Origin):"]
                #[doc = "    - The caller, a hotkey who wishes to set their weights."]
                #[doc = ""]
                #[doc = "* `netuids` (Vec<Compact<u16>>):"]
                #[doc = "\t- The network uids we are setting these weights on."]
                #[doc = ""]
                #[doc = "* `weights` (Vec<Vec<(Compact<u16>, Compact<u16>)>):"]
                #[doc = "\t- The weights to set for each network. [(uid, weight), ...]"]
                #[doc = ""]
                #[doc = "* `version_keys` (Vec<Compact<u64>>):"]
                #[doc = "\t- The network version keys to check if the validator is up to date."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* WeightsSet;"]
                #[doc = "\t- On successfully setting the weights on chain."]
                #[doc = "* BatchWeightsCompleted;"]
                #[doc = "\t- On success of the batch."]
                #[doc = "* BatchCompletedWithErrors;"]
                #[doc = "\t- On failure of any of the weights in the batch."]
                #[doc = "* BatchWeightItemFailed;"]
                #[doc = "\t- On failure for each failed item in the batch."]
                #[doc = ""]
                pub struct BatchSetWeights {
                    pub netuids: batch_set_weights::Netuids,
                    pub weights: batch_set_weights::Weights,
                    pub version_keys: batch_set_weights::VersionKeys,
                }
                pub mod batch_set_weights {
                    use super::runtime_types;
                    pub type Netuids = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::ext::codec::Compact<::core::primitive::u16>,
                    >;
                    pub type Weights = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::alloc::vec::Vec<(
                            ::subxt::ext::subxt_core::ext::codec::Compact<::core::primitive::u16>,
                            ::subxt::ext::subxt_core::ext::codec::Compact<::core::primitive::u16>,
                        )>,
                    >;
                    pub type VersionKeys = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::ext::codec::Compact<::core::primitive::u64>,
                    >;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for BatchSetWeights {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "batch_set_weights";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- Used to commit a hash of your weight values to later be revealed."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (`<T as frame_system::Config>::RuntimeOrigin`):"]
                #[doc = "  - The signature of the committing hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (`u16`):"]
                #[doc = "  - The u16 network identifier."]
                #[doc = ""]
                #[doc = "* `commit_hash` (`H256`):"]
                #[doc = "  - The hash representing the committed weights."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `CommitRevealDisabled`:"]
                #[doc = "  - Attempting to commit when the commit-reveal mechanism is disabled."]
                #[doc = ""]
                #[doc = "* `TooManyUnrevealedCommits`:"]
                #[doc = "  - Attempting to commit when the user has more than the allowed limit of unrevealed commits."]
                #[doc = ""]
                pub struct CommitWeights {
                    pub netuid: commit_weights::Netuid,
                    pub commit_hash: commit_weights::CommitHash,
                }
                pub mod commit_weights {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type CommitHash = ::subxt::ext::subxt_core::utils::H256;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for CommitWeights {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "commit_weights";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Allows a hotkey to commit weight hashes for multiple netuids as a batch."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (<T as frame_system::Config>Origin):"]
                #[doc = "    - The caller, a hotkey who wishes to set their weights."]
                #[doc = ""]
                #[doc = "* `netuids` (Vec<Compact<u16>>):"]
                #[doc = "\t- The network uids we are setting these weights on."]
                #[doc = ""]
                #[doc = "* `commit_hashes` (Vec<H256>):"]
                #[doc = "\t- The commit hashes to commit."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* WeightsSet;"]
                #[doc = "\t- On successfully setting the weights on chain."]
                #[doc = "* BatchWeightsCompleted;"]
                #[doc = "\t- On success of the batch."]
                #[doc = "* BatchCompletedWithErrors;"]
                #[doc = "\t- On failure of any of the weights in the batch."]
                #[doc = "* BatchWeightItemFailed;"]
                #[doc = "\t- On failure for each failed item in the batch."]
                #[doc = ""]
                pub struct BatchCommitWeights {
                    pub netuids: batch_commit_weights::Netuids,
                    pub commit_hashes: batch_commit_weights::CommitHashes,
                }
                pub mod batch_commit_weights {
                    use super::runtime_types;
                    pub type Netuids = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::ext::codec::Compact<::core::primitive::u16>,
                    >;
                    pub type CommitHashes = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::utils::H256,
                    >;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for BatchCommitWeights {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "batch_commit_weights";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- Used to reveal the weights for a previously committed hash."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (`<T as frame_system::Config>::RuntimeOrigin`):"]
                #[doc = "  - The signature of the revealing hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (`u16`):"]
                #[doc = "  - The u16 network identifier."]
                #[doc = ""]
                #[doc = "* `uids` (`Vec<u16>`):"]
                #[doc = "  - The uids for the weights being revealed."]
                #[doc = ""]
                #[doc = "* `values` (`Vec<u16>`):"]
                #[doc = "  - The values of the weights being revealed."]
                #[doc = ""]
                #[doc = "* `salt` (`Vec<u16>`):"]
                #[doc = "  - The salt used to generate the commit hash."]
                #[doc = ""]
                #[doc = "* `version_key` (`u64`):"]
                #[doc = "  - The network version key."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `CommitRevealDisabled`:"]
                #[doc = "  - Attempting to reveal weights when the commit-reveal mechanism is disabled."]
                #[doc = ""]
                #[doc = "* `NoWeightsCommitFound`:"]
                #[doc = "  - Attempting to reveal weights without an existing commit."]
                #[doc = ""]
                #[doc = "* `ExpiredWeightCommit`:"]
                #[doc = "  - Attempting to reveal a weight commit that has expired."]
                #[doc = ""]
                #[doc = "* `RevealTooEarly`:"]
                #[doc = "  - Attempting to reveal weights outside the valid reveal period."]
                #[doc = ""]
                #[doc = "* `InvalidRevealCommitHashNotMatch`:"]
                #[doc = "  - The revealed hash does not match any committed hash."]
                #[doc = ""]
                pub struct RevealWeights {
                    pub netuid: reveal_weights::Netuid,
                    pub uids: reveal_weights::Uids,
                    pub values: reveal_weights::Values,
                    pub salt: reveal_weights::Salt,
                    pub version_key: reveal_weights::VersionKey,
                }
                pub mod reveal_weights {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Uids =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Values =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Salt =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type VersionKey = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RevealWeights {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "reveal_weights";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- Used to commit encrypted commit-reveal v3 weight values to later be revealed."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (`<T as frame_system::Config>::RuntimeOrigin`):"]
                #[doc = "  - The committing hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (`u16`):"]
                #[doc = "  - The u16 network identifier."]
                #[doc = ""]
                #[doc = "* `commit` (`Vec<u8>`):"]
                #[doc = "  - The encrypted compressed commit."]
                #[doc = "    The steps for this are:"]
                #[doc = "    1. Instantiate [`WeightsTlockPayload`]"]
                #[doc = "    2. Serialize it using the `parity_scale_codec::Encode` trait"]
                #[doc = "    3. Encrypt it following the steps (here)[https://github.com/ideal-lab5/tle/blob/f8e6019f0fb02c380ebfa6b30efb61786dede07b/timelock/src/tlock.rs#L283-L336]"]
                #[doc = "       to produce a [`TLECiphertext<TinyBLS381>`] type."]
                #[doc = "    4. Serialize and compress using the `ark-serialize` `CanonicalSerialize` trait."]
                #[doc = ""]
                #[doc = "* reveal_round (`u64`):"]
                #[doc = "   - The drand reveal round which will be avaliable during epoch `n+1` from the current"]
                #[doc = "     epoch."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `CommitRevealV3Disabled`:"]
                #[doc = "  - Attempting to commit when the commit-reveal mechanism is disabled."]
                #[doc = ""]
                #[doc = "* `TooManyUnrevealedCommits`:"]
                #[doc = "  - Attempting to commit when the user has more than the allowed limit of unrevealed commits."]
                #[doc = ""]
                pub struct CommitCrv3Weights {
                    pub netuid: commit_crv3_weights::Netuid,
                    pub commit: commit_crv3_weights::Commit,
                    pub reveal_round: commit_crv3_weights::RevealRound,
                }
                pub mod commit_crv3_weights {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Commit = runtime_types::bounded_collections::bounded_vec::BoundedVec<
                        ::core::primitive::u8,
                    >;
                    pub type RevealRound = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for CommitCrv3Weights {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "commit_crv3_weights";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- The implementation for batch revealing committed weights."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (`<T as frame_system::Config>::RuntimeOrigin`):"]
                #[doc = "  - The signature of the revealing hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (`u16`):"]
                #[doc = "  - The u16 network identifier."]
                #[doc = ""]
                #[doc = "* `uids_list` (`Vec<Vec<u16>>`):"]
                #[doc = "  - A list of uids for each set of weights being revealed."]
                #[doc = ""]
                #[doc = "* `values_list` (`Vec<Vec<u16>>`):"]
                #[doc = "  - A list of values for each set of weights being revealed."]
                #[doc = ""]
                #[doc = "* `salts_list` (`Vec<Vec<u16>>`):"]
                #[doc = "  - A list of salts used to generate the commit hashes."]
                #[doc = ""]
                #[doc = "* `version_keys` (`Vec<u64>`):"]
                #[doc = "  - A list of network version keys."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `CommitRevealDisabled`:"]
                #[doc = "  - Attempting to reveal weights when the commit-reveal mechanism is disabled."]
                #[doc = ""]
                #[doc = "* `NoWeightsCommitFound`:"]
                #[doc = "  - Attempting to reveal weights without an existing commit."]
                #[doc = ""]
                #[doc = "* `ExpiredWeightCommit`:"]
                #[doc = "  - Attempting to reveal a weight commit that has expired."]
                #[doc = ""]
                #[doc = "* `RevealTooEarly`:"]
                #[doc = "  - Attempting to reveal weights outside the valid reveal period."]
                #[doc = ""]
                #[doc = "* `InvalidRevealCommitHashNotMatch`:"]
                #[doc = "  - The revealed hash does not match any committed hash."]
                #[doc = ""]
                #[doc = "* `InvalidInputLengths`:"]
                #[doc = "  - The input vectors are of mismatched lengths."]
                pub struct BatchRevealWeights {
                    pub netuid: batch_reveal_weights::Netuid,
                    pub uids_list: batch_reveal_weights::UidsList,
                    pub values_list: batch_reveal_weights::ValuesList,
                    pub salts_list: batch_reveal_weights::SaltsList,
                    pub version_keys: batch_reveal_weights::VersionKeys,
                }
                pub mod batch_reveal_weights {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type UidsList = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>,
                    >;
                    pub type ValuesList = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>,
                    >;
                    pub type SaltsList = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>,
                    >;
                    pub type VersionKeys =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u64>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for BatchRevealWeights {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "batch_reveal_weights";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The caller, a hotkey who wishes to set their weights."]
                #[doc = ""]
                #[doc = "* `netuid` (u16):"]
                #[doc = "\t- The network uid we are setting these weights on."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "\t- The hotkey associated with the operation and the calling coldkey."]
                #[doc = ""]
                #[doc = "* `dests` (Vec<u16>):"]
                #[doc = "\t- The edge endpoint for the weight, i.e. j for w_ij."]
                #[doc = ""]
                #[doc = "* 'weights' (Vec<u16>):"]
                #[doc = "\t- The u16 integer encoded weights. Interpreted as rational"]
                #[doc = "\t\tvalues in the range [0,1]. They must sum to in32::MAX."]
                #[doc = ""]
                #[doc = "* 'version_key' ( u64 ):"]
                #[doc = "\t- The network version key to check if the validator is up to date."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = ""]
                #[doc = "* WeightsSet;"]
                #[doc = "\t- On successfully setting the weights on chain."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = ""]
                #[doc = "* NonAssociatedColdKey;"]
                #[doc = "\t- Attempting to set weights on a non-associated cold key."]
                #[doc = ""]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to set weights on a non-existent network."]
                #[doc = ""]
                #[doc = "* 'NotRootSubnet':"]
                #[doc = "\t- Attempting to set weights on a subnet that is not the root network."]
                #[doc = ""]
                #[doc = "* 'WeightVecNotEqualSize':"]
                #[doc = "\t- Attempting to set weights with uids not of same length."]
                #[doc = ""]
                #[doc = "* 'UidVecContainInvalidOne':"]
                #[doc = "\t- Attempting to set weights with invalid uids."]
                #[doc = ""]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Attempting to set weights from a non registered account."]
                #[doc = ""]
                #[doc = "* 'WeightVecLengthIsLow':"]
                #[doc = "\t- Attempting to set weights with fewer weights than min."]
                #[doc = ""]
                #[doc = " * 'IncorrectWeightVersionKey':"]
                #[doc = "     - Attempting to set weights with the incorrect network version key."]
                #[doc = ""]
                #[doc = " * 'SettingWeightsTooFast':"]
                #[doc = "     - Attempting to set weights too fast."]
                #[doc = ""]
                #[doc = "* 'WeightVecLengthIsLow':"]
                #[doc = "\t- Attempting to set weights with fewer weights than min."]
                #[doc = ""]
                #[doc = "* 'MaxWeightExceeded':"]
                #[doc = "\t- Attempting to set weights with max value exceeding limit."]
                #[doc = ""]
                pub struct SetTaoWeights {
                    pub netuid: set_tao_weights::Netuid,
                    pub hotkey: set_tao_weights::Hotkey,
                    pub dests: set_tao_weights::Dests,
                    pub weights: set_tao_weights::Weights,
                    pub version_key: set_tao_weights::VersionKey,
                }
                pub mod set_tao_weights {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Dests =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Weights =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type VersionKey = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetTaoWeights {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "set_tao_weights";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Sets the key as a delegate."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The hotkey we are delegating (must be owned by the coldkey.)"]
                #[doc = ""]
                #[doc = "* 'take' (u64):"]
                #[doc = "\t- The stake proportion that this hotkey takes from delegations."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* DelegateAdded;"]
                #[doc = "\t- On successfully setting a hotkey as a delegate."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- The hotkey we are delegating is not registered on the network."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- The hotkey we are delegating is not owned by the calling coldket."]
                #[doc = ""]
                pub struct BecomeDelegate {
                    pub hotkey: become_delegate::Hotkey,
                }
                pub mod become_delegate {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for BecomeDelegate {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "become_delegate";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Allows delegates to decrease its take value."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>::Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The hotkey we are delegating (must be owned by the coldkey.)"]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- Subnet ID to decrease take for"]
                #[doc = ""]
                #[doc = "* 'take' (u16):"]
                #[doc = "\t- The new stake proportion that this hotkey takes from delegations."]
                #[doc = "       The new value can be between 0 and 11_796 and should be strictly"]
                #[doc = "       lower than the previous value. It T is the new value (rational number),"]
                #[doc = "       the the parameter is calculated as [65535 * T]. For example, 1% would be"]
                #[doc = "       [0.01 * 65535] = [655.35] = 655"]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* TakeDecreased;"]
                #[doc = "\t- On successfully setting a decreased take for this hotkey."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- The hotkey we are delegating is not registered on the network."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- The hotkey we are delegating is not owned by the calling coldkey."]
                #[doc = ""]
                #[doc = "* 'DelegateTakeTooLow':"]
                #[doc = "\t- The delegate is setting a take which is not lower than the previous."]
                #[doc = ""]
                pub struct DecreaseTake {
                    pub hotkey: decrease_take::Hotkey,
                    pub take: decrease_take::Take,
                }
                pub mod decrease_take {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Take = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for DecreaseTake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "decrease_take";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Allows delegates to increase its take value. This call is rate-limited."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>::Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The hotkey we are delegating (must be owned by the coldkey.)"]
                #[doc = ""]
                #[doc = "* 'take' (u16):"]
                #[doc = "\t- The new stake proportion that this hotkey takes from delegations."]
                #[doc = "       The new value can be between 0 and 11_796 and should be strictly"]
                #[doc = "       greater than the previous value. T is the new value (rational number),"]
                #[doc = "       the the parameter is calculated as [65535 * T]. For example, 1% would be"]
                #[doc = "       [0.01 * 65535] = [655.35] = 655"]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* TakeIncreased;"]
                #[doc = "\t- On successfully setting a increased take for this hotkey."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- The hotkey we are delegating is not registered on the network."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- The hotkey we are delegating is not owned by the calling coldkey."]
                #[doc = ""]
                #[doc = "* 'DelegateTakeTooHigh':"]
                #[doc = "\t- The delegate is setting a take which is not greater than the previous."]
                #[doc = ""]
                pub struct IncreaseTake {
                    pub hotkey: increase_take::Hotkey,
                    pub take: increase_take::Take,
                }
                pub mod increase_take {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Take = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for IncreaseTake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "increase_take";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Adds stake to a hotkey. The call is made from a coldkey account."]
                #[doc = "This delegates stake to the hotkey."]
                #[doc = ""]
                #[doc = "Note: the coldkey account may own the hotkey, in which case they are"]
                #[doc = "delegating to themselves."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = " * 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = " * 'hotkey' (T::AccountId):"]
                #[doc = "\t- The associated hotkey account."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "    - Subnetwork UID"]
                #[doc = ""]
                #[doc = " * 'amount_staked' (u64):"]
                #[doc = "\t- The amount of stake to be added to the hotkey staking account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = " * StakeAdded;"]
                #[doc = "\t- On the successfully adding stake to a global account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = " * 'NotEnoughBalanceToStake':"]
                #[doc = "\t- Not enough balance on the coldkey to add onto the global account."]
                #[doc = ""]
                #[doc = " * 'NonAssociatedColdKey':"]
                #[doc = "\t- The calling coldkey is not associated with this hotkey."]
                #[doc = ""]
                #[doc = " * 'BalanceWithdrawalError':"]
                #[doc = " \t- Errors stemming from transaction pallet."]
                #[doc = ""]
                pub struct AddStake {
                    pub hotkey: add_stake::Hotkey,
                    pub netuid: add_stake::Netuid,
                    pub amount_staked: add_stake::AmountStaked,
                }
                pub mod add_stake {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                    pub type AmountStaked = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for AddStake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "add_stake";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Remove stake from the staking account. The call must be made"]
                #[doc = "from the coldkey account attached to the neuron metadata. Only this key"]
                #[doc = "has permission to make staking and unstaking requests."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The associated hotkey account."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "    - Subnetwork UID"]
                #[doc = ""]
                #[doc = "* 'amount_unstaked' (u64):"]
                #[doc = "\t- The amount of stake to be added to the hotkey staking account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* StakeRemoved;"]
                #[doc = "\t- On the successfully removing stake from the hotkey account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Thrown if the account we are attempting to unstake from is non existent."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- Thrown if the coldkey does not own the hotkey we are unstaking from."]
                #[doc = ""]
                #[doc = "* 'NotEnoughStakeToWithdraw':"]
                #[doc = "\t- Thrown if there is not enough stake on the hotkey to withdwraw this amount."]
                #[doc = ""]
                pub struct RemoveStake {
                    pub hotkey: remove_stake::Hotkey,
                    pub netuid: remove_stake::Netuid,
                    pub amount_unstaked: remove_stake::AmountUnstaked,
                }
                pub mod remove_stake {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                    pub type AmountUnstaked = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RemoveStake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "remove_stake";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Serves or updates axon /prometheus information for the neuron associated with the caller. If the caller is"]
                #[doc = "already registered the metadata is updated. If the caller is not registered this call throws NotRegistered."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'version' (u64):"]
                #[doc = "\t- The bittensor version identifier."]
                #[doc = ""]
                #[doc = "* 'ip' (u64):"]
                #[doc = "\t- The endpoint ip information as a u128 encoded integer."]
                #[doc = ""]
                #[doc = "* 'port' (u16):"]
                #[doc = "\t- The endpoint port information as a u16 encoded integer."]
                #[doc = ""]
                #[doc = "* 'ip_type' (u8):"]
                #[doc = "\t- The endpoint ip version as a u8, 4 or 6."]
                #[doc = ""]
                #[doc = "* 'protocol' (u8):"]
                #[doc = "\t- UDP:1 or TCP:0"]
                #[doc = ""]
                #[doc = "* 'placeholder1' (u8):"]
                #[doc = "\t- Placeholder for further extra params."]
                #[doc = ""]
                #[doc = "* 'placeholder2' (u8):"]
                #[doc = "\t- Placeholder for further extra params."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* AxonServed;"]
                #[doc = "\t- On successfully serving the axon info."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to set weights on a non-existent network."]
                #[doc = ""]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Attempting to set weights from a non registered account."]
                #[doc = ""]
                #[doc = "* 'InvalidIpType':"]
                #[doc = "\t- The ip type is not 4 or 6."]
                #[doc = ""]
                #[doc = "* 'InvalidIpAddress':"]
                #[doc = "\t- The numerically encoded ip address does not resolve to a proper ip."]
                #[doc = ""]
                #[doc = "* 'ServingRateLimitExceeded':"]
                #[doc = "\t- Attempting to set prometheus information withing the rate limit min."]
                #[doc = ""]
                pub struct ServeAxon {
                    pub netuid: serve_axon::Netuid,
                    pub version: serve_axon::Version,
                    pub ip: serve_axon::Ip,
                    pub port: serve_axon::Port,
                    pub ip_type: serve_axon::IpType,
                    pub protocol: serve_axon::Protocol,
                    pub placeholder1: serve_axon::Placeholder1,
                    pub placeholder2: serve_axon::Placeholder2,
                }
                pub mod serve_axon {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Version = ::core::primitive::u32;
                    pub type Ip = ::core::primitive::u128;
                    pub type Port = ::core::primitive::u16;
                    pub type IpType = ::core::primitive::u8;
                    pub type Protocol = ::core::primitive::u8;
                    pub type Placeholder1 = ::core::primitive::u8;
                    pub type Placeholder2 = ::core::primitive::u8;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ServeAxon {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "serve_axon";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Same as `serve_axon` but takes a certificate as an extra optional argument."]
                #[doc = "Serves or updates axon /prometheus information for the neuron associated with the caller. If the caller is"]
                #[doc = "already registered the metadata is updated. If the caller is not registered this call throws NotRegistered."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'version' (u64):"]
                #[doc = "\t- The bittensor version identifier."]
                #[doc = ""]
                #[doc = "* 'ip' (u64):"]
                #[doc = "\t- The endpoint ip information as a u128 encoded integer."]
                #[doc = ""]
                #[doc = "* 'port' (u16):"]
                #[doc = "\t- The endpoint port information as a u16 encoded integer."]
                #[doc = ""]
                #[doc = "* 'ip_type' (u8):"]
                #[doc = "\t- The endpoint ip version as a u8, 4 or 6."]
                #[doc = ""]
                #[doc = "* 'protocol' (u8):"]
                #[doc = "\t- UDP:1 or TCP:0"]
                #[doc = ""]
                #[doc = "* 'placeholder1' (u8):"]
                #[doc = "\t- Placeholder for further extra params."]
                #[doc = ""]
                #[doc = "* 'placeholder2' (u8):"]
                #[doc = "\t- Placeholder for further extra params."]
                #[doc = ""]
                #[doc = "* 'certificate' (Vec<u8>):"]
                #[doc = "    - TLS certificate for inter neuron communitation."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* AxonServed;"]
                #[doc = "\t- On successfully serving the axon info."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to set weights on a non-existent network."]
                #[doc = ""]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Attempting to set weights from a non registered account."]
                #[doc = ""]
                #[doc = "* 'InvalidIpType':"]
                #[doc = "\t- The ip type is not 4 or 6."]
                #[doc = ""]
                #[doc = "* 'InvalidIpAddress':"]
                #[doc = "\t- The numerically encoded ip address does not resolve to a proper ip."]
                #[doc = ""]
                #[doc = "* 'ServingRateLimitExceeded':"]
                #[doc = "\t- Attempting to set prometheus information withing the rate limit min."]
                #[doc = ""]
                pub struct ServeAxonTls {
                    pub netuid: serve_axon_tls::Netuid,
                    pub version: serve_axon_tls::Version,
                    pub ip: serve_axon_tls::Ip,
                    pub port: serve_axon_tls::Port,
                    pub ip_type: serve_axon_tls::IpType,
                    pub protocol: serve_axon_tls::Protocol,
                    pub placeholder1: serve_axon_tls::Placeholder1,
                    pub placeholder2: serve_axon_tls::Placeholder2,
                    pub certificate: serve_axon_tls::Certificate,
                }
                pub mod serve_axon_tls {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Version = ::core::primitive::u32;
                    pub type Ip = ::core::primitive::u128;
                    pub type Port = ::core::primitive::u16;
                    pub type IpType = ::core::primitive::u8;
                    pub type Protocol = ::core::primitive::u8;
                    pub type Placeholder1 = ::core::primitive::u8;
                    pub type Placeholder2 = ::core::primitive::u8;
                    pub type Certificate =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ServeAxonTls {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "serve_axon_tls";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- Set prometheus information for the neuron."]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the calling hotkey."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'version' (u16):"]
                #[doc = "\t-  The bittensor version identifier."]
                #[doc = ""]
                #[doc = "* 'ip' (u128):"]
                #[doc = "\t- The prometheus ip information as a u128 encoded integer."]
                #[doc = ""]
                #[doc = "* 'port' (u16):"]
                #[doc = "\t- The prometheus port information as a u16 encoded integer."]
                #[doc = ""]
                #[doc = "* 'ip_type' (u8):"]
                #[doc = "\t- The ip type v4 or v6."]
                #[doc = ""]
                pub struct ServePrometheus {
                    pub netuid: serve_prometheus::Netuid,
                    pub version: serve_prometheus::Version,
                    pub ip: serve_prometheus::Ip,
                    pub port: serve_prometheus::Port,
                    pub ip_type: serve_prometheus::IpType,
                }
                pub mod serve_prometheus {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Version = ::core::primitive::u32;
                    pub type Ip = ::core::primitive::u128;
                    pub type Port = ::core::primitive::u16;
                    pub type IpType = ::core::primitive::u8;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ServePrometheus {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "serve_prometheus";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- Registers a new neuron to the subnetwork."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the calling hotkey."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'block_number' ( u64 ):"]
                #[doc = "\t- Block hash used to prove work done."]
                #[doc = ""]
                #[doc = "* 'nonce' ( u64 ):"]
                #[doc = "\t- Positive integer nonce used in POW."]
                #[doc = ""]
                #[doc = "* 'work' ( Vec<u8> ):"]
                #[doc = "\t- Vector encoded bytes representing work done."]
                #[doc = ""]
                #[doc = "* 'hotkey' ( T::AccountId ):"]
                #[doc = "\t- Hotkey to be registered to the network."]
                #[doc = ""]
                #[doc = "* 'coldkey' ( T::AccountId ):"]
                #[doc = "\t- Associated coldkey account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* NeuronRegistered;"]
                #[doc = "\t- On successfully registering a uid to a neuron slot on a subnetwork."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to register to a non existent network."]
                #[doc = ""]
                #[doc = "* 'TooManyRegistrationsThisBlock':"]
                #[doc = "\t- This registration exceeds the total allowed on this network this block."]
                #[doc = ""]
                #[doc = "* 'HotKeyAlreadyRegisteredInSubNet':"]
                #[doc = "\t- The hotkey is already registered on this network."]
                #[doc = ""]
                #[doc = "* 'InvalidWorkBlock':"]
                #[doc = "\t- The work has been performed on a stale, future, or non existent block."]
                #[doc = ""]
                #[doc = "* 'InvalidDifficulty':"]
                #[doc = "\t- The work does not match the difficulty."]
                #[doc = ""]
                #[doc = "* 'InvalidSeal':"]
                #[doc = "\t- The seal is incorrect."]
                #[doc = ""]
                pub struct Register {
                    pub netuid: register::Netuid,
                    pub block_number: register::BlockNumber,
                    pub nonce: register::Nonce,
                    pub work: register::Work,
                    pub hotkey: register::Hotkey,
                    pub coldkey: register::Coldkey,
                }
                pub mod register {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type BlockNumber = ::core::primitive::u64;
                    pub type Nonce = ::core::primitive::u64;
                    pub type Work =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Coldkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for Register {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "register";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Register the hotkey to root network"]
                pub struct RootRegister {
                    pub hotkey: root_register::Hotkey,
                }
                pub mod root_register {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RootRegister {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "root_register";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Attempt to adjust the senate membership to include a hotkey"]
                pub struct AdjustSenate {
                    pub hotkey: adjust_senate::Hotkey,
                }
                pub mod adjust_senate {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for AdjustSenate {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "adjust_senate";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "User register a new subnetwork via burning token"]
                pub struct BurnedRegister {
                    pub netuid: burned_register::Netuid,
                    pub hotkey: burned_register::Hotkey,
                }
                pub mod burned_register {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for BurnedRegister {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "burned_register";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "The extrinsic for user to change its hotkey in subnet or all subnets."]
                pub struct SwapHotkey {
                    pub hotkey: swap_hotkey::Hotkey,
                    pub new_hotkey: swap_hotkey::NewHotkey,
                    pub netuid: swap_hotkey::Netuid,
                }
                pub mod swap_hotkey {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type NewHotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::option::Option<::core::primitive::u16>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SwapHotkey {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "swap_hotkey";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "The extrinsic for user to change the coldkey associated with their account."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = ""]
                #[doc = "* `origin` - The origin of the call, must be signed by the old coldkey."]
                #[doc = "* `old_coldkey` - The current coldkey associated with the account."]
                #[doc = "* `new_coldkey` - The new coldkey to be associated with the account."]
                #[doc = ""]
                #[doc = "# Returns"]
                #[doc = ""]
                #[doc = "Returns a `DispatchResultWithPostInfo` indicating success or failure of the operation."]
                #[doc = ""]
                #[doc = "# Weight"]
                #[doc = ""]
                #[doc = "Weight is calculated based on the number of database reads and writes."]
                pub struct SwapColdkey {
                    pub old_coldkey: swap_coldkey::OldColdkey,
                    pub new_coldkey: swap_coldkey::NewColdkey,
                    pub swap_cost: swap_coldkey::SwapCost,
                }
                pub mod swap_coldkey {
                    use super::runtime_types;
                    pub type OldColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type NewColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type SwapCost = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SwapColdkey {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "swap_coldkey";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Sets the childkey take for a given hotkey."]
                #[doc = ""]
                #[doc = "This function allows a coldkey to set the childkey take for a given hotkey."]
                #[doc = "The childkey take determines the proportion of stake that the hotkey keeps for itself"]
                #[doc = "when distributing stake to its children."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` (<T as frame_system::Config>::RuntimeOrigin):"]
                #[doc = "    - The signature of the calling coldkey. Setting childkey take can only be done by the coldkey."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey for which the childkey take will be set."]
                #[doc = ""]
                #[doc = "* `take` (u16):"]
                #[doc = "    - The new childkey take value. This is a percentage represented as a value between 0 and 10000,"]
                #[doc = "      where 10000 represents 100%."]
                #[doc = ""]
                #[doc = "# Events:"]
                #[doc = "* `ChildkeyTakeSet`:"]
                #[doc = "    - On successfully setting the childkey take for a hotkey."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `NonAssociatedColdKey`:"]
                #[doc = "    - The coldkey does not own the hotkey."]
                #[doc = "* `InvalidChildkeyTake`:"]
                #[doc = "    - The provided take value is invalid (greater than the maximum allowed take)."]
                #[doc = "* `TxChildkeyTakeRateLimitExceeded`:"]
                #[doc = "    - The rate limit for changing childkey take has been exceeded."]
                #[doc = ""]
                pub struct SetChildkeyTake {
                    pub hotkey: set_childkey_take::Hotkey,
                    pub netuid: set_childkey_take::Netuid,
                    pub take: set_childkey_take::Take,
                }
                pub mod set_childkey_take {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Take = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetChildkeyTake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "set_childkey_take";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Sets the transaction rate limit for changing childkey take."]
                #[doc = ""]
                #[doc = "This function can only be called by the root origin."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` - The origin of the call, must be root."]
                #[doc = "* `tx_rate_limit` - The new rate limit in blocks."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `BadOrigin` - If the origin is not root."]
                #[doc = ""]
                pub struct SudoSetTxChildkeyTakeRateLimit {
                    pub tx_rate_limit: sudo_set_tx_childkey_take_rate_limit::TxRateLimit,
                }
                pub mod sudo_set_tx_childkey_take_rate_limit {
                    use super::runtime_types;
                    pub type TxRateLimit = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SudoSetTxChildkeyTakeRateLimit {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "sudo_set_tx_childkey_take_rate_limit";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Sets the minimum allowed childkey take."]
                #[doc = ""]
                #[doc = "This function can only be called by the root origin."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` - The origin of the call, must be root."]
                #[doc = "* `take` - The new minimum childkey take value."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `BadOrigin` - If the origin is not root."]
                #[doc = ""]
                pub struct SudoSetMinChildkeyTake {
                    pub take: sudo_set_min_childkey_take::Take,
                }
                pub mod sudo_set_min_childkey_take {
                    use super::runtime_types;
                    pub type Take = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SudoSetMinChildkeyTake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "sudo_set_min_childkey_take";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Sets the maximum allowed childkey take."]
                #[doc = ""]
                #[doc = "This function can only be called by the root origin."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` - The origin of the call, must be root."]
                #[doc = "* `take` - The new maximum childkey take value."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `BadOrigin` - If the origin is not root."]
                #[doc = ""]
                pub struct SudoSetMaxChildkeyTake {
                    pub take: sudo_set_max_childkey_take::Take,
                }
                pub mod sudo_set_max_childkey_take {
                    use super::runtime_types;
                    pub type Take = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SudoSetMaxChildkeyTake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "sudo_set_max_childkey_take";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Authenticates a council proposal and dispatches a function call with `Root` origin."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call must be a council majority."]
                #[doc = ""]
                #[doc = "## Complexity"]
                #[doc = "- O(1)."]
                pub struct Sudo {
                    pub call: ::subxt::ext::subxt_core::alloc::boxed::Box<sudo::Call>,
                }
                pub mod sudo {
                    use super::runtime_types;
                    pub type Call = runtime_types::node_subtensor_runtime::RuntimeCall;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for Sudo {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "sudo";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Authenticates a council proposal and dispatches a function call with `Root` origin."]
                #[doc = "This function does not check the weight of the call, and instead allows the"]
                #[doc = "user to specify the weight of the call."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call must be a council majority."]
                #[doc = ""]
                #[doc = "## Complexity"]
                #[doc = "- O(1)."]
                pub struct SudoUncheckedWeight {
                    pub call:
                        ::subxt::ext::subxt_core::alloc::boxed::Box<sudo_unchecked_weight::Call>,
                    pub weight: sudo_unchecked_weight::Weight,
                }
                pub mod sudo_unchecked_weight {
                    use super::runtime_types;
                    pub type Call = runtime_types::node_subtensor_runtime::RuntimeCall;
                    pub type Weight = runtime_types::sp_weights::weight_v2::Weight;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SudoUncheckedWeight {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "sudo_unchecked_weight";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "User vote on a proposal"]
                pub struct Vote {
                    pub hotkey: vote::Hotkey,
                    pub proposal: vote::Proposal,
                    #[codec(compact)]
                    pub index: vote::Index,
                    pub approve: vote::Approve,
                }
                pub mod vote {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Proposal = ::subxt::ext::subxt_core::utils::H256;
                    pub type Index = ::core::primitive::u32;
                    pub type Approve = ::core::primitive::bool;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for Vote {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "vote";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "User register a new subnetwork"]
                pub struct RegisterNetwork {
                    pub hotkey: register_network::Hotkey,
                }
                pub mod register_network {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RegisterNetwork {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "register_network";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Facility extrinsic for user to get taken from faucet"]
                #[doc = "It is only available when pow-faucet feature enabled"]
                #[doc = "Just deployed in testnet and devnet for testing purpose"]
                pub struct Faucet {
                    pub block_number: faucet::BlockNumber,
                    pub nonce: faucet::Nonce,
                    pub work: faucet::Work,
                }
                pub mod faucet {
                    use super::runtime_types;
                    pub type BlockNumber = ::core::primitive::u64;
                    pub type Nonce = ::core::primitive::u64;
                    pub type Work =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for Faucet {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "faucet";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Remove a user's subnetwork"]
                #[doc = "The caller must be the owner of the network"]
                pub struct DissolveNetwork {
                    pub coldkey: dissolve_network::Coldkey,
                    pub netuid: dissolve_network::Netuid,
                }
                pub mod dissolve_network {
                    use super::runtime_types;
                    pub type Coldkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for DissolveNetwork {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "dissolve_network";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Set a single child for a given hotkey on a specified network."]
                #[doc = ""]
                #[doc = "This function allows a coldkey to set a single child for a given hotkey on a specified network."]
                #[doc = "The proportion of the hotkey's stake to be allocated to the child is also specified."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` (<T as frame_system::Config>::RuntimeOrigin):"]
                #[doc = "    - The signature of the calling coldkey. Setting a hotkey child can only be done by the coldkey."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey which will be assigned the child."]
                #[doc = ""]
                #[doc = "* `child` (T::AccountId):"]
                #[doc = "    - The child which will be assigned to the hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (u16):"]
                #[doc = "    - The u16 network identifier where the childkey will exist."]
                #[doc = ""]
                #[doc = "* `proportion` (u64):"]
                #[doc = "    - Proportion of the hotkey's stake to be given to the child, the value must be u64 normalized."]
                #[doc = ""]
                #[doc = "# Events:"]
                #[doc = "* `ChildAddedSingular`:"]
                #[doc = "    - On successfully registering a child to a hotkey."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `SubNetworkDoesNotExist`:"]
                #[doc = "    - Attempting to register to a non-existent network."]
                #[doc = "* `RegistrationNotPermittedOnRootSubnet`:"]
                #[doc = "    - Attempting to register a child on the root network."]
                #[doc = "* `NonAssociatedColdKey`:"]
                #[doc = "    - The coldkey does not own the hotkey or the child is the same as the hotkey."]
                #[doc = "* `HotKeyAccountNotExists`:"]
                #[doc = "    - The hotkey account does not exist."]
                #[doc = ""]
                #[doc = "# Detailed Explanation of Checks:"]
                #[doc = "1. **Signature Verification**: Ensures that the caller has signed the transaction, verifying the coldkey."]
                #[doc = "2. **Root Network Check**: Ensures that the delegation is not on the root network, as child hotkeys are not valid on the root."]
                #[doc = "3. **Network Existence Check**: Ensures that the specified network exists."]
                #[doc = "4. **Ownership Verification**: Ensures that the coldkey owns the hotkey."]
                #[doc = "5. **Hotkey Account Existence Check**: Ensures that the hotkey account already exists."]
                #[doc = "6. **Child-Hotkey Distinction**: Ensures that the child is not the same as the hotkey."]
                #[doc = "7. **Old Children Cleanup**: Removes the hotkey from the parent list of its old children."]
                #[doc = "8. **New Children Assignment**: Assigns the new child to the hotkey and updates the parent list for the new child."]
                pub struct SetChildren {
                    pub hotkey: set_children::Hotkey,
                    pub netuid: set_children::Netuid,
                    pub children: set_children::Children,
                }
                pub mod set_children {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Children = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::core::primitive::u64,
                        ::subxt::ext::subxt_core::utils::AccountId32,
                    )>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetChildren {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "set_children";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Schedules a coldkey swap operation to be executed at a future block."]
                #[doc = ""]
                #[doc = "This function allows a user to schedule the swapping of their coldkey to a new one"]
                #[doc = "at a specified future block. The swap is not executed immediately but is scheduled"]
                #[doc = "to occur at the specified block number."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = ""]
                #[doc = "* `origin` - The origin of the call, which should be signed by the current coldkey owner."]
                #[doc = "* `new_coldkey` - The account ID of the new coldkey that will replace the current one."]
                #[doc = "* `when` - The block number at which the coldkey swap should be executed."]
                #[doc = ""]
                #[doc = "# Returns"]
                #[doc = ""]
                #[doc = "Returns a `DispatchResultWithPostInfo` indicating whether the scheduling was successful."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = ""]
                #[doc = "This function may return an error if:"]
                #[doc = "* The origin is not signed."]
                #[doc = "* The scheduling fails due to conflicts or system constraints."]
                #[doc = ""]
                #[doc = "# Notes"]
                #[doc = ""]
                #[doc = "- The actual swap is not performed by this function. It merely schedules the swap operation."]
                #[doc = "- The weight of this call is set to a fixed value and may need adjustment based on benchmarking."]
                #[doc = ""]
                #[doc = "# TODO"]
                #[doc = ""]
                #[doc = "- Implement proper weight calculation based on the complexity of the operation."]
                #[doc = "- Consider adding checks to prevent scheduling too far into the future."]
                #[doc = "TODO: Benchmark this call"]
                pub struct ScheduleSwapColdkey {
                    pub new_coldkey: schedule_swap_coldkey::NewColdkey,
                }
                pub mod schedule_swap_coldkey {
                    use super::runtime_types;
                    pub type NewColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ScheduleSwapColdkey {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "schedule_swap_coldkey";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Schedule the dissolution of a network at a specified block number."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = ""]
                #[doc = "* `origin` - The origin of the call, must be signed by the sender."]
                #[doc = "* `netuid` - The u16 network identifier to be dissolved."]
                #[doc = ""]
                #[doc = "# Returns"]
                #[doc = ""]
                #[doc = "Returns a `DispatchResultWithPostInfo` indicating success or failure of the operation."]
                #[doc = ""]
                #[doc = "# Weight"]
                #[doc = ""]
                #[doc = "Weight is calculated based on the number of database reads and writes."]
                pub struct ScheduleDissolveNetwork {
                    pub netuid: schedule_dissolve_network::Netuid,
                }
                pub mod schedule_dissolve_network {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for ScheduleDissolveNetwork {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "schedule_dissolve_network";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- Set prometheus information for the neuron."]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the calling hotkey."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'version' (u16):"]
                #[doc = "\t-  The bittensor version identifier."]
                #[doc = ""]
                #[doc = "* 'ip' (u128):"]
                #[doc = "\t- The prometheus ip information as a u128 encoded integer."]
                #[doc = ""]
                #[doc = "* 'port' (u16):"]
                #[doc = "\t- The prometheus port information as a u16 encoded integer."]
                #[doc = ""]
                #[doc = "* 'ip_type' (u8):"]
                #[doc = "\t- The ip type v4 or v6."]
                #[doc = ""]
                pub struct SetIdentity {
                    pub name: set_identity::Name,
                    pub url: set_identity::Url,
                    pub github_repo: set_identity::GithubRepo,
                    pub image: set_identity::Image,
                    pub discord: set_identity::Discord,
                    pub description: set_identity::Description,
                    pub additional: set_identity::Additional,
                }
                pub mod set_identity {
                    use super::runtime_types;
                    pub type Name =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Url = ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type GithubRepo =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Image =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Discord =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Description =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Additional =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetIdentity {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "set_identity";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- Set the identity information for a subnet."]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the calling coldkey, which must be the owner of the subnet."]
                #[doc = ""]
                #[doc = "* `netuid` (u16):"]
                #[doc = "    - The unique network identifier of the subnet."]
                #[doc = ""]
                #[doc = "* `subnet_name` (Vec<u8>):"]
                #[doc = "    - The name of the subnet."]
                #[doc = ""]
                #[doc = "* `github_repo` (Vec<u8>):"]
                #[doc = "    - The GitHub repository associated with the subnet identity."]
                #[doc = ""]
                #[doc = "* `subnet_contact` (Vec<u8>):"]
                #[doc = "    - The contact information for the subnet."]
                pub struct SetSubnetIdentity {
                    pub netuid: set_subnet_identity::Netuid,
                    pub subnet_name: set_subnet_identity::SubnetName,
                    pub github_repo: set_subnet_identity::GithubRepo,
                    pub subnet_contact: set_subnet_identity::SubnetContact,
                    pub subnet_url: set_subnet_identity::SubnetUrl,
                    pub discord: set_subnet_identity::Discord,
                    pub description: set_subnet_identity::Description,
                    pub logo_url: set_subnet_identity::LogoUrl,
                    pub additional: set_subnet_identity::Additional,
                }
                pub mod set_subnet_identity {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type SubnetName =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type GithubRepo =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type SubnetContact =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type SubnetUrl =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Discord =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Description =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type LogoUrl =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Additional =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetSubnetIdentity {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "set_subnet_identity";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "User register a new subnetwork"]
                pub struct RegisterNetworkWithIdentity {
                    pub hotkey: register_network_with_identity::Hotkey,
                    pub identity: register_network_with_identity::Identity,
                }
                pub mod register_network_with_identity {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Identity = ::core::option::Option<
                        runtime_types::pallet_subtensor::pallet::SubnetIdentityV3,
                    >;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RegisterNetworkWithIdentity {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "register_network_with_identity";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- The implementation for the extrinsic unstake_all: Removes all stake from a hotkey account across all subnets and adds it onto a coldkey."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The associated hotkey account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* StakeRemoved;"]
                #[doc = "    - On the successfully removing stake from the hotkey account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `NotRegistered`:"]
                #[doc = "    - Thrown if the account we are attempting to unstake from is non existent."]
                #[doc = ""]
                #[doc = "* `NonAssociatedColdKey`:"]
                #[doc = "    - Thrown if the coldkey does not own the hotkey we are unstaking from."]
                #[doc = ""]
                #[doc = "* `NotEnoughStakeToWithdraw`:"]
                #[doc = "    - Thrown if there is not enough stake on the hotkey to withdraw this amount."]
                #[doc = ""]
                #[doc = "* `TxRateLimitExceeded`:"]
                #[doc = "    - Thrown if key has hit transaction rate limit"]
                pub struct UnstakeAll {
                    pub hotkey: unstake_all::Hotkey,
                }
                pub mod unstake_all {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for UnstakeAll {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "unstake_all";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- The implementation for the extrinsic unstake_all: Removes all stake from a hotkey account across all subnets and adds it onto a coldkey."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The associated hotkey account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* StakeRemoved;"]
                #[doc = "    - On the successfully removing stake from the hotkey account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `NotRegistered`:"]
                #[doc = "    - Thrown if the account we are attempting to unstake from is non existent."]
                #[doc = ""]
                #[doc = "* `NonAssociatedColdKey`:"]
                #[doc = "    - Thrown if the coldkey does not own the hotkey we are unstaking from."]
                #[doc = ""]
                #[doc = "* `NotEnoughStakeToWithdraw`:"]
                #[doc = "    - Thrown if there is not enough stake on the hotkey to withdraw this amount."]
                #[doc = ""]
                #[doc = "* `TxRateLimitExceeded`:"]
                #[doc = "    - Thrown if key has hit transaction rate limit"]
                pub struct UnstakeAllAlpha {
                    pub hotkey: unstake_all_alpha::Hotkey,
                }
                pub mod unstake_all_alpha {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for UnstakeAllAlpha {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "unstake_all_alpha";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "---- The implementation for the extrinsic move_stake: Moves specified amount of stake from a hotkey to another across subnets."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `origin_hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey account to move stake from."]
                #[doc = ""]
                #[doc = "* `destination_hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey account to move stake to."]
                #[doc = ""]
                #[doc = "* `origin_netuid` (T::AccountId):"]
                #[doc = "    - The subnet ID to move stake from."]
                #[doc = ""]
                #[doc = "* `destination_netuid` (T::AccountId):"]
                #[doc = "    - The subnet ID to move stake to."]
                #[doc = ""]
                #[doc = "* `alpha_amount` (T::AccountId):"]
                #[doc = "    - The alpha stake amount to move."]
                #[doc = ""]
                pub struct MoveStake {
                    pub origin_hotkey: move_stake::OriginHotkey,
                    pub destination_hotkey: move_stake::DestinationHotkey,
                    pub origin_netuid: move_stake::OriginNetuid,
                    pub destination_netuid: move_stake::DestinationNetuid,
                    pub alpha_amount: move_stake::AlphaAmount,
                }
                pub mod move_stake {
                    use super::runtime_types;
                    pub type OriginHotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type DestinationHotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type OriginNetuid = ::core::primitive::u16;
                    pub type DestinationNetuid = ::core::primitive::u16;
                    pub type AlphaAmount = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for MoveStake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "move_stake";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Transfers a specified amount of stake from one coldkey to another, optionally across subnets,"]
                #[doc = "while keeping the same hotkey."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the `origin_coldkey`."]
                #[doc = "* `destination_coldkey` - The coldkey to which the stake is transferred."]
                #[doc = "* `hotkey` - The hotkey associated with the stake."]
                #[doc = "* `origin_netuid` - The network/subnet ID to move stake from."]
                #[doc = "* `destination_netuid` - The network/subnet ID to move stake to (for cross-subnet transfer)."]
                #[doc = "* `alpha_amount` - The amount of stake to transfer."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The origin is not signed by the correct coldkey."]
                #[doc = "* Either subnet does not exist."]
                #[doc = "* The hotkey does not exist."]
                #[doc = "* There is insufficient stake on `(origin_coldkey, hotkey, origin_netuid)`."]
                #[doc = "* The transfer amount is below the minimum stake requirement."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "May emit a `StakeTransferred` event on success."]
                pub struct TransferStake {
                    pub destination_coldkey: transfer_stake::DestinationColdkey,
                    pub hotkey: transfer_stake::Hotkey,
                    pub origin_netuid: transfer_stake::OriginNetuid,
                    pub destination_netuid: transfer_stake::DestinationNetuid,
                    pub alpha_amount: transfer_stake::AlphaAmount,
                }
                pub mod transfer_stake {
                    use super::runtime_types;
                    pub type DestinationColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type OriginNetuid = ::core::primitive::u16;
                    pub type DestinationNetuid = ::core::primitive::u16;
                    pub type AlphaAmount = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for TransferStake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "transfer_stake";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Swaps a specified amount of stake from one subnet to another, while keeping the same coldkey and hotkey."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the coldkey that owns the `hotkey`."]
                #[doc = "* `hotkey` - The hotkey whose stake is being swapped."]
                #[doc = "* `origin_netuid` - The network/subnet ID from which stake is removed."]
                #[doc = "* `destination_netuid` - The network/subnet ID to which stake is added."]
                #[doc = "* `alpha_amount` - The amount of stake to swap."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The transaction is not signed by the correct coldkey (i.e., `coldkey_owns_hotkey` fails)."]
                #[doc = "* Either `origin_netuid` or `destination_netuid` does not exist."]
                #[doc = "* The hotkey does not exist."]
                #[doc = "* There is insufficient stake on `(coldkey, hotkey, origin_netuid)`."]
                #[doc = "* The swap amount is below the minimum stake requirement."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "May emit a `StakeSwapped` event on success."]
                pub struct SwapStake {
                    pub hotkey: swap_stake::Hotkey,
                    pub origin_netuid: swap_stake::OriginNetuid,
                    pub destination_netuid: swap_stake::DestinationNetuid,
                    pub alpha_amount: swap_stake::AlphaAmount,
                }
                pub mod swap_stake {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type OriginNetuid = ::core::primitive::u16;
                    pub type DestinationNetuid = ::core::primitive::u16;
                    pub type AlphaAmount = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SwapStake {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "swap_stake";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Adds stake to a hotkey on a subnet with a price limit."]
                #[doc = "This extrinsic allows to specify the limit price for alpha token"]
                #[doc = "at which or better (lower) the staking should execute."]
                #[doc = ""]
                #[doc = "In case if slippage occurs and the price shall move beyond the limit"]
                #[doc = "price, the staking order may execute only partially or not execute"]
                #[doc = "at all."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = " * 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = " * 'hotkey' (T::AccountId):"]
                #[doc = "\t- The associated hotkey account."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "    - Subnetwork UID"]
                #[doc = ""]
                #[doc = " * 'amount_staked' (u64):"]
                #[doc = "\t- The amount of stake to be added to the hotkey staking account."]
                #[doc = ""]
                #[doc = " * 'limit_price' (u64):"]
                #[doc = "\t- The limit price expressed in units of RAO per one Alpha."]
                #[doc = ""]
                #[doc = " * 'allow_partial' (bool):"]
                #[doc = "\t- Allows partial execution of the amount. If set to false, this becomes"]
                #[doc = "      fill or kill type or order."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = " * StakeAdded;"]
                #[doc = "\t- On the successfully adding stake to a global account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = " * 'NotEnoughBalanceToStake':"]
                #[doc = "\t- Not enough balance on the coldkey to add onto the global account."]
                #[doc = ""]
                #[doc = " * 'NonAssociatedColdKey':"]
                #[doc = "\t- The calling coldkey is not associated with this hotkey."]
                #[doc = ""]
                #[doc = " * 'BalanceWithdrawalError':"]
                #[doc = " \t- Errors stemming from transaction pallet."]
                #[doc = ""]
                pub struct AddStakeLimit {
                    pub hotkey: add_stake_limit::Hotkey,
                    pub netuid: add_stake_limit::Netuid,
                    pub amount_staked: add_stake_limit::AmountStaked,
                    pub limit_price: add_stake_limit::LimitPrice,
                    pub allow_partial: add_stake_limit::AllowPartial,
                }
                pub mod add_stake_limit {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                    pub type AmountStaked = ::core::primitive::u64;
                    pub type LimitPrice = ::core::primitive::u64;
                    pub type AllowPartial = ::core::primitive::bool;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for AddStakeLimit {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "add_stake_limit";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "--- Removes stake from a hotkey on a subnet with a price limit."]
                #[doc = "This extrinsic allows to specify the limit price for alpha token"]
                #[doc = "at which or better (higher) the staking should execute."]
                #[doc = ""]
                #[doc = "In case if slippage occurs and the price shall move beyond the limit"]
                #[doc = "price, the staking order may execute only partially or not execute"]
                #[doc = "at all."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The associated hotkey account."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "    - Subnetwork UID"]
                #[doc = ""]
                #[doc = "* 'amount_unstaked' (u64):"]
                #[doc = "\t- The amount of stake to be added to the hotkey staking account."]
                #[doc = ""]
                #[doc = " * 'limit_price' (u64):"]
                #[doc = "    - The limit price expressed in units of RAO per one Alpha."]
                #[doc = ""]
                #[doc = " * 'allow_partial' (bool):"]
                #[doc = "    - Allows partial execution of the amount. If set to false, this becomes"]
                #[doc = "      fill or kill type or order."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* StakeRemoved;"]
                #[doc = "\t- On the successfully removing stake from the hotkey account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Thrown if the account we are attempting to unstake from is non existent."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- Thrown if the coldkey does not own the hotkey we are unstaking from."]
                #[doc = ""]
                #[doc = "* 'NotEnoughStakeToWithdraw':"]
                #[doc = "\t- Thrown if there is not enough stake on the hotkey to withdwraw this amount."]
                #[doc = ""]
                pub struct RemoveStakeLimit {
                    pub hotkey: remove_stake_limit::Hotkey,
                    pub netuid: remove_stake_limit::Netuid,
                    pub amount_unstaked: remove_stake_limit::AmountUnstaked,
                    pub limit_price: remove_stake_limit::LimitPrice,
                    pub allow_partial: remove_stake_limit::AllowPartial,
                }
                pub mod remove_stake_limit {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                    pub type AmountUnstaked = ::core::primitive::u64;
                    pub type LimitPrice = ::core::primitive::u64;
                    pub type AllowPartial = ::core::primitive::bool;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RemoveStakeLimit {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "remove_stake_limit";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Swaps a specified amount of stake from one subnet to another, while keeping the same coldkey and hotkey."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the coldkey that owns the `hotkey`."]
                #[doc = "* `hotkey` - The hotkey whose stake is being swapped."]
                #[doc = "* `origin_netuid` - The network/subnet ID from which stake is removed."]
                #[doc = "* `destination_netuid` - The network/subnet ID to which stake is added."]
                #[doc = "* `alpha_amount` - The amount of stake to swap."]
                #[doc = "* `limit_price` - The limit price expressed in units of RAO per one Alpha."]
                #[doc = "* `allow_partial` - Allows partial execution of the amount. If set to false, this becomes fill or kill type or order."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The transaction is not signed by the correct coldkey (i.e., `coldkey_owns_hotkey` fails)."]
                #[doc = "* Either `origin_netuid` or `destination_netuid` does not exist."]
                #[doc = "* The hotkey does not exist."]
                #[doc = "* There is insufficient stake on `(coldkey, hotkey, origin_netuid)`."]
                #[doc = "* The swap amount is below the minimum stake requirement."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "May emit a `StakeSwapped` event on success."]
                pub struct SwapStakeLimit {
                    pub hotkey: swap_stake_limit::Hotkey,
                    pub origin_netuid: swap_stake_limit::OriginNetuid,
                    pub destination_netuid: swap_stake_limit::DestinationNetuid,
                    pub alpha_amount: swap_stake_limit::AlphaAmount,
                    pub limit_price: swap_stake_limit::LimitPrice,
                    pub allow_partial: swap_stake_limit::AllowPartial,
                }
                pub mod swap_stake_limit {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type OriginNetuid = ::core::primitive::u16;
                    pub type DestinationNetuid = ::core::primitive::u16;
                    pub type AlphaAmount = ::core::primitive::u64;
                    pub type LimitPrice = ::core::primitive::u64;
                    pub type AllowPartial = ::core::primitive::bool;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SwapStakeLimit {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "swap_stake_limit";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Attempts to associate a hotkey with a coldkey."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the coldkey that owns the `hotkey`."]
                #[doc = "* `hotkey` - The hotkey to associate with the coldkey."]
                #[doc = ""]
                #[doc = "# Note"]
                #[doc = "Will charge based on the weight even if the hotkey is already associated with a coldkey."]
                pub struct TryAssociateHotkey {
                    pub hotkey: try_associate_hotkey::Hotkey,
                }
                pub mod try_associate_hotkey {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for TryAssociateHotkey {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "try_associate_hotkey";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Initiates a call on a subnet."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the call, which must be signed by the subnet owner."]
                #[doc = "* `netuid` - The unique identifier of the subnet on which the call is being initiated."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "Emits a `FirstEmissionBlockNumberSet` event on success."]
                pub struct StartCall {
                    pub netuid: start_call::Netuid,
                }
                pub mod start_call {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for StartCall {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "start_call";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Attempts to associate a hotkey with an EVM key."]
                #[doc = ""]
                #[doc = "The signature will be checked to see if the recovered public key matches the `evm_key` provided."]
                #[doc = ""]
                #[doc = "The EVM key is expected to sign the message according to this formula to produce the signature:"]
                #[doc = "```text"]
                #[doc = "keccak_256(hotkey ++ keccak_256(block_number))"]
                #[doc = "```"]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the coldkey that owns the `hotkey`."]
                #[doc = "* `netuid` - The netuid that the `hotkey` belongs to."]
                #[doc = "* `hotkey` - The hotkey associated with the `origin`."]
                #[doc = "* `evm_key` - The EVM key to associate with the `hotkey`."]
                #[doc = "* `block_number` - The block number used in the `signature`."]
                #[doc = "* `signature` - A signed message by the `evm_key` containing the `hotkey` and the hashed `block_number`."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The transaction is not signed."]
                #[doc = "* The hotkey is not owned by the origin coldkey."]
                #[doc = "* The hotkey does not belong to the subnet identified by the netuid."]
                #[doc = "* The EVM key cannot be recovered from the signature."]
                #[doc = "* The EVM key recovered from the signature does not match the given EVM key."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "May emit a `EvmKeyAssociated` event on success"]
                pub struct AssociateEvmKey {
                    pub netuid: associate_evm_key::Netuid,
                    pub evm_key: associate_evm_key::EvmKey,
                    pub block_number: associate_evm_key::BlockNumber,
                    pub signature: associate_evm_key::Signature,
                }
                pub mod associate_evm_key {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type EvmKey = ::subxt::ext::subxt_core::utils::H160;
                    pub type BlockNumber = ::core::primitive::u64;
                    pub type Signature = [::core::primitive::u8; 65usize];
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for AssociateEvmKey {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "associate_evm_key";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Recycles alpha from a cold/hot key pair, reducing AlphaOut on a subnet"]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the call (must be signed by the coldkey)"]
                #[doc = "* `hotkey` - The hotkey account"]
                #[doc = "* `amount` - The amount of alpha to recycle"]
                #[doc = "* `netuid` - The subnet ID"]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "Emits a `TokensRecycled` event on success."]
                pub struct RecycleAlpha {
                    pub hotkey: recycle_alpha::Hotkey,
                    pub amount: recycle_alpha::Amount,
                    pub netuid: recycle_alpha::Netuid,
                }
                pub mod recycle_alpha {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Amount = ::core::primitive::u64;
                    pub type Netuid = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RecycleAlpha {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "recycle_alpha";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Burns alpha from a cold/hot key pair without reducing `AlphaOut`"]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the call (must be signed by the coldkey)"]
                #[doc = "* `hotkey` - The hotkey account"]
                #[doc = "* `amount` - The amount of alpha to burn"]
                #[doc = "* `netuid` - The subnet ID"]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "Emits a `TokensBurned` event on success."]
                pub struct BurnAlpha {
                    pub hotkey: burn_alpha::Hotkey,
                    pub amount: burn_alpha::Amount,
                    pub netuid: burn_alpha::Netuid,
                }
                pub mod burn_alpha {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Amount = ::core::primitive::u64;
                    pub type Netuid = ::core::primitive::u16;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for BurnAlpha {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "burn_alpha";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Sets the pending childkey cooldown (in blocks). Root only."]
                pub struct SetPendingChildkeyCooldown {
                    pub cooldown: set_pending_childkey_cooldown::Cooldown,
                }
                pub mod set_pending_childkey_cooldown {
                    use super::runtime_types;
                    pub type Cooldown = ::core::primitive::u64;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for SetPendingChildkeyCooldown {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "set_pending_childkey_cooldown";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Removes all stake from a hotkey on a subnet with a price limit."]
                #[doc = "This extrinsic allows to specify the limit price for alpha token"]
                #[doc = "at which or better (higher) the staking should execute."]
                #[doc = "Without limit_price it remove all the stake similar to `remove_stake` extrinsic"]
                pub struct RemoveStakeFullLimit {
                    pub hotkey: remove_stake_full_limit::Hotkey,
                    pub netuid: remove_stake_full_limit::Netuid,
                    pub limit_price: remove_stake_full_limit::LimitPrice,
                }
                pub mod remove_stake_full_limit {
                    use super::runtime_types;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Netuid = ::core::primitive::u16;
                    pub type LimitPrice = ::core::option::Option<::core::primitive::u64>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RemoveStakeFullLimit {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "remove_stake_full_limit";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Register a new leased network."]
                #[doc = ""]
                #[doc = "The crowdloan's contributions are used to compute the share of the emissions that the contributors"]
                #[doc = "will receive as dividends."]
                #[doc = ""]
                #[doc = "The leftover cap is refunded to the contributors and the beneficiary."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `emissions_share` (Percent):"]
                #[doc = "    - The share of the emissions that the contributors will receive as dividends."]
                #[doc = ""]
                #[doc = "* `end_block` (Option<BlockNumberFor<T>>):"]
                #[doc = "    - The block at which the lease will end. If not defined, the lease is perpetual."]
                pub struct RegisterLeasedNetwork {
                    pub emissions_share: register_leased_network::EmissionsShare,
                    pub end_block: register_leased_network::EndBlock,
                }
                pub mod register_leased_network {
                    use super::runtime_types;
                    pub type EmissionsShare = runtime_types::sp_arithmetic::per_things::Percent;
                    pub type EndBlock = ::core::option::Option<::core::primitive::u32>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for RegisterLeasedNetwork {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "register_leased_network";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Terminate a lease."]
                #[doc = ""]
                #[doc = "The beneficiary can terminate the lease after the end block has passed and get the subnet ownership."]
                #[doc = "The subnet is transferred to the beneficiary and the lease is removed from storage."]
                #[doc = ""]
                #[doc = "**The hotkey must be owned by the beneficiary coldkey.**"]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `lease_id` (LeaseId):"]
                #[doc = "    - The ID of the lease to terminate."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey of the beneficiary to mark as subnet owner hotkey."]
                pub struct TerminateLease {
                    pub lease_id: terminate_lease::LeaseId,
                    pub hotkey: terminate_lease::Hotkey,
                }
                pub mod terminate_lease {
                    use super::runtime_types;
                    pub type LeaseId = ::core::primitive::u32;
                    pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for TerminateLease {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "terminate_lease";
                }
                #[derive(
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                    :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                    :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                    :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                    Clone,
                    Debug,
                )]
                # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
                #[codec(dumb_trait_bound)]
                #[decode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode"
                )]
                #[encode_as_type(
                    crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode"
                )]
                #[doc = "Updates the symbol for a subnet."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the call, which must be the subnet owner or root."]
                #[doc = "* `netuid` - The unique identifier of the subnet on which the symbol is being set."]
                #[doc = "* `symbol` - The symbol to set for the subnet."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The transaction is not signed by the subnet owner."]
                #[doc = "* The symbol does not exist."]
                #[doc = "* The symbol is already in use by another subnet."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "Emits a `SymbolUpdated` event on success."]
                pub struct UpdateSymbol {
                    pub netuid: update_symbol::Netuid,
                    pub symbol: update_symbol::Symbol,
                }
                pub mod update_symbol {
                    use super::runtime_types;
                    pub type Netuid = ::core::primitive::u16;
                    pub type Symbol =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                }
                impl ::subxt::ext::subxt_core::blocks::StaticExtrinsic for UpdateSymbol {
                    const PALLET: &'static str = "SubtensorModule";
                    const CALL: &'static str = "update_symbol";
                }
            }
            pub struct TransactionApi;
            impl TransactionApi {
                #[doc = "--- Sets the caller weights for the incentive mechanism. The call can be"]
                #[doc = "made from the hotkey account so is potentially insecure, however, the damage"]
                #[doc = "of changing weights is minimal if caught early. This function includes all the"]
                #[doc = "checks that the passed weights meet the requirements. Stored as u16s they represent"]
                #[doc = "rational values in the range [0,1] which sum to 1 and can be interpreted as"]
                #[doc = "probabilities. The specific weights determine how inflation propagates outward"]
                #[doc = "from this peer."]
                #[doc = ""]
                #[doc = "Note: The 16 bit integers weights should represent 1.0 as the max u16."]
                #[doc = "However, the function normalizes all integers to u16_max anyway. This means that if the sum of all"]
                #[doc = "elements is larger or smaller than the amount of elements * u16_max, all elements"]
                #[doc = "will be corrected for this deviation."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (<T as frame_system::Config>Origin):"]
                #[doc = "    - The caller, a hotkey who wishes to set their weights."]
                #[doc = ""]
                #[doc = "* `netuid` (u16):"]
                #[doc = "\t- The network uid we are setting these weights on."]
                #[doc = ""]
                #[doc = "* `dests` (Vec<u16>):"]
                #[doc = "\t- The edge endpoint for the weight, i.e. j for w_ij."]
                #[doc = ""]
                #[doc = "* 'weights' (Vec<u16>):"]
                #[doc = "\t- The u16 integer encoded weights. Interpreted as rational"]
                #[doc = "\t\tvalues in the range [0,1]. They must sum to in32::MAX."]
                #[doc = ""]
                #[doc = "* 'version_key' ( u64 ):"]
                #[doc = "\t- The network version key to check if the validator is up to date."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* WeightsSet;"]
                #[doc = "\t- On successfully setting the weights on chain."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to set weights on a non-existent network."]
                #[doc = ""]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Attempting to set weights from a non registered account."]
                #[doc = ""]
                #[doc = "* 'WeightVecNotEqualSize':"]
                #[doc = "\t- Attempting to set weights with uids not of same length."]
                #[doc = ""]
                #[doc = "* 'DuplicateUids':"]
                #[doc = "\t- Attempting to set weights with duplicate uids."]
                #[doc = ""]
                #[doc = "    * 'UidsLengthExceedUidsInSubNet':"]
                #[doc = "\t- Attempting to set weights above the max allowed uids."]
                #[doc = ""]
                #[doc = "* 'UidVecContainInvalidOne':"]
                #[doc = "\t- Attempting to set weights with invalid uids."]
                #[doc = ""]
                #[doc = "* 'WeightVecLengthIsLow':"]
                #[doc = "\t- Attempting to set weights with fewer weights than min."]
                #[doc = ""]
                #[doc = "* 'MaxWeightExceeded':"]
                #[doc = "\t- Attempting to set weights with max value exceeding limit."]
                pub fn set_weights(
                    &self,
                    netuid: types::set_weights::Netuid,
                    dests: types::set_weights::Dests,
                    weights: types::set_weights::Weights,
                    version_key: types::set_weights::VersionKey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetWeights>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "set_weights",
                        types::SetWeights {
                            netuid,
                            dests,
                            weights,
                            version_key,
                        },
                        [
                            26u8, 113u8, 253u8, 232u8, 169u8, 61u8, 9u8, 102u8, 199u8, 147u8,
                            148u8, 10u8, 248u8, 38u8, 32u8, 13u8, 141u8, 199u8, 11u8, 40u8, 238u8,
                            233u8, 56u8, 125u8, 156u8, 213u8, 224u8, 244u8, 72u8, 93u8, 195u8,
                            62u8,
                        ],
                    )
                }
                #[doc = "--- Allows a hotkey to set weights for multiple netuids as a batch."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (<T as frame_system::Config>Origin):"]
                #[doc = "    - The caller, a hotkey who wishes to set their weights."]
                #[doc = ""]
                #[doc = "* `netuids` (Vec<Compact<u16>>):"]
                #[doc = "\t- The network uids we are setting these weights on."]
                #[doc = ""]
                #[doc = "* `weights` (Vec<Vec<(Compact<u16>, Compact<u16>)>):"]
                #[doc = "\t- The weights to set for each network. [(uid, weight), ...]"]
                #[doc = ""]
                #[doc = "* `version_keys` (Vec<Compact<u64>>):"]
                #[doc = "\t- The network version keys to check if the validator is up to date."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* WeightsSet;"]
                #[doc = "\t- On successfully setting the weights on chain."]
                #[doc = "* BatchWeightsCompleted;"]
                #[doc = "\t- On success of the batch."]
                #[doc = "* BatchCompletedWithErrors;"]
                #[doc = "\t- On failure of any of the weights in the batch."]
                #[doc = "* BatchWeightItemFailed;"]
                #[doc = "\t- On failure for each failed item in the batch."]
                #[doc = ""]
                pub fn batch_set_weights(
                    &self,
                    netuids: types::batch_set_weights::Netuids,
                    weights: types::batch_set_weights::Weights,
                    version_keys: types::batch_set_weights::VersionKeys,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::BatchSetWeights>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "batch_set_weights",
                        types::BatchSetWeights {
                            netuids,
                            weights,
                            version_keys,
                        },
                        [
                            7u8, 33u8, 231u8, 220u8, 57u8, 56u8, 201u8, 202u8, 139u8, 235u8, 190u8,
                            216u8, 235u8, 1u8, 103u8, 10u8, 216u8, 117u8, 224u8, 2u8, 237u8, 19u8,
                            111u8, 169u8, 146u8, 99u8, 27u8, 128u8, 84u8, 131u8, 246u8, 123u8,
                        ],
                    )
                }
                #[doc = "---- Used to commit a hash of your weight values to later be revealed."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (`<T as frame_system::Config>::RuntimeOrigin`):"]
                #[doc = "  - The signature of the committing hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (`u16`):"]
                #[doc = "  - The u16 network identifier."]
                #[doc = ""]
                #[doc = "* `commit_hash` (`H256`):"]
                #[doc = "  - The hash representing the committed weights."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `CommitRevealDisabled`:"]
                #[doc = "  - Attempting to commit when the commit-reveal mechanism is disabled."]
                #[doc = ""]
                #[doc = "* `TooManyUnrevealedCommits`:"]
                #[doc = "  - Attempting to commit when the user has more than the allowed limit of unrevealed commits."]
                #[doc = ""]
                pub fn commit_weights(
                    &self,
                    netuid: types::commit_weights::Netuid,
                    commit_hash: types::commit_weights::CommitHash,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::CommitWeights>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "commit_weights",
                        types::CommitWeights {
                            netuid,
                            commit_hash,
                        },
                        [
                            228u8, 64u8, 192u8, 9u8, 130u8, 55u8, 179u8, 227u8, 55u8, 103u8, 173u8,
                            38u8, 39u8, 238u8, 250u8, 79u8, 152u8, 145u8, 158u8, 183u8, 40u8,
                            242u8, 211u8, 236u8, 69u8, 77u8, 47u8, 193u8, 140u8, 230u8, 240u8,
                            65u8,
                        ],
                    )
                }
                #[doc = "--- Allows a hotkey to commit weight hashes for multiple netuids as a batch."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (<T as frame_system::Config>Origin):"]
                #[doc = "    - The caller, a hotkey who wishes to set their weights."]
                #[doc = ""]
                #[doc = "* `netuids` (Vec<Compact<u16>>):"]
                #[doc = "\t- The network uids we are setting these weights on."]
                #[doc = ""]
                #[doc = "* `commit_hashes` (Vec<H256>):"]
                #[doc = "\t- The commit hashes to commit."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* WeightsSet;"]
                #[doc = "\t- On successfully setting the weights on chain."]
                #[doc = "* BatchWeightsCompleted;"]
                #[doc = "\t- On success of the batch."]
                #[doc = "* BatchCompletedWithErrors;"]
                #[doc = "\t- On failure of any of the weights in the batch."]
                #[doc = "* BatchWeightItemFailed;"]
                #[doc = "\t- On failure for each failed item in the batch."]
                #[doc = ""]
                pub fn batch_commit_weights(
                    &self,
                    netuids: types::batch_commit_weights::Netuids,
                    commit_hashes: types::batch_commit_weights::CommitHashes,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::BatchCommitWeights>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "batch_commit_weights",
                        types::BatchCommitWeights {
                            netuids,
                            commit_hashes,
                        },
                        [
                            133u8, 53u8, 149u8, 78u8, 93u8, 96u8, 35u8, 8u8, 103u8, 14u8, 197u8,
                            8u8, 141u8, 183u8, 107u8, 242u8, 188u8, 160u8, 58u8, 167u8, 40u8,
                            111u8, 157u8, 65u8, 232u8, 199u8, 212u8, 71u8, 91u8, 18u8, 134u8,
                            104u8,
                        ],
                    )
                }
                #[doc = "---- Used to reveal the weights for a previously committed hash."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (`<T as frame_system::Config>::RuntimeOrigin`):"]
                #[doc = "  - The signature of the revealing hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (`u16`):"]
                #[doc = "  - The u16 network identifier."]
                #[doc = ""]
                #[doc = "* `uids` (`Vec<u16>`):"]
                #[doc = "  - The uids for the weights being revealed."]
                #[doc = ""]
                #[doc = "* `values` (`Vec<u16>`):"]
                #[doc = "  - The values of the weights being revealed."]
                #[doc = ""]
                #[doc = "* `salt` (`Vec<u16>`):"]
                #[doc = "  - The salt used to generate the commit hash."]
                #[doc = ""]
                #[doc = "* `version_key` (`u64`):"]
                #[doc = "  - The network version key."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `CommitRevealDisabled`:"]
                #[doc = "  - Attempting to reveal weights when the commit-reveal mechanism is disabled."]
                #[doc = ""]
                #[doc = "* `NoWeightsCommitFound`:"]
                #[doc = "  - Attempting to reveal weights without an existing commit."]
                #[doc = ""]
                #[doc = "* `ExpiredWeightCommit`:"]
                #[doc = "  - Attempting to reveal a weight commit that has expired."]
                #[doc = ""]
                #[doc = "* `RevealTooEarly`:"]
                #[doc = "  - Attempting to reveal weights outside the valid reveal period."]
                #[doc = ""]
                #[doc = "* `InvalidRevealCommitHashNotMatch`:"]
                #[doc = "  - The revealed hash does not match any committed hash."]
                #[doc = ""]
                pub fn reveal_weights(
                    &self,
                    netuid: types::reveal_weights::Netuid,
                    uids: types::reveal_weights::Uids,
                    values: types::reveal_weights::Values,
                    salt: types::reveal_weights::Salt,
                    version_key: types::reveal_weights::VersionKey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::RevealWeights>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "reveal_weights",
                        types::RevealWeights {
                            netuid,
                            uids,
                            values,
                            salt,
                            version_key,
                        },
                        [
                            100u8, 200u8, 201u8, 32u8, 249u8, 125u8, 40u8, 49u8, 6u8, 165u8, 255u8,
                            194u8, 88u8, 105u8, 13u8, 162u8, 95u8, 3u8, 68u8, 92u8, 179u8, 172u8,
                            156u8, 135u8, 133u8, 189u8, 107u8, 140u8, 198u8, 113u8, 164u8, 108u8,
                        ],
                    )
                }
                #[doc = "---- Used to commit encrypted commit-reveal v3 weight values to later be revealed."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (`<T as frame_system::Config>::RuntimeOrigin`):"]
                #[doc = "  - The committing hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (`u16`):"]
                #[doc = "  - The u16 network identifier."]
                #[doc = ""]
                #[doc = "* `commit` (`Vec<u8>`):"]
                #[doc = "  - The encrypted compressed commit."]
                #[doc = "    The steps for this are:"]
                #[doc = "    1. Instantiate [`WeightsTlockPayload`]"]
                #[doc = "    2. Serialize it using the `parity_scale_codec::Encode` trait"]
                #[doc = "    3. Encrypt it following the steps (here)[https://github.com/ideal-lab5/tle/blob/f8e6019f0fb02c380ebfa6b30efb61786dede07b/timelock/src/tlock.rs#L283-L336]"]
                #[doc = "       to produce a [`TLECiphertext<TinyBLS381>`] type."]
                #[doc = "    4. Serialize and compress using the `ark-serialize` `CanonicalSerialize` trait."]
                #[doc = ""]
                #[doc = "* reveal_round (`u64`):"]
                #[doc = "   - The drand reveal round which will be avaliable during epoch `n+1` from the current"]
                #[doc = "     epoch."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `CommitRevealV3Disabled`:"]
                #[doc = "  - Attempting to commit when the commit-reveal mechanism is disabled."]
                #[doc = ""]
                #[doc = "* `TooManyUnrevealedCommits`:"]
                #[doc = "  - Attempting to commit when the user has more than the allowed limit of unrevealed commits."]
                #[doc = ""]
                pub fn commit_crv3_weights(
                    &self,
                    netuid: types::commit_crv3_weights::Netuid,
                    commit: types::commit_crv3_weights::Commit,
                    reveal_round: types::commit_crv3_weights::RevealRound,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::CommitCrv3Weights>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "commit_crv3_weights",
                        types::CommitCrv3Weights {
                            netuid,
                            commit,
                            reveal_round,
                        },
                        [
                            218u8, 155u8, 132u8, 104u8, 4u8, 126u8, 28u8, 171u8, 49u8, 113u8, 91u8,
                            67u8, 167u8, 49u8, 18u8, 101u8, 28u8, 87u8, 191u8, 49u8, 137u8, 96u8,
                            194u8, 112u8, 70u8, 194u8, 71u8, 49u8, 107u8, 149u8, 151u8, 63u8,
                        ],
                    )
                }
                #[doc = "---- The implementation for batch revealing committed weights."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin`: (`<T as frame_system::Config>::RuntimeOrigin`):"]
                #[doc = "  - The signature of the revealing hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (`u16`):"]
                #[doc = "  - The u16 network identifier."]
                #[doc = ""]
                #[doc = "* `uids_list` (`Vec<Vec<u16>>`):"]
                #[doc = "  - A list of uids for each set of weights being revealed."]
                #[doc = ""]
                #[doc = "* `values_list` (`Vec<Vec<u16>>`):"]
                #[doc = "  - A list of values for each set of weights being revealed."]
                #[doc = ""]
                #[doc = "* `salts_list` (`Vec<Vec<u16>>`):"]
                #[doc = "  - A list of salts used to generate the commit hashes."]
                #[doc = ""]
                #[doc = "* `version_keys` (`Vec<u64>`):"]
                #[doc = "  - A list of network version keys."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `CommitRevealDisabled`:"]
                #[doc = "  - Attempting to reveal weights when the commit-reveal mechanism is disabled."]
                #[doc = ""]
                #[doc = "* `NoWeightsCommitFound`:"]
                #[doc = "  - Attempting to reveal weights without an existing commit."]
                #[doc = ""]
                #[doc = "* `ExpiredWeightCommit`:"]
                #[doc = "  - Attempting to reveal a weight commit that has expired."]
                #[doc = ""]
                #[doc = "* `RevealTooEarly`:"]
                #[doc = "  - Attempting to reveal weights outside the valid reveal period."]
                #[doc = ""]
                #[doc = "* `InvalidRevealCommitHashNotMatch`:"]
                #[doc = "  - The revealed hash does not match any committed hash."]
                #[doc = ""]
                #[doc = "* `InvalidInputLengths`:"]
                #[doc = "  - The input vectors are of mismatched lengths."]
                pub fn batch_reveal_weights(
                    &self,
                    netuid: types::batch_reveal_weights::Netuid,
                    uids_list: types::batch_reveal_weights::UidsList,
                    values_list: types::batch_reveal_weights::ValuesList,
                    salts_list: types::batch_reveal_weights::SaltsList,
                    version_keys: types::batch_reveal_weights::VersionKeys,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::BatchRevealWeights>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "batch_reveal_weights",
                        types::BatchRevealWeights {
                            netuid,
                            uids_list,
                            values_list,
                            salts_list,
                            version_keys,
                        },
                        [
                            34u8, 35u8, 127u8, 148u8, 176u8, 70u8, 79u8, 195u8, 205u8, 11u8, 184u8,
                            14u8, 132u8, 198u8, 4u8, 117u8, 131u8, 180u8, 86u8, 132u8, 222u8,
                            152u8, 13u8, 214u8, 24u8, 38u8, 67u8, 198u8, 196u8, 172u8, 7u8, 60u8,
                        ],
                    )
                }
                #[doc = "# Args:"]
                #[doc = "* `origin`: (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The caller, a hotkey who wishes to set their weights."]
                #[doc = ""]
                #[doc = "* `netuid` (u16):"]
                #[doc = "\t- The network uid we are setting these weights on."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "\t- The hotkey associated with the operation and the calling coldkey."]
                #[doc = ""]
                #[doc = "* `dests` (Vec<u16>):"]
                #[doc = "\t- The edge endpoint for the weight, i.e. j for w_ij."]
                #[doc = ""]
                #[doc = "* 'weights' (Vec<u16>):"]
                #[doc = "\t- The u16 integer encoded weights. Interpreted as rational"]
                #[doc = "\t\tvalues in the range [0,1]. They must sum to in32::MAX."]
                #[doc = ""]
                #[doc = "* 'version_key' ( u64 ):"]
                #[doc = "\t- The network version key to check if the validator is up to date."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = ""]
                #[doc = "* WeightsSet;"]
                #[doc = "\t- On successfully setting the weights on chain."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = ""]
                #[doc = "* NonAssociatedColdKey;"]
                #[doc = "\t- Attempting to set weights on a non-associated cold key."]
                #[doc = ""]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to set weights on a non-existent network."]
                #[doc = ""]
                #[doc = "* 'NotRootSubnet':"]
                #[doc = "\t- Attempting to set weights on a subnet that is not the root network."]
                #[doc = ""]
                #[doc = "* 'WeightVecNotEqualSize':"]
                #[doc = "\t- Attempting to set weights with uids not of same length."]
                #[doc = ""]
                #[doc = "* 'UidVecContainInvalidOne':"]
                #[doc = "\t- Attempting to set weights with invalid uids."]
                #[doc = ""]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Attempting to set weights from a non registered account."]
                #[doc = ""]
                #[doc = "* 'WeightVecLengthIsLow':"]
                #[doc = "\t- Attempting to set weights with fewer weights than min."]
                #[doc = ""]
                #[doc = " * 'IncorrectWeightVersionKey':"]
                #[doc = "     - Attempting to set weights with the incorrect network version key."]
                #[doc = ""]
                #[doc = " * 'SettingWeightsTooFast':"]
                #[doc = "     - Attempting to set weights too fast."]
                #[doc = ""]
                #[doc = "* 'WeightVecLengthIsLow':"]
                #[doc = "\t- Attempting to set weights with fewer weights than min."]
                #[doc = ""]
                #[doc = "* 'MaxWeightExceeded':"]
                #[doc = "\t- Attempting to set weights with max value exceeding limit."]
                #[doc = ""]
                pub fn set_tao_weights(
                    &self,
                    netuid: types::set_tao_weights::Netuid,
                    hotkey: types::set_tao_weights::Hotkey,
                    dests: types::set_tao_weights::Dests,
                    weights: types::set_tao_weights::Weights,
                    version_key: types::set_tao_weights::VersionKey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetTaoWeights>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "set_tao_weights",
                        types::SetTaoWeights {
                            netuid,
                            hotkey,
                            dests,
                            weights,
                            version_key,
                        },
                        [
                            53u8, 245u8, 134u8, 15u8, 172u8, 149u8, 178u8, 47u8, 77u8, 244u8,
                            158u8, 201u8, 44u8, 126u8, 147u8, 140u8, 176u8, 120u8, 160u8, 49u8,
                            242u8, 205u8, 138u8, 154u8, 195u8, 165u8, 54u8, 124u8, 243u8, 220u8,
                            205u8, 113u8,
                        ],
                    )
                }
                #[doc = "--- Sets the key as a delegate."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The hotkey we are delegating (must be owned by the coldkey.)"]
                #[doc = ""]
                #[doc = "* 'take' (u64):"]
                #[doc = "\t- The stake proportion that this hotkey takes from delegations."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* DelegateAdded;"]
                #[doc = "\t- On successfully setting a hotkey as a delegate."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- The hotkey we are delegating is not registered on the network."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- The hotkey we are delegating is not owned by the calling coldket."]
                #[doc = ""]
                pub fn become_delegate(
                    &self,
                    hotkey: types::become_delegate::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::BecomeDelegate>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "become_delegate",
                        types::BecomeDelegate { hotkey },
                        [
                            203u8, 35u8, 56u8, 221u8, 32u8, 244u8, 108u8, 117u8, 57u8, 16u8, 244u8,
                            226u8, 201u8, 173u8, 128u8, 134u8, 26u8, 169u8, 5u8, 132u8, 98u8,
                            220u8, 214u8, 207u8, 250u8, 232u8, 234u8, 42u8, 212u8, 81u8, 98u8,
                            57u8,
                        ],
                    )
                }
                #[doc = "--- Allows delegates to decrease its take value."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>::Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The hotkey we are delegating (must be owned by the coldkey.)"]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- Subnet ID to decrease take for"]
                #[doc = ""]
                #[doc = "* 'take' (u16):"]
                #[doc = "\t- The new stake proportion that this hotkey takes from delegations."]
                #[doc = "       The new value can be between 0 and 11_796 and should be strictly"]
                #[doc = "       lower than the previous value. It T is the new value (rational number),"]
                #[doc = "       the the parameter is calculated as [65535 * T]. For example, 1% would be"]
                #[doc = "       [0.01 * 65535] = [655.35] = 655"]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* TakeDecreased;"]
                #[doc = "\t- On successfully setting a decreased take for this hotkey."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- The hotkey we are delegating is not registered on the network."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- The hotkey we are delegating is not owned by the calling coldkey."]
                #[doc = ""]
                #[doc = "* 'DelegateTakeTooLow':"]
                #[doc = "\t- The delegate is setting a take which is not lower than the previous."]
                #[doc = ""]
                pub fn decrease_take(
                    &self,
                    hotkey: types::decrease_take::Hotkey,
                    take: types::decrease_take::Take,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::DecreaseTake>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "decrease_take",
                        types::DecreaseTake { hotkey, take },
                        [
                            220u8, 18u8, 152u8, 244u8, 15u8, 135u8, 42u8, 101u8, 78u8, 32u8, 61u8,
                            230u8, 248u8, 203u8, 252u8, 150u8, 109u8, 187u8, 44u8, 194u8, 239u8,
                            16u8, 162u8, 67u8, 90u8, 34u8, 245u8, 120u8, 33u8, 57u8, 155u8, 33u8,
                        ],
                    )
                }
                #[doc = "--- Allows delegates to increase its take value. This call is rate-limited."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>::Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The hotkey we are delegating (must be owned by the coldkey.)"]
                #[doc = ""]
                #[doc = "* 'take' (u16):"]
                #[doc = "\t- The new stake proportion that this hotkey takes from delegations."]
                #[doc = "       The new value can be between 0 and 11_796 and should be strictly"]
                #[doc = "       greater than the previous value. T is the new value (rational number),"]
                #[doc = "       the the parameter is calculated as [65535 * T]. For example, 1% would be"]
                #[doc = "       [0.01 * 65535] = [655.35] = 655"]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* TakeIncreased;"]
                #[doc = "\t- On successfully setting a increased take for this hotkey."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- The hotkey we are delegating is not registered on the network."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- The hotkey we are delegating is not owned by the calling coldkey."]
                #[doc = ""]
                #[doc = "* 'DelegateTakeTooHigh':"]
                #[doc = "\t- The delegate is setting a take which is not greater than the previous."]
                #[doc = ""]
                pub fn increase_take(
                    &self,
                    hotkey: types::increase_take::Hotkey,
                    take: types::increase_take::Take,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::IncreaseTake>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "increase_take",
                        types::IncreaseTake { hotkey, take },
                        [
                            119u8, 250u8, 49u8, 96u8, 123u8, 185u8, 96u8, 196u8, 0u8, 65u8, 142u8,
                            148u8, 174u8, 144u8, 93u8, 217u8, 119u8, 230u8, 62u8, 6u8, 108u8, 40u8,
                            121u8, 7u8, 11u8, 25u8, 80u8, 8u8, 145u8, 186u8, 25u8, 153u8,
                        ],
                    )
                }
                #[doc = "--- Adds stake to a hotkey. The call is made from a coldkey account."]
                #[doc = "This delegates stake to the hotkey."]
                #[doc = ""]
                #[doc = "Note: the coldkey account may own the hotkey, in which case they are"]
                #[doc = "delegating to themselves."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = " * 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = " * 'hotkey' (T::AccountId):"]
                #[doc = "\t- The associated hotkey account."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "    - Subnetwork UID"]
                #[doc = ""]
                #[doc = " * 'amount_staked' (u64):"]
                #[doc = "\t- The amount of stake to be added to the hotkey staking account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = " * StakeAdded;"]
                #[doc = "\t- On the successfully adding stake to a global account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = " * 'NotEnoughBalanceToStake':"]
                #[doc = "\t- Not enough balance on the coldkey to add onto the global account."]
                #[doc = ""]
                #[doc = " * 'NonAssociatedColdKey':"]
                #[doc = "\t- The calling coldkey is not associated with this hotkey."]
                #[doc = ""]
                #[doc = " * 'BalanceWithdrawalError':"]
                #[doc = " \t- Errors stemming from transaction pallet."]
                #[doc = ""]
                pub fn add_stake(
                    &self,
                    hotkey: types::add_stake::Hotkey,
                    netuid: types::add_stake::Netuid,
                    amount_staked: types::add_stake::AmountStaked,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::AddStake>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "add_stake",
                        types::AddStake {
                            hotkey,
                            netuid,
                            amount_staked,
                        },
                        [
                            28u8, 155u8, 172u8, 37u8, 141u8, 241u8, 192u8, 86u8, 151u8, 176u8,
                            226u8, 231u8, 17u8, 222u8, 128u8, 179u8, 207u8, 35u8, 201u8, 68u8,
                            236u8, 59u8, 63u8, 199u8, 52u8, 220u8, 232u8, 249u8, 78u8, 92u8, 22u8,
                            237u8,
                        ],
                    )
                }
                #[doc = "Remove stake from the staking account. The call must be made"]
                #[doc = "from the coldkey account attached to the neuron metadata. Only this key"]
                #[doc = "has permission to make staking and unstaking requests."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The associated hotkey account."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "    - Subnetwork UID"]
                #[doc = ""]
                #[doc = "* 'amount_unstaked' (u64):"]
                #[doc = "\t- The amount of stake to be added to the hotkey staking account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* StakeRemoved;"]
                #[doc = "\t- On the successfully removing stake from the hotkey account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Thrown if the account we are attempting to unstake from is non existent."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- Thrown if the coldkey does not own the hotkey we are unstaking from."]
                #[doc = ""]
                #[doc = "* 'NotEnoughStakeToWithdraw':"]
                #[doc = "\t- Thrown if there is not enough stake on the hotkey to withdwraw this amount."]
                #[doc = ""]
                pub fn remove_stake(
                    &self,
                    hotkey: types::remove_stake::Hotkey,
                    netuid: types::remove_stake::Netuid,
                    amount_unstaked: types::remove_stake::AmountUnstaked,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::RemoveStake>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "remove_stake",
                        types::RemoveStake {
                            hotkey,
                            netuid,
                            amount_unstaked,
                        },
                        [
                            30u8, 103u8, 143u8, 13u8, 22u8, 208u8, 129u8, 17u8, 83u8, 166u8, 102u8,
                            241u8, 34u8, 168u8, 106u8, 152u8, 78u8, 165u8, 176u8, 175u8, 195u8,
                            119u8, 80u8, 160u8, 216u8, 34u8, 230u8, 196u8, 190u8, 149u8, 243u8,
                            34u8,
                        ],
                    )
                }
                #[doc = "Serves or updates axon /prometheus information for the neuron associated with the caller. If the caller is"]
                #[doc = "already registered the metadata is updated. If the caller is not registered this call throws NotRegistered."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'version' (u64):"]
                #[doc = "\t- The bittensor version identifier."]
                #[doc = ""]
                #[doc = "* 'ip' (u64):"]
                #[doc = "\t- The endpoint ip information as a u128 encoded integer."]
                #[doc = ""]
                #[doc = "* 'port' (u16):"]
                #[doc = "\t- The endpoint port information as a u16 encoded integer."]
                #[doc = ""]
                #[doc = "* 'ip_type' (u8):"]
                #[doc = "\t- The endpoint ip version as a u8, 4 or 6."]
                #[doc = ""]
                #[doc = "* 'protocol' (u8):"]
                #[doc = "\t- UDP:1 or TCP:0"]
                #[doc = ""]
                #[doc = "* 'placeholder1' (u8):"]
                #[doc = "\t- Placeholder for further extra params."]
                #[doc = ""]
                #[doc = "* 'placeholder2' (u8):"]
                #[doc = "\t- Placeholder for further extra params."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* AxonServed;"]
                #[doc = "\t- On successfully serving the axon info."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to set weights on a non-existent network."]
                #[doc = ""]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Attempting to set weights from a non registered account."]
                #[doc = ""]
                #[doc = "* 'InvalidIpType':"]
                #[doc = "\t- The ip type is not 4 or 6."]
                #[doc = ""]
                #[doc = "* 'InvalidIpAddress':"]
                #[doc = "\t- The numerically encoded ip address does not resolve to a proper ip."]
                #[doc = ""]
                #[doc = "* 'ServingRateLimitExceeded':"]
                #[doc = "\t- Attempting to set prometheus information withing the rate limit min."]
                #[doc = ""]
                pub fn serve_axon(
                    &self,
                    netuid: types::serve_axon::Netuid,
                    version: types::serve_axon::Version,
                    ip: types::serve_axon::Ip,
                    port: types::serve_axon::Port,
                    ip_type: types::serve_axon::IpType,
                    protocol: types::serve_axon::Protocol,
                    placeholder1: types::serve_axon::Placeholder1,
                    placeholder2: types::serve_axon::Placeholder2,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::ServeAxon>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "serve_axon",
                        types::ServeAxon {
                            netuid,
                            version,
                            ip,
                            port,
                            ip_type,
                            protocol,
                            placeholder1,
                            placeholder2,
                        },
                        [
                            115u8, 192u8, 140u8, 60u8, 59u8, 74u8, 35u8, 185u8, 142u8, 224u8,
                            166u8, 121u8, 135u8, 13u8, 247u8, 54u8, 152u8, 178u8, 119u8, 176u8,
                            131u8, 22u8, 125u8, 241u8, 162u8, 174u8, 238u8, 35u8, 245u8, 254u8,
                            254u8, 205u8,
                        ],
                    )
                }
                #[doc = "Same as `serve_axon` but takes a certificate as an extra optional argument."]
                #[doc = "Serves or updates axon /prometheus information for the neuron associated with the caller. If the caller is"]
                #[doc = "already registered the metadata is updated. If the caller is not registered this call throws NotRegistered."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'version' (u64):"]
                #[doc = "\t- The bittensor version identifier."]
                #[doc = ""]
                #[doc = "* 'ip' (u64):"]
                #[doc = "\t- The endpoint ip information as a u128 encoded integer."]
                #[doc = ""]
                #[doc = "* 'port' (u16):"]
                #[doc = "\t- The endpoint port information as a u16 encoded integer."]
                #[doc = ""]
                #[doc = "* 'ip_type' (u8):"]
                #[doc = "\t- The endpoint ip version as a u8, 4 or 6."]
                #[doc = ""]
                #[doc = "* 'protocol' (u8):"]
                #[doc = "\t- UDP:1 or TCP:0"]
                #[doc = ""]
                #[doc = "* 'placeholder1' (u8):"]
                #[doc = "\t- Placeholder for further extra params."]
                #[doc = ""]
                #[doc = "* 'placeholder2' (u8):"]
                #[doc = "\t- Placeholder for further extra params."]
                #[doc = ""]
                #[doc = "* 'certificate' (Vec<u8>):"]
                #[doc = "    - TLS certificate for inter neuron communitation."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* AxonServed;"]
                #[doc = "\t- On successfully serving the axon info."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to set weights on a non-existent network."]
                #[doc = ""]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Attempting to set weights from a non registered account."]
                #[doc = ""]
                #[doc = "* 'InvalidIpType':"]
                #[doc = "\t- The ip type is not 4 or 6."]
                #[doc = ""]
                #[doc = "* 'InvalidIpAddress':"]
                #[doc = "\t- The numerically encoded ip address does not resolve to a proper ip."]
                #[doc = ""]
                #[doc = "* 'ServingRateLimitExceeded':"]
                #[doc = "\t- Attempting to set prometheus information withing the rate limit min."]
                #[doc = ""]
                pub fn serve_axon_tls(
                    &self,
                    netuid: types::serve_axon_tls::Netuid,
                    version: types::serve_axon_tls::Version,
                    ip: types::serve_axon_tls::Ip,
                    port: types::serve_axon_tls::Port,
                    ip_type: types::serve_axon_tls::IpType,
                    protocol: types::serve_axon_tls::Protocol,
                    placeholder1: types::serve_axon_tls::Placeholder1,
                    placeholder2: types::serve_axon_tls::Placeholder2,
                    certificate: types::serve_axon_tls::Certificate,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::ServeAxonTls>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "serve_axon_tls",
                        types::ServeAxonTls {
                            netuid,
                            version,
                            ip,
                            port,
                            ip_type,
                            protocol,
                            placeholder1,
                            placeholder2,
                            certificate,
                        },
                        [
                            56u8, 156u8, 188u8, 127u8, 240u8, 39u8, 153u8, 238u8, 44u8, 224u8,
                            151u8, 222u8, 138u8, 122u8, 122u8, 104u8, 2u8, 244u8, 243u8, 18u8,
                            90u8, 72u8, 96u8, 223u8, 19u8, 22u8, 37u8, 235u8, 139u8, 255u8, 172u8,
                            118u8,
                        ],
                    )
                }
                #[doc = "---- Set prometheus information for the neuron."]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the calling hotkey."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'version' (u16):"]
                #[doc = "\t-  The bittensor version identifier."]
                #[doc = ""]
                #[doc = "* 'ip' (u128):"]
                #[doc = "\t- The prometheus ip information as a u128 encoded integer."]
                #[doc = ""]
                #[doc = "* 'port' (u16):"]
                #[doc = "\t- The prometheus port information as a u16 encoded integer."]
                #[doc = ""]
                #[doc = "* 'ip_type' (u8):"]
                #[doc = "\t- The ip type v4 or v6."]
                #[doc = ""]
                pub fn serve_prometheus(
                    &self,
                    netuid: types::serve_prometheus::Netuid,
                    version: types::serve_prometheus::Version,
                    ip: types::serve_prometheus::Ip,
                    port: types::serve_prometheus::Port,
                    ip_type: types::serve_prometheus::IpType,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::ServePrometheus>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "serve_prometheus",
                        types::ServePrometheus {
                            netuid,
                            version,
                            ip,
                            port,
                            ip_type,
                        },
                        [
                            20u8, 125u8, 112u8, 212u8, 213u8, 9u8, 36u8, 152u8, 252u8, 42u8, 37u8,
                            90u8, 11u8, 166u8, 1u8, 224u8, 116u8, 108u8, 124u8, 61u8, 93u8, 220u8,
                            88u8, 62u8, 71u8, 65u8, 225u8, 166u8, 66u8, 236u8, 238u8, 126u8,
                        ],
                    )
                }
                #[doc = "---- Registers a new neuron to the subnetwork."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the calling hotkey."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'block_number' ( u64 ):"]
                #[doc = "\t- Block hash used to prove work done."]
                #[doc = ""]
                #[doc = "* 'nonce' ( u64 ):"]
                #[doc = "\t- Positive integer nonce used in POW."]
                #[doc = ""]
                #[doc = "* 'work' ( Vec<u8> ):"]
                #[doc = "\t- Vector encoded bytes representing work done."]
                #[doc = ""]
                #[doc = "* 'hotkey' ( T::AccountId ):"]
                #[doc = "\t- Hotkey to be registered to the network."]
                #[doc = ""]
                #[doc = "* 'coldkey' ( T::AccountId ):"]
                #[doc = "\t- Associated coldkey account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* NeuronRegistered;"]
                #[doc = "\t- On successfully registering a uid to a neuron slot on a subnetwork."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'SubNetworkDoesNotExist':"]
                #[doc = "\t- Attempting to register to a non existent network."]
                #[doc = ""]
                #[doc = "* 'TooManyRegistrationsThisBlock':"]
                #[doc = "\t- This registration exceeds the total allowed on this network this block."]
                #[doc = ""]
                #[doc = "* 'HotKeyAlreadyRegisteredInSubNet':"]
                #[doc = "\t- The hotkey is already registered on this network."]
                #[doc = ""]
                #[doc = "* 'InvalidWorkBlock':"]
                #[doc = "\t- The work has been performed on a stale, future, or non existent block."]
                #[doc = ""]
                #[doc = "* 'InvalidDifficulty':"]
                #[doc = "\t- The work does not match the difficulty."]
                #[doc = ""]
                #[doc = "* 'InvalidSeal':"]
                #[doc = "\t- The seal is incorrect."]
                #[doc = ""]
                pub fn register(
                    &self,
                    netuid: types::register::Netuid,
                    block_number: types::register::BlockNumber,
                    nonce: types::register::Nonce,
                    work: types::register::Work,
                    hotkey: types::register::Hotkey,
                    coldkey: types::register::Coldkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::Register>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "register",
                        types::Register {
                            netuid,
                            block_number,
                            nonce,
                            work,
                            hotkey,
                            coldkey,
                        },
                        [
                            224u8, 165u8, 251u8, 192u8, 6u8, 131u8, 79u8, 41u8, 143u8, 150u8,
                            200u8, 247u8, 68u8, 7u8, 4u8, 195u8, 139u8, 31u8, 130u8, 173u8, 230u8,
                            99u8, 39u8, 220u8, 244u8, 120u8, 81u8, 87u8, 34u8, 207u8, 70u8, 193u8,
                        ],
                    )
                }
                #[doc = "Register the hotkey to root network"]
                pub fn root_register(
                    &self,
                    hotkey: types::root_register::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::RootRegister>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "root_register",
                        types::RootRegister { hotkey },
                        [
                            196u8, 149u8, 100u8, 179u8, 32u8, 69u8, 216u8, 177u8, 78u8, 22u8,
                            227u8, 176u8, 63u8, 178u8, 27u8, 80u8, 74u8, 246u8, 223u8, 236u8,
                            183u8, 226u8, 210u8, 249u8, 133u8, 103u8, 174u8, 43u8, 153u8, 201u8,
                            8u8, 55u8,
                        ],
                    )
                }
                #[doc = "Attempt to adjust the senate membership to include a hotkey"]
                pub fn adjust_senate(
                    &self,
                    hotkey: types::adjust_senate::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::AdjustSenate>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "adjust_senate",
                        types::AdjustSenate { hotkey },
                        [
                            99u8, 190u8, 20u8, 241u8, 251u8, 175u8, 215u8, 232u8, 255u8, 169u8,
                            22u8, 233u8, 46u8, 228u8, 144u8, 179u8, 217u8, 92u8, 164u8, 178u8,
                            157u8, 218u8, 255u8, 63u8, 82u8, 53u8, 126u8, 114u8, 178u8, 249u8,
                            37u8, 251u8,
                        ],
                    )
                }
                #[doc = "User register a new subnetwork via burning token"]
                pub fn burned_register(
                    &self,
                    netuid: types::burned_register::Netuid,
                    hotkey: types::burned_register::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::BurnedRegister>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "burned_register",
                        types::BurnedRegister { netuid, hotkey },
                        [
                            66u8, 182u8, 83u8, 185u8, 109u8, 48u8, 136u8, 88u8, 198u8, 19u8, 54u8,
                            132u8, 245u8, 28u8, 243u8, 177u8, 110u8, 11u8, 118u8, 109u8, 17u8,
                            188u8, 221u8, 94u8, 216u8, 72u8, 0u8, 101u8, 155u8, 87u8, 140u8, 251u8,
                        ],
                    )
                }
                #[doc = "The extrinsic for user to change its hotkey in subnet or all subnets."]
                pub fn swap_hotkey(
                    &self,
                    hotkey: types::swap_hotkey::Hotkey,
                    new_hotkey: types::swap_hotkey::NewHotkey,
                    netuid: types::swap_hotkey::Netuid,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SwapHotkey>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "swap_hotkey",
                        types::SwapHotkey {
                            hotkey,
                            new_hotkey,
                            netuid,
                        },
                        [
                            126u8, 205u8, 44u8, 17u8, 243u8, 106u8, 132u8, 67u8, 22u8, 200u8,
                            108u8, 219u8, 102u8, 203u8, 151u8, 165u8, 3u8, 148u8, 231u8, 106u8,
                            143u8, 42u8, 46u8, 27u8, 206u8, 167u8, 245u8, 194u8, 222u8, 129u8,
                            255u8, 13u8,
                        ],
                    )
                }
                #[doc = "The extrinsic for user to change the coldkey associated with their account."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = ""]
                #[doc = "* `origin` - The origin of the call, must be signed by the old coldkey."]
                #[doc = "* `old_coldkey` - The current coldkey associated with the account."]
                #[doc = "* `new_coldkey` - The new coldkey to be associated with the account."]
                #[doc = ""]
                #[doc = "# Returns"]
                #[doc = ""]
                #[doc = "Returns a `DispatchResultWithPostInfo` indicating success or failure of the operation."]
                #[doc = ""]
                #[doc = "# Weight"]
                #[doc = ""]
                #[doc = "Weight is calculated based on the number of database reads and writes."]
                pub fn swap_coldkey(
                    &self,
                    old_coldkey: types::swap_coldkey::OldColdkey,
                    new_coldkey: types::swap_coldkey::NewColdkey,
                    swap_cost: types::swap_coldkey::SwapCost,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SwapColdkey>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "swap_coldkey",
                        types::SwapColdkey {
                            old_coldkey,
                            new_coldkey,
                            swap_cost,
                        },
                        [
                            229u8, 236u8, 237u8, 205u8, 82u8, 37u8, 111u8, 92u8, 44u8, 67u8, 131u8,
                            246u8, 104u8, 82u8, 215u8, 130u8, 47u8, 169u8, 16u8, 218u8, 19u8,
                            238u8, 183u8, 65u8, 194u8, 196u8, 113u8, 187u8, 86u8, 175u8, 162u8,
                            32u8,
                        ],
                    )
                }
                #[doc = "Sets the childkey take for a given hotkey."]
                #[doc = ""]
                #[doc = "This function allows a coldkey to set the childkey take for a given hotkey."]
                #[doc = "The childkey take determines the proportion of stake that the hotkey keeps for itself"]
                #[doc = "when distributing stake to its children."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` (<T as frame_system::Config>::RuntimeOrigin):"]
                #[doc = "    - The signature of the calling coldkey. Setting childkey take can only be done by the coldkey."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey for which the childkey take will be set."]
                #[doc = ""]
                #[doc = "* `take` (u16):"]
                #[doc = "    - The new childkey take value. This is a percentage represented as a value between 0 and 10000,"]
                #[doc = "      where 10000 represents 100%."]
                #[doc = ""]
                #[doc = "# Events:"]
                #[doc = "* `ChildkeyTakeSet`:"]
                #[doc = "    - On successfully setting the childkey take for a hotkey."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `NonAssociatedColdKey`:"]
                #[doc = "    - The coldkey does not own the hotkey."]
                #[doc = "* `InvalidChildkeyTake`:"]
                #[doc = "    - The provided take value is invalid (greater than the maximum allowed take)."]
                #[doc = "* `TxChildkeyTakeRateLimitExceeded`:"]
                #[doc = "    - The rate limit for changing childkey take has been exceeded."]
                #[doc = ""]
                pub fn set_childkey_take(
                    &self,
                    hotkey: types::set_childkey_take::Hotkey,
                    netuid: types::set_childkey_take::Netuid,
                    take: types::set_childkey_take::Take,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetChildkeyTake>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "set_childkey_take",
                        types::SetChildkeyTake {
                            hotkey,
                            netuid,
                            take,
                        },
                        [
                            121u8, 93u8, 32u8, 255u8, 50u8, 102u8, 154u8, 191u8, 45u8, 27u8, 53u8,
                            78u8, 108u8, 88u8, 147u8, 83u8, 170u8, 32u8, 114u8, 16u8, 119u8, 178u8,
                            138u8, 107u8, 211u8, 73u8, 71u8, 151u8, 178u8, 44u8, 250u8, 224u8,
                        ],
                    )
                }
                #[doc = "Sets the transaction rate limit for changing childkey take."]
                #[doc = ""]
                #[doc = "This function can only be called by the root origin."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` - The origin of the call, must be root."]
                #[doc = "* `tx_rate_limit` - The new rate limit in blocks."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `BadOrigin` - If the origin is not root."]
                #[doc = ""]
                pub fn sudo_set_tx_childkey_take_rate_limit(
                    &self,
                    tx_rate_limit: types::sudo_set_tx_childkey_take_rate_limit::TxRateLimit,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::SudoSetTxChildkeyTakeRateLimit,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "sudo_set_tx_childkey_take_rate_limit",
                        types::SudoSetTxChildkeyTakeRateLimit { tx_rate_limit },
                        [
                            91u8, 243u8, 210u8, 65u8, 149u8, 33u8, 8u8, 69u8, 42u8, 197u8, 4u8,
                            202u8, 73u8, 167u8, 185u8, 75u8, 203u8, 98u8, 21u8, 230u8, 66u8, 192u8,
                            108u8, 254u8, 37u8, 246u8, 156u8, 120u8, 59u8, 180u8, 175u8, 156u8,
                        ],
                    )
                }
                #[doc = "Sets the minimum allowed childkey take."]
                #[doc = ""]
                #[doc = "This function can only be called by the root origin."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` - The origin of the call, must be root."]
                #[doc = "* `take` - The new minimum childkey take value."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `BadOrigin` - If the origin is not root."]
                #[doc = ""]
                pub fn sudo_set_min_childkey_take(
                    &self,
                    take: types::sudo_set_min_childkey_take::Take,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::SudoSetMinChildkeyTake,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "sudo_set_min_childkey_take",
                        types::SudoSetMinChildkeyTake { take },
                        [
                            229u8, 132u8, 126u8, 102u8, 220u8, 249u8, 9u8, 110u8, 89u8, 137u8,
                            46u8, 248u8, 54u8, 95u8, 124u8, 194u8, 190u8, 6u8, 198u8, 113u8, 35u8,
                            21u8, 214u8, 165u8, 231u8, 91u8, 158u8, 133u8, 6u8, 192u8, 14u8, 170u8,
                        ],
                    )
                }
                #[doc = "Sets the maximum allowed childkey take."]
                #[doc = ""]
                #[doc = "This function can only be called by the root origin."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` - The origin of the call, must be root."]
                #[doc = "* `take` - The new maximum childkey take value."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `BadOrigin` - If the origin is not root."]
                #[doc = ""]
                pub fn sudo_set_max_childkey_take(
                    &self,
                    take: types::sudo_set_max_childkey_take::Take,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::SudoSetMaxChildkeyTake,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "sudo_set_max_childkey_take",
                        types::SudoSetMaxChildkeyTake { take },
                        [
                            232u8, 17u8, 96u8, 93u8, 108u8, 28u8, 113u8, 84u8, 10u8, 189u8, 180u8,
                            155u8, 200u8, 40u8, 10u8, 242u8, 93u8, 38u8, 64u8, 131u8, 72u8, 204u8,
                            77u8, 95u8, 236u8, 174u8, 245u8, 180u8, 59u8, 128u8, 44u8, 50u8,
                        ],
                    )
                }
                #[doc = "Authenticates a council proposal and dispatches a function call with `Root` origin."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call must be a council majority."]
                #[doc = ""]
                #[doc = "## Complexity"]
                #[doc = "- O(1)."]
                pub fn sudo(
                    &self,
                    call: types::sudo::Call,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::Sudo>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "sudo",
                        types::Sudo {
                            call: ::subxt::ext::subxt_core::alloc::boxed::Box::new(call),
                        },
                        [
                            142u8, 209u8, 241u8, 61u8, 131u8, 175u8, 49u8, 121u8, 180u8, 145u8,
                            87u8, 163u8, 81u8, 33u8, 177u8, 24u8, 17u8, 238u8, 7u8, 74u8, 97u8,
                            24u8, 208u8, 246u8, 79u8, 253u8, 91u8, 172u8, 11u8, 217u8, 107u8,
                            120u8,
                        ],
                    )
                }
                #[doc = "Authenticates a council proposal and dispatches a function call with `Root` origin."]
                #[doc = "This function does not check the weight of the call, and instead allows the"]
                #[doc = "user to specify the weight of the call."]
                #[doc = ""]
                #[doc = "The dispatch origin for this call must be a council majority."]
                #[doc = ""]
                #[doc = "## Complexity"]
                #[doc = "- O(1)."]
                pub fn sudo_unchecked_weight(
                    &self,
                    call: types::sudo_unchecked_weight::Call,
                    weight: types::sudo_unchecked_weight::Weight,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SudoUncheckedWeight>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "sudo_unchecked_weight",
                        types::SudoUncheckedWeight {
                            call: ::subxt::ext::subxt_core::alloc::boxed::Box::new(call),
                            weight,
                        },
                        [
                            172u8, 29u8, 99u8, 224u8, 255u8, 197u8, 187u8, 129u8, 159u8, 32u8, 2u8,
                            214u8, 70u8, 95u8, 78u8, 72u8, 31u8, 173u8, 231u8, 120u8, 178u8, 232u8,
                            153u8, 160u8, 96u8, 90u8, 252u8, 18u8, 218u8, 189u8, 213u8, 41u8,
                        ],
                    )
                }
                #[doc = "User vote on a proposal"]
                pub fn vote(
                    &self,
                    hotkey: types::vote::Hotkey,
                    proposal: types::vote::Proposal,
                    index: types::vote::Index,
                    approve: types::vote::Approve,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::Vote>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "vote",
                        types::Vote {
                            hotkey,
                            proposal,
                            index,
                            approve,
                        },
                        [
                            193u8, 173u8, 105u8, 135u8, 203u8, 205u8, 84u8, 240u8, 190u8, 83u8,
                            45u8, 196u8, 82u8, 3u8, 88u8, 189u8, 234u8, 106u8, 197u8, 108u8, 37u8,
                            21u8, 236u8, 94u8, 242u8, 148u8, 61u8, 13u8, 199u8, 2u8, 159u8, 56u8,
                        ],
                    )
                }
                #[doc = "User register a new subnetwork"]
                pub fn register_network(
                    &self,
                    hotkey: types::register_network::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::RegisterNetwork>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "register_network",
                        types::RegisterNetwork { hotkey },
                        [
                            27u8, 43u8, 133u8, 172u8, 180u8, 221u8, 134u8, 246u8, 95u8, 112u8,
                            218u8, 27u8, 156u8, 230u8, 45u8, 167u8, 169u8, 196u8, 100u8, 34u8,
                            52u8, 10u8, 57u8, 180u8, 242u8, 210u8, 229u8, 151u8, 154u8, 82u8,
                            115u8, 133u8,
                        ],
                    )
                }
                #[doc = "Facility extrinsic for user to get taken from faucet"]
                #[doc = "It is only available when pow-faucet feature enabled"]
                #[doc = "Just deployed in testnet and devnet for testing purpose"]
                pub fn faucet(
                    &self,
                    block_number: types::faucet::BlockNumber,
                    nonce: types::faucet::Nonce,
                    work: types::faucet::Work,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::Faucet>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "faucet",
                        types::Faucet {
                            block_number,
                            nonce,
                            work,
                        },
                        [
                            122u8, 187u8, 66u8, 141u8, 160u8, 202u8, 28u8, 177u8, 251u8, 180u8,
                            35u8, 60u8, 1u8, 79u8, 187u8, 247u8, 150u8, 199u8, 154u8, 37u8, 161u8,
                            229u8, 97u8, 36u8, 213u8, 31u8, 101u8, 143u8, 138u8, 52u8, 45u8, 169u8,
                        ],
                    )
                }
                #[doc = "Remove a user's subnetwork"]
                #[doc = "The caller must be the owner of the network"]
                pub fn dissolve_network(
                    &self,
                    coldkey: types::dissolve_network::Coldkey,
                    netuid: types::dissolve_network::Netuid,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::DissolveNetwork>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "dissolve_network",
                        types::DissolveNetwork { coldkey, netuid },
                        [
                            54u8, 42u8, 87u8, 170u8, 5u8, 130u8, 20u8, 182u8, 95u8, 226u8, 55u8,
                            193u8, 60u8, 185u8, 139u8, 45u8, 107u8, 158u8, 210u8, 61u8, 133u8,
                            222u8, 92u8, 57u8, 137u8, 217u8, 93u8, 143u8, 66u8, 97u8, 88u8, 11u8,
                        ],
                    )
                }
                #[doc = "Set a single child for a given hotkey on a specified network."]
                #[doc = ""]
                #[doc = "This function allows a coldkey to set a single child for a given hotkey on a specified network."]
                #[doc = "The proportion of the hotkey's stake to be allocated to the child is also specified."]
                #[doc = ""]
                #[doc = "# Arguments:"]
                #[doc = "* `origin` (<T as frame_system::Config>::RuntimeOrigin):"]
                #[doc = "    - The signature of the calling coldkey. Setting a hotkey child can only be done by the coldkey."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey which will be assigned the child."]
                #[doc = ""]
                #[doc = "* `child` (T::AccountId):"]
                #[doc = "    - The child which will be assigned to the hotkey."]
                #[doc = ""]
                #[doc = "* `netuid` (u16):"]
                #[doc = "    - The u16 network identifier where the childkey will exist."]
                #[doc = ""]
                #[doc = "* `proportion` (u64):"]
                #[doc = "    - Proportion of the hotkey's stake to be given to the child, the value must be u64 normalized."]
                #[doc = ""]
                #[doc = "# Events:"]
                #[doc = "* `ChildAddedSingular`:"]
                #[doc = "    - On successfully registering a child to a hotkey."]
                #[doc = ""]
                #[doc = "# Errors:"]
                #[doc = "* `SubNetworkDoesNotExist`:"]
                #[doc = "    - Attempting to register to a non-existent network."]
                #[doc = "* `RegistrationNotPermittedOnRootSubnet`:"]
                #[doc = "    - Attempting to register a child on the root network."]
                #[doc = "* `NonAssociatedColdKey`:"]
                #[doc = "    - The coldkey does not own the hotkey or the child is the same as the hotkey."]
                #[doc = "* `HotKeyAccountNotExists`:"]
                #[doc = "    - The hotkey account does not exist."]
                #[doc = ""]
                #[doc = "# Detailed Explanation of Checks:"]
                #[doc = "1. **Signature Verification**: Ensures that the caller has signed the transaction, verifying the coldkey."]
                #[doc = "2. **Root Network Check**: Ensures that the delegation is not on the root network, as child hotkeys are not valid on the root."]
                #[doc = "3. **Network Existence Check**: Ensures that the specified network exists."]
                #[doc = "4. **Ownership Verification**: Ensures that the coldkey owns the hotkey."]
                #[doc = "5. **Hotkey Account Existence Check**: Ensures that the hotkey account already exists."]
                #[doc = "6. **Child-Hotkey Distinction**: Ensures that the child is not the same as the hotkey."]
                #[doc = "7. **Old Children Cleanup**: Removes the hotkey from the parent list of its old children."]
                #[doc = "8. **New Children Assignment**: Assigns the new child to the hotkey and updates the parent list for the new child."]
                pub fn set_children(
                    &self,
                    hotkey: types::set_children::Hotkey,
                    netuid: types::set_children::Netuid,
                    children: types::set_children::Children,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetChildren>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "set_children",
                        types::SetChildren {
                            hotkey,
                            netuid,
                            children,
                        },
                        [
                            17u8, 215u8, 125u8, 24u8, 155u8, 166u8, 225u8, 40u8, 207u8, 43u8,
                            193u8, 5u8, 198u8, 99u8, 220u8, 214u8, 5u8, 251u8, 156u8, 83u8, 230u8,
                            246u8, 93u8, 231u8, 155u8, 254u8, 179u8, 98u8, 6u8, 40u8, 183u8, 140u8,
                        ],
                    )
                }
                #[doc = "Schedules a coldkey swap operation to be executed at a future block."]
                #[doc = ""]
                #[doc = "This function allows a user to schedule the swapping of their coldkey to a new one"]
                #[doc = "at a specified future block. The swap is not executed immediately but is scheduled"]
                #[doc = "to occur at the specified block number."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = ""]
                #[doc = "* `origin` - The origin of the call, which should be signed by the current coldkey owner."]
                #[doc = "* `new_coldkey` - The account ID of the new coldkey that will replace the current one."]
                #[doc = "* `when` - The block number at which the coldkey swap should be executed."]
                #[doc = ""]
                #[doc = "# Returns"]
                #[doc = ""]
                #[doc = "Returns a `DispatchResultWithPostInfo` indicating whether the scheduling was successful."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = ""]
                #[doc = "This function may return an error if:"]
                #[doc = "* The origin is not signed."]
                #[doc = "* The scheduling fails due to conflicts or system constraints."]
                #[doc = ""]
                #[doc = "# Notes"]
                #[doc = ""]
                #[doc = "- The actual swap is not performed by this function. It merely schedules the swap operation."]
                #[doc = "- The weight of this call is set to a fixed value and may need adjustment based on benchmarking."]
                #[doc = ""]
                #[doc = "# TODO"]
                #[doc = ""]
                #[doc = "- Implement proper weight calculation based on the complexity of the operation."]
                #[doc = "- Consider adding checks to prevent scheduling too far into the future."]
                #[doc = "TODO: Benchmark this call"]
                pub fn schedule_swap_coldkey(
                    &self,
                    new_coldkey: types::schedule_swap_coldkey::NewColdkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::ScheduleSwapColdkey>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "schedule_swap_coldkey",
                        types::ScheduleSwapColdkey { new_coldkey },
                        [
                            66u8, 101u8, 41u8, 48u8, 176u8, 72u8, 84u8, 50u8, 72u8, 60u8, 8u8,
                            241u8, 164u8, 96u8, 160u8, 55u8, 31u8, 204u8, 167u8, 233u8, 184u8, 5u8,
                            106u8, 178u8, 49u8, 38u8, 199u8, 171u8, 125u8, 2u8, 163u8, 98u8,
                        ],
                    )
                }
                #[doc = "Schedule the dissolution of a network at a specified block number."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = ""]
                #[doc = "* `origin` - The origin of the call, must be signed by the sender."]
                #[doc = "* `netuid` - The u16 network identifier to be dissolved."]
                #[doc = ""]
                #[doc = "# Returns"]
                #[doc = ""]
                #[doc = "Returns a `DispatchResultWithPostInfo` indicating success or failure of the operation."]
                #[doc = ""]
                #[doc = "# Weight"]
                #[doc = ""]
                #[doc = "Weight is calculated based on the number of database reads and writes."]
                pub fn schedule_dissolve_network(
                    &self,
                    netuid: types::schedule_dissolve_network::Netuid,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::ScheduleDissolveNetwork,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "schedule_dissolve_network",
                        types::ScheduleDissolveNetwork { netuid },
                        [
                            226u8, 8u8, 148u8, 200u8, 65u8, 242u8, 123u8, 255u8, 171u8, 207u8,
                            68u8, 87u8, 122u8, 55u8, 61u8, 194u8, 198u8, 222u8, 33u8, 139u8, 0u8,
                            166u8, 153u8, 210u8, 172u8, 58u8, 116u8, 235u8, 191u8, 95u8, 116u8,
                            229u8,
                        ],
                    )
                }
                #[doc = "---- Set prometheus information for the neuron."]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the calling hotkey."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "\t- The u16 network identifier."]
                #[doc = ""]
                #[doc = "* 'version' (u16):"]
                #[doc = "\t-  The bittensor version identifier."]
                #[doc = ""]
                #[doc = "* 'ip' (u128):"]
                #[doc = "\t- The prometheus ip information as a u128 encoded integer."]
                #[doc = ""]
                #[doc = "* 'port' (u16):"]
                #[doc = "\t- The prometheus port information as a u16 encoded integer."]
                #[doc = ""]
                #[doc = "* 'ip_type' (u8):"]
                #[doc = "\t- The ip type v4 or v6."]
                #[doc = ""]
                pub fn set_identity(
                    &self,
                    name: types::set_identity::Name,
                    url: types::set_identity::Url,
                    github_repo: types::set_identity::GithubRepo,
                    image: types::set_identity::Image,
                    discord: types::set_identity::Discord,
                    description: types::set_identity::Description,
                    additional: types::set_identity::Additional,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetIdentity>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "set_identity",
                        types::SetIdentity {
                            name,
                            url,
                            github_repo,
                            image,
                            discord,
                            description,
                            additional,
                        },
                        [
                            237u8, 249u8, 60u8, 113u8, 96u8, 234u8, 95u8, 151u8, 158u8, 93u8, 97u8,
                            57u8, 67u8, 219u8, 148u8, 31u8, 31u8, 40u8, 92u8, 8u8, 53u8, 95u8,
                            178u8, 98u8, 62u8, 195u8, 126u8, 125u8, 204u8, 193u8, 61u8, 12u8,
                        ],
                    )
                }
                #[doc = "---- Set the identity information for a subnet."]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the calling coldkey, which must be the owner of the subnet."]
                #[doc = ""]
                #[doc = "* `netuid` (u16):"]
                #[doc = "    - The unique network identifier of the subnet."]
                #[doc = ""]
                #[doc = "* `subnet_name` (Vec<u8>):"]
                #[doc = "    - The name of the subnet."]
                #[doc = ""]
                #[doc = "* `github_repo` (Vec<u8>):"]
                #[doc = "    - The GitHub repository associated with the subnet identity."]
                #[doc = ""]
                #[doc = "* `subnet_contact` (Vec<u8>):"]
                #[doc = "    - The contact information for the subnet."]
                pub fn set_subnet_identity(
                    &self,
                    netuid: types::set_subnet_identity::Netuid,
                    subnet_name: types::set_subnet_identity::SubnetName,
                    github_repo: types::set_subnet_identity::GithubRepo,
                    subnet_contact: types::set_subnet_identity::SubnetContact,
                    subnet_url: types::set_subnet_identity::SubnetUrl,
                    discord: types::set_subnet_identity::Discord,
                    description: types::set_subnet_identity::Description,
                    logo_url: types::set_subnet_identity::LogoUrl,
                    additional: types::set_subnet_identity::Additional,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SetSubnetIdentity>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "set_subnet_identity",
                        types::SetSubnetIdentity {
                            netuid,
                            subnet_name,
                            github_repo,
                            subnet_contact,
                            subnet_url,
                            discord,
                            description,
                            logo_url,
                            additional,
                        },
                        [
                            32u8, 41u8, 124u8, 227u8, 220u8, 125u8, 125u8, 188u8, 171u8, 36u8,
                            184u8, 137u8, 43u8, 80u8, 117u8, 121u8, 239u8, 63u8, 198u8, 224u8,
                            229u8, 97u8, 56u8, 251u8, 41u8, 243u8, 53u8, 38u8, 240u8, 65u8, 101u8,
                            186u8,
                        ],
                    )
                }
                #[doc = "User register a new subnetwork"]
                pub fn register_network_with_identity(
                    &self,
                    hotkey: types::register_network_with_identity::Hotkey,
                    identity: types::register_network_with_identity::Identity,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::RegisterNetworkWithIdentity,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "register_network_with_identity",
                        types::RegisterNetworkWithIdentity { hotkey, identity },
                        [
                            12u8, 245u8, 161u8, 216u8, 254u8, 186u8, 104u8, 80u8, 5u8, 125u8, 46u8,
                            34u8, 242u8, 101u8, 15u8, 127u8, 106u8, 146u8, 62u8, 75u8, 251u8,
                            140u8, 136u8, 170u8, 237u8, 41u8, 105u8, 202u8, 162u8, 233u8, 174u8,
                            243u8,
                        ],
                    )
                }
                #[doc = "---- The implementation for the extrinsic unstake_all: Removes all stake from a hotkey account across all subnets and adds it onto a coldkey."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The associated hotkey account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* StakeRemoved;"]
                #[doc = "    - On the successfully removing stake from the hotkey account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `NotRegistered`:"]
                #[doc = "    - Thrown if the account we are attempting to unstake from is non existent."]
                #[doc = ""]
                #[doc = "* `NonAssociatedColdKey`:"]
                #[doc = "    - Thrown if the coldkey does not own the hotkey we are unstaking from."]
                #[doc = ""]
                #[doc = "* `NotEnoughStakeToWithdraw`:"]
                #[doc = "    - Thrown if there is not enough stake on the hotkey to withdraw this amount."]
                #[doc = ""]
                #[doc = "* `TxRateLimitExceeded`:"]
                #[doc = "    - Thrown if key has hit transaction rate limit"]
                pub fn unstake_all(
                    &self,
                    hotkey: types::unstake_all::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::UnstakeAll>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "unstake_all",
                        types::UnstakeAll { hotkey },
                        [
                            6u8, 179u8, 13u8, 170u8, 228u8, 87u8, 90u8, 211u8, 172u8, 136u8, 36u8,
                            255u8, 26u8, 26u8, 247u8, 122u8, 1u8, 23u8, 119u8, 215u8, 238u8, 115u8,
                            250u8, 172u8, 137u8, 152u8, 220u8, 52u8, 126u8, 24u8, 23u8, 141u8,
                        ],
                    )
                }
                #[doc = "---- The implementation for the extrinsic unstake_all: Removes all stake from a hotkey account across all subnets and adds it onto a coldkey."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The associated hotkey account."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* StakeRemoved;"]
                #[doc = "    - On the successfully removing stake from the hotkey account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* `NotRegistered`:"]
                #[doc = "    - Thrown if the account we are attempting to unstake from is non existent."]
                #[doc = ""]
                #[doc = "* `NonAssociatedColdKey`:"]
                #[doc = "    - Thrown if the coldkey does not own the hotkey we are unstaking from."]
                #[doc = ""]
                #[doc = "* `NotEnoughStakeToWithdraw`:"]
                #[doc = "    - Thrown if there is not enough stake on the hotkey to withdraw this amount."]
                #[doc = ""]
                #[doc = "* `TxRateLimitExceeded`:"]
                #[doc = "    - Thrown if key has hit transaction rate limit"]
                pub fn unstake_all_alpha(
                    &self,
                    hotkey: types::unstake_all_alpha::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::UnstakeAllAlpha>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "unstake_all_alpha",
                        types::UnstakeAllAlpha { hotkey },
                        [
                            154u8, 142u8, 32u8, 183u8, 143u8, 119u8, 9u8, 143u8, 204u8, 220u8,
                            41u8, 213u8, 34u8, 206u8, 48u8, 96u8, 37u8, 214u8, 2u8, 95u8, 51u8,
                            11u8, 86u8, 230u8, 149u8, 99u8, 119u8, 251u8, 209u8, 42u8, 85u8, 93u8,
                        ],
                    )
                }
                #[doc = "---- The implementation for the extrinsic move_stake: Moves specified amount of stake from a hotkey to another across subnets."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `origin_hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey account to move stake from."]
                #[doc = ""]
                #[doc = "* `destination_hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey account to move stake to."]
                #[doc = ""]
                #[doc = "* `origin_netuid` (T::AccountId):"]
                #[doc = "    - The subnet ID to move stake from."]
                #[doc = ""]
                #[doc = "* `destination_netuid` (T::AccountId):"]
                #[doc = "    - The subnet ID to move stake to."]
                #[doc = ""]
                #[doc = "* `alpha_amount` (T::AccountId):"]
                #[doc = "    - The alpha stake amount to move."]
                #[doc = ""]
                pub fn move_stake(
                    &self,
                    origin_hotkey: types::move_stake::OriginHotkey,
                    destination_hotkey: types::move_stake::DestinationHotkey,
                    origin_netuid: types::move_stake::OriginNetuid,
                    destination_netuid: types::move_stake::DestinationNetuid,
                    alpha_amount: types::move_stake::AlphaAmount,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::MoveStake>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "move_stake",
                        types::MoveStake {
                            origin_hotkey,
                            destination_hotkey,
                            origin_netuid,
                            destination_netuid,
                            alpha_amount,
                        },
                        [
                            80u8, 176u8, 34u8, 148u8, 176u8, 38u8, 6u8, 93u8, 82u8, 93u8, 86u8,
                            249u8, 78u8, 87u8, 103u8, 183u8, 197u8, 161u8, 215u8, 23u8, 248u8,
                            72u8, 86u8, 58u8, 162u8, 156u8, 101u8, 2u8, 107u8, 219u8, 108u8, 249u8,
                        ],
                    )
                }
                #[doc = "Transfers a specified amount of stake from one coldkey to another, optionally across subnets,"]
                #[doc = "while keeping the same hotkey."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the `origin_coldkey`."]
                #[doc = "* `destination_coldkey` - The coldkey to which the stake is transferred."]
                #[doc = "* `hotkey` - The hotkey associated with the stake."]
                #[doc = "* `origin_netuid` - The network/subnet ID to move stake from."]
                #[doc = "* `destination_netuid` - The network/subnet ID to move stake to (for cross-subnet transfer)."]
                #[doc = "* `alpha_amount` - The amount of stake to transfer."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The origin is not signed by the correct coldkey."]
                #[doc = "* Either subnet does not exist."]
                #[doc = "* The hotkey does not exist."]
                #[doc = "* There is insufficient stake on `(origin_coldkey, hotkey, origin_netuid)`."]
                #[doc = "* The transfer amount is below the minimum stake requirement."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "May emit a `StakeTransferred` event on success."]
                pub fn transfer_stake(
                    &self,
                    destination_coldkey: types::transfer_stake::DestinationColdkey,
                    hotkey: types::transfer_stake::Hotkey,
                    origin_netuid: types::transfer_stake::OriginNetuid,
                    destination_netuid: types::transfer_stake::DestinationNetuid,
                    alpha_amount: types::transfer_stake::AlphaAmount,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::TransferStake>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "transfer_stake",
                        types::TransferStake {
                            destination_coldkey,
                            hotkey,
                            origin_netuid,
                            destination_netuid,
                            alpha_amount,
                        },
                        [
                            76u8, 95u8, 121u8, 127u8, 46u8, 25u8, 21u8, 29u8, 168u8, 194u8, 198u8,
                            21u8, 135u8, 12u8, 207u8, 235u8, 129u8, 228u8, 54u8, 37u8, 129u8, 13u8,
                            127u8, 186u8, 78u8, 17u8, 139u8, 40u8, 71u8, 149u8, 234u8, 252u8,
                        ],
                    )
                }
                #[doc = "Swaps a specified amount of stake from one subnet to another, while keeping the same coldkey and hotkey."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the coldkey that owns the `hotkey`."]
                #[doc = "* `hotkey` - The hotkey whose stake is being swapped."]
                #[doc = "* `origin_netuid` - The network/subnet ID from which stake is removed."]
                #[doc = "* `destination_netuid` - The network/subnet ID to which stake is added."]
                #[doc = "* `alpha_amount` - The amount of stake to swap."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The transaction is not signed by the correct coldkey (i.e., `coldkey_owns_hotkey` fails)."]
                #[doc = "* Either `origin_netuid` or `destination_netuid` does not exist."]
                #[doc = "* The hotkey does not exist."]
                #[doc = "* There is insufficient stake on `(coldkey, hotkey, origin_netuid)`."]
                #[doc = "* The swap amount is below the minimum stake requirement."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "May emit a `StakeSwapped` event on success."]
                pub fn swap_stake(
                    &self,
                    hotkey: types::swap_stake::Hotkey,
                    origin_netuid: types::swap_stake::OriginNetuid,
                    destination_netuid: types::swap_stake::DestinationNetuid,
                    alpha_amount: types::swap_stake::AlphaAmount,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SwapStake>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "swap_stake",
                        types::SwapStake {
                            hotkey,
                            origin_netuid,
                            destination_netuid,
                            alpha_amount,
                        },
                        [
                            5u8, 200u8, 231u8, 57u8, 110u8, 203u8, 149u8, 125u8, 180u8, 132u8,
                            103u8, 67u8, 247u8, 152u8, 175u8, 36u8, 253u8, 234u8, 194u8, 157u8,
                            61u8, 159u8, 176u8, 172u8, 238u8, 137u8, 38u8, 98u8, 108u8, 94u8,
                            234u8, 13u8,
                        ],
                    )
                }
                #[doc = "--- Adds stake to a hotkey on a subnet with a price limit."]
                #[doc = "This extrinsic allows to specify the limit price for alpha token"]
                #[doc = "at which or better (lower) the staking should execute."]
                #[doc = ""]
                #[doc = "In case if slippage occurs and the price shall move beyond the limit"]
                #[doc = "price, the staking order may execute only partially or not execute"]
                #[doc = "at all."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = " * 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = " * 'hotkey' (T::AccountId):"]
                #[doc = "\t- The associated hotkey account."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "    - Subnetwork UID"]
                #[doc = ""]
                #[doc = " * 'amount_staked' (u64):"]
                #[doc = "\t- The amount of stake to be added to the hotkey staking account."]
                #[doc = ""]
                #[doc = " * 'limit_price' (u64):"]
                #[doc = "\t- The limit price expressed in units of RAO per one Alpha."]
                #[doc = ""]
                #[doc = " * 'allow_partial' (bool):"]
                #[doc = "\t- Allows partial execution of the amount. If set to false, this becomes"]
                #[doc = "      fill or kill type or order."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = " * StakeAdded;"]
                #[doc = "\t- On the successfully adding stake to a global account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = " * 'NotEnoughBalanceToStake':"]
                #[doc = "\t- Not enough balance on the coldkey to add onto the global account."]
                #[doc = ""]
                #[doc = " * 'NonAssociatedColdKey':"]
                #[doc = "\t- The calling coldkey is not associated with this hotkey."]
                #[doc = ""]
                #[doc = " * 'BalanceWithdrawalError':"]
                #[doc = " \t- Errors stemming from transaction pallet."]
                #[doc = ""]
                pub fn add_stake_limit(
                    &self,
                    hotkey: types::add_stake_limit::Hotkey,
                    netuid: types::add_stake_limit::Netuid,
                    amount_staked: types::add_stake_limit::AmountStaked,
                    limit_price: types::add_stake_limit::LimitPrice,
                    allow_partial: types::add_stake_limit::AllowPartial,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::AddStakeLimit>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "add_stake_limit",
                        types::AddStakeLimit {
                            hotkey,
                            netuid,
                            amount_staked,
                            limit_price,
                            allow_partial,
                        },
                        [
                            55u8, 119u8, 162u8, 204u8, 181u8, 201u8, 159u8, 232u8, 32u8, 223u8,
                            137u8, 96u8, 21u8, 174u8, 227u8, 161u8, 79u8, 71u8, 240u8, 172u8,
                            124u8, 16u8, 59u8, 165u8, 67u8, 254u8, 48u8, 60u8, 199u8, 160u8, 71u8,
                            165u8,
                        ],
                    )
                }
                #[doc = "--- Removes stake from a hotkey on a subnet with a price limit."]
                #[doc = "This extrinsic allows to specify the limit price for alpha token"]
                #[doc = "at which or better (higher) the staking should execute."]
                #[doc = ""]
                #[doc = "In case if slippage occurs and the price shall move beyond the limit"]
                #[doc = "price, the staking order may execute only partially or not execute"]
                #[doc = "at all."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* 'origin': (<T as frame_system::Config>Origin):"]
                #[doc = "\t- The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* 'hotkey' (T::AccountId):"]
                #[doc = "\t- The associated hotkey account."]
                #[doc = ""]
                #[doc = "* 'netuid' (u16):"]
                #[doc = "    - Subnetwork UID"]
                #[doc = ""]
                #[doc = "* 'amount_unstaked' (u64):"]
                #[doc = "\t- The amount of stake to be added to the hotkey staking account."]
                #[doc = ""]
                #[doc = " * 'limit_price' (u64):"]
                #[doc = "    - The limit price expressed in units of RAO per one Alpha."]
                #[doc = ""]
                #[doc = " * 'allow_partial' (bool):"]
                #[doc = "    - Allows partial execution of the amount. If set to false, this becomes"]
                #[doc = "      fill or kill type or order."]
                #[doc = ""]
                #[doc = "# Event:"]
                #[doc = "* StakeRemoved;"]
                #[doc = "\t- On the successfully removing stake from the hotkey account."]
                #[doc = ""]
                #[doc = "# Raises:"]
                #[doc = "* 'NotRegistered':"]
                #[doc = "\t- Thrown if the account we are attempting to unstake from is non existent."]
                #[doc = ""]
                #[doc = "* 'NonAssociatedColdKey':"]
                #[doc = "\t- Thrown if the coldkey does not own the hotkey we are unstaking from."]
                #[doc = ""]
                #[doc = "* 'NotEnoughStakeToWithdraw':"]
                #[doc = "\t- Thrown if there is not enough stake on the hotkey to withdwraw this amount."]
                #[doc = ""]
                pub fn remove_stake_limit(
                    &self,
                    hotkey: types::remove_stake_limit::Hotkey,
                    netuid: types::remove_stake_limit::Netuid,
                    amount_unstaked: types::remove_stake_limit::AmountUnstaked,
                    limit_price: types::remove_stake_limit::LimitPrice,
                    allow_partial: types::remove_stake_limit::AllowPartial,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::RemoveStakeLimit>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "remove_stake_limit",
                        types::RemoveStakeLimit {
                            hotkey,
                            netuid,
                            amount_unstaked,
                            limit_price,
                            allow_partial,
                        },
                        [
                            59u8, 225u8, 129u8, 72u8, 112u8, 149u8, 9u8, 240u8, 43u8, 153u8, 85u8,
                            178u8, 199u8, 31u8, 36u8, 153u8, 179u8, 180u8, 213u8, 115u8, 153u8,
                            75u8, 96u8, 31u8, 35u8, 245u8, 233u8, 36u8, 26u8, 113u8, 117u8, 157u8,
                        ],
                    )
                }
                #[doc = "Swaps a specified amount of stake from one subnet to another, while keeping the same coldkey and hotkey."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the coldkey that owns the `hotkey`."]
                #[doc = "* `hotkey` - The hotkey whose stake is being swapped."]
                #[doc = "* `origin_netuid` - The network/subnet ID from which stake is removed."]
                #[doc = "* `destination_netuid` - The network/subnet ID to which stake is added."]
                #[doc = "* `alpha_amount` - The amount of stake to swap."]
                #[doc = "* `limit_price` - The limit price expressed in units of RAO per one Alpha."]
                #[doc = "* `allow_partial` - Allows partial execution of the amount. If set to false, this becomes fill or kill type or order."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The transaction is not signed by the correct coldkey (i.e., `coldkey_owns_hotkey` fails)."]
                #[doc = "* Either `origin_netuid` or `destination_netuid` does not exist."]
                #[doc = "* The hotkey does not exist."]
                #[doc = "* There is insufficient stake on `(coldkey, hotkey, origin_netuid)`."]
                #[doc = "* The swap amount is below the minimum stake requirement."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "May emit a `StakeSwapped` event on success."]
                pub fn swap_stake_limit(
                    &self,
                    hotkey: types::swap_stake_limit::Hotkey,
                    origin_netuid: types::swap_stake_limit::OriginNetuid,
                    destination_netuid: types::swap_stake_limit::DestinationNetuid,
                    alpha_amount: types::swap_stake_limit::AlphaAmount,
                    limit_price: types::swap_stake_limit::LimitPrice,
                    allow_partial: types::swap_stake_limit::AllowPartial,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::SwapStakeLimit>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "swap_stake_limit",
                        types::SwapStakeLimit {
                            hotkey,
                            origin_netuid,
                            destination_netuid,
                            alpha_amount,
                            limit_price,
                            allow_partial,
                        },
                        [
                            173u8, 145u8, 7u8, 70u8, 213u8, 178u8, 149u8, 157u8, 158u8, 173u8,
                            251u8, 93u8, 1u8, 46u8, 255u8, 39u8, 55u8, 66u8, 153u8, 147u8, 144u8,
                            218u8, 93u8, 53u8, 165u8, 156u8, 196u8, 17u8, 174u8, 138u8, 148u8,
                            91u8,
                        ],
                    )
                }
                #[doc = "Attempts to associate a hotkey with a coldkey."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the coldkey that owns the `hotkey`."]
                #[doc = "* `hotkey` - The hotkey to associate with the coldkey."]
                #[doc = ""]
                #[doc = "# Note"]
                #[doc = "Will charge based on the weight even if the hotkey is already associated with a coldkey."]
                pub fn try_associate_hotkey(
                    &self,
                    hotkey: types::try_associate_hotkey::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::TryAssociateHotkey>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "try_associate_hotkey",
                        types::TryAssociateHotkey { hotkey },
                        [
                            212u8, 87u8, 45u8, 211u8, 243u8, 195u8, 169u8, 16u8, 19u8, 100u8, 14u8,
                            250u8, 14u8, 45u8, 182u8, 7u8, 193u8, 14u8, 184u8, 161u8, 10u8, 42u8,
                            59u8, 227u8, 209u8, 24u8, 164u8, 216u8, 115u8, 145u8, 214u8, 187u8,
                        ],
                    )
                }
                #[doc = "Initiates a call on a subnet."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the call, which must be signed by the subnet owner."]
                #[doc = "* `netuid` - The unique identifier of the subnet on which the call is being initiated."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "Emits a `FirstEmissionBlockNumberSet` event on success."]
                pub fn start_call(
                    &self,
                    netuid: types::start_call::Netuid,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::StartCall>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "start_call",
                        types::StartCall { netuid },
                        [
                            238u8, 117u8, 50u8, 112u8, 77u8, 220u8, 171u8, 204u8, 228u8, 188u8,
                            158u8, 42u8, 164u8, 105u8, 112u8, 208u8, 206u8, 122u8, 242u8, 83u8,
                            241u8, 118u8, 235u8, 154u8, 84u8, 242u8, 236u8, 88u8, 211u8, 151u8,
                            93u8, 212u8,
                        ],
                    )
                }
                #[doc = "Attempts to associate a hotkey with an EVM key."]
                #[doc = ""]
                #[doc = "The signature will be checked to see if the recovered public key matches the `evm_key` provided."]
                #[doc = ""]
                #[doc = "The EVM key is expected to sign the message according to this formula to produce the signature:"]
                #[doc = "```text"]
                #[doc = "keccak_256(hotkey ++ keccak_256(block_number))"]
                #[doc = "```"]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the transaction, which must be signed by the coldkey that owns the `hotkey`."]
                #[doc = "* `netuid` - The netuid that the `hotkey` belongs to."]
                #[doc = "* `hotkey` - The hotkey associated with the `origin`."]
                #[doc = "* `evm_key` - The EVM key to associate with the `hotkey`."]
                #[doc = "* `block_number` - The block number used in the `signature`."]
                #[doc = "* `signature` - A signed message by the `evm_key` containing the `hotkey` and the hashed `block_number`."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The transaction is not signed."]
                #[doc = "* The hotkey is not owned by the origin coldkey."]
                #[doc = "* The hotkey does not belong to the subnet identified by the netuid."]
                #[doc = "* The EVM key cannot be recovered from the signature."]
                #[doc = "* The EVM key recovered from the signature does not match the given EVM key."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "May emit a `EvmKeyAssociated` event on success"]
                pub fn associate_evm_key(
                    &self,
                    netuid: types::associate_evm_key::Netuid,
                    evm_key: types::associate_evm_key::EvmKey,
                    block_number: types::associate_evm_key::BlockNumber,
                    signature: types::associate_evm_key::Signature,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::AssociateEvmKey>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "associate_evm_key",
                        types::AssociateEvmKey {
                            netuid,
                            evm_key,
                            block_number,
                            signature,
                        },
                        [
                            32u8, 123u8, 51u8, 207u8, 109u8, 240u8, 44u8, 243u8, 193u8, 35u8,
                            218u8, 147u8, 113u8, 185u8, 245u8, 76u8, 218u8, 57u8, 71u8, 123u8,
                            176u8, 178u8, 122u8, 28u8, 248u8, 206u8, 215u8, 246u8, 6u8, 81u8, 60u8,
                            73u8,
                        ],
                    )
                }
                #[doc = "Recycles alpha from a cold/hot key pair, reducing AlphaOut on a subnet"]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the call (must be signed by the coldkey)"]
                #[doc = "* `hotkey` - The hotkey account"]
                #[doc = "* `amount` - The amount of alpha to recycle"]
                #[doc = "* `netuid` - The subnet ID"]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "Emits a `TokensRecycled` event on success."]
                pub fn recycle_alpha(
                    &self,
                    hotkey: types::recycle_alpha::Hotkey,
                    amount: types::recycle_alpha::Amount,
                    netuid: types::recycle_alpha::Netuid,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::RecycleAlpha>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "recycle_alpha",
                        types::RecycleAlpha {
                            hotkey,
                            amount,
                            netuid,
                        },
                        [
                            33u8, 136u8, 195u8, 76u8, 91u8, 120u8, 236u8, 22u8, 172u8, 152u8, 47u8,
                            111u8, 118u8, 113u8, 48u8, 131u8, 63u8, 242u8, 30u8, 26u8, 115u8, 82u8,
                            136u8, 14u8, 167u8, 193u8, 48u8, 203u8, 4u8, 15u8, 193u8, 79u8,
                        ],
                    )
                }
                #[doc = "Burns alpha from a cold/hot key pair without reducing `AlphaOut`"]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the call (must be signed by the coldkey)"]
                #[doc = "* `hotkey` - The hotkey account"]
                #[doc = "* `amount` - The amount of alpha to burn"]
                #[doc = "* `netuid` - The subnet ID"]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "Emits a `TokensBurned` event on success."]
                pub fn burn_alpha(
                    &self,
                    hotkey: types::burn_alpha::Hotkey,
                    amount: types::burn_alpha::Amount,
                    netuid: types::burn_alpha::Netuid,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::BurnAlpha>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "burn_alpha",
                        types::BurnAlpha {
                            hotkey,
                            amount,
                            netuid,
                        },
                        [
                            150u8, 162u8, 154u8, 19u8, 31u8, 127u8, 112u8, 63u8, 140u8, 186u8,
                            152u8, 175u8, 226u8, 182u8, 68u8, 21u8, 166u8, 111u8, 227u8, 215u8,
                            70u8, 44u8, 135u8, 50u8, 183u8, 255u8, 226u8, 103u8, 184u8, 194u8,
                            52u8, 114u8,
                        ],
                    )
                }
                #[doc = "Sets the pending childkey cooldown (in blocks). Root only."]
                pub fn set_pending_childkey_cooldown(
                    &self,
                    cooldown: types::set_pending_childkey_cooldown::Cooldown,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::SetPendingChildkeyCooldown,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "set_pending_childkey_cooldown",
                        types::SetPendingChildkeyCooldown { cooldown },
                        [
                            84u8, 127u8, 99u8, 184u8, 8u8, 38u8, 140u8, 140u8, 44u8, 209u8, 170u8,
                            22u8, 9u8, 130u8, 140u8, 168u8, 227u8, 136u8, 92u8, 172u8, 39u8, 10u8,
                            235u8, 141u8, 52u8, 64u8, 216u8, 14u8, 43u8, 86u8, 192u8, 117u8,
                        ],
                    )
                }
                #[doc = "Removes all stake from a hotkey on a subnet with a price limit."]
                #[doc = "This extrinsic allows to specify the limit price for alpha token"]
                #[doc = "at which or better (higher) the staking should execute."]
                #[doc = "Without limit_price it remove all the stake similar to `remove_stake` extrinsic"]
                pub fn remove_stake_full_limit(
                    &self,
                    hotkey: types::remove_stake_full_limit::Hotkey,
                    netuid: types::remove_stake_full_limit::Netuid,
                    limit_price: types::remove_stake_full_limit::LimitPrice,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::RemoveStakeFullLimit>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "remove_stake_full_limit",
                        types::RemoveStakeFullLimit {
                            hotkey,
                            netuid,
                            limit_price,
                        },
                        [
                            228u8, 64u8, 65u8, 13u8, 154u8, 12u8, 4u8, 110u8, 46u8, 253u8, 209u8,
                            55u8, 56u8, 51u8, 221u8, 240u8, 46u8, 70u8, 9u8, 98u8, 88u8, 155u8,
                            173u8, 111u8, 181u8, 188u8, 216u8, 133u8, 39u8, 199u8, 146u8, 58u8,
                        ],
                    )
                }
                #[doc = "Register a new leased network."]
                #[doc = ""]
                #[doc = "The crowdloan's contributions are used to compute the share of the emissions that the contributors"]
                #[doc = "will receive as dividends."]
                #[doc = ""]
                #[doc = "The leftover cap is refunded to the contributors and the beneficiary."]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `emissions_share` (Percent):"]
                #[doc = "    - The share of the emissions that the contributors will receive as dividends."]
                #[doc = ""]
                #[doc = "* `end_block` (Option<BlockNumberFor<T>>):"]
                #[doc = "    - The block at which the lease will end. If not defined, the lease is perpetual."]
                pub fn register_leased_network(
                    &self,
                    emissions_share: types::register_leased_network::EmissionsShare,
                    end_block: types::register_leased_network::EndBlock,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<
                    types::RegisterLeasedNetwork,
                > {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "register_leased_network",
                        types::RegisterLeasedNetwork {
                            emissions_share,
                            end_block,
                        },
                        [
                            91u8, 194u8, 226u8, 243u8, 136u8, 58u8, 202u8, 189u8, 62u8, 222u8,
                            24u8, 245u8, 58u8, 27u8, 49u8, 136u8, 242u8, 148u8, 54u8, 54u8, 113u8,
                            211u8, 148u8, 44u8, 182u8, 25u8, 147u8, 131u8, 130u8, 10u8, 9u8, 116u8,
                        ],
                    )
                }
                #[doc = "Terminate a lease."]
                #[doc = ""]
                #[doc = "The beneficiary can terminate the lease after the end block has passed and get the subnet ownership."]
                #[doc = "The subnet is transferred to the beneficiary and the lease is removed from storage."]
                #[doc = ""]
                #[doc = "**The hotkey must be owned by the beneficiary coldkey.**"]
                #[doc = ""]
                #[doc = "# Args:"]
                #[doc = "* `origin` - (<T as frame_system::Config>::Origin):"]
                #[doc = "    - The signature of the caller's coldkey."]
                #[doc = ""]
                #[doc = "* `lease_id` (LeaseId):"]
                #[doc = "    - The ID of the lease to terminate."]
                #[doc = ""]
                #[doc = "* `hotkey` (T::AccountId):"]
                #[doc = "    - The hotkey of the beneficiary to mark as subnet owner hotkey."]
                pub fn terminate_lease(
                    &self,
                    lease_id: types::terminate_lease::LeaseId,
                    hotkey: types::terminate_lease::Hotkey,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::TerminateLease>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "terminate_lease",
                        types::TerminateLease { lease_id, hotkey },
                        [
                            217u8, 89u8, 206u8, 150u8, 243u8, 76u8, 153u8, 242u8, 33u8, 43u8, 81u8,
                            149u8, 204u8, 206u8, 225u8, 159u8, 169u8, 210u8, 133u8, 232u8, 112u8,
                            162u8, 240u8, 188u8, 10u8, 147u8, 66u8, 224u8, 149u8, 176u8, 170u8,
                            132u8,
                        ],
                    )
                }
                #[doc = "Updates the symbol for a subnet."]
                #[doc = ""]
                #[doc = "# Arguments"]
                #[doc = "* `origin` - The origin of the call, which must be the subnet owner or root."]
                #[doc = "* `netuid` - The unique identifier of the subnet on which the symbol is being set."]
                #[doc = "* `symbol` - The symbol to set for the subnet."]
                #[doc = ""]
                #[doc = "# Errors"]
                #[doc = "Returns an error if:"]
                #[doc = "* The transaction is not signed by the subnet owner."]
                #[doc = "* The symbol does not exist."]
                #[doc = "* The symbol is already in use by another subnet."]
                #[doc = ""]
                #[doc = "# Events"]
                #[doc = "Emits a `SymbolUpdated` event on success."]
                pub fn update_symbol(
                    &self,
                    netuid: types::update_symbol::Netuid,
                    symbol: types::update_symbol::Symbol,
                ) -> ::subxt::ext::subxt_core::tx::payload::StaticPayload<types::UpdateSymbol>
                {
                    ::subxt::ext::subxt_core::tx::payload::StaticPayload::new_static(
                        "SubtensorModule",
                        "update_symbol",
                        types::UpdateSymbol { netuid, symbol },
                        [
                            134u8, 241u8, 164u8, 150u8, 185u8, 169u8, 235u8, 10u8, 34u8, 210u8,
                            193u8, 65u8, 223u8, 161u8, 156u8, 231u8, 11u8, 14u8, 158u8, 114u8,
                            218u8, 255u8, 145u8, 212u8, 152u8, 80u8, 107u8, 250u8, 218u8, 212u8,
                            138u8, 194u8,
                        ],
                    )
                }
            }
        }
        #[doc = "The `Event` enum of this pallet"]
        pub type Event = runtime_types::pallet_subtensor::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "a new network is added."]
            pub struct NetworkAdded(pub network_added::Field0, pub network_added::Field1);
            pub mod network_added {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NetworkAdded {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "NetworkAdded";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "a network is removed."]
            pub struct NetworkRemoved(pub network_removed::Field0);
            pub mod network_removed {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NetworkRemoved {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "NetworkRemoved";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "stake has been transferred from the a coldkey account onto the hotkey staking account."]
            pub struct StakeAdded(
                pub stake_added::Field0,
                pub stake_added::Field1,
                pub stake_added::Field2,
                pub stake_added::Field3,
                pub stake_added::Field4,
                pub stake_added::Field5,
            );
            pub mod stake_added {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u64;
                pub type Field3 = ::core::primitive::u64;
                pub type Field4 = ::core::primitive::u16;
                pub type Field5 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for StakeAdded {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "StakeAdded";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "stake has been removed from the hotkey staking account onto the coldkey account."]
            pub struct StakeRemoved(
                pub stake_removed::Field0,
                pub stake_removed::Field1,
                pub stake_removed::Field2,
                pub stake_removed::Field3,
                pub stake_removed::Field4,
                pub stake_removed::Field5,
            );
            pub mod stake_removed {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u64;
                pub type Field3 = ::core::primitive::u64;
                pub type Field4 = ::core::primitive::u16;
                pub type Field5 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for StakeRemoved {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "StakeRemoved";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "stake has been moved from origin (hotkey, subnet ID) to destination (hotkey, subnet ID) of this amount (in TAO)."]
            pub struct StakeMoved(
                pub stake_moved::Field0,
                pub stake_moved::Field1,
                pub stake_moved::Field2,
                pub stake_moved::Field3,
                pub stake_moved::Field4,
                pub stake_moved::Field5,
            );
            pub mod stake_moved {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u16;
                pub type Field3 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field4 = ::core::primitive::u16;
                pub type Field5 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for StakeMoved {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "StakeMoved";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "a caller successfully sets their weights on a subnetwork."]
            pub struct WeightsSet(pub weights_set::Field0, pub weights_set::Field1);
            pub mod weights_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for WeightsSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "WeightsSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "a new neuron account has been registered to the chain."]
            pub struct NeuronRegistered(
                pub neuron_registered::Field0,
                pub neuron_registered::Field1,
                pub neuron_registered::Field2,
            );
            pub mod neuron_registered {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
                pub type Field2 = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NeuronRegistered {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "NeuronRegistered";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "multiple uids have been concurrently registered."]
            pub struct BulkNeuronsRegistered(
                pub bulk_neurons_registered::Field0,
                pub bulk_neurons_registered::Field1,
            );
            pub mod bulk_neurons_registered {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BulkNeuronsRegistered {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BulkNeuronsRegistered";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "FIXME: Not used yet"]
            pub struct BulkBalancesSet(
                pub bulk_balances_set::Field0,
                pub bulk_balances_set::Field1,
            );
            pub mod bulk_balances_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BulkBalancesSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BulkBalancesSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "max allowed uids has been set for a subnetwork."]
            pub struct MaxAllowedUidsSet(
                pub max_allowed_uids_set::Field0,
                pub max_allowed_uids_set::Field1,
            );
            pub mod max_allowed_uids_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MaxAllowedUidsSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MaxAllowedUidsSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the max weight limit has been set for a subnetwork."]
            pub struct MaxWeightLimitSet(
                pub max_weight_limit_set::Field0,
                pub max_weight_limit_set::Field1,
            );
            pub mod max_weight_limit_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MaxWeightLimitSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MaxWeightLimitSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the difficulty has been set for a subnet."]
            pub struct DifficultySet(pub difficulty_set::Field0, pub difficulty_set::Field1);
            pub mod difficulty_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for DifficultySet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "DifficultySet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the adjustment interval is set for a subnet."]
            pub struct AdjustmentIntervalSet(
                pub adjustment_interval_set::Field0,
                pub adjustment_interval_set::Field1,
            );
            pub mod adjustment_interval_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for AdjustmentIntervalSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "AdjustmentIntervalSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "registration per interval is set for a subnet."]
            pub struct RegistrationPerIntervalSet(
                pub registration_per_interval_set::Field0,
                pub registration_per_interval_set::Field1,
            );
            pub mod registration_per_interval_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for RegistrationPerIntervalSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "RegistrationPerIntervalSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "we set max registrations per block."]
            pub struct MaxRegistrationsPerBlockSet(
                pub max_registrations_per_block_set::Field0,
                pub max_registrations_per_block_set::Field1,
            );
            pub mod max_registrations_per_block_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MaxRegistrationsPerBlockSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MaxRegistrationsPerBlockSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "an activity cutoff is set for a subnet."]
            pub struct ActivityCutoffSet(
                pub activity_cutoff_set::Field0,
                pub activity_cutoff_set::Field1,
            );
            pub mod activity_cutoff_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ActivityCutoffSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ActivityCutoffSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Rho value is set."]
            pub struct RhoSet(pub rho_set::Field0, pub rho_set::Field1);
            pub mod rho_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for RhoSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "RhoSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "steepness of the sigmoid used to compute alpha values."]
            pub struct AlphaSigmoidSteepnessSet(
                pub alpha_sigmoid_steepness_set::Field0,
                pub alpha_sigmoid_steepness_set::Field1,
            );
            pub mod alpha_sigmoid_steepness_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::i16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for AlphaSigmoidSteepnessSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "AlphaSigmoidSteepnessSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Kappa is set for a subnet."]
            pub struct KappaSet(pub kappa_set::Field0, pub kappa_set::Field1);
            pub mod kappa_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for KappaSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "KappaSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "minimum allowed weight is set for a subnet."]
            pub struct MinAllowedWeightSet(
                pub min_allowed_weight_set::Field0,
                pub min_allowed_weight_set::Field1,
            );
            pub mod min_allowed_weight_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MinAllowedWeightSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MinAllowedWeightSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the validator pruning length has been set."]
            pub struct ValidatorPruneLenSet(
                pub validator_prune_len_set::Field0,
                pub validator_prune_len_set::Field1,
            );
            pub mod validator_prune_len_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ValidatorPruneLenSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ValidatorPruneLenSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the scaling law power has been set for a subnet."]
            pub struct ScalingLawPowerSet(
                pub scaling_law_power_set::Field0,
                pub scaling_law_power_set::Field1,
            );
            pub mod scaling_law_power_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ScalingLawPowerSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ScalingLawPowerSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "weights set rate limit has been set for a subnet."]
            pub struct WeightsSetRateLimitSet(
                pub weights_set_rate_limit_set::Field0,
                pub weights_set_rate_limit_set::Field1,
            );
            pub mod weights_set_rate_limit_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for WeightsSetRateLimitSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "WeightsSetRateLimitSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "immunity period is set for a subnet."]
            pub struct ImmunityPeriodSet(
                pub immunity_period_set::Field0,
                pub immunity_period_set::Field1,
            );
            pub mod immunity_period_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ImmunityPeriodSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ImmunityPeriodSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "bonds moving average is set for a subnet."]
            pub struct BondsMovingAverageSet(
                pub bonds_moving_average_set::Field0,
                pub bonds_moving_average_set::Field1,
            );
            pub mod bonds_moving_average_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BondsMovingAverageSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BondsMovingAverageSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "bonds penalty is set for a subnet."]
            pub struct BondsPenaltySet(
                pub bonds_penalty_set::Field0,
                pub bonds_penalty_set::Field1,
            );
            pub mod bonds_penalty_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BondsPenaltySet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BondsPenaltySet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "bonds reset is set for a subnet."]
            pub struct BondsResetOnSet(
                pub bonds_reset_on_set::Field0,
                pub bonds_reset_on_set::Field1,
            );
            pub mod bonds_reset_on_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::bool;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BondsResetOnSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BondsResetOnSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting the max number of allowed validators on a subnet."]
            pub struct MaxAllowedValidatorsSet(
                pub max_allowed_validators_set::Field0,
                pub max_allowed_validators_set::Field1,
            );
            pub mod max_allowed_validators_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MaxAllowedValidatorsSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MaxAllowedValidatorsSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the axon server information is added to the network."]
            pub struct AxonServed(pub axon_served::Field0, pub axon_served::Field1);
            pub mod axon_served {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for AxonServed {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "AxonServed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the prometheus server information is added to the network."]
            pub struct PrometheusServed(
                pub prometheus_served::Field0,
                pub prometheus_served::Field1,
            );
            pub mod prometheus_served {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for PrometheusServed {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "PrometheusServed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "a hotkey has become a delegate."]
            pub struct DelegateAdded(
                pub delegate_added::Field0,
                pub delegate_added::Field1,
                pub delegate_added::Field2,
            );
            pub mod delegate_added {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for DelegateAdded {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "DelegateAdded";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the default take is set."]
            pub struct DefaultTakeSet(pub default_take_set::Field0);
            pub mod default_take_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for DefaultTakeSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "DefaultTakeSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "weights version key is set for a network."]
            pub struct WeightsVersionKeySet(
                pub weights_version_key_set::Field0,
                pub weights_version_key_set::Field1,
            );
            pub mod weights_version_key_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for WeightsVersionKeySet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "WeightsVersionKeySet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting min difficulty on a network."]
            pub struct MinDifficultySet(
                pub min_difficulty_set::Field0,
                pub min_difficulty_set::Field1,
            );
            pub mod min_difficulty_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MinDifficultySet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MinDifficultySet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting max difficulty on a network."]
            pub struct MaxDifficultySet(
                pub max_difficulty_set::Field0,
                pub max_difficulty_set::Field1,
            );
            pub mod max_difficulty_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MaxDifficultySet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MaxDifficultySet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting the prometheus serving rate limit."]
            pub struct ServingRateLimitSet(
                pub serving_rate_limit_set::Field0,
                pub serving_rate_limit_set::Field1,
            );
            pub mod serving_rate_limit_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ServingRateLimitSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ServingRateLimitSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting burn on a network."]
            pub struct BurnSet(pub burn_set::Field0, pub burn_set::Field1);
            pub mod burn_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BurnSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BurnSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting max burn on a network."]
            pub struct MaxBurnSet(pub max_burn_set::Field0, pub max_burn_set::Field1);
            pub mod max_burn_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MaxBurnSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MaxBurnSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting min burn on a network."]
            pub struct MinBurnSet(pub min_burn_set::Field0, pub min_burn_set::Field1);
            pub mod min_burn_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MinBurnSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MinBurnSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting the transaction rate limit."]
            pub struct TxRateLimitSet(pub tx_rate_limit_set::Field0);
            pub mod tx_rate_limit_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TxRateLimitSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "TxRateLimitSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting the delegate take transaction rate limit."]
            pub struct TxDelegateTakeRateLimitSet(pub tx_delegate_take_rate_limit_set::Field0);
            pub mod tx_delegate_take_rate_limit_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TxDelegateTakeRateLimitSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "TxDelegateTakeRateLimitSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting the childkey take transaction rate limit."]
            pub struct TxChildKeyTakeRateLimitSet(pub tx_child_key_take_rate_limit_set::Field0);
            pub mod tx_child_key_take_rate_limit_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TxChildKeyTakeRateLimitSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "TxChildKeyTakeRateLimitSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "minimum childkey take set"]
            pub struct MinChildKeyTakeSet(pub min_child_key_take_set::Field0);
            pub mod min_child_key_take_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MinChildKeyTakeSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MinChildKeyTakeSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "maximum childkey take set"]
            pub struct MaxChildKeyTakeSet(pub max_child_key_take_set::Field0);
            pub mod max_child_key_take_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MaxChildKeyTakeSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MaxChildKeyTakeSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "childkey take set"]
            pub struct ChildKeyTakeSet(
                pub child_key_take_set::Field0,
                pub child_key_take_set::Field1,
            );
            pub mod child_key_take_set {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ChildKeyTakeSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ChildKeyTakeSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "a sudo call is done."]
            pub struct Sudid(pub sudid::Field0);
            pub mod sudid {
                use super::runtime_types;
                pub type Field0 =
                    ::core::result::Result<(), runtime_types::sp_runtime::DispatchError>;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Sudid {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "Sudid";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "registration is allowed/disallowed for a subnet."]
            pub struct RegistrationAllowed(
                pub registration_allowed::Field0,
                pub registration_allowed::Field1,
            );
            pub mod registration_allowed {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::bool;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for RegistrationAllowed {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "RegistrationAllowed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "POW registration is allowed/disallowed for a subnet."]
            pub struct PowRegistrationAllowed(
                pub pow_registration_allowed::Field0,
                pub pow_registration_allowed::Field1,
            );
            pub mod pow_registration_allowed {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::bool;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for PowRegistrationAllowed {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "PowRegistrationAllowed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting tempo on a network"]
            pub struct TempoSet(pub tempo_set::Field0, pub tempo_set::Field1);
            pub mod tempo_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TempoSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "TempoSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting the RAO recycled for registration."]
            pub struct RAORecycledForRegistrationSet(
                pub rao_recycled_for_registration_set::Field0,
                pub rao_recycled_for_registration_set::Field1,
            );
            pub mod rao_recycled_for_registration_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for RAORecycledForRegistrationSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "RAORecycledForRegistrationSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "min stake is set for validators to set weights."]
            pub struct StakeThresholdSet(pub stake_threshold_set::Field0);
            pub mod stake_threshold_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for StakeThresholdSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "StakeThresholdSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting the minimum required stake amount for senate registration."]
            pub struct SenateRequiredStakePercentSet(pub senate_required_stake_percent_set::Field0);
            pub mod senate_required_stake_percent_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SenateRequiredStakePercentSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SenateRequiredStakePercentSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "setting the adjustment alpha on a subnet."]
            pub struct AdjustmentAlphaSet(
                pub adjustment_alpha_set::Field0,
                pub adjustment_alpha_set::Field1,
            );
            pub mod adjustment_alpha_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for AdjustmentAlphaSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "AdjustmentAlphaSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the faucet it called on the test net."]
            pub struct Faucet(pub faucet::Field0, pub faucet::Field1);
            pub mod faucet {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for Faucet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "Faucet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the subnet owner cut is set."]
            pub struct SubnetOwnerCutSet(pub subnet_owner_cut_set::Field0);
            pub mod subnet_owner_cut_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SubnetOwnerCutSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SubnetOwnerCutSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the network creation rate limit is set."]
            pub struct NetworkRateLimitSet(pub network_rate_limit_set::Field0);
            pub mod network_rate_limit_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NetworkRateLimitSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "NetworkRateLimitSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the network immunity period is set."]
            pub struct NetworkImmunityPeriodSet(pub network_immunity_period_set::Field0);
            pub mod network_immunity_period_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NetworkImmunityPeriodSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "NetworkImmunityPeriodSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the network minimum locking cost is set."]
            pub struct NetworkMinLockCostSet(pub network_min_lock_cost_set::Field0);
            pub mod network_min_lock_cost_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NetworkMinLockCostSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "NetworkMinLockCostSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the maximum number of subnets is set"]
            #[doc = "the lock cost reduction is set"]
            pub struct NetworkLockCostReductionIntervalSet(
                pub network_lock_cost_reduction_interval_set::Field0,
            );
            pub mod network_lock_cost_reduction_interval_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for NetworkLockCostReductionIntervalSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "NetworkLockCostReductionIntervalSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the take for a delegate is decreased."]
            pub struct TakeDecreased(
                pub take_decreased::Field0,
                pub take_decreased::Field1,
                pub take_decreased::Field2,
            );
            pub mod take_decreased {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TakeDecreased {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "TakeDecreased";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the take for a delegate is increased."]
            pub struct TakeIncreased(
                pub take_increased::Field0,
                pub take_increased::Field1,
                pub take_increased::Field2,
            );
            pub mod take_increased {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TakeIncreased {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "TakeIncreased";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the hotkey is swapped"]
            pub struct HotkeySwapped {
                pub coldkey: hotkey_swapped::Coldkey,
                pub old_hotkey: hotkey_swapped::OldHotkey,
                pub new_hotkey: hotkey_swapped::NewHotkey,
            }
            pub mod hotkey_swapped {
                use super::runtime_types;
                pub type Coldkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type OldHotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type NewHotkey = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for HotkeySwapped {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "HotkeySwapped";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "maximum delegate take is set by sudo/admin transaction"]
            pub struct MaxDelegateTakeSet(pub max_delegate_take_set::Field0);
            pub mod max_delegate_take_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MaxDelegateTakeSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MaxDelegateTakeSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "minimum delegate take is set by sudo/admin transaction"]
            pub struct MinDelegateTakeSet(pub min_delegate_take_set::Field0);
            pub mod min_delegate_take_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for MinDelegateTakeSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "MinDelegateTakeSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "a member of the senate is adjusted"]
            pub struct SenateAdjusted {
                pub old_member: senate_adjusted::OldMember,
                pub new_member: senate_adjusted::NewMember,
            }
            pub mod senate_adjusted {
                use super::runtime_types;
                pub type OldMember =
                    ::core::option::Option<::subxt::ext::subxt_core::utils::AccountId32>;
                pub type NewMember = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SenateAdjusted {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SenateAdjusted";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A coldkey has been swapped"]
            pub struct ColdkeySwapped {
                pub old_coldkey: coldkey_swapped::OldColdkey,
                pub new_coldkey: coldkey_swapped::NewColdkey,
                pub swap_cost: coldkey_swapped::SwapCost,
            }
            pub mod coldkey_swapped {
                use super::runtime_types;
                pub type OldColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type NewColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type SwapCost = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ColdkeySwapped {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ColdkeySwapped";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "All balance of a hotkey has been unstaked and transferred to a new coldkey"]
            pub struct AllBalanceUnstakedAndTransferredToNewColdkey {
                pub current_coldkey:
                    all_balance_unstaked_and_transferred_to_new_coldkey::CurrentColdkey,
                pub new_coldkey: all_balance_unstaked_and_transferred_to_new_coldkey::NewColdkey,
                pub total_balance:
                    all_balance_unstaked_and_transferred_to_new_coldkey::TotalBalance,
            }
            pub mod all_balance_unstaked_and_transferred_to_new_coldkey {
                use super::runtime_types;
                pub type CurrentColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type NewColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type TotalBalance = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent
                for AllBalanceUnstakedAndTransferredToNewColdkey
            {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "AllBalanceUnstakedAndTransferredToNewColdkey";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A coldkey swap has been scheduled"]
            pub struct ColdkeySwapScheduled {
                pub old_coldkey: coldkey_swap_scheduled::OldColdkey,
                pub new_coldkey: coldkey_swap_scheduled::NewColdkey,
                pub execution_block: coldkey_swap_scheduled::ExecutionBlock,
                pub swap_cost: coldkey_swap_scheduled::SwapCost,
            }
            pub mod coldkey_swap_scheduled {
                use super::runtime_types;
                pub type OldColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type NewColdkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type ExecutionBlock = ::core::primitive::u32;
                pub type SwapCost = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ColdkeySwapScheduled {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ColdkeySwapScheduled";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The arbitration period has been extended"]
            pub struct ArbitrationPeriodExtended {
                pub coldkey: arbitration_period_extended::Coldkey,
            }
            pub mod arbitration_period_extended {
                use super::runtime_types;
                pub type Coldkey = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ArbitrationPeriodExtended {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ArbitrationPeriodExtended";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Setting of children of a hotkey have been scheduled"]
            pub struct SetChildrenScheduled(
                pub set_children_scheduled::Field0,
                pub set_children_scheduled::Field1,
                pub set_children_scheduled::Field2,
                pub set_children_scheduled::Field3,
            );
            pub mod set_children_scheduled {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::core::primitive::u16;
                pub type Field2 = ::core::primitive::u64;
                pub type Field3 = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                    ::core::primitive::u64,
                    ::subxt::ext::subxt_core::utils::AccountId32,
                )>;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SetChildrenScheduled {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SetChildrenScheduled";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The children of a hotkey have been set"]
            pub struct SetChildren(
                pub set_children::Field0,
                pub set_children::Field1,
                pub set_children::Field2,
            );
            pub mod set_children {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::core::primitive::u16;
                pub type Field2 = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                    ::core::primitive::u64,
                    ::subxt::ext::subxt_core::utils::AccountId32,
                )>;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SetChildren {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SetChildren";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The identity of a coldkey has been set"]
            pub struct ChainIdentitySet(pub chain_identity_set::Field0);
            pub mod chain_identity_set {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ChainIdentitySet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ChainIdentitySet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The identity of a subnet has been set"]
            pub struct SubnetIdentitySet(pub subnet_identity_set::Field0);
            pub mod subnet_identity_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SubnetIdentitySet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SubnetIdentitySet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The identity of a subnet has been removed"]
            pub struct SubnetIdentityRemoved(pub subnet_identity_removed::Field0);
            pub mod subnet_identity_removed {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SubnetIdentityRemoved {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SubnetIdentityRemoved";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A dissolve network extrinsic scheduled."]
            pub struct DissolveNetworkScheduled {
                pub account: dissolve_network_scheduled::Account,
                pub netuid: dissolve_network_scheduled::Netuid,
                pub execution_block: dissolve_network_scheduled::ExecutionBlock,
            }
            pub mod dissolve_network_scheduled {
                use super::runtime_types;
                pub type Account = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Netuid = ::core::primitive::u16;
                pub type ExecutionBlock = ::core::primitive::u32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for DissolveNetworkScheduled {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "DissolveNetworkScheduled";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The duration of schedule coldkey swap has been set"]
            pub struct ColdkeySwapScheduleDurationSet(
                pub coldkey_swap_schedule_duration_set::Field0,
            );
            pub mod coldkey_swap_schedule_duration_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for ColdkeySwapScheduleDurationSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "ColdkeySwapScheduleDurationSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The duration of dissolve network has been set"]
            pub struct DissolveNetworkScheduleDurationSet(
                pub dissolve_network_schedule_duration_set::Field0,
            );
            pub mod dissolve_network_schedule_duration_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for DissolveNetworkScheduleDurationSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "DissolveNetworkScheduleDurationSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Commit-reveal v3 weights have been successfully committed."]
            #[doc = ""]
            #[doc = "- **who**: The account ID of the user committing the weights."]
            #[doc = "- **netuid**: The network identifier."]
            #[doc = "- **commit_hash**: The hash representing the committed weights."]
            pub struct CRV3WeightsCommitted(
                pub crv3_weights_committed::Field0,
                pub crv3_weights_committed::Field1,
                pub crv3_weights_committed::Field2,
            );
            pub mod crv3_weights_committed {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::core::primitive::u16;
                pub type Field2 = ::subxt::ext::subxt_core::utils::H256;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for CRV3WeightsCommitted {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "CRV3WeightsCommitted";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Weights have been successfully committed."]
            #[doc = ""]
            #[doc = "- **who**: The account ID of the user committing the weights."]
            #[doc = "- **netuid**: The network identifier."]
            #[doc = "- **commit_hash**: The hash representing the committed weights."]
            pub struct WeightsCommitted(
                pub weights_committed::Field0,
                pub weights_committed::Field1,
                pub weights_committed::Field2,
            );
            pub mod weights_committed {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::core::primitive::u16;
                pub type Field2 = ::subxt::ext::subxt_core::utils::H256;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for WeightsCommitted {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "WeightsCommitted";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Weights have been successfully revealed."]
            #[doc = ""]
            #[doc = "- **who**: The account ID of the user revealing the weights."]
            #[doc = "- **netuid**: The network identifier."]
            #[doc = "- **commit_hash**: The hash of the revealed weights."]
            pub struct WeightsRevealed(
                pub weights_revealed::Field0,
                pub weights_revealed::Field1,
                pub weights_revealed::Field2,
            );
            pub mod weights_revealed {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::core::primitive::u16;
                pub type Field2 = ::subxt::ext::subxt_core::utils::H256;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for WeightsRevealed {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "WeightsRevealed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Weights have been successfully batch revealed."]
            #[doc = ""]
            #[doc = "- **who**: The account ID of the user revealing the weights."]
            #[doc = "- **netuid**: The network identifier."]
            #[doc = "- **revealed_hashes**: A vector of hashes representing each revealed weight set."]
            pub struct WeightsBatchRevealed(
                pub weights_batch_revealed::Field0,
                pub weights_batch_revealed::Field1,
                pub weights_batch_revealed::Field2,
            );
            pub mod weights_batch_revealed {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::core::primitive::u16;
                pub type Field2 = ::subxt::ext::subxt_core::alloc::vec::Vec<
                    ::subxt::ext::subxt_core::utils::H256,
                >;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for WeightsBatchRevealed {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "WeightsBatchRevealed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A batch of weights (or commits) have been force-set."]
            #[doc = ""]
            #[doc = "- **netuids**: The netuids these weights were successfully set/committed for."]
            #[doc = "- **who**: The hotkey that set this batch."]
            pub struct BatchWeightsCompleted(
                pub batch_weights_completed::Field0,
                pub batch_weights_completed::Field1,
            );
            pub mod batch_weights_completed {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::alloc::vec::Vec<
                    ::subxt::ext::subxt_core::ext::codec::Compact<::core::primitive::u16>,
                >;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BatchWeightsCompleted {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BatchWeightsCompleted";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A batch extrinsic completed but with some errors."]
            pub struct BatchCompletedWithErrors;
            impl ::subxt::ext::subxt_core::events::StaticEvent for BatchCompletedWithErrors {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BatchCompletedWithErrors";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A weight set among a batch of weights failed."]
            #[doc = ""]
            #[doc = "- **error**: The dispatch error emitted by the failed item."]
            pub struct BatchWeightItemFailed(pub batch_weight_item_failed::Field0);
            pub mod batch_weight_item_failed {
                use super::runtime_types;
                pub type Field0 = runtime_types::sp_runtime::DispatchError;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for BatchWeightItemFailed {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "BatchWeightItemFailed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Stake has been transferred from one coldkey to another on the same subnet."]
            #[doc = "Parameters:"]
            #[doc = "(origin_coldkey, destination_coldkey, hotkey, origin_netuid, destination_netuid, amount)"]
            pub struct StakeTransferred(
                pub stake_transferred::Field0,
                pub stake_transferred::Field1,
                pub stake_transferred::Field2,
                pub stake_transferred::Field3,
                pub stake_transferred::Field4,
                pub stake_transferred::Field5,
            );
            pub mod stake_transferred {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field3 = ::core::primitive::u16;
                pub type Field4 = ::core::primitive::u16;
                pub type Field5 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for StakeTransferred {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "StakeTransferred";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Stake has been swapped from one subnet to another for the same coldkey-hotkey pair."]
            #[doc = ""]
            #[doc = "Parameters:"]
            #[doc = "(coldkey, hotkey, origin_netuid, destination_netuid, amount)"]
            pub struct StakeSwapped(
                pub stake_swapped::Field0,
                pub stake_swapped::Field1,
                pub stake_swapped::Field2,
                pub stake_swapped::Field3,
                pub stake_swapped::Field4,
            );
            pub mod stake_swapped {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u16;
                pub type Field3 = ::core::primitive::u16;
                pub type Field4 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for StakeSwapped {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "StakeSwapped";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Event called when transfer is toggled on a subnet."]
            #[doc = ""]
            #[doc = "Parameters:"]
            #[doc = "(netuid, bool)"]
            pub struct TransferToggle(pub transfer_toggle::Field0, pub transfer_toggle::Field1);
            pub mod transfer_toggle {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::bool;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for TransferToggle {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "TransferToggle";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The owner hotkey for a subnet has been set."]
            #[doc = ""]
            #[doc = "Parameters:"]
            #[doc = "(netuid, new_hotkey)"]
            pub struct SubnetOwnerHotkeySet(
                pub subnet_owner_hotkey_set::Field0,
                pub subnet_owner_hotkey_set::Field1,
            );
            pub mod subnet_owner_hotkey_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SubnetOwnerHotkeySet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SubnetOwnerHotkeySet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "FirstEmissionBlockNumber is set via start call extrinsic"]
            #[doc = ""]
            #[doc = "Parameters:"]
            #[doc = "netuid"]
            #[doc = "block number"]
            pub struct FirstEmissionBlockNumberSet(
                pub first_emission_block_number_set::Field0,
                pub first_emission_block_number_set::Field1,
            );
            pub mod first_emission_block_number_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for FirstEmissionBlockNumberSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "FirstEmissionBlockNumberSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Alpha has been recycled, reducing AlphaOut on a subnet."]
            #[doc = ""]
            #[doc = "Parameters:"]
            #[doc = "(coldkey, hotkey, amount, subnet_id)"]
            pub struct AlphaRecycled(
                pub alpha_recycled::Field0,
                pub alpha_recycled::Field1,
                pub alpha_recycled::Field2,
                pub alpha_recycled::Field3,
            );
            pub mod alpha_recycled {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u64;
                pub type Field3 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for AlphaRecycled {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "AlphaRecycled";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Alpha have been burned without reducing AlphaOut."]
            #[doc = ""]
            #[doc = "Parameters:"]
            #[doc = "(coldkey, hotkey, amount, subnet_id)"]
            pub struct AlphaBurned(
                pub alpha_burned::Field0,
                pub alpha_burned::Field1,
                pub alpha_burned::Field2,
                pub alpha_burned::Field3,
            );
            pub mod alpha_burned {
                use super::runtime_types;
                pub type Field0 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Field2 = ::core::primitive::u64;
                pub type Field3 = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for AlphaBurned {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "AlphaBurned";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "An EVM key has been associated with a hotkey."]
            pub struct EvmKeyAssociated {
                pub netuid: evm_key_associated::Netuid,
                pub hotkey: evm_key_associated::Hotkey,
                pub evm_key: evm_key_associated::EvmKey,
                pub block_associated: evm_key_associated::BlockAssociated,
            }
            pub mod evm_key_associated {
                use super::runtime_types;
                pub type Netuid = ::core::primitive::u16;
                pub type Hotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type EvmKey = ::subxt::ext::subxt_core::utils::H160;
                pub type BlockAssociated = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for EvmKeyAssociated {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "EvmKeyAssociated";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "CRV3 Weights have been successfully revealed."]
            #[doc = ""]
            #[doc = "- **netuid**: The network identifier."]
            #[doc = "- **who**: The account ID of the user revealing the weights."]
            pub struct CRV3WeightsRevealed(
                pub crv3_weights_revealed::Field0,
                pub crv3_weights_revealed::Field1,
            );
            pub mod crv3_weights_revealed {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::subxt::ext::subxt_core::utils::AccountId32;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for CRV3WeightsRevealed {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "CRV3WeightsRevealed";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Commit-Reveal periods has been successfully set."]
            #[doc = ""]
            #[doc = "- **netuid**: The network identifier."]
            #[doc = "- **periods**: The number of epochs before the reveal."]
            pub struct CommitRevealPeriodsSet(
                pub commit_reveal_periods_set::Field0,
                pub commit_reveal_periods_set::Field1,
            );
            pub mod commit_reveal_periods_set {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::u64;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for CommitRevealPeriodsSet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "CommitRevealPeriodsSet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "Commit-Reveal has been successfully toggled."]
            #[doc = ""]
            #[doc = "- **netuid**: The network identifier."]
            #[doc = "- **Enabled**: Is Commit-Reveal enabled."]
            pub struct CommitRevealEnabled(
                pub commit_reveal_enabled::Field0,
                pub commit_reveal_enabled::Field1,
            );
            pub mod commit_reveal_enabled {
                use super::runtime_types;
                pub type Field0 = ::core::primitive::u16;
                pub type Field1 = ::core::primitive::bool;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for CommitRevealEnabled {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "CommitRevealEnabled";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "the hotkey is swapped"]
            pub struct HotkeySwappedOnSubnet {
                pub coldkey: hotkey_swapped_on_subnet::Coldkey,
                pub old_hotkey: hotkey_swapped_on_subnet::OldHotkey,
                pub new_hotkey: hotkey_swapped_on_subnet::NewHotkey,
                pub netuid: hotkey_swapped_on_subnet::Netuid,
            }
            pub mod hotkey_swapped_on_subnet {
                use super::runtime_types;
                pub type Coldkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type OldHotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type NewHotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Netuid = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for HotkeySwappedOnSubnet {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "HotkeySwappedOnSubnet";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A subnet lease has been created."]
            pub struct SubnetLeaseCreated {
                pub beneficiary: subnet_lease_created::Beneficiary,
                pub lease_id: subnet_lease_created::LeaseId,
                pub netuid: subnet_lease_created::Netuid,
                pub end_block: subnet_lease_created::EndBlock,
            }
            pub mod subnet_lease_created {
                use super::runtime_types;
                pub type Beneficiary = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type LeaseId = ::core::primitive::u32;
                pub type Netuid = ::core::primitive::u16;
                pub type EndBlock = ::core::option::Option<::core::primitive::u32>;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SubnetLeaseCreated {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SubnetLeaseCreated";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "A subnet lease has been terminated."]
            pub struct SubnetLeaseTerminated {
                pub beneficiary: subnet_lease_terminated::Beneficiary,
                pub netuid: subnet_lease_terminated::Netuid,
            }
            pub mod subnet_lease_terminated {
                use super::runtime_types;
                pub type Beneficiary = ::subxt::ext::subxt_core::utils::AccountId32;
                pub type Netuid = ::core::primitive::u16;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SubnetLeaseTerminated {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SubnetLeaseTerminated";
            }
            #[derive(
                :: subxt :: ext :: subxt_core :: ext :: codec :: Decode,
                :: subxt :: ext :: subxt_core :: ext :: codec :: Encode,
                :: subxt :: ext :: subxt_core :: ext :: scale_decode :: DecodeAsType,
                :: subxt :: ext :: subxt_core :: ext :: scale_encode :: EncodeAsType,
                Clone,
                Debug,
            )]
            # [codec (crate = :: subxt :: ext :: subxt_core :: ext :: codec)]
            #[codec(dumb_trait_bound)]
            #[decode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_decode")]
            #[encode_as_type(crate_path = ":: subxt :: ext :: subxt_core :: ext :: scale_encode")]
            #[doc = "The symbol for a subnet has been updated."]
            pub struct SymbolUpdated {
                pub netuid: symbol_updated::Netuid,
                pub symbol: symbol_updated::Symbol,
            }
            pub mod symbol_updated {
                use super::runtime_types;
                pub type Netuid = ::core::primitive::u16;
                pub type Symbol = ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
            }
            impl ::subxt::ext::subxt_core::events::StaticEvent for SymbolUpdated {
                const PALLET: &'static str = "SubtensorModule";
                const EVENT: &'static str = "SymbolUpdated";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                pub mod min_activity_cutoff {
                    use super::runtime_types;
                    pub type MinActivityCutoff = ::core::primitive::u16;
                }
                pub mod coldkey_swap_schedule_duration {
                    use super::runtime_types;
                    pub type ColdkeySwapScheduleDuration = ::core::primitive::u32;
                }
                pub mod coldkey_swap_reschedule_duration {
                    use super::runtime_types;
                    pub type ColdkeySwapRescheduleDuration = ::core::primitive::u32;
                }
                pub mod dissolve_network_schedule_duration {
                    use super::runtime_types;
                    pub type DissolveNetworkScheduleDuration = ::core::primitive::u32;
                }
                pub mod senate_required_stake_percentage {
                    use super::runtime_types;
                    pub type SenateRequiredStakePercentage = ::core::primitive::u64;
                }
                pub mod last_hotkey_swap_on_netuid {
                    use super::runtime_types;
                    pub type LastHotkeySwapOnNetuid = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod next_stake_job_id {
                    use super::runtime_types;
                    pub type NextStakeJobId = ::core::primitive::u64;
                }
                pub mod tao_weight {
                    use super::runtime_types;
                    pub type TaoWeight = ::core::primitive::u64;
                }
                pub mod max_delegate_take {
                    use super::runtime_types;
                    pub type MaxDelegateTake = ::core::primitive::u16;
                }
                pub mod min_delegate_take {
                    use super::runtime_types;
                    pub type MinDelegateTake = ::core::primitive::u16;
                }
                pub mod max_childkey_take {
                    use super::runtime_types;
                    pub type MaxChildkeyTake = ::core::primitive::u16;
                }
                pub mod min_childkey_take {
                    use super::runtime_types;
                    pub type MinChildkeyTake = ::core::primitive::u16;
                }
                pub mod owner {
                    use super::runtime_types;
                    pub type Owner = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod delegates {
                    use super::runtime_types;
                    pub type Delegates = ::core::primitive::u16;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod childkey_take {
                    use super::runtime_types;
                    pub type ChildkeyTake = ::core::primitive::u16;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod pending_child_keys {
                    use super::runtime_types;
                    pub type PendingChildKeys = (
                        ::subxt::ext::subxt_core::alloc::vec::Vec<(
                            ::core::primitive::u64,
                            ::subxt::ext::subxt_core::utils::AccountId32,
                        )>,
                        ::core::primitive::u64,
                    );
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod child_keys {
                    use super::runtime_types;
                    pub type ChildKeys = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::core::primitive::u64,
                        ::subxt::ext::subxt_core::utils::AccountId32,
                    )>;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod parent_keys {
                    use super::runtime_types;
                    pub type ParentKeys = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::core::primitive::u64,
                        ::subxt::ext::subxt_core::utils::AccountId32,
                    )>;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod alpha_dividends_per_subnet {
                    use super::runtime_types;
                    pub type AlphaDividendsPerSubnet = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod tao_dividends_per_subnet {
                    use super::runtime_types;
                    pub type TaoDividendsPerSubnet = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod block_emission {
                    use super::runtime_types;
                    pub type BlockEmission = ::core::primitive::u64;
                }
                pub mod last_hotkey_emission_on_netuid {
                    use super::runtime_types;
                    pub type LastHotkeyEmissionOnNetuid = ::core::primitive::u64;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod total_issuance {
                    use super::runtime_types;
                    pub type TotalIssuance = ::core::primitive::u64;
                }
                pub mod total_stake {
                    use super::runtime_types;
                    pub type TotalStake = ::core::primitive::u64;
                }
                pub mod subnet_moving_alpha {
                    use super::runtime_types;
                    pub type SubnetMovingAlpha = runtime_types::substrate_fixed::FixedI128<
                        runtime_types::typenum::uint::UInt<
                            runtime_types::typenum::uint::UInt<
                                runtime_types::typenum::uint::UInt<
                                    runtime_types::typenum::uint::UInt<
                                        runtime_types::typenum::uint::UInt<
                                            runtime_types::typenum::uint::UInt<
                                                runtime_types::typenum::uint::UTerm,
                                                runtime_types::typenum::bit::B1,
                                            >,
                                            runtime_types::typenum::bit::B0,
                                        >,
                                        runtime_types::typenum::bit::B0,
                                    >,
                                    runtime_types::typenum::bit::B0,
                                >,
                                runtime_types::typenum::bit::B0,
                            >,
                            runtime_types::typenum::bit::B0,
                        >,
                    >;
                }
                pub mod subnet_moving_price {
                    use super::runtime_types;
                    pub type SubnetMovingPrice = runtime_types::substrate_fixed::FixedI128<
                        runtime_types::typenum::uint::UInt<
                            runtime_types::typenum::uint::UInt<
                                runtime_types::typenum::uint::UInt<
                                    runtime_types::typenum::uint::UInt<
                                        runtime_types::typenum::uint::UInt<
                                            runtime_types::typenum::uint::UInt<
                                                runtime_types::typenum::uint::UTerm,
                                                runtime_types::typenum::bit::B1,
                                            >,
                                            runtime_types::typenum::bit::B0,
                                        >,
                                        runtime_types::typenum::bit::B0,
                                    >,
                                    runtime_types::typenum::bit::B0,
                                >,
                                runtime_types::typenum::bit::B0,
                            >,
                            runtime_types::typenum::bit::B0,
                        >,
                    >;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_volume {
                    use super::runtime_types;
                    pub type SubnetVolume = ::core::primitive::u128;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_tao {
                    use super::runtime_types;
                    pub type SubnetTao = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_tao_provided {
                    use super::runtime_types;
                    pub type SubnetTaoProvided = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_alpha_in_emission {
                    use super::runtime_types;
                    pub type SubnetAlphaInEmission = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_alpha_out_emission {
                    use super::runtime_types;
                    pub type SubnetAlphaOutEmission = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_tao_in_emission {
                    use super::runtime_types;
                    pub type SubnetTaoInEmission = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_alpha_in {
                    use super::runtime_types;
                    pub type SubnetAlphaIn = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_alpha_in_provided {
                    use super::runtime_types;
                    pub type SubnetAlphaInProvided = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_alpha_out {
                    use super::runtime_types;
                    pub type SubnetAlphaOut = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod staking_hotkeys {
                    use super::runtime_types;
                    pub type StakingHotkeys = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                    >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod owned_hotkeys {
                    use super::runtime_types;
                    pub type OwnedHotkeys = ::subxt::ext::subxt_core::alloc::vec::Vec<
                        ::subxt::ext::subxt_core::utils::AccountId32,
                    >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod coldkey_swap_scheduled {
                    use super::runtime_types;
                    pub type ColdkeySwapScheduled = (
                        ::core::primitive::u32,
                        ::subxt::ext::subxt_core::utils::AccountId32,
                    );
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod total_hotkey_alpha {
                    use super::runtime_types;
                    pub type TotalHotkeyAlpha = ::core::primitive::u64;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod total_hotkey_alpha_last_epoch {
                    use super::runtime_types;
                    pub type TotalHotkeyAlphaLastEpoch = ::core::primitive::u64;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod total_hotkey_shares {
                    use super::runtime_types;
                    pub type TotalHotkeyShares = runtime_types::substrate_fixed::FixedU128<
                        runtime_types::typenum::uint::UInt<
                            runtime_types::typenum::uint::UInt<
                                runtime_types::typenum::uint::UInt<
                                    runtime_types::typenum::uint::UInt<
                                        runtime_types::typenum::uint::UInt<
                                            runtime_types::typenum::uint::UInt<
                                                runtime_types::typenum::uint::UInt<
                                                    runtime_types::typenum::uint::UTerm,
                                                    runtime_types::typenum::bit::B1,
                                                >,
                                                runtime_types::typenum::bit::B0,
                                            >,
                                            runtime_types::typenum::bit::B0,
                                        >,
                                        runtime_types::typenum::bit::B0,
                                    >,
                                    runtime_types::typenum::bit::B0,
                                >,
                                runtime_types::typenum::bit::B0,
                            >,
                            runtime_types::typenum::bit::B0,
                        >,
                    >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod alpha {
                    use super::runtime_types;
                    pub type Alpha = runtime_types::substrate_fixed::FixedU128<
                        runtime_types::typenum::uint::UInt<
                            runtime_types::typenum::uint::UInt<
                                runtime_types::typenum::uint::UInt<
                                    runtime_types::typenum::uint::UInt<
                                        runtime_types::typenum::uint::UInt<
                                            runtime_types::typenum::uint::UInt<
                                                runtime_types::typenum::uint::UInt<
                                                    runtime_types::typenum::uint::UTerm,
                                                    runtime_types::typenum::bit::B1,
                                                >,
                                                runtime_types::typenum::bit::B0,
                                            >,
                                            runtime_types::typenum::bit::B0,
                                        >,
                                        runtime_types::typenum::bit::B0,
                                    >,
                                    runtime_types::typenum::bit::B0,
                                >,
                                runtime_types::typenum::bit::B0,
                            >,
                            runtime_types::typenum::bit::B0,
                        >,
                    >;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param2 = ::core::primitive::u16;
                }
                pub mod token_symbol {
                    use super::runtime_types;
                    pub type TokenSymbol =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u8>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod used_work {
                    use super::runtime_types;
                    pub type UsedWork = ::core::primitive::u64;
                    pub type Param0 = [::core::primitive::u8];
                }
                pub mod max_registrations_per_block {
                    use super::runtime_types;
                    pub type MaxRegistrationsPerBlock = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod total_networks {
                    use super::runtime_types;
                    pub type TotalNetworks = ::core::primitive::u16;
                }
                pub mod network_immunity_period {
                    use super::runtime_types;
                    pub type NetworkImmunityPeriod = ::core::primitive::u64;
                }
                pub mod network_last_registered {
                    use super::runtime_types;
                    pub type NetworkLastRegistered = ::core::primitive::u64;
                }
                pub mod network_min_lock_cost {
                    use super::runtime_types;
                    pub type NetworkMinLockCost = ::core::primitive::u64;
                }
                pub mod network_last_lock_cost {
                    use super::runtime_types;
                    pub type NetworkLastLockCost = ::core::primitive::u64;
                }
                pub mod network_lock_reduction_interval {
                    use super::runtime_types;
                    pub type NetworkLockReductionInterval = ::core::primitive::u64;
                }
                pub mod subnet_owner_cut {
                    use super::runtime_types;
                    pub type SubnetOwnerCut = ::core::primitive::u16;
                }
                pub mod network_rate_limit {
                    use super::runtime_types;
                    pub type NetworkRateLimit = ::core::primitive::u64;
                }
                pub mod nominator_min_required_stake {
                    use super::runtime_types;
                    pub type NominatorMinRequiredStake = ::core::primitive::u64;
                }
                pub mod weights_version_key_rate_limit {
                    use super::runtime_types;
                    pub type WeightsVersionKeyRateLimit = ::core::primitive::u64;
                }
                pub mod last_rate_limited_block {
                    use super::runtime_types;
                    pub type LastRateLimitedBlock = ::core::primitive::u64;
                    pub type Param0 = runtime_types::pallet_subtensor::RateLimitKey;
                }
                pub mod transfer_toggle {
                    use super::runtime_types;
                    pub type TransferToggle = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_locked {
                    use super::runtime_types;
                    pub type SubnetLocked = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod largest_locked {
                    use super::runtime_types;
                    pub type LargestLocked = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod tempo {
                    use super::runtime_types;
                    pub type Tempo = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod first_emission_block_number {
                    use super::runtime_types;
                    pub type FirstEmissionBlockNumber = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_mechanism {
                    use super::runtime_types;
                    pub type SubnetMechanism = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnetwork_n {
                    use super::runtime_types;
                    pub type SubnetworkN = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod network_modality {
                    use super::runtime_types;
                    pub type NetworkModality = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod networks_added {
                    use super::runtime_types;
                    pub type NetworksAdded = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod is_network_member {
                    use super::runtime_types;
                    pub type IsNetworkMember = ::core::primitive::bool;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod network_registration_allowed {
                    use super::runtime_types;
                    pub type NetworkRegistrationAllowed = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod network_pow_registration_allowed {
                    use super::runtime_types;
                    pub type NetworkPowRegistrationAllowed = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod network_registered_at {
                    use super::runtime_types;
                    pub type NetworkRegisteredAt = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod pending_emission {
                    use super::runtime_types;
                    pub type PendingEmission = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod pending_root_divs {
                    use super::runtime_types;
                    pub type PendingRootDivs = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod pending_alpha_swapped {
                    use super::runtime_types;
                    pub type PendingAlphaSwapped = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod pending_owner_cut {
                    use super::runtime_types;
                    pub type PendingOwnerCut = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod blocks_since_last_step {
                    use super::runtime_types;
                    pub type BlocksSinceLastStep = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod last_mechansim_step_block {
                    use super::runtime_types;
                    pub type LastMechansimStepBlock = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_owner {
                    use super::runtime_types;
                    pub type SubnetOwner = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_owner_hotkey {
                    use super::runtime_types;
                    pub type SubnetOwnerHotkey = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod serving_rate_limit {
                    use super::runtime_types;
                    pub type ServingRateLimit = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod rho {
                    use super::runtime_types;
                    pub type Rho = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod alpha_sigmoid_steepness {
                    use super::runtime_types;
                    pub type AlphaSigmoidSteepness = ::core::primitive::i16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod kappa {
                    use super::runtime_types;
                    pub type Kappa = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod registrations_this_interval {
                    use super::runtime_types;
                    pub type RegistrationsThisInterval = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod pow_registrations_this_interval {
                    use super::runtime_types;
                    pub type PowRegistrationsThisInterval = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod burn_registrations_this_interval {
                    use super::runtime_types;
                    pub type BurnRegistrationsThisInterval = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod max_allowed_uids {
                    use super::runtime_types;
                    pub type MaxAllowedUids = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod immunity_period {
                    use super::runtime_types;
                    pub type ImmunityPeriod = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod activity_cutoff {
                    use super::runtime_types;
                    pub type ActivityCutoff = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod max_weights_limit {
                    use super::runtime_types;
                    pub type MaxWeightsLimit = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod weights_version_key {
                    use super::runtime_types;
                    pub type WeightsVersionKey = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod min_allowed_weights {
                    use super::runtime_types;
                    pub type MinAllowedWeights = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod max_allowed_validators {
                    use super::runtime_types;
                    pub type MaxAllowedValidators = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod adjustment_interval {
                    use super::runtime_types;
                    pub type AdjustmentInterval = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod bonds_moving_average {
                    use super::runtime_types;
                    pub type BondsMovingAverage = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod bonds_penalty {
                    use super::runtime_types;
                    pub type BondsPenalty = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod bonds_reset_on {
                    use super::runtime_types;
                    pub type BondsResetOn = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod weights_set_rate_limit {
                    use super::runtime_types;
                    pub type WeightsSetRateLimit = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod validator_prune_len {
                    use super::runtime_types;
                    pub type ValidatorPruneLen = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod scaling_law_power {
                    use super::runtime_types;
                    pub type ScalingLawPower = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod target_registrations_per_interval {
                    use super::runtime_types;
                    pub type TargetRegistrationsPerInterval = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod adjustment_alpha {
                    use super::runtime_types;
                    pub type AdjustmentAlpha = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod commit_reveal_weights_enabled {
                    use super::runtime_types;
                    pub type CommitRevealWeightsEnabled = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod burn {
                    use super::runtime_types;
                    pub type Burn = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod difficulty {
                    use super::runtime_types;
                    pub type Difficulty = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod min_burn {
                    use super::runtime_types;
                    pub type MinBurn = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod max_burn {
                    use super::runtime_types;
                    pub type MaxBurn = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod min_difficulty {
                    use super::runtime_types;
                    pub type MinDifficulty = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod max_difficulty {
                    use super::runtime_types;
                    pub type MaxDifficulty = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod last_adjustment_block {
                    use super::runtime_types;
                    pub type LastAdjustmentBlock = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod registrations_this_block {
                    use super::runtime_types;
                    pub type RegistrationsThisBlock = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod ema_price_halving_blocks {
                    use super::runtime_types;
                    pub type EmaPriceHalvingBlocks = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod rao_recycled_for_registration {
                    use super::runtime_types;
                    pub type RaoRecycledForRegistration = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod tx_rate_limit {
                    use super::runtime_types;
                    pub type TxRateLimit = ::core::primitive::u64;
                }
                pub mod tx_delegate_take_rate_limit {
                    use super::runtime_types;
                    pub type TxDelegateTakeRateLimit = ::core::primitive::u64;
                }
                pub mod tx_childkey_take_rate_limit {
                    use super::runtime_types;
                    pub type TxChildkeyTakeRateLimit = ::core::primitive::u64;
                }
                pub mod liquid_alpha_on {
                    use super::runtime_types;
                    pub type LiquidAlphaOn = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod yuma3_on {
                    use super::runtime_types;
                    pub type Yuma3On = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod alpha_values {
                    use super::runtime_types;
                    pub type AlphaValues = (::core::primitive::u16, ::core::primitive::u16);
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subtoken_enabled {
                    use super::runtime_types;
                    pub type SubtokenEnabled = ::core::primitive::bool;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod stake_weight {
                    use super::runtime_types;
                    pub type StakeWeight =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod uids {
                    use super::runtime_types;
                    pub type Uids = ::core::primitive::u16;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod keys {
                    use super::runtime_types;
                    pub type Keys = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod loaded_emission {
                    use super::runtime_types;
                    pub type LoadedEmission = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        ::core::primitive::u64,
                        ::core::primitive::u64,
                    )>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod active {
                    use super::runtime_types;
                    pub type Active =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::bool>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod rank {
                    use super::runtime_types;
                    pub type Rank =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod trust {
                    use super::runtime_types;
                    pub type Trust =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod consensus {
                    use super::runtime_types;
                    pub type Consensus =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod incentive {
                    use super::runtime_types;
                    pub type Incentive =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod dividends {
                    use super::runtime_types;
                    pub type Dividends =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod emission {
                    use super::runtime_types;
                    pub type Emission =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u64>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod last_update {
                    use super::runtime_types;
                    pub type LastUpdate =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u64>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod validator_trust {
                    use super::runtime_types;
                    pub type ValidatorTrust =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod pruning_scores {
                    use super::runtime_types;
                    pub type PruningScores =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::u16>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod validator_permit {
                    use super::runtime_types;
                    pub type ValidatorPermit =
                        ::subxt::ext::subxt_core::alloc::vec::Vec<::core::primitive::bool>;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod weights {
                    use super::runtime_types;
                    pub type Weights = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::core::primitive::u16,
                        ::core::primitive::u16,
                    )>;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod bonds {
                    use super::runtime_types;
                    pub type Bonds = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::core::primitive::u16,
                        ::core::primitive::u16,
                    )>;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod block_at_registration {
                    use super::runtime_types;
                    pub type BlockAtRegistration = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod axons {
                    use super::runtime_types;
                    pub type Axons = runtime_types::pallet_subtensor::pallet::AxonInfo;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod neuron_certificates {
                    use super::runtime_types;
                    pub type NeuronCertificates =
                        runtime_types::pallet_subtensor::pallet::NeuronCertificate;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod prometheus {
                    use super::runtime_types;
                    pub type Prometheus = runtime_types::pallet_subtensor::pallet::PrometheusInfo;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod identities {
                    use super::runtime_types;
                    pub type Identities = runtime_types::pallet_subtensor::pallet::ChainIdentity;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod identities_v2 {
                    use super::runtime_types;
                    pub type IdentitiesV2 =
                        runtime_types::pallet_subtensor::pallet::ChainIdentityV2;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod subnet_identities {
                    use super::runtime_types;
                    pub type SubnetIdentities =
                        runtime_types::pallet_subtensor::pallet::SubnetIdentity;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_identities_v2 {
                    use super::runtime_types;
                    pub type SubnetIdentitiesV2 =
                        runtime_types::pallet_subtensor::pallet::SubnetIdentityV2;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod subnet_identities_v3 {
                    use super::runtime_types;
                    pub type SubnetIdentitiesV3 =
                        runtime_types::pallet_subtensor::pallet::SubnetIdentityV3;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod transaction_key_last_block {
                    use super::runtime_types;
                    pub type TransactionKeyLastBlock = ::core::primitive::u64;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::core::primitive::u16;
                    pub type Param2 = ::core::primitive::u16;
                }
                pub mod last_tx_block {
                    use super::runtime_types;
                    pub type LastTxBlock = ::core::primitive::u64;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod last_tx_block_child_key_take {
                    use super::runtime_types;
                    pub type LastTxBlockChildKeyTake = ::core::primitive::u64;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod last_tx_block_delegate_take {
                    use super::runtime_types;
                    pub type LastTxBlockDelegateTake = ::core::primitive::u64;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod stake_threshold {
                    use super::runtime_types;
                    pub type StakeThreshold = ::core::primitive::u64;
                }
                pub mod weight_commits {
                    use super::runtime_types;
                    pub type WeightCommits = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::subxt::ext::subxt_core::utils::H256,
                        ::core::primitive::u64,
                        ::core::primitive::u64,
                        ::core::primitive::u64,
                    )>;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod crv3_weight_commits {
                    use super::runtime_types;
                    pub type Crv3WeightCommits = ::subxt::ext::subxt_core::alloc::vec::Vec<(
                        ::subxt::ext::subxt_core::utils::AccountId32,
                        runtime_types::bounded_collections::bounded_vec::BoundedVec<
                            ::core::primitive::u8,
                        >,
                        ::core::primitive::u64,
                    )>;
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::core::primitive::u64;
                }
                pub mod reveal_period_epochs {
                    use super::runtime_types;
                    pub type RevealPeriodEpochs = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod last_coldkey_hotkey_stake_block {
                    use super::runtime_types;
                    pub type LastColdkeyHotkeyStakeBlock = ::core::primitive::u64;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod staking_operation_rate_limiter {
                    use super::runtime_types;
                    pub type StakingOperationRateLimiter = ::core::primitive::bool;
                    pub type Param0 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                    pub type Param2 = ::core::primitive::u16;
                }
                pub mod associated_evm_address {
                    use super::runtime_types;
                    pub type AssociatedEvmAddress = (
                        ::subxt::ext::subxt_core::utils::H160,
                        ::core::primitive::u64,
                    );
                    pub type Param0 = ::core::primitive::u16;
                    pub type Param1 = ::core::primitive::u16;
                }
                pub mod subnet_leases {
                    use super::runtime_types;
                    pub type SubnetLeases =
                        runtime_types::pallet_subtensor::subnets::leasing::SubnetLease<
                            ::subxt::ext::subxt_core::utils::AccountId32,
                            ::core::primitive::u32,
                            ::core::primitive::u64,
                        >;
                    pub type Param0 = ::core::primitive::u32;
                }
                pub mod subnet_lease_shares {
                    use super::runtime_types;
                    pub type SubnetLeaseShares = runtime_types::substrate_fixed::FixedU128<
                        runtime_types::typenum::uint::UInt<
                            runtime_types::typenum::uint::UInt<
                                runtime_types::typenum::uint::UInt<
                                    runtime_types::typenum::uint::UInt<
                                        runtime_types::typenum::uint::UInt<
                                            runtime_types::typenum::uint::UInt<
                                                runtime_types::typenum::uint::UInt<
                                                    runtime_types::typenum::uint::UTerm,
                                                    runtime_types::typenum::bit::B1,
                                                >,
                                                runtime_types::typenum::bit::B0,
                                            >,
                                            runtime_types::typenum::bit::B0,
                                        >,
                                        runtime_types::typenum::bit::B0,
                                    >,
                                    runtime_types::typenum::bit::B0,
                                >,
                                runtime_types::typenum::bit::B0,
                            >,
                            runtime_types::typenum::bit::B0,
                        >,
                    >;
                    pub type Param0 = ::core::primitive::u32;
                    pub type Param1 = ::subxt::ext::subxt_core::utils::AccountId32;
                }
                pub mod subnet_uid_to_lease_id {
                    use super::runtime_types;
                    pub type SubnetUidToLeaseId = ::core::primitive::u32;
                    pub type Param0 = ::core::primitive::u16;
                }
                pub mod next_subnet_lease_id {
                    use super::runtime_types;
                    pub type NextSubnetLeaseId = ::core::primitive::u32;
                }
                pub mod accumulated_lease_dividends {
                    use super::runtime_types;
                    pub type AccumulatedLeaseDividends = ::core::primitive::u64;
                    pub type Param0 = ::core::primitive::u32;
                }
                pub mod has_migration_run {
                    use super::runtime_types;
                    pub type HasMigrationRun = ::core::primitive::bool;
                    pub type Param0 = [::core::primitive::u8];
                }
                pub mod pending_child_key_cooldown {
                    use super::runtime_types;
                    pub type PendingChildKeyCooldown = ::core::primitive::u64;
                }
            }
            pub struct StorageApi;
            impl StorageApi {
                pub fn min_activity_cutoff(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::min_activity_cutoff::MinActivityCutoff,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "MinActivityCutoff",
                        (),
                        [
                            21u8, 123u8, 162u8, 205u8, 232u8, 171u8, 55u8, 152u8, 86u8, 37u8, 65u8,
                            186u8, 63u8, 248u8, 155u8, 234u8, 244u8, 180u8, 236u8, 101u8, 64u8,
                            232u8, 43u8, 181u8, 36u8, 18u8, 30u8, 120u8, 210u8, 183u8, 4u8, 82u8,
                        ],
                    )
                }
                pub fn coldkey_swap_schedule_duration(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::coldkey_swap_schedule_duration::ColdkeySwapScheduleDuration,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ColdkeySwapScheduleDuration",
                        (),
                        [
                            135u8, 38u8, 13u8, 187u8, 124u8, 153u8, 35u8, 200u8, 169u8, 106u8,
                            128u8, 162u8, 134u8, 165u8, 63u8, 169u8, 96u8, 65u8, 222u8, 42u8, 31u8,
                            9u8, 12u8, 42u8, 84u8, 13u8, 24u8, 221u8, 186u8, 245u8, 126u8, 4u8,
                        ],
                    )
                }
                pub fn coldkey_swap_reschedule_duration(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::coldkey_swap_reschedule_duration::ColdkeySwapRescheduleDuration,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ColdkeySwapRescheduleDuration",
                        (),
                        [
                            115u8, 173u8, 172u8, 119u8, 70u8, 246u8, 8u8, 217u8, 21u8, 150u8, 24u8,
                            119u8, 201u8, 249u8, 112u8, 200u8, 219u8, 79u8, 187u8, 250u8, 173u8,
                            88u8, 226u8, 50u8, 137u8, 47u8, 51u8, 206u8, 1u8, 187u8, 184u8, 201u8,
                        ],
                    )
                }
                pub fn dissolve_network_schedule_duration(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::dissolve_network_schedule_duration::DissolveNetworkScheduleDuration,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "DissolveNetworkScheduleDuration",
                        (),
                        [
                            211u8, 28u8, 73u8, 53u8, 21u8, 221u8, 68u8, 103u8, 73u8, 81u8, 235u8,
                            185u8, 185u8, 120u8, 64u8, 149u8, 189u8, 49u8, 250u8, 173u8, 74u8,
                            31u8, 228u8, 139u8, 187u8, 6u8, 77u8, 242u8, 15u8, 41u8, 184u8, 27u8,
                        ],
                    )
                }
                pub fn senate_required_stake_percentage(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::senate_required_stake_percentage::SenateRequiredStakePercentage,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "SenateRequiredStakePercentage",
                        (),
                        [
                            113u8, 251u8, 37u8, 5u8, 78u8, 161u8, 44u8, 216u8, 5u8, 216u8, 141u8,
                            243u8, 254u8, 116u8, 149u8, 171u8, 168u8, 21u8, 79u8, 43u8, 40u8, 14u8,
                            30u8, 89u8, 216u8, 35u8, 80u8, 85u8, 17u8, 69u8, 252u8, 232u8,
                        ],
                    )
                }
                #[doc = " --- DMap ( netuid, coldkey ) --> blocknumber | last hotkey swap on network."]
                pub fn last_hotkey_swap_on_netuid_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::last_hotkey_swap_on_netuid::LastHotkeySwapOnNetuid,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "LastHotkeySwapOnNetuid",
                        (),
                        [
                            114u8, 241u8, 130u8, 146u8, 97u8, 174u8, 213u8, 147u8, 4u8, 68u8,
                            221u8, 219u8, 136u8, 199u8, 62u8, 69u8, 243u8, 208u8, 101u8, 234u8,
                            95u8, 167u8, 30u8, 154u8, 6u8, 185u8, 75u8, 247u8, 49u8, 102u8, 10u8,
                            130u8,
                        ],
                    )
                }
                #[doc = " --- DMap ( netuid, coldkey ) --> blocknumber | last hotkey swap on network."]
                pub fn last_hotkey_swap_on_netuid_iter1(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::last_hotkey_swap_on_netuid::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::last_hotkey_swap_on_netuid::Param0,
                    >,
                    types::last_hotkey_swap_on_netuid::LastHotkeySwapOnNetuid,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "LastHotkeySwapOnNetuid",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            114u8, 241u8, 130u8, 146u8, 97u8, 174u8, 213u8, 147u8, 4u8, 68u8,
                            221u8, 219u8, 136u8, 199u8, 62u8, 69u8, 243u8, 208u8, 101u8, 234u8,
                            95u8, 167u8, 30u8, 154u8, 6u8, 185u8, 75u8, 247u8, 49u8, 102u8, 10u8,
                            130u8,
                        ],
                    )
                }
                #[doc = " --- DMap ( netuid, coldkey ) --> blocknumber | last hotkey swap on network."]
                pub fn last_hotkey_swap_on_netuid(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::last_hotkey_swap_on_netuid::Param0>,
                    _1: impl ::core::borrow::Borrow<types::last_hotkey_swap_on_netuid::Param1>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::last_hotkey_swap_on_netuid::Param0,
                        >,
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::last_hotkey_swap_on_netuid::Param1,
                        >,
                    ),
                    types::last_hotkey_swap_on_netuid::LastHotkeySwapOnNetuid,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "LastHotkeySwapOnNetuid",
                        (
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _0.borrow(),
                            ),
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _1.borrow(),
                            ),
                        ),
                        [
                            114u8, 241u8, 130u8, 146u8, 97u8, 174u8, 213u8, 147u8, 4u8, 68u8,
                            221u8, 219u8, 136u8, 199u8, 62u8, 69u8, 243u8, 208u8, 101u8, 234u8,
                            95u8, 167u8, 30u8, 154u8, 6u8, 185u8, 75u8, 247u8, 49u8, 102u8, 10u8,
                            130u8,
                        ],
                    )
                }
                #[doc = " Ensures unique IDs for StakeJobs storage map"]
                pub fn next_stake_job_id(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::next_stake_job_id::NextStakeJobId,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "NextStakeJobId",
                        (),
                        [
                            204u8, 249u8, 198u8, 215u8, 96u8, 117u8, 180u8, 208u8, 179u8, 132u8,
                            75u8, 66u8, 248u8, 86u8, 158u8, 79u8, 214u8, 117u8, 165u8, 204u8, 49u8,
                            87u8, 250u8, 242u8, 242u8, 151u8, 41u8, 28u8, 200u8, 47u8, 30u8, 223u8,
                        ],
                    )
                }
                #[doc = " ============================"]
                #[doc = " ==== Staking Variables ===="]
                #[doc = " ============================"]
                #[doc = " The Subtensor [`TotalIssuance`] represents the total issuance of tokens on the Bittensor network."]
                #[doc = ""]
                #[doc = " It is comprised of three parts:"]
                #[doc = " - The total amount of issued tokens, tracked in the TotalIssuance of the Balances pallet"]
                #[doc = " - The total amount of tokens staked in the system, tracked in [`TotalStake`]"]
                #[doc = " - The total amount of tokens locked up for subnet reg, tracked in [`TotalSubnetLocked`] attained by iterating over subnet lock."]
                #[doc = ""]
                #[doc = " Eventually, Bittensor should migrate to using Holds afterwhich time we will not require this"]
                #[doc = " separate accounting."]
                #[doc = " --- ITEM --> Global weight"]
                pub fn tao_weight(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::tao_weight::TaoWeight,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "TaoWeight",
                        (),
                        [
                            199u8, 31u8, 192u8, 20u8, 182u8, 250u8, 81u8, 63u8, 167u8, 58u8, 238u8,
                            35u8, 220u8, 52u8, 52u8, 197u8, 121u8, 156u8, 186u8, 251u8, 209u8,
                            84u8, 217u8, 107u8, 239u8, 100u8, 188u8, 234u8, 22u8, 119u8, 226u8,
                            47u8,
                        ],
                    )
                }
                #[doc = " --- ITEM ( default_delegate_take )"]
                pub fn max_delegate_take(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::max_delegate_take::MaxDelegateTake,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "MaxDelegateTake",
                        (),
                        [
                            140u8, 164u8, 254u8, 107u8, 142u8, 50u8, 152u8, 230u8, 173u8, 9u8,
                            98u8, 65u8, 238u8, 216u8, 232u8, 162u8, 68u8, 74u8, 9u8, 88u8, 99u8,
                            40u8, 69u8, 238u8, 60u8, 137u8, 184u8, 169u8, 173u8, 29u8, 203u8,
                            190u8,
                        ],
                    )
                }
                #[doc = " --- ITEM ( min_delegate_take )"]
                pub fn min_delegate_take(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::min_delegate_take::MinDelegateTake,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "MinDelegateTake",
                        (),
                        [
                            253u8, 210u8, 73u8, 231u8, 97u8, 29u8, 51u8, 11u8, 3u8, 233u8, 117u8,
                            175u8, 223u8, 31u8, 81u8, 246u8, 186u8, 58u8, 255u8, 62u8, 65u8, 236u8,
                            204u8, 200u8, 42u8, 125u8, 127u8, 209u8, 113u8, 241u8, 165u8, 234u8,
                        ],
                    )
                }
                #[doc = " --- ITEM ( default_childkey_take )"]
                pub fn max_childkey_take(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::max_childkey_take::MaxChildkeyTake,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "MaxChildkeyTake",
                        (),
                        [
                            232u8, 205u8, 201u8, 56u8, 228u8, 129u8, 26u8, 148u8, 26u8, 152u8,
                            98u8, 38u8, 249u8, 185u8, 100u8, 185u8, 221u8, 16u8, 150u8, 192u8,
                            48u8, 103u8, 29u8, 183u8, 241u8, 152u8, 234u8, 210u8, 179u8, 100u8,
                            213u8, 108u8,
                        ],
                    )
                }
                #[doc = " --- ITEM ( min_childkey_take )"]
                pub fn min_childkey_take(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::min_childkey_take::MinChildkeyTake,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "MinChildkeyTake",
                        (),
                        [
                            34u8, 107u8, 136u8, 127u8, 157u8, 247u8, 199u8, 54u8, 84u8, 226u8,
                            206u8, 246u8, 19u8, 95u8, 3u8, 152u8, 190u8, 207u8, 171u8, 143u8,
                            224u8, 125u8, 113u8, 50u8, 201u8, 229u8, 144u8, 172u8, 64u8, 182u8,
                            228u8, 107u8,
                        ],
                    )
                }
                #[doc = " MAP ( hot ) --> cold | Returns the controlling coldkey for a hotkey."]
                pub fn owner_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::owner::Owner,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "Owner",
                        (),
                        [
                            42u8, 187u8, 183u8, 236u8, 168u8, 211u8, 164u8, 206u8, 104u8, 89u8,
                            156u8, 12u8, 1u8, 65u8, 130u8, 16u8, 104u8, 229u8, 168u8, 245u8, 123u8,
                            31u8, 228u8, 72u8, 122u8, 14u8, 38u8, 188u8, 45u8, 35u8, 16u8, 132u8,
                        ],
                    )
                }
                #[doc = " MAP ( hot ) --> cold | Returns the controlling coldkey for a hotkey."]
                pub fn owner(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::owner::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::owner::Param0,
                    >,
                    types::owner::Owner,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "Owner",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            42u8, 187u8, 183u8, 236u8, 168u8, 211u8, 164u8, 206u8, 104u8, 89u8,
                            156u8, 12u8, 1u8, 65u8, 130u8, 16u8, 104u8, 229u8, 168u8, 245u8, 123u8,
                            31u8, 228u8, 72u8, 122u8, 14u8, 38u8, 188u8, 45u8, 35u8, 16u8, 132u8,
                        ],
                    )
                }
                #[doc = " MAP ( hot ) --> take | Returns the hotkey delegation take. And signals that this key is open for delegation."]
                pub fn delegates_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::delegates::Delegates,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "Delegates",
                        (),
                        [
                            44u8, 10u8, 104u8, 255u8, 105u8, 110u8, 131u8, 174u8, 247u8, 100u8,
                            165u8, 220u8, 198u8, 71u8, 212u8, 83u8, 238u8, 109u8, 61u8, 53u8,
                            175u8, 29u8, 233u8, 38u8, 56u8, 76u8, 41u8, 207u8, 169u8, 70u8, 141u8,
                            251u8,
                        ],
                    )
                }
                #[doc = " MAP ( hot ) --> take | Returns the hotkey delegation take. And signals that this key is open for delegation."]
                pub fn delegates(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::delegates::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::delegates::Param0,
                    >,
                    types::delegates::Delegates,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "Delegates",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            44u8, 10u8, 104u8, 255u8, 105u8, 110u8, 131u8, 174u8, 247u8, 100u8,
                            165u8, 220u8, 198u8, 71u8, 212u8, 83u8, 238u8, 109u8, 61u8, 53u8,
                            175u8, 29u8, 233u8, 38u8, 56u8, 76u8, 41u8, 207u8, 169u8, 70u8, 141u8,
                            251u8,
                        ],
                    )
                }
                #[doc = " DMAP ( hot, netuid ) --> take | Returns the hotkey childkey take for a specific subnet"]
                pub fn childkey_take_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::childkey_take::ChildkeyTake,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ChildkeyTake",
                        (),
                        [
                            130u8, 71u8, 111u8, 167u8, 104u8, 2u8, 244u8, 86u8, 145u8, 164u8,
                            235u8, 205u8, 163u8, 63u8, 188u8, 204u8, 147u8, 179u8, 72u8, 153u8,
                            247u8, 116u8, 17u8, 228u8, 121u8, 77u8, 172u8, 133u8, 164u8, 248u8,
                            158u8, 54u8,
                        ],
                    )
                }
                #[doc = " DMAP ( hot, netuid ) --> take | Returns the hotkey childkey take for a specific subnet"]
                pub fn childkey_take_iter1(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::childkey_take::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::childkey_take::Param0,
                    >,
                    types::childkey_take::ChildkeyTake,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ChildkeyTake",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            130u8, 71u8, 111u8, 167u8, 104u8, 2u8, 244u8, 86u8, 145u8, 164u8,
                            235u8, 205u8, 163u8, 63u8, 188u8, 204u8, 147u8, 179u8, 72u8, 153u8,
                            247u8, 116u8, 17u8, 228u8, 121u8, 77u8, 172u8, 133u8, 164u8, 248u8,
                            158u8, 54u8,
                        ],
                    )
                }
                #[doc = " DMAP ( hot, netuid ) --> take | Returns the hotkey childkey take for a specific subnet"]
                pub fn childkey_take(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::childkey_take::Param0>,
                    _1: impl ::core::borrow::Borrow<types::childkey_take::Param1>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::childkey_take::Param0,
                        >,
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::childkey_take::Param1,
                        >,
                    ),
                    types::childkey_take::ChildkeyTake,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ChildkeyTake",
                        (
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _0.borrow(),
                            ),
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _1.borrow(),
                            ),
                        ),
                        [
                            130u8, 71u8, 111u8, 167u8, 104u8, 2u8, 244u8, 86u8, 145u8, 164u8,
                            235u8, 205u8, 163u8, 63u8, 188u8, 204u8, 147u8, 179u8, 72u8, 153u8,
                            247u8, 116u8, 17u8, 228u8, 121u8, 77u8, 172u8, 133u8, 164u8, 248u8,
                            158u8, 54u8,
                        ],
                    )
                }
                #[doc = " DMAP ( netuid, parent ) --> (Vec<(proportion,child)>, cool_down_block)"]
                pub fn pending_child_keys_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::pending_child_keys::PendingChildKeys,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "PendingChildKeys",
                        (),
                        [
                            144u8, 247u8, 102u8, 71u8, 226u8, 120u8, 229u8, 68u8, 86u8, 204u8,
                            239u8, 66u8, 53u8, 93u8, 152u8, 88u8, 94u8, 132u8, 131u8, 112u8, 137u8,
                            189u8, 180u8, 191u8, 98u8, 119u8, 135u8, 244u8, 60u8, 153u8, 127u8,
                            233u8,
                        ],
                    )
                }
                #[doc = " DMAP ( netuid, parent ) --> (Vec<(proportion,child)>, cool_down_block)"]
                pub fn pending_child_keys_iter1(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::pending_child_keys::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::pending_child_keys::Param0,
                    >,
                    types::pending_child_keys::PendingChildKeys,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "PendingChildKeys",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            144u8, 247u8, 102u8, 71u8, 226u8, 120u8, 229u8, 68u8, 86u8, 204u8,
                            239u8, 66u8, 53u8, 93u8, 152u8, 88u8, 94u8, 132u8, 131u8, 112u8, 137u8,
                            189u8, 180u8, 191u8, 98u8, 119u8, 135u8, 244u8, 60u8, 153u8, 127u8,
                            233u8,
                        ],
                    )
                }
                #[doc = " DMAP ( netuid, parent ) --> (Vec<(proportion,child)>, cool_down_block)"]
                pub fn pending_child_keys(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::pending_child_keys::Param0>,
                    _1: impl ::core::borrow::Borrow<types::pending_child_keys::Param1>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::pending_child_keys::Param0,
                        >,
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::pending_child_keys::Param1,
                        >,
                    ),
                    types::pending_child_keys::PendingChildKeys,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "PendingChildKeys",
                        (
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _0.borrow(),
                            ),
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _1.borrow(),
                            ),
                        ),
                        [
                            144u8, 247u8, 102u8, 71u8, 226u8, 120u8, 229u8, 68u8, 86u8, 204u8,
                            239u8, 66u8, 53u8, 93u8, 152u8, 88u8, 94u8, 132u8, 131u8, 112u8, 137u8,
                            189u8, 180u8, 191u8, 98u8, 119u8, 135u8, 244u8, 60u8, 153u8, 127u8,
                            233u8,
                        ],
                    )
                }
                #[doc = " DMAP ( parent, netuid ) --> Vec<(proportion,child)>"]
                pub fn child_keys_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::child_keys::ChildKeys,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ChildKeys",
                        (),
                        [
                            249u8, 196u8, 42u8, 188u8, 225u8, 115u8, 85u8, 228u8, 212u8, 248u8,
                            101u8, 244u8, 223u8, 151u8, 219u8, 128u8, 204u8, 176u8, 52u8, 61u8,
                            59u8, 213u8, 97u8, 8u8, 237u8, 228u8, 39u8, 11u8, 109u8, 141u8, 67u8,
                            46u8,
                        ],
                    )
                }
                #[doc = " DMAP ( parent, netuid ) --> Vec<(proportion,child)>"]
                pub fn child_keys_iter1(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::child_keys::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::child_keys::Param0,
                    >,
                    types::child_keys::ChildKeys,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ChildKeys",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            249u8, 196u8, 42u8, 188u8, 225u8, 115u8, 85u8, 228u8, 212u8, 248u8,
                            101u8, 244u8, 223u8, 151u8, 219u8, 128u8, 204u8, 176u8, 52u8, 61u8,
                            59u8, 213u8, 97u8, 8u8, 237u8, 228u8, 39u8, 11u8, 109u8, 141u8, 67u8,
                            46u8,
                        ],
                    )
                }
                #[doc = " DMAP ( parent, netuid ) --> Vec<(proportion,child)>"]
                pub fn child_keys(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::child_keys::Param0>,
                    _1: impl ::core::borrow::Borrow<types::child_keys::Param1>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::child_keys::Param0,
                        >,
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::child_keys::Param1,
                        >,
                    ),
                    types::child_keys::ChildKeys,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ChildKeys",
                        (
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _0.borrow(),
                            ),
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _1.borrow(),
                            ),
                        ),
                        [
                            249u8, 196u8, 42u8, 188u8, 225u8, 115u8, 85u8, 228u8, 212u8, 248u8,
                            101u8, 244u8, 223u8, 151u8, 219u8, 128u8, 204u8, 176u8, 52u8, 61u8,
                            59u8, 213u8, 97u8, 8u8, 237u8, 228u8, 39u8, 11u8, 109u8, 141u8, 67u8,
                            46u8,
                        ],
                    )
                }
                #[doc = " DMAP ( child, netuid ) --> Vec<(proportion,parent)>"]
                pub fn parent_keys_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::parent_keys::ParentKeys,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ParentKeys",
                        (),
                        [
                            37u8, 132u8, 47u8, 160u8, 174u8, 62u8, 94u8, 18u8, 202u8, 134u8, 247u8,
                            75u8, 69u8, 168u8, 234u8, 174u8, 184u8, 81u8, 240u8, 141u8, 155u8,
                            158u8, 120u8, 153u8, 121u8, 49u8, 217u8, 208u8, 136u8, 15u8, 98u8,
                            246u8,
                        ],
                    )
                }
                #[doc = " DMAP ( child, netuid ) --> Vec<(proportion,parent)>"]
                pub fn parent_keys_iter1(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::parent_keys::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::parent_keys::Param0,
                    >,
                    types::parent_keys::ParentKeys,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ParentKeys",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            37u8, 132u8, 47u8, 160u8, 174u8, 62u8, 94u8, 18u8, 202u8, 134u8, 247u8,
                            75u8, 69u8, 168u8, 234u8, 174u8, 184u8, 81u8, 240u8, 141u8, 155u8,
                            158u8, 120u8, 153u8, 121u8, 49u8, 217u8, 208u8, 136u8, 15u8, 98u8,
                            246u8,
                        ],
                    )
                }
                #[doc = " DMAP ( child, netuid ) --> Vec<(proportion,parent)>"]
                pub fn parent_keys(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::parent_keys::Param0>,
                    _1: impl ::core::borrow::Borrow<types::parent_keys::Param1>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::parent_keys::Param0,
                        >,
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::parent_keys::Param1,
                        >,
                    ),
                    types::parent_keys::ParentKeys,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "ParentKeys",
                        (
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _0.borrow(),
                            ),
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _1.borrow(),
                            ),
                        ),
                        [
                            37u8, 132u8, 47u8, 160u8, 174u8, 62u8, 94u8, 18u8, 202u8, 134u8, 247u8,
                            75u8, 69u8, 168u8, 234u8, 174u8, 184u8, 81u8, 240u8, 141u8, 155u8,
                            158u8, 120u8, 153u8, 121u8, 49u8, 217u8, 208u8, 136u8, 15u8, 98u8,
                            246u8,
                        ],
                    )
                }
                pub fn alpha_dividends_per_subnet_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::alpha_dividends_per_subnet::AlphaDividendsPerSubnet,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "AlphaDividendsPerSubnet",
                        (),
                        [
                            210u8, 6u8, 9u8, 98u8, 110u8, 11u8, 51u8, 135u8, 221u8, 25u8, 71u8,
                            247u8, 215u8, 101u8, 78u8, 209u8, 205u8, 108u8, 219u8, 96u8, 242u8,
                            175u8, 213u8, 210u8, 247u8, 198u8, 175u8, 26u8, 92u8, 146u8, 74u8,
                            32u8,
                        ],
                    )
                }
                pub fn alpha_dividends_per_subnet_iter1(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::alpha_dividends_per_subnet::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::alpha_dividends_per_subnet::Param0,
                    >,
                    types::alpha_dividends_per_subnet::AlphaDividendsPerSubnet,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "AlphaDividendsPerSubnet",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            210u8, 6u8, 9u8, 98u8, 110u8, 11u8, 51u8, 135u8, 221u8, 25u8, 71u8,
                            247u8, 215u8, 101u8, 78u8, 209u8, 205u8, 108u8, 219u8, 96u8, 242u8,
                            175u8, 213u8, 210u8, 247u8, 198u8, 175u8, 26u8, 92u8, 146u8, 74u8,
                            32u8,
                        ],
                    )
                }
                pub fn alpha_dividends_per_subnet(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::alpha_dividends_per_subnet::Param0>,
                    _1: impl ::core::borrow::Borrow<types::alpha_dividends_per_subnet::Param1>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::alpha_dividends_per_subnet::Param0,
                        >,
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::alpha_dividends_per_subnet::Param1,
                        >,
                    ),
                    types::alpha_dividends_per_subnet::AlphaDividendsPerSubnet,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "AlphaDividendsPerSubnet",
                        (
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _0.borrow(),
                            ),
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _1.borrow(),
                            ),
                        ),
                        [
                            210u8, 6u8, 9u8, 98u8, 110u8, 11u8, 51u8, 135u8, 221u8, 25u8, 71u8,
                            247u8, 215u8, 101u8, 78u8, 209u8, 205u8, 108u8, 219u8, 96u8, 242u8,
                            175u8, 213u8, 210u8, 247u8, 198u8, 175u8, 26u8, 92u8, 146u8, 74u8,
                            32u8,
                        ],
                    )
                }
                pub fn tao_dividends_per_subnet_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::tao_dividends_per_subnet::TaoDividendsPerSubnet,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "TaoDividendsPerSubnet",
                        (),
                        [
                            237u8, 228u8, 121u8, 47u8, 9u8, 115u8, 46u8, 200u8, 137u8, 229u8, 86u8,
                            194u8, 20u8, 229u8, 219u8, 35u8, 199u8, 69u8, 155u8, 94u8, 118u8, 41u8,
                            130u8, 226u8, 84u8, 219u8, 177u8, 40u8, 14u8, 67u8, 248u8, 176u8,
                        ],
                    )
                }
                pub fn tao_dividends_per_subnet_iter1(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::tao_dividends_per_subnet::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::tao_dividends_per_subnet::Param0,
                    >,
                    types::tao_dividends_per_subnet::TaoDividendsPerSubnet,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "TaoDividendsPerSubnet",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
                            237u8, 228u8, 121u8, 47u8, 9u8, 115u8, 46u8, 200u8, 137u8, 229u8, 86u8,
                            194u8, 20u8, 229u8, 219u8, 35u8, 199u8, 69u8, 155u8, 94u8, 118u8, 41u8,
                            130u8, 226u8, 84u8, 219u8, 177u8, 40u8, 14u8, 67u8, 248u8, 176u8,
                        ],
                    )
                }
                pub fn tao_dividends_per_subnet(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::tao_dividends_per_subnet::Param0>,
                    _1: impl ::core::borrow::Borrow<types::tao_dividends_per_subnet::Param1>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::tao_dividends_per_subnet::Param0,
                        >,
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                            types::tao_dividends_per_subnet::Param1,
                        >,
                    ),
                    types::tao_dividends_per_subnet::TaoDividendsPerSubnet,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "TaoDividendsPerSubnet",
                        (
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _0.borrow(),
                            ),
                            ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                                _1.borrow(),
                            ),
                        ),
                        [
                            237u8, 228u8, 121u8, 47u8, 9u8, 115u8, 46u8, 200u8, 137u8, 229u8, 86u8,
                            194u8, 20u8, 229u8, 219u8, 35u8, 199u8, 69u8, 155u8, 94u8, 118u8, 41u8,
                            130u8, 226u8, 84u8, 219u8, 177u8, 40u8, 14u8, 67u8, 248u8, 176u8,
                        ],
                    )
                }
                #[doc = " =================="]
                #[doc = " ==== Coinbase ===="]
                #[doc = " =================="]
                #[doc = " --- ITEM ( global_block_emission )"]
                pub fn block_emission(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::block_emission::BlockEmission,
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                    (),
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "BlockEmission",
                        (),
                        [
                            223u8, 151u8, 249u8, 123u8, 202u8, 93u8, 99u8, 232u8, 117u8, 221u8,
                            57u8, 50u8, 104u8, 65u8, 167u8, 199u8, 188u8, 167u8, 146u8, 32u8, 97u8,
                            156u8, 192u8, 88u8, 82u8, 228u8, 88u8, 171u8, 139u8, 207u8, 28u8,
                            183u8,
                        ],
                    )
                }
                #[doc = " --- DMap ( hot, netuid ) --> emission | last hotkey emission on network."]
                pub fn last_hotkey_emission_on_netuid_iter(
                    &self,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    (),
                    types::last_hotkey_emission_on_netuid::LastHotkeyEmissionOnNetuid,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "LastHotkeyEmissionOnNetuid",
                        (),
                        [
                            131u8, 226u8, 245u8, 210u8, 142u8, 247u8, 179u8, 221u8, 115u8, 205u8,
                            126u8, 254u8, 103u8, 117u8, 248u8, 204u8, 59u8, 200u8, 35u8, 106u8,
                            57u8, 88u8, 7u8, 82u8, 142u8, 144u8, 128u8, 43u8, 205u8, 29u8, 130u8,
                            14u8,
                        ],
                    )
                }
                #[doc = " --- DMap ( hot, netuid ) --> emission | last hotkey emission on network."]
                pub fn last_hotkey_emission_on_netuid_iter1(
                    &self,
                    _0: impl ::core::borrow::Borrow<types::last_hotkey_emission_on_netuid::Param0>,
                ) -> ::subxt::ext::subxt_core::storage::address::StaticAddress<
                    ::subxt::ext::subxt_core::storage::address::StaticStorageKey<
                        types::last_hotkey_emission_on_netuid::Param0,
                    >,
                    types::last_hotkey_emission_on_netuid::LastHotkeyEmissionOnNetuid,
                    (),
                    ::subxt::ext::subxt_core::utils::Yes,
                    ::subxt::ext::subxt_core::utils::Yes,
                > {
                    ::subxt::ext::subxt_core::storage::address::StaticAddress::new_static(
                        "SubtensorModule",
                        "LastHotkeyEmissionOnNetuid",
                        ::subxt::ext::subxt_core::storage::address::StaticStorageKey::new(
                            _0.borrow(),
                        ),
                        [
  