// This file is @generated by prost-build.
/// Request to start a new rental
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentalRequest {
    #[prost(string, tag = "1")]
    pub validator_hotkey: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub node_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub container_spec: ::core::option::Option<ContainerSpec>,
    #[prost(int64, tag = "4")]
    pub duration_seconds: i64,
    #[prost(string, tag = "5")]
    pub ssh_public_key: ::prost::alloc::string::String,
    #[prost(string, tag = "6")]
    pub session_token: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "7")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
/// Container specification
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ContainerSpec {
    #[prost(string, tag = "1")]
    pub image: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "2")]
    pub environment: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(message, repeated, tag = "3")]
    pub ports: ::prost::alloc::vec::Vec<PortMapping>,
    #[prost(message, optional, tag = "4")]
    pub resources: ::core::option::Option<ResourceRequirements>,
    #[prost(string, repeated, tag = "5")]
    pub command: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, repeated, tag = "6")]
    pub volumes: ::prost::alloc::vec::Vec<VolumeMount>,
    #[prost(map = "string, string", tag = "7")]
    pub labels: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(string, repeated, tag = "8")]
    pub capabilities: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "9")]
    pub network: ::core::option::Option<NetworkConfig>,
}
/// Port mapping configuration
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PortMapping {
    #[prost(uint32, tag = "1")]
    pub container_port: u32,
    #[prost(uint32, tag = "2")]
    pub host_port: u32,
    /// tcp/udp
    #[prost(string, tag = "3")]
    pub protocol: ::prost::alloc::string::String,
}
/// Resource requirements
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceRequirements {
    #[prost(double, tag = "1")]
    pub cpu_cores: f64,
    #[prost(int64, tag = "2")]
    pub memory_mb: i64,
    #[prost(int64, tag = "3")]
    pub storage_mb: i64,
    #[prost(uint32, tag = "4")]
    pub gpu_count: u32,
    #[prost(string, repeated, tag = "5")]
    pub gpu_types: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// Volume mount configuration
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VolumeMount {
    #[prost(string, tag = "1")]
    pub host_path: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub container_path: ::prost::alloc::string::String,
    #[prost(bool, tag = "3")]
    pub read_only: bool,
}
/// Network configuration
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NetworkConfig {
    /// bridge, host, none
    #[prost(string, tag = "1")]
    pub mode: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub dns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(map = "string, string", tag = "3")]
    pub extra_hosts: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
/// Rental response
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentalResponse {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub ssh_credentials: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub container_info: ::core::option::Option<ContainerInfo>,
    #[prost(message, optional, tag = "4")]
    pub expires_at: ::core::option::Option<
        super::super::super::basilca::common::v1::Timestamp,
    >,
    #[prost(message, optional, tag = "5")]
    pub error: ::core::option::Option<
        super::super::super::basilca::common::v1::ErrorInfo,
    >,
}
/// Container information
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ContainerInfo {
    #[prost(string, tag = "1")]
    pub container_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub container_name: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "3")]
    pub mapped_ports: ::prost::alloc::vec::Vec<PortMapping>,
    #[prost(string, tag = "4")]
    pub status: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "5")]
    pub labels: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
/// Request rental status
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentalStatusRequest {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub validator_hotkey: ::prost::alloc::string::String,
}
/// Rental status response
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentalStatusResponse {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(enumeration = "RentalState", tag = "2")]
    pub state: i32,
    #[prost(message, optional, tag = "3")]
    pub container_status: ::core::option::Option<ContainerStatus>,
    #[prost(message, optional, tag = "4")]
    pub created_at: ::core::option::Option<
        super::super::super::basilca::common::v1::Timestamp,
    >,
    #[prost(message, optional, tag = "5")]
    pub expires_at: ::core::option::Option<
        super::super::super::basilca::common::v1::Timestamp,
    >,
    #[prost(message, optional, tag = "6")]
    pub resource_usage: ::core::option::Option<ResourceUsage>,
    #[prost(message, optional, tag = "7")]
    pub error: ::core::option::Option<
        super::super::super::basilca::common::v1::ErrorInfo,
    >,
}
/// Container status
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ContainerStatus {
    #[prost(string, tag = "1")]
    pub container_id: ::prost::alloc::string::String,
    /// running, stopped, exited, etc.
    #[prost(string, tag = "2")]
    pub state: ::prost::alloc::string::String,
    #[prost(int32, tag = "3")]
    pub exit_code: i32,
    /// healthy, unhealthy, none
    #[prost(string, tag = "4")]
    pub health: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "5")]
    pub started_at: ::core::option::Option<
        super::super::super::basilca::common::v1::Timestamp,
    >,
    #[prost(message, optional, tag = "6")]
    pub finished_at: ::core::option::Option<
        super::super::super::basilca::common::v1::Timestamp,
    >,
}
/// Resource usage statistics
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceUsage {
    #[prost(double, tag = "1")]
    pub cpu_percent: f64,
    #[prost(int64, tag = "2")]
    pub memory_mb: i64,
    #[prost(int64, tag = "3")]
    pub disk_read_bytes: i64,
    #[prost(int64, tag = "4")]
    pub disk_write_bytes: i64,
    #[prost(int64, tag = "5")]
    pub network_rx_bytes: i64,
    #[prost(int64, tag = "6")]
    pub network_tx_bytes: i64,
    #[prost(message, repeated, tag = "7")]
    pub gpu_usage: ::prost::alloc::vec::Vec<GpuUsage>,
}
/// GPU usage statistics
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuUsage {
    #[prost(uint32, tag = "1")]
    pub gpu_index: u32,
    #[prost(double, tag = "2")]
    pub utilization_percent: f64,
    #[prost(int64, tag = "3")]
    pub memory_mb: i64,
    #[prost(double, tag = "4")]
    pub temperature_celsius: f64,
}
/// Stop rental request
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StopRentalRequest {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub validator_hotkey: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub reason: ::prost::alloc::string::String,
    #[prost(bool, tag = "4")]
    pub force: bool,
}
/// Stop rental response (gRPC only - HTTP API returns 204 No Content with empty body)
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StopRentalResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub message: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<
        super::super::super::basilca::common::v1::ErrorInfo,
    >,
}
/// Log stream request
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogStreamRequest {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub validator_hotkey: ::prost::alloc::string::String,
    #[prost(bool, tag = "3")]
    pub follow: bool,
    #[prost(int32, tag = "4")]
    pub tail_lines: i32,
    #[prost(message, optional, tag = "5")]
    pub since: ::core::option::Option<
        super::super::super::basilca::common::v1::Timestamp,
    >,
}
/// Log entry
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogEntry {
    #[prost(message, optional, tag = "1")]
    pub timestamp: ::core::option::Option<
        super::super::super::basilca::common::v1::Timestamp,
    >,
    /// stdout/stderr
    #[prost(string, tag = "2")]
    pub stream: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub message: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub container_id: ::prost::alloc::string::String,
}
/// Container state update (from node to miner)
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ContainerStateUpdate {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub node_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub status: ::core::option::Option<ContainerStatus>,
    #[prost(message, optional, tag = "4")]
    pub resource_usage: ::core::option::Option<ResourceUsage>,
    /// started, stopped, health_changed, etc.
    #[prost(string, tag = "5")]
    pub event_type: ::prost::alloc::string::String,
}
/// Container state response
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ContainerStateResponse {
    #[prost(bool, tag = "1")]
    pub acknowledged: bool,
    #[prost(message, optional, tag = "2")]
    pub error: ::core::option::Option<
        super::super::super::basilca::common::v1::ErrorInfo,
    >,
}
/// Rental state
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum RentalState {
    Unknown = 0,
    Provisioning = 1,
    Active = 2,
    Stopping = 3,
    Stopped = 4,
    Failed = 5,
    Expired = 6,
}
impl RentalState {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            RentalState::Unknown => "RENTAL_STATE_UNKNOWN",
            RentalState::Provisioning => "RENTAL_STATE_PROVISIONING",
            RentalState::Active => "RENTAL_STATE_ACTIVE",
            RentalState::Stopping => "RENTAL_STATE_STOPPING",
            RentalState::Stopped => "RENTAL_STATE_STOPPED",
            RentalState::Failed => "RENTAL_STATE_FAILED",
            RentalState::Expired => "RENTAL_STATE_EXPIRED",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "RENTAL_STATE_UNKNOWN" => Some(Self::Unknown),
            "RENTAL_STATE_PROVISIONING" => Some(Self::Provisioning),
            "RENTAL_STATE_ACTIVE" => Some(Self::Active),
            "RENTAL_STATE_STOPPING" => Some(Self::Stopping),
            "RENTAL_STATE_STOPPED" => Some(Self::Stopped),
            "RENTAL_STATE_FAILED" => Some(Self::Failed),
            "RENTAL_STATE_EXPIRED" => Some(Self::Expired),
            _ => None,
        }
    }
}
/// Generated client implementations.
pub mod rental_service_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// Rental service for container deployment operations
    #[derive(Debug, Clone)]
    pub struct RentalServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl RentalServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> RentalServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> RentalServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + Send + Sync,
        {
            RentalServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Start a new rental
        pub async fn start_rental(
            &mut self,
            request: impl tonic::IntoRequest<super::RentalRequest>,
        ) -> std::result::Result<tonic::Response<super::RentalResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.rental.v1.RentalService/StartRental",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("basilica.rental.v1.RentalService", "StartRental"),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Get rental status
        pub async fn get_rental_status(
            &mut self,
            request: impl tonic::IntoRequest<super::RentalStatusRequest>,
        ) -> std::result::Result<
            tonic::Response<super::RentalStatusResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.rental.v1.RentalService/GetRentalStatus",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.rental.v1.RentalService",
                        "GetRentalStatus",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Stop a rental
        pub async fn stop_rental(
            &mut self,
            request: impl tonic::IntoRequest<super::StopRentalRequest>,
        ) -> std::result::Result<
            tonic::Response<super::StopRentalResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.rental.v1.RentalService/StopRental",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("basilica.rental.v1.RentalService", "StopRental"),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Stream container logs
        pub async fn stream_logs(
            &mut self,
            request: impl tonic::IntoRequest<super::LogStreamRequest>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::LogEntry>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.rental.v1.RentalService/StreamLogs",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("basilica.rental.v1.RentalService", "StreamLogs"),
                );
            self.inner.server_streaming(req, path, codec).await
        }
        /// Update container state
        pub async fn update_container_state(
            &mut self,
            request: impl tonic::IntoRequest<super::ContainerStateUpdate>,
        ) -> std::result::Result<
            tonic::Response<super::ContainerStateResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.rental.v1.RentalService/UpdateContainerState",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.rental.v1.RentalService",
                        "UpdateContainerState",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod rental_service_server {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with RentalServiceServer.
    #[async_trait]
    pub trait RentalService: Send + Sync + 'static {
        /// Start a new rental
        async fn start_rental(
            &self,
            request: tonic::Request<super::RentalRequest>,
        ) -> std::result::Result<tonic::Response<super::RentalResponse>, tonic::Status>;
        /// Get rental status
        async fn get_rental_status(
            &self,
            request: tonic::Request<super::RentalStatusRequest>,
        ) -> std::result::Result<
            tonic::Response<super::RentalStatusResponse>,
            tonic::Status,
        >;
        /// Stop a rental
        async fn stop_rental(
            &self,
            request: tonic::Request<super::StopRentalRequest>,
        ) -> std::result::Result<
            tonic::Response<super::StopRentalResponse>,
            tonic::Status,
        >;
        /// Server streaming response type for the StreamLogs method.
        type StreamLogsStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::LogEntry, tonic::Status>,
            >
            + Send
            + 'static;
        /// Stream container logs
        async fn stream_logs(
            &self,
            request: tonic::Request<super::LogStreamRequest>,
        ) -> std::result::Result<tonic::Response<Self::StreamLogsStream>, tonic::Status>;
        /// Update container state
        async fn update_container_state(
            &self,
            request: tonic::Request<super::ContainerStateUpdate>,
        ) -> std::result::Result<
            tonic::Response<super::ContainerStateResponse>,
            tonic::Status,
        >;
    }
    /// Rental service for container deployment operations
    #[derive(Debug)]
    pub struct RentalServiceServer<T: RentalService> {
        inner: _Inner<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    struct _Inner<T>(Arc<T>);
    impl<T: RentalService> RentalServiceServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            let inner = _Inner(inner);
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for RentalServiceServer<T>
    where
        T: RentalService,
        B: Body + Send + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/basilica.rental.v1.RentalService/StartRental" => {
                    #[allow(non_camel_case_types)]
                    struct StartRentalSvc<T: RentalService>(pub Arc<T>);
                    impl<
                        T: RentalService,
                    > tonic::server::UnaryService<super::RentalRequest>
                    for StartRentalSvc<T> {
                        type Response = super::RentalResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::RentalRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as RentalService>::start_rental(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = StartRentalSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.rental.v1.RentalService/GetRentalStatus" => {
                    #[allow(non_camel_case_types)]
                    struct GetRentalStatusSvc<T: RentalService>(pub Arc<T>);
                    impl<
                        T: RentalService,
                    > tonic::server::UnaryService<super::RentalStatusRequest>
                    for GetRentalStatusSvc<T> {
                        type Response = super::RentalStatusResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::RentalStatusRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as RentalService>::get_rental_status(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = GetRentalStatusSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.rental.v1.RentalService/StopRental" => {
                    #[allow(non_camel_case_types)]
                    struct StopRentalSvc<T: RentalService>(pub Arc<T>);
                    impl<
                        T: RentalService,
                    > tonic::server::UnaryService<super::StopRentalRequest>
                    for StopRentalSvc<T> {
                        type Response = super::StopRentalResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::StopRentalRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as RentalService>::stop_rental(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = StopRentalSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.rental.v1.RentalService/StreamLogs" => {
                    #[allow(non_camel_case_types)]
                    struct StreamLogsSvc<T: RentalService>(pub Arc<T>);
                    impl<
                        T: RentalService,
                    > tonic::server::ServerStreamingService<super::LogStreamRequest>
                    for StreamLogsSvc<T> {
                        type Response = super::LogEntry;
                        type ResponseStream = T::StreamLogsStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::LogStreamRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as RentalService>::stream_logs(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = StreamLogsSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.rental.v1.RentalService/UpdateContainerState" => {
                    #[allow(non_camel_case_types)]
                    struct UpdateContainerStateSvc<T: RentalService>(pub Arc<T>);
                    impl<
                        T: RentalService,
                    > tonic::server::UnaryService<super::ContainerStateUpdate>
                    for UpdateContainerStateSvc<T> {
                        type Response = super::ContainerStateResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ContainerStateUpdate>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as RentalService>::update_container_state(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = UpdateContainerStateSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        Ok(
                            http::Response::builder()
                                .status(200)
                                .header("grpc-status", "12")
                                .header("content-type", "application/grpc")
                                .body(empty_body())
                                .unwrap(),
                        )
                    })
                }
            }
        }
    }
    impl<T: RentalService> Clone for RentalServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    impl<T: RentalService> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(Arc::clone(&self.0))
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: RentalService> tonic::server::NamedService for RentalServiceServer<T> {
        const NAME: &'static str = "basilica.rental.v1.RentalService";
    }
}
