// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ApplyCreditsRequest {
    #[prost(string, tag = "1")]
    pub user_id: ::prost::alloc::string::String,
    /// Decimal string for precision
    #[prost(string, tag = "2")]
    pub amount: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub transaction_id: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub payment_method: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "5")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ApplyCreditsResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    /// Decimal string
    #[prost(string, tag = "2")]
    pub new_balance: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub credit_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub applied_at: ::core::option::Option<::prost_types::Timestamp>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetBalanceRequest {
    #[prost(string, tag = "1")]
    pub user_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetBalanceResponse {
    /// Decimal string
    #[prost(string, tag = "1")]
    pub available_balance: ::prost::alloc::string::String,
    /// Decimal string
    #[prost(string, tag = "2")]
    pub total_balance: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub last_updated: ::core::option::Option<::prost_types::Timestamp>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TrackRentalRequest {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub user_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "5")]
    pub resource_spec: ::core::option::Option<ResourceSpec>,
    #[prost(message, optional, tag = "7")]
    pub start_time: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(map = "string, string", tag = "8")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Cloud type specific data
    #[prost(oneof = "track_rental_request::CloudType", tags = "20, 21")]
    pub cloud_type: ::core::option::Option<track_rental_request::CloudType>,
}
/// Nested message and enum types in `TrackRentalRequest`.
pub mod track_rental_request {
    /// Cloud type specific data
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum CloudType {
        #[prost(message, tag = "20")]
        Community(super::CommunityCloudData),
        #[prost(message, tag = "21")]
        Secure(super::SecureCloudData),
    }
}
/// Community cloud rental data (validator-based)
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CommunityCloudData {
    /// Miner node ID
    #[prost(string, tag = "1")]
    pub node_id: ::prost::alloc::string::String,
    /// Validator hotkey
    #[prost(string, tag = "2")]
    pub validator_id: ::prost::alloc::string::String,
    /// Final price per GPU per hour (already includes markup)
    #[prost(double, tag = "3")]
    pub base_price_per_gpu: f64,
    /// Number of GPUs in this rental
    #[prost(uint32, tag = "4")]
    pub gpu_count: u32,
    /// Bittensor miner UID for payment reconciliation
    #[prost(uint32, tag = "5")]
    pub miner_uid: u32,
}
/// Secure cloud rental data (direct provider API)
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SecureCloudData {
    /// Provider's instance ID
    #[prost(string, tag = "1")]
    pub provider_instance_id: ::prost::alloc::string::String,
    /// Provider name (e.g., "datacrunch", "hyperstack")
    #[prost(string, tag = "2")]
    pub provider: ::prost::alloc::string::String,
    /// Original offering ID from aggregator
    #[prost(string, tag = "3")]
    pub offering_id: ::prost::alloc::string::String,
    /// Final price per GPU per hour (already includes markup)
    #[prost(double, tag = "4")]
    pub base_price_per_gpu: f64,
    /// Number of GPUs in this rental
    #[prost(uint32, tag = "5")]
    pub gpu_count: u32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceSpec {
    #[prost(uint32, tag = "1")]
    pub cpu_cores: u32,
    #[prost(uint64, tag = "2")]
    pub memory_mb: u64,
    #[prost(message, repeated, tag = "3")]
    pub gpus: ::prost::alloc::vec::Vec<GpuSpec>,
    #[prost(uint64, tag = "4")]
    pub disk_gb: u64,
    #[prost(uint64, tag = "5")]
    pub network_bandwidth_mbps: u64,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuSpec {
    #[prost(string, tag = "1")]
    pub model: ::prost::alloc::string::String,
    #[prost(uint64, tag = "2")]
    pub memory_mb: u64,
    #[prost(uint32, tag = "3")]
    pub count: u32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TrackRentalResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(string, tag = "2")]
    pub tracking_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UpdateRentalStatusRequest {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(enumeration = "RentalStatus", tag = "2")]
    pub status: i32,
    #[prost(message, optional, tag = "3")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(string, tag = "4")]
    pub reason: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UpdateRentalStatusResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    /// Decimal string
    #[prost(string, tag = "2")]
    pub current_cost: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub updated_at: ::core::option::Option<::prost_types::Timestamp>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRentalStatusRequest {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRentalStatusResponse {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(enumeration = "RentalStatus", tag = "2")]
    pub status: i32,
    #[prost(string, tag = "3")]
    pub user_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetActiveRentalsRequest {
    #[prost(string, tag = "1")]
    pub user_id: ::prost::alloc::string::String,
    #[prost(uint32, tag = "4")]
    pub limit: u32,
    #[prost(uint32, tag = "5")]
    pub offset: u32,
    /// Filter by status; empty = all statuses
    #[prost(enumeration = "RentalStatus", repeated, tag = "6")]
    pub status_filter: ::prost::alloc::vec::Vec<i32>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetActiveRentalsResponse {
    #[prost(message, repeated, tag = "1")]
    pub rentals: ::prost::alloc::vec::Vec<ActiveRental>,
    #[prost(uint64, tag = "2")]
    pub total_count: u64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ActiveRental {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub user_id: ::prost::alloc::string::String,
    #[prost(enumeration = "RentalStatus", tag = "5")]
    pub status: i32,
    #[prost(message, optional, tag = "6")]
    pub resource_spec: ::core::option::Option<ResourceSpec>,
    /// Decimal string
    #[prost(string, tag = "8")]
    pub current_cost: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "9")]
    pub start_time: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "10")]
    pub last_updated: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(map = "string, string", tag = "11")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Cloud type specific data
    #[prost(oneof = "active_rental::CloudType", tags = "20, 21")]
    pub cloud_type: ::core::option::Option<active_rental::CloudType>,
}
/// Nested message and enum types in `ActiveRental`.
pub mod active_rental {
    /// Cloud type specific data
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum CloudType {
        #[prost(message, tag = "20")]
        Community(super::CommunityCloudData),
        #[prost(message, tag = "21")]
        Secure(super::SecureCloudData),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FinalizeRentalRequest {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub end_time: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(string, tag = "4")]
    pub termination_reason: ::prost::alloc::string::String,
    /// Desired final rental state. Defaults to STOPPED if not specified.
    #[prost(enumeration = "RentalStatus", tag = "5")]
    pub target_status: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FinalizeRentalResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    /// Decimal string
    #[prost(string, tag = "2")]
    pub total_cost: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub duration: ::core::option::Option<::prost_types::Duration>,
    /// Decimal string
    #[prost(string, tag = "4")]
    pub charged_amount: ::prost::alloc::string::String,
    /// Decimal string
    #[prost(string, tag = "5")]
    pub refunded_amount: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TelemetryData {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub node_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "4")]
    pub resource_usage: ::core::option::Option<ResourceUsage>,
    #[prost(map = "string, double", tag = "5")]
    pub custom_metrics: ::std::collections::HashMap<::prost::alloc::string::String, f64>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceUsage {
    #[prost(double, tag = "1")]
    pub cpu_percent: f64,
    #[prost(uint64, tag = "2")]
    pub memory_mb: u64,
    #[prost(uint64, tag = "3")]
    pub network_rx_bytes: u64,
    #[prost(uint64, tag = "4")]
    pub network_tx_bytes: u64,
    #[prost(uint64, tag = "5")]
    pub disk_read_bytes: u64,
    #[prost(uint64, tag = "6")]
    pub disk_write_bytes: u64,
    #[prost(message, repeated, tag = "7")]
    pub gpu_usage: ::prost::alloc::vec::Vec<GpuUsage>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuUsage {
    #[prost(uint32, tag = "1")]
    pub index: u32,
    #[prost(double, tag = "2")]
    pub utilization_percent: f64,
    #[prost(uint64, tag = "3")]
    pub memory_used_mb: u64,
    #[prost(double, tag = "4")]
    pub temperature_celsius: f64,
    #[prost(uint64, tag = "5")]
    pub power_watts: u64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IngestResponse {
    #[prost(uint64, tag = "1")]
    pub events_received: u64,
    #[prost(uint64, tag = "2")]
    pub events_processed: u64,
    #[prost(uint64, tag = "3")]
    pub events_failed: u64,
    #[prost(message, optional, tag = "4")]
    pub last_processed: ::core::option::Option<::prost_types::Timestamp>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UsageReportRequest {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub start_time: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "3")]
    pub end_time: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(enumeration = "UsageAggregation", tag = "4")]
    pub aggregation: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UsageReportResponse {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "2")]
    pub data_points: ::prost::alloc::vec::Vec<UsageDataPoint>,
    #[prost(message, optional, tag = "3")]
    pub summary: ::core::option::Option<UsageSummary>,
    /// Decimal string
    #[prost(string, tag = "4")]
    pub total_cost: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UsageDataPoint {
    #[prost(message, optional, tag = "1")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "2")]
    pub usage: ::core::option::Option<ResourceUsage>,
    /// Decimal string for this period
    #[prost(string, tag = "3")]
    pub cost: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UsageSummary {
    #[prost(double, tag = "1")]
    pub avg_cpu_percent: f64,
    #[prost(uint64, tag = "2")]
    pub avg_memory_mb: u64,
    #[prost(uint64, tag = "3")]
    pub total_network_bytes: u64,
    #[prost(uint64, tag = "4")]
    pub total_disk_bytes: u64,
    #[prost(double, tag = "5")]
    pub avg_gpu_utilization: f64,
    #[prost(message, optional, tag = "6")]
    pub duration: ::core::option::Option<::prost_types::Duration>,
}
/// Error details for better error handling
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ErrorDetail {
    #[prost(string, tag = "1")]
    pub code: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub message: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "3")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RefreshMinerRevenueSummaryRequest {
    /// Start of period (inclusive)
    #[prost(message, optional, tag = "1")]
    pub period_start: ::core::option::Option<::prost_types::Timestamp>,
    /// End of period (exclusive)
    #[prost(message, optional, tag = "2")]
    pub period_end: ::core::option::Option<::prost_types::Timestamp>,
    /// Version of computation logic (default: 1)
    #[prost(uint32, tag = "3")]
    pub computation_version: u32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RefreshMinerRevenueSummaryResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    /// Number of summary rows created
    #[prost(uint32, tag = "2")]
    pub summaries_created: u32,
    #[prost(message, optional, tag = "3")]
    pub computed_at: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(string, tag = "4")]
    pub error_message: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetMinerRevenueSummaryRequest {
    /// Filter criteria (all optional)
    ///
    /// Filter by specific node IDs
    #[prost(string, repeated, tag = "1")]
    pub node_ids: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Filter by specific validator IDs
    #[prost(string, repeated, tag = "2")]
    pub validator_ids: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Filter by period start
    #[prost(message, optional, tag = "3")]
    pub period_start: ::core::option::Option<::prost_types::Timestamp>,
    /// Filter by period end
    #[prost(message, optional, tag = "4")]
    pub period_end: ::core::option::Option<::prost_types::Timestamp>,
    /// Get snapshot from specific computation time
    #[prost(message, optional, tag = "5")]
    pub computed_at: ::core::option::Option<::prost_types::Timestamp>,
    /// Only return most recent computation for each (node, validator, period)
    #[prost(bool, tag = "6")]
    pub latest_only: bool,
    /// Pagination
    #[prost(uint32, tag = "7")]
    pub limit: u32,
    #[prost(uint32, tag = "8")]
    pub offset: u32,
    /// Filter by miner UIDs
    ///
    /// Filter by specific Bittensor miner UIDs
    #[prost(uint32, repeated, tag = "9")]
    pub miner_uids: ::prost::alloc::vec::Vec<u32>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetMinerRevenueSummaryResponse {
    #[prost(message, repeated, tag = "1")]
    pub summaries: ::prost::alloc::vec::Vec<MinerRevenueSummary>,
    #[prost(uint64, tag = "2")]
    pub total_count: u64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MinerRevenueSummary {
    /// UUID
    #[prost(string, tag = "1")]
    pub id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub node_id: ::prost::alloc::string::String,
    /// Nullable
    #[prost(string, tag = "3")]
    pub validator_id: ::prost::alloc::string::String,
    /// Bittensor miner UID (nullable, 0 means unknown)
    #[prost(uint32, tag = "16")]
    pub miner_uid: u32,
    /// Time period
    #[prost(message, optional, tag = "4")]
    pub period_start: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "5")]
    pub period_end: ::core::option::Option<::prost_types::Timestamp>,
    /// Aggregated metrics
    #[prost(uint32, tag = "6")]
    pub total_rentals: u32,
    #[prost(uint32, tag = "7")]
    pub completed_rentals: u32,
    #[prost(uint32, tag = "8")]
    pub failed_rentals: u32,
    /// Decimal string (TAO)
    #[prost(string, tag = "9")]
    pub total_revenue: ::prost::alloc::string::String,
    /// Decimal string
    #[prost(string, tag = "10")]
    pub total_hours: ::prost::alloc::string::String,
    /// Computed metrics
    ///
    /// Decimal string (nullable)
    #[prost(string, tag = "11")]
    pub avg_hourly_rate: ::prost::alloc::string::String,
    /// Decimal string (nullable)
    #[prost(string, tag = "12")]
    pub avg_rental_duration_hours: ::prost::alloc::string::String,
    /// Audit fields
    #[prost(message, optional, tag = "13")]
    pub computed_at: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(uint32, tag = "14")]
    pub computation_version: u32,
    #[prost(message, optional, tag = "15")]
    pub created_at: ::core::option::Option<::prost_types::Timestamp>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum RentalStatus {
    Unspecified = 0,
    Pending = 1,
    Active = 2,
    Stopping = 3,
    Stopped = 4,
    Failed = 5,
    FailedInsufficientCredits = 6,
}
impl RentalStatus {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            RentalStatus::Unspecified => "RENTAL_STATUS_UNSPECIFIED",
            RentalStatus::Pending => "RENTAL_STATUS_PENDING",
            RentalStatus::Active => "RENTAL_STATUS_ACTIVE",
            RentalStatus::Stopping => "RENTAL_STATUS_STOPPING",
            RentalStatus::Stopped => "RENTAL_STATUS_STOPPED",
            RentalStatus::Failed => "RENTAL_STATUS_FAILED",
            RentalStatus::FailedInsufficientCredits => {
                "RENTAL_STATUS_FAILED_INSUFFICIENT_CREDITS"
            }
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "RENTAL_STATUS_UNSPECIFIED" => Some(Self::Unspecified),
            "RENTAL_STATUS_PENDING" => Some(Self::Pending),
            "RENTAL_STATUS_ACTIVE" => Some(Self::Active),
            "RENTAL_STATUS_STOPPING" => Some(Self::Stopping),
            "RENTAL_STATUS_STOPPED" => Some(Self::Stopped),
            "RENTAL_STATUS_FAILED" => Some(Self::Failed),
            "RENTAL_STATUS_FAILED_INSUFFICIENT_CREDITS" => {
                Some(Self::FailedInsufficientCredits)
            }
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum UsageAggregation {
    Unspecified = 0,
    Minute = 1,
    Hour = 2,
    Day = 3,
}
impl UsageAggregation {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            UsageAggregation::Unspecified => "USAGE_AGGREGATION_UNSPECIFIED",
            UsageAggregation::Minute => "USAGE_AGGREGATION_MINUTE",
            UsageAggregation::Hour => "USAGE_AGGREGATION_HOUR",
            UsageAggregation::Day => "USAGE_AGGREGATION_DAY",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "USAGE_AGGREGATION_UNSPECIFIED" => Some(Self::Unspecified),
            "USAGE_AGGREGATION_MINUTE" => Some(Self::Minute),
            "USAGE_AGGREGATION_HOUR" => Some(Self::Hour),
            "USAGE_AGGREGATION_DAY" => Some(Self::Day),
            _ => None,
        }
    }
}
/// Generated client implementations.
pub mod billing_service_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// Billing service for credit management, rental tracking, and telemetry ingestion
    #[derive(Debug, Clone)]
    pub struct BillingServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl BillingServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> BillingServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> BillingServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + Send + Sync,
        {
            BillingServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Credit management
        pub async fn apply_credits(
            &mut self,
            request: impl tonic::IntoRequest<super::ApplyCreditsRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ApplyCreditsResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/ApplyCredits",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("basilica.billing.v1.BillingService", "ApplyCredits"),
                );
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_balance(
            &mut self,
            request: impl tonic::IntoRequest<super::GetBalanceRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetBalanceResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/GetBalance",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("basilica.billing.v1.BillingService", "GetBalance"),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Rental tracking
        pub async fn track_rental(
            &mut self,
            request: impl tonic::IntoRequest<super::TrackRentalRequest>,
        ) -> std::result::Result<
            tonic::Response<super::TrackRentalResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/TrackRental",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("basilica.billing.v1.BillingService", "TrackRental"),
                );
            self.inner.unary(req, path, codec).await
        }
        pub async fn update_rental_status(
            &mut self,
            request: impl tonic::IntoRequest<super::UpdateRentalStatusRequest>,
        ) -> std::result::Result<
            tonic::Response<super::UpdateRentalStatusResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/UpdateRentalStatus",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.billing.v1.BillingService",
                        "UpdateRentalStatus",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_active_rentals(
            &mut self,
            request: impl tonic::IntoRequest<super::GetActiveRentalsRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetActiveRentalsResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/GetActiveRentals",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.billing.v1.BillingService",
                        "GetActiveRentals",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        pub async fn finalize_rental(
            &mut self,
            request: impl tonic::IntoRequest<super::FinalizeRentalRequest>,
        ) -> std::result::Result<
            tonic::Response<super::FinalizeRentalResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/FinalizeRental",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.billing.v1.BillingService",
                        "FinalizeRental",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Telemetry ingestion
        pub async fn ingest_telemetry(
            &mut self,
            request: impl tonic::IntoStreamingRequest<Message = super::TelemetryData>,
        ) -> std::result::Result<tonic::Response<super::IngestResponse>, tonic::Status> {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/IngestTelemetry",
            );
            let mut req = request.into_streaming_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.billing.v1.BillingService",
                        "IngestTelemetry",
                    ),
                );
            self.inner.client_streaming(req, path, codec).await
        }
        pub async fn get_usage_report(
            &mut self,
            request: impl tonic::IntoRequest<super::UsageReportRequest>,
        ) -> std::result::Result<
            tonic::Response<super::UsageReportResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/GetUsageReport",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.billing.v1.BillingService",
                        "GetUsageReport",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Miner revenue reconciliation
        pub async fn refresh_miner_revenue_summary(
            &mut self,
            request: impl tonic::IntoRequest<super::RefreshMinerRevenueSummaryRequest>,
        ) -> std::result::Result<
            tonic::Response<super::RefreshMinerRevenueSummaryResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/RefreshMinerRevenueSummary",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.billing.v1.BillingService",
                        "RefreshMinerRevenueSummary",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        pub async fn get_miner_revenue_summary(
            &mut self,
            request: impl tonic::IntoRequest<super::GetMinerRevenueSummaryRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetMinerRevenueSummaryResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/GetMinerRevenueSummary",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.billing.v1.BillingService",
                        "GetMinerRevenueSummary",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Rental status lookup (for credit exhaustion monitoring)
        pub async fn get_rental_status(
            &mut self,
            request: impl tonic::IntoRequest<super::GetRentalStatusRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetRentalStatusResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilica.billing.v1.BillingService/GetRentalStatus",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilica.billing.v1.BillingService",
                        "GetRentalStatus",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod billing_service_server {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with BillingServiceServer.
    #[async_trait]
    pub trait BillingService: Send + Sync + 'static {
        /// Credit management
        async fn apply_credits(
            &self,
            request: tonic::Request<super::ApplyCreditsRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ApplyCreditsResponse>,
            tonic::Status,
        >;
        async fn get_balance(
            &self,
            request: tonic::Request<super::GetBalanceRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetBalanceResponse>,
            tonic::Status,
        >;
        /// Rental tracking
        async fn track_rental(
            &self,
            request: tonic::Request<super::TrackRentalRequest>,
        ) -> std::result::Result<
            tonic::Response<super::TrackRentalResponse>,
            tonic::Status,
        >;
        async fn update_rental_status(
            &self,
            request: tonic::Request<super::UpdateRentalStatusRequest>,
        ) -> std::result::Result<
            tonic::Response<super::UpdateRentalStatusResponse>,
            tonic::Status,
        >;
        async fn get_active_rentals(
            &self,
            request: tonic::Request<super::GetActiveRentalsRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetActiveRentalsResponse>,
            tonic::Status,
        >;
        async fn finalize_rental(
            &self,
            request: tonic::Request<super::FinalizeRentalRequest>,
        ) -> std::result::Result<
            tonic::Response<super::FinalizeRentalResponse>,
            tonic::Status,
        >;
        /// Telemetry ingestion
        async fn ingest_telemetry(
            &self,
            request: tonic::Request<tonic::Streaming<super::TelemetryData>>,
        ) -> std::result::Result<tonic::Response<super::IngestResponse>, tonic::Status>;
        async fn get_usage_report(
            &self,
            request: tonic::Request<super::UsageReportRequest>,
        ) -> std::result::Result<
            tonic::Response<super::UsageReportResponse>,
            tonic::Status,
        >;
        /// Miner revenue reconciliation
        async fn refresh_miner_revenue_summary(
            &self,
            request: tonic::Request<super::RefreshMinerRevenueSummaryRequest>,
        ) -> std::result::Result<
            tonic::Response<super::RefreshMinerRevenueSummaryResponse>,
            tonic::Status,
        >;
        async fn get_miner_revenue_summary(
            &self,
            request: tonic::Request<super::GetMinerRevenueSummaryRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetMinerRevenueSummaryResponse>,
            tonic::Status,
        >;
        /// Rental status lookup (for credit exhaustion monitoring)
        async fn get_rental_status(
            &self,
            request: tonic::Request<super::GetRentalStatusRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GetRentalStatusResponse>,
            tonic::Status,
        >;
    }
    /// Billing service for credit management, rental tracking, and telemetry ingestion
    #[derive(Debug)]
    pub struct BillingServiceServer<T: BillingService> {
        inner: _Inner<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    struct _Inner<T>(Arc<T>);
    impl<T: BillingService> BillingServiceServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            let inner = _Inner(inner);
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for BillingServiceServer<T>
    where
        T: BillingService,
        B: Body + Send + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/basilica.billing.v1.BillingService/ApplyCredits" => {
                    #[allow(non_camel_case_types)]
                    struct ApplyCreditsSvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::ApplyCreditsRequest>
                    for ApplyCreditsSvc<T> {
                        type Response = super::ApplyCreditsResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ApplyCreditsRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::apply_credits(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = ApplyCreditsSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/GetBalance" => {
                    #[allow(non_camel_case_types)]
                    struct GetBalanceSvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::GetBalanceRequest>
                    for GetBalanceSvc<T> {
                        type Response = super::GetBalanceResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::GetBalanceRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::get_balance(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = GetBalanceSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/TrackRental" => {
                    #[allow(non_camel_case_types)]
                    struct TrackRentalSvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::TrackRentalRequest>
                    for TrackRentalSvc<T> {
                        type Response = super::TrackRentalResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::TrackRentalRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::track_rental(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = TrackRentalSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/UpdateRentalStatus" => {
                    #[allow(non_camel_case_types)]
                    struct UpdateRentalStatusSvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::UpdateRentalStatusRequest>
                    for UpdateRentalStatusSvc<T> {
                        type Response = super::UpdateRentalStatusResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::UpdateRentalStatusRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::update_rental_status(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = UpdateRentalStatusSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/GetActiveRentals" => {
                    #[allow(non_camel_case_types)]
                    struct GetActiveRentalsSvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::GetActiveRentalsRequest>
                    for GetActiveRentalsSvc<T> {
                        type Response = super::GetActiveRentalsResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::GetActiveRentalsRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::get_active_rentals(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = GetActiveRentalsSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/FinalizeRental" => {
                    #[allow(non_camel_case_types)]
                    struct FinalizeRentalSvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::FinalizeRentalRequest>
                    for FinalizeRentalSvc<T> {
                        type Response = super::FinalizeRentalResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::FinalizeRentalRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::finalize_rental(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = FinalizeRentalSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/IngestTelemetry" => {
                    #[allow(non_camel_case_types)]
                    struct IngestTelemetrySvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::ClientStreamingService<super::TelemetryData>
                    for IngestTelemetrySvc<T> {
                        type Response = super::IngestResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<
                                tonic::Streaming<super::TelemetryData>,
                            >,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::ingest_telemetry(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = IngestTelemetrySvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.client_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/GetUsageReport" => {
                    #[allow(non_camel_case_types)]
                    struct GetUsageReportSvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::UsageReportRequest>
                    for GetUsageReportSvc<T> {
                        type Response = super::UsageReportResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::UsageReportRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::get_usage_report(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = GetUsageReportSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/RefreshMinerRevenueSummary" => {
                    #[allow(non_camel_case_types)]
                    struct RefreshMinerRevenueSummarySvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<
                        super::RefreshMinerRevenueSummaryRequest,
                    > for RefreshMinerRevenueSummarySvc<T> {
                        type Response = super::RefreshMinerRevenueSummaryResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<
                                super::RefreshMinerRevenueSummaryRequest,
                            >,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::refresh_miner_revenue_summary(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = RefreshMinerRevenueSummarySvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/GetMinerRevenueSummary" => {
                    #[allow(non_camel_case_types)]
                    struct GetMinerRevenueSummarySvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::GetMinerRevenueSummaryRequest>
                    for GetMinerRevenueSummarySvc<T> {
                        type Response = super::GetMinerRevenueSummaryResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::GetMinerRevenueSummaryRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::get_miner_revenue_summary(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = GetMinerRevenueSummarySvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilica.billing.v1.BillingService/GetRentalStatus" => {
                    #[allow(non_camel_case_types)]
                    struct GetRentalStatusSvc<T: BillingService>(pub Arc<T>);
                    impl<
                        T: BillingService,
                    > tonic::server::UnaryService<super::GetRentalStatusRequest>
                    for GetRentalStatusSvc<T> {
                        type Response = super::GetRentalStatusResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::GetRentalStatusRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as BillingService>::get_rental_status(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = GetRentalStatusSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        Ok(
                            http::Response::builder()
                                .status(200)
                                .header("grpc-status", "12")
                                .header("content-type", "application/grpc")
                                .body(empty_body())
                                .unwrap(),
                        )
                    })
                }
            }
        }
    }
    impl<T: BillingService> Clone for BillingServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    impl<T: BillingService> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(Arc::clone(&self.0))
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: BillingService> tonic::server::NamedService for BillingServiceServer<T> {
        const NAME: &'static str = "basilica.billing.v1.BillingService";
    }
}
