// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListCapacityRequest {
    /// API key for authentication
    #[prost(string, tag = "1")]
    pub api_key: ::prost::alloc::string::String,
    /// Resource filter criteria
    #[prost(message, optional, tag = "2")]
    pub requirements: ::core::option::Option<super::super::common::v1::ResourceLimits>,
    /// Geographic preference
    #[prost(string, tag = "3")]
    pub location_preference: ::prost::alloc::string::String,
    /// Price range
    #[prost(double, tag = "4")]
    pub max_price_per_hour: f64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CapacityOffer {
    #[prost(string, tag = "1")]
    pub offer_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub miner_hotkey: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub node_id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub gpu_spec: ::core::option::Option<super::super::common::v1::GpuSpec>,
    #[prost(message, optional, tag = "5")]
    pub available_resources: ::core::option::Option<
        super::super::common::v1::ResourceLimits,
    >,
    #[prost(double, tag = "6")]
    pub price_per_hour: f64,
    #[prost(string, tag = "7")]
    pub location: ::prost::alloc::string::String,
    #[prost(double, tag = "8")]
    pub reliability_score: f64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListCapacityResponse {
    #[prost(message, repeated, tag = "1")]
    pub offers: ::prost::alloc::vec::Vec<CapacityOffer>,
    #[prost(uint32, tag = "2")]
    pub total_offers: u32,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<super::super::common::v1::ErrorInfo>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentCapacityRequest {
    #[prost(string, tag = "1")]
    pub api_key: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub offer_id: ::prost::alloc::string::String,
    #[prost(uint64, tag = "3")]
    pub rental_duration_hours: u64,
    #[prost(message, optional, tag = "4")]
    pub container_spec: ::core::option::Option<super::super::common::v1::ContainerSpec>,
    #[prost(string, tag = "5")]
    pub user_ssh_public_key: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentCapacityResponse {
    #[prost(string, tag = "1")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub connection_info: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub ssh_endpoint: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub rental_start: ::core::option::Option<super::super::common::v1::Timestamp>,
    #[prost(message, optional, tag = "5")]
    pub rental_end: ::core::option::Option<super::super::common::v1::Timestamp>,
    #[prost(message, optional, tag = "6")]
    pub error: ::core::option::Option<super::super::common::v1::ErrorInfo>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TerminateRentalRequest {
    #[prost(string, tag = "1")]
    pub api_key: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub rental_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TerminateRentalResponse {
    #[prost(bool, tag = "1")]
    pub success: bool,
    #[prost(message, optional, tag = "2")]
    pub terminated_at: ::core::option::Option<super::super::common::v1::Timestamp>,
    #[prost(message, optional, tag = "3")]
    pub error: ::core::option::Option<super::super::common::v1::ErrorInfo>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentalStatusRequest {
    #[prost(string, tag = "1")]
    pub api_key: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub rental_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentalStatusResponse {
    #[prost(string, tag = "1")]
    pub status: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub container_status: ::core::option::Option<
        super::super::common::v1::ContainerStatus,
    >,
    #[prost(message, optional, tag = "3")]
    pub resource_usage: ::core::option::Option<
        super::super::common::v1::ResourceUsageStats,
    >,
    #[prost(message, optional, tag = "4")]
    pub last_update: ::core::option::Option<super::super::common::v1::Timestamp>,
    #[prost(message, optional, tag = "5")]
    pub error: ::core::option::Option<super::super::common::v1::ErrorInfo>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RentalLogRequest {
    #[prost(string, tag = "1")]
    pub api_key: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub rental_id: ::prost::alloc::string::String,
    #[prost(bool, tag = "3")]
    pub follow: bool,
    #[prost(uint32, tag = "4")]
    pub tail_lines: u32,
}
/// Generated client implementations.
pub mod validator_external_api_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// ValidatorExternalApi service for external consumption
    #[derive(Debug, Clone)]
    pub struct ValidatorExternalApiClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl ValidatorExternalApiClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> ValidatorExternalApiClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> ValidatorExternalApiClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + Send + Sync,
        {
            ValidatorExternalApiClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// List available capacity across the network
        pub async fn list_available_capacity(
            &mut self,
            request: impl tonic::IntoRequest<super::ListCapacityRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ListCapacityResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.validator.v1.ValidatorExternalApi/ListAvailableCapacity",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilca.validator.v1.ValidatorExternalApi",
                        "ListAvailableCapacity",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Rent GPU capacity from the network
        pub async fn rent_capacity(
            &mut self,
            request: impl tonic::IntoRequest<super::RentCapacityRequest>,
        ) -> std::result::Result<
            tonic::Response<super::RentCapacityResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.validator.v1.ValidatorExternalApi/RentCapacity",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilca.validator.v1.ValidatorExternalApi",
                        "RentCapacity",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Terminate an active rental
        pub async fn terminate_rental(
            &mut self,
            request: impl tonic::IntoRequest<super::TerminateRentalRequest>,
        ) -> std::result::Result<
            tonic::Response<super::TerminateRentalResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.validator.v1.ValidatorExternalApi/TerminateRental",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilca.validator.v1.ValidatorExternalApi",
                        "TerminateRental",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Get status of a rental
        pub async fn get_rental_status(
            &mut self,
            request: impl tonic::IntoRequest<super::RentalStatusRequest>,
        ) -> std::result::Result<
            tonic::Response<super::RentalStatusResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.validator.v1.ValidatorExternalApi/GetRentalStatus",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilca.validator.v1.ValidatorExternalApi",
                        "GetRentalStatus",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Stream rental logs
        pub async fn stream_rental_logs(
            &mut self,
            request: impl tonic::IntoRequest<super::RentalLogRequest>,
        ) -> std::result::Result<
            tonic::Response<
                tonic::codec::Streaming<super::super::super::common::v1::LogEntry>,
            >,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.validator.v1.ValidatorExternalApi/StreamRentalLogs",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilca.validator.v1.ValidatorExternalApi",
                        "StreamRentalLogs",
                    ),
                );
            self.inner.server_streaming(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod validator_external_api_server {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with ValidatorExternalApiServer.
    #[async_trait]
    pub trait ValidatorExternalApi: Send + Sync + 'static {
        /// List available capacity across the network
        async fn list_available_capacity(
            &self,
            request: tonic::Request<super::ListCapacityRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ListCapacityResponse>,
            tonic::Status,
        >;
        /// Rent GPU capacity from the network
        async fn rent_capacity(
            &self,
            request: tonic::Request<super::RentCapacityRequest>,
        ) -> std::result::Result<
            tonic::Response<super::RentCapacityResponse>,
            tonic::Status,
        >;
        /// Terminate an active rental
        async fn terminate_rental(
            &self,
            request: tonic::Request<super::TerminateRentalRequest>,
        ) -> std::result::Result<
            tonic::Response<super::TerminateRentalResponse>,
            tonic::Status,
        >;
        /// Get status of a rental
        async fn get_rental_status(
            &self,
            request: tonic::Request<super::RentalStatusRequest>,
        ) -> std::result::Result<
            tonic::Response<super::RentalStatusResponse>,
            tonic::Status,
        >;
        /// Server streaming response type for the StreamRentalLogs method.
        type StreamRentalLogsStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<
                    super::super::super::common::v1::LogEntry,
                    tonic::Status,
                >,
            >
            + Send
            + 'static;
        /// Stream rental logs
        async fn stream_rental_logs(
            &self,
            request: tonic::Request<super::RentalLogRequest>,
        ) -> std::result::Result<
            tonic::Response<Self::StreamRentalLogsStream>,
            tonic::Status,
        >;
    }
    /// ValidatorExternalApi service for external consumption
    #[derive(Debug)]
    pub struct ValidatorExternalApiServer<T: ValidatorExternalApi> {
        inner: _Inner<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    struct _Inner<T>(Arc<T>);
    impl<T: ValidatorExternalApi> ValidatorExternalApiServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            let inner = _Inner(inner);
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>>
    for ValidatorExternalApiServer<T>
    where
        T: ValidatorExternalApi,
        B: Body + Send + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/basilca.validator.v1.ValidatorExternalApi/ListAvailableCapacity" => {
                    #[allow(non_camel_case_types)]
                    struct ListAvailableCapacitySvc<T: ValidatorExternalApi>(pub Arc<T>);
                    impl<
                        T: ValidatorExternalApi,
                    > tonic::server::UnaryService<super::ListCapacityRequest>
                    for ListAvailableCapacitySvc<T> {
                        type Response = super::ListCapacityResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ListCapacityRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as ValidatorExternalApi>::list_available_capacity(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = ListAvailableCapacitySvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilca.validator.v1.ValidatorExternalApi/RentCapacity" => {
                    #[allow(non_camel_case_types)]
                    struct RentCapacitySvc<T: ValidatorExternalApi>(pub Arc<T>);
                    impl<
                        T: ValidatorExternalApi,
                    > tonic::server::UnaryService<super::RentCapacityRequest>
                    for RentCapacitySvc<T> {
                        type Response = super::RentCapacityResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::RentCapacityRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as ValidatorExternalApi>::rent_capacity(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = RentCapacitySvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilca.validator.v1.ValidatorExternalApi/TerminateRental" => {
                    #[allow(non_camel_case_types)]
                    struct TerminateRentalSvc<T: ValidatorExternalApi>(pub Arc<T>);
                    impl<
                        T: ValidatorExternalApi,
                    > tonic::server::UnaryService<super::TerminateRentalRequest>
                    for TerminateRentalSvc<T> {
                        type Response = super::TerminateRentalResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::TerminateRentalRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as ValidatorExternalApi>::terminate_rental(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = TerminateRentalSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilca.validator.v1.ValidatorExternalApi/GetRentalStatus" => {
                    #[allow(non_camel_case_types)]
                    struct GetRentalStatusSvc<T: ValidatorExternalApi>(pub Arc<T>);
                    impl<
                        T: ValidatorExternalApi,
                    > tonic::server::UnaryService<super::RentalStatusRequest>
                    for GetRentalStatusSvc<T> {
                        type Response = super::RentalStatusResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::RentalStatusRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as ValidatorExternalApi>::get_rental_status(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = GetRentalStatusSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilca.validator.v1.ValidatorExternalApi/StreamRentalLogs" => {
                    #[allow(non_camel_case_types)]
                    struct StreamRentalLogsSvc<T: ValidatorExternalApi>(pub Arc<T>);
                    impl<
                        T: ValidatorExternalApi,
                    > tonic::server::ServerStreamingService<super::RentalLogRequest>
                    for StreamRentalLogsSvc<T> {
                        type Response = super::super::super::common::v1::LogEntry;
                        type ResponseStream = T::StreamRentalLogsStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::RentalLogRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as ValidatorExternalApi>::stream_rental_logs(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = StreamRentalLogsSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        Ok(
                            http::Response::builder()
                                .status(200)
                                .header("grpc-status", "12")
                                .header("content-type", "application/grpc")
                                .body(empty_body())
                                .unwrap(),
                        )
                    })
                }
            }
        }
    }
    impl<T: ValidatorExternalApi> Clone for ValidatorExternalApiServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    impl<T: ValidatorExternalApi> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(Arc::clone(&self.0))
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: ValidatorExternalApi> tonic::server::NamedService
    for ValidatorExternalApiServer<T> {
        const NAME: &'static str = "basilca.validator.v1.ValidatorExternalApi";
    }
}
