// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ValidatorAuthRequest {
    #[prost(string, tag = "1")]
    pub validator_hotkey: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub signature: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub nonce: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub timestamp: ::core::option::Option<super::super::common::v1::Timestamp>,
    #[prost(string, tag = "5")]
    pub target_miner_hotkey: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MinerAuthResponse {
    #[prost(bool, tag = "1")]
    pub authenticated: bool,
    #[prost(string, tag = "2")]
    pub session_token: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub expires_at: ::core::option::Option<super::super::common::v1::Timestamp>,
    #[prost(message, optional, tag = "4")]
    pub error: ::core::option::Option<super::super::common::v1::ErrorInfo>,
    /// Miner identity verification fields
    ///
    /// Miner's hotkey for verification
    #[prost(string, tag = "5")]
    pub miner_hotkey: ::prost::alloc::string::String,
    /// Signature proving miner's identity
    #[prost(string, tag = "6")]
    pub miner_signature: ::prost::alloc::string::String,
    /// Nonce included in signature to prevent replay
    #[prost(string, tag = "7")]
    pub response_nonce: ::prost::alloc::string::String,
}
/// Node discovery request - validators request available nodes from miners
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DiscoverNodesRequest {
    #[prost(string, tag = "1")]
    pub validator_hotkey: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub signature: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub nonce: ::prost::alloc::string::String,
    /// Required: SSH public key
    #[prost(string, tag = "4")]
    pub validator_public_key: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "5")]
    pub timestamp: ::core::option::Option<super::super::common::v1::Timestamp>,
    #[prost(string, tag = "6")]
    pub target_miner_hotkey: ::prost::alloc::string::String,
}
/// Node connection details for direct SSH access
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NodeConnectionDetails {
    #[prost(string, tag = "1")]
    pub node_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub host: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub port: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub username: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub additional_opts: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "6")]
    pub gpu_spec: ::core::option::Option<super::super::common::v1::GpuSpec>,
    #[prost(string, tag = "7")]
    pub status: ::prost::alloc::string::String,
    /// Price in cents per GPU per hour (e.g., 250 = $2.50/hour)
    #[prost(uint32, tag = "8")]
    pub hourly_rate_cents: u32,
}
/// Response containing list of available nodes
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListNodeConnectionDetailsResponse {
    /// list of nodes
    #[prost(message, repeated, tag = "1")]
    pub nodes: ::prost::alloc::vec::Vec<NodeConnectionDetails>,
}
/// Generated client implementations.
pub mod miner_discovery_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// MinerDiscovery service for validator-miner interaction
    #[derive(Debug, Clone)]
    pub struct MinerDiscoveryClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl MinerDiscoveryClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> MinerDiscoveryClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> MinerDiscoveryClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + Send + Sync,
        {
            MinerDiscoveryClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Authenticate validator with the miner
        pub async fn authenticate_validator(
            &mut self,
            request: impl tonic::IntoRequest<super::ValidatorAuthRequest>,
        ) -> std::result::Result<
            tonic::Response<super::MinerAuthResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.miner.v1.MinerDiscovery/AuthenticateValidator",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilca.miner.v1.MinerDiscovery",
                        "AuthenticateValidator",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Discover available nodes from miner
        pub async fn discover_nodes(
            &mut self,
            request: impl tonic::IntoRequest<super::DiscoverNodesRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ListNodeConnectionDetailsResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.miner.v1.MinerDiscovery/DiscoverNodes",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("basilca.miner.v1.MinerDiscovery", "DiscoverNodes"),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod miner_discovery_server {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with MinerDiscoveryServer.
    #[async_trait]
    pub trait MinerDiscovery: Send + Sync + 'static {
        /// Authenticate validator with the miner
        async fn authenticate_validator(
            &self,
            request: tonic::Request<super::ValidatorAuthRequest>,
        ) -> std::result::Result<
            tonic::Response<super::MinerAuthResponse>,
            tonic::Status,
        >;
        /// Discover available nodes from miner
        async fn discover_nodes(
            &self,
            request: tonic::Request<super::DiscoverNodesRequest>,
        ) -> std::result::Result<
            tonic::Response<super::ListNodeConnectionDetailsResponse>,
            tonic::Status,
        >;
    }
    /// MinerDiscovery service for validator-miner interaction
    #[derive(Debug)]
    pub struct MinerDiscoveryServer<T: MinerDiscovery> {
        inner: _Inner<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    struct _Inner<T>(Arc<T>);
    impl<T: MinerDiscovery> MinerDiscoveryServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            let inner = _Inner(inner);
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for MinerDiscoveryServer<T>
    where
        T: MinerDiscovery,
        B: Body + Send + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/basilca.miner.v1.MinerDiscovery/AuthenticateValidator" => {
                    #[allow(non_camel_case_types)]
                    struct AuthenticateValidatorSvc<T: MinerDiscovery>(pub Arc<T>);
                    impl<
                        T: MinerDiscovery,
                    > tonic::server::UnaryService<super::ValidatorAuthRequest>
                    for AuthenticateValidatorSvc<T> {
                        type Response = super::MinerAuthResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ValidatorAuthRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as MinerDiscovery>::authenticate_validator(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = AuthenticateValidatorSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilca.miner.v1.MinerDiscovery/DiscoverNodes" => {
                    #[allow(non_camel_case_types)]
                    struct DiscoverNodesSvc<T: MinerDiscovery>(pub Arc<T>);
                    impl<
                        T: MinerDiscovery,
                    > tonic::server::UnaryService<super::DiscoverNodesRequest>
                    for DiscoverNodesSvc<T> {
                        type Response = super::ListNodeConnectionDetailsResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::DiscoverNodesRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as MinerDiscovery>::discover_nodes(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = DiscoverNodesSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        Ok(
                            http::Response::builder()
                                .status(200)
                                .header("grpc-status", "12")
                                .header("content-type", "application/grpc")
                                .body(empty_body())
                                .unwrap(),
                        )
                    })
                }
            }
        }
    }
    impl<T: MinerDiscovery> Clone for MinerDiscoveryServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    impl<T: MinerDiscovery> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(Arc::clone(&self.0))
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: MinerDiscovery> tonic::server::NamedService for MinerDiscoveryServer<T> {
        const NAME: &'static str = "basilca.miner.v1.MinerDiscovery";
    }
}
