// This file is @generated by prost-build.
/// GPU Proof-of-Work Challenge Parameters
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuPowChallenge {
    /// Unique challenge ID for tracking
    #[prost(string, tag = "1")]
    pub challenge_id: ::prost::alloc::string::String,
    /// 64-bit seed for deterministic random matrix generation
    #[prost(uint64, tag = "2")]
    pub seed: u64,
    /// Matrix dimension N for N x N matrices
    #[prost(uint32, tag = "3")]
    pub matrix_dim: u32,
    /// Total number of matrices to generate and hold in VRAM
    #[prost(uint32, tag = "4")]
    pub num_matrices: u32,
    /// Index of first matrix operand (0-based)
    #[prost(uint32, tag = "5")]
    pub matrix_a_index: u32,
    /// Index of second matrix operand (0-based)
    #[prost(uint32, tag = "6")]
    pub matrix_b_index: u32,
    /// Validator's nonce for replay protection
    #[prost(string, tag = "7")]
    pub validator_nonce: ::prost::alloc::string::String,
    /// Challenge timestamp
    #[prost(message, optional, tag = "8")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
}
/// GPU Proof-of-Work Challenge Result
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuPowResult {
    /// Challenge ID this result corresponds to
    #[prost(string, tag = "1")]
    pub challenge_id: ::prost::alloc::string::String,
    /// SHA-256 hash of the resulting matrix (32 bytes)
    #[prost(bytes = "vec", tag = "2")]
    pub result_checksum: ::prost::alloc::vec::Vec<u8>,
    /// Execution time in milliseconds (matrix multiplication only)
    #[prost(uint64, tag = "3")]
    pub execution_time_ms: u64,
    /// Error message if challenge failed
    #[prost(string, tag = "4")]
    pub error_message: ::prost::alloc::string::String,
    /// Whether challenge succeeded
    #[prost(bool, tag = "5")]
    pub success: bool,
    /// Result timestamp
    #[prost(message, optional, tag = "6")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    /// GPU model that executed the challenge
    #[prost(string, tag = "7")]
    pub gpu_model: ::prost::alloc::string::String,
    /// VRAM allocated in MB
    #[prost(uint64, tag = "8")]
    pub vram_allocated_mb: u64,
}
/// Performance baseline for a specific GPU model
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuPerformanceBaseline {
    /// GPU model name (e.g., "NVIDIA GeForce RTX 4090")
    #[prost(string, tag = "1")]
    pub gpu_model: ::prost::alloc::string::String,
    /// Matrix dimension used for baseline
    #[prost(uint32, tag = "2")]
    pub matrix_dim: u32,
    /// Expected execution time in milliseconds
    #[prost(uint64, tag = "3")]
    pub expected_time_ms: u64,
    /// Tolerance percentage (e.g., 30 for ±30%)
    #[prost(uint32, tag = "4")]
    pub tolerance_percent: u32,
    /// Minimum acceptable time (prevents pre-computation)
    #[prost(uint64, tag = "5")]
    pub min_time_ms: u64,
    /// Maximum acceptable time (prevents inferior hardware)
    #[prost(uint64, tag = "6")]
    pub max_time_ms: u64,
}
/// Request for a new challenge
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ChallengeRequest {
    /// Node ID requesting the challenge
    #[prost(string, tag = "1")]
    pub node_id: ::prost::alloc::string::String,
    /// Claimed GPU model
    #[prost(string, tag = "2")]
    pub claimed_gpu_model: ::prost::alloc::string::String,
    /// Claimed VRAM in MB
    #[prost(uint64, tag = "3")]
    pub claimed_vram_mb: u64,
}
/// Response to challenge result submission
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VerificationResponse {
    /// Whether the challenge was verified successfully
    #[prost(bool, tag = "1")]
    pub verified: bool,
    /// Verification message
    #[prost(string, tag = "2")]
    pub message: ::prost::alloc::string::String,
    /// Performance score (0-100)
    #[prost(double, tag = "3")]
    pub performance_score: f64,
    /// Whether timing was within acceptable bounds
    #[prost(bool, tag = "4")]
    pub timing_valid: bool,
    /// Whether checksum matched expected
    #[prost(bool, tag = "5")]
    pub checksum_valid: bool,
}
/// Generated client implementations.
pub mod gpu_pow_validator_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    /// Service definition for GPU PoW validation
    #[derive(Debug, Clone)]
    pub struct GpuPowValidatorClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl GpuPowValidatorClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> GpuPowValidatorClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> GpuPowValidatorClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + Send + Sync,
        {
            GpuPowValidatorClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Request a new challenge from the validator
        pub async fn request_challenge(
            &mut self,
            request: impl tonic::IntoRequest<super::ChallengeRequest>,
        ) -> std::result::Result<
            tonic::Response<super::GpuPowChallenge>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.gpu_pow.v1.GpuPowValidator/RequestChallenge",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "basilca.gpu_pow.v1.GpuPowValidator",
                        "RequestChallenge",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        /// Submit challenge result for verification
        pub async fn submit_result(
            &mut self,
            request: impl tonic::IntoRequest<super::GpuPowResult>,
        ) -> std::result::Result<
            tonic::Response<super::VerificationResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/basilca.gpu_pow.v1.GpuPowValidator/SubmitResult",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("basilca.gpu_pow.v1.GpuPowValidator", "SubmitResult"),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod gpu_pow_validator_server {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with GpuPowValidatorServer.
    #[async_trait]
    pub trait GpuPowValidator: Send + Sync + 'static {
        /// Request a new challenge from the validator
        async fn request_challenge(
            &self,
            request: tonic::Request<super::ChallengeRequest>,
        ) -> std::result::Result<tonic::Response<super::GpuPowChallenge>, tonic::Status>;
        /// Submit challenge result for verification
        async fn submit_result(
            &self,
            request: tonic::Request<super::GpuPowResult>,
        ) -> std::result::Result<
            tonic::Response<super::VerificationResponse>,
            tonic::Status,
        >;
    }
    /// Service definition for GPU PoW validation
    #[derive(Debug)]
    pub struct GpuPowValidatorServer<T: GpuPowValidator> {
        inner: _Inner<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    struct _Inner<T>(Arc<T>);
    impl<T: GpuPowValidator> GpuPowValidatorServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            let inner = _Inner(inner);
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for GpuPowValidatorServer<T>
    where
        T: GpuPowValidator,
        B: Body + Send + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/basilca.gpu_pow.v1.GpuPowValidator/RequestChallenge" => {
                    #[allow(non_camel_case_types)]
                    struct RequestChallengeSvc<T: GpuPowValidator>(pub Arc<T>);
                    impl<
                        T: GpuPowValidator,
                    > tonic::server::UnaryService<super::ChallengeRequest>
                    for RequestChallengeSvc<T> {
                        type Response = super::GpuPowChallenge;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ChallengeRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as GpuPowValidator>::request_challenge(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = RequestChallengeSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/basilca.gpu_pow.v1.GpuPowValidator/SubmitResult" => {
                    #[allow(non_camel_case_types)]
                    struct SubmitResultSvc<T: GpuPowValidator>(pub Arc<T>);
                    impl<
                        T: GpuPowValidator,
                    > tonic::server::UnaryService<super::GpuPowResult>
                    for SubmitResultSvc<T> {
                        type Response = super::VerificationResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::GpuPowResult>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as GpuPowValidator>::submit_result(&inner, request).await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = SubmitResultSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        Ok(
                            http::Response::builder()
                                .status(200)
                                .header("grpc-status", "12")
                                .header("content-type", "application/grpc")
                                .body(empty_body())
                                .unwrap(),
                        )
                    })
                }
            }
        }
    }
    impl<T: GpuPowValidator> Clone for GpuPowValidatorServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    impl<T: GpuPowValidator> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(Arc::clone(&self.0))
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: GpuPowValidator> tonic::server::NamedService for GpuPowValidatorServer<T> {
        const NAME: &'static str = "basilca.gpu_pow.v1.GpuPowValidator";
    }
}
