// This file is @generated by prost-build.
/// Timestamp wrapper for consistent time handling
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Timestamp {
    #[prost(message, optional, tag = "1")]
    pub value: ::core::option::Option<::prost_types::Timestamp>,
}
/// Unique resource identifier
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceId {
    #[prost(string, tag = "1")]
    pub value: ::prost::alloc::string::String,
}
/// GPU specification details
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuSpec {
    /// GPU model name (e.g., "RTX 4090", "A100")
    #[prost(string, tag = "1")]
    pub model: ::prost::alloc::string::String,
    /// GPU memory in MB
    #[prost(uint64, tag = "2")]
    pub memory_mb: u64,
    /// GPU unique identifier/UUID
    #[prost(string, tag = "3")]
    pub uuid: ::prost::alloc::string::String,
    /// Driver version
    #[prost(string, tag = "4")]
    pub driver_version: ::prost::alloc::string::String,
    /// CUDA version (if applicable)
    #[prost(string, tag = "5")]
    pub cuda_version: ::prost::alloc::string::String,
    /// GPU utilization percentage (0-100)
    #[prost(double, tag = "6")]
    pub utilization_percent: f64,
    /// Memory utilization percentage (0-100)
    #[prost(double, tag = "7")]
    pub memory_utilization_percent: f64,
    /// Temperature in Celsius
    #[prost(double, tag = "8")]
    pub temperature_celsius: f64,
    /// Power consumption in watts
    #[prost(double, tag = "9")]
    pub power_watts: f64,
    /// Clock speeds
    #[prost(uint32, tag = "10")]
    pub core_clock_mhz: u32,
    #[prost(uint32, tag = "11")]
    pub memory_clock_mhz: u32,
    /// Compute capability (for CUDA GPUs)
    #[prost(string, tag = "12")]
    pub compute_capability: ::prost::alloc::string::String,
}
/// CPU specification details
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CpuSpec {
    /// CPU model name
    #[prost(string, tag = "1")]
    pub model: ::prost::alloc::string::String,
    /// Number of physical cores
    #[prost(uint32, tag = "2")]
    pub physical_cores: u32,
    /// Number of logical cores (with hyperthreading)
    #[prost(uint32, tag = "3")]
    pub logical_cores: u32,
    /// Base frequency in MHz
    #[prost(uint32, tag = "4")]
    pub base_frequency_mhz: u32,
    /// Max frequency in MHz
    #[prost(uint32, tag = "5")]
    pub max_frequency_mhz: u32,
    /// CPU architecture (x86_64, arm64, etc.)
    #[prost(string, tag = "6")]
    pub architecture: ::prost::alloc::string::String,
    /// CPU vendor (Intel, AMD, etc.)
    #[prost(string, tag = "7")]
    pub vendor: ::prost::alloc::string::String,
    /// Cache sizes in KB
    #[prost(uint32, tag = "8")]
    pub l1_cache_kb: u32,
    #[prost(uint32, tag = "9")]
    pub l2_cache_kb: u32,
    #[prost(uint32, tag = "10")]
    pub l3_cache_kb: u32,
    /// Current utilization percentage (0-100)
    #[prost(double, tag = "11")]
    pub utilization_percent: f64,
    /// Current temperature in Celsius
    #[prost(double, tag = "12")]
    pub temperature_celsius: f64,
}
/// Memory specification
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MemorySpec {
    /// Total system memory in MB
    #[prost(uint64, tag = "1")]
    pub total_mb: u64,
    /// Available memory in MB
    #[prost(uint64, tag = "2")]
    pub available_mb: u64,
    /// Used memory in MB
    #[prost(uint64, tag = "3")]
    pub used_mb: u64,
    /// Memory type (DDR4, DDR5, etc.)
    #[prost(string, tag = "4")]
    pub memory_type: ::prost::alloc::string::String,
    /// Memory speed in MHz
    #[prost(uint32, tag = "5")]
    pub speed_mhz: u32,
}
/// Storage specification
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StorageSpec {
    /// Total storage in MB
    #[prost(uint64, tag = "1")]
    pub total_mb: u64,
    /// Available storage in MB
    #[prost(uint64, tag = "2")]
    pub available_mb: u64,
    /// Used storage in MB
    #[prost(uint64, tag = "3")]
    pub used_mb: u64,
    /// Storage type (SSD, HDD, NVMe)
    #[prost(string, tag = "4")]
    pub storage_type: ::prost::alloc::string::String,
    /// Mount point or drive identifier
    #[prost(string, tag = "5")]
    pub mount_point: ::prost::alloc::string::String,
    /// Read speed in MB/s
    #[prost(double, tag = "6")]
    pub read_speed_mbps: f64,
    /// Write speed in MB/s
    #[prost(double, tag = "7")]
    pub write_speed_mbps: f64,
}
/// Network performance metrics
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NetworkPerformance {
    /// Download bandwidth in Mbps
    #[prost(double, tag = "1")]
    pub download_mbps: f64,
    /// Upload bandwidth in Mbps
    #[prost(double, tag = "2")]
    pub upload_mbps: f64,
    /// Latency in milliseconds
    #[prost(double, tag = "3")]
    pub latency_ms: f64,
    /// Packet loss percentage (0-100)
    #[prost(double, tag = "4")]
    pub packet_loss_percent: f64,
    /// Network interface name
    #[prost(string, tag = "5")]
    pub interface_name: ::prost::alloc::string::String,
    /// Public IP address
    #[prost(string, tag = "6")]
    pub public_ip: ::prost::alloc::string::String,
    /// Geographic location (optional)
    #[prost(string, tag = "7")]
    pub location: ::prost::alloc::string::String,
}
/// Operating system information
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OsInfo {
    /// OS name (Linux, Windows, macOS)
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    /// OS version
    #[prost(string, tag = "2")]
    pub version: ::prost::alloc::string::String,
    /// Kernel version
    #[prost(string, tag = "3")]
    pub kernel_version: ::prost::alloc::string::String,
    /// Distribution (for Linux)
    #[prost(string, tag = "4")]
    pub distribution: ::prost::alloc::string::String,
    /// Architecture (x86_64, arm64)
    #[prost(string, tag = "5")]
    pub architecture: ::prost::alloc::string::String,
    /// Hostname
    #[prost(string, tag = "6")]
    pub hostname: ::prost::alloc::string::String,
    /// Uptime in seconds
    #[prost(uint64, tag = "7")]
    pub uptime_seconds: u64,
}
/// Docker environment information
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DockerInfo {
    /// Docker version
    #[prost(string, tag = "1")]
    pub version: ::prost::alloc::string::String,
    /// Docker API version
    #[prost(string, tag = "2")]
    pub api_version: ::prost::alloc::string::String,
    /// Available storage driver
    #[prost(string, tag = "3")]
    pub storage_driver: ::prost::alloc::string::String,
    /// Running containers count
    #[prost(uint32, tag = "4")]
    pub running_containers: u32,
    /// Total containers count
    #[prost(uint32, tag = "5")]
    pub total_containers: u32,
    /// Total images count
    #[prost(uint32, tag = "6")]
    pub total_images: u32,
    /// Whether Docker is accessible
    #[prost(bool, tag = "7")]
    pub accessible: bool,
    /// Whether GPU support is available (nvidia-docker, etc.)
    #[prost(bool, tag = "8")]
    pub gpu_support: bool,
    /// Security features (AppArmor, SELinux, Seccomp)
    #[prost(string, repeated, tag = "9")]
    pub security_features: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
/// System resource limits and quotas
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceLimits {
    /// Maximum CPU cores that can be allocated
    #[prost(uint32, tag = "1")]
    pub max_cpu_cores: u32,
    /// Maximum memory in MB that can be allocated
    #[prost(uint64, tag = "2")]
    pub max_memory_mb: u64,
    /// Maximum storage in MB that can be allocated
    #[prost(uint64, tag = "3")]
    pub max_storage_mb: u64,
    /// Maximum number of concurrent containers
    #[prost(uint32, tag = "4")]
    pub max_containers: u32,
    /// Network bandwidth limit in Mbps
    #[prost(double, tag = "5")]
    pub max_bandwidth_mbps: f64,
    /// Maximum GPU count that can be allocated
    #[prost(uint32, tag = "6")]
    pub max_gpus: u32,
}
/// Challenge parameters for computational verification
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ChallengeParameters {
    /// Challenge type identifier (e.g. "matrix_multiplication_pow")
    #[prost(string, tag = "1")]
    pub challenge_type: ::prost::alloc::string::String,
    /// Challenge-specific parameters (for backward compatibility)
    #[prost(string, tag = "2")]
    pub parameters_json: ::prost::alloc::string::String,
    /// Expected computation time in seconds
    #[prost(uint32, tag = "3")]
    pub expected_duration_seconds: u32,
    /// Difficulty level (1-10)
    #[prost(uint32, tag = "4")]
    pub difficulty_level: u32,
    /// Random seed for deterministic results (legacy string format)
    #[prost(string, tag = "5")]
    pub seed: ::prost::alloc::string::String,
    /// Machine information for context
    #[prost(message, optional, tag = "6")]
    pub machine_info: ::core::option::Option<MachineInfo>,
    /// GPU PoW specific fields
    /// 64-bit seed for deterministic random matrix generation
    #[prost(uint64, tag = "7")]
    pub gpu_pow_seed: u64,
    /// Matrix dimension N for N x N matrices
    #[prost(uint32, tag = "8")]
    pub matrix_dim: u32,
    /// Total number of matrices to generate and hold in VRAM
    #[prost(uint32, tag = "9")]
    pub num_matrices: u32,
    /// Index of first matrix operand (0-based) - DEPRECATED for v2
    #[prost(uint32, tag = "10")]
    pub matrix_a_index: u32,
    /// Index of second matrix operand (0-based) - DEPRECATED for v2
    #[prost(uint32, tag = "11")]
    pub matrix_b_index: u32,
    /// Validator's nonce for replay protection
    #[prost(string, tag = "12")]
    pub validator_nonce: ::prost::alloc::string::String,
    /// Number of matrix multiplication iterations for bandwidth testing (v2)
    #[prost(uint32, tag = "13")]
    pub num_iterations: u32,
    /// Sampling rate for validator verification (0.0-1.0, default 0.1 = 10%)
    #[prost(float, tag = "14")]
    pub verification_sample_rate: f32,
}
/// Machine information for challenge context
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MachineInfo {
    /// GPU specifications used in challenge
    #[prost(message, repeated, tag = "1")]
    pub gpus: ::prost::alloc::vec::Vec<GpuSpec>,
    /// CPU specification
    #[prost(message, optional, tag = "2")]
    pub cpu: ::core::option::Option<CpuSpec>,
    /// Memory specification
    #[prost(message, optional, tag = "3")]
    pub memory: ::core::option::Option<MemorySpec>,
    /// Operating system info
    #[prost(message, optional, tag = "4")]
    pub os_info: ::core::option::Option<OsInfo>,
    /// Unique machine fingerprint
    #[prost(string, tag = "5")]
    pub fingerprint: ::prost::alloc::string::String,
}
/// Challenge solution/result
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ChallengeResult {
    /// Solution data (format depends on challenge type)
    #[prost(string, tag = "1")]
    pub solution: ::prost::alloc::string::String,
    /// Execution time in milliseconds
    #[prost(uint64, tag = "2")]
    pub execution_time_ms: u64,
    /// GPU utilization during execution
    #[prost(double, repeated, tag = "3")]
    pub gpu_utilization: ::prost::alloc::vec::Vec<f64>,
    /// Memory usage during execution in MB
    #[prost(uint64, tag = "4")]
    pub memory_usage_mb: u64,
    /// Any error messages
    #[prost(string, tag = "5")]
    pub error_message: ::prost::alloc::string::String,
    /// Additional metadata as JSON
    #[prost(string, tag = "6")]
    pub metadata_json: ::prost::alloc::string::String,
    /// GPU PoW specific fields
    /// SHA-256 hash of the resulting matrix (32 bytes)
    #[prost(bytes = "vec", tag = "7")]
    pub result_checksum: ::prost::alloc::vec::Vec<u8>,
    /// Whether challenge succeeded
    #[prost(bool, tag = "8")]
    pub success: bool,
    /// GPU model that executed the challenge
    #[prost(string, tag = "9")]
    pub gpu_model: ::prost::alloc::string::String,
    /// VRAM allocated in MB
    #[prost(uint64, tag = "10")]
    pub vram_allocated_mb: u64,
    /// Challenge ID this result corresponds to
    #[prost(string, tag = "11")]
    pub challenge_id: ::prost::alloc::string::String,
}
/// Container specification for rental
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ContainerSpec {
    /// Docker image to run
    #[prost(string, tag = "1")]
    pub image: ::prost::alloc::string::String,
    /// Environment variables
    #[prost(map = "string, string", tag = "2")]
    pub environment: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Port mappings (container_port -> host_port)
    #[prost(map = "string, string", tag = "3")]
    pub port_mappings: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Volume mounts (host_path -> container_path)
    #[prost(map = "string, string", tag = "4")]
    pub volume_mounts: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Resource limits
    #[prost(message, optional, tag = "5")]
    pub resource_limits: ::core::option::Option<ResourceLimits>,
    /// Command to run (overrides Docker CMD)
    #[prost(string, repeated, tag = "6")]
    pub command: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Working directory
    #[prost(string, tag = "7")]
    pub working_directory: ::prost::alloc::string::String,
    /// User to run as
    #[prost(string, tag = "8")]
    pub user: ::prost::alloc::string::String,
    /// GPU requirements
    #[prost(string, repeated, tag = "9")]
    pub gpu_requirements: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Network mode
    #[prost(string, tag = "10")]
    pub network_mode: ::prost::alloc::string::String,
}
/// Container status information
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ContainerStatus {
    /// Container ID
    #[prost(string, tag = "1")]
    pub container_id: ::prost::alloc::string::String,
    /// Current status (running, stopped, error, etc.)
    #[prost(string, tag = "2")]
    pub status: ::prost::alloc::string::String,
    /// Status message
    #[prost(string, tag = "3")]
    pub status_message: ::prost::alloc::string::String,
    /// Created timestamp
    #[prost(message, optional, tag = "4")]
    pub created_at: ::core::option::Option<Timestamp>,
    /// Started timestamp (if applicable)
    #[prost(message, optional, tag = "5")]
    pub started_at: ::core::option::Option<Timestamp>,
    /// Finished timestamp (if applicable)
    #[prost(message, optional, tag = "6")]
    pub finished_at: ::core::option::Option<Timestamp>,
    /// Exit code (if finished)
    #[prost(int32, tag = "7")]
    pub exit_code: i32,
    /// Resource usage statistics
    #[prost(message, optional, tag = "8")]
    pub resource_usage: ::core::option::Option<ResourceUsageStats>,
}
/// Resource usage statistics
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceUsageStats {
    /// CPU usage percentage
    #[prost(double, tag = "1")]
    pub cpu_percent: f64,
    /// Memory usage in MB
    #[prost(uint64, tag = "2")]
    pub memory_mb: u64,
    /// Network I/O in bytes
    #[prost(uint64, tag = "3")]
    pub network_rx_bytes: u64,
    #[prost(uint64, tag = "4")]
    pub network_tx_bytes: u64,
    /// Disk I/O in bytes
    #[prost(uint64, tag = "5")]
    pub disk_read_bytes: u64,
    #[prost(uint64, tag = "6")]
    pub disk_write_bytes: u64,
    /// GPU usage (if applicable)
    #[prost(double, repeated, tag = "7")]
    pub gpu_utilization: ::prost::alloc::vec::Vec<f64>,
    #[prost(uint64, repeated, tag = "8")]
    pub gpu_memory_mb: ::prost::alloc::vec::Vec<u64>,
}
/// Log entry for streaming logs
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogEntry {
    /// Timestamp of log entry
    #[prost(message, optional, tag = "1")]
    pub timestamp: ::core::option::Option<Timestamp>,
    /// Log level (INFO, WARN, ERROR, DEBUG)
    #[prost(string, tag = "2")]
    pub level: ::prost::alloc::string::String,
    /// Source of log (stdout, stderr, system)
    #[prost(string, tag = "3")]
    pub source: ::prost::alloc::string::String,
    /// Log message content
    #[prost(string, tag = "4")]
    pub message: ::prost::alloc::string::String,
    /// Additional metadata
    #[prost(map = "string, string", tag = "5")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
/// Error information
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ErrorInfo {
    /// Error code
    #[prost(string, tag = "1")]
    pub code: ::prost::alloc::string::String,
    /// Human-readable error message
    #[prost(string, tag = "2")]
    pub message: ::prost::alloc::string::String,
    /// Additional error details
    #[prost(map = "string, string", tag = "3")]
    pub details: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    /// Timestamp when error occurred
    #[prost(message, optional, tag = "4")]
    pub timestamp: ::core::option::Option<Timestamp>,
    /// Stack trace (if available)
    #[prost(string, tag = "5")]
    pub stack_trace: ::prost::alloc::string::String,
}
/// GPU attestation report from gpu-attestor
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuAttestation {
    /// Attestation report data
    #[prost(bytes = "vec", tag = "1")]
    pub attestation_data: ::prost::alloc::vec::Vec<u8>,
    /// Signature of the attestation
    #[prost(bytes = "vec", tag = "2")]
    pub signature: ::prost::alloc::vec::Vec<u8>,
    /// Certificate chain
    #[prost(bytes = "vec", repeated, tag = "3")]
    pub certificate_chain: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    /// GPU specifications included in attestation
    #[prost(message, optional, tag = "4")]
    pub gpu_spec: ::core::option::Option<GpuSpec>,
    /// Timestamp of attestation
    #[prost(message, optional, tag = "5")]
    pub timestamp: ::core::option::Option<Timestamp>,
    /// Attestation type/method
    #[prost(string, tag = "6")]
    pub attestation_type: ::prost::alloc::string::String,
    /// Additional metadata
    #[prost(map = "string, string", tag = "7")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
/// System profile including hardware and software information
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SystemProfile {
    /// CPU specifications
    #[prost(message, optional, tag = "1")]
    pub cpu: ::core::option::Option<CpuSpec>,
    /// Memory specifications
    #[prost(message, optional, tag = "2")]
    pub memory: ::core::option::Option<MemorySpec>,
    /// Storage specifications
    #[prost(message, repeated, tag = "3")]
    pub storage: ::prost::alloc::vec::Vec<StorageSpec>,
    /// Network performance
    #[prost(message, optional, tag = "4")]
    pub network: ::core::option::Option<NetworkPerformance>,
    /// Operating system information
    #[prost(message, optional, tag = "5")]
    pub os_info: ::core::option::Option<OsInfo>,
    /// Docker environment information
    #[prost(message, optional, tag = "6")]
    pub docker_info: ::core::option::Option<DockerInfo>,
    /// GPU specifications (can be multiple)
    #[prost(message, repeated, tag = "7")]
    pub gpus: ::prost::alloc::vec::Vec<GpuSpec>,
    /// System fingerprint
    #[prost(string, tag = "8")]
    pub fingerprint: ::prost::alloc::string::String,
    /// Profile timestamp
    #[prost(message, optional, tag = "9")]
    pub timestamp: ::core::option::Option<Timestamp>,
}
/// Resource utilization metrics
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceUtilization {
    /// CPU usage percentage (0-100)
    #[prost(double, tag = "1")]
    pub cpu_percent: f64,
    /// Memory usage in MB
    #[prost(uint64, tag = "2")]
    pub memory_used_mb: u64,
    /// Memory total in MB
    #[prost(uint64, tag = "3")]
    pub memory_total_mb: u64,
    /// Storage usage in MB
    #[prost(uint64, tag = "4")]
    pub storage_used_mb: u64,
    /// Storage total in MB
    #[prost(uint64, tag = "5")]
    pub storage_total_mb: u64,
    /// Network I/O rates
    #[prost(double, tag = "6")]
    pub network_rx_mbps: f64,
    #[prost(double, tag = "7")]
    pub network_tx_mbps: f64,
    /// GPU utilization (per GPU)
    #[prost(double, repeated, tag = "8")]
    pub gpu_utilization_percent: ::prost::alloc::vec::Vec<f64>,
    /// GPU memory usage (per GPU) in MB
    #[prost(uint64, repeated, tag = "9")]
    pub gpu_memory_used_mb: ::prost::alloc::vec::Vec<u64>,
    /// Number of running containers
    #[prost(uint32, tag = "10")]
    pub running_containers: u32,
    /// Timestamp of measurement
    #[prost(message, optional, tag = "11")]
    pub timestamp: ::core::option::Option<Timestamp>,
}
/// Performance baseline for a specific GPU model
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpuPerformanceBaseline {
    /// GPU model name (e.g., "NVIDIA GeForce RTX 4090")
    #[prost(string, tag = "1")]
    pub gpu_model: ::prost::alloc::string::String,
    /// Matrix dimension used for baseline
    #[prost(uint32, tag = "2")]
    pub matrix_dim: u32,
    /// Expected execution time in milliseconds
    #[prost(uint64, tag = "3")]
    pub expected_time_ms: u64,
    /// Tolerance percentage (e.g., 30 for ±30%)
    #[prost(uint32, tag = "4")]
    pub tolerance_percent: u32,
    /// Minimum acceptable time (prevents pre-computation)
    #[prost(uint64, tag = "5")]
    pub min_time_ms: u64,
    /// Maximum acceptable time (prevents inferior hardware)
    #[prost(uint64, tag = "6")]
    pub max_time_ms: u64,
}
/// Authentication data for miner-to-node requests
#[derive(serde::Serialize, serde::Deserialize)]
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MinerAuthentication {
    /// Miner's hotkey address
    #[prost(string, tag = "1")]
    pub miner_hotkey: ::prost::alloc::string::String,
    /// Timestamp of the request (Unix milliseconds)
    #[prost(uint64, tag = "2")]
    pub timestamp_ms: u64,
    /// Nonce to prevent replay attacks
    #[prost(bytes = "vec", tag = "3")]
    pub nonce: ::prost::alloc::vec::Vec<u8>,
    /// Signature of the request payload
    #[prost(bytes = "vec", tag = "4")]
    pub signature: ::prost::alloc::vec::Vec<u8>,
    /// Request ID for tracking
    #[prost(bytes = "vec", tag = "5")]
    pub request_id: ::prost::alloc::vec::Vec<u8>,
}
