# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['koinput']

package_data = \
{'': ['*']}

install_requires = \
['colorama>=0.4.4,<0.5.0']

setup_kwargs = {
    'name': 'koinput',
    'version': '0.2.0.3',
    'description': 'Maximal simplification of Input / Output for text programs.',
    'long_description': '.. image:: https://img.shields.io/pypi/v/koinput.svg\n    :target: https://pypi.org/project/koinput/\n    :alt: Latest Version\n\n.. image:: https://img.shields.io/pypi/pyversions/koinput.svg\n    :target: https://pypi.org/project/koinput/\n    :alt: Supported Python versions\n\n.. contents:: Table of contents\n   :depth: 3\n\nkoinput\n=======\n\nMaximal simplification of Input / Output for text programs.\n\n`PyPI for releases <https://pypi.org/project/koinput/>`_ |\n`Github for source <https://github.com/k0perX-X/koinput>`_\n\nInstallation\n============\n\nRequirements `colorama <https://pypi.org/project/colorama/>`_ library.\n\n.. code-block:: bash\n\n    pip install koinput\n\nHow to use\n==========\n\nInputs\n------\n\nThe library has two types of inputs:\n\n* int_input\n* float_input\n\nThey have the same settings and differ only in the type of output.\n\nExplanation of input parameters\n+++++++++++++++++++++++++++++++\n\n.. code-block:: python\n\n\tdef int_input(input_suggestion="", greater=float(\'-inf\'), less=float(\'inf\'), console_style=colorama.Fore.RESET,\n\t\t      error_message=\'Invalid number format.\\n\', error_message_style=colorama.Fore.RED,\n\t\t      input_is_greater_than_less_error="The number is greater than acceptable.\\n",\n\t\t      input_is_less_than_greater_error="The number is less than acceptable.\\n",\n\t\t      input_is_less_error_style=None, input_is_greater_error_style=None,\n\t\t      strictly_greater=True, strictly_less=True):\n\n\n``input_suggestion=""``\n\tInput suggestion that will be displayed when the function is run.\n\n``greater=float(\'-inf\'), less=float(\'inf\')``\n\tThe range in which the entered number should be included.\n\n``strictly_greater=True, strictly_less=True``\n\tControlling the mathematical strictly of comparisons.\n\n``console_style=colorama.Fore.RESET``\n\tSets the base display style for the terminal. I recommend using the colorama library for easier style customization. You can also use standard sequences (example: "\\x1b[39m").\n\n``error_message=\'Invalid number format.\\n\'``\n\tError message when converting input to number.\n\n``error_message_style=colorama.Fore.RED``\n\tError message style.\n\n``input_is_greater_than_less_error="The number is greater than acceptable.\\n"``\n\tThe message issued when the number is greater than allowed.\n\n``input_is_less_than_greater_error="The number is less than acceptable.\\n"``\n\tThe message issued when the number is less than allowed.\n\n``input_is_less_error_style=None, input_is_greater_error_style=None``\n\tOut of range error styles.\n\nUsage example\n+++++++++++++\n\n.. code-block:: python\n\n    def area_triangle(base, height):\n        return 0.5 * base * height\n\n    print(area_triangle(float_input(input_suggestion=\'Enter the base of the triangle: \'),\n                        float_input(input_suggestion=\'Введите высоту треугольника: \')))\n\n.. code-block:: python\n\n\tmas = [randint(0, 999) for i in range(int_input(input_suggestion="Enter the size of the array: "))]\n\nMenu\n----\n\nThe menu class is used to quickly create a text menu based on existing functions.\n\nFirst, you need to create an instance of the class:\n\n.. code-block:: python\n\n\tfrom koinput import Menu\n\n\tmenu = Menu()\n\nThe next step is to add function calls to the menu. This can be done in 2 ways: using a decorator or a function.\n\n.. code-block:: python\n\n\t@menu.add_to_menu_dec(\'Name shown in the menu\', *arguments_passed_to_the_function)\n\tdef z2(a, b, c):\n\t\tdef area_circle(radius):\n\t\t\treturn math.pi * radius ** 2\n\n\t\tprint(area_circle(float_input(input_suggestion=\'Введите радиус круга: \')))\n\n\tOR\n\n\tdef z2(a, b, c):\n\t\tdef area_circle(radius):\n\t\t\treturn math.pi * radius ** 2\n\n\t\tprint(area_circle(float_input(input_suggestion=\'Введите радиус круга: \')))\n\n\tmenu.add_to_menu(\'Name shown in the menu\', z2, *arguments_passed_to_the_function)\n\nUse the show_menu command to display the menu.\n\n.. code-block:: python\n\n\tmenu.show_menu(title=None, title_style=None, number_of_leading_spaces_title=2, console_style=Fore.RESET,\n\t\t       order_of_items=None, number_of_leading_spaces=4, separator=\' - \', items_style=None,\n\t\t       input_suggestion=\'Select a menu item: \', enable_menu_item_exit=True, menu_item_exit=\'Exit\',\n\t\t       exit_offer=\'Press Enter to exit...\'):\n\n``title=None``\n\tMenu title.\n\n``title_style=None``\n\tSets the title display style. I recommend using the colorama library for easier style customization. You can also use standard sequences (example: "\\x1b[39m").\n\n``number_of_leading_spaces_title=2``\n\tSets the number of spaces before the menu title.\n\n``console_style=Fore.RESET``\n\tSets the base display style for the terminal. I recommend using the colorama library for easier style customization. You can also use standard sequences (example: "\\x1b[39m").\n\n``number_of_leading_spaces=4``\n\tSets the number of spaces before the menu items.\n\n``separator=\' - \'``\n\tSeparator between number and menu item name.\n\n``items_style=None``\n\tSets the menu item display style.\n\n``input_suggestion=\'Select a menu item: \'``\n\tInput suggestion at the end of the menu.\n\n``enable_menu_item_exit=True``\n\tEnabling the menu item exit. If False, then after selecting one of the items the menu will close.\n\n``menu_item_exit=\'Exit\'``\n\tThe name of the menu exit item.\n\n``exit_offer=\'Press Enter to exit...\'``\n\tExit message.\n\n``order_of_items=None``\n\tCustom order of issuing menu items. It is either a tuple of int or a tuple of str. A tuple of int must contain the ordinal numbers of items starting from 0 (the numbers are given in the order in which they are declared). The str tuple must contain the names of the menu items in the order they appear.\n\nChange the function of output from the menu.\n\nThis is necessary when you do not need an exit confirmation or when you exit you need to launch another menu or some function.\n\nExample with disabling the exit confirmation:\n\n.. code-block:: python\n\n\t@menu.reassign_menu_exit()\n\tdef menu_exit(exit_offer):\n\t\tdef f():\n\t\t\tpass\n\n\t\treturn f\n\nExample with displaying another menu:\n\n.. code-block:: python\n\n\t@menu.reassign_menu_exit()\n\tdef menu_exit(exit_offer):\n\t\tdef f():\n\t\t\tmenu2.show_menu(title=\'MENU\', title_colour=colorama.Fore.BLUE, enable_menu_item_exit=False)\n\n\t\treturn f\n\nUsage example\n+++++++++++++\n\n.. code-block:: python\n\n\timport math\n\tfrom koinput import float_input, Menu\n\timport colorama\n\n\tmenu = Menu()\n\n\n\t@menu.add_to_menu_dec(\'Площадь треугольника\')\n\tdef z1():\n\t\tdef area_triangle(base, height):\n\t\t\treturn 0.5 * base * height\n\n\t\tprint(area_triangle(float_input(input_suggestion=\'Введите основание треугольника: \'),\n\t\t\t\t    float_input(input_suggestion=\'Введите высоту треугольника: \')))\n\n\n\t@menu.add_to_menu_dec(\'Площадь круга\')\n\tdef z2():\n\t\tdef area_circle(radius):\n\t\t\treturn math.pi * radius ** 2\n\n\t\tprint(area_circle(float_input(input_suggestion=\'Введите радиус круга: \')))\n\n\n\t@menu.add_to_menu_dec(\'Расстояние от точки до точки\')\n\tdef z3():\n\t\tdef distance(x1, y1, x2, y2):\n\t\t\treturn math.sqrt((x2 - x1) ** 2 + (y2 - y1) ** 2)\n\n\t\tprint(distance(float_input(input_suggestion=\'Введите X первой точки: \'),\n\t\t\t       float_input(input_suggestion=\'Введите Y первой точки: \'),\n\t\t\t       float_input(input_suggestion=\'Введите X второй точки: \'),\n\t\t\t       float_input(input_suggestion=\'Введите Y второй точки: \')))\n\n\n\tdef z4():\n\t\tdef capitalize_word(word):\n\t\t\treturn word[0].upper() + word[1::]\n\n\t\tdef capitalize_string(s):\n\t\t\tss = s.split()\n\t\t\tfor word in ss:\n\t\t\t\ts = s.replace(word, capitalize_word(word))\n\t\t\treturn s\n\n\t\tprint(\'Введите строку для изменения: \')\n\t\tprint(capitalize_string(input()))\n\n\n\t@menu.reassign_menu_exit()\n\tdef menu_exit(exit_offer):\n\t\tdef f():\n\t\t\tpass\n\n\t\treturn f\n\n\n\tdef main():\n\t\tmenu.add_to_menu(\'Capitalize\', z4)\n\t\tmenu.show_menu(title=\'МЕНЮ\', title_colour=colorama.Fore.BLUE)\n\n\n\tif __name__ == \'__main__\':\n\t\tmain()\n\n\n',
    'author': 'Николай Перминов',
    'author_email': 'kolya-perminov@ya.ru',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/k0perX-X/koinput',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
