from setuptools import setup, Extension

with open('./README.md') as f:
  long_description = f.read()

setup(
  name = 'contextSearching',         # How you named your package folder (MyLib)
  packages = ['contextSearching'],   # Chose the same as "name"
  version = '0.4.2',      # Start with a small number and increase it with every change you make
  license='MIT',        # Chose a license from here: https://help.github.com/articles/licensing-a-repository
  description = 'Search the context where a token appears',   # Give a short description about your library
  long_description=long_description,
  long_description_content_type='text/markdown', 
  author = 'Xiao Ma',                   # Type in your name
  author_email = 'Marshalma0923@gmail.com',      # Type in your E-Mail
  url = 'https://github.com/ALaughingHorse/ContextSearching',   # Provide either the link to your github or to your website
  download_url = 'https://github.com/ALaughingHorse/ContextSearching/archive/v_04_2.tar.gz',    # I explain this later on
  keywords = ['NLP'],   # Keywords that define your package best
  install_requires=[            # I get to this in a second
          'tokenizer_xm',
          'pandas',
          'numpy'
      ],
  classifiers=[
    'Development Status :: 3 - Alpha',      # Chose either "3 - Alpha", "4 - Beta" or "5 - Production/Stable" as the current state of your package
    'Intended Audience :: Developers',      # Define that your audience are developers
    'Topic :: Software Development :: Build Tools',
    'License :: OSI Approved :: MIT License',   # Again, pick a license
    'Programming Language :: Python :: 3',      #Specify which pyhton versions that you want to support
    'Programming Language :: Python :: 3.4',
    'Programming Language :: Python :: 3.5',
    'Programming Language :: Python :: 3.6',
    'Programming Language :: Python :: 3.7'
  ],
)