from .user import User


class CreatorCode:
    """Represents a Creator Code.

    Attributes
    -----------
    user: :class:`User`
        The user of the creator code.
    disabled: :class:`bool`
        Whether the Creator Code is disabled or not.
    slug: :class:`str`
        The slug of the Creator Code
    verified: :class:`bool`
        Whether the Creator Code is verified or not.
    raw_data: :class:`dict`
        The raw data from request. Can be used for saving and re-creating the class.
    """

    def __init__(self, data):
        self.user = User({'id': data.get('id'), 'displayName': data.get('displayName')})
        self.disabled = data.get('status', '').lower() == 'disabled'
        self.slug = data.get('slug')
        self.verified = data.get('verified', False)
        self.raw_data = data
