from .base_model import *


class OmsLpu(BaseModel):
    """
    Лечебно-профилактические учреждения (ЛПУ)
    """

    id = models.AutoField(db_column="LPUID", primary_key=True)
    uuid = models.CharField(db_column="GUIDLPU", max_length=36, unique=True, default=uuid.uuid4)
    okato = models.ForeignKey("OmsOkato", models.DO_NOTHING, db_column="rf_OKATOID")
    c_ogrn = models.CharField(db_column="C_OGRN", max_length=15)
    m_names = models.CharField(db_column="M_NAMES", max_length=200)
    m_namef = models.CharField(db_column="M_NAMEF", max_length=1000)
    c_inn = models.CharField(db_column="C_INN", max_length=15)
    c_kpp = models.CharField(db_column="C_KPP", max_length=15)
    c_okved = models.CharField(db_column="C_OKVED", max_length=50)
    c_okogu = models.CharField(db_column="C_OKOGU", max_length=10)
    fam_gv = models.CharField(db_column="FAM_GV", max_length=40)
    im_gv = models.CharField(db_column="IM_GV", max_length=40)
    ot_gv = models.CharField(db_column="OT_GV", max_length=40)
    fam_bux = models.CharField(db_column="FAM_BUX", max_length=40)
    im_bux = models.CharField(db_column="IM_BUX", max_length=40)
    ot_bux = models.CharField(db_column="OT_BUX", max_length=40)
    tel = models.CharField(db_column="TEL", max_length=40)
    fax = models.CharField(db_column="FAX", max_length=40)
    e_mail = models.CharField(db_column="E_MAIL", max_length=50)
    date_b = models.DateTimeField(db_column="DATE_B")
    date_e = models.DateTimeField(db_column="DATE_E")
    c_n_fil = models.SmallIntegerField(db_column="C_N_FIL")
    address = models.CharField(db_column="ADRES", max_length=200)
    mcod = models.CharField(db_column="MCOD", unique=True, max_length=10)
    klpu = models.CharField(db_column="KLPU", max_length=1)
    post_idp = models.DecimalField(db_column="POST_IDP", max_digits=6, decimal_places=0)
    okpo = models.CharField(db_column="OKPO", max_length=8)
    organisation = models.ForeignKey("OmsOrganisation", models.DO_NOTHING, db_column="rf_OrganisationID")
    # tariff_type = models.ForeignKey('OmsKlTariffType', models.DO_NOTHING, db_column='rf_kl_TariffTypeID')
    # category = models.ForeignKey('OmsKlCategory', models.DO_NOTHING, db_column='rf_kl_CategoryID')
    ndog = models.CharField(db_column="NDOG", max_length=50)
    ddogfss = models.DateTimeField(db_column="DDOGFSS")
    lic = models.CharField(db_column="Lic", max_length=50)
    code_mo = models.IntegerField(db_column="Code_MO")
    fcod = models.CharField(db_column="FCOD", max_length=6)
    # type_lpu = models.ForeignKey('OmsKlTypeLpu', models.DO_NOTHING, db_column='rf_kl_Type_LPUID')
    main_lpu = models.ForeignKey("self", models.DO_NOTHING, db_column="rf_MainLPUID")
    stlpu = models.CharField(db_column="StLPU", max_length=1)
    # agegroup = models.ForeignKey('OmsKlAgegroup', models.DO_NOTHING, db_column='rf_kl_AgeGroupID')
    # tariff_target = models.ForeignKey('OmsTariffTarget', models.DO_NOTHING, db_column='rf_TariffTargetID')
    in_demand = models.BooleanField(db_column="InDemand")
    date_n_beg = models.DateTimeField(db_column="DateN_Beg")
    date_n_end = models.DateTimeField(db_column="DateN_End")
    code_kladr = models.CharField(db_column="CodeKladr", max_length=10)
    code_ruk = models.CharField(db_column="CodeRuk", max_length=10)
    dop_fk = models.CharField(db_column="DopFK", max_length=10)
    host = models.IntegerField(db_column="HostID")
    kfsr = models.CharField(db_column="KFSR", max_length=10)
    kosgu = models.CharField(db_column="KOSGU", max_length=10)
    kvr = models.CharField(db_column="KVR", max_length=10)
    kvsr = models.CharField(db_column="KVSR", max_length=10)
    kla_address = models.ForeignKey("KlaAddress", models.DO_NOTHING, db_column="rf_AddressID")
    prvd = models.ForeignKey("OmsPrvd", models.DO_NOTHING, db_column="rf_PRVDID")
    mdlpc_ode = models.CharField(db_column="MdlpCode", max_length=150)
    code_egisz = models.CharField(db_column="CodeEgisz", max_length=150)
    # med_care_type = models.ForeignKey('OmsKlMedCareType', models.DO_NOTHING, db_column='rf_kl_MedCareTypeID')

    flags = models.IntegerField(db_column="FLAGS")

    class Meta:
        managed = False
        db_table = "oms_LPU"
