from .base_model import *


class HltTap(BaseModel):
    """
    Талон амбулаторного пациента
    """

    id = models.AutoField(db_column="TAPID", primary_key=True)
    uuid = models.CharField(db_column="UGUID", max_length=36, unique=True, default=uuid.uuid4)
    mkab = models.ForeignKey("HltMkab", models.DO_NOTHING, db_column="rf_MKABID", related_name="taps")
    katl = models.IntegerField(db_column="rf_KATLID", blank=True)
    mkb = models.ForeignKey("OmsMkb", db_column="rf_MKBID", **FK_DEFAULT)
    mkb2 = models.ForeignKey("OmsMkb", db_column="rf_MKB2ID", **FK_DEFAULT)
    reason_care = models.ForeignKey("HltReasonCare", db_column="rf_ReasonCareID", **FK_DEFAULT)
    care_person_sex = models.BooleanField(db_column="CarePersonSex", blank=True)
    care_person_age = models.IntegerField(db_column="CarePersonAge", blank=True)
    date_tap = models.DateTimeField(db_column="DateTAP", blank=True)
    inv = models.IntegerField(db_column="rf_INVID", blank=True)
    not_work_doc_status = models.IntegerField(db_column="rf_NotWorkDocStatusID", blank=True)
    date_close = models.DateTimeField(db_column="DateClose", blank=True)
    lpu_doctor = models.ForeignKey("HltLpuDoctor", db_column="rf_LPUDoctorID", **FK_DEFAULT)
    lpu_doctor_s = models.ForeignKey("HltLpuDoctor", db_column="rf_LPUDoctor_SID", **FK_DEFAULT)
    smo = models.ForeignKey("OmsSmo", db_column="rf_SMOID", **FK_DEFAULT)
    other_smo = models.ForeignKey("OmsSmo", db_column="rf_OtherSMOID", **FK_DEFAULT)
    s_pol = models.CharField(db_column="S_POL", max_length=50, blank=True)
    n_pol = models.CharField(db_column="N_POL", max_length=50, blank=True)
    is_closed = models.BooleanField(db_column="IsClosed", blank=True)
    is_worker = models.BooleanField(db_column="isWorker", blank=True)
    spec_event_cert_id = models.IntegerField(db_column="rf_SpecEventCertID", blank=True)
    care_begin = models.DateTimeField(db_column="CareBegin", blank=True)
    care_end = models.DateTimeField(db_column="CareEnd", blank=True)
    family = models.CharField(db_column="FAMILY", max_length=40, blank=True)
    mkab_sheet_final_ds = models.IntegerField(db_column="rf_MKABSheetFinalDSID", blank=True)
    direction_id = models.IntegerField(db_column="rf_DirectionID", blank=True)
    outcome_visit_id = models.IntegerField(db_column="rf_OutcomeVisitID", blank=True)
    description = models.CharField(db_column="Description", max_length=1000, blank=True)
    profit_type = models.ForeignKey("OmsKlProfitType", db_column="rf_kl_ProfitTypeID", **FK_DEFAULT)
    disp_reg_state_id = models.IntegerField(db_column="rf_kl_DispRegStateID", blank=True)
    disp_reg_state2_id = models.IntegerField(db_column="rf_kl_DispRegState2ID", blank=True)
    disease_type = models.ForeignKey("OmsKlDiseaseType", db_column="rf_kl_DiseaseTypeID", **FK_DEFAULT)
    disease_type2 = models.ForeignKey("OmsKlDiseaseType", db_column="rf_kl_DiseaseType2ID", **FK_DEFAULT)
    trauma_type_id = models.IntegerField(db_column="rf_kl_TraumaTypeID", blank=True)
    sick_list_reason = models.IntegerField(db_column="rf_kl_SickListReasonID", blank=True)
    visit_result = models.ForeignKey("OmsKlVisitResult", db_column="rf_kl_VisitResultID", **FK_DEFAULT)
    registration_end_reason_id = models.IntegerField(db_column="rf_kl_RegistrationEndReasonID", blank=True)
    registration_end_reason2_id = models.IntegerField(db_column="rf_kl_RegistrationEndReason2ID", blank=True)
    health_group = models.ForeignKey("OmsKlHealthGroup", db_column="rf_kl_HealthGroupID", **FK_DEFAULT)
    visit_place = models.ForeignKey("OmsKlVisitPlace", db_column="rf_kl_VisitPlaceID", **FK_DEFAULT)
    reason_type = models.ForeignKey("OmsKlReasonType", db_column="rf_kl_ReasonTypeID", **FK_DEFAULT)
    department = models.ForeignKey("OmsDepartment", db_column="rf_DepartmentID", **FK_DEFAULT)
    soc_status = models.ForeignKey("OmsKlSocStatus", db_column="rf_kl_SocStatusID", **FK_DEFAULT)
    create_username = models.CharField(db_column="CreateUserName", max_length=255, blank=True)
    edit_username = models.CharField(db_column="EditUserName", max_length=255, blank=True)
    flag_bill = models.BooleanField(db_column="FlagBill", blank=True)
    flag_statist = models.BooleanField(db_column="FlagStatist", blank=True)
    create_user = models.ForeignKey("XUser", db_column="rf_CreateUserID", **FK_DEFAULT)
    edit_user = models.ForeignKey("XUser", db_column="rf_EditUserID", **FK_DEFAULT)
    stat_cure_result = models.ForeignKey("OmsKlStatCureResult", db_column="rf_kl_StatCureResultID", **FK_DEFAULT)
    polis_mkab_id = models.IntegerField(db_column="rf_PolisMKABID", blank=True)
    type_tap_id = models.IntegerField(db_column="rf_TypeTAPID", blank=True)
    registr_patient_id = models.IntegerField(db_column="rf_RegistrPatientID", blank=True)
    doc_prvd = models.ForeignKey("HltDocPrvd", db_column="rf_DocPRVDID", **FK_DEFAULT)
    mkp_card = models.UUIDField(db_column="rf_mkp_CardGUID", blank=True)
    date_create_tap = models.DateTimeField(db_column="DateCreateTAP", blank=True)
    num_in_other_system = models.CharField(db_column="NumInOtherSystem", max_length=50, blank=True)
    is_dvn_closed = models.BooleanField(db_column="isDVNClosed", blank=True)
    med_care_type = models.ForeignKey("OmsKlMedCareType", db_column="rf_kl_MedCareTypeID", **FK_DEFAULT)
    disability_status = models.IntegerField(db_column="DisabilityStatus", blank=True)
    reason_inv_id = models.IntegerField(db_column="rf_kl_ReasonInvID", blank=True)
    mkb_external = models.ForeignKey("OmsMkb", db_column="rf_MKBExternalID", **FK_DEFAULT)
    sanitation_id = models.IntegerField(db_column="rf_kl_SanitationID", blank=True)
    patient_status_id = models.IntegerField(db_column="rf_kl_PatientStatusID", blank=True)
    onco_sign_id = models.IntegerField(db_column="rf_onco_SignID", blank=True)
    dd_service = models.ForeignKey("OmsKlDDService", db_column="rf_kl_DDServiceID", **FK_DEFAULT)
    tip_oms = models.ForeignKey("OmsKlTipOms", db_column="rf_kl_TipOMSID", **FK_DEFAULT)
    num = models.IntegerField(db_column="Num", blank=True)

    flags = models.IntegerField(db_column="Flags")

    class Meta:
        managed = False
        db_table = "hlt_TAP"
