# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nibiru', 'nibiru.msg', 'nibiru.query_clients']

package_data = \
{'': ['*']}

install_requires = \
['aiocron>=1.8,<2.0',
 'aiohttp>=3.8.1,<4.0.0',
 'asyncio>=3.4.3,<4.0.0',
 'bech32>=1.2.0,<2.0.0',
 'bip32>=3.1,<4.0',
 'coincurve>=17.0.0,<18.0.0',
 'ecdsa>=0.18.0,<0.19.0',
 'eip712-structs>=1.1.0,<2.0.0',
 'grpcio>=1.47.0,<2.0.0',
 'hdwallets>=0.1.2,<0.2.0',
 'mnemonic>=0.20,<0.21',
 'nibiru-proto>=0.14.1,<0.15.0',
 'pre-commit>=2.20.0,<3.0.0',
 'protobuf==3.20.1',
 'pytest>=7.1.2,<8.0.0',
 'python-dotenv>=0.20.0,<0.21.0',
 'requests>=2.28.1,<3.0.0',
 'shutup>=0.2.0,<0.3.0',
 'websocket-client>=1.4.0,<2.0.0']

setup_kwargs = {
    'name': 'nibiru',
    'version': '0.4.5',
    'description': 'Python SDK for interacting with Nibiru.',
    'long_description': '# Nibiru Python SDK - `nibiru`                           <!-- omit in toc -->\n\n> Python-based client for interacting with the Nibiru blockchain.\n\n<!-- Badges -->\n\n[![Nibiru Test workflow][tests-badge]][tests-workflow]\n[![PyPI Version][pypi-image]][pypi-url]\n[![][documentation-image]][documentation-url]\n[![][discord-badge]][discord-url]\n[![][stars-image]][stars-url]\n[![MIT license][license-badge]][license-link]\n\n<!-- Badges links -->\n\n<!-- pypi -->\n[pypi-image]: https://img.shields.io/pypi/v/nibiru\n[pypi-url]: https://pypi.org/project/nibiru/\n[stars-image]: https://img.shields.io/github/stars/NibiruChain?style=social\n[stars-url]: https://github.com/NibiruChain\n[documentation-image]: https://readthedocs.org/projects/nibiru-py/badge/?version=latest\n[documentation-url]: https://nibiru-py.readthedocs.io/en/latest/?badge=latest\n[discord-badge]: https://img.shields.io/badge/Nibiru%20Chain-%237289DA.svg?style=&logo=discord&logoColor=white\n[discord-url]: https://discord.gg/sgPw8ZYfpQ\n[license-badge]: https://img.shields.io/badge/License-MIT-blue.svg\n[license-link]: https://github.com/NibiruChain/py-sdk/blob/master/LICENSE\n[tests-badge]: https://github.com/NibiruChain/py-sdk/actions/workflows/pytests.yml/badge.svg\n[tests-workflow]: https://github.com/NibiruChain/py-sdk/actions/workflows/pytests.yml\n\nThe `nibiru` package allows you to index, query, and send transactions on the Nibiru Blockchain using Python. It provides access to market data for analysis, visualization, indicator development, algorithmic trading, strategy backtesting, bot programming, and related software engineering.\n\nThe package is intended to be used by coders, developers, technically-skilled traders and  data-scientists for building trading algorithms.\n\n#### README Contents\n\n- [User Guidelines](#user-guidelines)\n  - [Documentation Website](#documentation-website)\n  - [Installation from `PyPI`](#installation-from-pypi)\n- [Development Guidelines](#development-guidelines)\n  - [Setting up a professional dev environment with `pyenv` and `poetry`](#setting-up-a-professional-dev-environment-with-pyenv-and-poetry)\n    - [Pyenv for managing multiple Python interpreters](#pyenv-for-managing-multiple-python-interpreters)\n  - [Installing `poetry` for dependency resolution and publishing packages](#installing-poetry-for-dependency-resolution-and-publishing-packages)\n  - [Installing external dependencies](#installing-external-dependencies)\n  - [Running tests](#running-tests)\n      - [Setting environment variables](#setting-environment-variables)\n      - [Running the tests with `poetry` + `pytest`](#running-the-tests-with-poetry--pytest)\n      - [(option B). Install the `nibiru` package with `pip`](#option-b-install-the-nibiru-package-with-pip)\n  - [Makefile and Protocol Buffers](#makefile-and-protocol-buffers)\n    - [Other dependencies](#other-dependencies)\n    - [Generating types wth protobuf](#generating-types-wth-protobuf)\n  - [Linting](#linting)\n  - [Gotchas](#gotchas)\n\n# User Guidelines\n\n## Documentation Website\n\nDocumentation can be found here: [Nibiru-py documentation](https://nibiru-py.readthedocs.io/en/latest/index.html)\n\n- Learn more about opening and managing your spot and perp positions [here](https://nibiru-py.readthedocs.io/en/latest/nibiru.sdks.tx.html#nibiru-sdks-tx-package)\n- Learn about querying the chain using the Sdk [here](https://nibiru-py.readthedocs.io/en/latest/nibiru.clients.html#nibiru-clients-package)\n\n## Installation from `PyPI`\n\n```sh\npip install nibiru  # requires Python 3.9\n```\n\nYou may need to update `pip` to get this to run:\n\n```sh\npython -m pip install --upgrade pip\n```\n\n<!-- NOTE --------- Deperecating this section as the examples don\'t work.\n\n## Usage Instructions\n\nThe [examples directory](https://github.com/NibiruChain/py-sdk/tree/master/examples) contains runnable examples that showcase how to use the package.\n- Requires Python 3.9+\n- Requires a running instance of the Nibiru blockchain\n\n```bash\n$ pipenv shell\n$ pipenv install\n```\n\n```sh\n# connecting to Nibiru Exchange API and create a new pool\n$ python examples/chain_client/dex/create_pool.py\n\n# sending a msg with bank transfer signs and posts a transaction to the Nibiru Chain\n$ python examples/chain_client/msg_send.py\n```\n\nUpgrade `pip` to the latest version, if you see these warnings:\n  ```\n  WARNING: Value for scheme.platlib does not match. Please report this to <https://github.com/pypa/pip/issues/10151>\n  WARNING: Additional context:   user = True   home = None   root = None   prefix = None\n  ```\n-->\n\n---\n\n# Development Guidelines\n\nOur recommended setup is `pyenv` in combination with `poetry`.\n\n- `pyenv` is a tool for installing and managing Python interpreters. This will let you seamlessly switch between Python versions.\n- `poetry` is used for managing virtual environments, dependency resolution, package installations, package building, and package publishing.\n- We assume you\'re on a Unix machine such as WSL2 Ubuntu, MacOS, or a common Linux distro.\n\nCurrently, `nibiru` is created with Python 3.9.13. It may be compatible with higher versions, but we only run end-to-end tests in 3.9.13.\n\n## Setting up a professional dev environment with `pyenv` and `poetry`\n\n### Pyenv for managing multiple Python interpreters\n\nIf you\'re on MacOS or a common Linux distro, you can install `pyenv` with brew.\n\n```sh\nbrew install pyenv\n```\n\nYou\'ll then need to add the following snippet to your shell config, e.g. your `.bash_profile`, `.bashrc`, or `.zshrc`.\n\n```sh\nexport PYENV_ROOT="$HOME/.pyenv"\nexport PATH="$PYENV_ROOT/bin:$PATH"\neval "$(pyenv init -)"\neval "$(pyenv init --path)"\n```\n\nAfter using `source` on your config or restarting the shell, you should have the `pyenv` root command.\n\nThe command use to install any version of python is `pyenv install`. Display additional info for this command with `pyenv install --help`.\n\n```sh\npyenv install 3.9.13 # example for nibiru\n```\n\nOnce you have a version installed, you can print out the versions on your machine with:\n\n```sh\npyenv versions\n```\n\n```\n# example output\n  system\n* 3.9.13 (set by /home/realu/.python-version)\n  3.10.4\n```\n\nIn this example, I have 2 different interpreters installed on my machine. The one with the `*` is currently set as my **global interpreter**. This is set manually using the `pyenv global` command.\n\n```sh\npyenv global 3.10.4   # switches the global interpreter to 3.10.4\n```\n\nYou can verify this works as expected using `python --version`. You may be familiar with using `python3` as the command instead of `python`. With `pyenv`, this is not necessary.\n\nAdditional usage and installation instructions can be found in the [pyenv repo](https://github.com/pyenv/pyenv).\n\n## Installing `poetry` for dependency resolution and publishing packages\n\nReference: [Poetry docs](https://python-poetry.org/docs/)\n\nPoetry can be installed with both `curl` and `pip`. We recommended using `curl` so that it will be global to your machine.\n\nNOTE We highly, highly, highly recommend that you DO NOT use `brew` to install `poetry`.\nIf you use `brew`, it\'s going to install directly to your system, which prevents you from being able to leverage `pyenv` to seamlessly switch between Python interpreters.\n\n```sh\n# installation with pip: recommended option in tandem with pyenv\npip install poetry\n```\n\n```sh\n# For UNIX systems - installation with curl\ncurl -sSL https://install.python-poetry.org/ | python -\n```\n\nAfter this installation command, add the `poetry` binary to the path in your shell config (if it\'s not done automatically).\n\n```sh\nexport PATH=$PATH:$HOME/.poetry/bin\n```\n\n## Installing external dependencies\n\nThe `nibiru` project is defined by its `pyproject.toml`. At the root of the repo, simply call:\n\n```sh\npoetry install\n```\n\nThis will resolve dependencies between each of the project\'s packages and install them into a virtual environment.\n\n## Running tests\n\n#### Setting environment variables\n\nThere\'s currently a "devnet" running in GCP that the CI workflows use. You can find these secrets at [this notion page](https://www.notion.so/nibiru/Resources-and-Repo-Configs-b31aa8074a2b419d80b0c946ed5efab0) if you have access to it or contact one of the `CODEOWNERS` (@Unique-Divine, @matthiasmatt, @nibiruheisenberg).\nThis is useful so that you can run every part of the package code without needing to visit other repositories.\n\nSet up a `.env` file to set environment variables for the tests.\nThe variables used in the CI build can be found in the `env` section of the [`pytests.yml` workflow](.github/workflows/pytests.yml):\n\n```yaml\njobs:\n  tests:\n    env:\n      # https://www.notion.so/nibiru/Resources-and-Repo-Configs-b31aa8074a2b419d80b0c946ed5efab0\n      CHAIN_ID: ${{ secrets.CHAIN_ID }}\n      HOST: ${{ secrets.HOST }}\n      VALIDATOR_MNEMONIC: ${{ secrets.VALIDATOR_MNEMONIC }}\n      GRPC_PORT: ${{ secrets.GRPC_PORT }}\n      LCD_PORT: ${{ secrets.LCD_PORT }}\n```\n\nYou\'ll need an `.env` configuration like this.\n\n```sh\n# Example configuration for the Nibiry Python SDK\nHOST="..."\nVALIDATOR_MNEMONIC="..."\nORACLE_MNEMONIC="..."\nGRPC_PORT="..."\nLCD_PORT="..."\nCHAIN_ID="..."\nNETWORK_INSECURE=true\n```\n\n#### Running the tests with `poetry` + `pytest`\n\nAfter following the instructions for setting up `poetry`, you can run the tests with `poetry run pytest`:\n\n```sh\npoetry run pytest -p no:warnings # silences warnings\n```\n\n#### (option B). Install the `nibiru` package with `pip`\n\n  ```sh\n  # from local\n  # build and install\n  pip install .\n\n  # from local build\n  pip uninstall nibiru\n  pip install nibiru --no-index --find-links /path/to/nibiru/py-sdk/dist\n\n  # from pypi\n  pip uninstall nibiru\n  pip install nibiru\n  ```\n\n## Makefile and Protocol Buffers\n\n### Other dependencies\n\nTo run shell scripts and commands in the `Makefile`, you\'ll need to install the following tools depending on your operating system.\n\n- **Ubuntu**\n\n  ```bash\n  sudo apt install python3.X-dev autoconf automake build-essential libffi-dev libtool pkg-config\n  ```\n\n- **macOS**\n\n  ```bash\n  brew install autoconf automake libtool\n  ```\n\n- **Fedora**\n\n  ```bash\n  sudo dnf install python3-devel autoconf automake gcc gcc-c++ libffi-devel libtool make pkgconfig\n  ```\n\n### Generating types wth protobuf\n\nThe objective is to run `make proto-gen`, which simply executes `scripts/protocgen.sh`.\n\nIn order to do this, you\'ll need to install a few packages on your system.\n\n```sh\npython -m pip install --user grpcio-tools\npip install mypy-protobuf\n```\n\nIf you get a permissions error such as\n\n```\nrm: cannot remove \'proto/proto/epochs/query.proto\': Permission denied\n```\n\ncall `sudo chown -R [USER-NAME] proto` using the name of user directory.\nYou can find the value for `[USER-NAME]` quickly by running `whoami`. In other words, this should work:\n\n```sh\nsudo chown -R $(whoami) proto\n```\n\nYou\'re done generating types once you\'ve successfully called\n\n```sh\nmake proto-gen\npoetry build # equivalently, you can run `python -m build`\n```\n\n## Linting\n\nEnable git hook which will perform linting before each commit:\n\n```shell\npoetry run pre-commit install\n```\n\nThis will keep your code clean.\n\n## Gotchas\n\nThe `protobuf` package must be version 3.20.x or lower. Otherwise, the following error appears at runtime.\n\n```\nnibiru/clients/__init__.py:1: in <module>\n    from nibiru.clients.dex import Dex  # noqa\nnibiru/clients/dex.py:8: in <module>\n    from nibiru.proto.dex.v1 import query_pb2 as dex_type\nnibiru/proto/dex/v1/query_pb2.py:16: in <module>\n    from google.api import annotations_pb2 as google_dot_api_dot_annotations__pb2\n../../../anaconda3/envs/divine/lib/python3.9/site-packages/google/api/annotations_pb2.py:30: in <module>\n    from google.api import http_pb2 as google_dot_api_dot_http__pb2\n../../../anaconda3/envs/divine/lib/python3.9/site-packages/google/api/http_pb2.py:48: in <module>\n    _descriptor.FieldDescriptor(\n../../../anaconda3/envs/divine/lib/python3.9/site-packages/google/protobuf/descriptor.py:560: in __new__\n    _message.Message._CheckCalledFromGeneratedFile()\nE   TypeError: Descriptors cannot not be created directly.\nE   If this call came from a _pb2.py file, your generated code is out of date and must be regenerated with protoc >= 3.19.0.\nE   If you cannot immediately regenerate your protos, some other possible workarounds are:\nE    1. Downgrade the protobuf package to 3.20.x or lower.\nE    2. Set PROTOCOL_BUFFERS_PYTHON_IMPLEMENTATION=python (but this will use pure-Python parsing and will be much slower).\nE\nE   More information: https://developers.google.com/protocol-buffers/docs/news/2022-05-06#python-updates\n```\n\n## Usage instructions for publishing.\n\nYou specify updates to publish using the commit (or PR) title with `bump-[version-keyword]`.\nFor the `poetry version` command, ysing any bump rule with a valid semver string will change the version inside `pyproject.toml`. For example,\n\n```\npoetry version patch # moves from x.y.14 to x.y.15\npoetry version minor # moves from x.5.z to x.6.0\npoetry version major # moves from 3.y.z to 4.0.0\n```\nThe list of bump rules includes:\npatch, minor, major, prepatch, preminor, premajor, prerelease.\n\nSo the list of available keywords you an put in a PR includes\n- `bump-patch`:\n- `bump-patch`: 0.0.0 → 0.0.1\n- `bump-minor`: 0.0.* → 0.1.0\n- `bump-major`: 0.*.* → 1.0.0\n- `bump-prepatch`: 0.0.0 → 0.0.1-alpha0\n- `bump-prerelease`: equivalent to `bump-prepatch`\n- `bump-preminor`: 0.0.* → 0.1.0-alpha0\n- `bump-premajor`: 0.*.* → 1.0.0-alpha0\n\nThese guidelines are in the release.yml for future reference.\n',
    'author': 'Nibiru Chain',
    'author_email': 'dev@nibiru.fi',
    'maintainer': 'NibiruHeisenberg',
    'maintainer_email': 'dev@nibiru.fi',
    'url': 'https://github.com/NibiruChain/sdk-py',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
