# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev1
    Generated by: https://openapi-generator.tech
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from synctera_client import schemas  # noqa: F401


class OutgoingAch(
    schemas.DictSchema
):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Represents a sent ACH transaction.
    """


    class MetaOapg:
        required = {
            "source_account_no",
            "amount",
            "partner_id",
            "bank_id",
            "effective_date",
            "is_same_day",
            "memo",
            "external_id",
            "id",
            "trace_no",
            "account_no",
            "status",
        }
        
        class properties:
            account_no = schemas.StrSchema
            amount = schemas.IntSchema
            bank_id = schemas.IntSchema
            effective_date = schemas.DateSchema
            external_id = schemas.UUIDSchema
            id = schemas.UUIDSchema
            is_same_day = schemas.BoolSchema
            memo = schemas.StrSchema
            partner_id = schemas.IntSchema
            source_account_no = schemas.StrSchema
            
            
            class status(
                schemas.EnumBase,
                schemas.StrSchema
            ):
                
                @schemas.classproperty
                def INIT(cls):
                    return cls("INIT")
                
                @schemas.classproperty
                def PENDING(cls):
                    return cls("PENDING")
                
                @schemas.classproperty
                def CANCELED(cls):
                    return cls("CANCELED")
                
                @schemas.classproperty
                def COMPLETE(cls):
                    return cls("COMPLETE")
                
                @schemas.classproperty
                def DECLINED(cls):
                    return cls("DECLINED")
            trace_no = schemas.StrSchema
            account_name = schemas.StrSchema
        
            @staticmethod
            def hold() -> typing.Type['HoldData']:
                return HoldData
            reference_info = schemas.StrSchema
            source_account_name = schemas.StrSchema
            __annotations__ = {
                "account_no": account_no,
                "amount": amount,
                "bank_id": bank_id,
                "effective_date": effective_date,
                "external_id": external_id,
                "id": id,
                "is_same_day": is_same_day,
                "memo": memo,
                "partner_id": partner_id,
                "source_account_no": source_account_no,
                "status": status,
                "trace_no": trace_no,
                "account_name": account_name,
                "hold": hold,
                "reference_info": reference_info,
                "source_account_name": source_account_name,
            }
    
    source_account_no: MetaOapg.properties.source_account_no
    amount: MetaOapg.properties.amount
    partner_id: MetaOapg.properties.partner_id
    bank_id: MetaOapg.properties.bank_id
    effective_date: MetaOapg.properties.effective_date
    is_same_day: MetaOapg.properties.is_same_day
    memo: MetaOapg.properties.memo
    external_id: MetaOapg.properties.external_id
    id: MetaOapg.properties.id
    trace_no: MetaOapg.properties.trace_no
    account_no: MetaOapg.properties.account_no
    status: MetaOapg.properties.status
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["account_no"]) -> MetaOapg.properties.account_no: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["bank_id"]) -> MetaOapg.properties.bank_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["effective_date"]) -> MetaOapg.properties.effective_date: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["external_id"]) -> MetaOapg.properties.external_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["is_same_day"]) -> MetaOapg.properties.is_same_day: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["memo"]) -> MetaOapg.properties.memo: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["partner_id"]) -> MetaOapg.properties.partner_id: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["source_account_no"]) -> MetaOapg.properties.source_account_no: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["trace_no"]) -> MetaOapg.properties.trace_no: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["account_name"]) -> MetaOapg.properties.account_name: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["hold"]) -> 'HoldData': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["reference_info"]) -> MetaOapg.properties.reference_info: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["source_account_name"]) -> MetaOapg.properties.source_account_name: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> schemas.UnsetAnyTypeSchema: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["account_no", "amount", "bank_id", "effective_date", "external_id", "id", "is_same_day", "memo", "partner_id", "source_account_no", "status", "trace_no", "account_name", "hold", "reference_info", "source_account_name", ], str]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["account_no"]) -> MetaOapg.properties.account_no: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["amount"]) -> MetaOapg.properties.amount: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["bank_id"]) -> MetaOapg.properties.bank_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["effective_date"]) -> MetaOapg.properties.effective_date: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["external_id"]) -> MetaOapg.properties.external_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["id"]) -> MetaOapg.properties.id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["is_same_day"]) -> MetaOapg.properties.is_same_day: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["memo"]) -> MetaOapg.properties.memo: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["partner_id"]) -> MetaOapg.properties.partner_id: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["source_account_no"]) -> MetaOapg.properties.source_account_no: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["status"]) -> MetaOapg.properties.status: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["trace_no"]) -> MetaOapg.properties.trace_no: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["account_name"]) -> typing.Union[MetaOapg.properties.account_name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["hold"]) -> typing.Union['HoldData', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["reference_info"]) -> typing.Union[MetaOapg.properties.reference_info, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["source_account_name"]) -> typing.Union[MetaOapg.properties.source_account_name, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[schemas.UnsetAnyTypeSchema, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["account_no", "amount", "bank_id", "effective_date", "external_id", "id", "is_same_day", "memo", "partner_id", "source_account_no", "status", "trace_no", "account_name", "hold", "reference_info", "source_account_name", ], str]):
        return super().get_item_oapg(name)
    

    def __new__(
        cls,
        *_args: typing.Union[dict, frozendict.frozendict, ],
        source_account_no: typing.Union[MetaOapg.properties.source_account_no, str, ],
        amount: typing.Union[MetaOapg.properties.amount, decimal.Decimal, int, ],
        partner_id: typing.Union[MetaOapg.properties.partner_id, decimal.Decimal, int, ],
        bank_id: typing.Union[MetaOapg.properties.bank_id, decimal.Decimal, int, ],
        effective_date: typing.Union[MetaOapg.properties.effective_date, str, date, ],
        is_same_day: typing.Union[MetaOapg.properties.is_same_day, bool, ],
        memo: typing.Union[MetaOapg.properties.memo, str, ],
        external_id: typing.Union[MetaOapg.properties.external_id, str, uuid.UUID, ],
        id: typing.Union[MetaOapg.properties.id, str, uuid.UUID, ],
        trace_no: typing.Union[MetaOapg.properties.trace_no, str, ],
        account_no: typing.Union[MetaOapg.properties.account_no, str, ],
        status: typing.Union[MetaOapg.properties.status, str, ],
        account_name: typing.Union[MetaOapg.properties.account_name, str, schemas.Unset] = schemas.unset,
        hold: typing.Union['HoldData', schemas.Unset] = schemas.unset,
        reference_info: typing.Union[MetaOapg.properties.reference_info, str, schemas.Unset] = schemas.unset,
        source_account_name: typing.Union[MetaOapg.properties.source_account_name, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[schemas.AnyTypeSchema, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, None, list, tuple, bytes],
    ) -> 'OutgoingAch':
        return super().__new__(
            cls,
            *_args,
            source_account_no=source_account_no,
            amount=amount,
            partner_id=partner_id,
            bank_id=bank_id,
            effective_date=effective_date,
            is_same_day=is_same_day,
            memo=memo,
            external_id=external_id,
            id=id,
            trace_no=trace_no,
            account_no=account_no,
            status=status,
            account_name=account_name,
            hold=hold,
            reference_info=reference_info,
            source_account_name=source_account_name,
            _configuration=_configuration,
            **kwargs,
        )

from synctera_client.model.hold_data import HoldData
