"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.api_client import ApiClient, Endpoint as _Endpoint
from synctera_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from synctera_client.model.error import Error
from synctera_client.model.pending_transaction import PendingTransaction
from synctera_client.model.pending_transactions import PendingTransactions
from synctera_client.model.posted_transaction import PostedTransaction
from synctera_client.model.posted_transactions import PostedTransactions


class TransactionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.get_pending_transaction_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (PendingTransaction,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/transactions/pending/{id}',
                'operation_id': 'get_pending_transaction_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.get_posted_transaction_by_id_endpoint = _Endpoint(
            settings={
                'response_type': (PostedTransaction,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/transactions/posted/{id}',
                'operation_id': 'get_posted_transaction_by_id',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                },
                'location_map': {
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_pending_transactions_endpoint = _Endpoint(
            settings={
                'response_type': (PendingTransactions,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/transactions/pending',
                'operation_id': 'list_pending_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_no',
                    'account_id',
                    'from_date',
                    'to_date',
                    'status',
                    'transaction_id',
                    'type',
                    'subtype',
                    'limit',
                    'page_token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_no':
                        (str,),
                    'account_id':
                        (str,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                    'status':
                        (str,),
                    'transaction_id':
                        (str,),
                    'type':
                        (str,),
                    'subtype':
                        (str,),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'account_no': 'account_no',
                    'account_id': 'account_id',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                    'status': 'status',
                    'transaction_id': 'transaction_id',
                    'type': 'type',
                    'subtype': 'subtype',
                    'limit': 'limit',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'account_no': 'query',
                    'account_id': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                    'status': 'query',
                    'transaction_id': 'query',
                    'type': 'query',
                    'subtype': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_posted_transactions_endpoint = _Endpoint(
            settings={
                'response_type': (PostedTransactions,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/transactions/posted',
                'operation_id': 'list_posted_transactions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'account_no',
                    'account_id',
                    'from_date',
                    'to_date',
                    'type',
                    'subtype',
                    'limit',
                    'page_token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'account_no':
                        (str,),
                    'account_id':
                        (str,),
                    'from_date':
                        (date,),
                    'to_date':
                        (date,),
                    'type':
                        (str,),
                    'subtype':
                        (str,),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'account_no': 'account_no',
                    'account_id': 'account_id',
                    'from_date': 'from_date',
                    'to_date': 'to_date',
                    'type': 'type',
                    'subtype': 'subtype',
                    'limit': 'limit',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'account_no': 'query',
                    'account_id': 'query',
                    'from_date': 'query',
                    'to_date': 'query',
                    'type': 'query',
                    'subtype': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def get_pending_transaction_by_id(
        self,
        id,
        **kwargs
    ):
        """Get a pending transaction  # noqa: E501

        Get a pending transaction by its uuid   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_pending_transaction_by_id(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): Transaction ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PendingTransaction
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_pending_transaction_by_id_endpoint.call_with_http_info(**kwargs)

    def get_posted_transaction_by_id(
        self,
        id,
        **kwargs
    ):
        """Get a posted transaction  # noqa: E501

        Get a posted transaction by its uuid   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_posted_transaction_by_id(id, async_req=True)
        >>> result = thread.get()

        Args:
            id (str): Transaction ID

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PostedTransaction
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['id'] = \
            id
        return self.get_posted_transaction_by_id_endpoint.call_with_http_info(**kwargs)

    def list_pending_transactions(
        self,
        **kwargs
    ):
        """List pending transactions  # noqa: E501

        Get paginated list of pending transactions matching the provided filters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_pending_transactions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            account_no (str): Account number. [optional]
            account_id (str): Account ID. [optional]
            from_date (date): Only display transactions with a posting date greater than from_date. [optional]
            to_date (date): Only display transactions with a posting date less than or equal to to_date. [optional]
            status (str): The status of the transaction. [optional]
            transaction_id (str): Only display holds linked to the provided transaction id. [optional]
            type (str): Only display transactions matching the given type. [optional]
            subtype (str): Only display transactions matching the given subtype. [optional]
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PendingTransactions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_pending_transactions_endpoint.call_with_http_info(**kwargs)

    def list_posted_transactions(
        self,
        **kwargs
    ):
        """List posted transactions  # noqa: E501

        Get paginated list of posted transactions matching the provided filters   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_posted_transactions(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            account_no (str): Account number. [optional]
            account_id (str): Account ID. [optional]
            from_date (date): Only display transactions with a posting date greater than from_date. [optional]
            to_date (date): Only display transactions with a posting date less than or equal to to_date. [optional]
            type (str): Only display transactions matching the given type. [optional]
            subtype (str): Only display transactions matching the given subtype. [optional]
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PostedTransactions
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_posted_transactions_endpoint.call_with_http_info(**kwargs)

