"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.api_client import ApiClient, Endpoint as _Endpoint
from synctera_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from synctera_client.model.ban_status import BanStatus
from synctera_client.model.error import Error
from synctera_client.model.patch_person import PatchPerson
from synctera_client.model.person import Person
from synctera_client.model.person_list import PersonList
from synctera_client.model.prefill_request import PrefillRequest
from synctera_client.model.status1 import Status1


class PersonsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_person_endpoint = _Endpoint(
            settings={
                'response_type': (Person,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/persons',
                'operation_id': 'create_person',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'person',
                    'idempotency_key',
                ],
                'required': [
                    'person',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'person':
                        (Person,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'person': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_person_endpoint = _Endpoint(
            settings={
                'response_type': (Person,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/persons/{person_id}',
                'operation_id': 'get_person',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'person_id',
                ],
                'required': [
                    'person_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'person_id':
                        (str,),
                },
                'attribute_map': {
                    'person_id': 'person_id',
                },
                'location_map': {
                    'person_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_persons_endpoint = _Endpoint(
            settings={
                'response_type': (PersonList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/persons',
                'operation_id': 'list_persons',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'first_name',
                    'last_name',
                    'phone_number',
                    'email',
                    'ban_status',
                    'status',
                    'is_customer',
                    'limit',
                    'page_token',
                    'sort_by',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'sort_by',
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                    ('sort_by',): {

                        "FIRST_NAME:ASC": "first_name:asc",
                        "FIRST_NAME:DESC": "first_name:desc",
                        "LAST_NAME:ASC": "last_name:asc",
                        "LAST_NAME:DESC": "last_name:desc",
                        "CREATION_TIME:ASC": "creation_time:asc",
                        "CREATION_TIME:DESC": "creation_time:desc",
                        "LAST_UPDATED_TIME:ASC": "last_updated_time:asc",
                        "LAST_UPDATED_TIME:DESC": "last_updated_time:desc"
                    },
                },
                'openapi_types': {
                    'id':
                        ([str],),
                    'first_name':
                        (str,),
                    'last_name':
                        (str,),
                    'phone_number':
                        (str,),
                    'email':
                        (str,),
                    'ban_status':
                        (BanStatus,),
                    'status':
                        (Status1,),
                    'is_customer':
                        (bool,),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                    'sort_by':
                        ([str],),
                },
                'attribute_map': {
                    'id': 'id',
                    'first_name': 'first_name',
                    'last_name': 'last_name',
                    'phone_number': 'phone_number',
                    'email': 'email',
                    'ban_status': 'ban_status',
                    'status': 'status',
                    'is_customer': 'is_customer',
                    'limit': 'limit',
                    'page_token': 'page_token',
                    'sort_by': 'sort_by',
                },
                'location_map': {
                    'id': 'query',
                    'first_name': 'query',
                    'last_name': 'query',
                    'phone_number': 'query',
                    'email': 'query',
                    'ban_status': 'query',
                    'status': 'query',
                    'is_customer': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                    'sort_by': 'query',
                },
                'collection_format_map': {
                    'id': 'csv',
                    'sort_by': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.prefill_person_endpoint = _Endpoint(
            settings={
                'response_type': (PrefillRequest,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/persons/{person_id}/prefill',
                'operation_id': 'prefill_person',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'person_id',
                    'prefill_request',
                    'idempotency_key',
                ],
                'required': [
                    'person_id',
                    'prefill_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'person_id':
                        (str,),
                    'prefill_request':
                        (PrefillRequest,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'person_id': 'person_id',
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'person_id': 'path',
                    'prefill_request': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.update_person_endpoint = _Endpoint(
            settings={
                'response_type': (Person,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/persons/{person_id}',
                'operation_id': 'update_person',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'person_id',
                    'patch_person',
                    'idempotency_key',
                ],
                'required': [
                    'person_id',
                    'patch_person',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'person_id':
                        (str,),
                    'patch_person':
                        (PatchPerson,),
                    'idempotency_key':
                        (str,),
                },
                'attribute_map': {
                    'person_id': 'person_id',
                    'idempotency_key': 'Idempotency-Key',
                },
                'location_map': {
                    'person_id': 'path',
                    'patch_person': 'body',
                    'idempotency_key': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_person(
        self,
        person,
        **kwargs
    ):
        """Create a person  # noqa: E501

        Create a person who may act as a personal customer or a director/officer/owner of a business. You can then verify the identity of this customer and associate them with other people and accounts.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_person(person, async_req=True)
        >>> result = thread.get()

        Args:
            person (Person):

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Person
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['person'] = \
            person
        return self.create_person_endpoint.call_with_http_info(**kwargs)

    def get_person(
        self,
        person_id,
        **kwargs
    ):
        """Get person  # noqa: E501

        Get person by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_person(person_id, async_req=True)
        >>> result = thread.get()

        Args:
            person_id (str): Person's unique identifier.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Person
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['person_id'] = \
            person_id
        return self.get_person_endpoint.call_with_http_info(**kwargs)

    def list_persons(
        self,
        **kwargs
    ):
        """List persons  # noqa: E501

        Retrieves paginated list of persons associated with the authorized requester.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_persons(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            id ([str]): Unique identifier for the resource. Multiple IDs can be provided as a comma-separated list. . [optional]
            first_name (str): [optional]
            last_name (str): [optional]
            phone_number (str): [optional]
            email (str): [optional]
            ban_status (BanStatus): [optional]
            status (Status1): [optional]
            is_customer (bool): If true, show only customers. If false, show non-customer parties.. [optional]
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            sort_by ([str]): Specifies the sort order for the returned persons. . [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PersonList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_persons_endpoint.call_with_http_info(**kwargs)

    def prefill_person(
        self,
        person_id,
        prefill_request,
        **kwargs
    ):
        """Prefill person  # noqa: E501

        Prefill takes a subset of a person's information and automatically fills personally identifiable information (PII) required for know your customer (KYC) verification.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.prefill_person(person_id, prefill_request, async_req=True)
        >>> result = thread.get()

        Args:
            person_id (str): Person's unique identifier.
            prefill_request (PrefillRequest):

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PrefillRequest
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['person_id'] = \
            person_id
        kwargs['prefill_request'] = \
            prefill_request
        return self.prefill_person_endpoint.call_with_http_info(**kwargs)

    def update_person(
        self,
        person_id,
        patch_person,
        **kwargs
    ):
        """Update person  # noqa: E501

        Update person by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_person(person_id, patch_person, async_req=True)
        >>> result = thread.get()

        Args:
            person_id (str): Person's unique identifier.
            patch_person (PatchPerson):

        Keyword Args:
            idempotency_key (str): An idempotency key is an arbitrary unique value generated by client to detect subsequent retries of the same request. It is recommended that a UUID or a similar random identifier be used as an idempotency key. A different key must be used for each request, unless it is a retry.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            Person
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['person_id'] = \
            person_id
        kwargs['patch_person'] = \
            patch_person
        return self.update_person_endpoint.call_with_http_info(**kwargs)

