"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.api_client import ApiClient, Endpoint as _Endpoint
from synctera_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from synctera_client.model.error import Error
from synctera_client.model.patch_payment_schedule import PatchPaymentSchedule
from synctera_client.model.payment_list import PaymentList
from synctera_client.model.payment_schedule import PaymentSchedule
from synctera_client.model.payment_schedule_list import PaymentScheduleList


class PaymentSchedulesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_payment_schedule_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentSchedule,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/payment_schedules',
                'operation_id': 'create_payment_schedule',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_schedule',
                ],
                'required': [
                    'payment_schedule',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_schedule':
                        (PaymentSchedule,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'payment_schedule': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.list_payment_schedules_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentScheduleList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/payment_schedules',
                'operation_id': 'list_payment_schedules',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'page_token',
                    'id',
                    'account_id',
                    'customer_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                    'id':
                        ([str],),
                    'account_id':
                        ([str],),
                    'customer_id':
                        ([str],),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'page_token': 'page_token',
                    'id': 'id',
                    'account_id': 'account_id',
                    'customer_id': 'customer_id',
                },
                'location_map': {
                    'limit': 'query',
                    'page_token': 'query',
                    'id': 'query',
                    'account_id': 'query',
                    'customer_id': 'query',
                },
                'collection_format_map': {
                    'id': 'csv',
                    'account_id': 'csv',
                    'customer_id': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_payments_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentList,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/payment_schedules/payments',
                'operation_id': 'list_payments',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'limit',
                    'page_token',
                    'id',
                    'schedule_id',
                    'account_id',
                    'customer_id',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                    'id':
                        ([str],),
                    'schedule_id':
                        ([str],),
                    'account_id':
                        ([str],),
                    'customer_id':
                        ([str],),
                },
                'attribute_map': {
                    'limit': 'limit',
                    'page_token': 'page_token',
                    'id': 'id',
                    'schedule_id': 'schedule_id',
                    'account_id': 'account_id',
                    'customer_id': 'customer_id',
                },
                'location_map': {
                    'limit': 'query',
                    'page_token': 'query',
                    'id': 'query',
                    'schedule_id': 'query',
                    'account_id': 'query',
                    'customer_id': 'query',
                },
                'collection_format_map': {
                    'id': 'csv',
                    'schedule_id': 'csv',
                    'account_id': 'csv',
                    'customer_id': 'csv',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.patch_payment_schedule_endpoint = _Endpoint(
            settings={
                'response_type': (PaymentSchedule,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/payment_schedules/{payment_schedule_id}',
                'operation_id': 'patch_payment_schedule',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'payment_schedule_id',
                    'patch_payment_schedule',
                ],
                'required': [
                    'payment_schedule_id',
                    'patch_payment_schedule',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'payment_schedule_id':
                        (str,),
                    'patch_payment_schedule':
                        (PatchPaymentSchedule,),
                },
                'attribute_map': {
                    'payment_schedule_id': 'payment_schedule_id',
                },
                'location_map': {
                    'payment_schedule_id': 'path',
                    'patch_payment_schedule': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_payment_schedule(
        self,
        payment_schedule,
        **kwargs
    ):
        """Create a payment schedule  # noqa: E501

        Create a payment schedule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_payment_schedule(payment_schedule, async_req=True)
        >>> result = thread.get()

        Args:
            payment_schedule (PaymentSchedule): payment schedule to create

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentSchedule
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['payment_schedule'] = \
            payment_schedule
        return self.create_payment_schedule_endpoint.call_with_http_info(**kwargs)

    def list_payment_schedules(
        self,
        **kwargs
    ):
        """List payment schedules  # noqa: E501

        Get paginated list of payment schedules  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payment_schedules(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            id ([str]): IDs. Multiple IDs can be provided as a comma-separated list.. [optional]
            account_id ([str]): Originating account IDs. Multiple IDs can be provided as a comma-separated list.. [optional]
            customer_id ([str]): The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentScheduleList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_payment_schedules_endpoint.call_with_http_info(**kwargs)

    def list_payments(
        self,
        **kwargs
    ):
        """List payments  # noqa: E501

        Get paginated list of payments  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_payments(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            id ([str]): IDs. Multiple IDs can be provided as a comma-separated list.. [optional]
            schedule_id ([str]): Payment schedule IDs. Multiple IDs can be provided as a comma-separated list.. [optional]
            account_id ([str]): Originating account IDs. Multiple IDs can be provided as a comma-separated list.. [optional]
            customer_id ([str]): The IDs of customers who created the payment schedules. Multiple IDs can be provided as a comma-separated list.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentList
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_payments_endpoint.call_with_http_info(**kwargs)

    def patch_payment_schedule(
        self,
        payment_schedule_id,
        patch_payment_schedule,
        **kwargs
    ):
        """Update a payment schedule  # noqa: E501

        Update a payment schedule  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.patch_payment_schedule(payment_schedule_id, patch_payment_schedule, async_req=True)
        >>> result = thread.get()

        Args:
            payment_schedule_id (str): Payment schedule ID
            patch_payment_schedule (PatchPaymentSchedule): payment schedule to update

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            PaymentSchedule
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['payment_schedule_id'] = \
            payment_schedule_id
        kwargs['patch_payment_schedule'] = \
            patch_payment_schedule
        return self.patch_payment_schedule_endpoint.call_with_http_info(**kwargs)

