"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from synctera_client.api_client import ApiClient, Endpoint as _Endpoint
from synctera_client.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from synctera_client.model.apple_digital_wallet_provision_request import AppleDigitalWalletProvisionRequest
from synctera_client.model.apple_digital_wallet_provision_response import AppleDigitalWalletProvisionResponse
from synctera_client.model.digital_wallet_token_edit_request import DigitalWalletTokenEditRequest
from synctera_client.model.digital_wallet_token_response import DigitalWalletTokenResponse
from synctera_client.model.digital_wallet_token_state import DigitalWalletTokenState
from synctera_client.model.error import Error
from synctera_client.model.google_digital_wallet_provision_request import GoogleDigitalWalletProvisionRequest
from synctera_client.model.google_digital_wallet_provision_response import GoogleDigitalWalletProvisionResponse
from synctera_client.model.token_list_response import TokenListResponse


class DigitalWalletTokensApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_digital_wallet_apple_endpoint = _Endpoint(
            settings={
                'response_type': (AppleDigitalWalletProvisionResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cards/{card_id}/digital_wallet_tokens/applepay',
                'operation_id': 'create_digital_wallet_apple',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'card_id',
                    'apple_digital_wallet_provision_request',
                ],
                'required': [
                    'card_id',
                    'apple_digital_wallet_provision_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'card_id':
                        (str,),
                    'apple_digital_wallet_provision_request':
                        (AppleDigitalWalletProvisionRequest,),
                },
                'attribute_map': {
                    'card_id': 'card_id',
                },
                'location_map': {
                    'card_id': 'path',
                    'apple_digital_wallet_provision_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.create_digital_wallet_google_endpoint = _Endpoint(
            settings={
                'response_type': (GoogleDigitalWalletProvisionResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cards/{card_id}/digital_wallet_tokens/googlepay',
                'operation_id': 'create_digital_wallet_google',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'card_id',
                    'google_digital_wallet_provision_request',
                ],
                'required': [
                    'card_id',
                    'google_digital_wallet_provision_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'card_id':
                        (str,),
                    'google_digital_wallet_provision_request':
                        (GoogleDigitalWalletProvisionRequest,),
                },
                'attribute_map': {
                    'card_id': 'card_id',
                },
                'location_map': {
                    'card_id': 'path',
                    'google_digital_wallet_provision_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.get_digital_wallet_token_endpoint = _Endpoint(
            settings={
                'response_type': (DigitalWalletTokenResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cards/digital_wallet_tokens/{digital_wallet_token_id}',
                'operation_id': 'get_digital_wallet_token',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'digital_wallet_token_id',
                ],
                'required': [
                    'digital_wallet_token_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'digital_wallet_token_id':
                        (str,),
                },
                'attribute_map': {
                    'digital_wallet_token_id': 'digital_wallet_token_id',
                },
                'location_map': {
                    'digital_wallet_token_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_digital_wallet_tokens_endpoint = _Endpoint(
            settings={
                'response_type': (TokenListResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cards/digital_wallet_tokens',
                'operation_id': 'list_digital_wallet_tokens',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'card_id',
                    'token_state',
                    'limit',
                    'page_token',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'limit',
                ]
            },
            root_map={
                'validations': {
                    ('limit',): {

                        'inclusive_minimum': 1,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'card_id':
                        (str,),
                    'token_state':
                        (DigitalWalletTokenState,),
                    'limit':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'card_id': 'card_id',
                    'token_state': 'token_state',
                    'limit': 'limit',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'card_id': 'query',
                    'token_state': 'query',
                    'limit': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_digital_wallet_token_status_endpoint = _Endpoint(
            settings={
                'response_type': (DigitalWalletTokenResponse,),
                'auth': [
                    'bearerAuth'
                ],
                'endpoint_path': '/cards/digital_wallet_tokens/{digital_wallet_token_id}',
                'operation_id': 'update_digital_wallet_token_status',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'digital_wallet_token_id',
                    'digital_wallet_token_edit_request',
                ],
                'required': [
                    'digital_wallet_token_id',
                    'digital_wallet_token_edit_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'digital_wallet_token_id':
                        (str,),
                    'digital_wallet_token_edit_request':
                        (DigitalWalletTokenEditRequest,),
                },
                'attribute_map': {
                    'digital_wallet_token_id': 'digital_wallet_token_id',
                },
                'location_map': {
                    'digital_wallet_token_id': 'path',
                    'digital_wallet_token_edit_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'application/problem+json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )

    def create_digital_wallet_apple(
        self,
        card_id,
        apple_digital_wallet_provision_request,
        **kwargs
    ):
        """Create digital wallet token provision request for Apple Pay  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_digital_wallet_apple(card_id, apple_digital_wallet_provision_request, async_req=True)
        >>> result = thread.get()

        Args:
            card_id (str):
            apple_digital_wallet_provision_request (AppleDigitalWalletProvisionRequest): Request to provision digital wallet card data to pass to Apple Pay digital wallet

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AppleDigitalWalletProvisionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['card_id'] = \
            card_id
        kwargs['apple_digital_wallet_provision_request'] = \
            apple_digital_wallet_provision_request
        return self.create_digital_wallet_apple_endpoint.call_with_http_info(**kwargs)

    def create_digital_wallet_google(
        self,
        card_id,
        google_digital_wallet_provision_request,
        **kwargs
    ):
        """Create digital wallet token provision request for Google Pay  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_digital_wallet_google(card_id, google_digital_wallet_provision_request, async_req=True)
        >>> result = thread.get()

        Args:
            card_id (str):
            google_digital_wallet_provision_request (GoogleDigitalWalletProvisionRequest): Request to provision digital wallet card data to pass to Google Pay digital wallet

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            GoogleDigitalWalletProvisionResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['card_id'] = \
            card_id
        kwargs['google_digital_wallet_provision_request'] = \
            google_digital_wallet_provision_request
        return self.create_digital_wallet_google_endpoint.call_with_http_info(**kwargs)

    def get_digital_wallet_token(
        self,
        digital_wallet_token_id,
        **kwargs
    ):
        """Get Digital Wallet Token  # noqa: E501

        Get the details about the digital wallet token of a card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_digital_wallet_token(digital_wallet_token_id, async_req=True)
        >>> result = thread.get()

        Args:
            digital_wallet_token_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DigitalWalletTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['digital_wallet_token_id'] = \
            digital_wallet_token_id
        return self.get_digital_wallet_token_endpoint.call_with_http_info(**kwargs)

    def list_digital_wallet_tokens(
        self,
        **kwargs
    ):
        """List Digital Wallet Tokens  # noqa: E501

        List Digital Wallet Tokens   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_digital_wallet_tokens(async_req=True)
        >>> result = thread.get()


        Keyword Args:
            card_id (str): [optional]
            token_state (DigitalWalletTokenState): The status of the Digital Wallet Token. [optional]
            limit (int): [optional] if omitted the server will use the default value of 100
            page_token (str): [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            TokenListResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        return self.list_digital_wallet_tokens_endpoint.call_with_http_info(**kwargs)

    def update_digital_wallet_token_status(
        self,
        digital_wallet_token_id,
        digital_wallet_token_edit_request,
        **kwargs
    ):
        """Update Digital Wallet Token's life cycle status  # noqa: E501

        The status of a digital wallet token can be updated as, ACTIVE to SUSPENDED, SUSPENDED to ACTIVE, ACTIVE to TERMINATED or SUSPENDED to TERMINATED.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_digital_wallet_token_status(digital_wallet_token_id, digital_wallet_token_edit_request, async_req=True)
        >>> result = thread.get()

        Args:
            digital_wallet_token_id (str):
            digital_wallet_token_edit_request (DigitalWalletTokenEditRequest): Update Digital wallet token status

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            DigitalWalletTokenResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['digital_wallet_token_id'] = \
            digital_wallet_token_id
        kwargs['digital_wallet_token_edit_request'] = \
            digital_wallet_token_edit_request
        return self.update_digital_wallet_token_status_endpoint.call_with_http_info(**kwargs)

