/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection.jndi;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.connection.AggregationKernel;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryKernel;
import com.sas.services.connection.ConnectionFactoryRequest;
import com.sas.services.connection.ConnectionFactoryUtil;
import com.sas.services.connection.Credential;
import com.sas.services.connection.FailoverCluster;
import com.sas.services.connection.PasswordCredential;
import com.sas.services.connection.PoolingKernel;
import com.sas.services.connection.Puddle;
import com.sas.services.connection.PuddleEnvelope;
import com.sas.services.connection.Server;
import com.sas.services.connection.jndi.JNDIAuthServer;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class JNDIConnectionFactoryConfiguration
extends ConnectionFactoryConfiguration {
    private static SearchControls _searchControls = new SearchControls();
    private DirContext _context;
    private String _baseDN;
    private String _logicalName;
    private String _repositoryDomain;
    private boolean _userAuth = true;
    private boolean _adminAuth;
    private boolean _noPool;
    private Hashtable _env;
    private PasswordCredential _privLogin;
    private Cluster[] _clusters;
    private Puddle[] _puddles;

    public JNDIConnectionFactoryConfiguration(DirContext context, String baseDN, String logicalName, String repositoryDomain) {
        this(context, baseDN, logicalName, repositoryDomain, true, false, false);
    }

    public JNDIConnectionFactoryConfiguration(DirContext context, String baseDN, String logicalName, String repositoryDomain, boolean userAuth, boolean adminAuth, boolean noPool) {
        if (context == null) {
            throw new IllegalArgumentException("\"context\" cannot be null.");
        }
        if (baseDN == null) {
            throw new IllegalArgumentException("\"baseDN\" cannot be null.");
        }
        if (logicalName == null) {
            throw new IllegalArgumentException("\"logicalName\" cannot be null.");
        }
        this._context = context;
        this._baseDN = baseDN;
        this._logicalName = logicalName;
        this._repositoryDomain = repositoryDomain != null ? repositoryDomain : "";
        this._userAuth = userAuth;
        this._adminAuth = adminAuth;
        this._noPool = noPool;
    }

    public DirContext getContext() {
        return this._context;
    }

    public String getBaseDN() {
        return this._baseDN;
    }

    public String getLogicalName() {
        return this._logicalName;
    }

    public String getRepositoryDomain() {
        return this._repositoryDomain;
    }

    public boolean isUserAuth() {
        return this._userAuth;
    }

    public boolean isAdminAuth() {
        return this._adminAuth;
    }

    public boolean isNoPool() {
        return this._noPool;
    }

    @Override
    public boolean equals(Object that) {
        String thatBaseDN;
        if (!super.equals(that)) {
            return false;
        }
        JNDIConnectionFactoryConfiguration thatConfig = (JNDIConnectionFactoryConfiguration)that;
        DirContext thatContext = thatConfig.getContext();
        if (this._context != thatContext) {
            Hashtable<?, ?> thisEnv = null;
            Hashtable<?, ?> thatEnv = null;
            try {
                thisEnv = this._context.getEnvironment();
                thatEnv = thatContext.getEnvironment();
                if (thisEnv == null ? thatEnv != null : !thisEnv.equals(thatEnv)) {
                    return false;
                }
            }
            catch (NamingException ne) {
                return false;
            }
        }
        if (!this._baseDN.equals(thatBaseDN = thatConfig.getBaseDN())) {
            return false;
        }
        String thatLogicalName = thatConfig.getLogicalName();
        if (!this._logicalName.equals(thatLogicalName)) {
            return false;
        }
        String thatRepositoryDomain = thatConfig.getRepositoryDomain();
        if (!this._repositoryDomain.equals(thatRepositoryDomain)) {
            return false;
        }
        boolean thatUserAuth = thatConfig.isUserAuth();
        if (this._userAuth != thatUserAuth) {
            return false;
        }
        boolean thatAdminAuth = thatConfig.isAdminAuth();
        if (this._adminAuth != thatAdminAuth) {
            return false;
        }
        boolean thatNoPool = thatConfig.isNoPool();
        return this._noPool == thatNoPool;
    }

    @Override
    public int hashCode() {
        int hc = super.hashCode();
        try {
            Hashtable<?, ?> thisEnv = this._context.getEnvironment();
            hc ^= thisEnv.hashCode();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        hc ^= this._baseDN.hashCode();
        hc ^= this._logicalName.hashCode();
        hc ^= this._repositoryDomain.hashCode();
        if (this._userAuth) {
            ++hc;
        }
        if (this._adminAuth) {
            hc += 2;
        }
        if (this._noPool) {
            hc += 4;
        }
        return hc;
    }

    public String toString() {
        HashSet<String[]> nvPairSet = new HashSet<String[]>(8);
        if (this._context != null) {
            String contextStr = null;
            try {
                contextStr = this._context.getNameInNamespace();
            }
            catch (NamingException ne) {
                contextStr = String.valueOf((Object)null);
            }
            String[] nvPairContext = new String[]{"context", contextStr};
            nvPairSet.add(nvPairContext);
        }
        if (this._baseDN != null) {
            String[] nvPairBaseDN = new String[]{"baseDN", this._baseDN};
            nvPairSet.add(nvPairBaseDN);
        }
        if (this._logicalName != null) {
            String[] nvPairLogicalName = new String[]{"logicalName", this._logicalName};
            nvPairSet.add(nvPairLogicalName);
        }
        if (this._repositoryDomain != null) {
            String[] nvPairReposDomain = new String[]{"reposDomain", this._repositoryDomain};
            nvPairSet.add(nvPairReposDomain);
        }
        if (!this._userAuth) {
            String userAuthStr = Boolean.toString(this._userAuth);
            String[] nvPairUserAuth = new String[]{"userAuth", userAuthStr};
            nvPairSet.add(nvPairUserAuth);
        }
        if (this._adminAuth) {
            String adminAuthStr = Boolean.toString(this._adminAuth);
            String[] nvPairAdminAuth = new String[]{"adminAuth", adminAuthStr};
            nvPairSet.add(nvPairAdminAuth);
        }
        if (this._noPool) {
            String noPoolStr = Boolean.toString(this._noPool);
            String[] nvPairNoPool = new String[]{"noPool", noPoolStr};
            nvPairSet.add(nvPairNoPool);
        }
        int nvPairSetL = nvPairSet.size();
        String[][] nvPairArr = new String[nvPairSetL][];
        nvPairArr = (String[][])nvPairSet.toArray((T[])nvPairArr);
        String str = ConnectionFactoryUtil.nvPairsToString(nvPairArr);
        return str;
    }

    @Override
    @SASScope
    protected ConnectionFactoryKernel doGetKernel(ConnectionFactoryRequest cxfReq) throws ConnectionFactoryException {
        if (this._clusters == null && this._puddles == null) {
            try {
                this._env = this._context.getEnvironment();
            }
            catch (NamingException ne) {
                throw new ConnectionFactoryException(ne);
            }
            this.resolve();
        }
        ConnectionFactoryKernel kernel = null;
        if (this._puddles != null) {
            PuddleEnvelope[] envs = new PuddleEnvelope[this._puddles.length];
            for (int i = 0; i < this._puddles.length; ++i) {
                envs[i] = new PuddleEnvelope(this._puddles[i]);
                if (this._privLogin == null) continue;
                envs[i].addUserToCache(this._privLogin);
            }
            JNDIAuthServer authServer = new JNDIAuthServer(envs, this);
            kernel = new PoolingKernel(cxfReq, envs, authServer);
        } else {
            kernel = new AggregationKernel(cxfReq, this._clusters);
        }
        return kernel;
    }

    @Override
    @SASScope
    protected String doGetLogicalServerName() {
        return this._logicalName;
    }

    private void resolve() throws ConnectionFactoryException {
        Map clusterMap = this.resolveClusters();
        if (!this._noPool) {
            this._puddles = this.resolvePuddles(clusterMap);
            if (this._puddles != null) {
                return;
            }
        }
        Set mapEntries = clusterMap.entrySet();
        Iterator entryIterator = mapEntries.iterator();
        this._clusters = new Cluster[mapEntries.size()];
        int i = 0;
        while (entryIterator.hasNext()) {
            HashSet serverSet = new HashSet();
            Set outerSet = (Set)entryIterator.next().getValue();
            for (Set innerSet : outerSet) {
                serverSet.addAll(innerSet);
            }
            Server[] servers = new Server[serverSet.size()];
            servers = serverSet.toArray(servers);
            FailoverCluster cluster = new FailoverCluster(servers);
            this._clusters[i++] = cluster;
        }
    }

    private Map resolveClusters() throws ConnectionFactoryException {
        try {
            HashMap<String, HashSet<Set>> clusterMap = new HashMap<String, HashSet<Set>>();
            StringBuffer filterBuffer = new StringBuffer(100);
            filterBuffer.append("(&(objectclass=sasServer)(sasProtocol=bridge)(sasLogicalName=");
            filterBuffer.append(this._logicalName).append("))");
            String filter = filterBuffer.toString();
            NamingEnumeration<SearchResult> serverEnumeration = null;
            try {
                serverEnumeration = this._context.search(this._baseDN, filter, _searchControls);
            }
            catch (CommunicationException ce) {
                this.reconnect(ce);
                serverEnumeration = this._context.search(this._baseDN, filter, _searchControls);
            }
            while (serverEnumeration.hasMore()) {
                SearchResult serverResult = serverEnumeration.next();
                Attributes serverAttributes = serverResult.getAttributes();
                Attribute domainAttr = serverAttributes.get("sasDomainName");
                String domain = domainAttr != null ? (String)domainAttr.get() : "";
                HashSet<Set> outerSet = (HashSet<Set>)clusterMap.get(domain);
                if (outerSet == null) {
                    outerSet = new HashSet<Set>();
                    clusterMap.put(domain, outerSet);
                }
                outerSet.add(JNDIConnectionFactoryConfiguration.resolveServers(serverAttributes, domain));
            }
            return clusterMap;
        }
        catch (NamingException ne) {
            throw new ConnectionFactoryException(ne);
        }
    }

    private Puddle[] resolvePuddles(Map clusterMap) throws ConnectionFactoryException {
        if (this._userAuth || this._adminAuth) {
            String privUserName = (String)this._env.get("java.naming.security.principal");
            String privPassword = (String)this._env.get("java.naming.security.credentials");
            if (privUserName != null && privPassword != null) {
                this._privLogin = new PasswordCredential(JNDIConnectionFactoryConfiguration.normalizeDN(privUserName), privPassword, this._repositoryDomain);
            }
        }
        try {
            StringBuffer filterBuffer = new StringBuffer(100);
            filterBuffer.append("(&(objectclass=sasLogin)(objectclass=top)(sasLogicalName=");
            String filter = filterBuffer.append(this._logicalName).append("))").toString();
            filterBuffer.setLength(0);
            NamingEnumeration<SearchResult> loginEnumeration = null;
            try {
                loginEnumeration = this._context.search(this._baseDN, filter, _searchControls);
            }
            catch (CommunicationException ce) {
                this.reconnect(ce);
                loginEnumeration = this._context.search(this._baseDN, filter, _searchControls);
            }
            if (!loginEnumeration.hasMore()) {
                filter = filterBuffer.append("(&(objectclass=sasLogin)(sasLogicalName=").append(this._logicalName).append("))").toString();
                filterBuffer.setLength(0);
                try {
                    loginEnumeration = this._context.search(this._baseDN, filter, _searchControls);
                }
                catch (CommunicationException ce) {
                    this.reconnect(ce);
                    loginEnumeration = this._context.search(this._baseDN, filter, _searchControls);
                }
            }
            if (!loginEnumeration.hasMore()) {
                return null;
            }
            HashSet<Puddle> puddleSet = new HashSet<Puddle>();
            while (loginEnumeration.hasMore()) {
                SearchResult searchResult = loginEnumeration.next();
                Attributes loginAttributes = searchResult.getAttributes();
                Attribute domainAttr = loginAttributes.get("sasDomainName");
                String domain = domainAttr != null ? (String)domainAttr.get() : "";
                Set outerSet = (Set)clusterMap.get(domain);
                if (outerSet == null) continue;
                puddleSet.add(this.resolvePuddle(searchResult.getName(), loginAttributes, domain, outerSet));
            }
            int puddleCount = puddleSet.size();
            if (puddleCount == 0) {
                return null;
            }
            Puddle[] puddles = new Puddle[puddleCount];
            puddles = puddleSet.toArray(puddles);
            return puddles;
        }
        catch (NamingException ne) {
            throw new ConnectionFactoryException(ne);
        }
    }

    private static Set resolveServers(Attributes serverAttributes, String domain) throws ConnectionFactoryException {
        try {
            String classID = "440196d4-90f0-11d0-9f41-00a024bb830c";
            int port = Integer.parseInt((String)serverAttributes.get("sasPort").get());
            Attribute maxPerPoolAttr = serverAttributes.get("sasMaxPerWorkspacePool");
            int maxClients = maxPerPoolAttr != null ? Integer.parseInt((String)maxPerPoolAttr.get()) : Integer.MIN_VALUE;
            Attribute recycleActivationLimitAttr = serverAttributes.get("sas-RecycleActivationLimit");
            int reactivationLimit = recycleActivationLimitAttr != null ? Integer.parseInt((String)recycleActivationLimitAttr.get()) : Integer.MIN_VALUE;
            Attribute runForeverAttr = serverAttributes.get("sas-ServerRunForever");
            int shutdownAfterMinutes = Integer.MIN_VALUE;
            if (runForeverAttr != null && !Boolean.valueOf((String)runForeverAttr.get()).booleanValue()) {
                Attribute shutdownAfterAttr = serverAttributes.get("sas-ServerShutdownAfter");
                shutdownAfterMinutes = shutdownAfterAttr != null ? Integer.parseInt((String)shutdownAfterAttr.get()) : 3;
            }
            Attribute requiredEncryptionLevelAttr = serverAttributes.get("sasRequiredEncryptionLevel");
            String encryptionPolicy = null;
            String encryptionContent = null;
            if (requiredEncryptionLevelAttr != null) {
                String requiredEncryptionLevel = ((String)requiredEncryptionLevelAttr.get()).toLowerCase(Locale.US);
                if (requiredEncryptionLevel.equals("authentication") || requiredEncryptionLevel.equals("credentials")) {
                    encryptionPolicy = "required";
                    encryptionContent = "authentication";
                } else if (requiredEncryptionLevel.equals("all") || requiredEncryptionLevel.equals("everything")) {
                    encryptionPolicy = "required";
                    encryptionContent = "all";
                }
            }
            Attribute dnsNames = serverAttributes.get("sasMachineDNSName");
            HashSet<BridgeServer> innerSet = new HashSet<BridgeServer>(dnsNames.size());
            NamingEnumeration<?> dnsNameEnum = dnsNames.getAll();
            while (dnsNameEnum.hasMore()) {
                String host = (String)dnsNameEnum.next();
                BridgeServer server = new BridgeServer(classID, host, port);
                if (encryptionPolicy != null) {
                    server.setEncryptionPolicy(encryptionPolicy);
                }
                if (encryptionContent != null) {
                    server.setEncryptionContent(encryptionContent);
                }
                if (maxClients != Integer.MIN_VALUE) {
                    server.setMaxClients(maxClients);
                }
                if (reactivationLimit != Integer.MIN_VALUE) {
                    server.setReactivationLimit(reactivationLimit);
                }
                if (shutdownAfterMinutes != Integer.MIN_VALUE) {
                    server.setShutdownAfterMinutes(shutdownAfterMinutes);
                }
                server.setDomain(domain);
                innerSet.add(server);
            }
            return innerSet;
        }
        catch (NamingException ne) {
            throw new ConnectionFactoryException(ne);
        }
    }

    private Puddle resolvePuddle(String name, Attributes loginAttributes, String domain, Set outerSet) throws ConnectionFactoryException {
        try {
            String userName = (String)loginAttributes.get("sasLoginName").get();
            String password = SasPasswordString.decode((String)((String)loginAttributes.get("sasUserPassword").get()));
            PasswordCredential login = new PasswordCredential(userName, password, domain);
            Attribute sasMinSizeAttr = loginAttributes.get("sasMinSize");
            int minSize = sasMinSizeAttr != null ? Integer.parseInt((String)sasMinSizeAttr.get()) : 0;
            Attribute sasMinAvailAttr = loginAttributes.get("sasMinAvail");
            int minAvail = sasMinAvailAttr != null ? Integer.parseInt((String)sasMinAvailAttr.get()) : 0;
            HashSet<String> authorizedUsers = null;
            if (this._userAuth) {
                Attribute sasAllowedClientDNAttr;
                authorizedUsers = new HashSet<String>();
                Attribute sasReferenceDNAttr = loginAttributes.get("sasReferenceDN");
                if (sasReferenceDNAttr != null) {
                    NamingEnumeration<?> values = sasReferenceDNAttr.getAll();
                    while (values.hasMore()) {
                        authorizedUsers.add(JNDIConnectionFactoryConfiguration.normalizeDN((String)values.next()));
                    }
                }
                if ((sasAllowedClientDNAttr = loginAttributes.get("sasAllowedClientDN")) != null) {
                    NamingEnumeration<?> values = sasAllowedClientDNAttr.getAll();
                    while (values.hasMore()) {
                        authorizedUsers.add(JNDIConnectionFactoryConfiguration.normalizeDN((String)values.next()));
                    }
                }
            }
            String puddleID = null;
            if (this._adminAuth) {
                puddleID = name + "," + this._baseDN;
            }
            Cluster[] clusters = new Cluster[outerSet.size()];
            Iterator outerIterator = outerSet.iterator();
            int i = 0;
            while (outerIterator.hasNext()) {
                Set innerSet = (Set)outerIterator.next();
                Server[] servers = new Server[innerSet.size()];
                servers = innerSet.toArray(servers);
                clusters[i++] = new FailoverCluster(servers);
            }
            Puddle puddle = new Puddle(clusters, (Credential)login);
            puddle.setMinSize(minSize);
            puddle.setMinAvail(minAvail);
            puddle.setUsers(authorizedUsers);
            puddle.setPuddleID(puddleID);
            return puddle;
        }
        catch (NamingException ne) {
            throw new ConnectionFactoryException(ne);
        }
        catch (SasPasswordEncodingException spee) {
            throw new ConnectionFactoryException(spee);
        }
    }

    protected Hashtable getEnv() {
        return this._env;
    }

    protected PasswordCredential getPrivLogin() {
        return this._privLogin;
    }

    protected void reconnect(CommunicationException ce) throws CommunicationException {
        try {
            this._context = new InitialDirContext(this._env);
        }
        catch (NamingException ne) {
            throw ce;
        }
    }

    public static String normalizeDN(String dn) {
        int length = dn.length();
        if (length == 0) {
            return dn;
        }
        boolean normalize = false;
        int i = 1;
        int before = -1;
        int current = dn.charAt(0);
        int after = length > 1 ? (int)dn.charAt(1) : -1;
        char last = dn.charAt(length - 1);
        if (JNDIConnectionFactoryConfiguration.isWhite(current) || JNDIConnectionFactoryConfiguration.isWhite(last)) {
            normalize = true;
        }
        while (current >= 0 && !normalize) {
            if (Character.isUpperCase((char)current)) {
                normalize = true;
                continue;
            }
            if ((current == 61 || current == 44 || current == 59) && (JNDIConnectionFactoryConfiguration.isWhite(before) || JNDIConnectionFactoryConfiguration.isWhite(after))) {
                normalize = true;
                continue;
            }
            before = current;
            current = after;
            after = ++i < length ? (int)dn.charAt(i) : -1;
        }
        if (!normalize) {
            return dn;
        }
        StringBuffer normalBuffer = new StringBuffer(length);
        int state = 0;
        int white = 0;
        block7: for (i = 0; i < length; ++i) {
            char c = dn.charAt(i);
            switch (state) {
                case 0: {
                    if (JNDIConnectionFactoryConfiguration.isWhite(c)) continue block7;
                    normalBuffer.append(Character.toLowerCase(c));
                    state = c == '\"' ? 2 : 1;
                    continue block7;
                }
                case 1: {
                    if (JNDIConnectionFactoryConfiguration.isWhite(c)) {
                        ++white;
                        normalBuffer.append(c);
                        continue block7;
                    }
                    if (c == '=' || c == ',' || c == ';') {
                        normalBuffer.setLength(normalBuffer.length() - white);
                        normalBuffer.append(c);
                        white = 0;
                        state = 0;
                        continue block7;
                    }
                    if (c == '\"') {
                        normalBuffer.append(c);
                        white = 0;
                        state = 2;
                        continue block7;
                    }
                    normalBuffer.append(Character.toLowerCase(c));
                    white = 0;
                    continue block7;
                }
                case 2: {
                    if (c == '\"') {
                        normalBuffer.append(c);
                        state = 1;
                        continue block7;
                    }
                    if (c == '\\') {
                        normalBuffer.append(c);
                        state = 3;
                        continue block7;
                    }
                    normalBuffer.append(Character.toLowerCase(c));
                    continue block7;
                }
                case 3: {
                    state = 2;
                    normalBuffer.append(Character.toLowerCase(c));
                }
            }
        }
        if (white > 0) {
            normalBuffer.setLength(normalBuffer.length() - white);
        }
        return normalBuffer.toString();
    }

    private static boolean isWhite(int c) {
        return c == 32 || c == 9 || c == 10;
    }

    static {
        _searchControls.setSearchScope(2);
    }
}

