/*
 * Decompiled with CFR 0.152.
 */
package com.sas.services.connection;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.Server;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class LoadBalancingCluster
extends Cluster {
    private static final long serialVersionUID = -6540622077802844816L;

    public LoadBalancingCluster(Server server) {
        this(new Server[]{server});
    }

    public LoadBalancingCluster(Server[] servers) {
        super(servers);
    }

    @Override
    public int getClusterType() {
        return 0;
    }

    @Override
    protected int computeMaxClients() {
        Server[] servers = this.getServerArray();
        long maxClients = 0L;
        for (int i = 0; i < servers.length; ++i) {
            maxClients += (long)servers[i].getMaxClients();
        }
        return maxClients <= Integer.MAX_VALUE ? (int)maxClients : Integer.MAX_VALUE;
    }
}

