/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.io.OutputStreamHeaderInterface;
import com.sas.iom.OutputStreamHeader;
import com.sas.iom.RB;
import com.sas.iom.SASCache.ICacheService;
import com.sas.iom.SASCache.ICacheWriter;
import com.sas.iom.SASIOMDefs.GenericError;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Map;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public class OutputStream
extends java.io.OutputStream {
    private ICacheWriter _iCacheWriter = null;
    private ICacheService _iCacheService = null;
    private boolean _dataWritten = false;
    private OutputStreamHeader _header = null;

    public OutputStream(ICacheWriter iCacheWriter, ICacheService iCacheService) {
        this._iCacheWriter = iCacheWriter;
        this._iCacheService = iCacheService;
    }

    public OutputStreamHeaderInterface getHeader() {
        if (this._header == null) {
            try {
                this._header = new OutputStreamHeader(this);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return this._header;
    }

    public void putData(byte[] data) {
        StreamData runnable = new StreamData(this, data);
        Thread t = new Thread(runnable);
        t.start();
    }

    public void putData(String data) {
        this.putData(data, null);
    }

    public void putData(String data, String encoding) {
        StreamData runnable = new StreamData(this, data, encoding);
        Thread t = new Thread(runnable);
        t.start();
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buffer = new byte[]{(byte)b};
        this.writeBuffer(buffer);
        this._dataWritten = true;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.writeBuffer(b);
        this._dataWritten = true;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] buffer = new byte[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = b[off + i];
        }
        this.writeBuffer(buffer);
        this._dataWritten = true;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._iCacheWriter != null) {
                this._iCacheWriter.Close();
            }
        }
        catch (GenericError e) {
            throw new IOException(MessageFormat.format(RB.getStringResource("OutputStream.closeException.fmt.ex.txt"), e.getMessage()));
        }
    }

    private void writeBuffer(byte[] buffer) throws IOException {
        try {
            if (this._iCacheWriter != null) {
                this._iCacheWriter.Write(buffer);
            }
        }
        catch (GenericError e) {
            throw new IOException(MessageFormat.format(RB.getStringResource("OutputStream.writeException.fmt.ex.txt"), e.getMessage()));
        }
    }

    void setHeader(String name, String value) throws IOException, IllegalStateException {
        if (this._dataWritten) {
            throw new IllegalStateException(RB.getStringResource("OutputStream.illegalWrite.ex.txt"));
        }
        try {
            if (this._iCacheWriter != null) {
                this._iCacheWriter.SetProperty(name, value);
            }
        }
        catch (GenericError e) {
            throw new IOException(MessageFormat.format(RB.getStringResource("OutputStream.setPropertyException.fmt.ex.txt"), e.getMessage()));
        }
    }

    void setHeaders(Map headers) throws IOException, IllegalStateException {
        if (this._dataWritten) {
            throw new IllegalStateException(RB.getStringResource("OutputStream.illegalWrite.ex.txt"));
        }
        for (String key : headers.keySet()) {
            try {
                if (this._iCacheWriter == null) continue;
                this._iCacheWriter.SetProperty(key, (String)headers.get(key));
            }
            catch (GenericError e) {
                throw new IOException(MessageFormat.format(RB.getStringResource("OutputStream.setPropertyException.fmt.ex.txt"), e.getMessage()));
            }
        }
    }

    @SASScope
    class StreamData
    implements Runnable {
        OutputStream _outputStream = null;
        Object _data = null;
        String _encoding = null;

        StreamData(OutputStream outputStream2, Object data) {
            this(outputStream2, data, null);
        }

        StreamData(OutputStream outputStream2, Object data, String encoding) {
            this._outputStream = outputStream2;
            this._data = data;
            this._encoding = encoding;
        }

        @Override
        public void run() {
            if (this._data instanceof String) {
                String data = (String)this._data;
                BufferedWriter bw = null;
                if (this._encoding == null) {
                    bw = new BufferedWriter(new OutputStreamWriter(this._outputStream));
                } else {
                    try {
                        bw = new BufferedWriter(new OutputStreamWriter((java.io.OutputStream)this._outputStream, this._encoding));
                    }
                    catch (UnsupportedEncodingException ue) {
                        ue.printStackTrace();
                    }
                }
                if (bw != null) {
                    try {
                        bw.write(data, 0, data.length());
                        bw.flush();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            } else {
                byte[] data = (byte[])this._data;
                BufferedOutputStream bos = new BufferedOutputStream(this._outputStream);
                try {
                    bos.write(data, 0, data.length);
                    bos.flush();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            try {
                this._outputStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

