/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.MissingValues;
import com.sas.SpecialValues;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDateType;
import com.sas.datatypes.DataTypeUtil;
import com.sas.datatypes.RB;
import com.sas.text.NLFormats;
import com.sas.util.CalendarUtil;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.Util;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import com.sas.util.transforms.StringToMissingValuesTransform;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

@SASScope
public class DateType
extends BaseDateType {
    public static final String RB_KEY = "DateType.";
    public static final DateType DEFAULT_INSTANCE = new DateType();
    public static final DateType DEFAULT_LOCAL_INSTANCE = new DateType(TimeZone.getDefault());

    public DateType() {
    }

    public DateType(TimeZone timeZone) {
        super(timeZone);
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof DatePeriod) {
            DatePeriod dp = (DatePeriod)inputValue;
            if ((dp.getPeriodType() == DateTypes.DATE || dp.getPeriodType() == DateTypes.WEEKDAY) && Util.equal(dp.getTimeZone(), this.timeZone)) {
                return dp;
            }
            return this.coerceValue(dp.toString(null, inputLocale), inputLocale);
        }
        if (inputValue instanceof Date) {
            if (!(inputValue instanceof Time) && !(inputValue instanceof Timestamp)) {
                return inputValue;
            }
        } else {
            if (inputValue instanceof Calendar) {
                return DataTypeUtil.convertDateToTimeZone(((Calendar)inputValue).getTime(), ((Calendar)inputValue).getTimeZone(), this.getTimeZone(), inputLocale);
            }
            if (inputValue instanceof ValueItem) {
                return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
            }
            if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
                return this.coerceValue(((String[])inputValue)[0], inputLocale);
            }
            if (inputValue instanceof String) {
                String value = (String)inputValue;
                if (value.trim().length() == 0) {
                    return null;
                }
                MissingValues missingValue = MissingValues.getNumericMissingValues((String)inputValue);
                if (missingValue != null) {
                    return missingValue;
                }
                SpecialValues specialValue = SpecialValues.valueOf((String)inputValue);
                if (specialValue != null) {
                    return specialValue;
                }
                try {
                    DateTypes[] dateTypes = new DateTypes[]{DateTypes.DATE};
                    DatePeriod dp = DatePeriod.parseDatePeriod(value, dateTypes, this.getTimeZone(), inputLocale);
                    if (dp != null) {
                        return dp;
                    }
                }
                catch (ParseException e) {
                    // empty catch block
                }
                Object transformObj = StringToMissingValuesTransform.defaultInstance.transform(value);
                if (transformObj.equals(MissingValues.Dot)) {
                    return MissingValues.Dot;
                }
            } else {
                if (inputValue instanceof MissingValues) {
                    return inputValue;
                }
                if (inputValue instanceof SpecialValues) {
                    return inputValue;
                }
                if (inputValue == null) {
                    return null;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("DateType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object out = null;
        try {
            out = new DatePeriod(CalendarUtil.parseDateString(input, null, this.timeZone), DateTypes.DATE, this.timeZone, Locale.US);
        }
        catch (ParseException e) {
            out = this.coerceValue(input, Locale.US);
        }
        return out;
    }

    @Override
    public String getPersistanceString(Object value) {
        String out = null;
        if (value == null) {
            return out;
        }
        if (value instanceof String && ((String)value).trim().length() == 0) {
            return out;
        }
        if (value instanceof MissingValues) {
            return MissingValues.toQueryString((MissingValues)value);
        }
        if (value instanceof SpecialValues) {
            return ((SpecialValues)value).getName();
        }
        out = value instanceof Calendar ? CalendarUtil.formatCalendar((Calendar)value, null) : (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate() ? ((DatePeriod)value).toString() : CalendarUtil.formatDate((Date)value, "yyyy'-'MM'-'dd'T'00':'00':'00'Z'"));
        return out;
    }

    @Override
    public DateFormat getDateFormatter(Object value, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(NLFormats.getPattern(this.getDefaultFormatName(), locale), locale);
        sdf.setLenient(false);
        return sdf;
    }

    @Override
    public DateTypes getDateType() {
        return DateTypes.DATE;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (this.isSpecialMacroValue(value)) {
            return this.getMacroVariablesForSpecialValues(macroInfoSource, value);
        }
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(baseMacroVariableName, DateType.formatSASDate((Date)value));
        if (value instanceof DatePeriod && ((DatePeriod)value).isRelativeDate()) {
            map.put(baseMacroVariableName + "_rel", value.toString());
        }
        if (value instanceof Date) {
            map.put(baseMacroVariableName + "_label", this.getLabelForDate((Date)value, locale));
        } else {
            map.put(baseMacroVariableName + "_label", this.getDisplayString(value, locale));
        }
        return map;
    }

    public static String formatSASDate(Date date) {
        DateFormat formatter = null;
        if (formatter == null) {
            formatter = new SimpleDateFormat("ddMMMyyyy", Locale.US);
            formatter.setTimeZone(gmtTimeZone);
            formatter.setLenient(false);
        }
        return formatter.format(date);
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object out = this.coerceValue(value, inputLocale);
        if (out != null && out == value && out instanceof Date) {
            return ((Date)out).clone();
        }
        return out;
    }

    @Override
    public String getDefaultFormatName() {
        return "NLDATE";
    }
}

