# Copyright 2018 PayTrace, Inc.
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

ASN1_SOURCE_LIST = []

# Auto-generated by asn1ate v.0.6.1.dev0 from json.asn1
# (last modified on 2018-05-03 15:59:38.732845)


ASN1_SOURCE_LIST.append(r"""
JSON-module DEFINITIONS ::=
BEGIN
EXPORTS JSONValue, JSONObject, KeyValuePair;

JSONObject ::= SET OF KeyValuePair
JSONValue ::= CHOICE { nullval NULL, strval UTF8String, numval REAL, boolval BOOLEAN, objval JSONObject, arrval SEQUENCE OF JSONValue }
KeyValuePair ::= [APPLICATION 1] IMPLICIT SEQUENCE { key UTF8String, value JSONValue }
END
""")

from pyasn1.type import univ, char, namedtype, namedval, tag, constraint, useful


class JSONValue(univ.Choice):
    pass


class KeyValuePair(univ.Sequence):
    pass


class JSONObject(univ.SetOf):
    pass


JSONValue.componentType = namedtype.NamedTypes(
    namedtype.NamedType('nullval', univ.Null()),
    namedtype.NamedType('strval', char.UTF8String()),
    namedtype.NamedType('numval', univ.Real()),
    namedtype.NamedType('boolval', univ.Boolean()),
    namedtype.NamedType('objval', JSONObject()),
    namedtype.NamedType('arrval', univ.SequenceOf(componentType=JSONValue()))
)


KeyValuePair.tagSet = univ.Sequence.tagSet.tagImplicitly(tag.Tag(tag.tagClassApplication, tag.tagFormatConstructed, 1))
KeyValuePair.componentType = namedtype.NamedTypes(
    namedtype.NamedType('key', char.UTF8String()),
    namedtype.NamedType('value', JSONValue())
)


JSONObject.componentType = KeyValuePair()



ASN1_SOURCE = ''.join(ASN1_SOURCE_LIST)

