"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
const component_1 = require("../component");
const render_options_1 = require("../javascript/render-options");
/**
 * Sets up a typescript project to use TypeScript for projenrc.
 */
class Projenrc extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.rcfile = options.filename ?? ".projenrc.ts";
        const projensrc = options.projenCodeDir ?? "projenrc";
        // tell eslint to take .projenrc.ts and *.ts files under `projen` into account as a dev-dependency
        project.tsconfigDev.addInclude(this.rcfile);
        project.eslint?.allowDevDeps(this.rcfile);
        project.eslint?.addIgnorePattern(`!${this.rcfile}`);
        project.tsconfigDev.addInclude(`${projensrc}/**/*.ts`);
        project.eslint?.allowDevDeps(`${projensrc}/**/*.ts`);
        project.eslint?.addIgnorePattern(`!${projensrc}/**/*.ts`);
        // this is the task projen executes when running `projen` without a
        // specific task (if this task is not defined, projen falls back to
        // running "node .projenrc.js").
        project.addDevDeps("ts-node");
        // we use "tsconfig.dev.json" here to allow projen source files to reside
        // anywhere in the project tree.
        project.defaultTask?.exec(`ts-node --project ${project.tsconfigDev.fileName} ${this.rcfile}`);
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_extra_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const parts = bootstrap.fqn.split(".");
        const moduleName = parts[0];
        const importName = parts[1];
        const className = parts.slice(1).join(".");
        const { renderedOptions, imports } = render_options_1.renderJavaScriptOptions({
            args: bootstrap.args,
            type: bootstrap.type,
            comments: bootstrap.comments,
        });
        imports.add(moduleName, importName);
        const lines = new Array();
        lines.push(...imports.asEsmImports());
        lines.push();
        lines.push(`const project = new ${className}(${renderedOptions});`);
        lines.push();
        lines.push("project.synth();");
        fs_extra_1.outputFileSync(rcfile, lines.join("\n"));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.typescript.Projenrc", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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