# Generated by Django 2.2 on 2022-02-28 04:44

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import filer.fields.image


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('cms', '0022_auto_20180620_1551'),
        migrations.swappable_dependency(settings.FILER_IMAGE_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ContentWidthVideo',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='content_width_video_contentwidthvideo', serialize=False, to='cms.CMSPlugin')),
                ('youtube_url', models.URLField(blank=True, help_text="\n            Enter the full URL of the youtube video page. \n            To start the video at a specific time add '&t=xx' to the end of the url (using seconds). \n            You can also add extra paramaters using an ampersand, for example '&t=75&autoplay=1'.\n        ", null=True, validators=[django.core.validators.URLValidator(message='Please enter the full URL of the Youtube video page', regex='www.youtube.com', schemes=['https'])])),
                ('alternate_url', models.URLField(blank=True, help_text='This will be used if no Youtube URL is provided', null=True)),
                ('title', models.CharField(blank=True, max_length=128)),
                ('alt_title', models.CharField(blank=True, default='', max_length=128)),
                ('alt_text', models.CharField(blank=True, default='', max_length=128)),
                ('display_image', models.BooleanField(default=True)),
                ('image', filer.fields.image.FilerImageField(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.FILER_IMAGE_MODEL)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin', models.Model),
        ),
    ]
