# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/oco2peak-map.ipynb (unless otherwise specified).

__all__ = ['build_sounding_scatter', 'build_sounding_map', 'plot_emission', 'build_world_map']

# Cell
import plotly.graph_objects as go

# Cell
def build_sounding_scatter(df_sounding, gaussian_param, plot_gaussian = True):
    xco2 = go.Scatter(
                    x=df_sounding['distance'],
                    y=df_sounding['xco2'],
                    text='xco2',
                    mode='markers',
                    opacity=0.5,
                    marker={
                        'size': 5,
                        'line': {'width': 0.5, 'color': 'white'}
                    },
                    name="xco2"
                )
    layout = go.Layout(
                xaxis={'title': 'Distance (km)'},
                yaxis={'title': 'CO² level in ppm'},
                #margin={'l': 40, 'b': 40, 't': 10, 'r': 10},
                legend={'x': 0, 'y': 1},
                hovermode='closest'
            )
    if plot_gaussian:
        gaussian_plot = go.Scatter(x=df_sounding['distance'], y=df_sounding['gaussian_y'], name="Gaussian fit",
                    hoverinfo='name',
                    line_shape='spline')
        sounding_plot = {
            'data': [xco2,gaussian_plot],
            'layout': layout
        }
    else:
        sounding_plot = {
            'data': [ xco2 ],
            'layout': layout
        }
    return sounding_plot

# Cell
def build_sounding_map(df_sounding, mapbox_token, peak_param=None):
    df = df_sounding
    center_lat = peak_param['latitude'] #df.latitude.min() + (df.latitude.max() - df.latitude.min())/2
    center_lon = peak_param['longitude'] #df.longitude.min() + (df.longitude.max() - df.longitude.min())/2
    xco_sounding_mapbox = go.Figure()
    _ = xco_sounding_mapbox.add_trace(go.Scattermapbox(
        lat=df.latitude,
        lon=df.longitude,
        mode='markers',
        marker=go.scattermapbox.Marker(color = df['xco2'], size=10, opacity=0.5),
        text=df.xco2,
        name='CO2 level'
    ))

    if peak_param is not None:
        wind_u = peak_param['windspeed_u']
        wind_v = peak_param['windspeed_v']
        x0=peak_param['latitude']
        y0=peak_param['longitude']
        x1=peak_param['latitude']+wind_u*0.3
        y1=peak_param['longitude']+wind_v*0.3
        _ = xco_sounding_mapbox.add_trace(go.Scattermapbox(
            mode = "lines",
            lon = [y0, y1],
            lat = [x0, x1],
            name="Wind direction",
            marker = {'size': 10})
            )
    xco_sounding_mapbox.update_layout(
        mapbox_style="satellite-streets",
        hovermode='closest',
        mapbox=dict(
            accesstoken=mapbox_token,
            bearing=0,
            center=go.layout.mapbox.Center(
                lat=center_lat,
                lon=center_lon
            ),
            pitch=0,
            zoom=6
        )
    )
    return xco_sounding_mapbox

# Cell
import plotly.graph_objects as go

def plot_emission(df_peak, peak_param, emission):
    fig = go.Figure()

    wind_u = emission['wind_u']
    wind_v = emission['wind_v']
    _ = fig.add_shape(
        # Wind vector
        type="line",
        x0=peak_param['latitude'],
        y0=peak_param['longitude'],
        x1=peak_param['latitude']+wind_u*0.3,
        y1=peak_param['longitude']+wind_v*0.3,
        name='Wind',
        line=dict(color="MediumPurple",width=4,dash="dot")
    )

    _ = fig.update_layout(
        showlegend=False,
        annotations=[
            dict(
                x=peak_param['latitude'],
                y=peak_param['longitude'],
                xref='x',
                yref='y',
                text="Wind",
                showarrow=True,
                arrowhead=1,
                ax=peak_param['latitude']+wind_u*0.3,
                ay=peak_param['longitude']+wind_v*0.3,
            )
        ]
    )
    return fig

# Cell
import folium
def build_world_map(data):
    folium_map = folium.Map([43, 0], zoom_start=4)
    folium.TileLayer("CartoDB dark_matter", name="Dark mode").add_to(folium_map)

    # Adding detected peaks
    peaks_group = folium.FeatureGroup(name="Peaks").add_to(folium_map)
    peaks_group_circle = folium.FeatureGroup(name=" - 50km Circles").add_to(folium_map)
    peaks_group_wind = folium.FeatureGroup(name=" - Wind Vectors").add_to(folium_map)

    for _, row in data.iterrows():
        radius = row["amplitude"]/20
        color="#FF3333" # red
        tooltip =  f'GPS : [{row.latitude:.2f} , {row.longitude:.2f}]'
        sounding = str(row.sounding_id.astype(int)) # TODO : find why .astype(str) add a '.0'
        date = sounding[:4] + '/' + sounding[4:6] + '/' + sounding[6:8]
        orbit = str(row['orbit'])
        wind = [[row['latitude'],row['longitude']],[row['latitude']+row['windspeed_u'],row['longitude']+row['windspeed_v']]]

        popup_html="""<h4>"""+tooltip+"""</h4>"""+date+"""<p>sounding_id: """+sounding+"""</br>orbit: """+orbit+"""</p>"""
        popup_html+='<p><input type="button" value="Show plot"'
        # Injecting JavaScript in popup to fire the Dash Callback
        popup_html+='onclick="\
            let bco_input = parent.document.getElementById(\'input_sounding\'); \
            let lastValue = bco_input.value;'
        popup_html+=f'bco_input.value = \'{sounding}\';'
        popup_html+="let bco_event = new Event('input', { bubbles: true });\
            bco_event.simulated = true;\
            let tracker = bco_input._valueTracker;\
            if (tracker) {\
            tracker.setValue(lastValue);\
            }\
            bco_input.dispatchEvent(bco_event);\
            elt.dispatchEvent(new Event('change'));\
            \"/></p>"
        #onclick="plot_data(\'{url}\', {slope}, {intercept}, {amplitude}, {sigma});"/></p>'

        popup=folium.Popup(popup_html, max_width=450)

        peaks_group.add_child(folium.CircleMarker(location=(row["latitude"],
                                    row["longitude"]),
                            radius=radius,
                            color=color,
                            tooltip=tooltip,
                            popup=popup,
                            fill=True))

        peaks_group_circle.add_child(folium.Circle(location=(row["latitude"],
                            row["longitude"]),
                            radius=50000,
                            color='#949494',
                            weight = 1,
                            fill=False))

        peaks_group_wind.add_child(folium.PolyLine(wind,
                        color='#B2B2B2',
                        weight = 1))
    return folium_map
