import pathlib
from setuptools import setup, find_packages
from distutils.core import setup

HERE = pathlib.Path(__file__).parent

README = (HERE / "README.md").read_text()

setup(
    name='gerrit_robo',
    url='https://github.com/tom-010/gerrit_robo.git',
    version='0.0.2',
    author='Thomas Deniffel',
    author_email='tdeniffel@gmail.com',
    packages=['gerrit_robo'], # find_packages(),
    license='Apache2',
    install_requires=[
        'requests'
    ],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3 :: Only',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7'
    ],
    description='A very thin wrapper around the gerrit API to allow robots to add comments to a patchset',
    long_description=README,
    long_description_content_type="text/markdown",
    python_requires='>=3',
    include_package_data=True,
    entry_points={
    }
)