import os
import pytest

from tral.sequence import sequence_io

TEST_FAA_FILE = "HIV-1_388796.faa"
TEST_SEQ_1 = "MKVMGIQRNCQQWWIWGILGFWMLMICNGMGNLWVTVYYGVPVWKDASPTLFCASDAKAYDTE" \
    "VHNVWGTFACVPTDPSPQELGLENVTENFNMWKNDMVEQMHQDIISLWDQGLKPCVKLTPLCVTLNCNAIKN" \
    "NTKVTNNSINSANDEMKNCSFNITTELRDKKRKAYALFYKLDIVPLNNGSTDYRLINCNTSTITQACPKVSL" \
    "DPIPIHYCAPAGYAILKCRDKTFTGTGPCHNVSTVQCTHGIKPVVSTQLLLNGSIAEGETIIRFENLTNNAK" \
    "IIIVQLNESVEITCTRPSNNTRESIRIGPGQTFYATGDIIGDIRQAHCNISEEKWNKTLQKVKEKLQKHFPN" \
    "KTIEFKPSSGGDLEITTHSFNCGGEFFYCNTSNLFNSTKLELFNSSTNLNITLQCRIKQIINMWQGVGRAMY" \
    "APPIEGIIMCRSNITGLLLTRDGAKEPHSTKEIFRPEGGDMRDNWRSELYKYKVVEIKPLGVAPTKPKRRVV" \
    "EREKRAALGALFLGFLGAAGSTMGAASITLTVQARQLLSGIVQQQSNLLKAIEAQQHMLQLTVWGIKQLQTR" \
    "VLAIERHLRDQQLLGIWGCSGKLICTTAVPWNSSWSNKSQEEIWDNMTWMQWDREISNYTDIIYNLLEVSQN" \
    "QQDKNEKDLLALDKWENLWNWFNITNWLWYIKIFIMIVGGVIGLRIIFAVLSIVNRVRQGYSPLSFQTLIPH" \
    "PRGPDRLGGIEEEGGEQGRDRSIRLVNGFLAIFWDDLRSLCLFSYHRLRDLILIAARTVELLGRSSLKGLQR" \
    "GWETLKYLGSLVQYWGLELKKSAINLLNTTAIVVGEGTDRFIELIQRIWRAFCNIPRRIRQGLEAALQ"
TEST_SEQ_1_ID = "sp|Q75008|ENV_HV1ET"


@pytest.fixture
def path():
    """Return the path to the test data files.
    """
    return os.path.dirname(os.path.abspath(__file__))


@pytest.mark.no_external_software_required
def test_read_fasta(path):

    test_lSeq = list(sequence_io.read_fasta(os.path.join(path, TEST_FAA_FILE)))
    assert len(test_lSeq) == 9
    assert test_lSeq[0] == (TEST_SEQ_1, TEST_SEQ_1_ID)
