# coding: utf-8
"""
Data source: Dutour Sikirić, Mathieu, Olaf Delgado-Friedrichs, and Michel Deza. “Space Fullerenes: a Computer Search for New Frank-Kasper Structures” Acta Crystallographica Section A Foundations of Crystallography 66.Pt 5 (2010): 602–615.

Cage composition:
 (12,14,15,16) = (20,8,8,4,)
"""
desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        76 160
        112 139
        36 203
        215 146
        78 202
        143 87
        224 93
        178 122
        104 203
        77 92
        133 118
        35 99
        152 94
        220 77
        76 34
        86 44
        9 194
        167 145
        112 222
        166 139
        29 98
        37 225
        48 159
        173 30
        152 195
        202 209
        155 148
        149 156
        70 174
        143 117
        115 1
        114 100
        86 186
        18 104
        31 60
        183 159
        8 95
        125 85
        214 176
        45 25
        151 197
        14 181
        76 103
        179 147
        86 93
        168 70
        73 156
        96 53
        121 144
        32 119
        223 216
        124 170
        59 65
        219 91
        0 67
        226 98
        22 208
        113 73
        40 80
        23 180
        206 50
        214 216
        212 150
        77 79
        210 68
        223 138
        142 207
        88 90
        105 146
        10 186
        194 117
        163 205
        206 54
        43 97
        6 161
        43 211
        129 153
        48 171
        206 131
        64 98
        137 71
        11 139
        219 169
        2 78
        210 74
        121 47
        86 216
        106 16
        45 80
        2 44
        100 46
        176 150
        61 154
        143 174
        26 11
        224 110
        9 107
        176 41
        187 149
        94 111
        19 109
        100 91
        219 158
        71 74
        114 78
        174 11
        204 47
        94 75
        180 15
        122 162
        163 137
        89 62
        155 1
        152 51
        56 212
        32 208
        106 157
        101 75
        52 15
        97 84
        212 27
        220 196
        160 139
        151 41
        222 73
        157 4
        149 47
        178 154
        81 186
        124 115
        165 63
        187 141
        132 192
        205 17
        50 171
        119 182
        158 71
        13 70
        165 185
        133 209
        176 69
        117 127
        96 149
        69 27
        33 187
        168 15
        190 208
        76 174
        190 141
        143 201
        35 160
        188 182
        121 221
        215 79
        225 60
        12 18
        162 96
        218 30
        197 150
        124 0
        194 26
        101 95
        211 82
        82 145
        137 91
        10 21
        39 196
        52 162
        7 83
        217 122
        31 183
        155 52
        90 58
        63 166
        129 219
        36 82
        5 57
        99 103
        211 90
        168 201
        93 130
        198 208
        184 135
        66 83
        172 60
        36 88
        227 40
        64 91
        215 226
        204 141
        30 65
        200 17
        59 74
        8 165
        119 214
        180 227
        49 92
        170 39
        48 66
        32 72
        59 116
        102 207
        147 21
        106 221
        168 45
        141 16
        22 107
        218 80
        67 92
        189 154
        87 34
        184 197
        136 113
        136 112
        37 198
        28 107
        111 83
        43 156
        35 167
        193 200
        151 62
        182 146
        195 54
        105 27
        23 191
        164 84
        129 114
        116 218
        108 20
        10 181
        191 49
        198 172
        7 189
        195 105
        189 213
        13 25
        89 44
        227 132
        214 198
        120 89
        183 83
        142 130
        22 57
        188 75
        126 213
        199 115
        211 180
        123 156
        7 38
        33 84
        89 202
        130 126
        138 21
        35 140
        64 65
        51 27
        188 56
        175 140
        121 72
        6 46
        1 34
        134 68
        193 179
        58 84
        51 102
        32 204
        175 218
        18 88
        134 193
        217 148
        88 140
        8 111
        22 213
        201 164
        33 123
        18 160
        105 131
        23 116
        173 128
        185 24
        64 210
        102 56
        81 60
        120 216
        181 79
        81 138
        120 41
        184 158
        19 166
        55 225
        42 126
        37 69
        87 227
        127 164
        192 161
        113 185
        171 138
        26 61
        136 104
        85 65
        223 172
        3 95
        170 17
        177 72
        10 220
        3 63
        43 53
        38 61
        207 66
        209 67
        40 58
        109 4
        42 95
        164 53
        14 55
        132 118
        25 0
        12 113
        19 33
        144 178
        111 24
        217 61
        34 192
        80 118
        179 114
        97 222
        210 200
        128 71
        3 38
        56 110
        42 7
        179 50
        102 101
        104 1
        169 197
        128 49
        2 39
        99 46
        193 39
        70 155
        142 110
        13 115
        217 185
        50 108
        38 24
        51 106
        134 153
        201 40
        144 96
        29 79
        127 187
        5 190
        85 92
        124 192
        221 190
        220 44
        93 159
        12 123
        5 127
        15 53
        67 196
        81 159
        36 205
        153 224
        133 25
        48 54
        177 107
        97 145
        170 6
        63 26
        136 148
        204 75
        90 123
        125 209
        31 189
        129 108
        182 150
        128 135
        3 109
        119 55
        19 222
        163 140
        158 68
        59 49
        202 147
        161 103
        125 62
        223 130
        131 226
        225 72
        224 54
        120 21
        42 207
        163 46
        173 118
        8 28
        215 184
        131 20
        200 100
        99 199
        6 78
        117 162
        55 186
        11 148
        5 144
        196 147
        134 206
        178 177
        151 29
        175 145
        31 177
        14 146
        4 24
        16 109
        212 20
        152 66
        101 16
        191 132
        191 0
        137 30
        169 20
        181 41
        112 167
        169 98
        153 2
        154 57
        199 17
        194 57
        87 52
        14 69
        9 165
        62 135
        188 195
        125 173
        94 157
        77 135
        29 85
        47 157
        37 221
        9 122
        12 166
        175 58
        142 171
        13 103
        28 126
        133 161
        203 167
        226 68
        23 45
        199 203
        108 110
        213 172
        28 183
        116 82
        205 74
        73 4
        """

        self.waters="""
        0.69334 0.33931 0.80278
        0.81834 0.48886 0.97613
        0.0 0.18213 0.98298
        0.30635 0.74824 0.16429
        0.625 0.73035 0.2895
        0.375 0.72499 0.66557
        0.125 0.30809 0.01126
        0.5 0.82655 0.04451
        0.0 0.80005 0.10121
        0.0 0.7227 0.90084
        0.69513 0.08767 0.77582
        0.375 0.59824 0.98555
        0.0 0.60718 0.21654
        0.5 0.42425 0.90145
        0.69513 0.0109 0.58549
        0.69334 0.5463 0.67959
        0.30487 0.78966 0.3751
        0.75 0.33236 0.13405
        0.0 0.52608 0.16566
        0.30667 0.66069 0.30278
        0.375 0.07979 0.31114
        0.5 0.09341 0.8584
        0.18135 0.8158 0.79563
        0.69334 0.42321 0.61173
        0.69366 0.74824 0.16429
        0.5 0.38503 0.80174
        0.30635 0.66801 0.97071
        0.5 0.96676 0.41807
        0.0 0.84869 0.97927
        0.5 0.17345 0.54451
        0.30635 0.33199 0.47071
        0.69366 0.8637 0.87294
        0.0 0.86652 0.61104
        0.18167 0.64351 0.41718
        0.0 0.47833 0.91566
        0.30667 0.4537 0.17959
        0.81834 0.42948 0.28948
        0.5 0.90553 0.60337
        0.5 0.75893 0.08388
        0.82013 0.23159 0.98247
        0.18167 0.48727 0.60113
        0.375 0.07937 0.65084
        0.30635 0.86386 0.08765
        0.69334 0.58725 0.47661
        0.0 0.1368 0.85267
        0.5 0.43691 0.69137
        0.25 0.33236 0.13405
        0.82013 0.76841 0.48247
        0.69513 0.9891 0.08549
        0.81866 0.30772 0.59793
        0.5 0.09447 0.10337
        0.5 0.9066 0.3584
        0.81834 0.57053 0.78948
        0.625 0.60871 0.60044
        0.82013 0.02456 0.1682
        0.82013 0.97545 0.6682
        0.17987 0.97443 0.2932
        0.30635 0.74288 0.79036
        0.18167 0.51115 0.47613
        0.69366 0.33199 0.47071
        0.625 0.92021 0.81114
        0.5 0.71073 0.97098
        0.18135 0.18672 0.6673
        0.18135 0.69228 0.09793
        0.5 0.24911 0.36691
        0.5 0.28927 0.47098
        0.625 0.92063 0.15084
        0.625 0.26965 0.7895
        0.81866 0.1842 0.29563
        0.5 0.9665 0.54307
        0.5 0.50811 0.85443
        0.0 0.27731 0.40084
        0.82013 0.84738 0.67136
        0.69334 0.66069 0.30278
        0.81866 0.31227 0.35404
        0.0 0.8632 0.35267
        0.18167 0.48886 0.97613
        0.81866 0.18672 0.6673
        0.17987 0.23159 0.98247
        0.69366 0.13614 0.58765
        0.30667 0.42321 0.61173
        0.69513 0.98948 0.87581
        0.69334 0.45432 0.39979
        0.69366 0.86386 0.08765
        0.30667 0.58725 0.47661
        0.5 0.24107 0.58388
        0.0 0.05077 0.85573
        0.0 0.5252 0.79066
        0.0 0.4748 0.29066
        0.17987 0.15514 0.79303
        0.0 0.52167 0.41566
        0.30635 0.25712 0.29036
        0.69366 0.25176 0.66429
        0.0 0.01211 0.98073
        0.82013 0.84486 0.29303
        0.18135 0.81328 0.1673
        0.75 0.66764 0.63405
        0.5 0.57576 0.40145
        0.5 0.17426 0.41447
        0.375 0.3913 0.10044
        0.375 0.27501 0.16557
        0.17987 0.84486 0.29303
        0.30487 0.91233 0.27582
        0.30667 0.41275 0.97661
        0.81834 0.51273 0.10113
        0.69513 0.01052 0.37581
        0.5 0.83194 0.42042
        0.0 0.80337 0.85958
        0.30487 0.0881 0.18611
        0.375 0.73035 0.2895
        0.17987 0.02456 0.1682
        0.81866 0.81328 0.1673
        0.5 0.56309 0.19137
        0.81834 0.63586 0.1773
        0.30487 0.20846 0.08811
        0.69334 0.41275 0.97661
        0.625 0.40176 0.48555
        0.125 0.64281 0.75856
        0.18167 0.36414 0.6773
        0.0 0.95051 0.60573
        0.30487 0.08767 0.77582
        0.69513 0.79154 0.58811
        0.81866 0.68773 0.85404
        0.0 0.60497 0.37134
        0.81834 0.3565 0.91718
        0.30635 0.25176 0.66429
        0.18135 0.88857 0.98003
        0.25 0.66764 0.63405
        0.0 0.27999 0.5578
        0.17987 0.15263 0.17136
        0.17987 0.97028 0.98076
        0.625 0.07979 0.31114
        0.0 0.39283 0.71654
        0.30667 0.33931 0.80278
        0.82013 0.15263 0.17136
        0.0 0.19996 0.60121
        0.69334 0.57679 0.11173
        0.18135 0.31227 0.35404
        0.5 0.03324 0.91807
        0.30667 0.57679 0.11173
        0.18167 0.42948 0.28948
        0.17987 0.76841 0.48247
        0.30487 0.9891 0.08549
        0.18167 0.57053 0.78948
        0.625 0.72499 0.66557
        0.5 0.4919 0.35443
        0.82013 0.02972 0.48076
        0.5 0.16807 0.92042
        0.625 0.59824 0.98555
        0.875 0.69191 0.51126
        0.17987 0.02972 0.48076
        0.30635 0.13614 0.58765
        0.69513 0.91233 0.27582
        0.0 0.13348 0.11104
        0.5 0.7509 0.86691
        0.69334 0.54568 0.89979
        0.81834 0.64351 0.41718
        0.69513 0.78966 0.3751
        0.0 0.19664 0.35958
        0.82013 0.97028 0.98076
        0.18167 0.51273 0.10113
        0.18167 0.3565 0.91718
        0.875 0.64281 0.75856
        0.125 0.3572 0.25856
        0.375 0.60871 0.60044
        0.0 0.72002 0.0578
        0.18167 0.63586 0.1773
        0.5 0.48908 0.22943
        0.5 0.51093 0.72943
        0.30635 0.13631 0.37294
        0.875 0.30809 0.01126
        0.5 0.0335 0.04307
        0.375 0.92021 0.81114
        0.18135 0.30772 0.59793
        0.30667 0.54568 0.89979
        0.30667 0.45432 0.39979
        0.30487 0.0109 0.58549
        0.81866 0.8158 0.79563
        0.69366 0.74288 0.79036
        0.5 0.16887 0.04039
        0.81834 0.48727 0.60113
        0.625 0.07937 0.65084
        0.0 0.9879 0.48073
        0.81866 0.88857 0.98003
        0.0 0.15131 0.47927
        0.81866 0.69228 0.09793
        0.82013 0.02558 0.7932
        0.125 0.69191 0.51126
        0.0 0.94923 0.35573
        0.5 0.82575 0.91447
        0.30487 0.79154 0.58811
        0.81834 0.36414 0.6773
        0.0 0.39503 0.87134
        0.69513 0.20846 0.08811
        0.18135 0.68773 0.85404
        0.82013 0.97443 0.2932
        0.69513 0.21034 0.8751
        0.18135 0.11143 0.48003
        0.30487 0.9119 0.68611
        0.625 0.3913 0.10044
        0.625 0.27501 0.16557
        0.30667 0.5463 0.67959
        0.30487 0.21034 0.8751
        0.69334 0.4537 0.17959
        0.0 0.81788 0.48298
        0.875 0.3572 0.25856
        0.69513 0.0881 0.18611
        0.375 0.92063 0.15084
        0.17987 0.84738 0.67136
        0.375 0.26965 0.7895
        0.69366 0.25712 0.29036
        0.81834 0.51115 0.47613
        0.30487 0.01052 0.37581
        0.30635 0.8637 0.87294
        0.17987 0.97545 0.6682
        0.81866 0.11143 0.48003
        0.17987 0.02558 0.7932
        0.69366 0.66801 0.97071
        0.375 0.40176 0.48555
        0.18135 0.1842 0.29563
        0.82013 0.15514 0.79303
        0.5 0.83113 0.54039
        0.5 0.61497 0.30174
        0.30487 0.98948 0.87581
        0.0 0.04949 0.10573
        0.69513 0.9119 0.68611
        0.69366 0.13631 0.37294
        0.0 0.47392 0.66566
        """

        self.coord= "relative"

        self.cages="""
        12 -0.5 -0.06704 0.98069
        12 -0.22538 -0.22657 0.97766
        15 0.0 -0.07477 0.81154
        15 -0.5 -0.70188 0.97852
        12 0.22538 -0.22657 0.97766
        16 0.0 -0.39745 0.97658
        14 0.0 -0.40626 0.59577
        12 0.5 0.66249 0.13817
        12 0.22666 0.54775 0.29514
        15 0.5 0.36644 0.29044
        15 -0.5 -0.36644 0.79044
        12 0.5 0.17684 0.22187
        12 0.5 0.06704 0.48069
        14 0.0 0.40626 0.09577
        12 -0.5 -0.17362 1.24201
        15 0.0 0.07733 0.65023
        14 0.0 -0.25863 0.67146
        15 0.0 0.07477 0.31154
        12 -0.22666 0.54775 1.29514
        15 0.0 -0.07733 1.15023
        16 0.0 0.39745 0.47658
        12 0.22538 0.22657 0.47766
        14 0.21949 0.10026 0.98058
        14 -0.21949 -0.10026 1.48058
        12 -0.22538 0.22657 1.47766
        12 0.5 0.49436 0.03701
        12 -0.22666 -0.54775 0.79514
        12 0.5 0.00052 0.23044
        12 0.5 0.17362 0.74201
        14 0.0 0.25863 0.17146
        14 0.21949 -0.10026 1.48058
        16 0.0 0.73065 0.2993
        14 -0.21949 0.10026 1.98058
        12 -0.5 -0.00052 0.73044
        12 -0.5 -0.49436 0.53701
        12 0.22666 -0.54775 0.79514
        12 -0.5 -0.17684 0.72187
        15 0.5 0.70188 0.47852
        16 0.0 -0.73065 0.7993
        12 -0.5 -0.66249 0.63817
        """

        self.bondlen = 3


        self.cell = """
        13.866929922957336 39.99330243650723 23.004205623408165
        """

        self.density = 0.5341851021344506



        self.cell = cellvectors(a=13.866929922957336,
                           b=39.99330243650723,
                           c=23.004205623408165)
