# coding: utf-8
"""
Cage composition:
 (12,14,15,16) = (28,16,8,8,)
"""

desc={"ref": {"SpaceFullerene": 'Sikiric 2010'},
      "usage": "No options available.",
      "brief": "A space fullerene."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.pairs="""
        185 164
        232 43
        70 26
        8 18
        327 280
        314 230
        273 116
        307 7
        197 81
        27 281
        71 244
        46 146
        20 298
        7 38
        188 113
        265 193
        58 33
        6 251
        331 208
        289 20
        265 293
        244 85
        93 242
        302 267
        187 159
        335 212
        277 140
        18 337
        248 40
        67 135
        120 75
        77 198
        69 7
        227 23
        5 129
        246 60
        8 44
        105 214
        73 78
        235 201
        41 81
        37 306
        159 272
        268 72
        153 25
        311 40
        285 129
        228 338
        214 198
        170 39
        222 188
        178 69
        179 20
        110 155
        335 158
        330 290
        64 182
        202 261
        120 229
        266 240
        99 338
        130 150
        84 178
        77 134
        87 275
        127 35
        309 319
        185 266
        340 313
        123 287
        97 54
        138 274
        234 332
        293 143
        14 263
        57 288
        316 50
        235 195
        209 279
        19 245
        276 137
        209 133
        327 259
        150 81
        163 83
        156 256
        310 121
        197 15
        215 332
        236 1
        136 173
        68 194
        185 58
        270 106
        116 2
        233 61
        235 64
        180 112
        18 39
        103 306
        119 289
        154 48
        155 146
        67 10
        296 204
        126 100
        109 90
        236 276
        253 171
        96 203
        127 96
        303 102
        105 149
        100 240
        102 87
        201 291
        98 65
        41 139
        209 267
        327 204
        98 147
        100 181
        323 267
        136 271
        172 76
        86 169
        119 308
        94 36
        216 145
        134 223
        58 264
        337 17
        107 343
        305 173
        237 225
        238 307
        277 287
        192 329
        186 174
        96 84
        301 245
        110 208
        97 271
        283 148
        314 13
        279 141
        114 171
        264 195
        163 194
        302 45
        102 194
        222 149
        320 286
        324 67
        182 199
        144 23
        277 53
        175 37
        315 165
        250 333
        108 5
        198 154
        118 149
        109 260
        113 134
        25 166
        6 342
        326 275
        341 36
        261 229
        246 148
        9 218
        300 181
        258 305
        325 10
        27 330
        160 286
        323 99
        67 213
        50 339
        270 74
        98 141
        193 12
        331 31
        161 72
        340 290
        10 161
        235 71
        98 66
        65 267
        178 52
        185 339
        338 224
        168 318
        92 63
        48 52
        196 288
        54 311
        272 38
        218 239
        62 181
        216 213
        260 59
        220 45
        4 167
        41 225
        314 148
        104 0
        47 180
        183 139
        341 328
        124 52
        274 115
        27 0
        232 272
        205 270
        319 56
        308 317
        321 129
        183 245
        336 292
        272 96
        210 86
        231 243
        310 292
        221 298
        260 203
        325 263
        254 35
        93 153
        278 43
        42 161
        61 124
        92 91
        6 225
        266 129
        94 295
        189 207
        21 3
        157 78
        250 187
        62 280
        89 158
        93 145
        63 303
        211 207
        117 120
        90 1
        265 200
        315 199
        234 331
        310 88
        246 240
        300 151
        190 321
        311 209
        47 71
        335 211
        50 53
        176 262
        289 85
        30 132
        231 334
        101 187
        309 303
        292 1
        95 84
        166 174
        192 200
        77 162
        47 308
        304 322
        301 41
        236 30
        131 19
        153 299
        160 168
        49 288
        110 12
        4 326
        234 293
        59 1
        32 328
        321 128
        296 139
        296 140
        147 177
        228 141
        151 60
        118 61
        193 3
        273 244
        32 318
        309 21
        294 3
        191 34
        111 128
        92 313
        32 286
        13 116
        326 194
        253 57
        322 8
        24 223
        118 320
        290 37
        317 75
        222 152
        123 80
        70 66
        188 320
        297 125
        105 24
        304 114
        104 319
        186 325
        189 89
        232 137
        276 324
        247 16
        301 251
        342 15
        200 294
        58 111
        256 38
        90 35
        125 42
        168 40
        51 284
        18 253
        304 57
        25 216
        297 213
        292 101
        299 268
        14 79
        232 254
        6 252
        109 84
        157 79
        252 114
        329 12
        233 238
        155 293
        182 205
        287 280
        59 88
        313 112
        54 212
        39 78
        94 158
        99 262
        230 2
        206 180
        184 14
        171 44
        222 223
        201 298
        285 247
        156 249
        192 167
        225 204
        254 187
        323 177
        211 295
        167 68
        79 196
        199 74
        263 166
        301 130
        193 275
        285 13
        335 271
        215 31
        63 290
        131 217
        22 295
        132 10
        248 66
        117 330
        23 343
        269 322
        324 145
        321 316
        170 44
        53 76
        107 234
        64 179
        314 5
        249 333
        224 279
        21 87
        24 162
        269 39
        126 280
        231 107
        183 217
        260 135
        205 175
        206 175
        144 210
        142 49
        284 274
        266 283
        313 29
        104 83
        328 223
        243 146
        247 274
        268 288
        189 286
        127 7
        48 256
        307 333
        175 20
        56 91
        332 169
        328 295
        111 284
        111 285
        184 30
        273 16
        95 48
        36 214
        269 17
        121 297
        115 2
        226 78
        302 40
        79 72
        233 154
        186 72
        29 229
        114 226
        45 11
        71 55
        148 138
        46 208
        33 165
        324 42
        310 254
        106 37
        312 202
        311 218
        195 16
        152 32
        123 259
        281 21
        11 271
        241 147
        342 150
        130 259
        190 151
        47 205
        51 164
        226 17
        152 158
        340 206
        5 51
        255 203
        118 22
        162 249
        12 31
        309 229
        214 238
        332 200
        136 82
        109 43
        170 237
        128 339
        337 252
        291 16
        303 0
        329 169
        336 43
        278 101
        296 62
        191 125
        191 216
        302 70
        160 173
        122 237
        176 219
        77 61
        179 244
        289 306
        237 259
        103 330
        57 17
        115 291
        168 212
        144 331
        220 65
        49 34
        242 268
        242 34
        312 117
        238 256
        341 320
        281 83
        103 29
        97 220
        282 45
        265 4
        190 217
        144 155
        54 26
        97 66
        0 68
        239 133
        182 55
        305 212
        191 132
        116 55
        76 139
        82 248
        88 137
        336 135
        204 15
        243 143
        121 255
        269 130
        95 278
        176 46
        228 239
        184 161
        300 51
        80 19
        131 287
        278 38
        215 275
        226 196
        160 11
        126 53
        153 157
        90 69
        262 239
        151 172
        180 85
        73 44
        334 219
        56 28
        327 245
        211 318
        100 339
        92 312
        195 165
        283 264
        31 167
        227 133
        263 213
        22 134
        323 227
        122 80
        122 81
        136 152
        138 33
        312 317
        108 246
        89 113
        55 165
        340 120
        137 203
        24 154
        119 202
        236 255
        197 76
        221 74
        163 329
        322 251
        261 106
        83 91
        106 75
        124 307
        304 73
        174 299
        110 86
        242 42
        9 248
        315 115
        233 341
        299 73
        282 26
        89 305
        183 126
        262 65
        337 150
        277 15
        189 22
        131 172
        325 34
        107 46
        198 333
        104 192
        4 210
        102 91
        112 306
        142 253
        186 142
        210 143
        135 121
        95 250
        163 3
        30 145
        308 298
        23 334
        283 247
        174 171
        342 123
        281 29
        179 291
        336 276
        127 250
        159 249
        117 56
        125 88
        101 69
        94 149
        257 215
        9 282
        190 240
        36 113
        319 294
        14 93
        112 317
        219 133
        147 176
        231 86
        221 75
        258 282
        343 99
        87 28
        103 202
        82 258
        13 33
        60 164
        258 207
        255 35
        124 156
        162 52
        140 217
        9 141
        326 169
        49 25
        220 218
        197 19
        241 146
        27 28
        334 208
        188 173
        62 172
        11 207
        178 159
        257 68
        284 230
        8 122
        142 157
        119 270
        64 2
        224 177
        343 143
        300 128
        59 132
        199 201
        251 80
        108 316
        166 196
        228 241
        257 294
        184 297
        219 224
        138 164
        241 227
        74 85
        264 230
        26 279
        105 156
        108 181
        70 177
        63 261
        316 140
        170 252
        338 243
        82 318
        257 28
        50 60
        221 206
        315 273
        """

        self.waters="""
        0.78877 0.88488 0.97572
        0.53104 0.79519 0.52724
        0.87941 0.79176 0.14072
        0.12115 0.55242 0.95202
        0.62458 0.67593 0.91489
        0.91808 0.62226 0.20212
        0.88116 0.45841 0.33501
        0.70183 0.00275 0.58511
        0.20825 0.87059 0.35928
        0.2886 0.58463 0.77715
        0.20465 0.74946 0.47582
        0.45956 0.88309 0.73796
        0.99725 0.29817 0.91489
        0.79817 0.50275 0.16489
        0.74494 0.20416 0.45212
        0.62774 0.58192 0.29789
        0.21429 0.20693 0.14057
        0.5 0.32781 0.375
        0.41795 0.74559 0.3697
        0.25507 0.95416 0.29788
        0.04817 0.99725 0.08511
        0.20481 0.46897 0.97276
        0.41465 0.71021 0.67904
        0.79176 0.87941 0.85928
        0.12059 0.45825 0.64072
        0.66654 0.66023 0.43765
        0.71123 0.38488 0.77428
        0.99918 0.04702 0.98786
        0.2114 0.08463 0.97286
        0.04044 0.38309 0.01204
        0.61691 0.95956 0.48796
        0.99725 0.04817 0.91489
        0.94759 0.62115 0.70202
        0.54817 0.50275 0.16489
        0.24494 0.45416 0.45212
        0.58192 0.12226 0.54789
        0.82407 0.12458 0.66489
        0.80242 0.87115 0.04798
        0.95183 0.00275 0.58511
        0.58312 0.91071 0.36955
        0.86691 0.79044 0.76204
        0.1683 0.49511 0.31251
        0.21123 0.11512 0.47572
        0.08192 0.87226 0.54789
        0.0 0.82781 0.375
        0.50083 0.79702 0.76214
        0.20693 0.21429 0.85943
        0.67593 0.37458 0.08511
        0.03571 0.70693 0.60943
        0.41246 0.53689 0.42905
        0.54702 0.50083 0.23786
        0.04584 0.74494 0.20212
        0.28571 0.70693 0.60943
        0.49918 0.45299 0.26214
        0.8735 0.17478 0.76214
        0.67219 0.5 0.125
        0.38309 0.04044 0.98796
        0.29176 0.37059 0.39072
        0.58535 0.28979 0.17904
        0.32523 0.6235 0.51214
        0.38488 0.71123 0.22572
        0.53571 0.79308 0.64057
        0.8765 0.82523 0.26214
        0.67478 0.6265 0.01214
        0.75441 0.91795 0.1197
        0.37885 0.05242 0.79798
        0.07732 0.37831 0.77418
        0.00083 0.70299 0.48786
        0.87115 0.80242 0.95202
        0.53031 0.79638 0.57106
        0.83097 0.50446 0.78335
        0.71429 0.29308 0.10943
        0.33171 0.99511 0.43749
        0.95693 0.03571 0.39057
        0.2916 0.63116 0.08501
        0.41808 0.87774 0.04789
        0.28877 0.61512 0.27428
        0.53571 0.54308 0.64057
        0.70693 0.03571 0.39057
        0.57763 0.12177 0.42889
        0.08754 0.03689 0.32096
        0.28845 0.61519 0.32121
        0.20299 0.49918 0.73786
        0.79536 0.25055 0.97582
        0.12177 0.57763 0.57111
        0.0416 0.38116 0.08501
        0.70825 0.37941 0.89072
        0.33508 0.33854 0.96368
        0.32523 0.3735 0.51214
        0.69759 0.37115 0.70202
        0.44759 0.87885 0.54798
        0.63309 0.29044 0.98796
        0.67478 0.3765 0.01214
        0.87226 0.08192 0.45212
        0.03689 0.08754 0.67905
        0.95841 0.61884 0.58501
        0.99511 0.33171 0.56251
        0.1235 0.17478 0.76214
        0.24494 0.29584 0.79788
        0.50275 0.79817 0.83511
        0.54044 0.11691 0.23796
        0.66023 0.66654 0.56236
        0.58873 0.46239 0.97286
        0.08463 0.2114 0.02715
        0.66903 0.00446 0.96665
        0.12059 0.20825 0.64072
        0.54584 0.75507 0.04788
        0.41688 0.08929 0.86955
        0.75055 0.70465 0.22582
        0.20416 0.74494 0.54788
        0.95825 0.37941 0.89072
        0.83977 0.16654 0.18765
        0.79584 0.25507 0.04788
        0.61519 0.28845 0.67879
        0.91688 0.41071 0.38045
        0.12941 0.79176 0.14072
        0.87941 0.54176 0.14072
        0.29702 0.99918 0.01214
        0.45841 0.88116 0.66499
        0.33977 0.33347 0.06236
        0.25055 0.79536 0.02418
        0.70956 0.36691 0.51204
        0.12458 0.82407 0.33511
        0.83347 0.16023 0.31236
        0.41071 0.91688 0.61955
        0.3735 0.32523 0.48786
        0.49918 0.20299 0.26214
        0.74953 0.20496 0.57111
        0.83854 0.16492 0.21368
        0.05242 0.37885 0.20202
        0.49725 0.20183 0.33511
        0.08873 0.03761 0.27714
        0.36691 0.70956 0.48796
        0.91246 0.96311 0.82096
        0.45183 0.49725 0.66489
        0.95956 0.61691 0.51204
        0.24946 0.29536 0.72582
        0.11512 0.21123 0.52428
        0.38481 0.71155 0.17879
        0.16903 0.49555 0.28335
        0.88309 0.45956 0.26204
        0.37226 0.41808 0.79789
        0.36884 0.70841 0.41499
        0.5 0.67219 0.875
        0.91795 0.75441 0.8803
        0.7886 0.91537 0.47286
        0.20693 0.46429 0.85943
        0.07763 0.37823 0.82111
        0.50489 0.83171 0.18749
        0.20841 0.13116 0.66499
        0.49725 0.45183 0.33511
        0.17478 0.8735 0.23786
        0.08192 0.37774 0.70212
        0.78979 0.91465 0.42904
        0.91071 0.58312 0.63045
        0.08312 0.58929 0.88045
        0.24559 0.08205 0.6197
        0.61884 0.95841 0.41499
        0.95416 0.25507 0.70212
        0.32407 0.37543 0.58511
        0.6217 0.92268 0.72582
        0.33097 0.99555 0.46665
        0.32781 0.5 0.625
        0.87774 0.41808 0.95212
        0.30242 0.62885 0.20202
        0.46429 0.45693 0.14057
        0.79638 0.53031 0.42895
        0.78845 0.88481 0.92879
        0.82523 0.8765 0.73786
        0.63116 0.2916 0.91499
        0.79308 0.78571 0.35943
        0.04176 0.62059 0.39072
        0.1265 0.82523 0.26214
        0.49555 0.16903 0.71665
        0.00275 0.70183 0.41489
        0.88481 0.78845 0.07121
        0.12543 0.17593 0.83511
        0.83171 0.50489 0.81251
        0.32407 0.62543 0.58511
        0.96429 0.04308 0.10943
        0.87823 0.42237 0.07111
        0.79044 0.86691 0.23796
        0.62941 0.70825 0.10928
        0.29536 0.24946 0.27418
        0.57732 0.1217 0.47582
        0.41808 0.37226 0.20212
        0.20496 0.74953 0.42889
        0.53689 0.41246 0.57096
        0.49511 0.1683 0.68749
        0.58192 0.62774 0.70212
        0.17478 0.1235 0.23786
        0.41127 0.53761 0.47286
        0.6683 0.00489 0.93749
        0.20362 0.46969 0.92895
        0.75507 0.54584 0.95212
        0.46429 0.20693 0.14057
        0.62543 0.32407 0.41489
        0.37115 0.69759 0.29798
        0.74559 0.41795 0.6303
        0.37941 0.70825 0.10928
        0.42237 0.87823 0.92889
        0.37941 0.95825 0.10928
        0.33854 0.33508 0.03632
        0.99555 0.33097 0.53335
        0.75507 0.70416 0.29788
        0.67593 0.62458 0.08511
        0.00489 0.6683 0.06251
        0.41537 0.7114 0.72286
        0.0 0.17219 0.875
        0.74494 0.04584 0.79788
        0.70825 0.62941 0.89072
        0.16146 0.83508 0.71368
        0.82523 0.1265 0.73786
        0.79519 0.53104 0.47276
        0.87059 0.20825 0.64072
        0.21021 0.08535 0.92904
        0.66492 0.66146 0.46368
        0.13309 0.20956 0.26204
        0.16492 0.83854 0.78632
        0.87543 0.17593 0.83511
        0.29519 0.96897 0.77724
        0.25047 0.79504 0.07111
        0.24953 0.29504 0.67889
        0.20183 0.49725 0.66489
        0.71155 0.38481 0.82121
        0.92237 0.62177 0.32111
        0.70693 0.28571 0.39057
        0.86884 0.7916 0.83501
        0.28979 0.58535 0.82096
        0.29044 0.63309 0.01204
        0.7916 0.86884 0.16499
        0.58205 0.25441 0.8697
        0.19759 0.12885 0.54798
        0.78571 0.79308 0.64057
        0.29308 0.96429 0.89057
        0.58929 0.08312 0.11955
        0.70299 0.00083 0.51214
        0.87458 0.82407 0.33511
        0.82781 0.0 0.625
        0.16654 0.83977 0.81236
        0.37831 0.07732 0.22582
        0.11884 0.5416 0.83501
        0.12885 0.19759 0.45202
        0.45693 0.46429 0.85943
        0.96429 0.29308 0.10943
        0.37774 0.08192 0.29789
        0.50446 0.83097 0.21665
        0.17593 0.12543 0.16489
        0.11691 0.54044 0.76204
        0.37059 0.29176 0.60928
        0.70841 0.36884 0.58501
        0.13116 0.20841 0.33501
        0.79308 0.53571 0.35943
        0.29176 0.62059 0.39072
        0.45416 0.24494 0.54788
        0.74946 0.20465 0.52418
        0.03571 0.95693 0.60943
        0.12774 0.91808 0.95212
        0.45299 0.49918 0.73786
        0.70362 0.03031 0.32106
        0.1217 0.57732 0.52418
        0.46239 0.58873 0.02714
        0.29638 0.96969 0.82106
        0.87885 0.44759 0.45202
        0.5416 0.11884 0.16499
        0.37458 0.67593 0.91489
        0.29584 0.24494 0.20212
        0.62226 0.91808 0.79789
        0.21155 0.11519 0.42879
        0.45825 0.12059 0.35928
        0.46311 0.58754 0.07096
        0.20956 0.13309 0.73796
        0.11519 0.21155 0.57121
        0.08929 0.41688 0.13045
        0.17593 0.87543 0.16489
        0.33347 0.33977 0.93765
        0.95299 0.00083 0.51214
        0.7114 0.41537 0.27715
        0.91465 0.78979 0.57096
        0.62885 0.30242 0.79798
        0.70481 0.03104 0.27724
        0.99918 0.29702 0.98786
        0.50083 0.54702 0.76214
        0.37823 0.07763 0.17889
        0.96311 0.91246 0.17905
        0.96969 0.29638 0.17895
        0.70416 0.75507 0.70212
        0.83508 0.16146 0.28632
        0.37543 0.32407 0.41489
        0.08535 0.21021 0.07096
        0.88488 0.78877 0.02428
        0.17219 0.0 0.125
        0.66146 0.66492 0.53632
        0.29308 0.71429 0.89057
        0.25507 0.79584 0.95212
        0.16023 0.83347 0.68765
        0.92268 0.6217 0.27418
        0.6235 0.32523 0.48786
        0.29817 0.99725 0.08511
        0.00275 0.95183 0.41489
        0.96239 0.91127 0.22286
        0.29504 0.24953 0.32111
        0.70465 0.75055 0.77418
        0.6265 0.67478 0.98786
        0.08205 0.24559 0.3803
        0.61512 0.28877 0.72572
        0.91808 0.12774 0.04789
        0.62059 0.04176 0.60928
        0.46969 0.20362 0.07106
        0.3765 0.67478 0.98786
        0.53761 0.41127 0.52714
        0.91127 0.96239 0.77714
        0.46897 0.20481 0.02724
        0.87831 0.42268 0.02418
        0.75047 0.70496 0.17889
        0.25441 0.58205 0.1303
        0.79702 0.50083 0.23786
        0.55242 0.12115 0.04798
        0.03104 0.70481 0.72276
        0.42268 0.87831 0.97582
        0.62177 0.92237 0.67889
        0.96897 0.29519 0.22276
        0.20825 0.12059 0.35928
        0.70496 0.75047 0.82111
        0.00083 0.95299 0.48786
        0.12226 0.58192 0.45212
        0.58754 0.46311 0.92905
        0.62115 0.94759 0.29798
        0.03031 0.70362 0.67895
        0.79504 0.25047 0.92889
        0.04702 0.99918 0.01214
        0.04308 0.96429 0.89057
        0.38116 0.0416 0.91499
        0.62059 0.29176 0.60928
        0.79176 0.12941 0.85928
        0.03761 0.08873 0.72286
        0.91537 0.7886 0.52715
        0.54308 0.53571 0.35943
        0.50275 0.54817 0.83511
        0.58463 0.2886 0.22286
        0.00446 0.66903 0.03335
        0.82407 0.87458 0.66489
        0.71021 0.41465 0.32096
        0.54176 0.87941 0.85928
        """

        self.coord= "relative"

        self.cages="""
        16 0.17286 0.4993 0.23814
        16 0.82714 0.5007 0.73814
        16 0.0007 0.67286 0.98814
        16 0.32714 0.9993 0.51186
        16 0.9993 0.32714 0.48814
        16 0.67286 0.0007 0.01186
        16 0.4993 0.17286 0.76186
        16 0.5007 0.82714 0.26186
        15 0.17084 0.49761 0.16704
        15 0.82916 0.50239 0.66704
        15 0.00239 0.67084 0.91704
        15 0.32916 0.99761 0.58296
        15 0.99761 0.32916 0.41704
        15 0.67084 0.00239 0.08296
        15 0.49761 0.17084 0.83296
        15 0.50239 0.82916 0.33296
        14 0.16991 0.49757 0.35477
        14 0.83009 0.50243 0.85477
        14 0.00243 0.66991 0.10477
        14 0.33009 0.99757 0.39523
        14 0.99757 0.33009 0.60477
        14 0.66991 0.00243 0.89523
        14 0.49757 0.16991 0.64523
        14 0.50243 0.83009 0.14523
        12 0.02176 0.34884 0.29816
        12 0.97824 0.65116 0.79816
        12 0.15116 0.52176 0.04816
        12 0.47824 0.84884 0.45184
        12 0.84884 0.47824 0.54816
        12 0.52176 0.15116 0.95184
        12 0.34884 0.02176 0.70184
        12 0.65116 0.97824 0.20184
        14 0.34195 0.33059 0.10415
        14 0.65805 0.66941 0.60415
        14 0.16941 0.84195 0.85415
        14 0.15805 0.83059 0.64585
        14 0.83059 0.15805 0.35415
        14 0.84195 0.16941 0.14585
        14 0.33059 0.34195 0.89585
        14 0.66941 0.65805 0.39585
        12 0.33704 0.33704 0.0
        12 0.66296 0.66296 0.5
        12 0.16296 0.83704 0.75
        12 0.83704 0.16296 0.25
        12 0.1885 0.00459 0.20145
        12 0.8115 0.99541 0.70145
        12 0.49541 0.6885 0.95145
        12 0.3115 0.50459 0.54855
        12 0.50459 0.3115 0.45145
        12 0.6885 0.49541 0.04855
        12 0.00459 0.1885 0.79855
        12 0.99541 0.8115 0.29855
        12 0.4861 0.32254 0.29856
        12 0.5139 0.67746 0.79856
        12 0.17746 0.9861 0.04856
        12 0.0139 0.82254 0.45144
        12 0.82254 0.0139 0.54856
        12 0.9861 0.17746 0.95144
        12 0.32254 0.4861 0.70144
        12 0.67746 0.5139 0.20144
        """

        self.bondlen = 3


        self.cell = """
        15.637205533572008 0.0 0.0
        9.57502685214912e-16 15.637205533572008 0.0
        1.0456453644263025e-14 1.0456453644263025e-14 170.76684725005143
        """

        #self.density = 0.24624552511509332



        self.cell = cellvectors(a=15.637205533572008,
                           b=15.637205533572008,
                           c=170.76684725005143)
