# coding: utf-8
"""
[Z] Frank, F.C., and JS Kasper. “Complex Alloy Structures Regarded as Sphere Packings. II. Analysis and Classification of Representative Structures.” Acta Crystallographica 12.7 (1959): 483–499.
[sIV] Jeffrey, G A. “Hydrate Inclusion Compounds.” Inclusion Compounds 1 (1984): 135–190.
[HS1] Kosyakov, Viktor I, and T M Polyanskaya. “Using Structural Data for Estimating the Stability of Water Networks in Clathrate and Semiclathrate Hydrates.” Journal of Structural Chemistry 40.2 (1999): 239–245.
"""

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.density = 0.8     #default self.density


        self.bondlen = 3      #bond threshold

        self.coord = "absolute"


        self.cell="""
        20.0715 11.588333333 11.754333333
        """

        self.waters="""
        -8.67219264749 8.15592694143 5.8771666665
        1.3635573525 9.22657305807 5.8771666665
        -7.9642708425 9.38220437473 8.14751614977
        -10.03575 8.52785449975 0.0
        -15.9284413275 11.5883912747 8.14751614977
        -3.83526222 9.37403459973 9.66852688306
        2.0714791575 3.58803770823 8.14751614977
        -2.0714791575 3.58803770823 8.14751614977
        -5.89269132751 5.79422460817 8.14751614977
        -8.67219264749 15.0207397246 5.8771666665
        -3.83526222 2.21429873327 2.08580644994
        -3.83526222 9.37403459973 2.08580644994
        -6.20048778 3.57986793323 2.08580644994
        -13.381066905 11.588333333 4.5493971732
        6.20048778 3.57986793323 9.66852688306
        0.0 4.42859746654 9.66852688306
        -2.0714791575 8.00029562477 8.14751614977
        -17.704066575 10.2214894164 0.0
        -3.83526222 2.21429873327 9.66852688306
        -10.03575 14.6488121662 0.0
        -11.3993073525 8.15592694143 5.8771666665
        -7.308635295 5.7941666665 5.8771666665
        -2.0714791575 3.58803770823 3.60681718323
        -12.1072291575 13.7944622913 8.14751614977
        -6.20048778 3.57986793323 9.66852688306
        7.66831657499 4.42732274987 0.0
        2.0714791575 8.00029562477 3.60681718323
        -7.66831657499 7.16101058313 0.0
        3.34531690501 5.7941666665 7.2049361598
        -7.964170485 9.38214643306 3.60681718323
        3.34531690501 5.7941666665 4.5493971732
        -12.107329515 13.7945202329 3.60681718323
        -11.3993073525 15.0207397246 5.8771666665
        7.308635295 5.7941666665 5.8771666665
        -2.367433425 10.2214894164 0.0
        -16.23623778 9.37403459973 2.08580644994
        -2.727114705 11.588333333 5.8771666665
        0.0 7.15973586646 9.66852688306
        -7.9642708425 13.7944622913 3.60681718323
        0.0 2.73368783325 0.0
        -13.381066905 11.588333333 7.2049361598
        -10.03575 10.222764133 9.66852688306
        -1.3635573525 9.22657305807 5.8771666665
        -6.20048778 8.00846539977 9.66852688306
        -1.3635573525 2.36176027493 5.8771666665
        -6.69043309499 11.588333333 4.5493971732
        0.0 4.42859746654 2.08580644994
        -13.87101222 8.00846539977 2.08580644994
        5.89269132751 5.79410872483 8.14751614977
        -7.9642708425 13.7944622913 8.14751614977
        -15.9284413275 11.5882753913 3.60681718323
        -2.071579515 8.00035356644 3.60681718323
        5.89269132751 5.79422460817 3.60681718323
        6.20048778 3.57986793323 2.08580644994
        -16.23623778 9.37403459973 9.66852688306
        1.3635573525 2.36176027493 5.8771666665
        -2.367433425 1.36684391663 0.0
        -6.20048778 8.00846539977 2.08580644994
        2.367433425 1.36684391663 0.0
        -4.14305867249 11.5883912747 3.60681718323
        -10.03575 12.953902533 2.08580644994
        -10.03575 10.222764133 2.08580644994
        2.0714791575 8.00029562477 8.14751614977
        0.0 8.85464549975 0.0
        -3.34531690501 5.7941666665 4.5493971732
        -10.03575 12.953902533 9.66852688306
        -3.34531690501 5.7941666665 7.2049361598
        -13.87101222 8.00846539977 9.66852688306
        -6.69043309499 11.588333333 7.2049361598
        -17.344385295 11.588333333 5.8771666665
        -7.66831657499 4.42732274987 0.0
        2.071579515 3.58797976656 3.60681718323
        3.83526222 2.21429873327 2.08580644994
        -12.1072291575 9.38220437473 8.14751614977
        3.83526222 2.21429873327 9.66852688306
        -12.403183425 7.16101058313 0.0
        -12.1072291575 9.38220437473 3.60681718323
        0.0 7.15973586646 2.08580644994
        -4.14305867249 11.5882753913 8.14751614977
        -5.89269132751 5.79410872483 3.60681718323
        """


        self.cages = """
        12    0.5000    0.0000    0.5000
        12    0.2500    0.7500    0.5000
        12    0.7500    0.7500    0.5000
        12    0.7500    0.2500    0.5000
        12    1.0000    0.5000    0.5000
        12    0.2500    0.2500    0.5000
        14    0.0000    1.0000    0.2461
        14    0.5000    0.5000    0.2461
        14    0.0000    1.0000    0.7539
        14    0.5000    0.5000    0.7539
        15    0.1667    0.5000    1.0000
        15    0.3333    0.0000    1.0000
        15    0.8333    0.5000    1.0000
        15    0.6667    0.0000    1.0000
        """

        self.cell = cellvectors(a=20.0715,
                           b=11.588333333,
                           c=11.754333333)
