# coding: utf-8
desc={"ref": {"CRN": 'Mousseau 2001'},
      "usage": "No options available.",
      "brief": "A continuous random network of Sillium."
      }

import genice2.lattices
from genice2.cell import cellvectors

class Lattice(genice2.lattices.Lattice):
    def __init__(self):
        self.cell="""
        43.274 43.274 43.274
        """
        self.density=0.96
        self.coord="absolute"
        self.waters="""
        1.3 20.49 19.52
        -7.38 5.07 -18.07
        7.43 2.0 21.28
        -0.9 2.58 -10.23
        -6.25 -5.76 -20.64
        12.09 -14.84 20.42
        5.72 -15.54 -4.46
        19.28 12.59 -10.94
        -7.3 18.27 16.69
        -6.94 -16.07 13.0
        -4.71 18.36 8.09
        -6.7 -0.59 11.68
        -3.19 -14.39 1.01
        -9.75 -7.3 2.16
        -7.53 -20.66 -4.23
        -8.05 -8.49 -14.15
        -17.12 0.99 8.71
        2.6 -12.49 16.27
        -18.25 -0.72 5.18
        -2.13 13.96 1.81
        2.5 17.28 18.19
        -11.62 11.43 -10.77
        9.83 -11.5 13.46
        -6.09 21.62 -2.85
        -17.62 -10.1 19.1
        19.61 -16.41 8.55
        -5.59 8.4 3.07
        -19.82 -7.11 2.37
        -4.95 -11.14 -15.01
        16.87 -9.67 9.11
        -8.15 10.89 13.29
        18.85 -7.67 11.85
        -6.37 3.4 16.97
        2.55 -17.33 -18.52
        12.21 13.77 12.55
        -17.72 -8.02 1.14
        -3.99 2.87 6.13
        12.16 0.8 6.62
        12.08 1.04 -3.09
        16.11 -17.36 -9.8
        -16.62 17.01 16.16
        -20.76 -15.28 -6.75
        10.69 11.97 15.83
        18.53 3.47 -6.97
        19.37 10.41 14.16
        -1.49 9.17 17.78
        4.4 0.69 -19.82
        20.29 13.81 -18.79
        8.79 12.7 17.31
        2.66 -12.63 -2.61
        13.63 21.03 -12.53
        -14.05 1.57 3.97
        -14.12 14.39 -16.09
        -10.82 10.37 -8.94
        -12.25 -8.54 -6.36
        7.02 -0.6 2.31
        -10.05 5.6 -15.15
        10.94 -13.86 -14.44
        5.3 -15.56 -2.54
        4.6 -9.19 -3.8
        -20.44 9.58 1.16
        2.78 13.81 18.06
        20.6 10.25 -20.06
        -0.19 -4.88 14.98
        16.89 -7.35 5.63
        9.73 -11.35 19.93
        18.56 11.01 -14.94
        -2.93 18.71 1.89
        -5.92 -1.45 7.99
        11.91 20.04 -1.38
        8.33 14.66 16.16
        1.62 6.14 3.5
        -14.41 0.43 13.37
        -15.51 18.22 0.76
        -2.13 -17.03 18.16
        -2.8 9.11 12.51
        14.38 -12.6 10.75
        -12.73 -1.55 10.76
        -19.95 13.09 7.14
        -10.18 -4.01 14.63
        -8.38 17.98 -13.64
        -18.82 0.58 19.31
        8.19 -18.9 -2.47
        -7.95 16.25 6.57
        6.29 -5.89 -8.01
        15.93 -20.49 -8.49
        -1.27 -11.3 1.4
        -11.09 -17.78 3.26
        18.64 -13.67 3.9
        -12.92 0.64 -9.09
        -8.67 -0.73 -10.45
        -10.52 -21.36 -2.08
        0.36 -8.76 14.61
        -9.81 -9.76 -1.61
        18.57 -11.81 12.78
        -2.41 -11.97 20.89
        8.27 16.3 -9.25
        -20.61 17.77 -8.5
        -4.49 -0.76 11.59
        -7.41 12.18 6.57
        18.53 5.46 11.43
        16.19 15.12 5.5
        -6.12 20.01 17.49
        -9.13 -16.88 -9.7
        7.14 12.39 -5.94
        21.52 -2.32 -1.15
        -11.28 8.52 -21.08
        -17.73 -17.01 11.25
        10.31 3.41 -15.26
        4.99 -20.78 -6.47
        2.07 20.95 -3.83
        -6.05 -11.79 2.49
        -20.02 -12.31 -9.33
        -4.21 17.18 15.82
        1.75 -8.87 6.38
        18.22 -7.46 -5.57
        -7.77 -1.22 13.56
        -1.23 16.79 -21.25
        -8.59 -16.03 -2.25
        -12.68 -17.52 -9.19
        -21.5 -5.22 -8.06
        1.98 -1.63 9.28
        -19.76 -15.01 -20.41
        -3.68 -1.57 -18.13
        -0.29 -16.13 -14.41
        20.33 15.73 19.05
        -2.12 6.44 -14.51
        -3.94 19.16 -7.97
        14.78 20.48 18.24
        -0.05 -14.49 -19.66
        4.02 12.75 -15.23
        -8.17 -5.12 17.23
        21.08 -18.2 -0.45
        -8.57 -20.7 -14.19
        3.39 -14.09 -20.17
        6.87 -8.44 1.22
        13.29 -0.01 -0.29
        -20.12 -2.75 -18.28
        20.67 -1.2 20.64
        8.14 1.86 -9.45
        20.12 4.53 -15.3
        12.54 -5.44 -13.4
        0.36 3.1 9.37
        19.39 11.93 2.8
        -19.27 -5.7 4.27
        -15.51 -21.05 10.87
        16.46 -20.03 17.23
        15.28 6.35 -13.1
        -13.11 14.08 -0.91
        -19.29 17.11 12.25
        -13.06 -5.78 18.29
        3.08 -17.85 10.63
        -20.98 1.68 2.85
        5.08 -19.35 -16.98
        -1.26 17.22 -14.18
        11.34 3.25 9.75
        -16.88 -0.77 -19.21
        1.05 13.11 -4.24
        -8.73 20.84 -11.12
        15.28 0.06 -4.73
        9.25 4.38 -6.83
        -15.67 -12.23 1.86
        -21.41 16.8 20.26
        -19.87 12.4 14.87
        14.7 -7.28 21.12
        -9.86 0.27 21.1
        0.65 -16.11 -18.01
        -4.05 -2.11 -13.79
        -0.03 6.49 11.09
        -17.21 7.63 -0.5
        13.07 12.98 4.42
        6.37 -5.31 17.01
        -17.58 13.4 14.99
        -0.33 -2.87 6.34
        -9.79 -13.02 3.37
        -3.3 -17.5 19.86
        16.99 17.37 9.96
        -12.57 1.52 16.58
        -14.81 -4.39 -17.39
        18.1 1.79 16.13
        -1.31 9.19 14.19
        1.32 -6.04 -12.26
        -12.34 -20.88 13.64
        0.62 -10.79 -4.23
        16.98 1.63 12.01
        -12.58 19.5 -0.05
        -4.6 19.71 12.17
        4.04 1.56 9.34
        -14.37 5.11 2.73
        -15.64 -17.76 6.1
        18.28 19.79 4.06
        -6.03 16.41 10.63
        0.29 14.22 18.25
        9.56 -5.88 -1.37
        -7.45 15.99 -13.14
        21.05 8.84 21.27
        -21.32 1.51 -5.01
        -17.11 -3.77 -16.97
        12.36 -18.98 21.3
        0.66 10.54 13.79
        11.56 10.39 -12.5
        -14.27 20.16 -17.25
        -6.58 -18.66 20.61
        16.97 8.91 11.08
        6.24 -3.42 8.19
        2.58 -4.21 -17.82
        -1.2 -17.51 -17.91
        -11.86 19.75 4.42
        15.2 -3.02 13.13
        9.36 -16.74 5.2
        9.7 6.77 -16.48
        -1.21 -11.19 16.75
        2.64 16.78 -16.97
        -13.28 -5.21 -10.42
        6.22 -9.83 -2.33
        16.06 -5.12 5.04
        5.46 3.91 18.62
        -0.38 11.43 -19.91
        -12.48 15.49 -10.74
        4.69 -7.46 -17.44
        -10.82 3.59 -0.49
        -10.0 10.06 1.72
        19.56 1.42 -0.4
        3.83 13.52 21.37
        -7.99 -16.34 16.86
        -15.48 10.82 -3.01
        14.09 -18.51 -14.04
        10.49 17.22 7.29
        -19.54 -11.92 -2.57
        -14.12 8.06 18.8
        16.72 -10.57 -15.32
        4.84 -14.19 -15.23
        15.35 13.61 -10.76
        -16.93 -13.0 -6.45
        4.98 -11.27 6.12
        -15.65 20.28 4.37
        -8.84 0.61 16.71
        -4.14 -5.3 15.88
        -19.93 -5.17 -2.76
        -21.24 10.65 -16.25
        -17.86 10.15 6.21
        -6.64 5.09 3.44
        18.21 7.15 -18.0
        7.33 -15.54 -1.31
        -9.69 -5.48 -6.32
        -11.58 -18.47 8.34
        10.07 3.84 -4.58
        -13.88 21.62 -7.41
        -5.07 -6.76 -14.78
        -7.99 -2.5 -7.25
        16.84 7.13 13.84
        -18.22 -7.97 13.14
        -0.71 17.91 17.46
        19.25 12.22 10.9
        20.15 -13.81 2.21
        9.22 20.45 12.53
        -20.41 9.64 19.91
        -2.36 -1.67 -3.12
        -9.14 14.84 20.37
        20.56 -9.2 -14.82
        4.05 -10.37 18.95
        0.39 -7.68 -3.0
        -21.13 -2.73 -14.76
        -9.16 -12.98 -4.74
        -2.85 -5.37 -4.09
        -2.03 -15.31 13.97
        -1.48 -4.35 -14.7
        -12.44 19.95 -10.22
        -2.34 6.85 0.32
        9.07 -4.31 -20.05
        -15.21 -15.2 -11.45
        14.56 15.43 -9.77
        -20.64 -4.26 -16.58
        -4.45 9.93 -1.53
        17.07 7.78 -13.71
        -9.94 17.83 1.82
        6.47 -9.51 13.67
        -12.4 1.17 -13.79
        -1.3 12.73 3.68
        7.91 -6.81 7.23
        0.75 6.24 -10.42
        14.3 1.53 -3.33
        7.24 -14.89 -7.94
        10.33 14.58 -17.8
        -17.53 5.04 -3.06
        19.01 8.34 -2.43
        5.18 -16.29 13.45
        13.69 14.7 -14.36
        13.54 5.19 17.31
        -11.53 5.5 -4.75
        7.53 -7.61 -12.68
        2.09 -18.77 -14.25
        3.06 16.39 0.04
        -3.21 12.95 13.53
        9.41 -5.88 13.13
        17.63 -16.96 -14.88
        13.56 -12.77 -3.09
        18.06 9.93 -16.74
        -1.22 -12.64 -12.37
        -3.46 -8.94 14.24
        21.27 -6.06 19.19
        -15.68 16.98 10.59
        13.87 -8.74 -14.02
        -8.3 20.35 14.15
        -6.77 -11.3 0.28
        0.9 17.67 -14.62
        0.38 10.27 8.39
        0.41 5.27 -20.76
        -7.66 -9.1 4.6
        18.81 17.43 18.96
        -0.46 -19.29 9.78
        -19.0 -0.7 15.8
        -3.95 14.19 8.3
        1.52 -16.4 11.49
        -7.88 16.22 -16.95
        -17.14 20.02 18.94
        -0.68 -17.62 6.47
        -10.63 7.28 -10.33
        14.3 17.18 3.55
        0.43 20.0 17.46
        16.14 4.44 -14.35
        10.65 -17.99 12.12
        21.42 6.59 -21.35
        -5.17 15.54 -5.63
        -12.09 3.51 10.39
        16.72 -15.36 7.19
        18.2 17.69 -17.17
        -2.5 10.19 15.97
        -9.9 18.51 4.0
        -12.72 13.19 -17.65
        12.47 12.58 -3.2
        -17.28 2.52 13.99
        -13.27 -5.54 -0.82
        -6.55 -20.07 -9.13
        -3.55 7.11 -12.91
        -3.24 9.99 -8.58
        -18.33 5.26 16.71
        6.07 8.14 -17.53
        -15.26 -20.7 4.48
        7.13 2.26 19.06
        20.7 2.88 12.82
        -18.2 6.64 14.52
        5.57 -12.08 18.25
        -19.92 13.8 11.07
        -12.51 13.3 20.19
        -11.07 -11.83 18.06
        18.73 -2.31 8.61
        -3.85 -4.2 6.33
        -3.01 18.37 -6.03
        -1.73 -1.06 3.38
        -11.91 -3.98 3.3
        -0.2 0.34 0.24
        -20.63 9.98 -11.15
        6.22 -17.78 6.58
        10.24 2.85 0.05
        -14.93 -1.2 -15.71
        -4.09 0.99 -0.92
        16.35 -18.91 -14.54
        1.8 11.65 -18.66
        -8.9 8.06 17.02
        -11.93 2.43 -15.73
        1.07 -8.62 -0.84
        -4.71 -18.12 -16.6
        2.81 0.09 -5.1
        -6.11 -19.54 17.31
        -10.38 -0.91 5.74
        -17.72 -6.39 -0.3
        14.54 4.23 13.61
        -2.7 -18.8 6.91
        -12.91 7.15 -20.56
        -17.82 0.99 -13.0
        -14.58 -9.28 21.34
        19.42 -4.69 -8.38
        -1.54 5.59 5.78
        -21.14 8.69 -9.18
        9.16 9.06 8.26
        -12.74 -16.69 8.59
        -10.05 13.88 -8.89
        -4.62 7.98 -6.07
        2.79 -15.03 -14.55
        -5.13 -20.98 -7.74
        20.42 4.73 -9.69
        -2.61 18.25 18.71
        17.45 14.16 -13.79
        14.04 -8.91 17.89
        -18.06 14.88 18.53
        -6.39 -18.92 10.24
        18.94 19.68 7.6
        -19.14 -14.57 5.36
        7.11 21.0 -4.44
        12.82 -12.57 20.3
        -3.74 11.67 -2.89
        4.5 -9.62 -8.16
        5.96 12.78 -18.92
        -5.87 -19.15 -12.74
        -21.45 -9.03 -6.31
        8.04 -19.67 14.0
        -8.19 13.92 -10.01
        -6.36 -4.2 -4.47
        1.51 8.17 10.97
        -14.85 -6.63 -7.33
        -5.4 -16.93 19.39
        14.08 -8.71 8.31
        12.51 4.64 6.3
        -20.0 21.46 -14.73
        19.01 -4.14 -10.71
        -17.72 -0.24 2.96
        -14.18 -0.64 21.33
        -6.59 -7.63 6.05
        5.67 -7.56 16.79
        3.32 -2.56 6.28
        -1.31 -17.34 -0.61
        19.86 10.47 -5.84
        4.5 6.27 9.61
        -2.8 -9.78 -3.18
        19.29 1.6 7.69
        -8.09 -6.02 6.38
        8.32 20.13 6.84
        -4.18 -11.19 13.89
        -9.8 16.11 -1.85
        -4.62 2.57 11.69
        4.51 20.44 11.25
        2.42 -19.65 -18.86
        20.6 18.89 10.83
        -18.49 9.07 21.33
        2.08 11.47 -16.28
        16.26 18.04 13.27
        9.25 -17.84 -4.33
        20.09 -1.15 -6.45
        19.64 -4.49 19.1
        10.97 -11.37 -11.37
        6.89 -10.28 -21.58
        -14.2 -10.61 19.43
        0.56 -0.4 -7.99
        15.42 13.48 -13.01
        2.32 20.02 16.1
        9.57 -21.48 17.08
        5.57 15.53 -3.33
        -17.55 -5.04 10.34
        15.84 1.88 -20.43
        -12.25 5.69 -18.63
        -15.48 -5.53 -11.25
        -18.46 15.7 8.6
        10.93 6.96 -9.3
        -5.11 18.24 -12.65
        -0.16 -0.59 16.96
        -16.13 15.9 -2.32
        -9.12 5.26 6.03
        8.09 -18.09 -6.23
        4.5 8.79 17.77
        -3.12 18.13 12.16
        19.76 6.56 6.34
        -8.57 -18.43 0.79
        -0.25 16.33 -11.04
        18.63 6.5 -12.55
        17.51 -15.09 -5.9
        -4.49 6.71 14.52
        13.81 -15.98 -13.68
        13.56 -10.9 7.46
        -16.37 -8.55 -13.19
        21.13 -11.36 -9.24
        17.64 -19.28 -4.93
        -2.12 18.47 -2.67
        12.71 -1.1 12.09
        -17.49 0.67 -4.18
        5.05 10.15 -9.56
        -15.13 18.23 -4.92
        2.47 -11.8 -13.55
        -9.53 20.24 12.26
        -20.44 3.02 -1.95
        21.39 -15.63 2.49
        14.75 -9.05 -6.49
        -6.36 -5.65 -7.79
        -10.06 -7.41 6.98
        6.21 18.78 13.81
        13.55 20.4 -21.4
        -17.64 -0.57 -11.38
        14.66 -5.81 -16.42
        11.74 -18.04 -16.69
        11.5 13.94 14.67
        18.2 12.97 -19.58
        -7.18 6.8 16.9
        -9.52 -19.38 4.05
        -18.26 19.72 -2.48
        18.85 -3.79 1.93
        17.68 -7.98 -20.26
        -9.73 18.19 -3.04
        7.7 -15.73 16.13
        6.36 -4.81 19.17
        -9.95 7.4 14.95
        -1.16 -9.67 9.18
        7.24 -10.63 -17.64
        20.23 -15.46 -17.34
        -0.76 -18.67 14.83
        -16.46 4.47 10.86
        -9.78 -4.07 -15.91
        -7.11 18.51 -20.27
        18.65 12.1 17.05
        4.08 16.03 -5.04
        -11.31 -18.63 -15.65
        -15.98 6.43 13.85
        -10.5 11.7 10.0
        5.04 12.86 11.91
        -0.41 14.53 -17.97
        16.53 -12.03 -18.89
        -12.11 -1.78 2.62
        -14.53 3.77 -12.34
        -18.95 1.71 -7.92
        0.88 -14.89 -15.93
        0.66 -17.27 -4.9
        -0.32 5.41 18.63
        20.78 -2.4 18.75
        -19.31 -11.74 -11.56
        21.42 -13.45 -5.68
        -2.02 -4.15 15.89
        -8.43 1.22 -20.58
        15.26 9.08 1.55
        -9.24 -15.9 21.22
        -11.36 10.49 -4.75
        9.56 -2.84 19.01
        7.65 0.21 -13.17
        7.14 -12.03 16.48
        -13.74 -13.5 10.64
        -6.99 14.97 -15.2
        6.22 13.67 3.18
        20.54 16.76 13.67
        -8.88 6.91 7.61
        15.45 -2.8 -2.7
        5.45 0.0 -1.97
        12.65 -14.28 -16.23
        -9.04 -16.51 10.02
        -7.44 -13.83 -17.5
        -15.12 14.75 -8.43
        15.37 8.66 13.93
        -4.2 14.84 2.47
        1.07 -3.74 0.87
        -0.47 13.44 16.24
        5.0 21.22 5.68
        -9.35 -0.87 -14.69
        8.68 1.25 -0.0
        9.85 20.99 -1.84
        -20.04 8.42 17.88
        -18.22 18.67 -17.26
        14.79 -0.94 -19.55
        14.45 -1.11 -10.35
        -17.73 9.11 17.06
        17.75 -16.83 19.02
        8.72 -16.69 -7.83
        -11.9 16.09 -0.66
        6.25 14.57 15.09
        13.21 18.9 15.16
        -9.91 21.21 7.12
        13.18 9.05 16.33
        7.12 -16.66 -19.81
        0.25 5.19 -12.33
        -9.74 4.12 13.08
        -6.21 -18.13 3.72
        14.84 -14.74 -11.91
        12.05 -11.3 16.77
        -7.0 -0.65 -19.84
        -19.75 -2.87 16.31
        18.08 15.15 -8.95
        6.9 17.52 -3.35
        19.75 -5.99 1.08
        -8.32 -9.6 -7.13
        -8.03 6.64 20.83
        -13.41 -16.14 -18.2
        1.22 -10.95 -21.35
        -8.73 -5.96 -8.4
        -9.43 -13.3 -18.85
        -11.77 -8.85 -0.98
        -4.03 14.54 -9.07
        4.04 -14.33 -10.98
        16.31 4.54 -4.1
        7.03 0.86 -7.49
        19.25 -6.43 -21.04
        0.08 13.99 7.44
        4.85 3.87 3.48
        13.5 18.53 -19.72
        -14.26 6.93 8.87
        18.1 -11.52 4.06
        9.69 10.18 -2.69
        2.06 -18.28 1.74
        -19.63 17.8 -2.82
        -1.38 20.56 6.3
        -17.5 -9.85 -0.41
        -11.53 -4.21 -18.86
        -9.38 -18.04 17.94
        11.15 -2.3 8.75
        18.33 6.13 -10.12
        -0.52 -4.8 -1.7
        2.12 10.65 6.88
        2.96 -21.02 -2.25
        -4.68 11.37 10.32
        -21.38 -21.49 -3.58
        15.79 11.3 -3.61
        3.07 -3.54 -2.17
        -15.25 12.18 -4.91
        -17.1 13.65 5.01
        16.99 -10.67 16.77
        20.95 -12.28 6.49
        -9.61 21.46 -19.5
        2.3 13.07 6.92
        19.31 15.68 12.02
        15.48 6.65 21.15
        6.53 -1.98 -2.56
        10.48 10.96 5.6
        12.97 -5.14 8.04
        -10.49 13.86 8.74
        -3.2 7.96 -1.48
        18.03 0.29 -15.74
        -18.79 5.2 -9.23
        -7.38 11.22 -8.18
        -13.29 15.47 13.67
        19.21 -17.72 -3.78
        4.21 -4.53 -14.56
        17.14 -4.74 -14.61
        6.64 -11.38 11.0
        -3.7 -2.79 12.64
        1.04 11.75 11.84
        8.31 0.96 -3.98
        18.62 -18.21 -19.29
        -15.1 11.79 17.95
        -5.11 8.62 -13.69
        -17.94 -18.87 -13.76
        11.79 -2.91 4.81
        -17.47 16.74 -9.8
        17.2 -19.92 -12.48
        13.82 -5.49 13.83
        17.08 4.35 18.42
        12.05 -21.13 13.93
        12.38 -16.44 8.92
        11.77 -19.36 14.94
        16.58 -14.77 3.65
        5.02 0.07 16.62
        -1.84 -19.05 -10.52
        6.49 18.36 16.12
        -1.48 -2.68 -1.33
        17.01 -18.41 16.07
        19.51 -7.7 -11.55
        -15.67 -11.72 -15.11
        7.43 -17.99 4.59
        -18.22 6.68 21.41
        1.7 -12.27 3.61
        10.1 -6.99 4.46
        5.05 4.69 -15.42
        20.51 19.78 -3.68
        -11.47 8.77 -7.58
        11.63 9.54 -1.23
        11.05 -16.75 -1.1
        19.47 -18.74 -9.68
        -14.13 16.82 4.1
        13.0 -9.81 2.18
        9.18 6.93 15.58
        16.63 7.97 6.21
        0.64 2.89 16.2
        18.38 -21.24 16.42
        -10.06 -9.21 -3.76
        -6.6 -13.19 -8.52
        19.92 -1.34 -18.29
        16.18 20.52 1.23
        0.26 -8.43 2.97
        -15.46 -14.67 11.17
        10.36 17.06 -17.61
        -14.53 21.27 -2.53
        7.16 16.41 -18.34
        -16.0 10.94 -14.28
        -18.11 -5.02 -8.86
        -7.02 -7.61 19.54
        -16.67 -10.01 10.56
        -0.48 -13.75 6.08
        -8.03 -18.27 -1.36
        -9.98 10.28 8.23
        -16.99 -10.44 -9.08
        19.79 14.3 -16.55
        18.13 20.29 -4.01
        3.91 -6.04 7.52
        13.13 -0.06 8.43
        11.25 19.11 -7.13
        20.33 18.91 13.17
        -20.6 -19.05 20.24
        -10.56 0.05 -6.76
        -21.15 7.41 11.74
        8.53 0.05 16.7
        -0.19 -14.77 -7.65
        -1.9 -3.31 -4.58
        -4.42 -7.65 5.27
        6.23 -8.62 -14.32
        -15.89 4.15 13.12
        2.18 0.15 2.92
        9.24 17.73 -15.5
        12.06 6.96 9.24
        11.34 11.39 -14.7
        8.64 -8.87 4.43
        -0.97 9.51 -4.01
        -14.72 10.95 14.29
        9.25 14.21 -19.88
        17.52 9.63 7.56
        -9.63 11.99 -7.8
        -10.69 -14.01 17.29
        -13.14 -18.36 -18.94
        -6.15 13.57 1.64
        -8.5 -1.63 -1.08
        10.42 -19.84 4.88
        -20.41 15.91 -12.01
        21.03 -8.09 12.7
        -0.51 15.54 1.1
        10.88 -3.04 -18.98
        6.07 8.24 15.99
        -19.0 -18.81 11.37
        -16.22 7.69 -9.38
        -13.12 10.86 -17.92
        -9.19 -3.09 -13.94
        -11.44 5.67 0.45
        -19.98 3.45 -16.72
        3.85 -12.39 14.35
        -7.79 1.49 -7.61
        -12.39 -18.82 20.57
        -16.59 4.04 -20.33
        17.93 -6.98 -16.98
        20.0 -9.01 -4.72
        -17.24 -21.0 18.27
        -0.13 -7.95 18.76
        -6.05 -3.6 -6.62
        13.61 2.62 6.37
        -0.05 -8.8 -4.77
        16.86 7.64 2.45
        -14.7 -19.58 -6.52
        3.94 -6.25 0.91
        14.85 0.41 14.78
        -14.1 -21.21 -12.53
        0.44 -21.05 11.07
        -15.57 20.73 12.49
        -5.58 1.96 -7.7
        1.71 13.96 -19.01
        -18.07 -3.5 -5.1
        8.77 -4.53 -6.16
        9.6 18.84 -11.72
        -18.71 19.23 8.54
        -2.47 11.45 -10.11
        20.1 4.92 3.77
        12.91 14.78 -2.76
        7.45 -15.96 13.71
        19.4 -20.09 7.05
        13.75 -8.05 3.7
        4.96 15.35 -0.95
        4.06 -13.8 17.57
        -14.01 15.18 -12.43
        17.0 16.21 -14.27
        -14.76 10.95 9.57
        -11.06 3.94 -11.92
        12.1 -12.95 -17.86
        2.12 16.25 -10.85
        0.86 -11.06 -9.36
        8.94 -6.97 15.1
        -10.9 0.92 13.18
        16.6 11.14 16.4
        -4.29 -2.06 -7.32
        5.56 -7.16 6.82
        -18.13 -17.36 16.54
        -5.82 -10.56 12.6
        15.53 -13.97 -19.13
        -7.84 -18.32 5.13
        -15.53 -16.13 -7.64
        -11.76 8.78 2.76
        21.36 -16.56 9.88
        7.36 -15.97 7.75
        -9.47 -16.74 -18.39
        16.01 -15.54 9.33
        18.94 -20.34 9.45
        -2.21 -9.02 -5.34
        -16.03 -8.69 13.91
        -19.93 -12.53 -4.72
        20.71 19.28 -13.97
        -19.52 8.02 -3.9
        -13.85 -13.24 0.55
        16.73 -1.52 -4.08
        -5.88 0.35 -15.33
        -12.72 -2.1 -4.1
        -15.75 -0.65 -4.71
        17.38 16.83 -0.69
        9.1 11.73 11.43
        8.77 5.71 7.37
        -18.81 -8.82 16.26
        -1.96 11.19 -16.62
        -7.03 13.48 -0.63
        17.33 10.07 -13.13
        -13.33 1.55 21.01
        20.74 4.08 -7.51
        11.28 11.55 12.17
        -8.21 2.67 -14.15
        15.05 17.77 15.23
        6.93 -7.99 10.07
        1.5 5.27 -0.29
        3.61 4.72 -4.0
        -6.92 20.89 -20.51
        18.91 -10.33 -1.4
        13.87 8.16 -18.68
        -0.75 -0.21 -4.09
        -15.38 10.56 -18.15
        -6.28 -4.28 0.94
        -12.41 18.87 14.54
        3.98 18.1 1.37
        7.75 -13.48 -6.11
        -16.46 -17.93 -12.4
        4.89 -17.78 -12.79
        -7.67 -17.73 11.62
        -14.93 -1.49 0.42
        16.15 -4.04 21.09
        21.5 -10.35 17.94
        -13.33 5.31 -8.57
        11.41 11.31 -19.28
        17.15 7.89 -16.17
        -8.74 14.92 16.86
        -3.41 4.45 -5.17
        10.75 -21.24 -15.13
        11.04 -13.5 13.31
        -16.4 9.76 13.03
        11.76 -10.27 6.13
        4.67 7.05 6.34
        7.5 -5.42 -18.91
        1.27 17.68 6.73
        -2.02 -12.47 6.75
        6.12 20.25 -10.12
        5.9 -21.02 -20.78
        -6.52 11.05 19.88
        13.72 13.78 2.32
        -1.41 -14.51 4.05
        4.2 19.69 7.44
        11.8 -16.06 -19.36
        -12.13 11.02 -14.25
        17.64 4.7 4.4
        3.67 -14.47 13.37
        -13.13 -9.78 6.26
        12.08 -5.66 16.92
        7.95 6.95 -3.54
        -2.85 -7.47 -10.7
        8.32 0.9 9.38
        -5.86 1.48 -11.47
        -10.96 14.82 4.73
        -14.82 -10.13 2.75
        -15.72 -1.58 2.62
        20.98 0.18 -8.11
        -1.82 2.67 -5.42
        1.54 -12.76 -19.77
        13.96 -21.25 9.2
        20.05 -14.12 5.74
        -8.16 14.32 14.75
        -16.66 -17.84 19.74
        2.97 1.95 -20.87
        -11.45 -2.91 -16.84
        -2.59 1.35 -9.32
        6.82 2.23 -5.52
        4.9 2.75 -14.42
        20.81 19.08 -0.02
        -3.91 3.09 19.5
        12.46 -7.29 7.56
        -7.86 19.71 4.23
        -11.37 -1.34 12.7
        15.6 4.11 -18.05
        11.59 2.41 15.4
        1.05 -20.73 -0.93
        18.47 -20.81 -0.99
        21.4 -17.59 -9.12
        0.12 -11.32 -13.91
        -8.56 -1.91 -18.58
        -11.06 4.56 6.84
        2.27 -9.57 -10.68
        -2.24 8.95 -17.55
        10.99 -16.02 -7.69
        5.77 8.29 9.79
        21.51 10.44 -0.41
        0.45 4.7 -16.94
        16.81 0.45 10.08
        0.26 -6.59 13.59
        -17.04 20.18 -11.65
        6.91 14.78 -19.87
        -0.02 13.43 -2.05
        1.62 14.14 -21.31
        16.53 15.14 17.12
        -5.45 -14.78 20.18
        -3.23 -7.68 12.03
        -18.96 -9.63 -2.39
        12.37 -5.81 -9.82
        3.39 -17.15 -14.54
        17.06 -20.2 -16.34
        -18.94 -16.26 -5.75
        -5.08 14.94 -3.5
        3.76 20.16 0.4
        3.44 -10.99 21.19
        -18.79 9.29 -12.0
        -2.44 20.67 0.65
        15.77 5.59 16.97
        7.26 -16.51 -17.58
        16.38 1.98 -11.86
        -3.07 -16.34 -16.73
        17.45 -7.23 14.92
        18.02 3.04 -3.56
        1.12 -18.0 -8.73
        -3.67 4.62 -2.65
        20.48 16.01 -12.24
        0.91 18.53 11.34
        -3.58 6.22 9.49
        17.98 -11.58 0.16
        3.0 -2.05 2.88
        -20.89 18.51 7.69
        -17.58 2.15 -5.92
        3.29 10.26 -19.87
        15.37 11.98 18.14
        -1.36 16.81 -9.12
        8.15 13.21 4.33
        -20.1 5.57 20.65
        21.11 -10.03 20.3
        -3.59 -14.17 -6.21
        -9.33 10.25 16.99
        -6.15 6.28 -0.21
        7.13 2.38 -14.02
        -0.15 -15.33 -1.3
        -5.84 16.3 -1.89
        -7.45 -10.91 -11.32
        -15.14 19.11 19.75
        -15.85 19.35 -2.89
        -18.66 10.41 -6.38
        12.16 1.38 -17.46
        -12.14 -5.81 20.61
        -17.46 -11.78 9.37
        6.9 13.59 -3.82
        10.3 -8.11 18.57
        -8.92 1.31 -9.47
        -8.49 15.57 -6.37
        8.37 4.64 -19.64
        -20.18 0.74 14.34
        -7.82 2.64 -10.93
        14.86 19.92 6.19
        -14.77 13.5 19.69
        -6.75 -13.68 9.87
        -10.48 1.49 0.52
        5.8 16.54 19.83
        12.06 -0.88 1.24
        -13.02 -17.9 -6.99
        11.33 -16.44 15.82
        -19.94 -19.44 8.0
        11.38 -7.49 -4.04
        5.28 -13.69 -18.86
        -15.07 -15.6 13.31
        -4.56 1.4 -13.42
        -2.25 -2.15 21.41
        -16.9 -5.18 4.49
        14.24 -16.64 10.39
        9.63 -15.6 -4.1
        -2.23 5.48 -8.57
        19.02 -5.84 8.22
        5.19 16.29 16.13
        1.13 8.93 -13.66
        12.52 -1.82 -15.14
        -4.76 -13.62 -10.12
        -18.48 -0.09 -15.21
        6.91 -12.39 20.13
        -16.56 21.24 -9.61
        -12.65 -0.76 16.63
        15.62 10.48 20.08
        16.34 -7.93 0.72
        -5.11 -6.19 11.26
        19.66 -14.55 -8.98
        -7.77 20.25 6.49
        -16.63 -7.51 -18.35
        -18.76 1.29 12.6
        -4.44 15.92 -17.9
        7.29 -18.76 -16.78
        3.48 -20.11 17.61
        2.47 5.6 14.2
        -16.79 -8.52 5.97
        8.79 -13.71 16.81
        6.74 -14.58 -13.82
        -11.65 -2.02 -6.24
        -10.94 -16.08 4.92
        6.76 4.9 -11.11
        -6.37 12.85 10.95
        21.41 -18.74 3.86
        6.89 12.18 8.08
        14.03 -11.8 2.87
        -8.63 -4.45 11.69
        6.49 12.47 -11.86
        6.64 3.55 -2.2
        14.2 3.51 -4.6
        -12.75 9.74 -15.97
        -14.57 4.06 -1.05
        19.11 -13.7 0.11
        -14.54 7.18 15.38
        11.76 15.66 19.63
        -15.97 -8.7 17.91
        -5.47 -11.3 6.02
        -9.84 -19.18 -9.6
        9.64 15.22 20.52
        -12.59 -12.24 19.81
        19.57 -7.4 2.93
        -13.09 -12.04 -4.98
        15.08 16.21 -15.66
        -0.65 -15.26 21.46
        -13.21 0.31 -18.72
        16.44 -6.65 -15.43
        -11.81 -8.12 1.19
        14.38 13.58 11.91
        3.76 -1.24 -18.89
        15.02 18.68 -15.48
        -5.77 11.13 -16.8
        1.78 18.67 -3.25
        15.71 18.22 -8.24
        3.98 -2.19 16.42
        -14.43 -16.72 1.82
        -12.03 17.08 -14.61
        1.13 -16.49 17.49
        13.7 -1.31 -5.34
        4.05 -14.96 1.44
        6.2 2.88 5.03
        12.8 13.59 19.9
        11.35 11.94 20.18
        21.29 -18.27 -4.99
        10.87 -21.07 -5.08
        10.88 12.14 7.65
        -16.03 17.33 6.81
        0.37 -13.99 -11.5
        19.61 4.45 -2.89
        8.98 -0.61 -14.67
        -1.09 14.94 11.14
        7.55 -0.9 -20.03
        -6.27 19.54 -15.88
        -20.83 -9.03 10.94
        4.71 5.68 13.46
        -4.82 9.71 15.87
        3.24 -8.63 -16.16
        -9.74 3.43 -15.56
        -13.49 -3.12 -9.29
        -20.63 3.57 -4.17
        -13.29 17.85 -20.03
        -1.31 -15.49 9.75
        -4.44 8.18 4.95
        -21.51 -16.0 16.09
        6.1 -1.05 4.2
        -9.34 -8.23 -8.78
        -21.54 -2.61 4.15
        -14.47 -4.91 14.29
        9.01 14.19 -8.6
        -17.49 -2.22 -2.1
        -15.23 4.46 21.12
        11.14 4.79 21.14
        -0.59 -16.75 4.22
        -10.3 -3.46 -11.89
        -0.89 17.76 1.73
        18.37 14.37 16.04
        -16.81 14.55 -10.1
        -1.43 1.78 8.68
        -8.01 -3.92 -17.64
        1.45 17.4 -1.32
        -15.84 7.56 17.26
        7.82 21.6 18.61
        -10.01 15.68 -17.53
        -20.04 -16.04 14.27
        12.92 12.72 -15.67
        9.36 2.85 18.43
        1.36 0.78 6.49
        3.31 1.06 1.05
        19.26 8.99 10.8
        8.32 -18.0 12.73
        -2.74 -20.07 -2.68
        13.16 11.95 8.2
        -14.63 -15.33 -13.72
        -11.83 -6.94 10.42
        12.52 -5.76 -4.92
        10.84 -2.34 -16.69
        -10.52 0.28 -13.09
        -17.69 -8.34 -9.38
        17.34 -17.33 6.12
        -3.99 -10.32 20.46
        -9.96 -6.35 11.83
        1.96 -6.98 -20.28
        17.13 -3.3 -5.52
        8.49 -5.1 16.37
        -7.29 -14.15 -1.98
        -8.74 3.89 -1.39
        -14.67 -16.86 -9.8
        13.25 6.77 -13.97
        -14.21 0.28 11.02
        -14.37 -1.73 14.05
        0.2 -5.86 19.78
        -11.91 16.74 1.51
        19.73 -11.17 -11.35
        1.82 -0.65 -17.71
        -11.27 12.71 18.38
        7.18 -8.2 -10.41
        -19.74 0.08 -4.04
        -8.43 -7.93 11.09
        -15.94 -17.6 12.78
        -6.2 20.61 -6.53
        9.32 12.9 19.77
        1.91 -14.2 -4.09
        9.66 1.61 -21.36
        14.59 18.95 11.82
        3.72 3.22 -12.69
        6.14 17.36 2.1
        -6.52 -2.37 15.13
        9.32 -0.69 2.5
        -20.95 7.52 1.63
        -8.44 -15.72 -11.62
        -15.22 -21.08 0.89
        -14.97 -20.4 17.76
        -10.32 -0.73 3.4
        -4.92 15.69 -15.64
        3.57 9.23 3.77
        -3.16 -6.63 19.21
        -21.11 -12.72 -15.28
        -7.2 16.28 17.74
        4.2 -11.47 10.92
        -9.11 -19.71 -2.91
        -10.38 6.89 -3.25
        -12.78 -7.92 -17.41
        10.01 18.78 -5.11
        -16.44 7.07 -7.11
        -7.62 10.18 7.98
        -10.62 13.5 -16.91
        -20.77 -11.6 4.82
        -2.71 -18.27 16.38
        -20.1 10.02 14.35
        -18.27 -10.0 21.3
        16.95 -11.26 -4.29
        -19.9 -20.65 -9.02
        6.15 -20.04 9.64
        1.37 7.05 1.27
        9.68 -15.18 -2.01
        -13.36 2.27 -19.96
        -12.8 11.95 -21.19
        6.62 0.21 18.14
        5.97 -5.62 -3.03
        10.91 1.54 19.88
        -18.42 -11.46 -7.66
        -16.18 2.11 -17.14
        -3.24 13.39 -0.03
        8.01 7.55 21.55
        21.51 -17.34 5.57
        -4.53 2.34 -9.75
        -21.43 -20.44 -1.25
        5.39 6.06 3.02
        -0.3 11.74 -9.37
        -21.41 15.95 5.27
        19.93 1.99 -20.68
        7.71 -17.69 -9.69
        0.87 -5.34 8.97
        20.2 -0.5 12.67
        15.65 3.92 -0.72
        11.82 17.51 -8.72
        12.26 13.27 -18.03
        13.89 3.63 19.07
        9.77 -14.85 20.66
        -11.98 13.46 -9.96
        21.21 18.97 -5.74
        21.4 9.93 7.18
        11.21 4.93 -16.57
        13.35 20.3 -6.63
        -8.63 19.59 -18.6
        19.45 19.91 -21.46
        12.27 12.29 -9.05
        10.83 -9.19 -16.87
        -2.62 4.02 21.27
        -0.05 -18.3 -15.02
        14.23 17.01 -11.39
        -10.44 1.38 -5.12
        17.45 18.69 2.14
        10.39 -0.1 -17.73
        -8.13 -6.71 -15.56
        15.93 0.1 -14.83
        10.09 17.11 -10.24
        -11.74 -20.12 9.85
        12.62 -4.2 -19.55
        -3.58 -19.79 -19.96
        -9.55 13.59 3.36
        -15.11 -18.49 -15.91
        -6.6 20.22 19.62
        -6.59 -5.18 -14.93
        -16.19 15.84 -18.92
        -0.94 12.26 8.76
        4.77 8.38 -19.5
        -5.54 -15.06 -1.07
        3.42 20.37 -18.6
        18.9 -17.82 17.34
        11.64 -8.62 -7.53
        -1.72 4.06 -11.82
        11.02 6.33 14.51
        -14.23 10.92 0.44
        -6.32 -18.92 -5.49
        20.11 -1.48 16.75
        -20.74 12.24 -1.3
        3.58 18.24 -4.54
        -3.54 11.0 0.19
        1.58 6.07 7.5
        -9.71 -20.37 -16.0
        2.29 11.15 -4.44
        15.77 -21.0 -18.07
        13.01 -16.32 -17.43
        -1.36 -20.51 20.3
        19.29 5.7 21.32
        14.4 8.07 6.06
        -5.93 -2.36 -12.43
        -5.31 -3.98 14.01
        16.2 -19.83 -3.26
        -11.12 -6.48 -18.0
        -14.07 -12.61 8.52
        -18.6 20.36 -6.36
        2.37 2.4 -2.05
        10.99 8.74 0.85
        12.1 19.39 20.63
        -7.35 -14.07 11.95
        -19.61 10.33 -4.24
        -20.01 -13.4 -13.17
        -20.35 -14.88 9.12
        -16.6 9.14 -6.01
        1.18 -3.76 -6.73
        -5.82 7.6 -8.1
        -13.15 -19.41 -16.89
        16.03 16.65 2.1
        0.54 11.59 -0.8
        18.37 -20.09 2.44
        -1.56 -12.0 9.01
        19.81 0.43 -4.93
        -8.94 14.88 -11.9
        21.04 6.12 -6.22
        -11.79 11.15 -2.69
        21.28 -9.36 14.44
        13.38 3.94 -0.5
        2.71 13.47 12.19
        -15.16 -3.23 12.75
        -7.01 -0.34 -12.08
        -3.06 -3.93 -13.1
        18.49 -13.04 -12.07
        20.28 1.05 20.46
        18.23 -5.35 11.47
        -17.65 -13.03 -1.68
        -9.88 10.05 -18.41
        19.19 -21.06 21.2
        -10.12 18.38 19.43
        -20.08 -9.38 -12.03
        2.92 19.17 -6.5
        9.81 -11.84 -7.99
        -11.29 4.03 -8.34
        4.73 -4.85 9.17
        18.72 9.87 -9.21
        13.32 21.35 -0.65
        16.85 19.37 -16.55
        -17.52 5.95 -19.73
        -4.68 -20.47 12.86
        5.93 -4.63 4.32
        -15.11 -15.84 -2.24
        9.54 2.51 8.61
        4.52 8.44 -2.99
        14.43 21.01 2.66
        4.07 16.81 -20.12
        5.89 -18.15 0.8
        13.38 -13.88 -10.11
        -16.18 8.7 -3.79
        16.57 -6.0 8.61
        -4.38 21.56 0.38
        0.2 -10.28 18.51
        -7.29 3.74 9.03
        5.04 -21.18 14.78
        -15.41 11.61 -12.11
        13.13 16.95 0.28
        3.44 -7.96 -0.59
        18.99 -16.0 -7.4
        12.26 -4.33 21.36
        11.67 9.29 -18.11
        -13.48 -6.6 4.86
        13.29 -16.09 18.96
        5.1 11.37 -13.37
        -5.41 6.47 1.99
        2.05 16.37 -8.6
        16.14 13.06 6.56
        -3.9 -2.11 -9.69
        3.73 16.79 4.46
        11.25 19.5 10.27
        16.47 13.64 18.84
        13.96 21.17 14.67
        8.05 18.21 5.34
        6.43 -11.75 -5.73
        -13.23 -7.07 -9.15
        -15.16 11.19 -21.5
        -11.58 -10.87 -9.21
        -10.15 -0.99 -16.94
        12.87 8.55 7.82
        -3.89 -9.26 -14.44
        -2.54 -3.81 -10.71
        -1.52 -0.06 10.03
        11.11 0.13 -11.91
        17.0 16.78 -18.88
        2.1 6.87 -21.27
        -8.7 -9.57 -19.45
        -14.88 12.82 4.7
        -2.36 -17.65 3.22
        -13.73 -11.53 -12.35
        20.35 20.84 3.68
        -19.58 -3.7 3.76
        0.7 -10.34 12.74
        -14.6 -18.88 11.37
        6.66 -14.1 4.78
        12.86 -19.56 16.97
        13.07 -15.67 -0.9
        -5.76 12.96 -2.79
        15.24 7.88 -2.33
        21.39 -2.96 15.3
        3.0 12.92 15.91
        7.64 10.41 -1.69
        0.44 -0.94 10.86
        -13.84 5.55 0.53
        1.39 3.09 -12.99
        -20.93 14.04 -4.52
        7.11 -21.33 6.02
        13.25 -8.64 -11.85
        -13.31 -11.4 -15.67
        14.2 11.96 6.06
        -10.24 -11.9 -0.98
        1.91 -20.68 -7.0
        20.86 9.59 -12.55
        -4.58 0.26 -6.48
        -16.23 17.65 14.07
        13.09 -7.12 13.34
        16.19 5.17 -9.7
        -0.6 5.87 -18.75
        18.85 16.38 -15.65
        -4.89 -10.59 10.42
        -12.24 13.41 -2.81
        0.38 1.76 -14.87
        -20.53 17.41 -4.92
        8.01 -19.84 -9.82
        10.41 -5.71 -21.56
        3.43 -8.07 -9.42
        -13.53 -17.77 5.41
        17.5 13.29 -9.86
        15.78 4.47 20.18
        -2.31 10.24 -12.11
        17.03 2.96 21.44
        -3.13 -3.02 0.18
        19.43 -11.32 10.59
        14.1 -19.74 7.48
        -18.06 -5.57 -4.05
        -8.75 -19.4 12.95
        9.68 7.1 9.13
        -3.15 -5.64 -9.55
        -0.93 0.97 18.6
        -2.92 -16.79 1.04
        6.71 -7.36 -6.19
        14.65 5.42 11.49
        -14.54 -17.46 -0.38
        -4.25 10.7 -13.44
        -13.68 -6.68 1.25
        14.98 21.18 12.66
        -20.22 5.98 18.2
        18.72 2.18 1.74
        -16.57 0.04 6.59
        -15.64 6.89 -18.69
        16.27 10.27 12.86
        -4.84 5.31 -12.17
        10.5 -8.24 16.06
        14.86 8.61 -6.21
        -6.93 9.37 -20.77
        -14.95 -7.13 -14.46
        15.54 20.62 20.51
        -12.77 1.83 14.21
        20.0 -17.46 13.89
        -10.61 2.04 17.61
        -16.46 9.88 20.4
        4.76 -19.66 -8.54
        -12.4 5.06 3.88
        16.59 -18.69 -6.87
        2.26 14.58 14.26
        19.75 14.83 5.54
        -17.89 2.37 0.26
        -6.18 17.99 1.61
        -20.89 1.84 19.55
        1.52 -11.56 -17.81
        14.89 -16.29 -2.34
        17.29 -8.13 -12.07
        -1.72 6.38 7.95
        5.32 -6.89 4.54
        -5.53 12.22 5.13
        -15.71 1.96 -13.39
        17.32 21.28 12.69
        -17.03 6.41 -12.9
        -15.77 -10.72 12.62
        7.49 6.3 -16.58
        18.46 12.49 19.16
        -1.43 -2.26 -17.83
        -13.37 -9.63 -18.64
        12.68 4.98 8.58
        -10.89 11.27 6.08
        -9.65 -19.84 -7.47
        14.6 6.32 -10.88
        11.53 8.66 21.18
        0.84 -13.39 -9.37
        0.75 4.88 12.66
        -14.24 0.12 -13.9
        1.35 2.89 11.52
        -6.76 -7.14 14.19
        -10.73 -15.75 11.25
        3.3 -16.41 -20.46
        21.38 10.64 -4.14
        7.08 7.14 -10.76
        -18.33 -15.39 15.49
        2.7 8.73 -11.97
        -2.91 17.68 -17.87
        -15.79 0.89 16.98
        -12.78 18.43 -5.56
        -7.13 19.59 -12.51
        -5.53 0.4 -4.35
        -0.93 -8.31 -9.92
        -21.5 -6.0 13.14
        -12.02 15.84 -20.57
        -2.46 -0.31 5.45
        -20.51 -17.11 19.47
        5.73 10.35 6.98
        4.0 -21.04 10.14
        -0.35 8.12 -18.48
        6.17 10.69 21.02
        -15.77 15.43 19.17
        -18.78 13.96 -3.69
        -11.08 -15.86 -9.15
        -21.11 4.18 7.47
        16.62 -15.33 -16.23
        -6.19 -8.51 -2.48
        12.85 -3.74 -0.68
        18.26 -17.93 2.12
        -11.85 19.85 6.74
        -5.7 -18.55 -1.23
        1.57 -17.33 -10.92
        16.22 -8.55 -14.15
        3.53 17.52 6.69
        7.35 1.4 -1.87
        19.91 -2.85 -14.73
        8.23 -13.63 1.53
        -3.24 21.22 -12.22
        4.32 -8.81 13.39
        -17.9 -2.87 -18.76
        -16.6 -16.87 2.89
        0.53 6.59 5.44
        21.56 11.99 6.17
        -20.72 -1.29 -9.02
        3.58 -6.09 -12.99
        4.22 9.67 12.77
        -18.61 -4.27 12.28
        -15.42 14.2 -1.01
        -5.49 3.95 -6.53
        16.02 -11.12 -20.98
        -16.75 14.13 12.81
        19.59 -14.49 -13.24
        -21.19 -11.74 -19.71
        12.69 8.21 -8.75
        -14.88 13.33 8.73
        -21.59 17.69 -18.68
        5.17 12.36 9.68
        16.6 6.69 11.68
        9.53 15.12 7.9
        -20.68 6.26 -0.15
        20.46 3.34 8.82
        17.5 21.08 -13.2
        18.4 -15.29 -3.87
        -20.2 -2.97 18.62
        2.27 17.87 -21.31
        18.91 8.76 20.06
        -18.42 -19.09 -18.37
        -13.44 9.27 15.47
        -3.6 -15.63 -9.71
        -19.08 -5.85 13.63
        -3.95 -11.73 -9.73
        2.42 -13.83 -12.6
        2.62 12.59 -10.89
        -1.14 -0.58 -6.42
        -2.98 -12.63 12.38
        12.0 3.31 -9.85
        -0.94 -6.74 6.31
        6.89 4.3 -6.52
        -12.27 -0.7 7.06
        18.05 19.43 13.79
        -0.16 0.49 20.77
        -19.27 12.01 -19.89
        -2.53 -17.79 -6.8
        -19.13 -21.5 5.6
        7.96 2.62 3.88
        8.33 -1.47 -3.99
        -16.19 -7.49 7.97
        -8.75 -21.11 11.39
        -18.49 4.18 -5.08
        12.7 -10.87 -4.0
        16.31 -2.44 8.18
        -7.31 -3.99 -13.33
        -3.73 2.1 8.45
        -4.27 -5.06 9.65
        -6.54 -12.23 -13.43
        10.68 15.3 -11.66
        17.15 4.12 1.1
        4.42 5.13 -11.48
        15.07 -6.89 17.38
        1.79 20.72 -10.3
        16.0 14.64 20.87
        9.44 11.95 -5.96
        3.75 -17.21 0.35
        10.01 19.83 16.2
        -5.96 19.82 13.98
        -21.53 14.19 -15.58
        11.66 15.69 11.03
        -5.91 -11.24 -21.59
        15.54 -2.88 -9.39
        -12.7 5.92 5.96
        -18.26 9.91 -19.84
        -3.51 -15.78 10.33
        15.47 -11.87 6.36
        17.94 -14.25 -10.28
        -16.39 -2.63 -4.13
        -21.34 -12.18 2.57
        12.86 -13.39 -1.02
        7.69 -10.68 -7.6
        -5.88 12.24 -12.47
        -7.79 -14.2 20.06
        -17.14 20.45 15.66
        -3.91 -9.79 18.37
        -10.16 4.7 -6.49
        16.62 -10.37 13.04
        20.89 -5.25 15.27
        9.16 -2.76 -14.91
        17.69 -17.36 -0.18
        -3.55 -14.87 12.55
        20.41 13.19 9.2
        21.24 5.38 -4.0
        2.86 1.15 4.8
        -6.99 -13.21 -4.08
        -19.31 1.38 8.77
        19.37 -5.09 -14.25
        15.47 5.29 -7.46
        -3.35 21.39 -8.57
        -8.39 -15.99 -14.94
        -10.49 17.96 -13.21
        -9.72 -4.97 2.93
        -12.44 19.91 -20.96
        -5.53 16.13 -12.06
        -17.21 16.55 -14.15
        19.11 5.38 18.92
        -18.38 8.78 -17.77
        0.97 21.48 2.57
        -15.63 -13.24 3.97
        3.74 4.04 20.12
        20.53 -16.09 12.08
        -2.42 -15.76 -14.58
        -0.2 15.66 -1.2
        13.2 10.41 11.33
        -11.95 -15.16 -16.49
        11.94 18.76 17.03
        -16.93 -15.09 7.98
        8.84 9.32 14.71
        17.01 4.71 8.12
        -15.67 2.45 0.35
        -12.09 -20.04 -12.32
        10.43 -3.79 13.92
        12.99 16.1 2.39
        7.03 -14.31 -20.22
        -14.24 -7.1 13.45
        17.39 2.53 7.21
        -0.55 -8.96 6.85
        -11.38 -2.04 17.92
        21.51 13.18 21.05
        17.83 19.07 -8.5
        -15.76 -9.36 -4.82
        -21.11 -18.86 -20.84
        18.38 -12.55 17.28
        5.12 -9.56 -0.19
        7.88 19.67 -16.18
        -13.55 16.47 -8.86
        8.95 -20.55 -13.69
        3.22 7.96 0.32
        -18.52 -7.04 -5.69
        8.72 13.29 -16.74
        -20.75 -7.71 -18.56
        18.77 0.44 -19.24
        -13.54 -3.05 -15.83
        -20.33 14.18 -6.69
        -1.09 18.13 -12.15
        21.63 2.48 17.43
        -1.07 -4.81 -18.48
        -17.42 13.43 1.31
        1.64 1.74 -0.05
        13.33 -13.54 12.75
        -16.69 11.42 0.31
        -8.92 2.86 -5.99
        -6.48 3.89 14.67
        -8.81 6.65 -18.73
        13.01 21.22 -4.68
        -17.49 19.68 3.21
        10.35 -8.87 -5.68
        -6.6 -15.19 1.26
        9.46 -5.9 -15.9
        -10.7 -13.21 -2.78
        -6.01 20.25 10.43
        2.32 -10.51 17.49
        16.54 -12.98 -9.24
        7.08 9.48 3.71
        15.07 -3.39 -16.88
        -2.65 5.22 -18.26
        -4.78 3.86 9.71
        0.46 12.43 -11.44
        18.47 6.11 -1.94
        -4.79 20.63 8.55
        8.05 20.17 -0.61
        -5.24 -5.18 -9.64
        -6.97 3.01 -21.43
        3.17 -20.32 13.88
        -18.1 -15.49 -9.6
        -16.84 5.96 -10.53
        19.81 8.09 4.61
        10.34 -20.81 -7.37
        10.81 -19.17 -18.47
        20.56 -21.36 -18.7
        1.84 -14.46 10.12
        16.37 -15.47 17.5
        -13.79 -5.01 -5.93
        -15.05 -8.24 -2.86
        1.74 10.08 10.22
        -16.29 -0.74 -21.43
        -18.25 10.53 -13.98
        3.79 10.67 -11.56
        -17.34 -3.92 -13.71
        -15.04 4.6 -10.19
        -17.75 20.87 7.18
        -17.69 7.44 -2.83
        17.88 -16.71 9.81
        -18.08 9.02 14.71
        -0.97 12.92 -5.54
        -4.97 -7.57 15.6
        -11.88 18.76 -3.56
        15.99 -5.71 10.86
        20.0 -19.78 -20.32
        -13.88 14.58 15.83
        14.3 0.37 -17.72
        16.24 14.9 -4.31
        10.09 2.66 -8.35
        -20.64 19.21 -20.14
        -15.05 16.44 -17.07
        -18.58 -8.26 -13.71
        -4.26 -19.41 -6.23
        9.42 -17.29 0.43
        9.35 -10.99 3.75
        -6.22 20.23 -18.0
        19.95 -16.27 -19.4
        15.59 -14.61 1.46
        3.39 -20.26 5.36
        -2.59 -1.73 9.06
        4.54 12.43 3.58
        -10.79 5.18 15.13
        6.35 -21.48 -1.11
        5.22 14.32 -8.61
        -4.31 -17.0 4.48
        -21.0 -21.16 6.72
        -3.91 -14.64 4.3
        5.14 -4.11 -21.12
        -18.31 -16.43 20.22
        15.45 20.27 -0.78
        -8.9 0.74 14.43
        1.13 -5.85 -18.27
        -16.95 -4.03 -10.45
        5.21 -19.16 18.91
        -11.38 17.44 -16.78
        -3.17 -6.94 -5.94
        10.48 1.04 3.35
        -13.37 17.99 -17.82
        10.51 -2.61 -3.66
        -9.58 8.94 -0.34
        -13.61 -5.2 2.9
        16.36 -8.93 -4.92
        -18.49 -8.6 10.99
        5.01 4.78 11.33
        19.07 -18.59 -12.04
        12.64 -19.7 -15.61
        16.69 -1.26 3.69
        17.18 -18.81 9.51
        -7.96 -13.55 -15.08
        -10.34 19.71 0.53
        -2.28 13.12 -2.03
        14.44 -5.74 3.26
        -17.44 -12.92 -18.17
        -15.81 13.01 -15.6
        -12.95 20.09 -12.48
        2.78 -14.26 19.51
        4.57 20.66 -1.62
        15.01 1.86 4.65
        -11.81 -4.26 17.19
        -19.54 17.46 -10.46
        -5.79 4.03 -19.56
        18.4 4.46 -13.75
        -0.96 7.78 -5.8
        19.26 14.36 -7.04
        5.35 -15.3 -17.13
        -19.46 10.48 10.15
        10.73 -5.8 2.4
        13.11 -6.69 -15.1
        18.34 -12.92 19.64
        0.2 17.27 -7.66
        9.58 -0.0 12.96
        -19.76 -13.0 1.05
        -3.61 4.55 -10.35
        21.43 -20.33 -14.97
        -7.02 3.71 -4.86
        -8.72 6.24 3.84
        -6.73 -10.2 7.76
        12.36 13.69 -7.48
        -18.11 -9.11 -4.65
        -4.09 7.41 -20.77
        -10.92 4.88 8.99
        16.4 -14.27 14.3
        -20.09 12.73 -16.23
        1.48 -16.03 -2.96
        10.39 -18.43 6.53
        -6.09 15.56 -20.78
        10.51 3.54 11.99
        13.88 -18.13 1.59
        -9.85 19.17 -16.79
        -18.15 -19.66 19.9
        5.53 7.89 13.56
        12.79 -12.53 9.07
        18.52 -2.7 -7.19
        8.68 -20.13 -18.26
        18.78 5.62 0.2
        -9.84 -3.42 -6.1
        5.41 -6.97 -9.88
        21.39 18.27 -2.01
        -13.42 -14.53 19.4
        0.4 -3.07 11.94
        -17.47 -15.13 -2.63
        -19.9 16.04 10.35
        15.49 -14.16 5.72
        1.8 6.17 18.11
        13.69 -19.78 -12.03
        -7.09 18.18 7.72
        -6.9 9.06 12.37
        -17.71 9.13 2.74
        -10.75 -20.57 5.32
        -10.84 -18.56 16.15
        16.78 14.76 3.29
        -19.29 19.52 12.56
        -4.7 -20.53 -1.6
        0.73 20.28 9.7
        9.85 20.43 -8.37
        19.05 18.36 5.82
        7.73 10.15 12.79
        19.9 16.15 15.86
        6.26 -14.16 8.45
        -8.0 12.44 -19.87
        19.54 -2.64 -2.36
        -19.21 20.52 10.49
        17.79 -4.98 -18.29
        -8.14 18.26 -15.81
        14.61 -3.22 -19.08
        -13.05 5.09 11.71
        2.01 -2.98 -21.64
        12.45 7.23 17.72
        -10.98 -10.43 -11.44
        20.91 -14.04 -1.54
        -9.62 -11.29 -6.41
        8.2 -20.14 4.3
        -4.73 2.29 -18.16
        -15.29 -3.69 20.02
        10.59 -12.27 10.16
        -18.36 12.89 3.27
        18.96 14.31 3.24
        4.8 -4.41 -7.55
        -0.22 -13.42 10.3
        -8.54 2.0 10.19
        -7.82 4.91 -10.23
        -15.98 13.1 -21.57
        18.92 -0.1 9.37
        10.77 -16.63 -11.41
        -21.44 -14.19 17.32
        15.66 -6.77 -20.15
        -5.49 1.89 20.72
        -8.11 -19.13 -12.69
        21.62 3.88 -18.4
        -16.51 -3.93 6.26
        10.68 -7.17 0.31
        12.46 9.38 3.61
        15.39 9.83 -19.34
        12.88 -7.9 -0.7
        -21.1 -1.7 7.34
        -16.96 -15.05 4.36
        0.61 21.11 -8.25
        -11.47 -16.25 -12.81
        -5.14 -3.54 -0.95
        7.11 -5.2 -12.55
        -12.45 -10.22 2.1
        -18.58 1.97 2.5
        6.93 -19.66 7.59
        11.38 -15.84 -13.56
        5.19 4.28 -0.42
        -2.36 -8.01 -15.98
        18.52 3.43 12.66
        8.65 -9.6 18.91
        17.52 5.93 6.32
        2.68 -1.62 -12.15
        -1.15 3.21 -15.81
        8.44 14.81 0.69
        9.55 -19.57 15.59
        -1.84 -4.76 3.42
        -4.8 12.08 21.08
        7.49 2.87 14.6
        -12.78 -8.11 -13.82
        -2.73 8.07 -11.17
        -13.45 18.57 1.54
        11.22 -7.48 -20.32
        20.82 -2.33 2.14
        -10.06 14.15 -2.7
        -13.65 2.03 9.57
        3.69 17.88 -8.12
        -2.47 11.16 -4.8
        7.04 13.07 -8.13
        -10.48 -13.23 8.94
        -9.53 16.96 13.01
        -1.16 10.05 -0.23
        -20.6 12.02 19.23
        7.23 -5.33 -1.05
        9.09 -19.05 8.21
        0.32 -4.9 7.09
        20.65 10.2 -8.19
        1.34 -16.4 -7.1
        9.4 9.05 18.32
        -3.78 -13.64 -1.03
        -19.71 -17.81 6.62
        -9.44 -17.64 8.2
        -18.65 -19.19 5.04
        0.97 11.99 3.41
        -18.09 12.72 -9.39
        -0.2 -20.0 18.37
        0.96 1.68 -11.21
        -19.83 -18.83 3.13
        9.95 -12.79 -6.13
        17.92 1.24 -2.0
        -8.37 -6.82 15.54
        -10.87 6.4 2.68
        15.08 -20.66 4.05
        -0.25 -9.26 -13.41
        7.08 -16.89 -13.21
        -4.17 -5.86 -13.12
        -15.33 19.96 -8.13
        -0.77 -21.22 -2.17
        20.12 6.95 8.42
        14.24 -16.43 -4.51
        15.57 -19.9 -20.1
        2.88 18.88 19.93
        -6.31 2.28 -3.32
        -19.55 5.55 8.7
        -14.48 5.87 -6.6
        19.38 20.0 -12.17
        -13.28 -18.22 3.18
        -9.56 -11.61 -20.49
        -3.92 -7.2 8.58
        -17.92 -20.96 -21.63
        4.54 -21.53 2.0
        12.1 -0.64 19.3
        4.04 -2.71 12.75
        5.53 -10.86 3.86
        21.54 -5.17 10.8
        -8.43 -12.12 14.6
        -16.21 -12.78 7.93
        -20.86 -8.51 -1.62
        15.96 9.39 -0.57
        12.09 6.4 -5.7
        17.92 10.68 20.48
        17.79 10.81 4.08
        7.81 14.1 6.6
        -6.24 20.2 0.73
        5.71 8.08 -8.95
        -12.82 -11.78 -17.72
        -4.68 18.04 -14.93
        -18.25 -2.95 5.54
        -9.36 2.42 -12.53
        7.45 19.79 -8.12
        3.87 -0.57 -0.47
        -10.73 8.79 -16.61
        -17.5 16.89 -7.37
        18.64 -13.99 -16.84
        -19.84 2.54 6.74
        3.76 -7.34 11.79
        16.88 20.67 7.13
        8.98 17.27 -19.45
        12.81 -0.76 4.92
        9.03 -18.25 18.71
        -15.27 -5.1 18.22
        -8.93 9.07 -15.02
        15.15 0.51 0.68
        -7.26 -16.81 -8.44
        -5.95 11.88 -6.55
        -12.74 -14.99 -19.99
        12.17 5.53 -1.82
        12.89 -8.54 21.57
        8.61 -4.53 10.38
        -15.56 17.46 -20.29
        19.97 -1.78 6.73
        17.86 11.62 6.29
        12.05 18.74 -18.02
        4.09 -7.22 -2.71
        -2.32 -7.06 -12.48
        1.97 14.94 -5.29
        12.99 11.54 -1.1
        9.26 -5.39 6.2
        -10.22 9.5 20.42
        -3.61 16.55 13.68
        -14.49 7.18 -3.42
        16.88 -2.17 12.04
        4.56 8.49 -15.74
        12.01 20.26 -14.26
        -6.21 -15.82 -12.02
        13.49 -19.98 -1.64
        -6.22 14.49 9.32
        -1.82 1.49 -1.04
        12.1 14.99 -0.72
        -6.78 -5.37 18.98
        -16.99 -19.53 -6.52
        11.72 -11.16 19.07
        -5.91 -10.87 -17.11
        -8.48 21.51 19.53
        16.78 13.12 -17.67
        10.68 5.82 12.4
        16.02 -6.85 -8.87
        -3.03 16.08 -6.22
        17.94 21.43 -8.05
        5.16 18.96 19.97
        8.21 -20.67 2.07
        -4.39 0.65 16.71
        10.65 -13.05 -1.16
        6.07 0.96 14.58
        4.55 10.64 -3.88
        2.67 -2.98 -10.18
        7.09 -1.29 11.65
        14.3 -7.16 -18.35
        3.57 -20.06 -15.43
        2.63 -3.91 9.68
        -9.48 -9.89 -15.51
        -5.74 12.23 -18.86
        -8.72 -20.25 -18.23
        1.78 15.7 -15.22
        0.43 -13.85 19.77
        2.45 -5.86 12.96
        -11.14 -6.59 -13.62
        -8.26 14.59 -20.84
        -12.76 -17.21 16.4
        16.75 20.27 -18.58
        21.35 2.43 10.77
        11.52 6.69 -21.09
        0.33 16.31 4.88
        2.57 13.34 4.58
        4.74 -3.56 -9.79
        5.16 3.71 -8.15
        -10.62 12.5 -5.9
        -1.96 -14.56 -4.59
        -19.31 19.61 -11.6
        -11.27 7.45 -1.16
        -2.22 -3.15 19.5
        20.49 -21.1 1.98
        7.35 4.55 10.87
        -14.93 1.67 6.05
        6.31 -2.52 1.2
        -20.11 -14.6 -8.99
        12.2 14.7 5.32
        11.81 -20.19 11.88
        14.88 18.55 -6.27
        -6.8 12.54 14.47
        9.68 8.17 -18.26
        0.59 -3.25 -4.63
        20.19 -5.57 -12.18
        -0.45 13.44 -7.73
        11.44 10.24 18.59
        7.68 -2.63 9.69
        -3.29 11.95 8.54
        12.87 14.81 16.26
        16.37 5.15 14.87
        -5.26 17.21 21.05
        10.65 -8.04 8.92
        12.09 -8.05 5.38
        9.05 11.3 9.03
        15.4 -16.26 13.99
        -4.95 -16.95 -2.42
        15.3 18.02 -0.82
        -6.77 -6.98 9.78
        -14.22 -8.72 -10.25
        -3.2 -17.19 -13.31
        -10.38 -7.75 17.87
        -18.97 -5.77 -13.87
        -21.36 -7.31 9.51
        1.72 -21.11 6.8
        9.36 15.38 10.33
        -7.87 18.5 -4.4
        -3.18 5.46 13.18
        -12.38 -19.37 6.39
        0.8 3.57 0.89
        2.6 2.3 -9.95
        1.11 11.61 15.91
        20.5 -11.64 14.27
        12.03 -2.9 -7.63
        17.33 -15.1 -0.17
        -3.43 -14.78 15.81
        -4.01 17.29 10.19
        -2.06 8.07 21.32
        19.76 12.91 6.89
        -18.17 -3.28 9.11
        14.99 8.31 19.56
        14.95 15.52 15.42
        16.6 17.05 18.33
        18.64 7.53 1.2
        -3.81 -6.69 1.47
        4.15 1.14 -15.86
        -9.01 21.31 -21.54
        -8.41 -12.53 -9.86
        -0.37 -1.12 -10.09
        10.51 0.64 -6.9
        15.82 -3.43 -13.16
        8.84 -7.35 -8.92
        -4.89 -10.42 -2.91
        -10.87 -10.9 3.5
        20.89 -20.42 10.72
        -18.09 6.15 6.94
        15.32 11.47 -1.28
        4.19 -12.11 -5.8
        17.17 -7.16 18.31
        11.17 -0.14 -14.18
        -1.05 -0.99 14.85
        5.19 0.77 5.17
        20.55 16.22 -2.1
        5.17 -16.91 11.23
        -13.62 -3.54 -13.55
        -10.64 6.63 -17.22
        -11.71 16.95 18.76
        -6.58 0.17 19.5
        -11.71 -9.37 10.17
        -5.65 -10.01 -10.01
        17.98 14.47 -21.36
        17.78 21.14 10.4
        -12.88 -9.53 -11.96
        -6.69 21.09 -14.26
        7.9 4.13 8.55
        -16.98 -14.91 -16.87
        2.16 -8.71 16.2
        -3.64 -8.17 21.02
        -13.51 -13.07 -10.58
        -9.3 0.08 8.95
        0.08 6.83 -14.04
        -9.32 6.03 11.72
        -0.79 -19.92 -12.39
        -16.7 18.89 -6.59
        -5.9 -21.56 6.74
        11.51 16.44 17.55
        -20.2 12.24 -10.54
        4.24 21.15 16.78
        -9.41 -18.61 -19.63
        5.07 -4.13 15.6
        20.99 -7.58 21.01
        19.13 -18.45 -1.47
        -2.4 -2.29 6.83
        1.72 4.48 -9.33
        3.67 1.82 -8.13
        4.39 -4.53 19.75
        3.98 -18.07 6.29
        -15.39 3.0 2.7
        -18.45 5.76 0.3
        0.89 16.25 10.48
        6.91 -8.62 20.11
        11.72 11.43 3.85
        13.84 6.93 -6.98
        10.06 -9.88 7.66
        -20.69 -5.14 -12.12
        14.88 4.6 9.28
        -12.57 1.48 -5.19
        -7.73 1.45 5.56
        -0.16 -0.66 -19.01
        16.13 9.06 -4.32
        6.96 13.17 0.92
        7.78 -21.43 10.13
        11.59 9.43 -15.83
        13.87 -10.21 -20.53
        -3.0 -13.82 -13.54
        -19.95 7.19 -15.14
        19.91 7.2 12.13
        14.48 -12.76 0.78
        -10.62 -4.39 20.06
        9.87 -20.06 -1.31
        5.07 2.63 1.39
        -13.11 13.84 -19.69
        -14.26 -13.68 -1.78
        14.05 16.07 5.59
        1.11 -20.2 -20.48
        0.55 16.39 18.79
        21.09 12.45 -9.33
        8.68 -6.69 9.21
        -15.83 -12.66 -20.06
        1.63 0.81 16.09
        -0.9 2.83 3.46
        15.83 -11.05 4.32
        11.46 -3.52 -9.81
        17.2 -1.6 -8.47
        5.33 1.54 -17.86
        -2.71 3.49 2.16
        19.22 -7.14 5.15
        -12.22 -18.25 -0.64
        3.41 16.59 14.74
        12.98 9.86 -5.7
        -10.22 -6.26 14.15
        -14.96 8.97 -15.29
        -8.57 -20.85 14.84
        -3.44 -11.81 17.56
        -3.88 0.82 -21.2
        15.0 5.14 -16.22
        2.25 8.25 17.14
        12.43 13.05 0.58
        9.57 14.93 14.17
        3.62 14.81 -14.1
        -16.19 6.87 5.95
        16.19 -17.75 -19.6
        -7.62 -1.4 9.53
        11.16 7.7 4.63
        -11.91 6.9 9.35
        11.5 -20.95 18.22
        -14.14 14.99 10.31
        -20.54 21.22 -18.89
        -14.84 -6.73 -16.87
        11.49 -18.21 3.66
        -1.53 6.87 17.16
        -15.15 -5.02 10.03
        -18.32 2.99 -9.63
        -12.66 21.62 -17.28
        -16.29 -10.47 -20.71
        -0.95 -20.85 1.79
        -17.78 9.17 -9.83
        13.6 -15.96 12.69
        6.72 16.11 6.02
        -8.62 5.95 -2.52
        13.54 -9.64 16.0
        -8.4 0.5 -0.24
        -12.98 6.02 18.95
        -20.08 -18.61 -9.84
        4.91 -1.72 7.77
        -15.29 -14.7 18.02
        -8.54 -3.77 1.28
        -1.99 -8.15 -20.57
        1.88 -20.63 19.1
        1.4 -4.6 -3.08
        -5.88 -7.72 21.6
        14.35 13.44 -21.45
        -19.53 -1.9 10.43
        -17.98 -19.16 15.09
        -13.95 16.41 6.42
        19.49 13.99 -12.63
        3.52 -10.92 -16.87
        -21.34 6.23 -18.99
        -9.48 -3.85 -0.7
        -16.4 5.63 17.87
        13.84 10.29 -11.62
        14.12 -9.51 -18.25
        18.99 -1.41 -13.22
        -6.69 6.1 14.65
        -16.52 -14.27 14.5
        -21.08 -12.5 12.9
        14.06 -5.92 -8.18
        2.56 -19.67 21.11
        -15.06 -20.62 -10.42
        -17.93 3.92 5.97
        9.87 15.11 -1.14
        -11.81 -20.52 -0.37
        -3.85 -18.34 12.58
        2.97 -10.94 -4.0
        2.14 -2.07 -7.93
        2.38 0.26 14.02
        4.95 -8.26 18.97
        11.13 -18.87 -4.25
        -10.24 4.0 20.37
        -0.07 -7.3 -8.19
        -4.69 -12.64 15.8
        -2.86 9.57 19.56
        10.8 3.15 2.27
        12.81 7.77 -2.3
        -1.17 -10.27 -9.25
        -2.7 6.92 4.16
        -11.39 -9.76 14.26
        -18.54 10.67 3.96
        11.86 8.19 -4.42
        7.67 19.91 8.9
        -10.25 -12.19 11.06
        6.74 8.39 -6.78
        -0.57 7.05 15.05
        -20.16 21.51 -11.07
        16.57 -14.68 -21.07
        3.07 -14.53 6.33
        5.19 -19.32 -4.63
        -4.16 -18.1 10.32
        -2.96 0.78 11.85
        10.54 21.44 10.96
        -14.96 7.4 -13.56
        -9.3 -5.35 -2.68
        6.82 4.03 -21.31
        8.47 12.76 -12.82
        -4.42 0.9 4.93
        -11.54 5.73 -13.43
        18.75 -1.89 -16.44
        -13.33 -12.57 14.94
        9.09 -4.18 -12.72
        -7.79 -19.62 18.87
        20.7 15.89 -19.8
        -15.07 2.43 19.95
        -5.18 -19.11 -10.54
        17.77 15.76 8.65
        12.39 16.25 -12.94
        11.0 15.85 3.72
        13.96 -5.19 18.07
        -11.13 20.14 -13.62
        -2.55 -20.75 5.41
        11.36 -14.93 -9.8
        -12.94 2.54 -11.91
        -13.91 20.77 7.48
        -14.72 -17.76 9.35
        14.22 13.84 9.47
        13.58 -6.46 -11.57
        5.92 8.39 21.61
        6.96 15.94 -11.2
        -20.74 19.8 -7.28
        -18.35 3.01 16.07
        20.27 7.08 2.67
        13.68 2.28 -20.86
        1.56 10.09 4.66
        7.7 -6.19 -4.58
        -19.07 -1.62 20.07
        14.87 1.94 13.08
        -4.79 14.56 4.72
        -18.55 12.64 -7.1
        -1.7 3.27 5.5
        21.43 5.42 5.62
        -19.23 2.33 -11.81
        10.36 1.59 -4.58
        -9.4 18.3 11.03
        6.6 -10.43 7.37
        18.45 12.36 -6.22
        18.61 3.98 -20.72
        -16.56 -11.99 5.65
        -7.77 4.7 17.92
        4.42 3.76 -21.07
        -15.83 9.23 6.37
        -19.46 8.99 -7.93
        -8.53 -4.23 4.96
        10.28 2.12 6.6
        -7.98 4.46 20.27
        16.32 17.71 -12.32
        -13.39 -12.79 -19.61
        0.27 18.96 -0.01
        15.67 -11.33 -0.39
        8.23 2.91 12.26
        17.61 -8.61 2.43
        -17.1 17.43 8.75
        8.4 18.52 -21.46
        11.24 -1.3 -20.7
        5.81 -11.2 -11.73
        14.07 0.27 -8.63
        18.08 1.24 20.0
        8.83 10.89 4.08
        -1.02 -18.95 -8.36
        -21.61 -6.66 17.04
        -16.99 -1.64 -7.96
        -0.3 -7.73 -15.02
        18.15 -8.58 16.66
        4.51 18.02 -15.92
        -13.63 -1.85 5.89
        -20.26 0.75 -1.82
        10.62 20.37 14.11
        -9.7 11.14 -12.11
        17.55 2.1 -8.59
        18.98 8.05 14.14
        -12.6 -1.82 0.46
        -4.9 -21.6 14.82
        -15.8 -19.02 14.5
        -6.06 18.38 -2.85
        -21.09 -16.86 -19.65
        -5.1 16.47 -9.98
        3.05 -2.46 -14.44
        -13.85 4.18 -15.78
        -18.46 0.9 -19.2
        -19.07 7.35 -12.97
        -2.29 -14.89 17.84
        3.47 15.31 -18.3
        -18.94 15.03 0.14
        7.3 17.46 -7.41
        2.34 -8.71 3.85
        17.44 11.71 -8.24
        7.91 4.27 -13.0
        -21.55 -11.37 10.67
        0.34 -1.8 -0.36
        -1.55 3.35 0.23
        -17.22 19.76 13.62
        12.18 -20.98 -18.87
        -17.17 -2.74 20.95
        14.71 -14.37 -15.26
        7.01 7.0 6.3
        -11.9 2.66 4.1
        -13.84 18.45 -13.82
        6.28 -10.89 -13.99
        18.24 -6.71 -7.9
        -14.43 14.05 12.41
        -11.85 -2.45 19.89
        -2.56 -15.63 -7.72
        21.04 -16.95 -6.93
        14.62 1.51 18.35
        17.88 -1.87 16.27
        -18.53 12.72 19.34
        -13.2 7.07 -5.26
        -7.71 8.41 4.2
        -1.1 4.99 13.98
        -16.72 20.24 1.12
        -20.9 -10.37 -15.97
        12.76 15.28 8.97
        -5.13 -7.34 -17.01
        -17.09 -2.16 -15.37
        1.52 20.71 0.51
        2.42 -8.39 10.06
        -6.51 -5.31 12.76
        4.0 -8.34 -13.87
        20.43 11.06 16.2
        5.93 17.11 9.73
        -12.79 -14.92 1.67
        -7.7 7.64 -1.0
        -4.27 -20.09 1.9
        6.01 20.01 17.93
        -12.46 7.44 -8.96
        6.38 -3.78 -13.97
        -7.33 21.4 2.52
        17.07 0.0 15.16
        -18.24 -18.59 -0.34
        4.2 17.76 13.09
        18.1 19.75 16.2
        14.4 -10.06 -10.39
        10.93 -17.86 -20.3
        -18.89 -16.74 -14.4
        -8.56 -16.06 14.64
        -21.61 12.25 -20.09
        18.77 13.08 -0.52
        12.56 -18.06 7.16
        -8.22 10.74 21.49
        -8.93 -8.8 16.35
        -6.64 -21.16 16.14
        13.37 -20.66 -20.68
        -15.36 -10.06 -1.42
        -18.15 -14.29 -4.88
        2.18 2.34 8.05
        -12.86 -13.66 -6.69
        21.14 12.71 -3.2
        7.15 1.56 1.8
        1.65 -7.12 17.71
        -0.01 14.23 -15.61
        12.27 -4.27 15.12
        10.03 17.4 -1.46
        11.53 19.54 4.18
        -20.05 -15.43 1.09
        -21.01 20.54 19.64
        -1.25 -21.18 -7.78
        -6.92 18.13 20.71
        10.89 -12.05 5.07
        -14.05 -15.5 21.42
        -2.4 -5.65 -16.61
        20.71 -19.91 -12.75
        14.31 10.02 4.82
        -6.08 18.2 3.88
        19.63 -1.94 -11.2
        -8.87 -20.37 2.03
        5.95 11.92 -2.43
        -14.41 9.04 8.0
        19.97 20.4 -15.92
        6.68 -17.06 2.75
        -7.09 -12.44 16.43
        15.66 -1.72 10.13
        7.37 -2.84 19.97
        -13.04 1.36 7.38
        17.82 -3.47 4.1
        12.22 10.73 -21.3
        -2.42 -9.28 -12.72
        1.7 12.48 1.16
        19.01 -14.81 -20.91
        -21.31 4.35 14.1
        3.82 4.62 -18.92
        -10.3 -15.17 -19.98
        21.61 -5.83 -4.01
        -15.81 -15.57 6.29
        2.71 19.46 12.43
        -2.23 -2.58 -6.58
        5.11 20.24 3.67
        6.9 11.34 -9.8
        9.08 -21.32 20.83
        -4.9 -12.92 -20.16
        -20.25 -13.72 20.81
        -1.68 -10.52 5.39
        0.31 16.37 8.26
        -18.52 4.03 -1.08
        -3.13 11.97 19.46
        -15.34 -5.0 -13.4
        18.25 -5.17 -4.55
        16.17 1.38 -6.15
        3.34 18.69 3.39
        9.81 8.31 -14.85
        6.9 16.43 0.23
        0.46 19.88 -12.1
        5.54 19.26 9.37
        -20.98 -9.3 5.18
        13.77 10.09 9.16
        6.38 -3.99 -17.44
        -19.52 16.76 1.76
        -11.73 -6.35 -5.58
        -10.28 -16.64 -16.37
        -17.8 17.23 3.3
        -0.11 -14.03 14.01
        7.82 -12.8 -2.52
        15.9 14.75 13.24
        0.09 5.27 -1.89
        -2.72 -12.03 -20.06
        -7.42 -2.53 -3.67
        18.58 16.42 -20.56
        -1.84 12.7 -18.53
        -5.98 -17.25 17.15
        6.9 5.81 -14.47
        6.06 9.44 -14.18
        -9.59 -13.76 -11.48
        -4.23 -5.03 -19.79
        -14.18 18.55 -9.45
        9.99 11.7 -11.31
        12.17 1.92 -1.03
        -15.52 2.57 -6.82
        -9.14 18.18 -20.1
        9.14 14.04 -3.19
        -16.0 -19.27 -0.63
        10.16 -10.5 15.63
        -11.37 17.77 9.67
        2.73 -5.35 -7.12
        -4.86 -18.08 0.8
        17.86 4.88 -18.62
        -12.33 -20.74 -4.84
        -6.15 -9.5 -7.76
        -8.98 13.73 -4.8
        -19.22 -13.99 17.15
        -8.58 -12.89 5.41
        16.93 -3.57 0.7
        10.96 -9.03 -11.35
        14.32 -17.71 20.31
        15.58 15.18 -17.91
        16.9 -17.11 3.86
        3.59 -10.26 -12.3
        -7.72 14.93 2.8
        10.57 20.63 -10.57
        0.89 6.71 -5.16
        -5.76 7.4 -4.01
        16.27 7.7 17.6
        10.22 3.55 -20.27
        -14.4 -3.18 10.59
        4.1 -17.21 -16.86
        19.76 18.36 17.12
        -5.24 8.99 19.43
        14.68 -16.46 -8.15
        -7.45 5.85 -4.42
        -5.97 -2.28 -21.4
        -7.29 -12.06 12.67
        -15.64 -21.12 -20.76
        -16.99 -6.56 -20.54
        16.29 -12.94 20.8
        5.47 19.38 -3.55
        1.18 19.67 3.86
        12.9 19.31 -3.18
        -13.67 3.97 13.61
        -2.3 18.75 5.16
        -4.62 8.47 -9.87
        -11.04 -6.9 -3.48
        11.54 -18.87 -2.01
        19.89 15.49 9.68
        3.28 -5.57 15.09
        -12.47 8.28 6.63
        -20.65 -3.15 -7.56
        -15.18 19.58 -15.2
        0.76 -19.07 7.7
        19.59 17.85 -7.09
        15.39 -10.79 14.98
        6.26 3.57 7.28
        -21.03 -12.48 8.6
        -15.58 -13.48 -10.35
        5.05 16.09 7.75
        -21.57 -18.1 -15.55
        13.14 2.82 -13.86
        12.2 4.72 -4.16
        -16.52 11.1 -9.96
        -2.3 -19.9 3.19
        -14.71 -1.09 17.5
        9.83 -1.6 16.97
        -15.04 6.24 10.78
        -10.24 -0.87 -2.15
        3.08 6.13 20.02
        18.87 -14.51 7.67
        -14.05 -6.95 10.99
        7.69 5.6 20.31
        7.5 4.29 -17.61
        19.51 -4.4 9.83
        15.73 -12.36 -2.56
        -21.17 -5.75 0.83
        -11.17 10.54 18.48
        -21.39 -0.36 1.62
        -13.16 5.5 21.2
        -19.42 9.34 -15.85
        -9.12 11.95 -17.77
        17.89 -11.86 -7.69
        -13.87 -20.43 2.86
        -1.27 2.88 14.99
        13.03 -13.32 16.35
        9.98 -5.02 18.11
        -2.33 -4.91 1.29
        -16.14 -7.74 -11.05
        6.16 -20.36 0.96
        -6.62 1.15 17.38
        6.75 11.58 17.13
        10.7 10.37 14.27
        -10.11 16.06 -7.75
        -0.18 17.49 15.22
        -21.09 13.75 13.16
        0.68 -14.08 0.51
        -8.29 -1.67 2.5
        20.24 -5.39 6.25
        6.03 -14.03 21.07
        8.81 0.17 -11.09
        -13.78 -14.26 6.68
        7.68 -2.39 -5.96
        -4.12 19.14 -21.34
        -15.32 -6.99 21.3
        9.23 8.1 -10.65
        -19.61 -3.49 7.28
        -7.63 11.64 17.98
        -18.53 -0.3 -9.06
        3.83 19.32 -9.94
        -11.48 3.67 -19.59
        15.61 -9.03 -8.6
        1.89 -5.58 21.1
        3.71 5.2 -9.15
        20.71 21.56 -11.25
        -10.81 15.91 16.68
        -2.81 14.96 -3.16
        -20.31 7.29 5.18
        -11.18 -19.01 -5.92
        3.96 -16.7 -10.94
        9.76 -20.51 -11.34
        9.02 8.43 -6.5
        8.62 20.36 1.74
        -20.08 -17.66 -17.5
        -17.24 -1.25 14.79
        12.97 1.68 9.82
        -17.94 -0.76 11.67
        1.54 10.81 20.01
        5.96 -20.76 -10.28
        20.05 -13.51 -3.74
        20.82 -9.41 -12.55
        21.01 6.78 -15.34
        17.66 -10.12 -10.89
        -5.7 -20.45 3.37
        -15.32 17.08 -12.76
        -19.97 -8.21 -9.93
        13.8 5.87 2.83
        -15.71 -2.25 15.91
        -10.08 16.79 5.71
        4.93 7.39 19.59
        16.87 12.02 10.19
        -4.71 -5.08 18.14
        -8.94 -16.57 6.11
        2.85 -16.41 19.1
        -19.96 -2.15 -4.37
        -0.12 -14.5 17.68
        18.67 -0.61 -3.22
        -0.1 -1.56 -21.25
        -4.06 9.08 -19.12
        9.72 10.68 1.79
        8.61 4.85 -2.78
        -11.68 21.36 17.53
        -7.08 -11.39 4.56
        -1.25 0.95 13.54
        -2.61 -17.78 -2.64
        -5.67 -8.52 -13.62
        -13.87 13.91 6.65
        2.23 -17.36 21.03
        -2.77 -2.27 14.72
        6.05 -1.31 -13.48
        -8.45 -3.66 9.56
        -20.54 13.51 2.66
        -6.2 17.82 15.0
        -16.5 -6.37 -2.37
        -21.17 -0.75 -17.78
        10.88 -7.66 -9.45
        1.73 9.19 -21.49
        -20.76 13.74 0.28
        3.83 -11.33 0.68
        13.95 -1.5 13.9
        -17.92 5.67 2.63
        -18.36 1.64 -17.04
        -10.85 5.62 18.8
        -19.64 -9.4 14.31
        4.1 9.7 1.48
        6.19 7.6 -12.94
        3.45 12.24 19.48
        -7.23 0.14 1.61
        8.4 -8.59 -6.89
        -12.01 -9.29 -15.59
        1.95 -15.52 8.08
        13.3 -14.33 -4.88
        -11.01 -12.97 -17.08
        -4.8 -21.01 -13.78
        -3.9 19.23 17.13
        -6.74 5.53 -8.02
        7.14 8.17 11.84
        0.75 9.82 -8.48
        -5.69 -2.97 -10.28
        -14.23 -20.53 6.62
        -0.36 -6.5 4.15
        5.16 16.39 -7.28
        20.8 10.97 -14.33
        -14.8 10.46 -6.46
        -6.54 -17.11 -15.73
        -14.65 10.32 4.75
        0.73 -0.44 -11.98
        17.37 -11.3 7.65
        -2.97 21.44 9.5
        -17.82 -4.3 -20.63
        -12.82 12.66 0.99
        2.16 -7.21 8.21
        -20.24 19.38 -13.66
        19.25 -11.2 21.02
        -17.33 -2.47 12.97
        14.46 -1.2 -16.07
        14.22 -3.84 -7.72
        -19.44 20.84 3.65
        -4.85 15.51 17.55
        -9.18 -16.91 -13.07
        -6.74 -17.32 1.79
        -15.83 10.04 -19.97
        2.05 1.41 -16.59
        -17.49 -20.91 -17.22
        8.47 -16.79 20.35
        -5.01 -8.26 -11.27
        -15.96 17.16 20.8
        20.51 17.11 -14.36
        -6.71 -11.4 9.54
        -15.85 -4.06 2.77
        -18.66 -7.73 21.44
        2.43 9.33 -15.84
        9.39 6.51 3.24
        8.31 -20.1 -7.44
        -4.66 6.49 -2.19
        21.23 -5.99 -17.48
        -5.79 -14.86 -5.49
        11.48 6.21 -12.62
        5.16 -13.55 6.53
        -0.25 0.56 2.59
        -15.47 12.65 15.79
        -13.96 8.98 1.58
        19.12 -10.85 6.16
        0.63 3.39 -3.14
        -1.77 1.9 -21.23
        -18.98 8.16 6.76
        -12.59 -14.84 -14.3
        -9.73 6.7 -20.78
        4.74 -0.52 -11.72
        9.23 -13.78 -20.48
        -9.19 -9.92 14.49
        13.93 19.27 4.13
        -9.83 20.21 18.06
        3.31 12.99 -8.5
        1.66 -2.5 -16.25
        6.2 -16.16 20.38
        2.82 7.53 9.05
        9.88 -19.41 0.89
        18.68 -5.41 15.6
        21.47 11.99 3.75
        -10.43 16.58 -11.33
        -1.64 -16.99 -4.69
        -19.37 16.76 19.27
        14.64 -21.03 16.69
        10.06 -10.34 11.59
        9.35 -7.29 -3.1
        -11.54 15.35 20.52
        -1.05 21.25 12.82
        8.19 17.23 10.49
        20.31 21.42 -0.15
        -20.46 0.35 -19.65
        -18.2 17.14 21.09
        -14.83 8.02 -20.47
        20.24 10.58 11.97
        8.35 -7.09 -17.53
        10.91 18.22 -13.72
        14.86 -18.29 3.71
        -15.77 13.87 -12.15
        -11.08 1.86 19.95
        -14.6 10.9 -8.64
        16.31 18.63 21.35
        0.27 -12.98 16.05
        9.61 17.24 14.11
        -17.22 13.47 -5.52
        18.89 13.46 -2.63
        1.34 -3.43 3.0
        17.45 -20.66 6.32
        4.88 -19.51 21.2
        -5.85 8.99 -17.56
        5.43 16.56 -14.33
        14.41 -9.32 0.35
        -17.43 -17.42 -7.15
        2.11 15.38 3.79
        7.36 -3.0 -21.04
        3.19 -4.19 0.05
        9.08 16.51 17.56
        8.63 -13.74 -15.15
        -15.15 -1.14 -6.71
        -12.81 -7.31 -2.25
        -16.24 -11.6 18.91
        0.27 -8.87 10.86
        -5.23 -18.99 -18.74
        18.22 18.42 -10.83
        0.8 16.3 21.19
        -16.31 -0.36 10.21
        1.92 8.15 -9.92
        21.02 -10.24 1.77
        -7.59 -0.55 -4.63
        14.56 -12.92 14.62
        15.57 19.71 -13.26
        -12.7 10.86 11.07
        -8.3 -14.23 17.67
        16.48 13.23 0.01
        3.19 6.86 -19.18
        21.52 -15.03 19.54
        -13.91 -0.81 3.76
        7.13 14.88 -16.56
        -17.05 14.2 -14.16
        13.87 -8.97 10.64
        -12.5 -7.68 17.16
        19.41 -8.22 -9.12
        21.62 -19.12 14.15
        -11.57 -17.18 12.78
        -8.82 -14.09 1.4
        0.79 10.01 17.81
        3.91 -7.75 15.38
        9.16 -9.0 0.43
        11.5 21.55 5.48
        7.43 -2.18 13.84
        12.83 -11.55 -10.0
        -21.26 20.48 13.78
        -7.56 -7.77 1.09
        1.88 21.14 14.18
        -19.03 21.3 -4.14
        13.1 -8.76 -2.85
        -8.17 1.86 -2.14
        -0.46 -6.0 -13.63
        17.74 8.66 4.32
        6.89 -0.18 -17.9
        3.25 4.47 -1.61
        2.16 18.96 -13.27
        -15.1 7.89 12.35
        8.51 -15.0 6.08
        16.28 -19.0 7.28
        10.18 6.45 -7.19
        19.64 -17.34 -16.02
        -2.86 -9.79 -19.08
        -7.0 -4.22 21.12
        6.19 0.25 -21.34
        -13.44 -2.92 -7.14
        15.44 -6.28 15.16
        5.46 3.89 -17.62
        5.33 -16.3 -7.55
        -4.47 3.62 -13.8
        6.42 -10.17 -9.57
        0.78 20.13 6.02
        -13.18 -10.65 -1.25
        1.41 -19.26 -12.18
        7.31 -12.1 8.87
        -3.45 -20.59 -10.44
        15.93 -11.45 -10.96
        5.19 -11.36 -18.43
        -17.05 1.21 20.69
        3.81 14.06 8.56
        -8.05 -5.77 -4.44
        11.25 17.9 -3.53
        -12.83 9.26 -5.91
        -9.61 8.93 -4.53
        3.84 -14.33 -5.37
        -18.21 13.19 21.61
        -18.82 11.97 -2.56
        8.18 0.72 11.5
        12.63 -4.36 3.07
        16.1 1.29 8.29
        8.9 -13.24 19.23
        16.2 10.02 9.29
        0.44 -9.46 -18.12
        -18.54 -6.56 19.32
        18.94 -6.79 -1.27
        -12.96 17.89 -1.67
        -3.67 -1.62 1.97
        -8.91 -3.33 21.1
        -11.26 -1.45 9.01
        13.73 14.61 -19.41
        21.31 -0.11 -0.55
        20.96 -20.66 19.59
        18.46 10.75 -20.46
        -20.63 21.32 16.02
        19.45 11.16 0.45
        -21.25 1.13 -11.85
        21.2 13.15 -13.66
        19.86 -12.6 -20.35
        -20.12 3.26 21.31
        16.67 -2.89 17.88
        -5.94 -8.18 8.12
        7.21 19.39 -12.14
        -12.03 -11.45 5.49
        -18.65 18.99 -21.01
        -2.59 -0.47 -10.52
        2.65 -17.74 8.26
        -17.7 13.02 11.06
        16.67 -1.34 -13.24
        -0.33 -10.7 3.37
        1.28 -4.72 -10.46
        -21.05 -3.17 -20.27
        -6.27 -16.88 -4.48
        -16.4 -14.31 -8.34
        11.86 1.74 -15.24
        -1.71 15.03 -4.99
        -12.17 -7.59 14.68
        -18.11 -14.76 -13.5
        -9.68 -14.02 12.15
        -3.89 11.8 -15.44
        -7.78 11.14 -15.88
        -1.33 8.61 -2.25
        15.74 9.04 -8.27
        9.37 6.89 0.81
        -3.65 14.1 -14.6
        -19.1 -16.92 -2.06
        -1.89 5.06 -1.11
        -5.34 20.97 21.2
        18.42 8.79 -4.73
        11.92 -10.81 -7.93
        -13.13 -21.15 -9.36
        -13.7 -3.81 -19.57
        -3.91 5.19 -20.22
        -8.42 -3.24 16.26
        16.27 0.31 -7.77
        -7.94 2.67 13.63
        -6.36 -1.97 -1.86
        -8.09 10.25 -3.47
        3.11 -10.74 12.87
        15.87 -4.17 15.01
        8.22 18.28 12.6
        -1.13 8.74 -7.98
        1.41 -19.39 -4.97
        -15.36 7.99 20.54
        -20.1 16.16 16.03
        -9.93 -8.81 3.96
        4.81 -21.55 -14.1
        -15.81 -20.07 -2.92
        -7.41 16.26 13.82
        12.25 -9.02 19.39
        -8.01 16.65 1.28
        10.34 -16.28 3.34
        -6.15 18.62 -7.5
        -8.15 20.68 -5.58
        -0.92 1.36 6.44
        0.0 -13.76 -5.59
        14.92 -3.43 -5.74
        -11.57 6.86 11.49
        15.28 -0.52 7.37
        7.87 17.97 -1.3
        -11.65 13.43 6.61
        -9.26 -1.5 17.64
        13.19 19.79 -16.23
        8.67 -17.87 -20.94
        17.02 2.0 18.11
        12.53 3.13 20.56
        14.61 3.16 -6.76
        6.69 -8.39 -16.71
        11.23 -2.35 20.54
        10.82 12.42 1.99
        6.35 3.06 -10.04
        -0.37 -15.63 7.58
        -18.71 20.45 20.56
        9.42 21.2 -17.22
        -11.81 -21.6 -19.54
        -17.08 10.92 18.49
        -21.39 2.47 -20.14
        -9.92 21.01 -7.24
        -4.65 -17.51 6.66
        0.81 18.06 -18.01
        -7.41 8.25 6.58
        11.6 -19.02 -10.89
        8.01 -20.13 -20.61
        18.43 18.19 21.12
        -2.08 -18.1 -20.04
        -9.42 13.13 -13.23
        1.76 7.53 14.92
        -18.78 -12.05 16.3
        17.04 16.39 12.1
        16.95 -20.68 0.75
        -2.3 -11.02 -11.03
        -20.87 -14.8 12.67
        16.6 -14.67 -2.3
        5.76 17.54 -12.34
        10.49 -16.43 10.38
        -7.77 8.97 -8.03
        -10.06 19.79 -9.42
        0.51 19.31 -16.28
        7.8 9.72 16.55
        -14.01 -1.45 -12.31
        15.39 11.32 -8.17
        19.23 -15.15 20.14
        1.45 -5.29 16.47
        -3.24 19.02 -11.61
        -10.4 -3.63 8.46
        -15.88 16.6 2.37
        1.85 -5.36 4.12
        7.84 11.7 -18.33
        -9.57 -20.84 9.24
        17.27 5.31 -6.12
        15.42 -16.13 -17.99
        18.58 -3.57 12.72
        13.7 6.42 -20.33
        8.18 16.82 19.81
        7.85 -0.35 14.55
        10.78 8.94 6.55
        -3.32 15.13 6.24
        10.23 13.91 -6.74
        -5.92 11.77 16.43
        9.8 10.28 -7.52
        15.24 -16.45 -21.27
        16.36 -18.82 19.47
        15.52 -8.19 -2.99
        -19.84 16.98 -17.46
        -15.16 3.34 -18.87
        5.35 -17.58 -9.2
        -12.51 -1.87 14.63
        17.9 -3.67 14.83
        -1.06 21.28 -13.13
        -5.98 -3.83 -16.56
        18.21 -0.69 -10.19
        6.0 -3.69 13.59
        1.62 -15.59 13.66
        12.01 16.08 -4.42
        10.51 -11.05 -4.59
        1.47 6.2 -15.77
        -10.09 -5.35 18.03
        18.9 10.35 -11.45
        -18.83 5.49 -16.29
        2.77 -20.27 2.97
        4.83 -0.94 11.62
        -20.22 13.57 -12.42
        16.77 -12.78 -6.03
        15.59 -1.73 1.53
        -5.61 4.74 5.74
        -0.87 1.73 -19.27
        17.99 -18.64 13.97
        16.51 18.52 -4.5
        -18.52 15.4 -18.69
        -4.23 -13.37 6.19
        -9.84 16.0 -19.71
        12.73 8.46 19.36
        8.36 -5.19 -8.48
        14.86 -3.4 16.9
        14.13 1.85 2.52
        -0.25 4.01 -8.46
        -13.34 -10.18 8.56
        -14.74 4.09 -5.2
        -4.42 -5.31 -17.55
        13.2 -1.59 9.85
        2.4 2.37 19.08
        12.33 -1.23 -3.47
        -0.58 -12.47 12.45
        -9.82 2.2 -18.85
        -17.3 -12.41 13.15
        -18.9 12.8 -14.11
        -4.99 -13.93 2.42
        13.74 18.46 -9.79
        -0.04 -12.87 -16.84
        7.37 -4.05 6.06
        12.4 0.34 3.06
        3.56 -10.14 9.11
        3.96 -1.27 -6.57
        -19.5 -10.49 -5.91
        -10.5 -12.24 -12.99
        -6.48 -20.99 11.27
        -4.79 20.77 -4.54
        7.14 20.94 -14.1
        -16.23 -16.25 9.79
        -3.25 9.88 7.55
        14.44 -4.62 -4.0
        16.33 13.78 8.76
        -2.52 -8.26 0.41
        4.8 -8.47 -5.99
        -10.94 20.91 -15.88
        17.42 -3.45 -1.5
        -8.62 -16.5 -4.41
        -18.35 -3.42 -7.28
        -18.79 -5.41 -16.12
        -15.07 -18.83 -20.27
        -9.11 19.19 16.01
        13.82 11.72 -4.72
        17.86 -8.81 -18.2
        17.08 2.5 4.92
        -18.64 13.13 -18.0
        -16.82 -17.63 -19.35
        -0.0 5.4 8.99
        17.32 -21.23 4.25
        -8.06 1.81 3.13
        -2.21 -8.06 17.75
        9.56 14.32 2.74
        -5.47 -7.49 -6.53
        -16.29 -14.09 -14.83
        -21.3 12.65 16.87
        19.87 0.5 5.72
        -4.83 -4.96 -2.87
        -0.95 -6.9 11.79
        0.45 -2.75 14.12
        -7.49 -8.92 13.02
        17.37 -8.45 -1.27
        20.82 -20.84 13.04
        4.77 11.83 -20.68
        7.74 -21.48 12.5
        -6.56 -19.22 6.81
        2.67 -19.58 -8.77
        -10.75 -17.13 19.64
        20.34 5.25 15.53
        -19.27 -6.79 17.13
        -20.48 -0.8 5.39
        -13.44 8.08 -1.65
        -3.52 -14.08 -17.28
        -2.64 -19.55 9.11
        -11.21 -1.41 -21.33
        -16.09 -14.36 -21.52
        14.83 -12.49 19.44
        -1.86 -5.98 -7.67
        16.05 11.02 -17.4
        -5.67 15.72 12.75
        20.71 7.29 -13.18
        7.83 9.58 -17.55
        17.45 -0.85 21.02
        -18.95 15.31 -20.97
        -1.37 19.92 8.6
        12.72 -17.7 -7.42
        -17.75 -15.93 -20.88
        5.96 -17.42 -5.66
        18.6 -21.27 -5.66
        3.73 6.99 4.17
        -12.87 -15.98 14.35
        -9.46 -9.54 9.94
        -4.7 8.05 8.61
        -9.71 -7.36 -19.68
        8.62 -15.99 2.03
        -15.62 -16.64 -17.52
        16.42 -8.58 19.93
        -17.62 16.0 5.36
        -13.72 5.41 -13.92
        5.71 10.54 -5.98
        -15.54 8.88 3.09
        12.85 15.71 -8.16
        1.7 14.93 1.48
        -1.14 14.43 5.51
        -1.92 -10.68 -6.98
        13.94 2.46 -8.84
        -15.93 3.2 -15.21
        19.12 -11.11 -3.63
        8.61 -9.37 -1.93
        9.96 -14.29 11.4
        -0.59 -2.91 3.98
        11.96 -19.37 1.84
        -13.1 -20.83 19.25
        -13.31 10.83 -12.24
        8.34 -18.38 -14.65
        17.54 -9.65 21.54
        -5.52 -12.98 -18.07
        -1.39 20.03 -1.22
        6.06 -6.15 -20.63
        13.05 4.91 -15.21
        2.34 4.58 16.27
        20.36 9.7 -17.76
        -15.42 4.94 -3.13
        -17.9 -19.88 -4.27
        -21.08 7.12 -2.5
        -11.44 -10.3 -5.29
        -20.01 7.26 -6.31
        -5.42 -16.9 -9.99
        8.93 10.31 -9.77
        1.45 4.45 -4.97
        6.69 -20.38 -3.14
        20.2 -8.87 6.32
        -20.93 6.22 -9.95
        -3.46 -13.46 19.29
        20.23 -4.1 -4.26
        17.47 8.75 -19.76
        -0.92 -21.58 16.65
        -14.49 18.71 11.66
        7.31 -5.18 12.19
        -6.17 -16.92 -19.69
        2.8 -7.14 -5.88
        0.2 -17.26 20.84
        -21.59 -15.1 -12.44
        -0.42 9.22 -20.48
        -18.73 20.36 -0.1
        20.02 -7.95 8.5
        -21.18 2.02 -7.23
        1.8 14.34 -7.54
        -20.99 7.16 9.36
        -0.63 20.66 20.92
        -1.0 16.74 -18.8
        -3.97 -2.81 -20.19
        -20.66 16.04 13.8
        16.02 -18.12 -1.49
        -15.91 2.85 -9.22
        15.78 1.65 -1.32
        -3.22 -12.65 -15.38
        -11.9 13.85 16.37
        -0.69 8.28 1.25
        -13.6 13.04 -8.34
        20.49 14.76 -0.16
        6.32 -6.19 0.86
        -15.87 -9.62 -18.6
        16.39 -13.62 10.4
        9.67 -2.49 3.74
        7.35 -12.37 3.37
        -11.74 -3.64 -0.74
        13.41 8.53 12.69
        20.0 7.5 15.98
        9.09 11.98 -14.88
        10.5 20.96 7.43
        18.58 -20.71 13.96
        -13.67 18.1 18.1
        -18.03 0.95 17.26
        -1.54 14.89 -14.13
        7.31 -3.01 -0.71
        -13.21 5.3 15.4
        -18.56 0.39 -0.57
        1.88 -14.42 2.24
        -5.26 -1.48 19.92
        -19.21 7.24 3.18
        17.83 13.56 13.98
        -11.87 -10.69 12.05
        -13.96 0.85 -7.02
        -14.03 17.64 13.59
        2.52 -4.77 6.24
        12.98 17.11 20.72
        18.16 1.68 -17.46
        15.33 11.12 -13.29
        4.02 6.95 -12.73
        10.4 -14.38 -18.57
        -3.78 16.36 19.43
        -21.32 19.56 17.51
        6.2 19.77 -21.24
        -7.21 -16.13 -17.77
        -2.26 -16.81 -11.25
        18.32 -16.45 -12.87
        -1.64 -13.44 -18.57
        -15.83 -10.85 -13.0
        13.03 1.13 12.0
        -20.37 -20.71 2.15
        14.28 12.84 -6.58
        -5.49 7.07 6.66
        -18.08 15.22 16.3
        -4.96 10.69 -20.31
        9.44 18.51 9.15
        18.63 -12.32 -18.5
        11.35 -6.68 11.88
        12.49 -0.68 -7.19
        -21.09 19.46 3.56
        -19.1 -15.01 11.1
        -17.07 19.08 -19.36
        9.44 -11.99 8.43
        2.11 17.93 15.9
        -8.54 -1.12 19.86
        3.67 6.38 -14.98
        -17.16 13.62 8.82
        1.86 -6.33 -8.88
        15.73 10.82 3.1
        -6.63 5.8 -15.93
        -3.29 5.82 2.18
        -1.02 14.3 -11.83
        3.04 -2.9 18.56
        7.67 -14.36 12.09
        -12.63 8.68 12.27
        15.26 14.93 -6.26
        -18.51 -14.3 19.36
        10.93 19.92 1.93
        -9.46 7.52 19.2
        15.58 -5.7 1.06
        -18.44 15.75 -2.15
        -14.44 2.45 17.73
        7.04 7.59 0.23
        12.59 16.46 -20.43
        18.19 -12.76 9.09
        -19.52 -20.68 -0.04
        15.93 15.5 -0.17
        -21.52 -8.53 3.03
        20.97 -20.54 -5.54
        -15.26 0.5 -0.69
        17.68 7.4 21.63
        14.17 -0.36 19.97
        -8.28 10.34 3.31
        0.17 3.03 18.31
        13.33 -0.02 -21.01
        10.25 -5.99 -13.66
        -11.68 -8.05 5.37
        -2.46 6.91 11.5
        16.81 -20.59 21.1
        -1.8 -13.73 -2.41
        -8.13 6.73 -14.42
        -1.23 -13.54 1.8
        -15.27 -13.31 16.03
        4.68 -13.32 -2.19
        5.04 -3.52 -3.52
        -16.39 12.55 -17.75
        -0.98 -11.36 -2.54
        -4.77 -20.19 21.3
        -15.36 13.92 -19.51
        -10.06 -12.23 -8.32
        -12.29 -4.0 15.1
        -4.18 13.08 17.37
        4.84 -10.05 -20.46
        -15.79 -7.16 4.49
        -3.89 -9.88 4.89
        19.09 -2.39 21.63
        -0.68 -4.84 10.72
        -1.27 7.12 -9.64
        20.84 16.64 -8.7
        15.07 -19.22 -0.06
        -14.57 -17.76 21.03
        8.43 11.27 21.16
        -16.59 -18.77 4.42
        10.62 -3.45 10.59
        12.6 4.56 15.2
        8.53 -17.18 9.33
        8.58 15.06 -12.79
        8.55 -10.32 -19.73
        19.01 17.72 0.91
        -18.41 -21.18 16.23
        -10.55 17.65 15.04
        19.31 1.07 -9.48
        -5.65 -11.48 -6.89
        18.86 -19.13 -17.13
        -16.07 -18.55 -10.39
        -14.96 -4.7 -1.97
        8.28 -0.58 6.41
        -3.05 6.97 -16.53
        -8.26 -0.45 -6.74
        15.94 2.05 -18.1
        10.21 -17.01 -15.34
        -0.04 11.91 -15.31
        -12.73 3.09 -1.94
        -15.19 15.89 -4.52
        -3.44 -0.49 20.53
        -7.88 -17.67 -21.13
        -20.79 -14.38 -16.92
        -7.21 -14.94 -7.23
        9.58 8.47 -4.26
        -5.09 2.99 -1.63
        7.14 19.09 3.2
        -10.76 8.21 8.07
        8.04 -11.44 -15.49
        5.31 15.39 -21.49
        6.22 18.41 -17.48
        13.75 4.15 -19.45
        -9.74 -13.99 14.24
        15.99 20.86 9.21
        12.09 -19.63 -8.54
        -16.58 -13.61 19.6
        8.52 -0.81 -7.44
        -10.44 2.57 11.61
        -0.47 18.03 3.78
        -6.9 17.12 -5.83
        19.43 16.58 -10.35
        1.08 -8.49 -6.64
        -3.2 21.29 16.39
        4.18 10.11 10.27
        -15.6 -7.98 2.2
        -20.56 12.62 9.41
        13.59 -15.83 1.25
        9.37 20.74 -4.11
        -10.07 10.68 14.74
        -14.64 5.58 6.98
        9.18 -3.63 -10.28
        -15.69 14.57 1.36
        -2.77 6.39 -6.29
        -21.44 -19.74 16.34
        3.31 -6.54 19.52
        17.98 -5.02 17.86
        21.01 9.07 -2.33
        20.24 0.9 16.31
        -16.56 -9.29 16.05
        -5.21 -3.2 2.91
        -1.25 13.36 19.95
        -10.66 -21.47 1.47
        2.48 8.36 -1.93
        20.76 3.33 -1.2
        12.99 3.87 1.87
        19.94 18.86 -17.71
        -0.11 21.08 -20.2
        -19.19 20.88 -16.86
        12.28 5.6 -10.52
        -13.35 9.96 17.78
        -3.17 21.43 11.9
        20.71 -7.61 -2.86
        -19.78 -13.36 -18.78
        -7.79 -5.65 -11.82
        -4.86 0.28 1.24
        -7.69 0.33 -14.24
        -16.55 17.81 -15.86
        1.53 19.46 -19.68
        -19.58 15.41 6.62
        -4.55 21.55 4.87
        -11.72 15.48 10.2
        -11.02 1.58 -8.61
        -0.96 19.41 -5.69
        -6.32 16.77 -18.86
        15.74 13.01 2.21
        15.77 -16.68 -6.22
        -0.65 -0.3 -14.0
        21.5 1.07 -14.19
        5.4 -15.85 16.88
        6.44 5.91 18.64
        5.05 -0.03 -8.1
        -4.8 0.22 -19.16
        18.26 0.79 3.8
        21.42 19.07 21.19
        18.8 -9.11 10.02
        3.38 -3.16 -19.85
        5.79 -1.07 19.98
        4.18 -2.37 0.91
        -7.05 6.32 -12.09
        -10.91 -20.63 15.65
        13.74 -21.43 -8.47
        -7.37 18.28 10.0
        4.35 -7.71 -19.83
        12.54 20.21 18.59
        17.76 -9.8 -8.74
        -17.08 10.81 10.9
        -1.12 1.89 -3.35
        3.0 -18.76 15.57
        -14.4 1.4 -10.38
        13.2 -2.43 15.85
        21.22 15.86 -4.25
        4.26 -11.95 -15.04
        -0.2 -7.69 0.79
        17.83 -0.24 12.99
        7.8 11.02 0.57
        -14.02 -1.97 19.57
        -2.17 15.12 -8.11
        6.7 8.23 -1.95
        15.96 3.03 -9.97
        16.14 -10.23 -17.58
        1.49 -10.68 -7.35
        -6.03 7.76 21.22
        1.26 -17.36 15.37
        7.26 -6.54 20.55
        9.25 9.14 20.51
        3.58 7.22 -8.47
        4.46 -5.18 -16.79
        14.65 -14.13 -8.41
        13.13 8.13 1.89
        17.04 21.46 -2.29
        -7.28 15.04 -8.22
        -2.39 21.5 -19.0
        0.17 -19.13 0.38
        -9.94 -2.92 -20.19
        -8.02 -9.39 -4.96
        6.55 -8.68 3.51
        -4.23 4.05 17.4
        -20.29 2.75 15.55
        6.04 0.02 6.92
        10.03 -11.64 -20.9
        5.24 -15.53 3.46
        -16.15 8.62 -17.21
        3.87 9.11 7.59
        -21.39 -15.31 4.77
        2.5 -3.94 11.81
        -3.09 0.98 18.76
        -12.59 -9.43 -20.89
        -9.53 -2.71 12.9
        -5.3 7.95 17.46
        -13.72 13.98 -4.56
        -3.54 -19.94 -15.43
        9.21 -4.07 2.12
        13.12 6.36 4.99
        -2.54 15.11 20.95
        -9.31 8.22 -6.64
        -15.99 21.02 -18.69
        1.54 -16.53 3.34
        0.22 -21.11 -4.13
        13.13 -15.32 -20.79
        -2.66 10.71 3.78
        -4.91 -9.26 -18.33
        3.92 -13.33 21.18
        5.52 -8.91 8.37
        1.04 3.01 -19.93
        1.78 1.31 -6.88
        -6.14 9.5 9.92
        17.88 21.02 -15.42
        12.34 20.29 8.64
        -3.14 17.4 6.7
        -19.0 -15.68 7.36
        -8.32 -12.79 -0.31
        8.5 14.09 12.03
        -15.89 21.3 -13.71
        21.21 20.49 7.92
        2.15 8.93 13.18
        -0.89 -3.98 -7.7
        14.53 11.13 -21.22
        -7.53 -10.29 17.4
        -18.41 5.76 -6.89
        -5.44 14.02 -7.36
        -15.27 -5.36 7.7
        -0.32 -19.44 -16.77
        -6.9 1.67 11.75
        -16.51 6.07 20.11
        11.41 18.45 0.11
        10.4 -12.92 1.08
        -14.61 -21.11 14.11
        12.54 -10.69 -17.06
        5.09 18.85 -19.31
        4.36 6.86 -4.68
        -4.48 10.35 2.26
        4.03 10.98 -7.62
        -9.3 0.56 -3.5
        20.77 0.2 10.54
        -21.57 9.16 16.16
        -14.25 4.65 17.41
        -17.65 18.82 17.09
        13.26 -2.78 1.43
        -13.13 -1.45 -20.19
        11.68 2.49 -12.02
        19.02 -10.8 -15.36
        -12.59 -16.06 6.47
        -12.03 -4.76 -12.4
        -11.63 -19.32 -20.36
        19.66 -16.26 15.82
        11.27 14.21 7.45
        -6.44 -9.38 -20.24
        -19.65 2.53 10.78
        -0.46 -17.27 11.05
        -1.58 -9.71 -17.25
        20.85 -2.61 13.02
        11.97 10.23 -7.81
        14.22 -5.19 20.31
        21.46 -9.15 -8.57
        -10.14 5.05 -10.11
        -18.72 -7.5 -17.3
        -8.72 12.21 11.59
        6.43 6.5 -5.42
        -7.88 8.74 -18.79
        -3.11 -6.42 6.7
        -19.8 -7.2 7.93
        -15.69 -19.14 7.77
        -5.25 7.56 -15.89
        -5.84 -6.37 0.42
        0.63 7.19 -2.73
        -4.55 14.06 -12.45
        -14.14 8.74 -9.72
        11.22 1.79 13.2
        7.9 -4.06 -15.77
        -10.47 12.42 1.3
        5.88 20.83 13.12
        5.09 13.82 -17.12
        -20.51 -7.08 -20.82
        6.27 -11.79 -3.3
        12.95 16.94 7.51
        -8.97 -4.49 -10.24
        -20.69 -0.5 9.21
        -11.92 -19.46 -10.11
        17.89 -17.75 -8.42
        -10.73 -15.33 0.52
        -12.16 16.37 -6.95
        16.74 -0.15 -20.31
        21.51 -2.65 -5.62
        21.51 17.12 9.51
        -5.05 -6.88 -1.73
        14.94 15.69 -2.44
        10.16 -13.5 6.82
        13.02 20.5 -10.4
        15.47 9.18 16.1
        -19.2 -11.63 14.04
        2.79 3.42 4.5
        -2.87 -0.17 -12.98
        -21.13 15.7 2.99
        -6.6 15.98 4.65
        -12.26 -11.69 0.35
        16.79 -17.53 12.71
        -4.03 18.88 -3.99
        13.22 -17.27 5.05
        -6.98 -2.38 4.26
        -2.71 -16.29 -21.46
        -11.53 8.98 14.32
        13.29 -10.89 -14.75
        -9.92 -17.86 14.1
        -4.54 -0.66 -2.6
        14.03 -20.37 11.26
        19.99 -19.96 17.52
        12.31 11.1 17.02
        -11.18 13.22 -14.62
        17.06 -8.27 13.07
        15.96 -2.02 19.95
        18.29 2.04 -5.46
        20.59 -8.67 16.61
        -2.62 18.47 -15.59
        -9.14 -7.45 -12.55
        -13.65 8.61 -11.95
        -10.19 -18.11 -4.15
        1.09 3.99 3.13
        4.41 -20.72 -18.9
        -17.19 -6.75 -7.72
        -12.27 21.15 -3.35
        -9.09 -10.71 19.11
        -11.68 10.34 -19.78
        -2.55 1.04 -6.91
        16.57 -4.24 -11.07
        21.47 -15.46 -10.1
        -1.32 21.59 -5.59
        -19.83 -2.89 -2.37
        -13.94 13.69 2.64
        -7.93 -19.18 8.56
        5.97 4.51 15.16
        2.61 -20.53 -10.95
        5.15 13.05 -0.42
        -14.82 16.3 17.24
        5.47 14.42 -10.92
        -18.12 -2.79 -12.01
        -13.62 10.32 -1.75
        11.35 -11.67 -13.7
        -7.51 -18.85 -7.44
        -21.6 -21.36 -7.7
        -14.53 -8.73 -6.59
        -0.1 8.68 5.23
        11.73 -14.62 2.38
        15.27 -12.2 -14.53
        16.12 15.94 -8.23
        -4.52 -1.6 16.24
        -5.27 -15.1 7.24
        14.14 -20.12 -3.95
        -2.27 16.45 -1.75
        -2.84 11.35 11.83
        18.26 9.27 -0.37
        -3.61 -12.01 -7.31
        6.89 21.45 -6.63
        12.55 -21.63 1.54
        5.53 -1.8 -17.34
        -19.69 17.97 17.36
        -18.1 -6.97 9.31
        -3.29 -8.87 10.01
        3.46 1.54 17.17
        6.4 -19.39 15.53
        -4.27 16.9 1.33
        16.24 5.7 -2.26
        -20.03 -4.83 -21.21
        15.28 2.26 -13.76
        -11.66 -14.1 15.1
        3.84 11.9 1.23
        11.77 3.57 -18.45
        -0.1 -16.02 -11.95
        5.23 10.91 18.81
        -17.67 -12.11 0.49
        -9.98 4.33 17.15
        -16.3 -6.76 19.09
        0.2 12.39 21.28
        -6.24 -8.36 2.84
        9.61 -11.42 -2.49
        -16.99 -11.72 -11.16
        13.29 -3.2 -13.34
        2.14 -1.46 -1.8
        -17.51 -13.38 11.13
        -15.92 6.63 3.57
        -12.51 13.98 -6.39
        -19.09 -3.17 1.52
        -0.01 -11.7 -6.1
        14.88 18.01 -2.85
        3.33 -19.13 -3.42
        1.83 -12.15 -0.47
        -16.28 15.27 -6.41
        -7.41 3.65 6.62
        3.98 1.22 -3.42
        3.8 2.67 11.37
        -4.83 8.84 13.74
        14.38 8.48 -10.14
        -6.25 11.61 2.88
        -10.23 -6.09 -15.79
        -2.9 -7.86 -1.74
        20.24 2.54 -10.93
        -10.94 -7.74 21.58
        2.65 -19.99 11.6
        -12.21 20.75 -6.33
        1.98 3.39 -18.0
        2.88 15.05 10.59
        -0.17 -11.66 20.28
        -4.35 14.11 -21.13
        12.31 -6.33 -18.71
        0.4 -8.84 -20.4
        8.38 -16.43 -11.27
        -18.78 -9.39 -15.87
        15.47 -18.55 11.0
        -9.19 -14.87 -5.97
        3.91 -0.69 9.58
        -10.31 19.35 21.54
        -3.93 10.42 5.53
        12.08 8.54 14.43
        -20.81 9.74 12.09
        -12.29 -3.69 5.57
        -14.74 7.5 0.04
        -19.59 16.48 -6.79
        15.38 -6.02 -2.69
        -14.82 -10.22 -8.46
        -10.17 -21.57 -12.73
        -6.25 3.72 -15.01
        -6.31 8.52 -11.69
        7.95 -2.13 5.18
        -20.68 -3.42 11.52
        13.49 -11.0 -6.25
        15.33 16.86 20.28
        3.39 -6.8 3.27
        -7.95 -5.98 -19.04
        -9.33 17.54 -9.42
        -4.08 -4.7 4.14
        -19.6 -17.95 -4.12
        1.2 -7.75 -16.75
        4.87 -17.5 15.31
        6.26 14.61 12.6
        0.67 19.22 -7.13
        15.7 -19.48 -10.68
        -7.75 15.72 -0.81
        14.17 11.91 -10.04
        6.13 -13.5 -11.66
        17.23 -3.5 -16.64
        3.43 -17.05 -2.05
        -9.22 12.74 -0.83
        5.27 10.45 4.68
        -15.82 2.91 9.16
        15.33 -10.49 10.94
        9.84 -10.02 -14.83
        10.98 -14.19 15.63
        -20.37 -2.92 -12.46
        4.61 5.15 7.57
        -2.73 -3.7 10.57
        10.38 8.22 -12.66
        -1.2 -11.55 -15.77
        -11.57 -8.56 -8.43
        20.1 -12.65 -7.69
        -17.67 4.78 -14.48
        -0.22 -21.05 14.55
        -14.93 21.19 16.09
        -4.77 -15.22 -20.89
        7.3 7.2 4.06
        6.13 1.61 8.43
        2.29 20.63 -16.6
        4.24 15.78 18.16
        3.41 -10.82 2.97
        -9.12 -9.67 7.68
        19.1 20.22 -19.21
        17.55 -5.39 -2.37
        21.0 4.72 17.65
        7.68 16.0 -14.77
        1.81 -20.51 -16.85
        15.96 -8.8 4.17
        -16.0 -2.24 9.12
        2.17 0.75 20.56
        17.54 -13.88 12.4
        -1.62 -9.11 15.72
        -20.64 -18.85 -12.16
        -3.59 -12.38 10.11
        -1.12 5.73 20.81
        -21.53 20.83 10.09
        5.0 -16.93 18.7
        17.99 8.0 -8.54
        16.17 -4.58 -19.98
        5.7 15.85 3.87
        -7.32 -7.46 -17.37
        10.23 15.76 -20.65
        8.24 -10.22 16.73
        18.28 3.91 14.92
        -2.67 15.8 9.62
        -10.62 -17.39 1.01
        -6.29 2.15 -16.64
        -3.99 19.55 -19.05
        -20.5 -5.56 6.43
        4.7 -1.03 -15.26
        7.02 8.72 7.72
        7.3 -8.49 15.52
        15.32 -4.49 7.34
        9.35 -17.45 16.66
        18.59 2.49 -12.56
        -18.07 2.47 -20.98
        -17.58 3.61 3.59
        -19.49 17.11 -13.86
        -11.12 4.77 -21.31
        -4.01 15.73 -0.51
        -9.61 10.78 -1.78
        -1.91 14.94 13.25
        -8.47 -14.56 8.86
        5.32 12.41 15.44
        10.79 20.45 -18.97
        -11.24 -2.63 -2.75
        0.17 -10.76 -0.55
        -4.66 -11.46 -0.79
        12.52 -1.89 -11.35
        11.1 -14.67 -5.7
        -15.67 -2.41 -9.6
        -13.39 -12.09 -8.6
        -4.66 -10.11 2.71
        -14.44 -3.84 -4.03
        -18.84 -12.3 5.72
        8.3 -9.07 6.6
        14.91 7.47 -16.7
        14.35 -4.44 11.8
        7.09 6.24 16.38
        19.32 0.74 -13.99
        6.16 -11.77 14.45
        9.35 6.81 -20.02
        11.37 -6.86 -16.6
        -15.53 -2.02 6.94
        9.33 2.26 16.26
        -5.41 -3.89 7.95
        -19.48 -20.28 -19.99
        -14.23 -19.31 -4.37
        7.49 -17.5 -0.75
        -9.05 11.82 4.86
        -12.75 -12.49 -2.84
        9.81 -13.02 -10.05
        18.35 -15.92 11.82
        -12.36 -19.2 11.95
        6.48 9.48 1.48
        -11.34 0.89 -17.54
        -9.51 0.83 6.68
        -9.01 13.42 18.54
        20.74 -20.64 5.26
        20.34 -20.85 -16.68
        -8.27 16.89 19.63
        13.83 -21.28 5.87
        11.59 18.37 13.75
        -16.52 -11.57 16.59
        20.48 7.47 -17.52
        -20.01 -6.47 -0.91
        -20.89 -18.74 10.0
        -0.08 15.11 14.68
        -12.61 15.45 3.24
        -2.42 2.88 -17.68
        11.5 -8.67 10.94
        -14.07 20.9 20.95
        1.69 -12.76 5.9
        21.41 15.04 17.02
        4.38 3.55 16.62
        19.85 -21.02 -9.18
        -14.24 5.19 -17.8
        -8.07 14.23 7.88
        -15.43 -11.68 -4.88
        -2.36 4.14 -14.07
        1.01 -4.11 18.19
        -1.36 20.42 -15.45
        -8.01 10.1 -11.23
        16.06 18.83 17.04
        -17.69 -20.34 8.32
        18.61 19.09 9.8
        17.67 16.51 -4.41
        -16.07 0.78 14.64
        7.82 -14.24 -10.24
        -9.16 8.95 -9.74
        10.64 -19.8 19.84
        3.23 21.19 -5.96
        -3.24 -20.88 -4.78
        -18.03 -17.73 -9.23
        9.72 -8.6 -18.83
        10.22 4.15 -13.07
        -9.11 -9.16 -11.1
        -11.73 -14.35 3.7
        18.76 7.13 -6.34
        -3.34 18.01 -9.66
        -19.15 -9.08 6.65
        -12.58 -1.32 -10.41
        -8.06 -11.98 20.87
        9.93 -0.76 0.5
        3.45 -11.53 -7.75
        8.7 18.08 16.12
        -21.23 3.23 -14.81
        7.12 -19.61 17.96
        7.53 -12.4 12.91
        -6.63 3.24 2.25
        -14.62 -17.57 -13.87
        -8.17 7.23 13.21
        -3.44 2.61 15.65
        3.37 -15.26 -7.31
        -7.68 -9.26 -0.66
        0.78 0.79 12.44
        15.55 -10.33 18.61
        -7.27 -5.11 8.37
        19.56 -17.77 6.77
        2.78 -10.89 7.02
        -19.62 -18.4 13.59
        -4.73 -6.75 3.44
        -3.08 13.54 -10.8
        18.07 13.11 -15.73
        10.24 17.7 5.03
        -4.01 19.34 3.97
        -13.36 0.87 -1.8
        -9.41 -8.49 19.77
        3.33 14.51 -11.8
        -12.35 -18.18 -13.5
        -19.08 -0.98 1.31
        -20.36 -11.31 21.43
        -11.41 -5.88 8.3
        21.18 -10.17 -0.51
        -20.46 18.85 1.23
        -3.3 -19.8 19.78
        -1.67 17.44 8.38
        2.2 -6.54 -3.73
        -1.13 8.8 7.43
        -4.06 10.34 -6.43
        -17.26 -15.75 -11.74
        -0.86 18.8 12.99
        -15.22 17.77 -1.45
        -8.06 -9.74 -17.36
        9.19 1.17 5.13
        -3.84 -20.08 17.55
        4.99 -13.23 0.11
        -21.13 -3.53 0.73
        -1.81 -5.22 20.47
        5.19 -5.32 -11.32
        -15.01 -8.75 9.52
        -1.69 -17.57 13.09
        -5.74 -6.31 -11.34
        -5.83 -8.79 17.71
        18.65 7.59 18.05
        13.65 -21.25 -17.09
        4.81 16.22 11.51
        0.09 16.36 -5.38
        20.09 -3.01 -19.79
        -7.7 -14.78 6.68
        5.2 6.39 0.66
        10.15 6.92 17.72
        -8.38 3.09 -17.39
        -11.71 -0.02 -0.6
        -20.15 -5.85 -9.87
        9.64 5.07 19.27
        -9.31 19.95 -1.48
        -6.88 -7.68 -4.53
        -15.23 0.04 -17.62
        -11.46 7.8 -12.35
        8.41 17.23 -5.29
        10.0 5.11 -0.85
        -20.84 -6.72 -6.12
        6.98 -4.5 2.3
        8.7 6.55 11.27
        -6.98 17.22 -9.07
        20.49 -17.76 2.01
        -13.66 21.43 -0.47
        2.65 -1.96 14.49
        -7.83 -2.6 -9.46
        9.26 11.93 -20.0
        -13.81 -9.44 17.6
        14.52 10.84 -15.46
        13.82 18.79 7.98
        -17.11 16.38 12.44
        16.11 -12.77 -12.58
        -4.34 -0.35 9.19
        16.13 -7.98 7.82
        14.48 -14.28 18.06
        -0.82 -2.85 17.69
        9.11 -1.1 8.51
        10.69 -2.05 12.4
        4.39 0.96 12.98
        -20.78 16.31 -15.42
        -21.43 -1.28 -11.13
        20.07 15.79 1.83
        9.53 4.31 3.69
        -11.78 17.61 7.28
        -11.31 12.57 14.4
        21.02 0.9 14.06
        0.73 -8.26 -11.59
        1.65 7.83 -17.43
        4.49 1.87 -11.21
        -7.46 12.82 -14.33
        -13.68 -11.89 12.51
        -1.94 -18.92 -14.03
        -17.22 -4.37 0.87
        12.47 -11.84 -20.84
        10.24 12.09 -3.75
        5.58 11.23 13.39
        -13.84 -15.89 -6.14
        12.55 -13.3 3.99
        2.82 7.7 -6.21
        16.72 -15.86 -11.26
        -16.65 -20.13 -15.19
        15.91 -6.42 -11.04
        12.35 18.02 11.72
        -13.35 -13.23 4.85
        -11.08 15.34 12.51
        8.34 2.66 -16.05
        -8.43 -11.08 10.96
        18.06 16.25 6.36
        3.39 -16.29 4.82
        -9.81 13.69 13.18
        -19.15 -11.3 7.82
        -21.04 -16.12 -1.03
        -13.74 18.98 3.67
        12.03 -0.95 17.03
        -6.97 20.05 -1.46
        1.46 -1.46 7.01
        3.14 -13.55 -8.94
        5.74 -14.8 10.51
        5.34 -17.32 -21.05
        7.72 -14.47 -4.24
        2.22 9.99 -6.58
        -4.55 1.99 2.67
        -3.97 13.75 -18.99
        3.28 -1.46 20.13
        -8.52 6.15 -6.51
        19.76 -13.04 -15.04
        -16.03 -4.51 16.07
        -4.4 3.58 13.68
        19.7 13.64 12.68
        13.66 -1.86 -1.76
        0.33 3.16 -6.43
        4.68 -20.22 -12.11
        -21.62 -9.97 -18.16
        -0.54 -2.32 -15.56
        -13.56 21.41 9.6
        -12.05 -14.78 9.78
        -19.79 5.8 12.83
        -19.44 -10.39 17.64
        -12.77 14.9 -14.31
        -15.79 3.58 6.98
        -16.11 -3.17 -0.68
        13.3 -7.26 -6.63
        15.74 18.52 -19.66
        -4.77 -14.35 9.33
        -12.31 9.73 4.95
        -18.46 -4.96 15.76
        -10.61 -1.27 -11.34
        13.57 8.65 -15.26
        20.94 4.67 0.4
        15.03 -0.49 5.13
        -10.82 -14.33 -7.44
        12.71 6.75 11.43
        -3.8 6.35 16.82
        18.54 15.9 -2.48
        -17.92 12.37 6.97
        -4.87 -16.49 13.51
        9.73 -20.87 9.19
        -19.1 -15.96 -16.5
        6.97 -18.16 10.81
        -19.29 -20.45 -12.9
        14.08 -5.77 -0.75
        5.31 -2.91 -5.84
        10.65 -3.86 -1.55
        -20.02 -4.95 19.74
        -2.16 -5.76 -20.41
        15.31 -16.96 16.11
        4.48 -2.67 4.37
        1.28 -1.1 -3.88
        -20.83 -17.07 -13.57
        -9.72 -12.15 -15.11
        14.48 -13.07 -6.46
        3.78 -13.71 11.08
        8.16 -1.56 -9.76
        17.34 11.4 14.32
        3.57 19.93 -14.81
        -6.29 -0.43 5.73
        -19.72 4.12 -13.23
        -17.8 -20.77 10.49
        12.4 -4.91 10.54
        -11.75 20.33 12.77
        19.95 -6.9 -15.77
        11.26 -3.95 6.94
        -12.75 3.56 -4.26
        18.67 -10.53 2.12
        -16.21 -16.99 17.71
        -20.11 9.03 8.43
        15.03 -7.54 12.0
        13.25 0.97 16.41
        5.66 -6.31 10.94
        -10.69 -15.33 -1.84
        -15.83 -12.11 -2.56
        -9.5 -3.48 -3.8
        -11.29 2.4 6.36
        19.77 -5.12 -19.15
        7.66 -9.56 11.56
        -17.11 0.04 -2.02
        21.16 14.31 -8.0
        -6.45 9.05 -2.5
        -3.27 -10.31 0.9
        -11.64 -14.74 -10.97
        -0.29 -5.43 0.4
        -17.02 -10.89 -16.84
        21.55 18.1 5.51
        -15.94 18.16 -10.96
        -14.07 -5.09 -21.62
        -11.87 -21.58 3.47
        -5.15 -13.82 -12.34
        21.59 8.98 5.05
        17.88 -14.52 16.08
        -5.43 13.49 12.99
        -12.48 -12.6 -13.88
        -19.04 6.54 -18.26
        13.04 -18.23 -5.06
        3.5 17.95 -11.66
        10.98 -4.02 -5.66
        -0.21 -17.79 18.59
        -11.92 -11.62 -21.23
        -20.64 -1.29 -21.45
        10.3 4.36 5.93
        13.64 16.45 -6.12
        5.73 -1.48 -9.87
        2.76 4.22 6.83
        -21.0 -12.29 -0.94
        16.22 5.5 2.78
        19.4 -10.33 -17.65
        -16.7 12.11 -1.66
        -0.56 -3.46 -9.94
        -1.43 8.72 3.5
        -2.06 18.86 20.91
        9.48 -6.37 19.81
        -18.61 -17.29 1.68
        -20.68 6.12 -12.21
        -0.21 10.84 -13.14
        -7.2 12.17 -4.47
        9.72 -0.14 -20.02
        18.97 5.12 9.31
        -17.98 -21.18 -7.95
        12.45 -7.68 15.51
        9.66 -8.19 -13.15
        -20.35 -17.73 17.25
        17.33 12.85 -4.2
        -6.62 -20.99 -18.62
        15.29 18.74 9.68
        -18.79 4.68 10.81
        19.3 16.13 -5.7
        -4.91 -1.79 -16.02
        -10.42 9.65 -13.46
        -15.83 19.73 6.53
        8.12 9.86 -15.26
        -13.64 -0.06 -3.81
        13.46 12.92 17.77
        11.87 -17.28 13.81
        -2.02 -21.09 -16.74
        -0.23 18.21 -4.12
        18.42 -4.53 20.89
        -18.1 9.57 0.62
        -1.49 -6.4 -2.63
        13.41 -13.41 -19.64
        -12.45 -10.84 16.21
        -13.82 -16.87 -3.96
        20.59 -12.24 16.68
        12.26 -14.4 7.66
        9.09 -15.31 -16.77
        -0.54 -19.02 -21.3
        -13.18 -5.42 6.76
        -4.39 -16.72 15.68
        20.74 3.37 2.28
        19.84 -3.38 5.31
        -20.7 10.26 3.41
        -6.75 3.99 -0.12
        -6.33 -11.21 -4.6
        10.65 13.41 -10.21
        1.19 10.2 -2.74
        -10.3 1.54 2.77
        19.56 9.05 8.48
        -13.19 19.8 16.53
        13.38 -14.85 5.55
        -5.46 -17.19 -13.68
        10.56 -10.59 1.75
        2.66 21.06 8.52
        -20.68 -0.55 -15.47
        -8.71 5.56 9.51
        -13.25 12.14 12.95
        -12.76 19.49 10.75
        -11.77 -17.13 -2.74
        -15.48 -0.67 -11.08
        19.42 3.7 -17.36
        16.29 -0.24 -11.43
        -21.21 1.21 5.16
        -4.29 -2.85 18.42
        -14.79 -18.35 16.6
        5.22 3.0 -4.13
        -8.24 -20.31 -10.6
        9.36 -2.83 -0.0
        8.59 0.49 -16.65
        8.99 -3.09 15.25
        -0.91 12.56 10.92
        -6.97 11.9 -10.37
        7.11 -13.59 -0.37
        -10.15 -3.11 6.24
        -10.2 -11.8 6.97
        10.12 20.04 -21.43
        13.15 -17.29 17.11
        -11.96 -15.73 18.25
        15.16 11.69 11.85
        -15.33 -10.12 5.23
        9.89 15.35 -5.02
        19.58 13.91 20.29
        14.5 2.61 8.63
        -21.13 15.28 -21.48
        -2.57 12.51 15.79
        """
        self.pairs="""
        0 2143
        0 3105
        0 319
        0 1848
        1 3833
        1 1690
        1 3175
        1 1589
        2 1096
        2 2197
        2 2763
        2 339
        3 2963
        3 851
        3 1185
        3 1833
        4 2424
        4 2762
        4 2145
        4 3616
        5 1152
        5 1270
        5 390
        5 3388
        6 3904
        6 58
        6 3043
        6 2783
        7 2091
        7 1334
        7 2150
        7 2945
        8 1111
        8 2587
        8 102
        8 2998
        9 806
        9 1210
        9 3940
        9 2337
        10 1735
        10 2001
        10 1605
        10 3398
        11 116
        11 2117
        11 98
        11 3412
        12 1826
        12 1346
        12 2974
        12 3207
        13 1001
        13 1537
        13 2746
        13 2853
        14 23
        14 2861
        14 1113
        14 1188
        15 1168
        15 2580
        15 3503
        15 1937
        16 1531
        16 1355
        16 3632
        16 2719
        17 1597
        17 715
        17 2696
        17 746
        18 1355
        18 3026
        18 1874
        18 406
        19 534
        19 706
        19 278
        19 1136
        20 3169
        20 2090
        20 1848
        20 3650
        21 1153
        21 3069
        21 2270
        21 53
        22 2679
        22 3779
        22 2432
        22 816
        23 1742
        23 3899
        23 2984
        24 990
        24 3922
        24 1123
        24 2714
        25 3789
        25 2495
        25 1628
        25 765
        26 1036
        26 1272
        26 2310
        26 3420
        27 35
        27 3193
        27 144
        27 2501
        28 1493
        28 3112
        28 1919
        28 1287
        29 2622
        29 3858
        29 3324
        29 3633
        30 3278
        30 3446
        30 1966
        30 1736
        31 3324
        31 705
        31 1234
        31 3498
        32 3366
        32 2515
        32 2241
        32 1588
        33 2455
        33 1401
        33 422
        33 166
        34 1002
        34 789
        34 479
        34 1505
        35 585
        35 366
        35 3274
        36 2199
        36 2952
        36 2232
        36 1491
        37 1885
        37 2246
        37 724
        37 677
        38 281
        38 2969
        38 2235
        38 2427
        39 3468
        39 2458
        39 3884
        39 3624
        40 3522
        40 1321
        40 3426
        40 3159
        41 513
        41 1962
        41 2305
        41 886
        42 3496
        42 2517
        42 48
        42 479
        43 2917
        43 788
        43 3500
        43 2271
        44 3958
        44 2688
        44 2272
        44 2321
        45 2125
        45 2739
        45 2176
        45 327
        46 849
        46 1003
        46 2099
        46 2763
        47 2338
        47 674
        47 2205
        47 480
        48 1094
        48 70
        48 2516
        49 2168
        49 1095
        49 3209
        49 3574
        50 1734
        50 3477
        50 2724
        50 1910
        51 2062
        51 2730
        51 1960
        51 2298
        52 329
        52 1640
        52 1683
        52 3923
        53 698
        53 3760
        53 647
        54 3529
        54 3641
        54 3081
        54 2409
        55 1101
        55 2350
        55 1038
        55 1961
        56 2030
        56 2200
        56 3206
        56 1031
        57 529
        57 1793
        57 2711
        57 3526
        58 3629
        58 243
        58 3209
        59 2991
        59 2168
        59 1900
        59 214
        60 871
        60 4053
        60 1102
        60 4040
        61 2601
        61 192
        61 1307
        61 3650
        62 2338
        62 195
        62 2801
        62 3077
        63 874
        63 2910
        63 3015
        63 514
        64 215
        64 3858
        64 3658
        64 2101
        65 1918
        65 3369
        65 2789
        65 1797
        66 786
        66 297
        66 2617
        66 3794
        67 3796
        67 1048
        67 891
        67 3549
        68 3857
        68 3716
        68 2117
        68 3960
        69 540
        69 2467
        69 3414
        69 1245
        70 549
        70 2710
        70 2113
        71 3506
        71 1440
        71 1127
        71 3045
        72 3758
        72 1364
        72 1082
        72 1083
        73 1808
        73 2913
        73 2312
        73 3813
        74 1121
        74 4000
        74 175
        74 2283
        75 3203
        75 180
        75 3579
        75 3538
        76 1721
        76 3119
        76 3633
        76 1585
        77 1082
        77 2454
        77 858
        77 2797
        78 3308
        78 3939
        78 3275
        78 1441
        79 2105
        79 3377
        79 2841
        79 3216
        80 1753
        80 1536
        80 194
        80 1409
        81 3129
        81 1375
        81 2228
        81 2777
        82 2084
        82 3719
        82 3086
        82 427
        83 1735
        83 2563
        83 3748
        83 3483
        84 1767
        84 2960
        84 1726
        84 1347
        85 1370
        85 3330
        85 1925
        85 3624
        86 3207
        86 3983
        86 3697
        86 2817
        87 1853
        87 975
        87 482
        87 3676
        88 254
        88 633
        88 580
        88 846
        89 3139
        89 3311
        89 3772
        89 3338
        90 928
        90 1230
        90 3931
        90 3850
        91 3837
        91 1113
        91 3509
        91 2166
        92 3662
        92 2041
        92 1299
        92 874
        93 657
        93 1317
        93 3785
        93 570
        94 1997
        94 1522
        94 1339
        94 3661
        95 2416
        95 3089
        95 3590
        95 1073
        96 2286
        96 1042
        96 1170
        96 2221
        97 1689
        97 3224
        97 2222
        97 3605
        98 3857
        98 2193
        98 618
        99 1381
        99 3748
        99 3720
        99 1118
        100 1796
        100 2081
        100 1456
        100 4020
        101 1740
        101 2088
        101 1274
        101 3892
        102 2343
        102 2609
        102 1176
        103 1422
        103 1890
        103 1103
        103 992
        104 1815
        104 3055
        104 1500
        104 926
        105 2799
        105 3818
        105 3516
        105 1750
        106 369
        106 3511
        106 2662
        106 1905
        107 709
        107 2986
        107 3166
        107 1092
        108 1156
        108 3890
        108 3766
        108 2822
        109 1368
        109 3762
        109 2191
        109 3541
        110 1006
        110 3762
        110 592
        110 3387
        111 304
        111 3703
        111 2577
        111 2974
        112 512
        112 460
        112 1134
        112 1962
        113 2609
        113 2633
        113 2587
        113 1906
        114 3790
        114 1562
        114 2626
        114 2287
        115 720
        115 1671
        115 2398
        115 2301
        116 1660
        116 1100
        116 3377
        117 3383
        117 2718
        117 4013
        117 3106
        118 671
        118 1078
        118 2994
        118 3974
        119 1080
        119 3467
        119 1422
        119 939
        120 372
        120 3835
        120 2476
        120 3843
        121 3900
        121 1936
        121 3598
        121 1309
        122 2277
        122 3302
        122 3042
        122 2392
        123 4030
        123 3107
        123 1388
        123 3321
        124 508
        124 1163
        124 3556
        124 1547
        125 4092
        125 309
        125 3744
        125 162
        126 3750
        126 2045
        126 3243
        126 334
        127 3770
        127 1534
        127 2860
        127 348
        128 3333
        128 1363
        128 3754
        128 2678
        129 3153
        129 998
        129 166
        129 844
        130 2114
        130 3461
        130 425
        130 1271
        131 2841
        131 1837
        131 2944
        131 1916
        132 1140
        132 3896
        132 3847
        132 2056
        133 1777
        133 2038
        133 3608
        133 1194
        134 1401
        134 844
        134 943
        134 3391
        135 3117
        135 1569
        135 2741
        135 3365
        136 1889
        136 938
        136 3914
        136 2427
        137 2589
        137 2819
        137 272
        137 1438
        138 3221
        138 511
        138 1233
        138 4002
        139 2525
        139 2878
        139 574
        139 1638
        140 3777
        140 1691
        140 2556
        140 4071
        141 3201
        141 2219
        141 3565
        141 1697
        142 1051
        142 3004
        142 1398
        142 2347
        143 1766
        143 1868
        143 2674
        143 2803
        144 1298
        144 947
        144 3679
        145 732
        145 3919
        145 1300
        145 3962
        146 2929
        146 2678
        146 638
        146 656
        147 274
        147 1081
        147 1393
        147 320
        148 548
        148 1446
        148 1327
        148 2625
        149 3855
        149 1741
        149 1731
        149 3108
        150 1887
        150 1688
        150 924
        150 2734
        151 3586
        151 313
        151 2028
        151 2814
        152 1791
        152 2503
        152 4073
        152 4051
        153 968
        153 3507
        153 1935
        153 2455
        154 1580
        154 305
        154 3502
        154 3130
        155 1716
        155 1390
        155 2550
        155 1251
        156 2281
        156 1621
        156 1438
        156 3839
        157 1630
        157 877
        157 1195
        157 1902
        158 4077
        158 3608
        158 2904
        158 1409
        159 2399
        159 776
        159 281
        159 1012
        160 1638
        160 2759
        160 246
        160 1476
        161 1544
        161 3558
        161 775
        161 840
        162 3323
        162 4094
        162 2677
        163 2520
        163 172
        163 3011
        163 1122
        164 1775
        164 1894
        164 3442
        164 3052
        165 3170
        165 3030
        165 515
        165 2693
        166 508
        166 206
        167 4030
        167 1231
        167 3481
        167 1201
        168 1396
        168 399
        168 3203
        168 3004
        169 2063
        169 3604
        169 1627
        169 4040
        170 2066
        170 826
        170 1963
        170 1316
        171 1077
        171 409
        171 2054
        171 488
        172 2655
        172 1449
        172 3159
        173 2057
        173 3066
        173 1822
        173 3900
        174 2738
        174 2441
        174 2018
        174 3768
        175 3489
        175 3806
        175 401
        176 3756
        176 4027
        176 2208
        176 2896
        177 3187
        177 1364
        177 959
        177 1366
        178 1578
        178 197
        178 2839
        178 2123
        179 3287
        179 3674
        179 2330
        179 2872
        180 2187
        180 327
        180 199
        181 2818
        181 1443
        181 3871
        181 2751
        182 3416
        182 3724
        182 3964
        182 3329
        183 3571
        183 2168
        183 3212
        183 725
        184 3343
        184 1796
        184 2229
        184 873
        185 2794
        185 1808
        185 3848
        185 1679
        186 3300
        186 1503
        186 1596
        186 450
        187 3648
        187 2347
        187 3598
        187 3578
        188 3568
        188 1310
        188 2062
        188 1369
        189 1333
        189 3228
        189 3451
        189 2385
        190 1745
        190 3005
        190 1166
        190 1297
        191 3035
        191 3331
        191 1913
        191 2001
        192 2090
        192 536
        192 3290
        193 3947
        193 1780
        193 2680
        193 1820
        194 523
        194 1223
        194 1539
        195 322
        195 256
        195 1464
        196 1222
        196 3102
        196 1033
        196 1090
        197 2316
        197 1438
        197 2996
        198 2335
        198 3761
        198 2344
        198 2444
        199 619
        199 3404
        199 1996
        200 3639
        200 692
        200 2155
        200 2426
        201 2128
        201 1667
        201 2477
        201 3385
        202 2204
        202 3213
        202 3251
        202 401
        203 2790
        203 1456
        203 1062
        203 1357
        204 1972
        204 1243
        204 2977
        204 2139
        205 3356
        205 2669
        205 3325
        205 1661
        206 895
        206 3411
        206 2892
        207 1428
        207 328
        207 3990
        207 3897
        208 2594
        208 2847
        208 1908
        208 3708
        209 2859
        209 641
        209 1714
        209 2757
        210 1967
        210 2401
        210 1156
        210 1386
        211 2696
        211 1260
        211 2108
        211 3662
        212 2887
        212 1940
        212 2266
        212 2284
        213 1032
        213 1282
        213 441
        213 3432
        214 3463
        214 3064
        214 1569
        215 2376
        215 1681
        215 3683
        216 339
        216 3745
        216 1545
        216 3319
        217 3099
        217 2419
        217 358
        217 3561
        218 1153
        218 747
        218 1571
        218 2675
        219 2875
        219 3356
        219 1030
        219 3332
        220 713
        220 1079
        220 3248
        220 936
        221 3459
        221 1669
        221 764
        221 3198
        222 1354
        222 1836
        222 2799
        222 3293
        223 3259
        223 2601
        223 3019
        223 878
        224 2337
        224 2420
        224 587
        224 2726
        225 597
        225 3525
        225 1257
        225 4010
        226 1734
        226 457
        226 1675
        226 357
        227 3161
        227 3795
        227 1457
        227 3464
        228 1235
        228 882
        228 4007
        228 772
        229 2851
        229 1054
        229 2137
        229 3299
        230 3532
        230 3349
        230 1431
        230 3430
        231 973
        231 3341
        231 1694
        231 379
        232 434
        232 3626
        232 1334
        232 271
        233 2821
        233 2346
        233 3749
        233 1134
        234 2653
        234 1860
        234 2237
        234 3790
        235 4032
        235 338
        235 1591
        235 3897
        236 1366
        236 2515
        236 1660
        236 2869
        237 2566
        237 1631
        237 514
        237 1202
        238 3516
        238 3736
        238 2384
        238 1341
        239 2617
        239 2505
        239 1712
        239 3077
        240 2243
        240 2660
        240 2182
        240 3939
        241 3780
        241 1272
        241 2952
        241 1705
        242 2436
        242 3091
        242 3735
        242 812
        243 1128
        243 4083
        243 3719
        244 2409
        244 568
        244 2779
        244 1725
        245 1171
        245 1993
        245 376
        245 1828
        246 2575
        246 2235
        246 2487
        247 1843
        247 727
        247 3587
        247 2838
        248 2580
        248 1842
        248 1177
        248 2315
        249 723
        249 3850
        249 1725
        249 3244
        250 533
        250 1975
        250 1456
        250 2272
        251 2598
        251 771
        251 1468
        251 1672
        252 319
        252 382
        252 2519
        252 2090
        253 2688
        253 2565
        253 1527
        253 3913
        254 987
        254 1514
        254 470
        255 2848
        255 2194
        255 3020
        255 2269
        256 424
        256 541
        256 1819
        257 637
        257 685
        257 798
        257 3493
        258 3731
        258 3728
        258 1944
        258 2681
        259 3965
        259 2313
        259 2555
        259 3430
        260 1597
        260 889
        260 2171
        260 342
        261 361
        261 725
        261 4041
        261 3808
        262 272
        262 1434
        262 4065
        262 3636
        263 3597
        263 1760
        263 1530
        263 1595
        264 685
        264 3013
        264 4041
        264 1665
        265 1526
        265 2000
        265 2412
        265 3822
        266 2751
        266 2362
        266 3918
        266 1231
        267 2425
        267 1684
        267 2904
        267 2838
        268 2834
        268 3114
        268 609
        268 3176
        269 707
        269 2708
        269 820
        269 1331
        270 1066
        270 2483
        270 1080
        270 3811
        271 3533
        271 1164
        271 3057
        272 2650
        272 2996
        273 391
        273 609
        273 3982
        273 1192
        274 454
        274 786
        274 812
        275 1679
        275 2858
        275 328
        275 1085
        276 1437
        276 3682
        276 3711
        276 3979
        277 360
        277 1070
        277 1397
        277 2215
        278 1830
        278 3059
        278 3389
        279 1904
        279 758
        279 2092
        279 3706
        280 2720
        280 554
        280 3223
        280 2058
        281 3111
        281 984
        282 2767
        282 803
        282 3759
        282 547
        283 1150
        283 1575
        283 696
        283 663
        284 1487
        284 1627
        284 3078
        284 2395
        285 1604
        285 3286
        285 3539
        285 2836
        286 3621
        286 2028
        286 832
        286 742
        287 2209
        287 997
        287 1058
        287 434
        288 3230
        288 892
        288 1757
        288 1151
        289 1114
        289 1521
        289 3967
        289 2309
        290 1089
        290 687
        290 4023
        290 1789
        291 2772
        291 1935
        291 884
        291 1163
        292 745
        292 3058
        292 1053
        292 802
        293 3692
        293 4095
        293 3538
        293 3994
        294 1557
        294 754
        294 3094
        294 3163
        295 357
        295 3152
        295 1424
        295 2760
        296 2500
        296 2606
        296 1488
        296 1515
        297 3034
        297 812
        297 3077
        298 864
        298 1021
        298 2079
        298 2898
        299 3662
        299 1631
        299 418
        299 881
        300 2055
        300 3948
        300 429
        300 2262
        301 3855
        301 2254
        301 3093
        301 2121
        302 1697
        302 3491
        302 1431
        302 1314
        303 2107
        303 468
        303 1503
        303 2998
        304 3785
        304 3400
        304 3698
        305 2905
        305 1940
        305 2755
        306 591
        306 1620
        306 1179
        306 3809
        307 1292
        307 3665
        307 1324
        307 3393
        308 408
        308 2577
        308 2853
        308 3562
        309 2891
        309 2007
        309 2456
        310 3438
        310 731
        310 3029
        310 2478
        311 560
        311 3129
        311 931
        311 2549
        312 1913
        312 1973
        312 2924
        312 3675
        313 2940
        313 3438
        313 1616
        314 1753
        314 523
        314 1056
        314 3313
        315 721
        315 920
        315 3426
        315 2880
        316 2478
        316 368
        316 1046
        316 2879
        317 3840
        317 3760
        317 3444
        317 2327
        318 1558
        318 2666
        318 2088
        318 1218
        319 3092
        319 435
        320 3552
        320 1691
        320 2110
        321 4036
        321 2902
        321 1063
        321 1964
        322 2152
        322 1199
        322 911
        323 887
        323 1924
        323 3409
        323 3269
        324 3267
        324 1710
        324 1812
        324 1755
        325 1072
        325 2495
        325 768
        325 1732
        326 1325
        326 3295
        326 1291
        326 1246
        327 4095
        327 1029
        328 857
        328 2563
        329 711
        329 1119
        329 2086
        330 3879
        330 741
        330 2999
        330 1903
        331 2223
        331 688
        331 966
        331 3758
        332 3122
        332 1351
        332 3241
        332 2713
        333 380
        333 2207
        333 4077
        333 3527
        334 1807
        334 1358
        334 623
        335 739
        335 3810
        335 2849
        335 2470
        336 1353
        336 341
        336 2223
        336 2154
        337 1180
        337 1386
        337 1909
        337 3037
        338 2508
        338 3228
        338 2614
        339 1131
        339 1059
        340 2381
        340 1796
        340 3870
        340 1947
        341 3921
        341 500
        341 1629
        342 957
        342 521
        342 746
        343 2815
        343 2520
        343 1731
        343 3275
        344 1130
        344 934
        344 2681
        344 1088
        345 3510
        345 699
        345 4043
        345 994
        346 1772
        346 1489
        346 1897
        346 2499
        347 3716
        347 2057
        347 3449
        347 3618
        348 1924
        348 3312
        348 3486
        349 2795
        349 3066
        349 1414
        349 2654
        350 3603
        350 1670
        350 505
        350 1537
        351 2654
        351 1584
        351 1914
        351 2291
        352 374
        352 890
        352 2051
        352 1319
        353 2061
        353 641
        353 766
        353 1792
        354 2177
        354 3842
        354 2427
        354 539
        355 1397
        355 3839
        355 1578
        355 2316
        356 3304
        356 3255
        356 3493
        356 1914
        357 885
        357 627
        358 425
        358 907
        358 734
        359 489
        359 3184
        359 481
        359 914
        360 3726
        360 2280
        360 1031
        361 3697
        361 3342
        361 1265
        362 895
        362 2619
        362 3380
        362 2716
        363 3952
        363 3394
        363 2980
        363 3577
        364 2420
        364 3816
        364 2204
        364 2343
        365 1477
        365 4084
        365 3727
        365 1106
        366 3736
        366 3877
        366 2588
        367 1975
        367 2229
        367 3230
        367 1348
        368 2213
        368 2886
        368 3029
        369 440
        369 2687
        369 2504
        370 476
        370 1382
        370 956
        370 2234
        371 3376
        371 432
        371 2529
        371 2129
        372 405
        372 2301
        372 1722
        373 2180
        373 1440
        373 2232
        373 1379
        374 1823
        374 2244
        374 3088
        375 3681
        375 1343
        375 2923
        375 1979
        376 3431
        376 2217
        376 3920
        377 698
        377 2518
        377 1153
        377 397
        378 2451
        378 1216
        378 3810
        378 3282
        379 884
        379 1470
        379 508
        380 1642
        380 1534
        380 1093
        381 788
        381 589
        381 3088
        381 3584
        382 4013
        382 2609
        382 3147
        383 2150
        383 434
        383 3794
        383 748
        384 1497
        384 2857
        384 2135
        384 3787
        385 3159
        385 1420
        385 2308
        385 2677
        386 3518
        386 2983
        386 806
        386 2192
        387 3403
        387 3756
        387 1883
        387 1745
        388 3373
        388 3705
        388 1785
        388 3399
        389 3541
        389 2465
        389 3277
        389 3086
        390 3878
        390 3032
        390 1918
        391 1814
        391 1304
        391 1680
        392 1332
        392 3775
        392 2769
        392 2991
        393 2915
        393 876
        393 3019
        393 3461
        394 1777
        394 2608
        394 2207
        394 4062
        395 2981
        395 720
        395 3443
        395 3843
        396 1063
        396 3548
        396 1802
        396 3020
        397 3360
        397 1223
        397 4082
        398 3013
        398 723
        398 2417
        398 2779
        399 3404
        399 2671
        399 1620
        400 1618
        400 3529
        400 1282
        400 3508
        401 880
        401 2420
        402 458
        402 856
        402 3858
        402 2733
        403 3382
        403 724
        403 1390
        403 4003
        404 1703
        404 3944
        404 2627
        404 3297
        405 3513
        405 1969
        405 2366
        406 3801
        406 841
        406 1791
        407 3345
        407 1621
        407 3428
        407 787
        408 686
        408 416
        408 2809
        409 2171
        409 2740
        409 3682
        410 3900
        410 3951
        410 3141
        410 2139
        411 3362
        411 1346
        411 917
        411 2579
        412 2238
        412 2836
        412 1402
        412 1823
        413 3637
        413 2671
        413 870
        413 1673
        414 3212
        414 2017
        414 3583
        414 770
        415 1772
        415 3012
        415 1459
        415 1561
        416 2245
        416 473
        416 3788
        417 3126
        417 2184
        417 1313
        417 1280
        418 760
        418 1473
        418 2175
        419 548
        419 3625
        419 1811
        419 486
        420 1602
        420 2193
        420 3912
        420 3412
        421 2404
        421 1417
        421 3460
        421 2386
        422 3507
        422 3657
        422 2089
        423 3756
        423 679
        423 3666
        423 3473
        424 1509
        424 642
        424 1367
        425 2646
        425 3247
        426 1097
        426 791
        426 2896
        426 1478
        427 949
        427 448
        427 2172
        428 1222
        428 1722
        428 3472
        428 842
        429 511
        429 3285
        429 4039
        430 2744
        430 2443
        430 3722
        430 3526
        431 957
        431 2065
        431 3218
        431 3233
        432 2714
        432 994
        432 3852
        433 3394
        433 2169
        433 1472
        433 2013
        434 3144
        435 2052
        435 2747
        435 3169
        436 1055
        436 1802
        436 2120
        436 1502
        437 562
        437 498
        437 926
        437 745
        438 2004
        438 1445
        438 3545
        438 2126
        439 1337
        439 2225
        439 3245
        439 3471
        440 2535
        440 3747
        440 2030
        441 2513
        441 2397
        441 1662
        442 2254
        442 3172
        442 3308
        442 1731
        443 2530
        443 3298
        443 2759
        443 1452
        444 2911
        444 1409
        444 1539
        444 1873
        445 2094
        445 1345
        445 3860
        445 2025
        446 1446
        446 3186
        446 3813
        446 3249
        447 866
        447 1705
        447 3576
        447 526
        448 3043
        448 547
        448 2648
        449 2111
        449 2564
        449 708
        449 3557
        450 1906
        450 3812
        450 2001
        451 1845
        451 1798
        451 1612
        451 2233
        452 671
        452 2367
        452 3676
        452 2635
        453 909
        453 752
        453 3177
        453 1580
        454 589
        454 1691
        454 3036
        455 1266
        455 3315
        455 1461
        455 2950
        456 1992
        456 3937
        456 3579
        456 2158
        457 1793
        457 557
        457 2296
        458 1721
        458 1511
        458 818
        459 3154
        459 1641
        459 1362
        459 2513
        460 3642
        460 3443
        460 1086
        461 1370
        461 3044
        461 614
        461 1203
        462 4038
        462 3073
        462 3537
        462 3486
        463 3155
        463 2594
        463 2967
        463 3862
        464 779
        464 1090
        464 906
        464 3980
        465 1623
        465 3421
        465 2389
        465 1871
        466 3249
        466 921
        466 2048
        466 1408
        467 2447
        467 864
        467 3341
        467 1470
        468 3964
        468 2236
        468 1486
        469 2395
        469 3293
        469 1033
        469 2268
        470 3847
        470 2356
        470 3373
        471 3613
        471 1671
        471 3926
        471 2536
        472 1607
        472 3009
        472 568
        472 723
        473 3803
        473 3202
        473 3652
        474 2332
        474 2848
        474 636
        474 3460
        475 578
        475 1363
        475 2344
        475 1209
        476 4070
        476 2533
        476 3524
        477 1934
        477 1697
        477 1000
        477 1600
        478 1675
        478 1197
        478 1614
        478 3246
        479 1974
        479 2113
        480 1921
        480 2801
        480 2035
        481 2158
        481 2241
        481 3378
        482 762
        482 1738
        482 2367
        483 2748
        483 583
        483 921
        483 3100
        484 2376
        484 1810
        484 2442
        484 563
        485 3000
        485 1775
        485 3071
        485 575
        486 1632
        486 3837
        486 1991
        487 3318
        487 3684
        487 972
        487 742
        488 3353
        488 2060
        488 2374
        489 1651
        489 3490
        489 3782
        490 1221
        490 3546
        490 1562
        490 2715
        491 3258
        491 2875
        491 2776
        491 3233
        492 1646
        492 2760
        492 1880
        492 3252
        493 1121
        493 3822
        493 3352
        493 3644
        494 688
        494 2492
        494 4028
        494 3632
        495 1052
        495 712
        495 3582
        495 850
        496 795
        496 2429
        496 2359
        496 3313
        497 756
        497 1387
        497 1049
        497 2321
        498 1902
        498 1191
        498 2616
        499 1194
        499 2410
        499 1217
        499 3800
        500 988
        500 2756
        500 688
        501 3446
        501 608
        501 672
        501 2725
        502 3880
        502 1455
        502 1228
        502 3622
        503 734
        503 3106
        503 2352
        503 2419
        504 3162
        504 3349
        504 761
        504 1448
        505 2730
        505 1106
        505 2273
        506 3054
        506 1382
        506 1625
        506 2215
        507 906
        507 2127
        507 2533
        507 3102
        508 2976
        509 1713
        509 2676
        509 2850
        509 1824
        510 1733
        510 2125
        510 3199
        510 3665
        511 1462
        511 1189
        512 1239
        512 1212
        512 3564
        513 772
        513 2554
        513 3642
        514 3860
        514 2583
        515 559
        515 1608
        515 2971
        516 1865
        516 726
        516 3174
        516 3358
        517 3023
        517 2383
        517 3251
        517 1518
        518 2782
        518 2781
        518 1225
        518 1953
        519 2491
        519 2374
        519 2511
        519 2876
        520 2584
        520 2525
        520 916
        520 1023
        521 3711
        521 972
        521 3673
        522 662
        522 3875
        522 3920
        522 1205
        523 3874
        523 1107
        524 3670
        524 910
        524 1650
        524 2075
        525 3108
        525 679
        525 603
        525 1747
        526 4066
        526 2888
        526 3257
        527 2988
        527 2993
        527 3914
        527 776
        528 1877
        528 3577
        528 605
        528 1433
        529 1197
        529 751
        529 2296
        530 3693
        530 806
        530 1828
        530 1400
        531 3150
        531 1678
        531 569
        531 3072
        532 3575
        532 3115
        532 1050
        532 1571
        533 3123
        533 1357
        533 3478
        534 701
        534 2230
        534 3549
        535 2291
        535 2700
        535 2709
        535 3985
        536 1996
        536 4095
        536 3738
        537 828
        537 1313
        537 2388
        537 1648
        538 1285
        538 712
        538 3305
        538 1070
        539 1433
        539 3774
        539 2350
        540 1606
        540 2084
        540 3277
        541 1353
        541 545
        541 3424
        542 3297
        542 3306
        542 2931
        542 3167
        543 3200
        543 1754
        543 3471
        543 1636
        544 2258
        544 1507
        544 3699
        544 4072
        545 2883
        545 1629
        545 1054
        546 1183
        546 2929
        546 2909
        546 1617
        547 1145
        547 869
        548 2794
        548 1085
        549 952
        549 3622
        549 3694
        550 3733
        550 791
        550 1551
        550 1279
        551 964
        551 1738
        551 1428
        551 2916
        552 3601
        552 3496
        552 3478
        552 1757
        553 1559
        553 2871
        553 893
        553 3903
        554 2045
        554 1185
        554 1311
        555 3267
        555 2046
        555 2843
        555 1651
        556 762
        556 2635
        556 1654
        556 2558
        557 3884
        557 3856
        557 1256
        558 2432
        558 2510
        558 1918
        558 2135
        559 2460
        559 865
        559 3321
        560 1462
        560 3930
        560 1306
        561 1334
        561 3270
        561 3533
        561 1693
        562 3841
        562 2867
        562 2465
        563 2501
        563 2793
        563 995
        564 2438
        564 1760
        564 3364
        564 1039
        565 2662
        565 3184
        565 2247
        565 3351
        566 700
        566 1550
        566 3051
        566 1892
        567 3590
        567 3593
        567 844
        567 889
        568 3465
        568 1039
        569 1854
        569 2383
        569 2607
        570 2771
        570 1001
        570 2713
        571 3346
        571 2278
        571 3409
        571 3793
        572 3627
        572 3901
        572 2544
        572 1470
        573 2917
        573 897
        573 984
        573 3550
        574 852
        574 3266
        574 3320
        575 4039
        575 3978
        575 2055
        576 602
        576 1179
        576 3059
        576 2394
        577 1141
        577 3480
        577 1014
        577 2085
        578 1899
        578 3189
        578 3927
        579 3279
        579 2119
        579 2492
        579 2369
        580 2657
        580 2096
        580 3968
        581 3254
        581 648
        581 3879
        581 1308
        582 2947
        582 1501
        582 3362
        582 3386
        583 1329
        583 1727
        583 3186
        584 3040
        584 2213
        584 2469
        584 2770
        585 2345
        585 3558
        585 882
        586 2839
        586 3363
        586 1204
        586 850
        587 3023
        587 2204
        587 1739
        588 2967
        588 3861
        588 3229
        588 3966
        589 1323
        589 3668
        590 3985
        590 2144
        590 637
        590 4041
        591 602
        591 3372
        591 2226
        592 3573
        592 1686
        592 861
        593 1973
        593 977
        593 3538
        593 3395
        594 646
        594 1140
        594 2748
        594 3194
        595 2021
        595 2074
        595 4025
        595 2999
        596 2144
        596 3210
        596 3566
        596 2709
        597 3379
        597 2618
        597 2698
        598 1765
        598 1294
        598 3939
        598 3053
        599 2480
        599 1568
        599 3787
        599 2265
        600 846
        600 1120
        600 2482
        600 2657
        601 2011
        601 2882
        601 1939
        601 1158
        602 1950
        602 2778
        603 2473
        603 2896
        603 3913
        604 2920
        604 2005
        604 1335
        604 3196
        605 3131
        605 1484
        605 3210
        606 1019
        606 2923
        606 2260
        606 2066
        607 3963
        607 856
        607 3683
        607 3966
        608 3310
        608 2868
        608 3748
        609 2829
        609 2649
        610 2201
        610 3143
        610 1169
        610 3710
        611 3088
        611 2127
        611 3408
        611 1611
        612 1891
        612 2903
        612 698
        612 4082
        613 1635
        613 3889
        613 3140
        613 2302
        614 1017
        614 2056
        614 1461
        615 3356
        615 2279
        615 2328
        615 1443
        616 1000
        616 1532
        616 3628
        616 2015
        617 2773
        617 3779
        617 3979
        617 1112
        618 1202
        618 2583
        618 3638
        619 1620
        619 4081
        619 1228
        620 1484
        620 1433
        620 2235
        620 852
        621 2116
        621 1646
        621 1634
        621 3239
        622 934
        622 2655
        622 3299
        622 2883
        623 3610
        623 3452
        623 1350
        624 804
        624 3944
        624 3885
        624 2336
        625 1885
        625 2787
        625 3120
        625 3966
        626 1879
        626 1689
        626 1050
        626 3988
        627 1460
        627 3624
        627 1674
        628 2353
        628 2765
        628 3708
        628 1322
        629 892
        629 1335
        629 2872
        629 1541
        630 1964
        630 632
        630 1279
        630 2269
        631 4046
        631 2340
        631 948
        631 2902
        632 4036
        632 1302
        632 1802
        633 1647
        633 2446
        633 1732
        634 1008
        634 1131
        634 3547
        634 1930
        635 2047
        635 2774
        635 3151
        635 2261
        636 952
        636 3776
        636 2326
        637 2291
        637 1338
        638 3950
        638 1183
        638 2954
        639 2735
        639 2555
        639 1969
        639 1378
        640 3010
        640 1315
        640 3986
        640 3154
        641 2371
        641 1761
        642 1247
        642 911
        642 3413
        643 3743
        643 3651
        643 2817
        643 3134
        644 693
        644 1978
        644 1904
        644 1696
        645 3171
        645 853
        645 2766
        645 2421
        646 1727
        646 1154
        646 675
        647 2781
        647 2327
        647 3384
        648 2178
        648 1903
        648 1208
        649 1643
        649 1303
        649 2472
        649 1128
        650 1674
        650 3746
        650 3468
        650 863
        651 2913
        651 2149
        651 3739
        651 3897
        652 4063
        652 744
        652 980
        652 2705
        653 1186
        653 1553
        653 3709
        653 3832
        654 697
        654 1798
        654 2752
        654 1200
        655 2094
        655 2509
        655 3076
        655 3199
        656 2333
        656 3495
        656 3127
        657 3081
        657 3364
        657 2471
        658 2012
        658 955
        658 3238
        658 3253
        659 1577
        659 3829
        659 2201
        659 2589
        660 1166
        660 1253
        660 1659
        660 2897
        661 2287
        661 2615
        661 3342
        661 2817
        662 3567
        662 2986
        662 944
        663 1899
        663 1884
        663 690
        664 2855
        664 3848
        664 921
        664 3509
        665 1884
        665 876
        665 2731
        665 3260
        666 1263
        666 2106
        666 1683
        666 1622
        667 1662
        667 3508
        667 2995
        667 3835
        668 3824
        668 2145
        668 3798
        668 1916
        669 925
        669 3821
        669 1672
        669 1385
        670 3743
        670 2879
        670 822
        670 827
        671 1113
        671 1429
        672 1391
        672 1118
        672 3257
        673 3607
        673 3564
        673 1134
        673 1071
        674 1325
        674 1504
        674 3794
        675 2955
        675 3359
        675 3044
        676 2626
        676 3141
        676 758
        676 1243
        677 2967
        677 2866
        677 2550
        678 1744
        678 1157
        678 1149
        678 1116
        679 2745
        679 1478
        680 1415
        680 1567
        680 2800
        680 1719
        681 1165
        681 974
        681 3244
        681 3311
        682 3602
        682 3104
        682 3921
        682 2081
        683 3715
        683 2922
        683 2491
        683 1131
        684 2304
        684 1395
        684 2863
        684 1824
        685 2387
        685 1968
        686 3792
        686 3449
        686 3220
        687 2320
        687 2300
        687 2875
        688 2468
        689 904
        689 1529
        689 1061
        689 2654
        690 2690
        690 3656
        690 1570
        691 1343
        691 1390
        691 3936
        691 1286
        692 3125
        692 1058
        692 2077
        693 3706
        693 3365
        693 1644
        694 4057
        694 1692
        694 2829
        694 1814
        695 2655
        695 817
        695 1466
        695 4067
        696 3672
        696 876
        696 3851
        697 1898
        697 2790
        697 4059
        698 1953
        699 4088
        699 3553
        699 2726
        700 2997
        700 3433
        700 1217
        701 3581
        701 2448
        701 785
        702 2153
        702 2493
        702 2844
        702 2136
        703 2124
        703 1761
        703 2742
        703 1714
        704 2949
        704 1689
        704 900
        704 3688
        705 1226
        705 1027
        705 1412
        706 1048
        706 3058
        706 1548
        707 1172
        707 1069
        707 2256
        708 1720
        708 2906
        708 3709
        709 3791
        709 3737
        709 3962
        710 2131
        710 1117
        710 1611
        710 3456
        711 3511
        711 799
        711 985
        712 1490
        712 1047
        713 1838
        713 1956
        713 1310
        714 3777
        714 2596
        714 1778
        714 2946
        715 832
        715 2846
        715 3711
        716 928
        716 733
        716 1587
        716 3244
        717 3433
        717 3226
        717 3068
        717 3023
        718 2932
        718 3686
        718 1247
        718 1044
        719 1752
        719 3965
        719 1000
        719 3000
        720 3063
        720 3301
        721 1719
        721 3235
        721 1105
        722 3007
        722 2351
        722 1084
        722 1260
        723 757
        724 1687
        724 4093
        725 3271
        725 770
        726 4008
        726 2008
        726 2752
        727 1917
        727 3718
        727 939
        728 1265
        728 3117
        728 3615
        728 2709
        729 2594
        729 2229
        729 2330
        729 3972
        730 1556
        730 1684
        730 2163
        730 3402
        731 1743
        731 2682
        731 3586
        732 3093
        732 2293
        732 3416
        733 1139
        733 1320
        733 1447
        734 878
        734 2284
        735 1513
        735 1341
        735 2995
        735 2569
        736 3999
        736 2960
        736 2227
        736 2527
        737 1170
        737 2810
        737 2449
        737 2690
        738 905
        738 1626
        738 1751
        738 2254
        739 3793
        739 1336
        739 1142
        740 4051
        740 831
        740 2233
        740 2224
        741 1915
        741 3475
        741 2941
        742 1063
        742 3179
        743 3729
        743 3789
        743 769
        743 2701
        744 1978
        744 3658
        744 1681
        745 2402
        745 3521
        746 3318
        746 1685
        747 2559
        747 3923
        747 2692
        748 1325
        748 997
        748 2248
        749 2725
        749 3335
        749 2369
        749 1453
        750 2215
        750 3444
        750 1875
        750 2200
        751 3417
        751 3146
        751 4042
        752 1273
        752 3799
        752 3998
        753 1395
        753 3350
        753 2179
        753 867
        754 3682
        754 1077
        754 1359
        755 1660
        755 858
        755 3267
        755 1364
        756 908
        756 3958
        756 3478
        757 1320
        757 2387
        757 1275
        758 1380
        758 3392
        759 4024
        759 3969
        759 1404
        759 2148
        760 3016
        760 2461
        760 1326
        761 2189
        761 4042
        761 2918
        762 2567
        762 3021
        763 2706
        763 3881
        763 2821
        763 1080
        764 2656
        764 1838
        764 3929
        765 1213
        765 3737
        765 1546
        766 2757
        766 1748
        766 3231
        767 2410
        767 3150
        767 2383
        767 2053
        768 1628
        768 948
        768 3119
        769 2036
        769 1677
        769 2019
        770 1665
        770 3060
        771 1385
        771 1560
        771 3288
        772 2346
        772 2981
        773 2370
        773 2627
        773 2642
        773 1852
        774 1627
        774 1211
        774 3080
        774 3082
        775 2323
        775 2087
        775 3484
        776 1076
        776 2571
        777 4030
        777 3677
        777 3305
        777 945
        778 4034
        778 3696
        778 3704
        778 974
        779 4034
        779 2712
        779 1513
        780 3938
        780 1982
        780 3192
        780 3234
        781 1746
        781 1979
        781 789
        781 3401
        782 2297
        782 2039
        782 4003
        782 1343
        783 3025
        783 3922
        783 2598
        783 3288
        784 2827
        784 3247
        784 868
        784 2419
        785 1304
        785 3630
        785 3625
        786 3144
        786 2945
        787 1129
        787 2693
        787 2206
        788 3102
        788 1224
        789 2517
        789 1549
        790 1875
        790 1031
        790 3305
        790 3609
        791 3754
        791 2006
        792 3973
        792 3392
        792 3979
        792 2092
        793 1994
        793 2415
        793 1127
        793 2754
        794 2754
        794 4076
        794 3085
        794 3419
        795 4026
        795 2011
        795 2835
        796 3017
        796 3063
        796 903
        796 3804
        797 1268
        797 2920
        797 1782
        797 3707
        798 3336
        798 1472
        798 3952
        799 3371
        799 3211
        799 2636
        800 1788
        800 3453
        800 3289
        800 2141
        801 3236
        801 3140
        801 4060
        801 3964
        802 1099
        802 2400
        802 888
        803 3904
        803 1281
        803 1835
        804 3781
        804 3811
        804 3240
        805 3916
        805 884
        805 2544
        805 1841
        806 1342
        807 3195
        807 2273
        807 841
        807 3925
        808 3669
        808 4039
        808 3442
        808 3499
        809 3922
        809 4045
        809 3501
        809 912
        810 1851
        810 1625
        810 2327
        810 1242
        811 2377
        811 1268
        811 3851
        811 1150
        812 3707
        813 3728
        813 2540
        813 1111
        813 847
        814 899
        814 843
        814 1447
        814 3282
        815 1910
        815 1572
        815 1675
        815 2881
        816 3635
        816 1585
        816 3065
        817 1629
        817 2756
        817 3335
        818 2068
        818 1978
        818 2360
        819 2297
        819 3045
        819 3637
        819 3372
        820 2689
        820 2407
        820 3074
        821 2770
        821 1432
        821 1949
        821 2394
        822 1221
        822 2957
        822 2393
        823 1876
        823 2534
        823 2553
        823 2810
        824 3149
        824 2702
        824 2890
        824 3507
        825 2457
        825 2532
        825 1804
        825 2341
        826 3314
        826 2112
        826 1558
        827 1656
        827 1046
        827 3207
        828 1432
        828 4064
        828 2404
        829 2335
        829 3146
        829 3388
        829 1197
        830 3069
        830 985
        830 4031
        830 3497
        831 4008
        831 1798
        831 3001
        832 2940
        832 3956
        833 3202
        833 4090
        833 2811
        833 2964
        834 2211
        834 2511
        834 2353
        834 4022
        835 2575
        835 3347
        835 3254
        835 3447
        836 1901
        836 2640
        836 1344
        836 1411
        837 3648
        837 3861
        837 1251
        837 2786
        838 1230
        838 1139
        838 932
        838 945
        839 2868
        839 2563
        839 1174
        839 3739
        840 3274
        840 1790
        840 4090
        841 2730
        841 2644
        842 3237
        842 3102
        842 1442
        843 3336
        843 3915
        843 3512
        844 1376
        845 3263
        845 1340
        845 3397
        845 3494
        846 3373
        846 2495
        847 3894
        847 1966
        847 2856
        848 3969
        848 1719
        848 1658
        848 3226
        849 3660
        849 2242
        849 3393
        850 1285
        850 1578
        851 2813
        851 3512
        851 1139
        852 1476
        852 4076
        853 2010
        853 916
        853 1098
        854 3805
        854 3234
        854 1727
        854 2684
        855 1162
        855 3366
        855 1776
        855 3375
        856 1978
        856 1977
        857 2365
        857 964
        857 2329
        858 2934
        858 3377
        859 3261
        859 2110
        859 2436
        859 3245
        860 3457
        860 3230
        860 3972
        860 3715
        861 3362
        861 2317
        861 1844
        862 2056
        862 3359
        862 2897
        862 2684
        863 2305
        863 2138
        863 3514
        864 1840
        864 3640
        865 3363
        865 1285
        865 1052
        866 1710
        866 1508
        866 3977
        867 3871
        867 1332
        867 2447
        868 1418
        868 2573
        868 3243
        869 3700
        869 2214
        869 3041
        870 3273
        870 2611
        870 3681
        871 1190
        871 3286
        871 2803
        872 2943
        872 1800
        872 1324
        872 3588
        873 2788
        873 1772
        873 2373
        874 3014
        874 1942
        875 958
        875 3988
        875 3402
        875 1955
        876 3259
        877 1680
        877 1219
        877 1548
        878 2718
        878 3561
        879 1049
        879 2006
        879 1278
        879 2007
        880 3089
        880 1518
        880 3646
        881 962
        881 3014
        881 3546
        882 1864
        882 1708
        883 2219
        883 2590
        883 2097
        883 2161
        884 2455
        885 1196
        885 3239
        885 3396
        886 2706
        886 2346
        886 3619
        887 918
        887 2541
        887 1304
        888 1857
        888 1686
        888 2317
        889 3218
        889 3391
        890 2131
        890 2282
        890 1622
        891 2130
        891 1259
        891 3073
        892 1975
        892 2452
        893 4047
        893 968
        893 1694
        894 3685
        894 3552
        894 3348
        894 4072
        895 1547
        895 3028
        896 2673
        896 2265
        896 3498
        896 2765
        897 1836
        897 1022
        897 3500
        898 2261
        898 1430
        898 3022
        898 1824
        899 3255
        899 2649
        899 2834
        900 3270
        900 2150
        900 2642
        901 1743
        901 3812
        901 2386
        901 2064
        902 3203
        902 1602
        902 3048
        902 1379
        903 987
        903 2251
        903 3968
        904 3327
        904 3951
        904 2700
        905 3987
        905 3473
        905 3403
        906 2428
        906 1487
        907 3019
        907 1180
        907 2591
        908 4035
        908 1278
        908 960
        909 1699
        909 3346
        909 3770
        910 2260
        910 3008
        910 1869
        911 2807
        911 1353
        912 2055
        912 2628
        912 3802
        913 3540
        913 2651
        913 1954
        913 2304
        914 2502
        914 2532
        914 3278
        915 4054
        915 2324
        915 1272
        915 2649
        916 2289
        916 3890
        917 2521
        917 3205
        917 1713
        918 3690
        918 3625
        918 2276
        919 2034
        919 1493
        919 3767
        919 2012
        920 3128
        920 3742
        920 2641
        921 3813
        922 1211
        922 1214
        922 2244
        922 2231
        923 2822
        923 1636
        923 3555
        923 1167
        924 3989
        924 2083
        924 3585
        925 1863
        925 3895
        925 3567
        926 2430
        926 2368
        927 4014
        927 1797
        927 1359
        927 2857
        928 932
        928 3311
        929 2518
        929 3360
        929 3269
        929 2439
        930 2197
        930 3712
        930 2498
        930 2453
        931 3367
        931 966
        931 3870
        932 1770
        932 1875
        933 1883
        933 3854
        933 2666
        933 3732
        934 1771
        934 1420
        935 2643
        935 3928
        935 3693
        935 1210
        936 3834
        936 2136
        936 4058
        937 3650
        937 2921
        937 1926
        937 3259
        938 3774
        938 2978
        938 3427
        939 2543
        939 3881
        940 3635
        940 3684
        940 4087
        940 4036
        941 1655
        941 3737
        941 3755
        941 1827
        942 1592
        942 2680
        942 2749
        942 1068
        943 1694
        943 1559
        943 2776
        944 3046
        944 1092
        944 2159
        945 3481
        945 2768
        946 2572
        946 3107
        946 3250
        946 1957
        947 2644
        947 3219
        947 1779
        948 2132
        948 3596
        949 1128
        949 3700
        949 3904
        950 3223
        950 1702
        950 2963
        950 3282
        951 1258
        951 3101
        951 2499
        951 2523
        952 2103
        952 3650
        953 2646
        953 2045
        953 1405
        953 4017
        954 1069
        954 2024
        954 2630
        954 3565
        955 1467
        955 1469
        955 3991
        956 4065
        956 2316
        956 2596
        957 2524
        957 2789
        958 1843
        958 4021
        958 2163
        959 2490
        959 2934
        959 1563
        960 2005
        960 1867
        960 3406
        961 2253
        961 2705
        961 3185
        961 3017
        962 2319
        962 1492
        962 1983
        963 3642
        963 1266
        963 3514
        963 1512
        964 1735
        964 2049
        965 2123
        965 3118
        965 2463
        965 3445
        966 2551
        966 3437
        967 1406
        967 3907
        967 1107
        967 3313
        968 1723
        968 3070
        969 2143
        969 3337
        969 1663
        969 2052
        970 1028
        970 1396
        970 3076
        970 2894
        971 4090
        971 3219
        971 1485
        971 3771
        972 2789
        972 3635
        973 1841
        973 2711
        973 3627
        974 2764
        974 1725
        975 3768
        975 3431
        975 2567
        976 1403
        976 2289
        976 2878
        976 1496
        977 1913
        977 3446
        977 3994
        978 1834
        978 3729
        978 3847
        978 1138
        979 1416
        979 1979
        979 1455
        979 1869
        980 2082
        980 3882
        980 2096
        981 1074
        981 2319
        981 2585
        981 3377
        982 2389
        982 3523
        982 2198
        982 1271
        983 2575
        983 4076
        983 1433
        983 1794
        984 2874
        984 2487
        985 1878
        985 2106
        986 1555
        986 3078
        986 3248
        986 1310
        987 1759
        987 1999
        988 1054
        988 3132
        988 1466
        989 993
        989 3142
        989 1015
        989 2050
        990 3852
        990 3560
        990 3288
        991 2957
        991 2577
        991 1706
        991 3220
        992 1392
        992 3467
        992 4077
        993 2921
        993 3672
        993 1094
        994 4001
        994 1728
        995 2253
        995 2101
        995 3193
        996 3749
        996 2348
        996 3721
        996 3081
        997 1004
        997 2445
        998 1941
        998 3097
        998 3489
        999 3839
        999 1129
        999 3428
        999 3726
        1000 1431
        1001 1790
        1001 1351
        1002 2218
        1002 2414
        1002 4089
        1003 1087
        1003 3543
        1003 3325
        1004 2724
        1004 2870
        1004 1246
        1005 2828
        1005 1938
        1005 2703
        1005 2827
        1006 1191
        1006 1053
        1006 4038
        1007 3533
        1007 2975
        1007 1965
        1007 1565
        1008 2054
        1008 3178
        1008 3849
        1009 1349
        1009 1853
        1009 1439
        1009 2323
        1010 1536
        1010 3923
        1010 2299
        1010 1664
        1011 3352
        1011 2568
        1011 2570
        1011 4000
        1012 3164
        1012 2864
        1012 2969
        1013 3134
        1013 1501
        1013 3817
        1013 3370
        1014 1483
        1014 2026
        1014 2481
        1015 1016
        1015 4035
        1015 2146
        1016 1971
        1016 1094
        1016 2377
        1017 3194
        1017 2305
        1017 3619
        1018 2172
        1018 1613
        1018 3277
        1018 1590
        1019 1979
        1019 3435
        1019 1065
        1020 4032
        1020 2149
        1020 3053
        1020 2254
        1021 1470
        1021 1395
        1021 3556
        1022 1604
        1022 1528
        1022 3293
        1023 4079
        1023 2024
        1023 1524
        1024 3692
        1024 4081
        1024 3675
        1024 2064
        1025 2708
        1025 2763
        1025 2753
        1025 4019
        1026 1753
        1026 2038
        1026 1873
        1026 1645
        1027 1672
        1027 1988
        1027 2290
        1028 1720
        1028 3519
        1028 1673
        1029 3378
        1029 3579
        1029 2926
        1030 2320
        1030 2151
        1030 3620
        1031 3833
        1032 2764
        1032 3701
        1032 3772
        1033 1487
        1033 1528
        1034 1538
        1034 1896
        1034 1667
        1034 1413
        1035 2879
        1035 1510
        1035 3438
        1035 1768
        1036 3600
        1036 3158
        1036 2180
        1037 4024
        1037 1057
        1037 3434
        1037 1774
        1038 3951
        1038 3611
        1038 2026
        1039 3641
        1039 3767
        1040 3026
        1040 1810
        1040 4052
        1040 1298
        1041 1560
        1041 3911
        1041 1229
        1041 3216
        1042 4056
        1042 1815
        1042 2925
        1043 3925
        1043 3980
        1043 1513
        1043 3516
        1044 2206
        1044 3413
        1044 2504
        1045 2873
        1045 2453
        1045 1948
        1045 3836
        1046 3386
        1046 1295
        1047 3931
        1047 3465
        1047 3432
        1048 3268
        1048 2250
        1049 3137
        1049 1747
        1050 2692
        1050 1831
        1051 1289
        1051 2862
        1051 1491
        1052 3616
        1052 2937
        1053 2250
        1053 1548
        1054 2154
        1055 2326
        1055 3778
        1055 2390
        1056 1664
        1056 2958
        1056 1119
        1057 2899
        1057 3791
        1057 1404
        1058 1150
        1058 3853
        1059 3715
        1059 1133
        1059 3836
        1060 3900
        1060 1529
        1060 2862
        1060 2347
        1061 1584
        1061 1877
        1061 2085
        1062 4059
        1062 2688
        1062 2081
        1063 3943
        1064 2579
        1064 3763
        1064 1844
        1064 1742
        1065 1316
        1065 2218
        1065 2406
        1066 2661
        1066 3010
        1066 3781
        1067 3803
        1067 2496
        1067 2033
        1067 1074
        1068 3926
        1068 2988
        1068 3999
        1069 1167
        1069 1524
        1070 1875
        1070 3931
        1071 2513
        1071 3508
        1071 2560
        1072 2446
        1072 2758
        1072 3789
        1073 1506
        1073 1520
        1073 2042
        1074 1091
        1074 2105
        1075 3332
        1075 2537
        1075 3593
        1075 1661
        1076 1722
        1076 2864
        1076 2398
        1077 2511
        1077 4080
        1078 1530
        1078 1181
        1078 3400
        1079 4054
        1079 2750
        1079 2134
        1080 3240
        1081 2652
        1081 3075
        1081 3932
        1082 2719
        1082 1812
        1083 2934
        1083 2562
        1083 1229
        1084 2537
        1084 3819
        1084 3751
        1085 3739
        1085 1808
        1086 2557
        1086 2555
        1086 1232
        1087 2073
        1087 2637
        1087 2669
        1088 3113
        1088 3728
        1088 2502
        1089 2016
        1089 2769
        1089 1726
        1090 2569
        1090 2268
        1091 1983
        1091 3016
        1091 3047
        1092 1300
        1092 2275
        1093 2861
        1093 2860
        1093 2984
        1094 3227
        1095 1713
        1095 2783
        1095 2863
        1096 2453
        1096 1133
        1096 4019
        1097 1352
        1097 3887
        1097 4027
        1098 1496
        1098 3873
        1098 1311
        1099 2402
        1099 3670
        1099 3256
        1100 3534
        1100 1202
        1100 2841
        1101 1666
        1101 3120
        1101 3774
        1102 3136
        1102 1458
        1102 2224
        1103 1911
        1103 2634
        1103 2423
        1104 2508
        1104 2312
        1104 2431
        1104 3848
        1105 4075
        1105 3068
        1105 3645
        1106 4058
        1106 2522
        1107 2832
        1107 1873
        1108 3045
        1108 2599
        1108 3631
        1108 2226
        1109 3819
        1109 2042
        1109 3007
        1109 2566
        1110 3910
        1110 2313
        1110 1212
        1110 3252
        1111 3731
        1111 2633
        1112 2979
        1112 2846
        1112 3956
        1113 3505
        1114 1956
        1114 2782
        1114 2134
        1115 2123
        1115 2604
        1115 1389
        1115 1204
        1116 2780
        1116 3841
        1116 3277
        1117 3408
        1117 1851
        1117 1214
        1118 3395
        1118 2888
        1119 2506
        1119 3497
        1120 1514
        1120 3705
        1120 2405
        1121 4050
        1121 3816
        1122 1629
        1122 3602
        1122 3424
        1123 3802
        1123 2129
        1123 2645
        1124 2950
        1124 3063
        1124 2500
        1124 1671
        1125 4021
        1125 3528
        1125 2138
        1125 2188
        1126 2076
        1126 3943
        1126 1792
        1126 1417
        1127 1573
        1127 3114
        1128 1929
        1129 2535
        1129 2932
        1130 2086
        1130 1283
        1130 3511
        1131 3326
        1132 1820
        1132 3210
        1132 1900
        1132 2227
        1133 1858
        1133 2873
        1134 2981
        1135 2596
        1135 2932
        1135 3062
        1135 3839
        1136 3690
        1136 1192
        1136 1680
        1137 3712
        1137 2497
        1137 2220
        1137 3354
        1138 3373
        1138 1827
        1138 3789
        1139 1702
        1140 2684
        1140 3191
        1141 3045
        1141 3647
        1141 3831
        1142 1970
        1142 1603
        1142 2612
        1143 3308
        1143 3482
        1143 3987
        1143 1372
        1144 2239
        1144 1233
        1144 2884
        1144 1577
        1145 2933
        1145 1330
        1145 3594
        1146 2626
        1146 3222
        1146 1936
        1146 1822
        1147 3440
        1147 3343
        1147 3870
        1147 3423
        1148 1495
        1148 3111
        1148 3550
        1148 1227
        1149 3057
        1149 2975
        1149 1170
        1150 2798
        1151 1335
        1151 2873
        1151 2306
        1152 2639
        1152 2664
        1152 2789
        1153 3115
        1154 2222
        1154 1329
        1154 2479
        1155 4059
        1155 1441
        1155 3992
        1155 3970
        1156 3555
        1156 3075
        1157 1965
        1157 1590
        1157 3330
        1158 1645
        1158 2429
        1158 1718
        1159 3323
        1159 3653
        1159 2891
        1159 1237
        1160 1707
        1160 4056
        1160 3441
        1160 3626
        1161 3417
        1161 3765
        1161 3634
        1161 3713
        1162 3665
        1162 2659
        1162 2840
        1163 3411
        1163 3876
        1164 2209
        1164 2975
        1164 2248
        1165 3422
        1165 1587
        1165 2071
        1166 1218
        1166 3234
        1167 4079
        1167 4019
        1168 3582
        1168 1177
        1168 3671
        1169 2630
        1169 2816
        1169 3552
        1170 1494
        1171 2916
        1171 3724
        1171 3919
        1172 1754
        1172 1267
        1172 3592
        1173 2892
        1173 2716
        1173 3213
        1173 3361
        1174 3720
        1174 3459
        1174 2448
        1175 1217
        1175 3051
        1175 3885
        1175 3781
        1176 2835
        1176 1920
        1176 2359
        1177 2937
        1177 1490
        1178 1640
        1178 3214
        1178 1896
        1178 2956
        1179 1973
        1179 4081
        1180 2728
        1180 2220
        1181 1981
        1181 1826
        1181 1593
        1182 3307
        1182 3507
        1182 3649
        1182 3418
        1183 3495
        1183 3434
        1184 1592
        1184 2590
        1184 2837
        1184 3926
        1185 1702
        1185 3750
        1186 3601
        1186 1922
        1186 3230
        1187 2656
        1187 3525
        1187 2625
        1187 1586
        1188 3527
        1188 1642
        1188 2820
        1189 3287
        1189 2307
        1189 1306
        1190 2349
        1190 2785
        1190 2592
        1191 2465
        1191 1240
        1192 1818
        1192 3420
        1193 4006
        1193 2671
        1193 3004
        1193 1440
        1194 2992
        1194 1939
        1195 3905
        1195 1931
        1195 4057
        1196 1946
        1196 3826
        1196 1847
        1197 2918
        1198 1832
        1198 4048
        1198 3806
        1198 3105
        1199 2239
        1199 1541
        1199 3196
        1200 1286
        1200 2364
        1200 3382
        1201 1490
        1201 1230
        1201 2613
        1202 2319
        1203 3109
        1203 3536
        1203 3359
        1204 3049
        1204 3582
        1205 2526
        1205 1863
        1205 2964
        1206 2748
        1206 2222
        1206 2048
        1206 4021
        1207 2658
        1207 1584
        1207 3577
        1207 2754
        1208 3358
        1208 2831
        1208 2574
        1209 3142
        1209 4086
        1209 3333
        1210 2826
        1210 2461
        1211 1402
        1211 2785
        1212 2825
        1212 3098
        1213 3399
        1213 2482
        1213 3166
        1214 2618
        1214 1257
        1215 2434
        1215 1968
        1215 2169
        1215 3405
        1216 2610
        1216 2903
        1216 2470
        1217 2128
        1218 1740
        1218 3192
        1219 1818
        1219 2379
        1219 4057
        1220 2897
        1220 1427
        1220 3005
        1220 1958
        1221 3664
        1221 1768
        1222 2571
        1222 3500
        1223 2675
        1223 2893
        1224 3769
        1224 3082
        1224 1528
        1225 3691
        1225 3525
        1225 1327
        1226 2598
        1226 3501
        1226 1997
        1227 1893
        1227 2427
        1227 3294
        1228 3589
        1228 1371
        1229 2629
        1229 2454
        1230 3305
        1231 1842
        1231 1288
        1232 1512
        1232 1450
        1232 3856
        1233 2259
        1233 1375
        1234 2919
        1234 1633
        1234 2499
        1235 3558
        1235 3975
        1235 1730
        1236 2506
        1236 3511
        1236 1878
        1236 3448
        1237 1634
        1237 2800
        1237 3204
        1238 3599
        1238 2031
        1238 2667
        1238 3731
        1239 2555
        1239 1641
        1239 2560
        1240 3762
        1240 3623
        1240 1813
        1241 1516
        1241 1835
        1241 3722
        1241 2837
        1242 1521
        1242 3444
        1242 3311
        1243 1936
        1243 3973
        1244 2288
        1244 3668
        1244 1823
        1244 2945
        1245 1659
        1245 1912
        1245 3542
        1246 3396
        1246 1946
        1247 3996
        1247 1356
        1248 2983
        1248 2167
        1248 3300
        1248 2274
        1249 3951
        1249 2977
        1249 3844
        1249 1380
        1250 1349
        1250 2087
        1250 4044
        1250 1730
        1251 2039
        1251 2246
        1252 3292
        1252 1931
        1252 3419
        1252 3347
        1253 2666
        1253 3542
        1253 1839
        1254 1463
        1254 3259
        1254 2284
        1254 3418
        1255 2371
        1255 1501
        1255 2514
        1255 3719
        1256 3357
        1256 2214
        1256 2744
        1257 1627
        1257 1907
        1258 1633
        1258 3858
        1258 3683
        1259 2325
        1259 1870
        1259 1742
        1260 3590
        1260 1597
        1261 1602
        1261 4066
        1261 3576
        1261 1769
        1262 3548
        1262 2052
        1262 1609
        1262 3460
        1263 2488
        1263 2692
        1263 3069
        1264 1982
        1264 3414
        1264 1558
        1264 1915
        1265 1569
        1265 1900
        1266 2305
        1266 3468
        1267 2876
        1267 3442
        1267 1331
        1268 1967
        1268 2077
        1269 1670
        1269 3202
        1269 4049
        1269 3219
        1270 4087
        1270 3859
        1270 2444
        1271 2422
        1271 1623
        1272 3176
        1273 1813
        1273 1699
        1273 3103
        1274 1316
        1274 2989
        1274 1898
        1275 2813
        1275 1288
        1275 2613
        1276 2400
        1276 1432
        1276 3670
        1276 2707
        1277 3887
        1277 3161
        1277 2194
        1277 3397
        1278 1387
        1278 1499
        1279 1352
        1279 2678
        1280 3256
        1280 3795
        1280 2133
        1281 1516
        1281 3463
        1281 2022
        1282 1984
        1282 3641
        1283 1771
        1283 1367
        1283 2636
        1284 3702
        1284 3641
        1284 3215
        1284 1758
        1285 3726
        1286 2406
        1286 2923
        1287 1795
        1287 2378
        1287 2580
        1288 1344
        1288 4011
        1289 2193
        1289 1309
        1289 1649
        1290 3699
        1290 2024
        1290 2525
        1290 3429
        1291 2418
        1291 2445
        1291 3927
        1292 2728
        1292 2494
        1292 2591
        1293 3814
        1293 1854
        1293 3049
        1293 3436
        1294 3517
        1294 2581
        1294 2620
        1295 1654
        1295 1346
        1295 2489
        1296 3995
        1296 2043
        1296 3154
        1296 2037
        1297 3729
        1297 3165
        1297 1958
        1298 3570
        1298 1874
        1299 2715
        1299 2970
        1299 2846
        1300 2217
        1300 3724
        1301 2757
        1301 3370
        1301 3121
        1301 2653
        1302 2678
        1302 2120
        1302 4087
        1303 1377
        1303 1515
        1303 3276
        1304 4018
        1305 1865
        1305 2178
        1305 3550
        1305 2074
        1306 3440
        1306 1523
        1307 1996
        1307 3694
        1307 1371
        1308 2368
        1308 3344
        1308 3347
        1309 3786
        1309 1729
        1310 3604
        1311 1833
        1311 1328
        1312 2349
        1312 1579
        1312 1421
        1312 3340
        1313 1792
        1313 1761
        1314 2219
        1314 2443
        1314 2334
        1315 2604
        1315 3995
        1315 1872
        1316 2364
        1317 3484
        1317 3400
        1317 1595
        1318 2850
        1318 3762
        1318 3022
        1318 1786
        1319 2617
        1319 2945
        1319 3036
        1320 1410
        1320 3512
        1321 2293
        1321 3140
        1321 3855
        1322 4022
        1322 3971
        1322 3163
        1323 1533
        1323 1393
        1323 3348
        1324 1418
        1324 1601
        1325 2642
        1326 3546
        1326 2643
        1326 3664
        1327 1811
        1327 3379
        1328 2637
        1328 1800
        1328 3316
        1329 3605
        1329 3340
        1330 2648
        1330 2545
        1330 2553
        1331 4014
        1331 1809
        1332 3173
        1332 1726
        1333 1993
        1333 1853
        1333 3431
        1334 2288
        1335 1337
        1336 4017
        1336 1807
        1336 1350
        1337 2239
        1337 2259
        1338 2795
        1338 1788
        1338 2512
        1339 2290
        1339 3190
        1339 3324
        1340 2340
        1340 3732
        1340 2758
        1341 1574
        1341 2588
        1342 1486
        1342 2107
        1342 3492
        1343 3845
        1344 1607
        1344 3033
        1345 3375
        1345 1479
        1345 3199
        1346 2435
        1347 2991
        1347 2227
        1347 2603
        1348 1456
        1348 2070
        1348 3936
        1349 2102
        1349 2431
        1350 1517
        1350 2827
        1351 3274
        1351 1670
        1352 3494
        1352 1383
        1353 3655
        1354 4051
        1354 3322
        1354 1495
        1355 1960
        1355 3714
        1356 3747
        1356 2687
        1356 3371
        1357 3958
        1357 4089
        1358 2768
        1358 3328
        1358 1702
        1359 2432
        1359 4022
        1360 2830
        1360 2104
        1360 2074
        1360 2067
        1361 3160
        1361 3448
        1361 3351
        1361 2341
        1362 2397
        1362 1806
        1362 2123
        1363 3204
        1363 2695
        1364 2468
        1365 3434
        1365 2736
        1365 1546
        1365 2954
        1366 2693
        1366 3559
        1367 2883
        1367 2851
        1368 3022
        1368 2933
        1368 2553
        1369 2298
        1369 1508
        1369 1838
        1370 3468
        1370 3315
        1371 3738
        1371 2103
        1372 3892
        1372 2003
        1372 1766
        1373 2395
        1373 3133
        1373 1555
        1373 1791
        1374 2858
        1374 1870
        1374 3549
        1374 2365
        1375 1581
        1375 2807
        1376 2151
        1376 2791
        1376 2976
        1377 1846
        1377 2900
        1377 3109
        1378 2557
        1378 1431
        1378 3886
        1379 3004
        1379 3809
        1380 3365
        1380 3615
        1381 2230
        1381 3581
        1381 3600
        1382 3062
        1382 1397
        1383 1478
        1383 2036
        1383 3127
        1384 2282
        1384 3643
        1384 2195
        1384 1611
        1385 2972
        1385 3875
        1386 2498
        1386 2421
        1387 4092
        1387 1867
        1388 2073
        1388 1582
        1388 3918
        1389 1872
        1389 3118
        1389 3376
        1390 2070
        1391 3720
        1391 2868
        1391 3929
        1392 3527
        1392 2543
        1392 2885
        1393 3580
        1393 3298
        1394 3354
        1394 2377
        1394 2959
        1394 1948
        1395 3901
        1396 2311
        1396 1398
        1397 2907
        1398 3786
        1398 3578
        1399 1837
        1399 2319
        1399 3016
        1399 1631
        1400 2737
        1400 2826
        1400 3920
        1401 2582
        1401 3903
        1402 2349
        1402 3286
        1403 2530
        1403 2600
        1403 1871
        1404 2159
        1404 2440
        1405 3145
        1405 2720
        1405 1623
        1406 3106
        1406 3678
        1406 3502
        1407 3129
        1407 2490
        1407 3758
        1407 3187
        1408 3470
        1408 1632
        1408 3587
        1409 2038
        1410 3493
        1410 2722
        1410 1849
        1411 3871
        1411 2174
        1411 2179
        1412 1523
        1412 1861
        1412 1468
        1413 2681
        1413 2958
        1413 2086
        1414 2057
        1414 2199
        1414 2862
        1415 1658
        1415 4024
        1415 2729
        1416 3681
        1416 3631
        1416 3372
        1417 3586
        1417 4064
        1418 3099
        1418 3872
        1419 3019
        1419 2220
        1419 3227
        1419 3557
        1420 2641
        1420 3522
        1421 3186
        1421 2698
        1421 2785
        1422 3935
        1422 3984
        1423 1881
        1423 2233
        1423 1850
        1423 1459
        1424 2296
        1424 1880
        1424 2918
        1425 3838
        1425 3474
        1425 2017
        1425 3785
        1426 3945
        1426 3947
        1426 3914
        1426 3427
        1427 2446
        1427 3847
        1427 1525
        1428 3868
        1428 2216
        1429 1981
        1429 1742
        1429 2435
        1430 3556
        1430 2544
        1430 2772
        1432 2484
        1434 2157
        1434 2201
        1434 1532
        1435 3050
        1435 3415
        1435 4083
        1435 3121
        1436 2936
        1436 2608
        1436 2774
        1436 2911
        1437 2740
        1437 1882
        1437 2846
        1438 2624
        1439 4015
        1439 3228
        1439 1785
        1440 3530
        1441 2674
        1441 2003
        1442 2476
        1442 3865
        1442 2533
        1443 3820
        1443 2320
        1444 1720
        1444 3273
        1444 3880
        1444 3404
        1445 2629
        1445 1468
        1445 3612
        1446 4010
        1446 3281
        1447 1704
        1447 2610
        1448 3071
        1448 2464
        1448 2078
        1449 2815
        1449 3855
        1449 2302
        1450 3910
        1450 3098
        1450 3152
        1451 3302
        1451 3917
        1451 3802
        1451 2806
        1452 3441
        1452 2067
        1452 3580
        1453 2121
        1453 3172
        1453 2581
        1454 2205
        1454 1639
        1454 2931
        1454 3295
        1455 3273
        1455 2778
        1457 3435
        1457 1990
        1457 1869
        1458 3933
        1458 3080
        1458 2063
        1459 1947
        1459 4020
        1460 1852
        1460 3396
        1460 2724
        1461 2554
        1461 2900
        1462 2228
        1462 3948
        1463 2718
        1463 3307
        1463 1848
        1464 3196
        1464 3825
        1464 1867
        1465 2638
        1465 3003
        1465 3717
        1465 2548
        1466 3299
        1466 3490
        1467 2304
        1467 3151
        1467 3083
        1468 3930
        1469 2034
        1469 3540
        1469 2898
        1471 3799
        1471 1623
        1471 1603
        1471 2668
        1472 2387
        1472 3512
        1473 1526
        1473 3664
        1473 2970
        1474 3429
        1474 3061
        1474 1638
        1474 3298
        1475 1562
        1475 3449
        1475 2615
        1475 1822
        1476 1952
        1476 3447
        1477 2797
        1477 2267
        1477 2375
        1478 2333
        1479 3660
        1479 2572
        1479 2659
        1480 2784
        1480 1509
        1480 2338
        1480 3002
        1481 2261
        1481 2304
        1481 1642
        1481 2676
        1482 1829
        1482 1655
        1482 1626
        1482 2632
        1483 2350
        1483 3815
        1483 3867
        1484 2527
        1484 1668
        1485 3821
        1485 3410
        1485 3545
        1486 2916
        1486 2983
        1487 3408
        1488 2942
        1488 3613
        1488 2749
        1489 2866
        1489 3683
        1489 2373
        1490 3303
        1491 1602
        1491 3857
        1492 3716
        1492 1855
        1492 3638
        1493 1678
        1493 3991
        1494 3232
        1494 4056
        1494 2209
        1495 1724
        1495 4008
        1496 2538
        1496 3145
        1497 2023
        1497 2765
        1497 2211
        1498 1786
        1498 2534
        1498 3520
        1498 2403
        1499 2035
        1499 2146
        1499 3614
        1500 3879
        1500 2925
        1500 2927
        1501 3629
        1502 1551
        1502 3776
        1502 2269
        1503 2274
        1503 2587
        1504 2805
        1504 3864
        1504 1712
        1505 2314
        1505 3887
        1505 1990
        1506 3436
        1506 3773
        1506 2391
        1507 2098
        1507 3513
        1507 2631
        1508 2475
        1508 3279
        1509 2636
        1509 1542
        1510 2192
        1510 1526
        1510 3928
        1511 2096
        1511 2622
        1511 1732
        1512 3884
        1512 1598
        1513 3704
        1514 1701
        1514 2721
        1515 1929
        1515 2082
        1516 2603
        1516 2769
        1517 3874
        1517 3455
        1517 4082
        1518 3773
        1518 2726
        1519 3235
        1519 3645
        1519 2293
        1519 3426
        1520 2108
        1520 3824
        1520 3007
        1521 1587
        1521 3909
        1522 3498
        1522 2480
        1522 3633
        1523 2262
        1523 2673
        1524 3458
        1524 2203
        1525 1999
        1525 3109
        1525 2056
        1526 3940
        1527 2003
        1527 2473
        1527 3275
        1528 3080
        1529 2026
        1529 3480
        1530 2651
        1530 4055
        1531 3466
        1531 3437
        1531 1881
        1532 1969
        1532 3965
        1533 2917
        1533 2874
        1533 2067
        1534 2774
        1534 2358
        1535 2634
        1535 2410
        1535 1678
        1535 2619
        1536 2675
        1536 2212
        1537 2245
        1537 2141
        1538 2882
        1538 3599
        1538 3742
        1539 3455
        1539 2278
        1540 2559
        1540 2732
        1540 3688
        1540 3306
        1541 3655
        1541 3825
        1542 3996
        1542 3371
        1542 2505
        1543 2317
        1543 2130
        1543 2466
        1543 2947
        1544 2240
        1544 1785
        1544 3888
        1545 2242
        1545 2968
        1545 2494
        1546 2899
        1546 3723
        1547 2079
        1547 1985
        1548 3537
        1549 3123
        1549 4089
        1549 2406
        1550 2410
        1550 2661
        1550 2607
        1551 3333
        1551 2050
        1552 2385
        1552 2986
        1552 1863
        1552 3399
        1553 2906
        1553 2517
        1553 1746
        1554 4020
        1554 1561
        1554 2070
        1554 1798
        1555 2062
        1555 3195
        1556 3608
        1556 3800
        1556 3467
        1557 4080
        1557 3862
        1557 2353
        1558 2210
        1559 2524
        1559 2664
        1560 2496
        1560 2824
        1561 2788
        1561 3001
        1562 2393
        1563 1688
        1563 2869
        1563 2303
        1564 2338
        1564 4092
        1564 4094
        1564 1819
        1565 1925
        1565 2717
        1565 2479
        1566 3749
        1566 1619
        1566 1708
        1566 3529
        1567 1634
        1567 2277
        1567 3717
        1568 1698
        1568 3993
        1568 4045
        1569 2593
        1570 3260
        1570 2985
        1570 2881
        1571 2425
        1571 3470
        1572 2545
        1572 3070
        1572 2985
        1573 2599
        1573 3831
        1573 3292
        1574 1708
        1574 3843
        1574 3508
        1575 2915
        1575 3125
        1575 2731
        1576 2650
        1576 3462
        1576 3917
        1576 3445
        1577 3143
        1577 3471
        1578 2029
        1579 2231
        1579 3981
        1579 3605
        1580 2911
        1580 2403
        1581 3655
        1581 3367
        1581 3287
        1582 2362
        1582 1661
        1582 3949
        1583 1586
        1583 2285
        1583 3281
        1583 1765
        1584 1994
        1585 2723
        1585 2132
        1586 4010
        1586 4040
        1587 1704
        1588 2158
        1588 2843
        1588 3912
        1589 2030
        1589 3448
        1589 2662
        1590 2467
        1590 3536
        1591 2312
        1591 2632
        1591 2411
        1592 2603
        1592 2942
        1593 2974
        1593 2738
        1593 2635
        1594 2689
        1594 3713
        1594 3458
        1594 3201
        1595 3974
        1595 3721
        1596 3331
        1596 1605
        1596 2983
        1597 2041
        1598 2775
        1598 3357
        1598 2507
        1599 3631
        1599 2260
        1599 3647
        1599 3725
        1600 2630
        1600 3628
        1600 1754
        1601 2840
        1601 3740
        1601 3243
        1603 3177
        1603 4017
        1604 1724
        1604 3550
        1605 2623
        1605 2049
        1606 1652
        1606 2867
        1606 2547
        1607 2613
        1607 3823
        1608 1776
        1608 2247
        1608 1690
        1609 3337
        1609 2747
        1609 3586
        1610 3811
        1610 2821
        1610 3764
        1610 1962
        1611 1625
        1612 3992
        1612 2752
        1612 2224
        1613 1744
        1613 2648
        1613 3264
        1614 1723
        1614 2294
        1614 2335
        1615 3653
        1615 1634
        1615 2122
        1615 3730
        1616 1768
        1616 2605
        1616 3956
        1617 3859
        1617 3950
        1617 3993
        1618 2409
        1618 2764
        1618 3704
        1619 2713
        1619 2588
        1619 2345
        1620 3273
        1621 2295
        1621 2777
        1622 2973
        1622 2505
        1624 1987
        1624 3524
        1624 2316
        1624 2397
        1625 3110
        1626 4032
        1626 3755
        1628 3723
        1628 1677
        1630 1970
        1630 2823
        1630 1814
        1631 3824
        1632 2794
        1632 3509
        1633 3971
        1633 3708
        1635 2655
        1635 3113
        1635 3522
        1636 2630
        1636 3245
        1637 3475
        1637 3757
        1637 3181
        1637 4025
        1638 2014
        1639 2122
        1639 2812
        1639 3323
        1640 1667
        1640 3306
        1641 1987
        1641 3595
        1642 3763
        1643 2672
        1643 3050
        1643 3719
        1644 3121
        1644 4063
        1644 2360
        1645 4026
        1645 3678
        1646 2277
        1646 2380
        1647 2082
        1647 3276
        1647 1999
        1648 2061
        1648 1989
        1648 2947
        1649 3857
        1649 2057
        1649 3638
        1650 3554
        1650 1950
        1650 3631
        1651 3559
        1651 3132
        1652 2514
        1652 1686
        1652 3086
        1653 2668
        1653 1815
        1653 2616
        1653 3523
        1654 2886
        1654 1656
        1655 3403
        1655 3729
        1656 2957
        1656 2974
        1657 2708
        1657 3074
        1657 2060
        1657 3325
        1658 3182
        1658 3042
        1659 1982
        1659 3359
        1660 2843
        1661 3620
        1662 3524
        1662 3701
        1663 3667
        1663 3778
        1663 2702
        1664 1667
        1664 1718
        1665 3009
        1665 3033
        1666 2978
        1666 3815
        1666 2177
        1668 2969
        1668 3999
        1668 3947
        1669 2324
        1669 3691
        1669 1956
        1670 2644
        1671 2930
        1672 3545
        1673 1959
        1673 3578
        1674 3152
        1674 2363
        1675 3826
        1676 3322
        1676 3934
        1676 2951
        1676 2376
        1677 2758
        1677 3596
        1678 3954
        1679 3837
        1679 3291
        1680 2541
        1681 3185
        1681 2787
        1682 3302
        1682 2040
        1682 2093
        1682 3986
        1683 3211
        1683 2732
        1684 2299
        1684 2212
        1685 3391
        1685 2568
        1685 1941
        1686 2465
        1687 2962
        1687 3001
        1687 3934
        1688 3216
        1688 2944
        1689 1955
        1690 2840
        1690 1762
        1691 3685
        1692 3282
        1692 2849
        1692 2450
        1693 3981
        1693 2238
        1693 4029
        1694 2455
        1695 3335
        1695 3970
        1695 3602
        1695 3275
        1696 2787
        1696 3381
        1696 1780
        1697 3713
        1698 2909
        1698 2628
        1698 2464
        1699 3623
        1699 3828
        1700 3862
        1700 2786
        1700 3457
        1700 2922
        1701 2356
        1701 3558
        1701 4007
        1703 2363
        1703 2485
        1703 3730
        1704 2459
        1704 1849
        1705 2310
        1705 1838
        1706 2809
        1706 2643
        1706 3652
        1707 3157
        1707 3057
        1707 2925
        1708 2981
        1709 3351
        1709 2002
        1709 2840
        1709 2573
        1710 2119
        1710 4066
        1711 2723
        1711 1980
        1711 3993
        1711 3661
        1712 3002
        1712 2973
        1713 3629
        1714 1821
        1714 2340
        1715 1944
        1715 3591
        1715 1976
        1715 3313
        1716 3457
        1716 1922
        1716 2252
        1717 3067
        1717 3225
        1717 2691
        1717 3276
        1718 1753
        1718 2992
        1719 1856
        1720 2611
        1721 1764
        1721 4046
        1722 2098
        1723 2890
        1723 2881
        1724 2008
        1724 3933
        1725 3976
        1726 3820
        1727 2027
        1728 4088
        1728 2361
        1728 2140
        1729 3222
        1729 3015
        1729 3374
        1730 2346
        1730 2833
        1731 3473
        1732 4061
        1733 2111
        1733 3076
        1733 2494
        1734 2889
        1734 3624
        1735 3331
        1736 3395
        1736 3579
        1736 3782
        1737 3056
        1737 2182
        1737 3136
        1737 4040
        1738 3990
        1738 1993
        1739 1945
        1739 3329
        1739 3492
        1740 1766
        1740 3314
        1741 1751
        1741 2293
        1741 2745
        1743 4064
        1743 3040
        1744 1876
        1744 2449
        1745 3892
        1745 3987
        1746 3880
        1746 2611
        1747 3744
        1747 2456
        1748 2653
        1748 2773
        1748 3902
        1749 1944
        1749 1938
        1749 2341
        1749 2506
        1750 2993
        1750 2571
        1750 3090
        1751 3962
        1751 3666
        1752 3628
        1752 3978
        1752 3669
        1754 3669
        1755 2468
        1755 2492
        1755 2865
        1756 3908
        1756 3325
        1756 2572
        1756 2537
        1757 3832
        1757 2959
        1758 2037
        1758 3767
        1758 2982
        1759 3896
        1759 2554
        1759 4007
        1760 3215
        1760 3081
        1761 1927
        1762 3677
        1762 3740
        1762 3321
        1763 3989
        1763 1887
        1763 3345
        1763 2295
        1764 3168
        1764 3065
        1764 2679
        1765 2182
        1765 2586
        1766 3866
        1767 2434
        1767 1951
        1767 3946
        1768 2970
        1769 2044
        1769 3267
        1769 3412
        1770 3328
        1770 2610
        1770 3444
        1771 2784
        1771 3214
        1772 3423
        1773 1793
        1773 2889
        1773 3594
        1773 2214
        1774 2440
        1774 4045
        1774 2729
        1775 1934
        1775 3669
        1776 2109
        1776 2032
        1777 2634
        1777 4077
        1778 2884
        1778 4071
        1778 2152
        1779 3714
        1779 1874
        1779 3410
        1780 2741
        1780 1783
        1781 2364
        1781 3358
        1781 2118
        1781 2066
        1782 3406
        1782 3091
        1782 3034
        1783 2749
        1783 3945
        1783 2705
        1784 2531
        1784 3466
        1784 1897
        1784 3026
        1785 2385
        1786 2358
        1786 3623
        1787 2634
        1787 3800
        1787 3984
        1787 2661
        1788 2844
        1788 3013
        1789 3820
        1789 2328
        1789 2203
        1790 2018
        1790 3484
        1791 3687
        1792 1821
        1793 3246
        1794 2085
        1794 3831
        1794 2754
        1795 2362
        1795 2264
        1795 3439
        1796 3674
        1797 2065
        1797 3673
        1799 2663
        1799 1932
        1799 2621
        1799 2279
        1800 3740
        1800 3750
        1801 2165
        1801 2402
        1801 3008
        1801 2075
        1802 3684
        1803 3618
        1803 3066
        1803 2615
        1803 2512
        1804 3591
        1804 2396
        1804 3160
        1805 3519
        1805 2252
        1805 3715
        1805 1930
        1806 2037
        1806 1943
        1806 2604
        1807 3223
        1807 2470
        1808 3897
        1809 3765
        1809 3592
        1809 1894
        1810 2503
        1810 3818
        1811 3630
        1811 2439
        1812 2375
        1812 3632
        1813 2534
        1813 2616
        1814 3810
        1815 2389
        1816 2185
        1816 3693
        1816 4085
        1816 3920
        1817 3889
        1817 2236
        1817 3236
        1817 2856
        1818 2829
        1818 3114
        1819 3011
        1819 2308
        1820 3117
        1820 3131
        1821 3231
        1821 3941
        1822 3141
        1823 2091
        1824 3784
        1825 3354
        1825 3832
        1825 1971
        1825 2906
        1826 3698
        1826 3205
        1827 3399
        1827 1829
        1828 3518
        1828 2567
        1829 1834
        1829 3228
        1830 2226
        1830 1950
        1830 2379
        1831 2488
        1831 2231
        1831 2051
        1832 2143
        1832 4000
        1832 3092
        1833 2621
        1833 1995
        1834 3156
        1834 4015
        1835 3700
        1835 2942
        1836 3111
        1836 2571
        1837 2342
        1837 2105
        1839 2691
        1839 3732
        1839 3005
        1840 3871
        1840 2378
        1840 2264
        1841 3070
        1841 3594
        1842 3823
        1842 1901
        1843 2425
        1843 2048
        1844 3387
        1844 3073
        1845 4020
        1845 4059
        1845 3104
        1846 3997
        1846 2606
        1846 3315
        1847 2344
        1847 3204
        1847 2116
        1848 1926
        1849 2750
        1849 3255
        1850 3104
        1850 4028
        1850 2020
        1851 2309
        1851 2965
        1852 2539
        1852 2717
        1853 2508
        1854 3773
        1854 4001
        1855 2809
        1855 3546
        1855 3449
        1856 2880
        1856 2462
        1856 3717
        1857 2514
        1857 2388
        1857 2947
        1858 3197
        1858 3898
        1858 2876
        1859 2939
        1859 3374
        1859 3849
        1859 2948
        1860 3365
        1860 3121
        1860 3651
        1861 2499
        1861 3612
        1861 1988
        1862 2372
        1862 2461
        1862 2665
        1862 3262
        1863 2240
        1864 3301
        1864 3804
        1864 3736
        1865 2021
        1865 3539
        1866 2067
        1866 2183
        1866 2487
        1866 2759
        1867 2801
        1868 2752
        1868 1898
        1868 3174
        1869 2133
        1870 3899
        1870 2329
        1871 2186
        1871 3355
        1872 2607
        1872 2249
        1873 3502
        1874 2531
        1876 3541
        1876 2286
        1877 3566
        1877 3327
        1878 2030
        1878 1888
        1879 2048
        1879 3575
        1879 3605
        1880 3910
        1880 3162
        1881 4073
        1881 2164
        1882 1942
        1882 2318
        1882 3973
        1883 2701
        1883 3263
        1884 2255
        1884 3672
        1885 3934
        1885 2978
        1886 2639
        1886 3684
        1886 3761
        1886 3778
        1887 3560
        1887 3911
        1888 4031
        1888 3206
        1888 2828
        1889 2962
        1889 2951
        1889 3111
        1890 3253
        1890 3527
        1890 3083
        1891 4018
        1891 3810
        1891 3409
        1892 2383
        1892 2361
        1892 2249
        1893 2487
        1893 3842
        1893 2178
        1894 2857
        1894 2078
        1895 3094
        1895 3229
        1895 1972
        1895 2092
        1896 3167
        1896 2641
        1897 4052
        1897 3012
        1898 2003
        1899 3695
        1899 2870
        1900 3808
        1901 2378
        1901 2751
        1902 3103
        1902 3828
        1903 2021
        1903 2112
        1904 2977
        1904 3966
        1905 2341
        1905 3184
        1905 2502
        1906 3035
        1906 3692
        1907 3078
        1907 2309
        1907 3027
        1908 2919
        1908 3343
        1908 2373
        1909 3171
        1909 2422
        1909 2646
        1910 2690
        1910 2870
        1911 3991
        1911 4062
        1911 3083
        1912 2472
        1912 3225
        1912 3536
        1913 3748
        1914 2292
        1914 3336
        1915 2112
        1915 2165
        1916 2762
        1916 2566
        1917 4021
        1917 2706
        1917 3079
        1918 2857
        1919 3814
        1919 3390
        1919 3072
        1920 2011
        1920 2204
        1920 2667
        1921 3034
        1921 3794
        1921 2445
        1922 3845
        1922 3936
        1923 2161
        1923 2536
        1923 2301
        1923 3886
        1924 3346
        1924 2823
        1925 3746
        1925 3044
        1926 3149
        1926 2326
        1927 2547
        1927 2672
        1927 2514
        1928 3783
        1928 3534
        1928 2515
        1928 3375
        1929 3563
        1929 3415
        1930 2922
        1930 3863
        1931 2368
        1931 3055
        1932 2169
        1932 2818
        1932 1951
        1933 1972
        1933 2948
        1933 2743
        1933 2786
        1934 3592
        1934 2156
        1935 2854
        1935 3657
        1936 3374
        1937 3814
        1937 3954
        1937 2604
        1938 3907
        1938 3160
        1939 2053
        1939 4026
        1940 2352
        1940 2114
        1941 3590
        1941 2570
        1942 3374
        1942 2474
        1943 3432
        1943 3503
        1943 3582
        1944 2958
        1945 4088
        1945 3046
        1945 4075
        1946 3927
        1946 3653
        1947 3437
        1947 3423
        1948 2920
        1948 3712
        1949 3059
        1949 2707
        1949 3268
        1950 2707
        1951 3820
        1951 4005
        1952 2538
        1952 2878
        1952 2059
        1953 2439
        1953 3569
        1954 2676
        1954 3205
        1954 2863
        1955 2188
        1955 2627
        1956 3027
        1957 3819
        1957 4074
        1957 3860
        1958 2684
        1958 3156
        1959 2252
        1959 2039
        1959 3845
        1960 2375
        1960 3924
        1961 3327
        1961 3131
        1961 3844
        1962 3514
        1963 2210
        1963 2088
        1963 3435
        1964 2194
        1964 3494
        1965 2955
        1965 4004
        1966 2926
        1966 3994
        1967 3712
        1967 3037
        1968 2144
        1968 3952
        1969 2069
        1970 3346
        1970 3103
        1971 3496
        1971 2959
        1972 3861
        1973 2987
        1974 2050
        1974 4035
        1974 2006
        1975 3674
        1976 2528
        1976 3147
        1976 2359
        1977 3741
        1977 2068
        1977 2092
        1980 3485
        1980 3950
        1980 2132
        1981 2820
        1981 2579
        1982 3572
        1983 3788
        1983 2809
        1984 2513
        1984 3607
        1984 2037
        1985 4062
        1985 3151
        1985 3876
        1986 2944
        1986 3798
        1986 2734
        1986 2342
        1987 2069
        1987 2996
        1988 3101
        1988 3450
        1989 2770
        1989 2478
        1989 4064
        1990 2683
        1990 3401
        1991 2276
        1991 2861
        1991 3269
        1992 3203
        1992 2311
        1992 3912
        1993 2614
        1994 3506
        1994 2292
        1995 3873
        1995 2059
        1995 2058
        1996 2739
        1997 4045
        1997 2160
        1998 3164
        1998 3999
        1998 2631
        1998 2097
        1999 2900
        2000 2175
        2000 2283
        2000 4050
        2001 3675
        2002 3665
        2002 2176
        2002 3099
        2004 2531
        2004 3659
        2004 2147
        2005 2452
        2005 2959
        2006 2414
        2007 3614
        2007 3754
        2008 3539
        2008 2224
        2009 3792
        2009 2990
        2009 3453
        2009 2512
        2010 2637
        2010 3680
        2010 2099
        2011 3599
        2012 3215
        2012 2423
        2013 2813
        2013 2621
        2013 4011
        2014 2235
        2014 3164
        2014 3266
        2015 2816
        2015 3513
        2015 3565
        2016 2960
        2016 2590
        2016 2603
        2017 4055
        2017 3698
        2018 2853
        2018 2811
        2019 3018
        2019 3737
        2019 3666
        2020 2115
        2020 2660
        2020 2164
        2021 2727
        2022 2168
        2022 2783
        2022 3775
        2023 3285
        2023 2265
        2023 3052
        2024 2822
        2025 2578
        2025 3015
        2025 2583
        2026 3368
        2027 3340
        2027 3116
        2027 3938
        2028 3902
        2028 3943
        2029 2907
        2029 2397
        2029 3432
        2031 2540
        2031 2681
        2031 3128
        2032 2515
        2032 3170
        2032 3135
        2033 2964
        2033 3138
        2033 3047
        2034 2640
        2034 2438
        2035 4092
        2035 2418
        2036 3756
        2036 3263
        2038 2608
        2039 2481
        2040 3942
        2040 3051
        2040 3010
        2041 2351
        2041 2740
        2042 2142
        2042 2145
        2043 3702
        2043 3984
        2043 2483
        2044 3727
        2044 2797
        2044 2117
        2045 2943
        2046 2865
        2046 4066
        2046 3782
        2047 2936
        2047 2772
        2047 3876
        2049 3309
        2049 3021
        2050 2710
        2051 2949
        2051 2091
        2052 2326
        2053 3251
        2053 3433
        2054 2474
        2054 2939
        2055 3462
        2058 2963
        2058 2538
        2059 3320
        2059 3394
        2060 3284
        2060 3178
        2061 3893
        2061 2814
        2062 3687
        2063 2395
        2063 2595
        2064 3589
        2064 2394
        2065 3353
        2065 2171
        2066 2877
        2068 3168
        2068 3706
        2069 3636
        2069 3835
        2070 4093
        2071 3139
        2071 3967
        2071 4034
        2072 3727
        2072 3960
        2072 3576
        2072 3006
        2073 2572
        2073 2953
        2074 2836
        2075 3344
        2075 3521
        2076 3020
        2076 3941
        2076 2184
        2077 2401
        2077 3932
        2078 2156
        2078 3878
        2079 3991
        2079 3112
        2080 2282
        2080 2505
        2080 2556
        2080 2946
        2081 2272
        2082 2251
        2083 2944
        2083 2303
        2083 2796
        2084 2672
        2084 2472
        2085 2350
        2086 3214
        2087 3721
        2087 3975
        2088 3464
        2089 4048
        2089 3296
        2089 2162
        2090 2718
        2091 3981
        2093 2129
        2093 3031
        2093 2249
        2094 2170
        2094 3547
        2095 2654
        2095 2100
        2095 2232
        2095 3506
        2096 3658
        2097 3699
        2097 3280
        2098 2938
        2098 2842
        2099 2753
        2099 2766
        2100 3906
        2100 3176
        2100 2292
        2101 3087
        2101 2523
        2102 4069
        2102 3676
        2102 2166
        2103 3169
        2103 2332
        2104 3441
        2104 2183
        2104 2999
        2105 2824
        2106 3371
        2106 2195
        2107 2343
        2107 3329
        2108 3089
        2108 2175
        2109 2659
        2109 3250
        2109 3321
        2110 3707
        2110 3075
        2111 2894
        2111 2739
        2112 2877
        2113 2697
        2113 3401
        2114 3799
        2114 2704
        2115 3279
        2115 3568
        2115 2243
        2116 2918
        2116 2928
        2117 2585
        2118 2647
        2118 3382
        2118 2923
        2119 3257
        2119 2865
        2120 3333
        2120 3761
        2121 3310
        2121 2302
        2122 3297
        2122 3717
        2124 2859
        2124 3487
        2124 3067
        2125 2187
        2125 3937
        2126 2496
        2126 3410
        2126 2454
        2127 2234
        2127 3110
        2128 2992
        2128 2882
        2129 3118
        2130 3362
        2130 2489
        2131 2244
        2131 2488
        2132 4036
        2133 3670
        2133 2484
        2134 2459
        2134 2324
        2135 2480
        2135 4022
        2136 2602
        2136 2750
        2137 2504
        2137 2597
        2137 3425
        2138 3764
        2138 3663
        2139 3368
        2139 3598
        2140 3208
        2140 3265
        2140 3969
        2141 2153
        2141 2522
        2142 3593
        2142 3949
        2142 2761
        2143 2162
        2144 3808
        2145 3436
        2146 3406
        2146 2798
        2147 3612
        2147 2551
        2147 3466
        2148 3235
        2148 2275
        2148 3791
        2149 2581
        2149 3868
        2150 2805
        2151 3341
        2151 2776
        2152 3735
        2152 3996
        2153 3122
        2153 2196
        2154 3425
        2154 3413
        2155 3580
        2155 3144
        2155 3626
        2156 3349
        2156 3417
        2157 2816
        2157 3710
        2157 2366
        2158 3782
        2159 3208
        2159 2972
        2160 3479
        2160 2290
        2160 2899
        2161 2631
        2161 3926
        2162 2582
        2162 2702
        2163 3240
        2163 2838
        2164 3924
        2164 3687
        2165 2430
        2165 2354
        2166 3848
        2166 3291
        2167 2192
        2167 3822
        2167 3940
        2169 2980
        2170 3863
        2170 3849
        2170 3786
        2171 3284
        2172 3997
        2172 2472
        2173 3689
        2173 2597
        2173 2247
        2173 2693
        2174 3271
        2174 3173
        2174 3033
        2175 2372
        2176 2396
        2176 2457
        2177 3294
        2177 3867
        2178 2183
        2179 3060
        2179 2898
        2180 4012
        2180 3176
        2181 2824
        2181 4043
        2181 3138
        2181 2665
        2182 4053
        2183 3254
        2184 2404
        2184 3161
        2185 3138
        2185 2826
        2185 3891
        2186 3055
        2186 3447
        2186 2546
        2187 2894
        2187 2311
        2188 3944
        2188 2539
        2189 2380
        2189 2928
        2189 2464
        2190 3893
        2190 2653
        2190 3743
        2190 2605
        2191 3043
        2191 3573
        2191 3086
        2192 3029
        2193 2578
        2194 3941
        2195 3504
        2195 3054
        2196 2471
        2196 3976
        2196 2779
        2197 2497
        2197 2242
        2198 3125
        2198 2426
        2198 3232
        2199 3906
        2199 3960
        2200 3840
        2200 3054
        2201 3628
        2202 3208
        2202 3875
        2202 4043
        2202 3553
        2203 3280
        2203 3201
        2205 4094
        2205 2418
        2206 2777
        2206 3187
        2207 2774
        2207 3083
        2208 2989
        2208 3892
        2208 2473
        2209 2690
        2210 3795
        2210 3008
        2211 2961
        2211 3442
        2212 3608
        2212 2992
        2213 3309
        2213 2489
        2214 3722
        2215 3338
        2216 2614
        2216 3919
        2216 4032
        2217 2986
        2217 3451
        2218 2314
        2218 2989
        2219 3886
        2220 2564
        2221 3523
        2221 2901
        2221 3232
        2222 3528
        2223 3129
        2223 3367
        2225 2873
        2225 3261
        2225 3200
        2226 3530
        2227 2680
        2228 2295
        2228 4002
        2229 3155
        2230 3483
        2230 2924
        2231 2698
        2232 2862
        2233 2542
        2234 3961
        2234 2804
        2236 2433
        2236 3331
        2237 2773
        2237 3392
        2237 3706
        2238 2288
        2238 4025
        2239 2436
        2240 3705
        2240 4090
        2241 3559
        2241 2247
        2242 2382
        2243 2369
        2243 2620
        2244 3082
        2245 4084
        2245 3488
        2246 3815
        2246 4003
        2248 2717
        2248 2724
        2249 4001
        2250 3073
        2250 2317
        2251 2705
        2251 2500
        2252 2786
        2253 3658
        2253 3968
        2255 3149
        2255 4086
        2255 2921
        2256 4019
        2256 2876
        2256 3200
        2257 2447
        2257 3627
        2257 2300
        2257 2769
        2258 3164
        2258 3061
        2258 2842
        2259 2872
        2259 3038
        2260 2574
        2261 2358
        2262 3025
        2262 3501
        2263 2995
        2263 2533
        2263 3701
        2263 2712
        2264 2751
        2264 3620
        2265 3501
        2266 2704
        2266 3959
        2266 3260
        2267 3603
        2267 2730
        2267 3714
        2268 2799
        2268 3133
        2269 3733
        2270 3753
        2270 4031
        2270 2893
        2271 3237
        2271 2842
        2271 3348
        2272 3124
        2273 3834
        2273 3122
        2274 2343
        2274 3272
        2275 4075
        2275 3416
        2276 3899
        2276 3486
        2277 2548
        2278 3770
        2278 3846
        2279 3680
        2279 2669
        2280 3054
        2280 3062
        2280 3747
        2281 2596
        2281 2685
        2281 3686
        2282 4016
        2283 3089
        2283 2570
        2284 3461
        2285 2408
        2285 2592
        2285 3186
        2286 3841
        2286 2616
        2287 3651
        2287 3615
        2288 2908
        2289 3766
        2289 2421
        2290 2482
        2291 3566
        2292 2834
        2294 3826
        2294 2344
        2294 3695
        2295 2624
        2296 3532
        2297 3681
        2297 3647
        2298 4058
        2298 3977
        2299 2477
        2299 2559
        2300 3341
        2300 3258
        2301 2735
        2302 4067
        2303 3030
        2303 3345
        2306 3972
        2306 2872
        2306 3197
        2307 2808
        2307 2935
        2307 2330
        2308 2784
        2308 2883
        2309 2781
        2310 3198
        2310 2888
        2311 2509
        2312 3100
        2313 3595
        2313 3917
        2314 3464
        2314 3435
        2315 2966
        2315 3671
        2315 3390
        2318 2715
        2318 2979
        2318 2626
        2320 2447
        2321 3424
        2321 3011
        2322 2404
        2322 2484
        2322 2683
        2322 3827
        2323 3768
        2323 3469
        2324 3982
        2325 2435
        2325 2558
        2325 2489
        2327 3456
        2328 2584
        2328 3458
        2329 2367
        2329 2558
        2330 3343
        2331 4015
        2331 2431
        2331 2833
        2331 3191
        2332 2386
        2332 3827
        2333 3754
        2333 2456
        2334 2536
        2334 2744
        2334 2775
        2335 2871
        2336 3942
        2336 2825
        2336 3953
        2337 3262
        2337 3492
        2339 2803
        2339 2727
        2339 2699
        2339 3116
        2340 3487
        2342 3407
        2342 2665
        2345 2771
        2345 3975
        2347 4006
        2348 3702
        2348 3935
        2348 3881
        2349 2699
        2351 3284
        2351 2910
        2352 3247
        2352 3130
        2353 3339
        2354 3414
        2354 2867
        2354 2780
        2355 3183
        2355 3795
        2355 2666
        2355 2742
        2356 4015
        2356 3896
        2357 3323
        2357 3148
        2357 2880
        2357 2800
        2358 3515
        2359 3731
        2360 3476
        2360 3882
        2361 3226
        2361 3031
        2362 2966
        2363 3663
        2363 2539
        2364 3174
        2365 3483
        2365 3796
        2366 2938
        2366 3865
        2367 3291
        2368 3521
        2369 2475
        2370 3396
        2370 3730
        2370 3295
        2371 3050
        2371 3370
        2372 2726
        2372 3407
        2373 2967
        2374 3326
        2374 2708
        2375 3977
        2376 4052
        2377 3406
        2378 2898
        2379 3554
        2379 3058
        2380 2909
        2380 2806
        2381 3367
        2381 3921
        2381 3024
        2382 2728
        2382 2766
        2382 3588
        2384 3301
        2384 3090
        2384 3843
        2385 2526
        2386 2747
        2387 3405
        2388 2400
        2388 3256
        2389 3084
        2390 4086
        2390 2890
        2390 3761
        2391 2416
        2391 3072
        2391 3646
        2392 3182
        2392 2729
        2392 3802
        2393 3220
        2393 2817
        2394 3807
        2396 3290
        2396 3217
        2398 3090
        2398 3654
        2399 2874
        2399 2842
        2399 3500
        2400 2466
        2401 3639
        2401 4033
        2402 2867
        2403 2936
        2403 2755
        2405 3193
        2405 3087
        2405 3771
        2406 2790
        2407 3458
        2407 3356
        2407 3543
        2408 2411
        2408 3805
        2408 3482
        2409 2471
        2411 3053
        2411 2913
        2412 2970
        2412 2940
        2412 2696
        2413 3904
        2413 4083
        2413 3563
        2413 3463
        2414 2896
        2414 3137
        2415 2658
        2415 3454
        2415 2834
        2416 3153
        2416 2761
        2417 2844
        2417 2722
        2417 3976
        2418 2891
        2419 3907
        2420 4050
        2421 2600
        2422 4033
        2422 2600
        2423 3984
        2423 2982
        2424 3107
        2424 2966
        2424 3949
        2425 3988
        2426 3084
        2426 4056
        2428 2965
        2428 3110
        2428 3139
        2429 2958
        2429 3599
        2430 4091
        2430 3879
        2431 2855
        2432 3673
        2433 3310
        2433 4068
        2433 3868
        2434 3096
        2434 3173
        2435 2635
        2436 4071
        2437 3718
        2437 2543
        2437 3509
        2437 3587
        2438 3009
        2438 3238
        2439 4018
        2440 2895
        2440 3182
        2441 2577
        2441 4085
        2441 3830
        2442 2951
        2442 2993
        2442 3185
        2443 4023
        2443 2590
        2444 2929
        2444 2928
        2445 2798
        2446 2691
        2448 3483
        2448 2858
        2449 3477
        2449 2545
        2450 3454
        2450 3085
        2450 3883
        2451 2459
        2451 2649
        2451 3982
        2452 3825
        2452 3478
        2453 3555
        2454 3659
        2456 3148
        2457 3351
        2457 3378
        2458 3315
        2458 3357
        2458 3041
        2459 3909
        2460 3107
        2460 2762
        2460 3135
        2461 3891
        2462 3742
        2462 2997
        2462 3385
        2463 2529
        2463 2645
        2463 2624
        2464 3032
        2466 2770
        2466 3268
        2467 3572
        2467 2780
        2468 3132
        2469 3398
        2469 3268
        2469 3796
        2470 3610
        2471 2713
        2473 3473
        2474 2740
        2474 2910
        2475 3257
        2475 3929
        2476 2995
        2476 3472
        2477 3402
        2477 3306
        2478 2814
        2479 4029
        2479 3224
        2480 2723
        2481 3637
        2481 3648
        2482 3895
        2483 3564
        2483 2821
        2484 2778
        2485 3953
        2485 2760
        2485 2548
        2486 2822
        2486 3429
        2486 3552
        2486 3075
        2488 2694
        2490 3345
        2490 2562
        2491 4080
        2491 3898
        2492 2756
        2493 3696
        2493 3422
        2493 3834
        2494 2564
        2495 3190
        2496 3821
        2497 3319
        2497 3836
        2498 3890
        2498 2766
        2500 2900
        2501 3736
        2501 3818
        2502 3299
        2503 3801
        2503 2799
        2504 3689
        2506 2828
        2507 3334
        2507 2950
        2507 3642
        2508 3990
        2509 3783
        2509 2578
        2510 2723
        2510 3635
        2510 3859
        2511 4014
        2512 3985
        2516 3557
        2516 3694
        2516 2906
        2517 3601
        2518 3617
        2518 3470
        2519 3812
        2519 3169
        2519 3738
        2520 3913
        2520 3108
        2521 3207
        2521 3574
        2521 3134
        2522 3488
        2522 2602
        2523 3679
        2523 4052
        2524 2670
        2524 3391
        2525 3957
        2526 3888
        2526 3431
        2527 3946
        2527 3266
        2528 4013
        2528 3678
        2528 2835
        2529 3989
        2529 3560
        2530 3084
        2530 3639
        2531 3679
        2532 2926
        2532 3728
        2534 3998
        2535 2971
        2535 3689
        2536 3334
        2537 3284
        2538 3355
        2539 3746
        2540 3236
        2540 3113
        2541 2823
        2541 3537
        2542 3992
        2542 2660
        2542 3136
        2543 3505
        2544 2933
        2545 2889
        2546 3254
        2546 2927
        2546 2759
        2547 3256
        2547 3183
        2548 3942
        2549 2629
        2549 3758
        2549 2562
        2550 4093
        2550 3155
        2551 2629
        2551 2719
        2552 2591
        2552 2601
        2552 3561
        2552 2739
        2553 3916
        2554 3063
        2556 3036
        2556 3735
        2557 3334
        2557 2775
        2558 3309
        2559 3988
        2560 3835
        2560 3443
        2561 3382
        2561 3358
        2561 4008
        2561 3294
        2562 3911
        2563 3868
        2564 3319
        2565 2790
        2565 2989
        2565 4089
        2566 4074
        2567 3830
        2568 3667
        2568 2582
        2569 3472
        2569 3516
        2570 2696
        2573 2703
        2573 3160
        2574 2877
        2574 3344
        2575 3842
        2576 2667
        2576 3329
        2576 3068
        2576 4060
        2578 3786
        2579 2676
        2580 2640
        2581 2868
        2582 3097
        2583 3534
        2584 2663
        2584 3680
        2585 3788
        2585 2912
        2586 3482
        2586 2592
        2586 2674
        2587 2856
        2588 3241
        2589 4065
        2589 2685
        2591 3099
        2592 3116
        2593 3651
        2593 3574
        2593 3817
        2594 3339
        2595 3136
        2595 3687
        2595 3568
        2597 3559
        2597 3184
        2598 3479
        2599 3725
        2599 3554
        2600 3145
        2601 3557
        2602 3304
        2602 3006
        2605 2814
        2605 2879
        2606 3955
        2606 3700
        2607 3954
        2608 3380
        2609 3272
        2610 3909
        2611 3845
        2612 3905
        2612 2720
        2612 2849
        2613 3850
        2614 3451
        2615 2914
        2617 2805
        2618 2781
        2618 2694
        2619 4062
        2619 3150
        2620 3929
        2620 3056
        2621 3316
        2622 2657
        2622 3190
        2623 3029
        2623 3040
        2623 3300
        2624 3551
        2625 3459
        2625 3517
        2627 3688
        2628 3071
        2628 2806
        2631 2864
        2632 3156
        2632 3165
        2633 3217
        2633 3147
        2636 2687
        2637 3588
        2638 3885
        2638 3385
        2638 3297
        2639 2871
        2639 2670
        2640 3823
        2641 2686
        2642 3864
        2643 3891
        2644 3877
        2645 2792
        2645 3462
        2646 3872
        2647 3647
        2647 2831
        2647 3867
        2648 3541
        2650 3965
        2650 3978
        2651 3253
        2651 2820
        2652 3298
        2652 3639
        2652 3766
        2656 3056
        2656 3604
        2657 3087
        2658 3085
        2658 3336
        2659 2953
        2660 3970
        2661 3995
        2662 3689
        2663 3873
        2663 4005
        2664 3146
        2664 3369
        2665 3016
        2667 2998
        2668 3103
        2668 3421
        2669 3918
        2670 3903
        2670 3667
        2671 3372
        2672 3067
        2673 2935
        2673 3285
        2674 4053
        2675 3617
        2677 3544
        2677 2686
        2679 3741
        2679 3979
        2680 3064
        2682 3644
        2682 3300
        2682 3812
        2683 3161
        2683 2848
        2685 4002
        2685 2884
        2686 2812
        2686 3039
        2687 2851
        2688 3602
        2689 2875
        2689 3765
        2691 3487
        2692 2732
        2694 3115
        2694 3456
        2695 2891
        2695 3614
        2695 3927
        2697 3733
        2697 2848
        2697 3776
        2698 3575
        2699 4025
        2699 3938
        2700 3066
        2700 2914
        2701 3005
        2701 2758
        2702 3903
        2703 3448
        2703 3452
        2704 3656
        2704 2901
        2706 3764
        2707 3058
        2709 3327
        2710 2921
        2710 3776
        2711 3258
        2711 4047
        2712 2764
        2712 3139
        2714 3265
        2714 3734
        2715 3014
        2716 4026
        2716 3095
        2717 3270
        2719 3659
        2720 3355
        2721 3804
        2721 3968
        2721 3193
        2722 3422
        2722 3244
        2725 3180
        2725 4067
        2727 3192
        2727 3314
        2728 3872
        2729 2909
        2731 3461
        2731 3656
        2732 2973
        2733 3971
        2733 3741
        2733 3633
        2734 2824
        2734 3852
        2735 3443
        2735 3334
        2736 3283
        2736 3018
        2736 3791
        2737 3724
        2737 3046
        2737 3492
        2738 3400
        2738 3469
        2741 3064
        2741 4063
        2742 3732
        2742 3126
        2743 4080
        2743 2922
        2743 2939
        2744 2837
        2745 2802
        2745 3018
        2746 3785
        2746 3453
        2746 3562
        2747 3644
        2748 3079
        2749 2930
        2750 3422
        2753 3543
        2753 4079
        2755 3998
        2755 3959
        2756 3180
        2757 3476
        2760 3239
        2761 3390
        2761 3439
        2762 2796
        2763 3326
        2765 2847
        2767 2933
        2767 3043
        2767 3784
        2768 3750
        2768 3609
        2771 3484
        2771 3721
        2772 3520
        2773 3168
        2775 3856
        2776 3218
        2777 3686
        2778 3589
        2779 3838
        2780 2941
        2782 3384
        2782 2845
        2783 3784
        2784 3039
        2785 4010
        2787 3427
        2788 2866
        2788 4093
        2791 3439
        2791 3620
        2791 3593
        2792 3560
        2792 3948
        2792 3025
        2793 3654
        2793 3301
        2793 3017
        2794 3813
        2795 3289
        2795 3304
        2796 3170
        2796 3363
        2797 2912
        2798 3189
        2800 3495
        2801 3091
        2802 3148
        2802 3235
        2802 3283
        2803 3539
        2804 3865
        2804 3317
        2804 3584
        2805 2949
        2806 3162
        2807 3686
        2807 2884
        2808 2961
        2808 3285
        2808 3499
        2810 2901
        2810 2985
        2811 3888
        2811 4085
        2812 3167
        2812 2880
        2813 3481
        2815 3172
        2815 3335
        2816 4072
        2818 3173
        2818 4011
        2819 3829
        2819 3551
        2819 4002
        2820 2994
        2823 3828
        2825 3010
        2825 3811
        2826 3262
        2827 2832
        2828 3874
        2829 3454
        2830 3580
        2830 2908
        2830 3668
        2831 3188
        2831 3842
        2832 3455
        2832 3130
        2833 3619
        2833 3896
        2835 3213
        2836 3769
        2837 3613
        2838 3467
        2839 3989
        2839 3428
        2841 2869
        2843 3412
        2844 3493
        2845 4018
        2845 3982
        2845 3691
        2847 2935
        2847 2961
        2849 3223
        2850 3387
        2850 3573
        2851 3413
        2852 3159
        2852 3544
        2852 3108
        2852 3744
        2853 3202
        2854 2985
        2854 3916
        2854 3959
        2855 3718
        2855 3079
        2856 3035
        2858 3625
        2859 3050
        2859 3531
        2860 3846
        2860 3269
        2861 2885
        2863 3571
        2864 2988
        2865 3180
        2866 3934
        2869 3170
        2870 3826
        2871 2890
        2874 3061
        2877 3008
        2878 3873
        2881 3695
        2882 3433
        2885 3587
        2885 2904
        2886 3535
        2886 3021
        2887 2905
        2887 3307
        2887 3106
        2888 3158
        2889 3264
        2892 4048
        2892 3489
        2893 3874
        2893 3497
        2894 3404
        2895 3922
        2895 3479
        2895 3734
        2897 3225
        2899 3166
        2901 3998
        2902 3065
        2902 3231
        2903 3384
        2903 3760
        2904 3617
        2905 3649
        2905 3752
        2907 4070
        2907 3772
        2908 3626
        2908 3157
        2910 3751
        2911 3770
        2912 4084
        2912 3803
        2913 3281
        2914 3141
        2914 3615
        2915 3851
        2915 3037
        2916 3518
        2917 3769
        2919 2935
        2919 3440
        2920 3261
        2924 3059
        2924 3398
        2925 4091
        2926 3217
        2927 3084
        2927 3441
        2928 3388
        2929 3204
        2930 3606
        2930 3017
        2931 2956
        2931 3864
        2932 3747
        2934 3216
        2936 3752
        2937 2966
        2937 4030
        2938 4072
        2938 3237
        2939 3094
        2940 3352
        2941 4091
        2941 4004
        2942 3563
        2943 3872
        2943 3171
        2946 3643
        2946 3996
        2948 3598
        2948 3863
        2949 2973
        2950 3955
        2951 3427
        2952 3576
        2952 3158
        2953 3740
        2953 3393
        2954 3127
        2954 3485
        2955 3757
        2955 3572
        2956 3002
        2956 3039
        2957 3535
        2960 3280
        2961 3339
        2962 2978
        2962 3294
        2963 3915
        2964 3821
        2965 3967
        2965 3078
        2968 3547
        2968 3199
        2968 3660
        2969 3914
        2971 3833
        2971 3726
        2972 3567
        2972 3479
        2975 3477
        2976 3153
        2976 3640
        2977 3611
        2979 3790
        2979 3392
        2980 3320
        2980 3946
        2982 3954
        2982 3995
        2984 3763
        2984 3486
        2987 3600
        2987 3048
        2987 3809
        2988 3606
        2990 3342
        2990 3983
        2990 3583
        2991 3096
        2993 3654
        2994 3597
        2994 3505
        2996 3445
        2997 3226
        2997 3003
        2998 3236
        2999 3157
        3000 3349
        3000 4009
        3001 3322
        3002 3211
        3003 3042
        3003 3051
        3006 4058
        3006 3780
        3007 3662
        3009 3838
        3011 3744
        3012 3322
        3012 4073
        3013 3474
        3014 3222
        3015 3849
        3018 3127
        3020 3460
        3021 3518
        3022 3520
        3023 4088
        3024 3674
        3024 3124
        3024 3655
        3025 3930
        3026 4073
        3027 3525
        3027 3604
        3028 3112
        3028 3153
        3028 3072
        3030 3428
        3030 3363
        3031 3042
        3031 3265
        3032 3787
        3032 3859
        3033 3405
        3034 3853
        3035 3994
        3036 4016
        3037 4033
        3038 3499
        3038 3471
        3038 3221
        3039 4094
        3040 3807
        3041 3997
        3041 3264
        3044 3194
        3046 3553
        3047 3891
        3047 3652
        3048 3395
        3048 3158
        3049 3585
        3049 3616
        3052 3787
        3052 3071
        3053 3308
        3055 3421
        3056 3568
        3057 4004
        3060 3571
        3060 3540
        3061 3348
        3062 3643
        3064 3563
        3065 3179
        3067 3542
        3068 3742
        3069 3504
        3070 3246
        3074 3332
        3074 3353
        3076 3745
        3077 3735
        3079 3619
        3080 3286
        3082 3408
        3085 3915
        3087 3101
        3088 4016
        3090 3472
        3091 3196
        3092 3644
        3092 3272
        3093 4068
        3093 3140
        3094 3973
        3095 3251
        3095 3646
        3095 3150
        3096 3808
        3096 3271
        3097 4000
        3097 4048
        3098 3514
        3098 3953
        3100 3805
        3100 3191
        3101 3324
        3104 3970
        3105 3296
        3105 4013
        3109 3225
        3110 3338
        3112 3640
        3113 3869
        3114 4012
        3115 3569
        3116 3866
        3117 3844
        3118 3986
        3119 3190
        3119 3661
        3120 3381
        3120 3611
        3122 3696
        3123 3936
        3123 3601
        3124 3825
        3124 3424
        3125 4033
        3126 3397
        3126 3941
        3128 3522
        3128 4060
        3130 3177
        3131 4078
        3132 3425
        3133 3980
        3133 3801
        3134 3386
        3135 3250
        3135 4074
        3137 3958
        3137 3913
        3138 3875
        3142 3189
        3142 3614
        3143 4071
        3143 3245
        3144 3853
        3145 3171
        3146 4047
        3147 3383
        3148 3544
        3149 3418
        3151 3556
        3152 3884
        3154 3564
        3155 3457
        3156 3191
        3157 3181
        3162 4009
        3163 3963
        3163 3741
        3165 3987
        3165 3805
        3166 3567
        3167 3385
        3168 3476
        3172 3939
        3174 3314
        3175 3206
        3175 3609
        3175 3452
        3177 3793
        3178 3908
        3178 3751
        3179 3902
        3179 3779
        3180 3490
        3181 4004
        3181 3533
        3182 3265
        3183 3414
        3183 3542
        3185 3945
        3187 3425
        3188 3831
        3188 3347
        3188 3725
        3189 3672
        3192 3475
        3194 3528
        3195 3980
        3195 3797
        3197 3499
        3197 3200
        3198 3720
        3198 3581
        3201 4023
        3205 3212
        3206 3328
        3208 3734
        3209 3463
        3209 3817
        3210 3946
        3211 3214
        3212 3697
        3213 3806
        3215 3935
        3217 4095
        3218 3332
        3219 3274
        3220 3703
        3221 4039
        3221 3829
        3222 3638
        3224 3270
        3224 3981
        3227 3851
        3227 3354
        3229 3862
        3229 3963
        3231 3943
        3232 3656
        3233 3369
        3233 3765
        3234 3866
        3237 3584
        3238 3540
        3238 4055
        3239 3730
        3240 3764
        3241 3704
        3241 3925
        3242 3611
        3242 3861
        3242 3815
        3242 3368
        3243 3452
        3246 4047
        3247 4017
        3248 3797
        3248 3967
        3249 3379
        3249 3575
        3250 3375
        3252 3302
        3252 3942
        3253 3597
        3255 4054
        3258 3634
        3260 3418
        3261 3555
        3262 3553
        3263 4027
        3264 3330
        3266 3957
        3271 3350
        3272 3816
        3276 3531
        3278 3869
        3278 3490
        3279 3924
        3280 3957
        3281 3517
        3283 3495
        3283 4024
        3287 3870
        3288 3734
        3289 3618
        3289 3488
        3290 3561
        3290 3383
        3291 3990
        3292 4057
        3292 3454
        3293 3933
        3295 3653
        3296 3307
        3296 3361
        3303 3823
        3303 3465
        3303 3503
        3304 3906
        3309 3796
        3310 3889
        3312 4038
        3312 3623
        3312 3515
        3316 3918
        3316 3481
        3317 4065
        3317 3710
        3317 3777
        3318 3667
        3318 3621
        3319 3709
        3320 4005
        3326 3908
        3328 3610
        3330 3477
        3337 3352
        3337 3621
        3338 4070
        3339 3898
        3340 4029
        3342 3985
        3344 3725
        3350 3571
        3350 3775
        3353 4014
        3355 3883
        3357 3955
        3360 3409
        3360 3846
        3361 3678
        3361 4037
        3364 4055
        3364 3838
        3366 3937
        3366 3783
        3368 3648
        3369 3878
        3370 3893
        3376 4001
        3376 3585
        3378 3937
        3379 3569
        3380 4037
        3380 3876
        3381 3844
        3381 4078
        3383 3591
        3384 3909
        3386 3893
        3387 3515
        3388 4042
        3389 3600
        3389 3420
        3389 4012
        3390 3436
        3393 3588
        3394 3915
        3397 3854
        3398 3807
        3401 3622
        3402 3885
        3403 3666
        3405 4011
        3407 3510
        3407 3824
        3410 4049
        3411 4037
        3411 3657
        3415 4063
        3415 3531
        3416 3645
        3417 3491
        3419 3447
        3419 3883
        3420 3581
        3421 3905
        3423 3466
        3426 3544
        3429 3766
        3430 4009
        3430 3910
        3434 3993
        3437 4028
        3438 3822
        3439 3640
        3440 3612
        3445 3595
        3446 3894
        3450 3679
        3450 3545
        3450 3771
        3451 3755
        3453 3474
        3455 3793
        3456 3504
        3459 3630
        3462 3551
        3464 3854
        3465 3850
        3469 3974
        3469 3676
        3470 3569
        3474 3583
        3475 3572
        3476 4046
        3480 3506
        3480 4006
        3482 3866
        3485 3596
        3485 3723
        3487 4061
        3488 3960
        3489 3646
        3491 3526
        3491 3532
        3494 3596
        3496 4035
        3497 3923
        3498 3971
        3502 3752
        3503 3767
        3504 3840
        3505 4069
        3510 3798
        3510 3773
        3513 3886
        3515 3763
        3517 3739
        3519 3745
        3519 3709
        3520 3916
        3521 3554
        3523 3799
        3524 3636
        3526 3634
        3528 3746
        3529 3607
        3530 4012
        3530 3809
        3531 3882
        3532 3856
        3534 4074
        3535 3830
        3535 3928
        3536 3997
        3537 3690
        3538 4081
        3543 3680
        3547 3745
        3548 3778
        3548 3621
        3549 3690
        3551 3948
        3562 3703
        3562 3792
        3565 3699
        3566 3952
        3570 3877
        3570 3801
        3570 3818
        3573 3629
        3574 3697
        3577 4076
        3578 3863
        3583 4041
        3584 3685
        3585 3798
        3589 3827
        3591 3907
        3592 3713
        3594 3759
        3595 3986
        3597 3935
        3603 4084
        3603 4049
        3606 3945
        3606 3654
        3607 3702
        3609 3677
        3610 3753
        3613 3955
        3616 3671
        3617 3846
        3618 3792
        3622 3827
        3627 3759
        3630 3691
        3632 3924
        3634 4023
        3636 3865
        3637 4006
        3643 3961
        3645 4060
        3649 3657
        3649 3959
        3652 4085
        3659 3714
        3660 3908
        3661 3723
        3663 3953
        3663 3944
        3664 3928
        3668 3769
        3671 3814
        3673 3682
        3675 3807
        3677 3833
        3685 3710
        3688 3864
        3692 3738
        3693 3830
        3694 3880
        3695 4086
        3696 3976
        3698 3983
        3701 4070
        3703 3983
        3705 3895
        3707 3932
        3708 3963
        3711 3779
        3716 3788
        3718 4044
        3722 3759
        3727 3977
        3733 3887
        3743 3790
        3749 3975
        3751 3860
        3752 4037
        3753 3760
        3753 4082
        3755 3962
        3757 4029
        3757 3938
        3768 3888
        3771 3895
        3772 3931
        3774 4078
        3775 3901
        3777 3961
        3780 4054
        3780 3906
        3781 3800
        3783 3912
        3784 3901
        3797 3834
        3797 4034
        3803 4049
        3804 4007
        3806 3816
        3817 4083
        3819 3949
        3828 4038
        3829 3978
        3832 3836
        3837 3899
        3840 4031
        3841 4091
        3852 4043
        3853 3932
        3854 4027
        3867 4003
        3869 3894
        3869 4067
        3877 3925
        3878 4042
        3881 4044
        3882 4061
        3883 3905
        3889 3894
        3890 4079
        3898 3972
        3902 3956
        3911 3930
        3917 4009
        3919 4068
        3921 4028
        3933 4051
        3940 4050
        3947 4078
        3950 4087
        3957 4005
        3961 4016
        3964 4068
        3969 4075
        3974 4069
        3992 4053
        4044 4069
        4046 4061
        """


        self.cell = cellvectors(a=43.274,
                           b=43.274,
                           c=43.274)
