def AlgOptions(alphaLevelOptAlg, Alg, epsStop):
    if Alg == 'MMA':
        alphaLevelOptAlg.setOption('GEPS', epsStop)
        alphaLevelOptAlg.setOption('DABOBJ', epsStop)
        alphaLevelOptAlg.setOption('DELOBJ', epsStop)
        alphaLevelOptAlg.setOption('ITRM', 1)
        alphaLevelOptAlg.setOption('MAXIT', 30)
    elif Alg == 'GCMMA':
        alphaLevelOptAlg.setOption('GEPS', epsStop)
        alphaLevelOptAlg.setOption('DABOBJ', epsStop)
        alphaLevelOptAlg.setOption('DELOBJ', epsStop)
        alphaLevelOptAlg.setOption('ITRM', 1)
        alphaLevelOptAlg.setOption('MAXIT', 30)
        alphaLevelOptAlg.setOption('INNMAX', 5)
    elif Alg == 'SLSQP':
        alphaLevelOptAlg.setOption('ACC', epsStop)
        alphaLevelOptAlg.setOption('MAXIT', 50)
    elif Alg == 'NLPQLP':
        alphaLevelOptAlg.setOption('ACC', epsStop)
        alphaLevelOptAlg.setOption('ACCQP', epsStop)
        alphaLevelOptAlg.setOption('STPMIN', epsStop)
        alphaLevelOptAlg.setOption('MAXFUN', 5)
        alphaLevelOptAlg.setOption('MAXIT', 50)
        alphaLevelOptAlg.setOption('RHOB', 0.0)
        alphaLevelOptAlg.setOption('MODE', 0)
        alphaLevelOptAlg.setOption('LQL', True)
    elif Alg == 'PSQP':
        alphaLevelOptAlg.setOption('XMAX', 10.0)
        alphaLevelOptAlg.setOption('TOLX', epsStop)
        alphaLevelOptAlg.setOption('TOLC', epsStop)
        alphaLevelOptAlg.setOption('TOLG', epsStop)
        alphaLevelOptAlg.setOption('RPF', epsStop)
        alphaLevelOptAlg.setOption('MIT', 350)
        alphaLevelOptAlg.setOption('MFV', 1000)
        alphaLevelOptAlg.setOption('MET', 1)
        alphaLevelOptAlg.setOption('MEC', 2)
    elif Alg == 'COBYLA':
        alphaLevelOptAlg.setOption('RHOBEG', 0.25)
        alphaLevelOptAlg.setOption('RHOEND', epsStop)
        alphaLevelOptAlg.setOption('MAXFUN', 15000)
    elif Alg == 'CONMIN':
        alphaLevelOptAlg.setOption('ITMAX', 500)
        alphaLevelOptAlg.setOption('DELFUN', epsStop)
        alphaLevelOptAlg.setOption('DABFUN', epsStop)
        alphaLevelOptAlg.setOption('ITRM', 2)
        alphaLevelOptAlg.setOption('NFEASCT', 20)
    elif Alg == 'KSOPT':
        alphaLevelOptAlg.setOption('ITMAX', 30)
        alphaLevelOptAlg.setOption('RDFUN', epsStop)
        alphaLevelOptAlg.setOption('RHOMIN', 5.0)
        alphaLevelOptAlg.setOption('RHOMAX', 100.0)
    elif Alg == 'SOLVOPT':
        alphaLevelOptAlg.setOption('xtol', epsStop)
        alphaLevelOptAlg.setOption('ftol', epsStop)
        alphaLevelOptAlg.setOption('maxit', 30)
        alphaLevelOptAlg.setOption('gtol', epsStop)
        alphaLevelOptAlg.setOption('spcdil', 2.5)
    elif Alg == 'ALGENCAN':
        alphaLevelOptAlg.setOption('epsfeas', epsStop)
        alphaLevelOptAlg.setOption('epsopt', epsStop)
    elif Alg == 'NSGA2':
        alphaLevelOptAlg.setOption('PopSize', 100)
        alphaLevelOptAlg.setOption('maxGen', 10)
        alphaLevelOptAlg.setOption('pCross_real', 0.6)
        alphaLevelOptAlg.setOption('pMut_real', 0.2)
        alphaLevelOptAlg.setOption('eta_c', 10.0)
        alphaLevelOptAlg.setOption('eta_m', 20.0)
        alphaLevelOptAlg.setOption('pCross_bin', 0.0)
        alphaLevelOptAlg.setOption('pMut_bin', 0.0)
        alphaLevelOptAlg.setOption('seed', 0.0)
        alphaLevelOptAlg.setOption('PrintOut', 2)
    if Alg == 'ALPSO':
        alphaLevelOptAlg.setOption('SwarmSize', 20)
        alphaLevelOptAlg.setOption('maxOuterIter', 10)
        alphaLevelOptAlg.setOption('maxInnerIter', 5)
        alphaLevelOptAlg.setOption('minInnerIter', 1)
        alphaLevelOptAlg.setOption('dynInnerIter', 0)
        alphaLevelOptAlg.setOption('stopCriteria', 1)
        alphaLevelOptAlg.setOption('stopIters', 2)
        alphaLevelOptAlg.setOption('etol', epsStop)
        alphaLevelOptAlg.setOption('itol', epsStop)
        alphaLevelOptAlg.setOption('rtol', epsStop)
        alphaLevelOptAlg.setOption('atol', epsStop)
        alphaLevelOptAlg.setOption('dtol', epsStop)
        alphaLevelOptAlg.setOption('rinit', 1.0)
        alphaLevelOptAlg.setOption('xinit', 0)
        alphaLevelOptAlg.setOption('vinit', 1.0)
        alphaLevelOptAlg.setOption('vmax', 2.0)
        alphaLevelOptAlg.setOption('c1', 2.0)
        alphaLevelOptAlg.setOption('c2', 1.0)
        alphaLevelOptAlg.setOption('w1', 0.99)
        alphaLevelOptAlg.setOption('w2', 0.55)
        alphaLevelOptAlg.setOption('ns', 15)
        alphaLevelOptAlg.setOption('nf', 5)
        # alphaLevelOptAlg.setOption("dt", 1)
        alphaLevelOptAlg.setOption('vcrazy', 1e-4)
        alphaLevelOptAlg.setOption('HoodSize', 40)
        alphaLevelOptAlg.setOption('HoodModel', 'gbest')
        alphaLevelOptAlg.setOption('HoodSelf', 1)
        alphaLevelOptAlg.setOption('Scaling', 1)
    elif Alg == 'ALHSO':
        alphaLevelOptAlg.setOption('hms', 5)
        alphaLevelOptAlg.setOption('hmcr', 0.95)
        alphaLevelOptAlg.setOption('par', 0.65)
        alphaLevelOptAlg.setOption('dbw', 2000)
        alphaLevelOptAlg.setOption('maxoutiter', 200)
        alphaLevelOptAlg.setOption('maxinniter', 50)
        alphaLevelOptAlg.setOption('stopcriteria', 0)
        alphaLevelOptAlg.setOption('stopiters', 2)
        alphaLevelOptAlg.setOption('etol', epsStop)
        alphaLevelOptAlg.setOption('itol', epsStop)
        alphaLevelOptAlg.setOption('rtol', epsStop)
        alphaLevelOptAlg.setOption('atol', epsStop)
        alphaLevelOptAlg.setOption('prtoutiter', 0)
        alphaLevelOptAlg.setOption('prtinniter', 0)
        alphaLevelOptAlg.setOption('xinit', 0)
        alphaLevelOptAlg.setOption('rinit', 1.0)
        alphaLevelOptAlg.setOption('seed', 0.0)
        alphaLevelOptAlg.setOption('scaling', 1)
    elif Alg == 'MIDACO':
        alphaLevelOptAlg.setOption('ACC', epsStop)
        alphaLevelOptAlg.setOption('ISEED', 3)
        alphaLevelOptAlg.setOption('QSTART', 1)
        alphaLevelOptAlg.setOption('AUTOSTOP', 0)
        alphaLevelOptAlg.setOption('ORACLE', 0.0)
        alphaLevelOptAlg.setOption('ANTS', 0)
        alphaLevelOptAlg.setOption('KERNEL', 0)
        alphaLevelOptAlg.setOption('CHARACTER', 0)
        alphaLevelOptAlg.setOption('MAXEVAL', 10000)
        alphaLevelOptAlg.setOption('MAXTIME', 100000.0)
    return alphaLevelOptAlg
