{{autogenerated}}

## Notes about the transition between the legacy builder and buildx

Users are encouraged to use buildx in Python-on-whales through the
[`docker.build()`](buildx.md#build) function.

Buildx is the next gen Docker builder and a transition is underway to make
the `docker build` shell command use buildx. Python-on-whales has had an opinionated
answer on the matter as `docker.build()` will always use buildx. This is because Python-on-whales was created 
during the transition and doesn't have an existing user codebase to support.

The legacy builder is still available by calling [`docker.legacy_build()`](image.md#legacy_build), but note that

* It won't work if you use Docker 22.06 or above 
* It won't work if you used `docker.buildx.install()` or `docker buildx install` previously 
* It won't work if you had set the environment variable `DOCKER_BUILDKIT` to `1`

Some resources on the matter:

* [Discussion about supporting the legacy builder in Python-on-whales](https://github.com/gabrieldemarmiesse/python-on-whales/issues/345)
* [Proposal: make BuildKit the default builder on Linux](https://github.com/moby/moby/issues/40379)
* [Deprecated Engine Features: Legacy builder for Linux images](https://github.com/docker/cli/blob/master/docs/deprecated.md#legacy-builder-for-linux-images)
