# coding: utf-8

"""
    EVR API

    OpenAPI Generator'i jaoks kohandatud EVR API kirjeldus. Kasuta seda juhul, kui spetsifikatsioonile vastava EVR API kirjeldusega ei õnnestu klienti genereerida.  # noqa: E501

    The version of the OpenAPI document: 1.8.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from pyevr.openapi_client.configuration import Configuration


class Shipment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'holding_base': 'HoldingBase',
        'source': 'Source',
        'items': 'list[ShipmentItem]',
        'certificate_claims': 'list[CertificateClaim]',
        'user_custom_data': 'object',
        'supply_contract_number': 'str'
    }

    attribute_map = {
        'holding_base': 'holdingBase',
        'source': 'source',
        'items': 'items',
        'certificate_claims': 'certificateClaims',
        'user_custom_data': 'userCustomData',
        'supply_contract_number': 'supplyContractNumber'
    }

    def __init__(self, holding_base=None, source=None, items=None, certificate_claims=None, user_custom_data=None, supply_contract_number=None, local_vars_configuration=None):  # noqa: E501
        """Shipment - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._holding_base = None
        self._source = None
        self._items = None
        self._certificate_claims = None
        self._user_custom_data = None
        self._supply_contract_number = None
        self.discriminator = None

        self.holding_base = holding_base
        self.source = source
        self.items = items
        self.certificate_claims = certificate_claims
        if user_custom_data is not None:
            self.user_custom_data = user_custom_data
        self.supply_contract_number = supply_contract_number

    @property
    def holding_base(self):
        """Gets the holding_base of this Shipment.  # noqa: E501


        :return: The holding_base of this Shipment.  # noqa: E501
        :rtype: HoldingBase
        """
        return self._holding_base

    @holding_base.setter
    def holding_base(self, holding_base):
        """Sets the holding_base of this Shipment.


        :param holding_base: The holding_base of this Shipment.  # noqa: E501
        :type: HoldingBase
        """
        if self.local_vars_configuration.client_side_validation and holding_base is None:  # noqa: E501
            raise ValueError("Invalid value for `holding_base`, must not be `None`")  # noqa: E501

        self._holding_base = holding_base

    @property
    def source(self):
        """Gets the source of this Shipment.  # noqa: E501


        :return: The source of this Shipment.  # noqa: E501
        :rtype: Source
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this Shipment.


        :param source: The source of this Shipment.  # noqa: E501
        :type: Source
        """
        if self.local_vars_configuration.client_side_validation and source is None:  # noqa: E501
            raise ValueError("Invalid value for `source`, must not be `None`")  # noqa: E501

        self._source = source

    @property
    def items(self):
        """Gets the items of this Shipment.  # noqa: E501

        Saadetis  # noqa: E501

        :return: The items of this Shipment.  # noqa: E501
        :rtype: list[ShipmentItem]
        """
        return self._items

    @items.setter
    def items(self, items):
        """Sets the items of this Shipment.

        Saadetis  # noqa: E501

        :param items: The items of this Shipment.  # noqa: E501
        :type: list[ShipmentItem]
        """
        if self.local_vars_configuration.client_side_validation and items is None:  # noqa: E501
            raise ValueError("Invalid value for `items`, must not be `None`")  # noqa: E501

        self._items = items

    @property
    def certificate_claims(self):
        """Gets the certificate_claims of this Shipment.  # noqa: E501

        Tarneahela sertifikaadi väited  # noqa: E501

        :return: The certificate_claims of this Shipment.  # noqa: E501
        :rtype: list[CertificateClaim]
        """
        return self._certificate_claims

    @certificate_claims.setter
    def certificate_claims(self, certificate_claims):
        """Sets the certificate_claims of this Shipment.

        Tarneahela sertifikaadi väited  # noqa: E501

        :param certificate_claims: The certificate_claims of this Shipment.  # noqa: E501
        :type: list[CertificateClaim]
        """

        self._certificate_claims = certificate_claims

    @property
    def user_custom_data(self):
        """Gets the user_custom_data of this Shipment.  # noqa: E501

        Api kasutaja poolt kohandatavad andmed  # noqa: E501

        :return: The user_custom_data of this Shipment.  # noqa: E501
        :rtype: object
        """
        return self._user_custom_data

    @user_custom_data.setter
    def user_custom_data(self, user_custom_data):
        """Sets the user_custom_data of this Shipment.

        Api kasutaja poolt kohandatavad andmed  # noqa: E501

        :param user_custom_data: The user_custom_data of this Shipment.  # noqa: E501
        :type: object
        """

        self._user_custom_data = user_custom_data

    @property
    def supply_contract_number(self):
        """Gets the supply_contract_number of this Shipment.  # noqa: E501

        Tarnelepingu number  # noqa: E501

        :return: The supply_contract_number of this Shipment.  # noqa: E501
        :rtype: str
        """
        return self._supply_contract_number

    @supply_contract_number.setter
    def supply_contract_number(self, supply_contract_number):
        """Sets the supply_contract_number of this Shipment.

        Tarnelepingu number  # noqa: E501

        :param supply_contract_number: The supply_contract_number of this Shipment.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                supply_contract_number is not None and len(supply_contract_number) > 50):
            raise ValueError("Invalid value for `supply_contract_number`, length must be less than or equal to `50`")  # noqa: E501

        self._supply_contract_number = supply_contract_number

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Shipment):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Shipment):
            return True

        return self.to_dict() != other.to_dict()
