from . import *
from testinlabel.request import Request
import os
import json


class TLA():
    def __init__(self, accessKey, host="", debug=False, savePath=""):
        if host == "":
            self.host = "http://label-export.testin.cn/"
        else:
            if "http://" in host or "https://" in host:
                self.host = host.rstrip("/") + "/"
            else:
                self.host = "http://" + host.strip("/") + "/"
        self.__debug = debug
        self.AK = accessKey
        # self.SK = secretKey
        self.savePath = savePath
        # self.req = Request(host=self.host, AK=self.AK, SK=self.SK, debug=self.__debug)
        self.req = None
        self.data = None
        self.taskList = None
        self.taskKey = None
        self.jsonDir = None
        self.jsonPath = None
        self.readmePath = None

    def SetKey(self, taskKey):
        '''
        Set the dataset to be processed
        :param datasetId: the id of the dataset
        :return:
        '''
        self.taskKey = taskKey
        self.req = Request(host=self.host, AK=self.AK, task_key=self.taskKey, debug=self.__debug)

        if self.__debug:
            print(f"[SET_TASK_KEY] set task key:{taskKey}")

        self.jsonDir = os.path.join(self.savePath, "testinlabel-data", self.taskKey)
        if not os.path.exists(self.jsonDir):
            os.makedirs(self.jsonDir)

        self.jsonPath = os.path.join(self.jsonDir, taskKey + ".json")
        self.readmePath = os.path.join(self.jsonDir, "readme.txt")

        if os.path.exists(self.jsonPath):
            with open(self.jsonPath, "r", encoding="utf-8") as jf:
                self.data = json.load(jf)
                self.taskList = self.data["data"]["task_list"]

    def GetLabelData(self, hasUnable=False, status=[STATUS_PASS], overlay=False):
        """
        get labeled data by task_key, more about task_key, see: http://label.testin.cn/v/pm-task-list
        :param taskKey:
        :param hasUnable:
        :param status:
        :param save:
        :return:
        """
        if self.data is not None and not overlay:
            if self.__debug:
                print(
                    f"[GET_LABEL_DATA] label data already download to locah path: {self.jsonPath}, abort this request！if you need re-download anyway, you should set overlay to Ture"
                )
            self.taskList = self.data["data"]["task_list"]
            return self.data
        if self.req is None:
            print('请设置任务key')
            return None
        self.data = self.req.getTaskData(key=self.taskKey, hasUnable=hasUnable, status=status)

        with open(self.jsonPath, "w", encoding="utf-8") as f:
            json.dump(self.data, f)
            if self.__debug:
                print(f"[SAVE_LABEL_DATA] save data to:{self.jsonPath}")

        with open(self.readmePath, "w", encoding="utf-8") as rdm:
            rdmContent = """注意：
    当前目录为 testinlabel SDK 自动生成的目录，同级目录的json文件为数据缓存文件，在导出数据之后您可以按需删除。
    更多信息：http://ai.testin.cn/
    登入系统：https://label.testin.cn/
    
Notice:
     The current directory is automatically generated by the testinlabel SDK, the json file in the same level is cache data, you can delete it as your need after exporting the data. :)
     more about: http://ai.testin.cn/
     login: https://label.testin.cn/
            """
            rdm.write(rdmContent)

        self.taskList = self.data["data"]["task_list"]
        return self.data
