"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthType = exports.HttpMethod = void 0;
/** Http Methods that API Gateway supports */
var HttpMethod;
(function (HttpMethod) {
    /** Retreive data from a server at the specified resource */
    HttpMethod["GET"] = "GET";
    /** Send data to the API endpoint to create or udpate a resource */
    HttpMethod["POST"] = "POST";
    /** Send data to the API endpoint to update or create a resource */
    HttpMethod["PUT"] = "PUT";
    /** Delete the resource at the specified endpoint */
    HttpMethod["DELETE"] = "DELETE";
    /** Apply partial modifications to the resource */
    HttpMethod["PATCH"] = "PATCH";
    /** Retreive data from a server at the specified resource without the response body */
    HttpMethod["HEAD"] = "HEAD";
    /** Return data describing what other methods and operations the server supports */
    HttpMethod["OPTIONS"] = "OPTIONS";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
/**
 * The authentication method used to call the endpoint
 */
var AuthType;
(function (AuthType) {
    /** Call the API direclty with no authorization method */
    AuthType["NO_AUTH"] = "NO_AUTH";
    /** Use the IAM role associated with the current state machine for authorization */
    AuthType["IAM_ROLE"] = "IAM_ROLE";
    /** Use the resource policy of the API for authorization */
    AuthType["RESOURCE_POLICY"] = "RESOURCE_POLICY";
})(AuthType = exports.AuthType || (exports.AuthType = {}));
//# sourceMappingURL=data:application/json;base64,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