from setuptools import setup

try:
    import pypandoc
    long_description = pypandoc.convert_file('README.md', 'rst')
except(IOError, ImportError):
    long_description = open('README.md').read()

setup(
    name='pg_batch',
    version='1.1.1',
    description='Run large PostgreSQL UPDATE and DELETE queries with small batches to prevent locks',
    long_description=long_description,
    author='Gabriel Bordeaux',
    author_email='pypi@gab.lc',
    url='https://github.com/gabfl/pg-batch',
    license='MIT',
    packages=['pg_batch'],
    package_dir={'pg_batch': 'src'},
    install_requires=[  # external dependencies
        'psycopg2-binary==2.9.*'
    ],
    entry_points={
        'console_scripts': [
            'pg_batch = pg_batch.pg_batch:main',
        ],
    },
    classifiers=[  # see https://pypi.python.org/pypi?%3Aaction=list_classifiers
        'Topic :: Software Development',
        'Topic :: Database',
        'Topic :: Database :: Database Engines/Servers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: MacOS',
        'Operating System :: POSIX :: Linux',
        'Natural Language :: English',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python',
        #  'Development Status :: 4 - Beta',
        'Development Status :: 5 - Production/Stable',
    ],
)
